/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.google.gson.Gson;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AvalesWorker
extends Worker {
    private SharedPreferences sesion;
    private final ConnectivityManager connectivityManager;
    private final boolean isWorkEnqueued = false;
    public static final int BATCH_SIZE_AVALES = 999999;
    public static int currentPageAvales = 0;
    public static boolean allDataLoadedAvales = false;
    public static boolean isTaskAvalesCompleted = false;
    private static final Object dbLock = new Object();

    @RequiresApi(api=24)
    public AvalesWorker(Context context, WorkerParameters workerParams) {
        super(context, workerParams);
        this.sesion = context.getSharedPreferences("sesion", 0);
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    @RequiresApi(api=24)
    @NonNull
    public ListenableWorker.Result doWork() {
        SQLiteDatabase db = null;
        DatabaseHelper dbHelper = null;
        try {
            if (!this.isNetworkAvailable(this.getApplicationContext())) {
                Log.d((String)"AvalesWorker", (String)"No internet connection, retrying later.");
                return ListenableWorker.Result.failure();
            }
            dbHelper = new DatabaseHelper(this.getApplicationContext());
            db = dbHelper.getWritableDatabase();
            Context context = this.getApplicationContext();
            if (context == null) {
                Log.e((String)"AvalesWorker", (String)"El contexto es nulo. Abortando ejecuci\u00f3n.");
                return ListenableWorker.Result.failure();
            }
            if (db == null) {
                Log.e((String)"AvalesWorker", (String)"La base de datos es nula. Abortando ejecuci\u00f3n.");
                return ListenableWorker.Result.failure();
            }
            if (db == null || !db.isOpen()) {
                Log.e((String)"AvalesWorker", (String)"Fallo al abrir la base de datos.");
                return ListenableWorker.Result.failure();
            }
            Log.d((String)"AvalesWorker", (String)"Base de datos abierta correctamente desde worker AVALES.");
            if (!allDataLoadedAvales) {
                this.loadAllData(db);
            } else {
                this.checkForUpdates(this.getApplicationContext(), db);
            }
            this.reprogramarWorker();
            return ListenableWorker.Result.success();
        }
        catch (Exception e) {
            Log.e((String)"AvalesWorker", (String)"Error in doWork", (Throwable)e);
            return ListenableWorker.Result.failure();
        }
    }

    private void reprogramarWorker() {
        WorkManager.getInstance((Context)this.getApplicationContext()).enqueueUniqueWork("AvalesWorker", ExistingWorkPolicy.REPLACE, (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AvalesWorker.class).setInitialDelay(12L, TimeUnit.MINUTES)).build());
        Log.d((String)"AvalesWorker", (String)"Worker AvalesWorker reprogramado para ejecutarse en 2 minuto.");
    }

    public static void enqueueWork(Context context) {
        if (context == null) {
            Log.e((String)"AvalesWorker", (String)"No se puede iniciar WorkManager con un contexto nulo.");
            return;
        }
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest oneTimeWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AvalesWorker.class).setConstraints(constraints)).build();
        WorkManager.getInstance((Context)context.getApplicationContext()).enqueueUniqueWork("AvalesWorker", ExistingWorkPolicy.REPLACE, oneTimeWorkRequest);
        Log.d((String)"AvalesWorker", (String)"Se ha encolado un OneTimeWorkRequest para AvalesWorker.");
    }

    @RequiresApi(api=24)
    private void loadAllData(SQLiteDatabase db) {
        Context context = this.getApplicationContext();
        if (context == null) {
            Log.e((String)"AVALES", (String)"El contexto es nulo. No se puede cargar la data.");
            return;
        }
        this.sesion = context.getSharedPreferences("sesion", 0);
        JSONObject data = new JSONObject();
        try {
            data.put("page", currentPageAvales);
            data.put("size", 999999);
            data.put("func", (Object)"indexApp_lotes");
            Log.d((String)"Avales", (String)("Parametros enviados WORKER AVALES indexApp_lotes: " + data));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, response -> {
            try {
                JSONArray data1 = response.getJSONArray("data");
                Log.d((String)"AVALES", (String)("Cantidad de datos recibidos: " + data1.length()));
                ArrayList<Aval> batchAvales = new ArrayList<Aval>();
                for (int i = 0; i < data1.length(); ++i) {
                    JSONObject obj = data1.getJSONObject(i);
                    Gson gson = new Gson();
                    Aval aval = (Aval)gson.fromJson(obj.toString(), Aval.class);
                    batchAvales.add(aval);
                }
                this.insertAvalesIntoSQLiteAllData(context, batchAvales, db);
                if (batchAvales.size() < 999999) {
                    allDataLoadedAvales = true;
                } else {
                    ++currentPageAvales;
                }
            }
            catch (JSONException e) {
                Log.e((String)"AVALES", (String)("Error al procesar la respuesta JSON: " + e.getMessage()));
            }
        }, error -> {
            Log.e((String)"AVALES", (String)("Error de red: " + error.toString()));
            if (error.networkResponse != null && error.networkResponse.data != null) {
                String responseBody = new String(error.networkResponse.data);
                Log.e((String)"AVALES", (String)("Respuesta de error del servidor: " + responseBody));
            }
            this.handleNetworkError(context);
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void handleNetworkError(Context context) {
        if (this.isNetworkAvailable(context)) {
            Log.d((String)"AvalesWorker", (String)"Network available, resuming work.");
            AvalesWorker.enqueueWork(context);
        } else {
            Log.d((String)"AvalesWorker", (String)"No network available, stopping work.");
            this.cancelAndRescheduleWork(context);
        }
    }

    private void cancelAndRescheduleWork(Context context) {
        WorkManager.getInstance((Context)context).cancelAllWorkByTag("AvalesWorker");
        this.scheduleRetry(context);
    }

    private void scheduleRetry(Context context) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest retryWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AvalesWorker.class).setConstraints(constraints)).setInitialDelay(12L, TimeUnit.MINUTES)).build();
        WorkManager.getInstance((Context)context).enqueue((WorkRequest)retryWorkRequest);
        Log.d((String)"AvalesWorker", (String)"Reprogramado trabajo debido a error.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAvalesIntoSQLiteAllData(Context context, List<Aval> avales, SQLiteDatabase db) {
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        db.beginTransaction();
        try {
            for (Aval aval : avales) {
                Cursor cursor = db.query("avales", new String[]{"id"}, "id = ?", new String[]{aval.getId()}, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    cursor.close();
                    continue;
                }
                ContentValues values = new ContentValues();
                values.put("id", aval.getId());
                values.put("nombre_completo", aval.getNombre_completo());
                values.put("direccion", aval.getDireccion());
                values.put("telefono", aval.getTelefono());
                values.put("garantias", aval.getGarantias());
                values.put("carpeta_comprobantes", aval.getCarpeta_comprobantes());
                values.put("carpeta_garantias", aval.getCarpeta_garantias());
                values.put("otras_referencias", aval.getOtras_referencias());
                values.put("created_at", aval.getCreated_at());
                values.put("updated_at", aval.getUpdated_at());
                values.put("update_comprobantes", aval.getUpdate_comprobantes_Enaval());
                values.put("update_garantias", aval.getUpdate_garantias_Enaval());
                values.put("ruta_id", aval.getRuta_id() != null ? aval.getRuta_id() : "NULL");
                values.put("poblacion_id", aval.getPoblacion_id() != null ? aval.getPoblacion_id() : "NULL");
                values.put("colocadora_id", aval.getColocadora_id() != null ? aval.getColocadora_id() : "NULL");
                long newRowId = db.insert("avales", null, values);
                if (newRowId != -1L) continue;
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error durante la inserci\u00f3n en lote: " + e.getMessage()));
        }
        finally {
            if (db != null && db.isOpen()) {
                Log.e((String)"AvalesWorker", (String)"Cerrando la conexi\u00f3n a la base de datos insertAvalesIntoSQLiteAllData...");
                db.endTransaction();
                db.close();
                isTaskAvalesCompleted = true;
            }
        }
    }

    private void checkForUpdates(Context context, SQLiteDatabase db) {
        Log.d((String)"AvalesWorker", (String)"Checking for updates Avales...");
        Handler mainHandler = new Handler(Looper.getMainLooper());
        Gson gson = new Gson();
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        List<Aval> localAvales = dbHelper.getLast30AvalesFromSQLite();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"indexApp_Upd");
            data.put("ruta_id", (Object)this.sesion.getString("rutas", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        if (context != null) {
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, response -> {
                try {
                    JSONArray data1 = response.getJSONArray("data");
                    ArrayList<Aval> newAvales = new ArrayList<Aval>();
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Aval serverData = (Aval)gson.fromJson(obj.toString(), Aval.class);
                        newAvales.add(serverData);
                    }
                    this.updateAvalInSQLite(context, newAvales, localAvales, db);
                }
                catch (JSONException e) {
                    Log.e((String)"AVALES", (String)("Error al procesar la respuesta JSON: " + e.getMessage()));
                }
            }, error -> mainHandler.post(() -> {
                if (context != null) {
                    Log.e((String)"AvalesWorker", (String)("Error occurred: " + error.getMessage()), (Throwable)error);
                } else {
                    Log.e((String)"AvalesWorker", (String)"Context is null, cannot handle network error.");
                }
            }));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
        } else {
            Log.d((String)"AvalesWorker", (String)"No context available, skipping network requests.");
        }
    }

    private void updateAvalInSQLite(Context context, List<Aval> serverAvales, List<Aval> localAvales, SQLiteDatabase db) {
        if (!db.isOpen()) {
            Log.d((String)"AvalesWorker", (String)"Base de datos cerrada, reabriendo...");
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        HashSet<String> localAvalIds = new HashSet<String>();
        for (Aval localAval : localAvales) {
            localAvalIds.add(localAval.getId());
        }
        Log.d((String)"AvalesWorker", (String)"Iniciando actualizaci\u00f3n de avales...");
        AtomicInteger remainingComparisons = new AtomicInteger(serverAvales.size());
        for (Aval serverAval : serverAvales) {
            Log.d((String)"AvalesWorker", (String)("Procesando aval ID: " + serverAval.getId()));
            if (localAvalIds.contains(serverAval.getId())) {
                Log.d((String)"AvalesWorker", (String)"El aval ya existe en la base de datos local. Verificando actualizaci\u00f3n...");
                Aval localAval = null;
                for (Aval aval : localAvales) {
                    if (!aval.getId().equals(serverAval.getId())) continue;
                    localAval = aval;
                    break;
                }
                if (localAval != null) {
                    String localUpdatedAt = localAval.getUpdated_at();
                    if (localUpdatedAt == null || localUpdatedAt.isEmpty()) {
                        Log.d((String)"AvalesWorker", (String)"El campo 'updated_at' es nulo o vac\u00edo. Asignando nueva hora...");
                        if (Build.VERSION.SDK_INT >= 26) {
                            LocalDateTime now = LocalDateTime.now();
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                            localUpdatedAt = now.format(formatter);
                        } else {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                            localUpdatedAt = sdf.format(new Date());
                        }
                        ContentValues values = new ContentValues();
                        values.put("updated_at", localUpdatedAt);
                        int rowsUpdated = db.update("avales", values, "id = ?", new String[]{localAval.getId()});
                        if (rowsUpdated > 0) {
                            Log.d((String)"SQLite", (String)("Se actualiz\u00f3 'updated_at' para el Aval ID: " + localAval.getId()));
                        } else {
                            Log.e((String)"SQLite", (String)("Error al actualizar 'updated_at' para el Aval ID: " + localAval.getId()));
                        }
                    }
                    if (localUpdatedAt.isEmpty() || this.isNewer(serverAval.getUpdated_at(), localUpdatedAt)) {
                        Log.d((String)"AvalesWorker", (String)"El aval en el servidor es m\u00e1s nuevo. Actualizando en SQLite...");
                        Log.d((String)"AvalesWorker", (String)("Direccion a actualizar: " + serverAval.getDireccion()));
                        this.updateValuesInDatabase(db, serverAval, remainingComparisons);
                    } else if (this.isNewer(localUpdatedAt, serverAval.getUpdated_at())) {
                        Log.d((String)"AvalesWorker", (String)"El aval local es m\u00e1s nuevo. Enviando datos al servidor...");
                        this.enviarDatosLocalAlServidor(context, localAval, db, remainingComparisons);
                    } else {
                        Log.d((String)"AvalesWorker", (String)"Los avales son iguales. No se requiere actualizaci\u00f3n.");
                        remainingComparisons.decrementAndGet();
                    }
                }
            } else {
                Log.d((String)"AvalesWorker", (String)"El aval no existe en la base de datos local. Insertando...");
                this.insertAvalesIntoSQLite(context, Collections.singletonList(serverAval), db, remainingComparisons);
            }
            if (remainingComparisons.get() != 0) continue;
            Log.d((String)"AvalesWorker", (String)"Todas las comparaciones finalizadas. Cerrando base de datos.");
            db.close();
            isTaskAvalesCompleted = true;
        }
    }

    private void enviarDatosLocalAlServidor(Context context, Aval avalLocal, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        remainingComparisons.decrementAndGet();
        Handler mainHandler = new Handler(Looper.getMainLooper());
        if (context == null) {
            Log.e((String)"AvalesWorker", (String)"Context is null. Cannot send data to server.");
            return;
        }
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"updateFromLocal");
            data.put("id", (Object)avalLocal.getId());
            data.put("nombre", (Object)avalLocal.getNombre_completo());
            data.put("direccion", (Object)avalLocal.getDireccion());
            data.put("telefono", (Object)avalLocal.getTelefono());
            data.put("otras_referencias", (Object)avalLocal.getOtras_referencias());
            data.put("garantias", (Object)avalLocal.getGarantias());
            data.put("updated_at", (Object)avalLocal.getUpdated_at());
            data.put("ruta_id", (Object)avalLocal.getRuta_id());
            data.put("poblacion_id", (Object)avalLocal.getPoblacion_id());
            data.put("colocadora_id", (Object)avalLocal.getColocadora_id());
            Log.d((String)"Avales", (String)("Parametros enviados al servidor para actualizar AVALES: " + data.toString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, response -> {}, error -> mainHandler.post(() -> {
            String errorMessage = error.getMessage();
            Log.e((String)"AvalesWorker", (String)("Error occurred al enviar datos locales AVALES: " + errorMessage), (Throwable)error);
            if (error.networkResponse != null) {
                Log.e((String)"AvalesWorker", (String)("C\u00f3digo de estado: " + error.networkResponse.statusCode));
            }
        }));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void insertAvalesIntoSQLite(Context context, List<Aval> avales, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        Log.e((String)"SQLite", (String)"Entrando a la funci\u00f3n insertAvalesIntoSQLite()............................");
        try {
            for (Aval aval : avales) {
                ContentValues values = new ContentValues();
                values.put("id", aval.getId());
                values.put("nombre_completo", aval.getNombre_completo());
                values.put("direccion", aval.getDireccion());
                values.put("telefono", aval.getTelefono());
                values.put("garantias", aval.getGarantias());
                values.put("carpeta_comprobantes", aval.getCarpeta_comprobantes());
                values.put("carpeta_garantias", aval.getCarpeta_garantias());
                values.put("otras_referencias", aval.getOtras_referencias());
                values.put("created_at", aval.getCreated_at());
                values.put("updated_at", aval.getUpdated_at());
                values.put("update_comprobantes", aval.getUpdate_comprobantes_Enaval());
                values.put("update_garantias", aval.getUpdate_garantias_Enaval());
                values.put("ruta_id", aval.getRuta_id() != null ? aval.getRuta_id() : "NULL");
                values.put("poblacion_id", aval.getPoblacion_id() != null ? aval.getPoblacion_id() : "NULL");
                values.put("colocadora_id", aval.getColocadora_id() != null ? aval.getColocadora_id() : "NULL");
                long newRowId = db.insertWithOnConflict("avales", null, values, 5);
                if (newRowId == -1L) {
                    remainingComparisons.decrementAndGet();
                    Log.e((String)"SQLite", (String)("Error al insertar el aval con ID: " + aval.getId()));
                    continue;
                }
                remainingComparisons.decrementAndGet();
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error durante la inserci\u00f3n en lote: " + e.getMessage()));
        }
    }

    private void updateValuesInDatabase(SQLiteDatabase db, Aval aval, AtomicInteger remainingComparisons) {
        ContentValues values = new ContentValues();
        values.put("nombre_completo", aval.getNombre_completo());
        values.put("direccion", aval.getDireccion());
        values.put("telefono", aval.getTelefono());
        values.put("garantias", aval.getGarantias());
        values.put("carpeta_comprobantes", aval.getCarpeta_comprobantes());
        values.put("carpeta_garantias", aval.getCarpeta_garantias());
        values.put("otras_referencias", aval.getOtras_referencias());
        values.put("created_at", aval.getCreated_at());
        values.put("updated_at", aval.getUpdated_at());
        values.put("update_comprobantes", aval.getUpdate_comprobantes_Enaval());
        values.put("update_garantias", aval.getUpdate_garantias_Enaval());
        values.put("ruta_id", aval.getRuta_id() != null ? aval.getRuta_id() : "NULL");
        values.put("poblacion_id", aval.getPoblacion_id() != null ? aval.getPoblacion_id() : "NULL");
        values.put("colocadora_id", aval.getColocadora_id() != null ? aval.getColocadora_id() : "NULL");
        int rowsUpdated = db.update("avales", values, "id=?", new String[]{String.valueOf(aval.getId())});
        if (rowsUpdated > 0) {
            remainingComparisons.decrementAndGet();
            Log.d((String)"SQLite", (String)("Registro actualizado correctamente: ID = " + aval.getId()));
        } else {
            remainingComparisons.decrementAndGet();
            Log.e((String)"SQLite", (String)"Error al actualizar el registro. ID no encontrado o fallo en la base de datos.");
        }
    }

    private boolean isNewer(String serverDate, String localDate) {
        if (serverDate == null || localDate == null || serverDate.isEmpty() || localDate.isEmpty()) {
            Log.e((String)"isNewer", (String)("Una de las fechas es nula o vac\u00eda: serverDate=" + serverDate + ", localDate=" + localDate));
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        try {
            Date server = sdf.parse(serverDate);
            Date local = sdf.parse(localDate);
            return server != null && local != null && server.after(local);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo activeNetworkInfo = this.connectivityManager.getActiveNetworkInfo();
            return activeNetworkInfo != null && activeNetworkInfo.isConnected();
        }
        catch (Exception e) {
            Log.e((String)"AvalesWorker", (String)"Error checking network availability", (Throwable)e);
            return false;
        }
    }

    public static void cancelWork(Context context) {
        WorkManager.getInstance((Context)context).cancelUniqueWork("AvalesWorker");
        Log.d((String)"AVALES", (String)"Worker cancelado");
    }
}

