/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientesWorker
extends Worker {
    private SharedPreferences sesion;
    private final ConnectivityManager connectivityManager;
    private final boolean isWorkEnqueued = false;
    public static final int BATCH_SIZE_CLIENTES = 999999;
    private static final int MAX_RETRIES = 3;
    private int retryCount = 0;
    public static int currentPageClientes = 0;
    public static boolean allDataLoadedClientes = false;
    public static boolean isTaskClientesCompleted = false;
    public static final String CLIENTES_WORKER_TAG = "ClientesWorker";

    @RequiresApi(api=24)
    public ClientesWorker(Context context, WorkerParameters workerParams) {
        super(context, workerParams);
        this.sesion = context.getSharedPreferences("sesion", 0);
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    @NonNull
    public ListenableWorker.Result doWork() {
        SQLiteDatabase db = null;
        try {
            if (!this.isNetworkAvailable(this.getApplicationContext())) {
                Log.d((String)CLIENTES_WORKER_TAG, (String)"No internet connection, retrying later.");
                ListenableWorker.Result result = this.retryOrFailure();
                return result;
            }
            if (!this.isWithinAllowedTime()) {
                Log.d((String)CLIENTES_WORKER_TAG, (String)"Current time is outside allowed range, retrying later.");
                ListenableWorker.Result result = this.retryOrFailure();
                return result;
            }
            DatabaseHelper dbHelper = new DatabaseHelper(this.getApplicationContext());
            db = dbHelper.getWritableDatabase();
            if (db == null || !db.isOpen()) {
                Log.e((String)CLIENTES_WORKER_TAG, (String)"Fallo al abrir la base de datos Clientes.");
                ListenableWorker.Result result = ListenableWorker.Result.failure();
                return result;
            }
            if (!allDataLoadedClientes) {
                this.loadAllData(db);
                Log.d((String)CLIENTES_WORKER_TAG, (String)"ENTRO EN CARGAR TODOS LOS DATOS........................");
            } else {
                this.checkForUpdates(this.getApplicationContext(), db);
                Log.d((String)CLIENTES_WORKER_TAG, (String)"ENTRO EN ACTUALIZAR TODOS LOS DATOS.......................");
            }
            this.reprogramarWorker();
            ListenableWorker.Result result = ListenableWorker.Result.success();
            return result;
        }
        catch (Exception e) {
            Log.e((String)CLIENTES_WORKER_TAG, (String)"Error in doWork", (Throwable)e);
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            return result;
        }
        finally {
            if (isTaskClientesCompleted && db != null && db.isOpen()) {
                Log.d((String)CLIENTES_WORKER_TAG, (String)"Base de datos cerrada desde worker CLIENTES.");
                db.close();
            }
        }
    }

    private void reprogramarWorker() {
        WorkManager.getInstance((Context)this.getApplicationContext()).enqueueUniqueWork(CLIENTES_WORKER_TAG, ExistingWorkPolicy.REPLACE, (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ClientesWorker.class).setInitialDelay(14L, TimeUnit.MINUTES)).build());
        Log.d((String)CLIENTES_WORKER_TAG, (String)"Worker ClientesWorker reprogramado para ejecutarse en 5 minuto.");
    }

    private ListenableWorker.Result retryOrFailure() {
        if (this.retryCount < 3) {
            ++this.retryCount;
            return ListenableWorker.Result.retry();
        }
        return ListenableWorker.Result.failure();
    }

    private boolean isWithinAllowedTime() {
        Calendar calendar = Calendar.getInstance();
        int hourOfDay = calendar.get(11);
        return hourOfDay >= 7 && hourOfDay <= 22;
    }

    @RequiresApi(api=24)
    private void loadAllData(SQLiteDatabase db) {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        Context context = this.getApplicationContext();
        this.sesion = context.getSharedPreferences("sesion", 0);
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"indexApp");
            data.put("ruta_id", (Object)this.sesion.getString("rutas", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        Log.d((String)"Clientes", (String)("Parametros enviados WORKER CLIENTES indexApp: " + data));
        Log.d((String)"1", (String)"loadAllData: ");
        Log.d((String)"asdasdasd", (String)data.toString());
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, response -> {
            Log.d((String)"alkslkdas", (String)String.valueOf(response));
            try {
                JSONArray data1 = response.getJSONArray("data");
                ArrayList<Cliente> batchClientes = new ArrayList<Cliente>();
                for (int i = 0; i < data1.length(); ++i) {
                    JSONObject obj = data1.getJSONObject(i);
                    try {
                        Cliente cliente = (Cliente)new Gson().fromJson(obj.toString(), Cliente.class);
                        batchClientes.add(cliente);
                        continue;
                    }
                    catch (JsonSyntaxException e) {
                        Log.e((String)"ERROR_JSON", (String)("Error de sintaxis JSON en el registro " + i + ": " + obj.toString()), (Throwable)e);
                        continue;
                    }
                    catch (JsonParseException e) {
                        Log.e((String)"ERROR_JSON", (String)("Error al analizar el JSON en el registro " + i + ": " + obj.toString()), (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        Log.e((String)"ERROR_JSON", (String)("Error inesperado en el registro " + i + ": " + obj.toString()), (Throwable)e);
                    }
                }
                this.insertClientesIntoSQLiteAllDatos(context, batchClientes, db);
                if (batchClientes.size() < 999999) {
                    allDataLoadedClientes = true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }, error -> mainHandler.post(() -> this.handleNetworkError(context, error, "loadAllData")));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertClientesIntoSQLiteAllDatos(Context context, List<Cliente> clientes, SQLiteDatabase db) {
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        Log.d((String)"SQLite", (String)"Insertando clientes en lote...");
        db.beginTransaction();
        try {
            for (Cliente cliente : clientes) {
                ContentValues values = new ContentValues();
                values.put("id", cliente.getId());
                values.put("nombre_completo", cliente.getNombre_completo() != null ? cliente.getNombre_completo() : "");
                values.put("direccion", cliente.getDireccion() != null ? cliente.getDireccion() : "");
                values.put("telefono", cliente.getTelefono() != null ? cliente.getTelefono() : "");
                values.put("garantias", cliente.getGarantias() != null ? cliente.getGarantias() : "");
                values.put("carpeta_comprobantes", cliente.getCarpeta_comprobantes() != null ? cliente.getCarpeta_comprobantes() : "");
                values.put("carpeta_garantias", cliente.getCarpeta_garantias() != null ? cliente.getCarpeta_garantias() : "");
                values.put("otras_referencias", cliente.getOtras_referencias() != null ? cliente.getOtras_referencias() : "");
                values.put("ruta_id", cliente.getRuta_id() != null ? cliente.getRuta_id() : "NULLOO");
                values.put("poblacion_id", cliente.getPoblacion_id() != null ? cliente.getPoblacion_id() : "NULLOO");
                values.put("colocadora_id", cliente.getColocadora_id() != null ? cliente.getColocadora_id() : "NULLOO");
                values.put("created_at", cliente.getCreated_at() != null ? cliente.getCreated_at() : "");
                values.put("updated_at", cliente.getUpdated_at() != null ? cliente.getUpdated_at() : "");
                values.put("update_comprobantes", cliente.getUpdate_comprobantes_cliente() != null ? cliente.getUpdate_comprobantes_cliente() : "");
                values.put("update_garantias", cliente.getUpdate_garantias_cliente() != null ? cliente.getUpdate_garantias_cliente() : "");
                values.put("prestanombre", cliente.getPrestanombre() != null ? cliente.getPrestanombre() : "");
                values.put("aval_id", cliente.getAval_id() != null ? cliente.getAval_id() : "");
                db.insert("clientes", null, values);
            }
            db.setTransactionSuccessful();
            Log.d((String)"SQLite", (String)"Todos los clientes insertados correctamente.");
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error al insertar clientes en lote: " + e.getMessage()), (Throwable)e);
        }
        finally {
            db.endTransaction();
            isTaskClientesCompleted = true;
        }
    }

    private void handleNetworkError(Context context, VolleyError error, String from) {
        String errorMessage = error.getMessage();
        Log.e((String)CLIENTES_WORKER_TAG, (String)("Error occurred in " + from + ": " + errorMessage), (Throwable)error);
        if (error.networkResponse != null) {
            Log.e((String)CLIENTES_WORKER_TAG, (String)("C\u00f3digo de estado: " + error.networkResponse.statusCode));
            try {
                String responseBody = new String(error.networkResponse.data, "UTF-8");
                Log.e((String)CLIENTES_WORKER_TAG, (String)("Response body: " + responseBody));
            }
            catch (Exception e) {
                Log.e((String)CLIENTES_WORKER_TAG, (String)"Error reading response body", (Throwable)e);
            }
        }
    }

    private void checkForUpdates(Context context, SQLiteDatabase db) {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        Gson gson = new Gson();
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        List<Cliente> localClientes = dbHelper.getLast30ClientesFromSQLite();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"indexApp_Upd");
            data.put("ruta_id", (Object)this.sesion.getString("rutas", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        if (context != null) {
            Log.d((String)"2", (String)"loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, response -> {
                try {
                    JSONArray data1 = response.getJSONArray("data");
                    ArrayList<Cliente> newClientes = new ArrayList<Cliente>();
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Cliente serverData = (Cliente)gson.fromJson(obj.toString(), Cliente.class);
                        newClientes.add(serverData);
                    }
                    this.updateClienteInSQLite(context, newClientes, localClientes, db);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> mainHandler.post(() -> {
                if (context != null) {
                    Log.e((String)CLIENTES_WORKER_TAG, (String)("Error occurred: " + error.getMessage()), (Throwable)error);
                } else {
                    Log.e((String)CLIENTES_WORKER_TAG, (String)"Context is null, cannot handle network error.");
                }
            }));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
        }
    }

    private void insertClientesIntoSQLite(Context context, List<Cliente> clientes, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        Log.d((String)"SQLite", (String)"Insertando clientes en lote...");
        try {
            for (Cliente cliente : clientes) {
                ContentValues values = new ContentValues();
                values.put("id", cliente.getId());
                values.put("nombre_completo", cliente.getNombre_completo() != null ? cliente.getNombre_completo() : "");
                values.put("direccion", cliente.getDireccion() != null ? cliente.getDireccion() : "");
                values.put("telefono", cliente.getTelefono() != null ? cliente.getTelefono() : "");
                values.put("garantias", cliente.getGarantias() != null ? cliente.getGarantias() : "");
                values.put("carpeta_comprobantes", cliente.getCarpeta_comprobantes() != null ? cliente.getCarpeta_comprobantes() : "");
                values.put("carpeta_garantias", cliente.getCarpeta_garantias() != null ? cliente.getCarpeta_garantias() : "");
                values.put("otras_referencias", cliente.getOtras_referencias() != null ? cliente.getOtras_referencias() : "");
                values.put("ruta_id", cliente.getRuta_id() != null ? cliente.getRuta_id() : "NULLOO");
                values.put("poblacion_id", cliente.getPoblacion_id() != null ? cliente.getPoblacion_id() : "NULLOO");
                values.put("colocadora_id", cliente.getColocadora_id() != null ? cliente.getColocadora_id() : "NULLOO");
                values.put("created_at", cliente.getCreated_at() != null ? cliente.getCreated_at() : "");
                values.put("updated_at", cliente.getUpdated_at() != null ? cliente.getUpdated_at() : "");
                values.put("update_comprobantes", cliente.getUpdate_comprobantes_cliente() != null ? cliente.getUpdate_comprobantes_cliente() : "");
                values.put("update_garantias", cliente.getUpdate_garantias_cliente() != null ? cliente.getUpdate_garantias_cliente() : "");
                values.put("prestanombre", cliente.getPrestanombre() != null ? cliente.getPrestanombre() : "");
                values.put("aval_id", cliente.getAval_id() != null ? cliente.getAval_id() : "");
                long rowId = db.insertWithOnConflict("clientes", null, values, 5);
                if (rowId != -1L) {
                    remainingComparisons.decrementAndGet();
                    continue;
                }
                remainingComparisons.decrementAndGet();
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error al insertar clientes en lote: " + e.getMessage()), (Throwable)e);
        }
    }

    private void updateClienteInSQLite(Context context, List<Cliente> serverData, List<Cliente> localClientes, SQLiteDatabase db) {
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        HashSet<String> localClienteIds = new HashSet<String>();
        for (Cliente localCliente : localClientes) {
            localClienteIds.add(localCliente.getId());
        }
        AtomicInteger remainingComparisons = new AtomicInteger(serverData.size());
        for (Cliente serverCliente : serverData) {
            if (localClienteIds.contains(serverCliente.getId())) {
                Cliente localCliente = null;
                for (Cliente cliente : localClientes) {
                    if (!cliente.getId().equals(serverCliente.getId())) continue;
                    localCliente = cliente;
                    break;
                }
                if (localCliente == null) continue;
                String localUpdatedAt = localCliente.getUpdated_at();
                if (localUpdatedAt == null || localUpdatedAt.isEmpty()) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        LocalDateTime now = LocalDateTime.now();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                        localUpdatedAt = now.format(formatter);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                        localUpdatedAt = sdf.format(new Date());
                    }
                    ContentValues values = new ContentValues();
                    values.put("updated_at", localUpdatedAt);
                    int rowsUpdated = db.update("clientes", values, "id = ?", new String[]{localCliente.getId()});
                    if (rowsUpdated > 0) {
                        Log.d((String)"SQLite", (String)("Updated 'updated_at' for Clientes ID: " + localCliente.getId()));
                    } else {
                        Log.e((String)"SQLite", (String)("Failed to update 'updated_at' for Clientes ID: " + localCliente.getId()));
                    }
                }
                if (localUpdatedAt == null || localUpdatedAt.isEmpty() || this.isNewer(serverCliente.getUpdated_at(), localUpdatedAt)) {
                    this.updateValuesInDatabase(db, serverCliente, remainingComparisons);
                    continue;
                }
                if (this.isNewer(localUpdatedAt, serverCliente.getUpdated_at())) {
                    this.enviarDatosLocalAlServidor(context, localCliente, db, remainingComparisons);
                    continue;
                }
                remainingComparisons.decrementAndGet();
                continue;
            }
            this.insertClientesIntoSQLite(context, Collections.singletonList(serverCliente), db, remainingComparisons);
        }
        if (remainingComparisons.get() == 0) {
            isTaskClientesCompleted = true;
        }
    }

    private void enviarDatosLocalAlServidor(Context context, Cliente clienteLocal, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        remainingComparisons.decrementAndGet();
        if (context == null) {
            Log.e((String)CLIENTES_WORKER_TAG, (String)"Context is null. Cannot send data to server.");
            remainingComparisons.decrementAndGet();
            return;
        }
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"updateFromLocal");
            data.put("id", (Object)clienteLocal.getId());
            data.put("nombre", (Object)clienteLocal.getNombre_completo());
            data.put("direccion", (Object)clienteLocal.getDireccion());
            data.put("telefono", (Object)clienteLocal.getTelefono());
            data.put("garantias", (Object)clienteLocal.getGarantias());
            data.put("otras_referencias", (Object)clienteLocal.getOtras_referencias());
            data.put("ruta_id", (Object)clienteLocal.getRuta_cliente());
            data.put("poblacion_id", (Object)clienteLocal.getPoblacion_cliente());
            data.put("colocadora_id", (Object)clienteLocal.getColocadora_id());
            data.put("created_at", (Object)clienteLocal.getCreated_at());
            data.put("updated_at", (Object)clienteLocal.getUpdated_at());
            data.put("prestanombre", (Object)clienteLocal.getPrestanombre());
            data.put("aval_id", (Object)clienteLocal.getAval_id());
        }
        catch (JSONException e) {
            Log.e((String)CLIENTES_WORKER_TAG, (String)"Error creating JSON for enviarDatosLocalAlServidor", (Throwable)e);
            remainingComparisons.decrementAndGet();
            return;
        }
        Log.d((String)"LocalAlServidor", (String)("ClientesWorker enviarDatosLocalAlServidor Datos enviados: " + data.toString()));
        Log.d((String)"3", (String)"loadAllData: ");
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, response -> Log.d((String)CLIENTES_WORKER_TAG, (String)("Datos locales enviados y respuesta recibida: " + response.toString())), error -> Log.e((String)CLIENTES_WORKER_TAG, (String)"Error al enviar datos al servidor", (Throwable)error));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void updateValuesInDatabase(SQLiteDatabase db, Cliente cliente, AtomicInteger remainingComparisons) {
        ContentValues values = new ContentValues();
        values.put("nombre_completo", cliente.getNombre_completo());
        values.put("direccion", cliente.getDireccion());
        values.put("telefono", cliente.getTelefono());
        values.put("garantias", cliente.getGarantias());
        values.put("carpeta_comprobantes", cliente.getCarpeta_comprobantes());
        values.put("carpeta_garantias", cliente.getCarpeta_garantias());
        values.put("otras_referencias", cliente.getOtras_referencias());
        values.put("ruta_id", cliente.getRuta_id() != null ? cliente.getRuta_id() : "0");
        values.put("poblacion_id", cliente.getPoblacion_id() != null ? cliente.getPoblacion_id() : "0");
        values.put("colocadora_id", cliente.getColocadora_id() != null ? cliente.getColocadora_id() : "0");
        values.put("created_at", cliente.getCreated_at());
        values.put("updated_at", cliente.getUpdated_at());
        values.put("update_comprobantes", cliente.getUpdate_comprobantes_cliente());
        values.put("update_garantias", cliente.getUpdate_garantias_cliente());
        values.put("aval_id", cliente.getAval_id());
        values.put("prestanombre", cliente.getPrestanombre() != null ? cliente.getPrestanombre() : "0");
        int rowsUpdated = db.update("clientes", values, "id=?", new String[]{String.valueOf(cliente.getId())});
        if (rowsUpdated > 0) {
            Log.d((String)"SQLite", (String)("Registro actualizado correctamente Cliente: ID = " + cliente.getId()));
            remainingComparisons.decrementAndGet();
        } else {
            Log.e((String)"SQLite", (String)"Error al actualizar el registro. ID no encontrado o fallo en la base de datos.");
            remainingComparisons.decrementAndGet();
        }
    }

    private boolean isNewer(String serverDate, String localDate) {
        if (serverDate == null || localDate == null || serverDate.isEmpty() || localDate.isEmpty()) {
            Log.e((String)"isNewer", (String)("Una de las fechas es nula o vac\u00eda: serverDate=" + serverDate + ", localDate=" + localDate));
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        try {
            Date server = sdf.parse(serverDate);
            Date local = sdf.parse(localDate);
            return server != null && local != null && server.after(local);
        }
        catch (ParseException e) {
            Log.e((String)"isNewer", (String)"Error parsing dates", (Throwable)e);
            return false;
        }
    }

    private boolean isNetworkAvailable(Context context) {
        if (this.connectivityManager == null) {
            return false;
        }
        Network network = null;
        if (Build.VERSION.SDK_INT >= 23) {
            network = this.connectivityManager.getActiveNetwork();
        }
        if (network == null) {
            return false;
        }
        NetworkCapabilities networkCapabilities = this.connectivityManager.getNetworkCapabilities(network);
        return networkCapabilities != null && (networkCapabilities.hasTransport(1) || networkCapabilities.hasTransport(0) || networkCapabilities.hasTransport(3));
    }

    public static void enqueueWork(Context context) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest oneTimeWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ClientesWorker.class).setConstraints(constraints)).addTag(CLIENTES_WORKER_TAG)).build();
        WorkManager.getInstance((Context)context.getApplicationContext()).enqueueUniqueWork(CLIENTES_WORKER_TAG, ExistingWorkPolicy.REPLACE, oneTimeWorkRequest);
    }
}

