/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.app.Activity;
import android.app.Dialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.customview.widget.Openable;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.DialogFragment;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;
import androidx.work.WorkManager;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.ClientesWorker;
import com.example.sefinsa_app.LoginActivity;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.PagosWorker;
import com.example.sefinsa_app.PrestamosWorker;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PagoController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.PrestamoController;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.databinding.ActivityDashboardBinding;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.rmd.RMDFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChangeListener;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.navigation.NavigationView;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DashboardActivity
extends AppCompatActivity
implements NetworkChangeReceiver.NetworkChangeListener {
    private AppBarConfiguration mAppBarConfiguration;
    private ActivityDashboardBinding binding;
    private SharedPreferences sesion;
    private String usuario;
    private String nombre;
    private String telefono;
    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private AvalController avalController;
    private PrestamoController prestamoController;
    private PagoController pagoController;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private int retryCount = 0;
    private static final int MAX_RETRIES = 80;
    private NavController navController;
    private TextView navHeaderNombreUsuario;
    private TextView navHeaderNombreCompleto;
    NetworkChangeListener networkChangeListener = new NetworkChangeListener();
    Context context;
    private NetworkChangeReceiver networkChangeReceiver;
    private boolean isConnected = true;

    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;
    }

    private void initControllers() {
        this.rutaController = new RutaController((Context)this);
        this.poblacionController = new PoblacionController((Context)this);
        this.colocadoraController = new ColocadoraController((Context)this);
        this.clienteController = new ClienteController((Context)this);
        this.avalController = new AvalController((Context)this);
        this.prestamoController = new PrestamoController((Context)this);
        this.pagoController = new PagoController((Context)this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Locale.setDefault(Locale.US);
        this.networkChangeReceiver = new NetworkChangeReceiver(this);
        Locale.setDefault(Locale.US);
        this.initControllers();
        Handler handler = new Handler();
        this.sesion = this.getSharedPreferences("sesion", 0);
        this.usuario = this.sesion.getString("usuario", "");
        this.nombre = this.sesion.getString("nombre", "");
        this.telefono = this.sesion.getString("telefono", "");
        new MaterialAlertDialogBuilder((Context)this).setTitle((CharSequence)"\u00bfDesea conectarse a la impresora?").setCancelable(false).setPositiveButton((CharSequence)"S\u00ed", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                BluetoothUtils.context = DashboardActivity.this.getApplicationContext();
                BluetoothUtils.listPairedDevices(DashboardActivity.this.sesion.getString("impresora", "SP-T12 Printer"));
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
                filter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
                filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
                DashboardActivity.this.registerReceiver(BluetoothUtils.BTReceiver, filter);
                BluetoothUtils.broadcastReceiver();
                BluetoothUtils.initThread();
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
        this.binding = ActivityDashboardBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.setSupportActionBar(this.binding.appBarDashboard.toolbar);
        final DrawerLayout drawer = this.binding.drawerLayout;
        NavigationView navigationView = this.binding.navView;
        View headerView = navigationView.getHeaderView(0);
        this.navHeaderNombreUsuario = (TextView)headerView.findViewById(2131296842);
        this.navHeaderNombreCompleto = (TextView)headerView.findViewById(2131296841);
        this.navHeaderNombreUsuario.setText((CharSequence)(this.usuario + " (" + this.sesion.getString("nombre_perfil", "") + ")"));
        this.navHeaderNombreCompleto.setText((CharSequence)this.nombre);
        this.navController = Navigation.findNavController((Activity)this, (int)2131296862);
        if (this.sesion.getString("nombre_perfil", "").equals("Administrador") || this.sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {
            this.mAppBarConfiguration = new AppBarConfiguration.Builder(new int[]{2131296843, 2131296849, 2131296866, 2131296859, 2131296868, 2131296870, 2131296871, 2131296869, 2131296858, 2131296872}).setOpenableLayout((Openable)drawer).build();
            NavigationUI.setupActionBarWithNavController((AppCompatActivity)this, (NavController)this.navController, (AppBarConfiguration)this.mAppBarConfiguration);
            NavigationUI.setupWithNavController((NavigationView)navigationView, (NavController)this.navController);
        } else if (this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR") || this.sesion.getString("nombre_perfil", "").equals("JURIDICO")) {
            Menu nav_Menu = navigationView.getMenu();
            nav_Menu.findItem(2131296868).setVisible(false);
            nav_Menu.findItem(2131296870).setVisible(false);
            nav_Menu.findItem(2131296869).setVisible(false);
            if (this.sesion.getString("nombre_perfil", "").equals("JURIDICO")) {
                nav_Menu.findItem(2131296849).setVisible(false);
                nav_Menu.findItem(2131296843).setVisible(false);
            }
            this.mAppBarConfiguration = new AppBarConfiguration.Builder(new int[]{2131296843, 2131296849, 2131296866, 2131296859, 2131296868, 2131296870, 2131296871, 2131296869, 2131296858, 2131296872}).setOpenableLayout((Openable)drawer).build();
            NavigationUI.setupActionBarWithNavController((AppCompatActivity)this, (NavController)this.navController, (AppBarConfiguration)this.mAppBarConfiguration);
            NavigationUI.setupWithNavController((NavigationView)navigationView, (NavController)this.navController);
            this.navController.navigate(2131296866);
        } else if (this.sesion.getString("nombre_perfil", "").equals("VOCERO")) {
            Menu nav_Menu = navigationView.getMenu();
            nav_Menu.findItem(2131296868).setVisible(false);
            nav_Menu.findItem(2131296870).setVisible(false);
            nav_Menu.findItem(2131296869).setVisible(false);
            this.mAppBarConfiguration = new AppBarConfiguration.Builder(new int[]{2131296843, 2131296859, 2131296849, 2131296866, 2131296871, 2131296858, 2131296872}).setOpenableLayout((Openable)drawer).build();
            NavigationUI.setupActionBarWithNavController((AppCompatActivity)this, (NavController)this.navController, (AppBarConfiguration)this.mAppBarConfiguration);
            NavigationUI.setupWithNavController((NavigationView)navigationView, (NavController)this.navController);
        }
        this.sincronizarRutas();
        this.sincronizarPoblaciones();
        this.sincronizarColocadoras();
        navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                switch (item.getItemId()) {
                    case 2131296843: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296843);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296849: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296849);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296866: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296866);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296859: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296859);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296868: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296868);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296871: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296871);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296870: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296870);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296869: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296869);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296858: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296858);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296872: {
                        Navigation.findNavController((Activity)DashboardActivity.this, (int)2131296862).navigate(2131296872);
                        drawer.closeDrawer(0x800003);
                        break;
                    }
                    case 2131296863: {
                        drawer.closeDrawer(0x800003);
                        CharSequence[] opcionesImp = new String[]{"Conectar", "Cambiar nombre"};
                        final int[] opcionElegidaImp = new int[]{-1};
                        new MaterialAlertDialogBuilder((Context)DashboardActivity.this).setTitle((CharSequence)"Impresora").setSingleChoiceItems(opcionesImp, -1, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                opcionElegidaImp[0] = i;
                            }
                        }).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                if (opcionElegidaImp[0] == 1) {
                                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)DashboardActivity.this);
                                    builder.setTitle((CharSequence)"Nombre de impresora");
                                    final EditText input = new EditText((Context)DashboardActivity.this);
                                    input.setInputType(1);
                                    String impresora = DashboardActivity.this.sesion.getString("impresora", "SP-T12 Printer");
                                    input.setText((CharSequence)impresora);
                                    builder.setView((View)input);
                                    builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            new MaterialAlertDialogBuilder((Context)DashboardActivity.this).setTitle((CharSequence)"AVISO").setCancelable(false).setMessage((CharSequence)"Se cerrara la aplicaci\u00f3n para aplicar los cambios de la impresora").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                                                public void onClick(DialogInterface dialogInterface, int i) {
                                                    SharedPreferences.Editor editor = DashboardActivity.this.sesion.edit();
                                                    editor.putString("impresora", input.getText().toString());
                                                    editor.commit();
                                                    DashboardActivity.this.moveTaskToBack(true);
                                                    Process.killProcess((int)Process.myPid());
                                                    System.exit(1);
                                                }
                                            }).setNegativeButton((CharSequence)"CANCELAR", new DialogInterface.OnClickListener(){

                                                public void onClick(DialogInterface dialogInterface, int i) {
                                                }
                                            }).show();
                                        }
                                    });
                                    builder.setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.cancel();
                                        }
                                    });
                                    builder.show();
                                } else if (opcionElegidaImp[0] == 0) {
                                    BluetoothUtils.context = DashboardActivity.this.getApplicationContext();
                                    BluetoothUtils.listPairedDevices(DashboardActivity.this.sesion.getString("impresora", "SP-T12 Printer"));
                                    IntentFilter filter = new IntentFilter();
                                    filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
                                    filter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
                                    filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
                                    DashboardActivity.this.registerReceiver(BluetoothUtils.BTReceiver, filter);
                                    BluetoothUtils.broadcastReceiver();
                                    BluetoothUtils.initThread();
                                }
                            }
                        }).show();
                        break;
                    }
                    case 2131296873: {
                        CharSequence[] opciones = new String[]{"Clientes y avales", "Pr\u00e9stamos y Pagos", "Rutas", "Poblaciones", "Colocadoras", "Reporte Diario", "Reporte creditos", "Folios", "RMD"};
                        final int[] opcionElegida = new int[]{-1};
                        new MaterialAlertDialogBuilder((Context)DashboardActivity.this).setTitle((CharSequence)"Sincronizar").setSingleChoiceItems(opciones, -1, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                opcionElegida[0] = i;
                            }
                        }).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                if (opcionElegida[0] == 0) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando clientes y avales", (int)1).show();
                                    DashboardActivity.this.sincronizarClientesAvales();
                                } else if (opcionElegida[0] == 1) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando pr\u00e9stamos", (int)1).show();
                                    DashboardActivity.this.sincronizarPrestamosPagos();
                                } else if (opcionElegida[0] == 2) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando rutas", (int)1).show();
                                    DashboardActivity.this.sincronizarRutas();
                                } else if (opcionElegida[0] == 3) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando poblaciones", (int)1).show();
                                    DashboardActivity.this.sincronizarPoblaciones();
                                } else if (opcionElegida[0] == 4) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando colocadoras", (int)1).show();
                                    DashboardActivity.this.sincronizarColocadoras();
                                } else if (opcionElegida[0] == 5) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando Reporte diario", (int)1).show();
                                    DashboardActivity.this.sincronizarReporteDiario();
                                } else if (opcionElegida[0] == 6) {
                                    Toast.makeText((Context)DashboardActivity.this, (CharSequence)"Sincronizando Reporte creditos", (int)1).show();
                                    DashboardActivity.this.sincronizarReporteCreditos();
                                } else if (opcionElegida[0] == 7) {
                                    DashboardActivity.this.syncFolios();
                                } else if (opcionElegida[0] == 8) {
                                    DashboardActivity.this.dbSync();
                                }
                            }
                        }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                        break;
                    }
                    case 2131296848: {
                        new MaterialAlertDialogBuilder((Context)DashboardActivity.this).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"\u00bfDesea cerrar sesi\u00f3n?").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                WorkManager workManager = WorkManager.getInstance((Context)DashboardActivity.this);
                                workManager.cancelUniqueWork("UpdateLastExecutionTimeClientesWorker");
                                workManager.cancelUniqueWork("ClientesWorker");
                                workManager.cancelUniqueWork("ImmediatePrestamosWorker");
                                workManager.cancelUniqueWork("PrestamosWorker");
                                workManager.cancelUniqueWork("ImmediateAvalesWorker");
                                workManager.cancelUniqueWork("AvalesWorker");
                                workManager.cancelUniqueWork("UpdateLastExecutionTimePagosWorker");
                                workManager.cancelUniqueWork("PagosWorker");
                                BluetoothUtils.closeThread();
                                Intent intent = new Intent((Context)DashboardActivity.this, LoginActivity.class);
                                DashboardActivity.this.startActivity(intent);
                                DashboardActivity.this.finish();
                            }
                        }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                    }
                }
                return false;
            }
        });
    }

    public void onStart() {
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.registerReceiver(this.networkChangeListener, intentFilter);
        super.onStart();
    }

    public void onStop() {
        this.unregisterReceiver(this.networkChangeListener);
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        WorkManager workManager = WorkManager.getInstance((Context)this);
        workManager.cancelAllWork();
        WorkManager.getInstance((Context)this).cancelAllWork();
        this.deleteDatabase("workmanager.db");
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        try {
            this.getMenuInflater().inflate(2131623937, menu2);
        }
        catch (Exception e) {
            Log.e((String)"DashboardActivity", (String)"Error inflating menu", (Throwable)e);
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        return false;
    }

    public boolean onSupportNavigateUp() {
        NavController navController = Navigation.findNavController((Activity)this, (int)2131296862);
        return NavigationUI.navigateUp((NavController)navController, (AppBarConfiguration)this.mAppBarConfiguration) || super.onSupportNavigateUp();
    }

    public String getCurrentFragment() {
        return this.getSupportFragmentManager().findFragmentById(2131296862).getClass().getSimpleName();
    }

    public void sincronizarClientesAvales() {
        ClientesWorker.currentPageClientes = 0;
        ClientesWorker.allDataLoadedClientes = true;
        ClientesWorker.isTaskClientesCompleted = false;
        AvalesWorker.currentPageAvales = 0;
        AvalesWorker.allDataLoadedAvales = true;
        AvalesWorker.isTaskAvalesCompleted = false;
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                AvalesWorker.enqueueWork((Context)DashboardActivity.this);
                DashboardActivity.this.checckBanderaAvales();
            }
        }, 1000L);
    }

    private void checckBanderaAvales() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                ClientesWorker.enqueueWork((Context)this);
            } else {
                Log.d((String)"PRESTAMOS", (String)"Tarea avales a\u00fan no completadas. Reintentando en 500ms...");
                this.checckBanderaAvales();
            }
        }, 1000L);
    }

    public void sincronizarPrestamosPagos() {
        SQLiteDatabase db = new DatabaseHelper((Context)this).getReadableDatabase();
        Cursor cursorPrestamos = db.rawQuery("SELECT COUNT(*) FROM prestamos", null);
        PrestamosWorker.allDataLoadedPrestamos = !cursorPrestamos.moveToFirst() || cursorPrestamos.getInt(0) != 0;
        cursorPrestamos.close();
        Cursor cursorPagos = db.rawQuery("SELECT COUNT(*) FROM pagos", null);
        PagosWorker.allDataLoadedPagos = !cursorPagos.moveToFirst() || cursorPagos.getInt(0) != 0;
        cursorPagos.close();
        PrestamosWorker.currentPagePrestamos = 0;
        PrestamosWorker.isTaskPrestamosCompleted = false;
        PagosWorker.currentPagePagos = 0;
        PagosWorker.isTaskPagosCompleted = false;
        PrestamosWorker.enqueueWork((Context)this);
        this.checckBanderaPrestamos();
    }

    private void checckBanderaPrestamos() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (PrestamosWorker.isTaskPrestamosCompleted) {
                Log.d((String)"PRESTAMOS", (String)"Tarea PrestamosWorker PrestamosWorker.isTaskPrestamosCompleted");
                this.cargarPrestamosDesdeSQLite();
                PagosWorker.enqueueWork((Context)this);
            } else {
                Log.d((String)"PRESTAMOS", (String)"Tarea PrestamosWorker a\u00fan no completadas. Reintentando en 500ms...");
                this.checckBanderaPrestamos();
            }
        }, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cargarPrestamosDesdeSQLite() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Log.d((String)"PagosWorker", (String)"Entro en cargarPrestamosDesdeSQLite()...................");
        String[] columnas = new String[]{"id", "numero_tarjeton", "updated_at"};
        String selection = null;
        String[] selectionArgs = null;
        if (this.sesion.getString("nombre_perfil", "").equalsIgnoreCase("VOCERO") || this.sesion.getString("nombre_perfil", "").equalsIgnoreCase("Administrador") || this.sesion.getString("nombre_perfil", "").equalsIgnoreCase("ADMINISTRADOR")) {
            selection = "status != ?";
            selectionArgs = new String[]{"-1"};
        }
        try (Cursor cursor = db.query("prestamos", columnas, selection, selectionArgs, null, null, "updated_at DESC");){
            if (cursor == null) {
                Log.e((String)"PagosWorker", (String)"El cursor es null, no se pudo realizar la consulta.");
                return;
            }
            PagosWorker.allPagos = new ArrayList<Integer>();
            while (cursor.moveToNext()) {
                String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                try {
                    PagosWorker.allPagos.add(Integer.valueOf(prestamoId));
                    Log.d((String)"PagosWorker", (String)("Lista de pr\u00e9stamos en allPagos SINCRONIZAR: " + PagosWorker.allPagos.toString()));
                }
                catch (NumberFormatException e) {
                    Log.e((String)"PagosWorker", (String)("ID de pr\u00e9stamo no es un n\u00famero v\u00e1lido: " + prestamoId));
                }
            }
            Log.d((String)"PagosWorker", (String)("Total de pr\u00e9stamos cargados: " + PagosWorker.allPagos.size()));
            Log.d((String)"PagosWorker", (String)("Lista de pr\u00e9stamos en allPagos: " + PagosWorker.allPagos.toString()));
        }
        catch (Exception e) {
            Log.e((String)"PagosWorker", (String)("Error al consultar la base de datos: " + e.getMessage()));
        }
        finally {
            db.close();
        }
        if (!PagosWorker.allPagos.isEmpty() && PrestamosWorker.isTaskPrestamosCompleted) {
            Log.d((String)"PagosWorker", (String)"Pr\u00e9stamos cargados correctamente y tarea completada.");
        } else {
            Log.d((String)"PagosWorker", (String)"No hay registros o la tarea no est\u00e1 completa.");
        }
    }

    public void sincronizarRutas() {
        this.vs = VolleyS.getInstance((Context)this);
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"rutasActivas");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    Log.d((String)"SINCRONIZANDO", (String)"RUTAS");
                    DashboardActivity.this.rutaController.truncate();
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Gson gson = new Gson();
                        Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                        DashboardActivity.this.rutaController.nueva(ruta);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)DashboardActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.clear();
    }

    public void sincronizarPoblaciones() {
        this.vs = VolleyS.getInstance((Context)this);
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"index");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    Log.d((String)"SINCRONIZANDO", (String)"POBLACIONES");
                    DashboardActivity.this.poblacionController.truncate();
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Gson gson = new Gson();
                        Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                        DashboardActivity.this.poblacionController.nueva(poblacion);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)DashboardActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    public void sincronizarColocadoras() {
        this.vs = VolleyS.getInstance((Context)this);
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"index");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    Log.d((String)"SINCRONIZANDO", (String)"COLOCADORAS");
                    DashboardActivity.this.colocadoraController.truncate();
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Gson gson = new Gson();
                        Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                        DashboardActivity.this.colocadoraController.nueva(colocadora);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)DashboardActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    public void sincronizarReporteDiario() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursorGastos = db.rawQuery("SELECT * FROM gastos WHERE status IN ('1', '2')", null);
        Cursor cursor = db.rawQuery("SELECT * FROM reporte_diario_rutas WHERE status IN ('1', '2')", null);
        if (cursorGastos != null && cursorGastos.moveToFirst()) {
            do {
                String Gid = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("id"));
                String Gotros = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("otros"));
                String Ggasolina = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("gasolina"));
                String Ghotel = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("hotel"));
                String Galimentos = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("alimentos"));
                String Gcasetas = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("casetas"));
                String Gtotal = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("total"));
                String Gstatus = cursorGastos.getString(cursorGastos.getColumnIndexOrThrow("status"));
                JSONObject dataGastos = new JSONObject();
                try {
                    dataGastos.put("id", (Object)Gid);
                    dataGastos.put("otros", (Object)Gotros);
                    dataGastos.put("gasolina", (Object)Ggasolina);
                    dataGastos.put("hotel", (Object)Ghotel);
                    dataGastos.put("alimentos", (Object)Galimentos);
                    dataGastos.put("casetas", (Object)Gcasetas);
                    dataGastos.put("total", (Object)Gtotal);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (Gstatus.equals("1")) {
                    Log.d((String)"DEBUG", (String)"SINCRONIZAR GASTOS de rutas CONDICION STATUS = 1 SIN Gastos INSERTAR......................");
                    try {
                        dataGastos.put("func", (Object)"createGastos");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    this.enviarSolicitudAlServidorGastos(1, API.urlPagos, dataGastos, Gid, Gstatus);
                    continue;
                }
                if (!Gstatus.equals("2")) continue;
                Log.d((String)"DEBUG", (String)"SINCRONIZAR GASTOS de rutas CONDICION STATUS = 2 EDITAR......................");
                try {
                    dataGastos.put("func", (Object)"editGastos");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.enviarSolicitudAlServidorGastos(2, API.urlPagos, dataGastos, Gid, Gstatus);
            } while (cursorGastos.moveToNext());
        }
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                String estimacion = cursor.getString(cursor.getColumnIndexOrThrow("estimacion"));
                String abonos_semana = cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana"));
                String recuperacion_semana = cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana"));
                String recuperacion_vencida = cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_vencida"));
                String anticipos = cursor.getString(cursor.getColumnIndexOrThrow("anticipos"));
                String total_1 = cursor.getString(cursor.getColumnIndexOrThrow("total_1"));
                String recuperacion_prestamos = cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos"));
                String colocacion = cursor.getString(cursor.getColumnIndexOrThrow("colocacion"));
                String prestamo_colocadora = cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora"));
                String comision = cursor.getString(cursor.getColumnIndexOrThrow("comision"));
                String bono_colocadora = cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora"));
                String total_2 = cursor.getString(cursor.getColumnIndexOrThrow("total_2"));
                String saldo = cursor.getString(cursor.getColumnIndexOrThrow("saldo"));
                String pendiente_recuperar = cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar"));
                String abonos_recuperar = cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar"));
                String comentario = cursor.getString(cursor.getColumnIndexOrThrow("comentario"));
                String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                String gastos_id = cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                String fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
                String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                JSONObject data = new JSONObject();
                try {
                    data.put("id", (Object)id2);
                    data.put("poblacion_id", (Object)poblacion_id);
                    data.put("estimacion", (Object)estimacion);
                    data.put("abonos_semana", (Object)abonos_semana);
                    data.put("recuperacion_semana", (Object)recuperacion_semana);
                    data.put("recuperacion_vencida", (Object)recuperacion_vencida);
                    data.put("anticipos", (Object)anticipos);
                    data.put("total_1", (Object)total_1);
                    data.put("recuperacion_prestamos", (Object)recuperacion_prestamos);
                    data.put("colocacion", (Object)colocacion);
                    data.put("prestamo_colocadora", (Object)prestamo_colocadora);
                    data.put("comision", (Object)comision);
                    data.put("bono_colocadora", (Object)bono_colocadora);
                    data.put("total_2", (Object)total_2);
                    data.put("saldo", (Object)saldo);
                    data.put("pendiente_recuperar", (Object)pendiente_recuperar);
                    data.put("abonos_recuperar", (Object)abonos_recuperar);
                    data.put("comentario", (Object)comentario);
                    data.put("empleado_id", (Object)empleado_id);
                    data.put("fecha", (Object)fecha);
                    data.put("fecha_registro", (Object)fecha_registro);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (status.equals("0")) {
                    if (gastos_id.isEmpty()) continue;
                    Log.d((String)"DEBUG", (String)"SINCRONIZAR Reporte diario de rutas CONDICION STATUS = 1 y Contiene ID de Gastos......................");
                    try {
                        data.put("func", (Object)"agregarRegistroReporteDiarioRutas");
                        data.put("gastos_id", (Object)gastos_id);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    this.enviarSolicitudAlServidorReporteDiarioRutas(1, API.urlPagos, data, id2, status);
                    continue;
                }
                if (status.equals("1")) {
                    Log.d((String)"DEBUG", (String)"SINCRONIZAR Reporte diario de rutas CONDICION STATUS = 1 SIN Gastos......................");
                    try {
                        data.put("func", (Object)"createReporteDiarioRutas");
                        data.put("gastos_id", (Object)"");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    this.enviarSolicitudAlServidorReporteDiarioRutas(1, API.urlPagos, data, id2, status);
                    continue;
                }
                if (!status.equals("2")) continue;
                Log.d((String)"DEBUG", (String)"SINCRONIZAR Reporte diario de rutas CONDICION STATUS = 2 EDITAR......................");
                try {
                    data.put("func", (Object)"editReporteDiarioRutas");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.enviarSolicitudAlServidorReporteDiarioRutas(2, API.urlPagos, data, id2, status);
            } while (cursor.moveToNext());
        }
        if (cursorGastos != null) {
            cursorGastos.close();
        }
        if (cursor != null) {
            cursor.close();
        }
        db.close();
    }

    private void enviarSolicitudAlServidorReporteDiarioRutas(int method, String url, JSONObject data, final String id2, final String status) {
        JsonObjectRequest request = new JsonObjectRequest(method, url, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String idServer = response.getJSONObject("data").getString("id");
                        String gastosId = response.getJSONObject("data").getString("gastos_id");
                        Log.d((String)"DEBUG", (String)("Status en el DATA ....................: " + status));
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de idServer'....................: " + idServer));
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de idServer'....................: " + gastosId));
                        SQLiteDatabase writableDb = new DatabaseHelper(DashboardActivity.this.getApplicationContext()).getWritableDatabase();
                        ContentValues values = new ContentValues();
                        if (status.equals("1")) {
                            if (gastosId != null && !gastosId.isEmpty()) {
                                values.put("gastos_id", gastosId);
                                values.put("status", "0");
                                values.put("id", idServer);
                                writableDb.update("reporte_diario_rutas", values, "id = ?", new String[]{id2});
                            }
                        } else {
                            values.put("status", "0");
                            writableDb.update("reporte_diario_rutas", values, "id = ?", new String[]{id2});
                        }
                        writableDb.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)DashboardActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    private void enviarSolicitudAlServidorGastos(int method, String url, JSONObject data, final String id2, final String gstatus) {
        JsonObjectRequest request = new JsonObjectRequest(method, url, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String idServer = response.getJSONObject("data").getString("id");
                        Log.d((String)"DEBUG", (String)("Status en el DATA ....................: " + gstatus));
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de idServer'....................: " + idServer));
                        SQLiteDatabase writableDb = new DatabaseHelper(DashboardActivity.this.getApplicationContext()).getWritableDatabase();
                        ContentValues values = new ContentValues();
                        if (gstatus.equals("1")) {
                            values.put("status", "0");
                            values.put("id", idServer);
                            writableDb.update("gastos", values, "id = ?", new String[]{id2});
                        } else {
                            values.put("status", "0");
                            writableDb.update("gastos", values, "id = ?", new String[]{id2});
                        }
                        writableDb.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)DashboardActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    public void dbSync() {
        this.syncServerApp(new RMDFragment.SyncCallback(){

            @Override
            public void onSuccess() {
            }
        });
        this.syncAppServer(new RMDFragment.SyncCallback(){

            @Override
            public void onSuccess() {
            }
        });
        Toast.makeText((Context)this, (CharSequence)"RMDs insertados", (int)0).show();
    }

    public void syncServerApp(final RMDFragment.SyncCallback callback) {
        final RMDController rmdController = new RMDController((Context)this, null);
        rmdController.getCountRMDsServidor(new RMDController.GetCountRMDsServidorCallback(){

            @Override
            public void onSuccess(int n) {
                int c = rmdController.getRMDSCount();
                if (c == n) {
                    callback.onSuccess();
                } else {
                    rmdController.getRMDSinSincronizar(new RMDController.GetRMDsSinSincronizarCallback(){

                        @Override
                        public void onSuccess(ArrayList<RMD> rmds) {
                            if (rmds != null && !rmds.isEmpty()) {
                                for (RMD rmd : rmds) {
                                    rmdController.intertarRMDServidor(rmd, new RMDController.SincronizarDelServidorCallback(){

                                        @Override
                                        public void onSuccess() {
                                        }

                                        @Override
                                        public void onError(String error) {
                                        }
                                    });
                                }
                            }
                        }

                        @Override
                        public void onError(String error) {
                        }
                    });
                }
            }

            @Override
            public void onError(String error) {
                Log.d((String)"ERROR", (String)("onError: " + error));
            }
        });
    }

    public void syncAppServer(RMDFragment.SyncCallback callback) {
        RMDController rmdController = new RMDController((Context)this, null);
        ArrayList<RMD> rmds = rmdController.getRMDsDesincronizados();
        if (rmds != null && !rmds.isEmpty()) {
            this.sincronizar(rmds);
            callback.onSuccess();
        } else {
            callback.onSuccess();
        }
    }

    public void sincronizar(ArrayList<RMD> rmds) {
        RMDController rmdController = new RMDController((Context)this, null);
        for (RMD rmd : rmds) {
            rmdController.subirRMDsDesincronizadosServidor(rmd, new RMDController.SubirRMDsDesincronizadosServidorCallback(){

                @Override
                public void onSuccess() {
                }

                @Override
                public void onError(String error) {
                }
            });
        }
    }

    public void syncFolios() {
        final DatabaseHelper dbHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        ArrayList<Object> unsyncedFolios = new ArrayList();
        unsyncedFolios = this.getUnsyncedFolios();
        if (!unsyncedFolios.isEmpty()) {
            for (final Folio folio : unsyncedFolios) {
                JSONObject data = new JSONObject();
                try {
                    data.put("func", (Object)"storeFolio");
                    data.put("folio", (Object)folio.getId());
                    data.put("fecha", (Object)folio.getFecha());
                    data.put("hora", (Object)folio.getHora());
                    data.put("cliente_id", (Object)folio.getCliente_id());
                    data.put("ruta_id", (Object)folio.getRuta_id());
                    data.put("poblacion_id", (Object)folio.getPoblacion_id());
                    data.put("monto", (Object)folio.getMonto());
                    data.put("monto_letra", (Object)folio.getMonto_letra());
                    data.put("concepto", (Object)folio.getConcepto());
                    data.put("firma_usuario", (Object)folio.getFirma_usuario());
                    data.put("firma_cliente", (Object)folio.getFirma_cliente());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                Log.d((String)"data", (String)data.toString());
                this.vs = VolleyS.getInstance((Context)this);
                this.requestQueue = this.vs.getRequestQueue();
                JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        Log.d((String)"sync repsonse", (String)("onResponse: " + response));
                        String query = "UPDATE folios SET sync = 1 WHERE id = ?";
                        SQLiteDatabase db = dbHelper.getWritableDatabase();
                        db.execSQL(query, (Object[])new String[]{folio.getId()});
                        db.close();
                    }
                }, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        Log.d((String)"sync error dashboard", (String)("onErrorResponse: " + error));
                    }
                });
                request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
                request.setShouldCache(false);
                VolleyS vs = VolleyS.getInstance(this.context);
                RequestQueue requestQueue = vs.getRequestQueue();
                requestQueue.add((Request)request);
            }
        }
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"indexFolio");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray dataArray = response.getJSONArray("data");
                        for (int i = 0; i < dataArray.length(); ++i) {
                            JSONObject folioObject = dataArray.getJSONObject(i);
                            Folio newFolio = new Folio(folioObject.getString("id"), folioObject.getString("fecha"), folioObject.getString("hora"), folioObject.getString("cliente_id"), folioObject.getString("ruta_id"), folioObject.getString("poblacion_id"), folioObject.getString("monto"), folioObject.getString("monto_letra"), folioObject.getString("concepto"), folioObject.getString("firma_usuario"), folioObject.getString("firma_cliente"));
                            Log.d((String)"folioDescargado", (String)newFolio.toString());
                            Folio existingFolio = DashboardActivity.this.getFolioFromDbById(newFolio.getId());
                            if (existingFolio == null) {
                                DashboardActivity.this.storeSync(newFolio);
                                continue;
                            }
                            if (!newFolio.equals(existingFolio)) {
                                DashboardActivity.this.updateFolioInDb(newFolio);
                                Log.d((String)"folioActualizado", (String)newFolio.toString());
                                continue;
                            }
                            Log.d((String)"folioSinCambios", (String)newFolio.getId());
                        }
                    } else {
                        Toast.makeText((Context)DashboardActivity.this.context, (CharSequence)("Error del servidor: " + response.getString("message")), (int)0).show();
                    }
                }
                catch (JSONException e) {
                    Toast.makeText((Context)DashboardActivity.this.context, (CharSequence)"Error al parsear respuesta JSON.", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Toast.makeText((Context)DashboardActivity.this.context, (CharSequence)("Error de red: " + error.getMessage()), (int)0).show();
            }
        });
        jsonObjectRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        jsonObjectRequest.setShouldCache(false);
        VolleyS.getInstance(this.context).getRequestQueue().add((Request)jsonObjectRequest);
    }

    private void updateFolioInDb(Folio newFolio) {
        DatabaseHelper databaseHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("fecha", newFolio.getFecha());
        cv.put("hora", newFolio.getHora());
        cv.put("cliente_id", newFolio.getCliente_id());
        cv.put("ruta_id", newFolio.getRuta_id());
        cv.put("poblacion_id", newFolio.getPoblacion_id());
        cv.put("monto", newFolio.getMonto());
        cv.put("monto_letra", newFolio.getMonto_letra());
        cv.put("concepto", newFolio.getConcepto());
        cv.put("firma_usuario", newFolio.getFirma_usuario());
        cv.put("firma_cliente", newFolio.getFirma_cliente());
        cv.put("sync", Integer.valueOf(1));
        db.update("folios", cv, "id = ?", new String[]{newFolio.getId()});
        db.close();
    }

    public boolean folioExists(String folioId) {
        DatabaseHelper databaseHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT id FROM folios WHERE id = ?", new String[]{folioId});
        boolean exists = cursor.moveToFirst();
        cursor.close();
        db.close();
        return exists;
    }

    public double storeSync(Folio folio) {
        DatabaseHelper databaseHelper = new DatabaseHelper((Context)this);
        if (this.folioExists(folio.getId())) {
            return -1.0;
        }
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("id", folio.getId());
        cv.put("fecha", folio.getFecha());
        cv.put("hora", folio.getHora());
        cv.put("cliente_id", folio.getCliente_id());
        cv.put("ruta_id", folio.getRuta_id());
        cv.put("poblacion_id", folio.getPoblacion_id());
        cv.put("monto", folio.getMonto());
        cv.put("monto_letra", folio.getMonto_letra());
        cv.put("concepto", folio.getConcepto());
        cv.put("firma_usuario", folio.getFirma_usuario());
        cv.put("firma_cliente", folio.getFirma_cliente());
        cv.put("sync", Integer.valueOf(1));
        String createUsuariosFoliosTable = "CREATE TABLE IF NOT EXISTS usuarios_folios (usuario_id INTEGER,folio_id INTEGER);";
        db.execSQL(createUsuariosFoliosTable);
        String query = "DELETE FROM usuarios_folios WHERE folio_id = ?";
        db.execSQL(query, (Object[])new String[]{folio.getId()});
        Log.d((String)"FadeMove", (String)("storeSync: " + folio.getId()));
        return db.insert("folios", null, cv);
    }

    private Folio getFolioFromDbById(String id2) {
        DatabaseHelper databaseHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        try {
            String query = "SELECT * FROM folios WHERE id = ?";
            Cursor cursor = db.rawQuery(query, new String[]{id2});
            Folio folio = null;
            if (cursor.moveToFirst()) {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                cursor.close();
                db.close();
                return folio;
            }
            cursor.close();
            db.close();
            return folio;
        }
        catch (Exception e) {
            String drop = "DROP TABLE folios";
            db.execSQL(drop);
            String createTableQuery = "CREATE TABLE IF NOT EXISTS folios (id INTEGER PRIMARY KEY,fecha VARCHAR(10),hora TIME,cliente_id VARCHAR(100),ruta_id INTEGER,poblacion_id INTEGER,monto VARCHAR(50),monto_letra VARCHAR(200),concepto VARCHAR(1000),firma_usuario VARCHAR(200000),firma_cliente VARCHAR(200000),sync VARCHAR(1));";
            db.execSQL(createTableQuery);
            this.syncFolios();
            return null;
        }
    }

    public ArrayList<Folio> getUnsyncedFolios() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        try {
            String query = "SELECT * FROM folios WHERE sync = 0";
            Cursor cursor = db.rawQuery(query, new String[0]);
            if (cursor.moveToFirst()) {
                do {
                    String nFolio = cursor.getString(0);
                    String fecha = cursor.getString(1);
                    String hora = cursor.getString(2);
                    String cliente_id = cursor.getString(3);
                    String ruta_id = cursor.getString(4);
                    String poblacion_id = cursor.getString(5);
                    String monto = cursor.getString(6);
                    String monto_letra = cursor.getString(7);
                    String concepto = cursor.getString(8);
                    String firma_usuario = cursor.getString(9);
                    String firma_cliente = cursor.getString(10);
                    Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                    folios.add(folio);
                } while (cursor.moveToNext());
                cursor.close();
                db.close();
            }
            return folios;
        }
        catch (Exception e) {
            String drop = "DROP TABLE folios";
            db.execSQL(drop);
            String createTableQuery = "CREATE TABLE IF NOT EXISTS folios (id INTEGER PRIMARY KEY,fecha VARCHAR(10),hora TIME,cliente_id VARCHAR(100),ruta_id INTEGER,poblacion_id INTEGER,monto VARCHAR(50),monto_letra VARCHAR(200),concepto VARCHAR(1000),firma_usuario VARCHAR(200000),firma_cliente VARCHAR(200000),sync VARCHAR(1));";
            db.execSQL(createTableQuery);
            this.syncFolios();
            return folios;
        }
    }

    public void sincronizarReporteCreditos() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT * FROM reporte_creditos WHERE status IN ('1', '2')", null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                String observaciones = cursor.getString(cursor.getColumnIndexOrThrow("observaciones"));
                String creditos_otorgados = cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados"));
                String total_prestamos = cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos"));
                String prestamos_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos"));
                String monto_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos"));
                String prestamos_renovados = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados"));
                String monto_renovados = cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados"));
                String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                String fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
                String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                JSONObject data = new JSONObject();
                try {
                    data.put("id", (Object)id2);
                    data.put("poblacion_id", (Object)poblacion_id);
                    data.put("observaciones", (Object)observaciones);
                    data.put("creditos_otorgados", (Object)creditos_otorgados);
                    data.put("total_prestamos", (Object)total_prestamos);
                    data.put("prestamos_nuevos", (Object)prestamos_nuevos);
                    data.put("monto_nuevos", (Object)monto_nuevos);
                    data.put("prestamos_renovados", (Object)prestamos_renovados);
                    data.put("monto_renovados", (Object)monto_renovados);
                    data.put("empleado_id", (Object)empleado_id);
                    data.put("fecha", (Object)fecha);
                    data.put("fecha_registro", (Object)fecha_registro);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (status.equals("1")) {
                    Log.d((String)"DEBUG", (String)"SINCRONIZAR GASTOS de rutas CONDICION STATUS = 1 SIN Gastos INSERTAR......................");
                    try {
                        data.put("func", (Object)"createReporteCreditos");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    this.enviarSolicitudAlServidorCreditos(1, API.urlPagos, data, id2, status);
                    continue;
                }
                if (!status.equals("2")) continue;
                Log.d((String)"DEBUG", (String)"SINCRONIZAR GASTOS de rutas CONDICION STATUS = 2 EDITAR......................");
                try {
                    data.put("func", (Object)"editReporteCreditos");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.enviarSolicitudAlServidorCreditos(2, API.urlPagos, data, id2, status);
            } while (cursor.moveToNext());
        }
        if (cursor != null) {
            cursor.close();
        }
        db.close();
    }

    private void enviarSolicitudAlServidorCreditos(int method, String url, JSONObject data, final String id2, final String status) {
        JsonObjectRequest request = new JsonObjectRequest(method, url, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String idServer = response.getJSONObject("data").getString("id");
                        Log.d((String)"DEBUG", (String)("Status en el DATA ....................: " + status));
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de idServer'....................: " + idServer));
                        SQLiteDatabase writableDb = new DatabaseHelper(DashboardActivity.this.getApplicationContext()).getWritableDatabase();
                        ContentValues values = new ContentValues();
                        if (status.equals("1")) {
                            values.put("status", "0");
                            values.put("id", idServer);
                            writableDb.update("reporte_creditos", values, "id = ?", new String[]{id2});
                        } else {
                            values.put("status", "0");
                            writableDb.update("reporte_creditos", values, "id = ?", new String[]{id2});
                        }
                        writableDb.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)DashboardActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    public void onBackPressed() {
        super.onBackPressed();
        DrawerLayout drawer = (DrawerLayout)this.findViewById(2131296562);
        if (drawer.isDrawerOpen(0x800003)) {
            drawer.closeDrawer(0x800003);
        } else if (CurrentFragment.fragment.equals("ClientesEditarFragment") || CurrentFragment.fragment.equals("ClientesCrearFragment") || CurrentFragment.fragment.equals("PrestamosCrearFragment")) {
            this.navController.navigate(2131296849);
        } else if (CurrentFragment.fragment.equals("PagosFragment") || CurrentFragment.fragment.equals("PagosPagarFragment")) {
            this.navController.navigate(2131296866);
        } else {
            new ConfirmLogoutDialogFragment().show(this.getSupportFragmentManager(), "confirmLogout");
        }
    }

    public void conectarImpresora(ConexionCallback callback) {
        BluetoothUtils.context = this.getApplicationContext();
        BluetoothUtils.listPairedDevices(this.sesion.getString("impresora", "SP-T12 Printer"));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.registerReceiver(BluetoothUtils.BTReceiver, filter);
        BluetoothUtils.broadcastReceiver();
        BluetoothUtils.initThread();
        callback.onSuccess();
    }

    public static class ConfirmLogoutDialogFragment
    extends DialogFragment {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new MaterialAlertDialogBuilder(this.requireContext()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"\u00bfDesea cerrar sesi\u00f3n?").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    this.getActivity().finish();
                }
            }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).create();
        }
    }

    public static interface ConexionCallback {
        public void onSuccess();
    }
}

