/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.work.WorkManager;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.DashboardActivity;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ConfiguracionSemanasController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ConfiguracionSemana;
import com.example.sefinsa_app.models.Empleado;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChangeListener;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginActivity
extends AppCompatActivity {
    private Button btnLogin;
    private TextInputLayout tlUsuario;
    private TextInputLayout tlContrasenia;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private SharedPreferences sesion;
    private ConfiguracionSemanasController configuracionSemanaController;
    private ArrayList<ConfiguracionSemana> configuracionSemanas;
    private TextView tvAnio;
    private TextView tvVersion;
    private final int CODIGO_PERMISOS = 777;
    NetworkChangeListener networkChangeListener = new NetworkChangeListener();

    @SuppressLint(value={"SetTextI18n"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Locale.setDefault(Locale.US);
        this.setContentView(2131492894);
        Executors.newSingleThreadExecutor().execute(() -> {
            WorkManager workManager = WorkManager.getInstance((Context)this);
            workManager.cancelAllWork();
            WorkManager.getInstance((Context)this).cancelAllWork();
            this.deleteDatabase("workmanager.db");
            this.getConfiguracionSemana();
        });
        if (!API.production) {
            Toast.makeText((Context)this, (CharSequence)"Modo de pruebas", (int)1).show();
        }
        this.sesion = this.getSharedPreferences("sesion", 0);
        this.btnLogin = (Button)this.findViewById(2131296441);
        this.tlUsuario = (TextInputLayout)this.findViewById(2131297242);
        this.tlContrasenia = (TextInputLayout)this.findViewById(2131297168);
        this.tvAnio = (TextView)this.findViewById(2131297264);
        this.tvVersion = (TextView)this.findViewById(2131297346);
        this.tvAnio.setText((CharSequence)String.valueOf(Calendar.getInstance().get(1)));
        this.tvVersion.setText((CharSequence)"v 2.0.1");
        int permisoAlmacen = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        int permisoAlmacen2 = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_EXTERNAL_STORAGE");
        int permisoCamara = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA");
        int permisoBT1 = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.BLUETOOTH_CONNECT");
        int permisoBT2 = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.BLUETOOTH");
        int permisoUbicacion1 = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION");
        int permisoUbicacion2 = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION");
        if (permisoAlmacen != 0 || permisoAlmacen2 != 0 || permisoCamara != 0 || permisoBT1 != 0 || permisoBT2 != 0 || permisoUbicacion1 != 0 || permisoUbicacion2 != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.BLUETOOTH", "android.permission.BLUETOOTH_CONNECT", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, (int)777);
        }
        this.btnLogin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Executors.newSingleThreadExecutor().execute(() -> LoginActivity.this.runOnUiThread(() -> {
                    if (Validator.fieldValidation(LoginActivity.this.tlUsuario, "Ingresa un usuario v\u00e1lido") && Validator.fieldValidation(LoginActivity.this.tlContrasenia, "Ingresa una contrase\u00f1a v\u00e1lida")) {
                        LoginActivity.this.login(LoginActivity.this.tlUsuario.getEditText().getText().toString(), LoginActivity.this.tlContrasenia.getEditText().getText().toString());
                    }
                }));
            }
        });
    }

    public void onStart() {
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.registerReceiver(this.networkChangeListener, intentFilter);
        super.onStart();
    }

    public void onStop() {
        this.unregisterReceiver(this.networkChangeListener);
        super.onStop();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 777: {
                if (grantResults.length > 0) {
                    if (grantResults[0] == 0 && grantResults[1] == 0 && grantResults[2] == 0 && grantResults[5] == 0 && grantResults[6] == 0) break;
                    this.showPermissionDeniedDialog();
                    break;
                }
                this.showPermissionDeniedDialog();
            }
        }
    }

    private void showPermissionDeniedDialog() {
        if (!this.isFinishing()) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)"Permisos necesarios");
            builder.setMessage((CharSequence)"Los permisos son necesarios para el correcto funcionamiento de la aplicaci\u00f3n. Por favor, otorgue los permisos requeridos.");
            builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ActivityCompat.requestPermissions((Activity)LoginActivity.this, (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.BLUETOOTH", "android.permission.BLUETOOTH_CONNECT", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, (int)777);
                }
            });
            builder.setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Toast.makeText((Context)LoginActivity.this, (CharSequence)"Los permisos son necesarios para utilizar la aplicaci\u00f3n.", (int)0).show();
                }
            });
            builder.setCancelable(false);
            builder.show();
        }
    }

    private void login(String usuario, String contrasenia) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogView = inflater.inflate(2131492938, null);
        builder.setView(dialogView);
        builder.setCancelable(false);
        final AlertDialog dialog = builder.create();
        dialog.show();
        this.vs = VolleyS.getInstance(this.getApplicationContext());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("usuario", (Object)usuario);
            data.put("password", (Object)contrasenia);
            data.put("func", (Object)"login");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlEmpleados, data, (Response.Listener)new Response.Listener<JSONObject>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(JSONObject response) {
                try {
                    dialog.cancel();
                    Log.d((String)"response", (String)response.toString());
                    Gson gson = new Gson();
                    Empleado empleado = null;
                    Object dataRaw = response.get("data");
                    if (dataRaw instanceof JSONArray) {
                        JSONArray dataArray = (JSONArray)dataRaw;
                        Log.d((String)"dataType", (String)"JSONArray");
                        if (dataArray.length() <= 0) {
                            Toast.makeText((Context)LoginActivity.this, (CharSequence)"No se encontraron datos de usuario", (int)0).show();
                            return;
                        }
                        JSONObject dataObject = dataArray.getJSONObject(0);
                        empleado = (Empleado)gson.fromJson(dataObject.toString(), Empleado.class);
                    } else {
                        if (!(dataRaw instanceof JSONObject)) {
                            Toast.makeText((Context)LoginActivity.this, (CharSequence)"Respuesta inesperada del servidor", (int)0).show();
                            return;
                        }
                        JSONObject dataObject = (JSONObject)dataRaw;
                        Log.d((String)"dataType", (String)"JSONObject");
                        empleado = (Empleado)gson.fromJson(dataObject.toString(), Empleado.class);
                    }
                    if (empleado == null) return;
                    String cachedId = LoginActivity.this.sesion.getString("id", null);
                    if (cachedId != null && !cachedId.equals(empleado.id)) {
                        LoginActivity.this.clearLocalData();
                    }
                    SharedPreferences.Editor editor = LoginActivity.this.sesion.edit();
                    editor.putString("id", empleado.id);
                    editor.putString("nombre", empleado.nombre_completo);
                    editor.putString("usuario", empleado.usuario);
                    editor.putString("perfil_id", empleado.perfil_id);
                    editor.putString("tipo_perfil", empleado.tipo_perfil);
                    editor.putString("nombre_perfil", empleado.nombre_perfil);
                    editor.putString("rutas", empleado.rutas);
                    editor.putString("telefono", empleado.telefono);
                    editor.commit();
                    Intent intent = new Intent((Context)LoginActivity.this, DashboardActivity.class);
                    intent.addFlags(335577088);
                    LoginActivity.this.startActivity(intent);
                    LoginActivity.this.finish();
                    return;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Toast.makeText((Context)LoginActivity.this, (CharSequence)"Error al procesar la respuesta del servidor", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                Log.d((String)"loginError", (String)error.toString());
                ErrorChecker.checker(error, (Context)LoginActivity.this);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    private void clearLocalData() {
        DatabaseHelper dbHelper = new DatabaseHelper(this.getApplicationContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        db.delete("clientes", null, null);
        db.delete("prestamos", null, null);
        db.delete("pagos", null, null);
        db.close();
        Log.d((String)"SQLite", (String)"Datos locales eliminados correctamente de CLIENTES, PRESTAMOS Y PAGOS.");
    }

    public void getConfiguracionSemana() {
        Log.d((String)"DEBUG", (String)"Entro en getConfiguracionSemana()............");
        this.configuracionSemanaController = new ConfiguracionSemanasController((Context)this);
        this.configuracionSemanas = new ArrayList();
        if (this.configuracionSemanaController.obtener().size() == 0) {
            Log.d((String)"DEBUG", (String)"Entro en configuracionSemanaController().size() == 0............");
            this.vs = VolleyS.getInstance((Context)this);
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"indexApp_UpdConfiguraciones");
            }
            catch (JSONException e) {
                Log.d((String)"DEBUG", (String)("Error al crear el JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = response.getJSONArray("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            ConfiguracionSemana configuracion = (ConfiguracionSemana)gson.fromJson(obj.toString(), ConfiguracionSemana.class);
                            LoginActivity.this.configuracionSemanas.add(configuracion);
                            LoginActivity.this.configuracionSemanaController.nueva(configuracion);
                        }
                    }
                    catch (JSONException e) {
                        Log.d((String)"DEBUG", (String)("Error en el procesamiento de la respuesta: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.d((String)"DEBUG", (String)"Entro en request ERROR getConfiguracionSemana!!!!!............");
                    if (error.networkResponse != null) {
                        int statusCode = error.networkResponse.statusCode;
                        Log.d((String)"DEBUG", (String)("HTTP Status Code: " + statusCode));
                        String responseBody = new String(error.networkResponse.data);
                        Log.d((String)"DEBUG", (String)("Response Body: " + responseBody));
                    } else {
                        Log.d((String)"DEBUG", (String)"No hay respuesta del servidor.");
                    }
                    ErrorChecker.checker(error, (Context)LoginActivity.this);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            Log.d((String)"DEBUG", (String)"No hay configuraciones disponibles en configuracionSemanaController.");
        }
    }
}

