/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.ui.avales.AvalesFragment;
import com.example.sefinsa_app.ui.clientes.ClientesFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.VolleyS;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    private final NetworkChangeListener listener;
    private static Context appContext;
    private boolean isProcessing = false;

    public NetworkChangeReceiver(NetworkChangeListener listener) {
        this.listener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        appContext = context.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        this.listener.onNetworkChanged(isConnected);
        if (isConnected) {
            this.procesarColaSolicitudes();
        }
    }

    private void procesarColaSolicitudes() {
        ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
        if (colaSolicitudes.estaVacia()) {
            this.isProcessing = false;
            return;
        }
        if (this.isProcessing) {
            return;
        }
        this.isProcessing = true;
        SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud();
        if (solicitud == null) {
            this.isProcessing = false;
            this.procesarColaSolicitudes();
            return;
        }
        switch (solicitud.getTipo()) {
            case "aval": {
                this.subirFotosAv(solicitud.getArchivos(), solicitud.getFunc(), solicitud.getId(), solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo());
                break;
            }
            case "cliente": {
                this.subirFotosCl(solicitud.getArchivos(), solicitud.getFunc(), solicitud.getId(), solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo());
                break;
            }
            case "InsertAval": {
                this.registrarAvalNuevo(solicitud, colaSolicitudes, solicitud.getArchivos(), solicitud.getNombreQ(), solicitud.getDireccionQ(), solicitud.getTelefonoQ(), solicitud.getOtrasReferenciasQ(), solicitud.getGarantiasQ(), solicitud.getRutaIdQ(), solicitud.getPoblacionIdQ(), solicitud.getColocadoraIdQ(), solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo(), solicitud.getClienteIDQ());
                break;
            }
            case "InsertCliente": {
                this.registrarClienteNuevo(solicitud, colaSolicitudes, solicitud.getArchivos(), solicitud.getNombreQ(), solicitud.getDireccionQ(), solicitud.getTelefonoQ(), solicitud.getOtrasReferenciasQ(), solicitud.getGarantiasQ(), solicitud.getRutaIdQ(), solicitud.getPoblacionIdQ(), solicitud.getColocadoraIdQ(), solicitud.getCantidadGarantias(), solicitud.getCantidadArchivo(), solicitud.getAval_idQ());
                break;
            }
            default: {
                this.procesarColaSolicitudes();
            }
        }
    }

    private void registrarAvalNuevo(SolicitudSubida solicitud, ColaSolicitudes colaSolicitudes, List<MultipartBody.Part> archivosGeneral, final String nombreQ, String direccionQ, String telefonoQ, String otrasReferenciasQ, String garantiasQ, String rutaIdQ, String poblacionIdQ, String colocadoraIdQ, String cantidad_archivos_garantias_cliente2, String cantidad_archivos_cliente2, final String clienteIDQ) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"createAPP");
        RequestBody nombre_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreQ);
        RequestBody direccion_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)direccionQ);
        RequestBody telefono_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)telefonoQ);
        RequestBody rutaId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)rutaIdQ);
        RequestBody poblacionId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)poblacionIdQ);
        RequestBody colocadoraId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)colocadoraIdQ);
        RequestBody or_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)otrasReferenciasQ);
        RequestBody garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)garantiasQ);
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_cliente2);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_garantias_cliente2);
        RequestBody latitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"0");
        RequestBody longitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"0");
        Call<ResponseMe> call = retrofitInterface.registrarAval(archivosGeneral, func, nombre_aval, direccion_aval, telefono_aval, rutaId, poblacionId, colocadoraId, or_aval, garantias_aval, cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    if (response.body() != null && ((ResponseMe)response.body()).getStatus().equals("success")) {
                        String idAntiguo;
                        String clienteId = ((ResponseMe)response.body()).getClienteId();
                        ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                        SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud();
                        if (solicitud != null) {
                            colaSolicitudes.obtenerIndexSolicitudyBorrar();
                            NetworkChangeReceiver.this.isProcessing = false;
                            NetworkChangeReceiver.this.procesarColaSolicitudes();
                        }
                        if ((idAntiguo = NetworkChangeReceiver.this.obtenerIdAntiguoDeSQLiteAval(nombreQ)) != null) {
                            NetworkChangeReceiver.this.actualizarRegistroSQLiteAval(clienteId, nombreQ, idAntiguo, clienteIDQ);
                        }
                    } else {
                        NetworkChangeReceiver.this.isProcessing = false;
                        NetworkChangeReceiver.this.procesarColaSolicitudes();
                    }
                } else {
                    ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                    SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud();
                    if (solicitud != null) {
                        colaSolicitudes.obtenerIndexSolicitudyBorrar();
                        NetworkChangeReceiver.this.isProcessing = false;
                        NetworkChangeReceiver.this.procesarColaSolicitudes();
                    }
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                Log.d((String)"SQLite", (String)("ENTRO EN ERROR INSERT SUBIDA........................" + t.getLocalizedMessage()));
                NetworkChangeReceiver.this.isProcessing = false;
                NetworkChangeReceiver.this.procesarColaSolicitudes();
            }
        });
    }

    private void registrarClienteNuevo(SolicitudSubida solicitud, ColaSolicitudes colaSolicitudes, List<MultipartBody.Part> archivosGeneral, final String nombreQ, String direccionQ, String telefonoQ, String otrasReferenciasQ, String garantiasQ, String rutaIdQ, String poblacionIdQ, String colocadoraIdQ, String cantidad_archivos_garantias_cliente2, String cantidad_archivos_cliente2, String avalIdQ) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"createNuevoClienteSinAval");
        RequestBody nombre_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreQ);
        RequestBody direccion_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)direccionQ);
        RequestBody telefono_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)telefonoQ);
        RequestBody or_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)otrasReferenciasQ);
        RequestBody garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)garantiasQ);
        RequestBody rutaId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)rutaIdQ);
        RequestBody poblacionId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)poblacionIdQ);
        RequestBody colocadoraId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)colocadoraIdQ);
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_garantias_cliente2);
        RequestBody cantidad_archivos_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_cliente2);
        RequestBody lat = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"0");
        RequestBody lon = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"0");
        String aval_finalId = "";
        if (!avalIdQ.isEmpty()) {
            aval_finalId = avalIdQ;
        }
        RequestBody aval_final = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)aval_finalId);
        Call<ResponseMe> call = retrofitInterface.registrarClienteSolo(archivosGeneral, func, nombre_cliente, direccion_cliente, telefono_cliente, or_cliente, garantias_cliente, rutaId, poblacionId, colocadoraId, cantidad_archivos_garantias_cliente, cantidad_archivos_cliente, lat, lon, aval_final);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    if (response.body() != null && ((ResponseMe)response.body()).getStatus().equals("success")) {
                        String idAntiguo;
                        String clienteId = ((ResponseMe)response.body()).getClienteId();
                        ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                        SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud();
                        if (solicitud != null) {
                            colaSolicitudes.obtenerIndexSolicitudyBorrar();
                            NetworkChangeReceiver.this.isProcessing = false;
                            NetworkChangeReceiver.this.procesarColaSolicitudes();
                        }
                        if ((idAntiguo = NetworkChangeReceiver.this.obtenerIdAntiguoDeSQLite(nombreQ)) != null) {
                            NetworkChangeReceiver.this.actualizarRegistroSQLite(clienteId, nombreQ, idAntiguo);
                        }
                    } else {
                        NetworkChangeReceiver.this.isProcessing = false;
                        NetworkChangeReceiver.this.procesarColaSolicitudes();
                    }
                } else {
                    NetworkChangeReceiver.this.isProcessing = false;
                    NetworkChangeReceiver.this.procesarColaSolicitudes();
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                Log.d((String)"SQLite", (String)("ENTRO EN ERROR INSERT SUBIDA........................" + t.getLocalizedMessage()));
                NetworkChangeReceiver.this.isProcessing = false;
                NetworkChangeReceiver.this.procesarColaSolicitudes();
            }
        });
    }

    private String obtenerIdAntiguoDeSQLite(String nombre) {
        String idAntiguo = null;
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT id FROM clientes WHERE nombre_completo = ?", new String[]{nombre});
        if (cursor.moveToFirst()) {
            idAntiguo = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return idAntiguo;
    }

    private String obtenerIdAntiguoDeSQLiteAval(String nombre) {
        String idAntiguo = null;
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT id FROM avales WHERE nombre_completo = ?", new String[]{nombre});
        if (cursor.moveToFirst()) {
            idAntiguo = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return idAntiguo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NotifyDataSetChanged"})
    private void actualizarRegistroSQLiteAval(String nuevoId, String nombre, String idAntiguo, String clienteIDQ) {
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        try (SQLiteDatabase db = dbHelper.getWritableDatabase();){
            ContentValues valores = new ContentValues();
            valores.put("id", nuevoId);
            valores.put("updated_at", Long.valueOf(System.currentTimeMillis()));
            long resultadoAval = db.update("avales", valores, "id=?", new String[]{idAntiguo});
            if (resultadoAval == -1L) {
                Log.d((String)"SQLite", (String)"Error al actualizar el aval en SQLite.");
            } else {
                Log.d((String)"SQLite", (String)("Aval actualizado con \u00e9xito en SQLite con nuevo ID: " + nuevoId));
                if (AvalesFragment.avales != null && !AvalesFragment.avales.isEmpty()) {
                    Log.d((String)"SQLite", (String)("La lista de avales tiene " + AvalesFragment.avales.size() + " elementos."));
                    for (Aval aval : AvalesFragment.avales) {
                        Log.d((String)"SQLite", (String)("ID actual en la lista: " + aval.getId()));
                        if (!aval.getId().equals(idAntiguo)) continue;
                        aval.setId(nuevoId);
                        Log.d((String)"SQLite", (String)("ID del aval actualizado a: " + nuevoId));
                        break;
                    }
                    new Handler(Looper.getMainLooper()).post(() -> AvalesFragment.avalesAdapter.notifyDataSetChanged());
                } else {
                    Log.d((String)"SQLite", (String)"La lista de avales es null o est\u00e1 vac\u00eda.");
                }
            }
            if (clienteIDQ != null && !clienteIDQ.isEmpty()) {
                ContentValues valoresPrestamo = new ContentValues();
                valoresPrestamo.put("aval_id", nuevoId);
                int resultadoPrestamos = db.update("prestamos", valoresPrestamo, "cliente_id=? AND status=0", new String[]{clienteIDQ});
                if (resultadoPrestamos > 0) {
                    Log.d((String)"SQLite", (String)("Se actualizaron " + resultadoPrestamos + " pr\u00e9stamos con el nuevo ID del aval: " + nuevoId));
                } else {
                    Log.d((String)"SQLite", (String)("No se encontraron pr\u00e9stamos con el ID del aval antiguo: " + idAntiguo));
                }
                ContentValues valoresCliente = new ContentValues();
                valoresCliente.put("aval_id", nuevoId);
                int resultadoCliente = db.update("clientes", valoresCliente, "id=?", new String[]{clienteIDQ});
                if (resultadoCliente > 0) {
                    Log.d((String)"SQLite", (String)"El aval_id se actualiz\u00f3 con \u00e9xito en la tabla clientes.");
                } else {
                    Log.d((String)"SQLite", (String)("No se encontr\u00f3 un cliente con el id: " + clienteIDQ));
                }
                this.CambiarAval(clienteIDQ, nuevoId);
            } else {
                Log.d((String)"SQLite", (String)"clienteIDQ es nulo o vac\u00edo. No se actualiz\u00f3 ni en prestamos ni en clientes.");
            }
        }
    }

    private void CambiarAval(String cliente_id, String aval_id) {
        Log.d((String)"DEBUG", (String)("Cambiando el aval_id EN PRESTAMO.................................. " + aval_id));
        VolleyS vs = VolleyS.getInstance(appContext);
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"CambiarAvalPrestamoClienteAaval");
            data.put("cliente_id", (Object)cliente_id);
            data.put("aval_id", (Object)aval_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"DEBUG", (String)("El aval_id DESPUES de guardar es: " + aval_id));
        Log.d((String)"DEBUG", (String)("El cliente_id DESPUES de guardar es: " + cliente_id));
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Log.d((String)"DEBUG", (String)"El aval_id A SIDO CAMBIANDO CON EXITO EN PRESTAMO.................................. ");
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, appContext);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        requestQueue.add((Request)request);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void actualizarRegistroSQLite(String clienteId, String nombre, String idAntiguo) {
        Log.d((String)"SQLite", (String)"ENTRO EN SUBIDA actualizarRegistroSQLite()...................");
        Log.d((String)"SQLite", (String)("ENTRO EN SUBIDA actualizarRegistroSQLite() idAntiguo:..................." + idAntiguo));
        DatabaseHelper dbHelper = new DatabaseHelper(appContext);
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        ContentValues valores = new ContentValues();
        valores.put("id", clienteId);
        valores.put("nombre_completo", nombre);
        valores.put("updated_at", Long.valueOf(System.currentTimeMillis()));
        long resultado = db.update("clientes", valores, "nombre_completo=?", new String[]{nombre});
        if (resultado == -1L) {
            Log.d((String)"SQLite", (String)"Error al actualizar el cliente en SQLite NETWORKreceiver.");
        } else {
            Log.d((String)"SQLite", (String)("Cliente actualizado con \u00e9xito NETWORKreceiver en SQLite con ID: " + clienteId));
            ContentValues valoresPrestamo = new ContentValues();
            valoresPrestamo.put("cliente_id", clienteId);
            int prestamosActualizados = db.update("prestamos", valoresPrestamo, "cliente_id=?", new String[]{idAntiguo});
            if (prestamosActualizados > 0) {
                Log.d((String)"SQLite", (String)("Se actualizaron " + prestamosActualizados + " pr\u00e9stamos con el nuevo cliente ID: " + clienteId));
            } else {
                Log.d((String)"SQLite", (String)"No se encontraron pr\u00e9stamos para actualizar con el cliente ID antiguo.");
            }
            for (Cliente cliente : ClientesFragment.clientes) {
                if (!cliente.getNombre_completo().equals(nombre)) continue;
                cliente.setId(clienteId);
                break;
            }
            new Handler(Looper.getMainLooper()).post(() -> ClientesFragment.clientesAdapter.notifyDataSetChanged());
        }
        db.close();
    }

    public void subirFotosAv(List<MultipartBody.Part> archivosGeneral, String func2, String aval_id2, String cantidad_archivos_garantias_aval2, String cantidad_archivos_aval2) {
        Log.d((String)"ArchivosJson", (String)"Entro en funcion Solicitud subir fotos en subirFotosAv().................. ");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)func2);
        RequestBody aval_id = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)aval_id2);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_garantias_aval2);
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_aval2);
        if (archivosGeneral == null || archivosGeneral.isEmpty()) {
            return;
        }
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        Call<ResponseMe> call = retrofitInterface.subirFotosA(archivosGeneral, func, aval_id, cantidad_archivos_garantias_aval, cantidad_archivos_aval);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                    SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud();
                    if (solicitud != null) {
                        colaSolicitudes.obtenerIndexSolicitudyBorrar();
                        NetworkChangeReceiver.this.isProcessing = false;
                        NetworkChangeReceiver.this.procesarColaSolicitudes();
                        Log.d((String)"SQLite", (String)"Solicitud eliminada de la cola tras subida exitosa");
                    }
                } else {
                    NetworkChangeReceiver.this.isProcessing = false;
                    NetworkChangeReceiver.this.procesarColaSolicitudes();
                    Log.d((String)"ErrorResponse", (String)("Error en la subida: " + response.message()));
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                NetworkChangeReceiver.this.isProcessing = false;
                NetworkChangeReceiver.this.procesarColaSolicitudes();
            }
        });
    }

    public void subirFotosCl(List<MultipartBody.Part> archivosGeneral, String func2, String cliente_id2, String cantidad_archivos_garantias_cliente2, String cantidad_archivos_cliente2) {
        Log.d((String)"ArchivosJson", (String)("Entro en funcion Solicitud subir fotos en subirFotosCl().................. " + cliente_id2));
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)func2);
        RequestBody cliente_id = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cliente_id2);
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_garantias_cliente2);
        RequestBody cantidad_archivos_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)cantidad_archivos_cliente2);
        if (archivosGeneral == null || archivosGeneral.isEmpty()) {
            return;
        }
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        Call<ResponseMe> call = retrofitInterface.subirFotosCA(archivosGeneral, func, cliente_id, cantidad_archivos_garantias_cliente, cantidad_archivos_cliente);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                if (response.isSuccessful()) {
                    Log.d((String)"response", (String)("subirFotos al recuperar conexion SUCCESS.............." + ((ResponseMe)response.body()).getMessage()));
                    ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
                    SolicitudSubida solicitud = colaSolicitudes.obtenerPrimeraSolicitud();
                    if (solicitud != null) {
                        colaSolicitudes.obtenerIndexSolicitudyBorrar();
                        NetworkChangeReceiver.this.isProcessing = false;
                        NetworkChangeReceiver.this.procesarColaSolicitudes();
                        Log.d((String)"SQLite", (String)"Solicitud eliminada de la cola tras subida exitosa");
                    }
                } else {
                    Log.d((String)"ErrorResponse", (String)("Error en la subida: " + response.message()));
                    NetworkChangeReceiver.this.isProcessing = false;
                    NetworkChangeReceiver.this.procesarColaSolicitudes();
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                NetworkChangeReceiver.this.isProcessing = false;
                NetworkChangeReceiver.this.procesarColaSolicitudes();
            }
        });
    }

    public static interface NetworkChangeListener {
        public void onNetworkChanged(boolean var1);
    }
}

