/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.TextView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.utilities.ErrorChecker;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkSpeedChecker {
    private final Context context;
    private final TextView textViewMensajes;
    private final ScheduledExecutorService scheduler;
    private final Handler handler;
    private boolean wasSlowNetworkPreviously = false;
    private ScheduledFuture<?> scheduledFuture;
    private boolean isRequestInProgress = false;

    public NetworkSpeedChecker(Context context, TextView textViewMensajes) {
        this.context = context;
        this.textViewMensajes = textViewMensajes;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.handler = new Handler(Looper.getMainLooper());
    }

    public void startChecking() {
        if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this::checkNetworkSpeed, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    public void stopChecking() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
    }

    private synchronized void checkNetworkSpeed() {
        if (this.isRequestInProgress) {
            return;
        }
        this.isRequestInProgress = true;
        long startTime = System.currentTimeMillis();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"index");
            data.put("estatus", (Object)"0");
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.isRequestInProgress = false;
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, response -> {
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            if (duration > 5000L) {
                if (!this.wasSlowNetworkPreviously) {
                    this.showSlowNetworkMessage();
                    this.wasSlowNetworkPreviously = true;
                }
            } else if (this.wasSlowNetworkPreviously) {
                this.showGoodNetworkMessage();
                this.wasSlowNetworkPreviously = false;
            }
            this.isRequestInProgress = false;
        }, error -> {
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            ErrorChecker.checker(error, this.context);
            this.isRequestInProgress = false;
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        VolleySingleton.getInstance(this.context.getApplicationContext()).addToRequestQueue(request);
    }

    private void showSlowNetworkMessage() {
        this.handler.post(() -> {
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setTextColor(this.context.getResources().getColor(2131100471));
                this.textViewMensajes.setTextSize(14.0f);
                this.textViewMensajes.setText((CharSequence)"\u00a1Red lenta o intermitente!");
            } else {
                Log.e((String)"NETWORK_SPEED", (String)"TextView es nulo.");
            }
        });
    }

    private void showGoodNetworkMessage() {
        this.handler.post(() -> {
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            } else {
                Log.e((String)"NETWORK_SPEED", (String)"TextView es nulo.");
            }
        });
    }
}

