/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Pago;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PagosWorker
extends Worker {
    private SharedPreferences sesion;
    private final ConnectivityManager connectivityManager;
    public static final int BATCH_SIZE_PAGOS = 999999;
    public static int currentPagePagos = 0;
    public static boolean allDataLoadedPagos = false;
    public static List<Integer> allPagos = new ArrayList<Integer>();
    public static boolean isTaskPagosCompleted = false;

    public PagosWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        this.sesion = context.getSharedPreferences("sesion", 0);
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    @NonNull
    public ListenableWorker.Result doWork() {
        SQLiteDatabase db = null;
        try {
            if (!this.isNetworkAvailable(this.getApplicationContext())) {
                Log.d((String)"PagosWorker", (String)"No internet connection, retrying later.");
                ListenableWorker.Result result = ListenableWorker.Result.retry();
                return result;
            }
            if (!this.isWithinAllowedTime()) {
                Log.d((String)"PagosWorker", (String)"Current time is outside allowed range, retrying later.");
                ListenableWorker.Result result = ListenableWorker.Result.retry();
                return result;
            }
            DatabaseHelper dbHelper = new DatabaseHelper(this.getApplicationContext());
            db = dbHelper.getWritableDatabase();
            if (!allDataLoadedPagos) {
                Log.d((String)"PagosWorker", (String)"Entro en loadAllData PAgos.................................");
                this.loadAllData(db);
            } else {
                Log.d((String)"PagosWorker", (String)"Entro en checkForUpdates de PAgos.................................");
                this.checkForUpdates(this.getApplicationContext(), db);
            }
            this.reprogramarWorker();
            ListenableWorker.Result result = ListenableWorker.Result.success();
            return result;
        }
        catch (Exception e) {
            Log.e((String)"PagosWorker", (String)"Error in doWork", (Throwable)e);
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            return result;
        }
        finally {
            if (isTaskPagosCompleted && db != null && db.isOpen()) {
                db.close();
                Log.d((String)"PagosWorker", (String)"Cerrando conexi\u00f3n a la base de datos EN PAGOS.");
            }
        }
    }

    private void reprogramarWorker() {
        WorkManager.getInstance((Context)this.getApplicationContext()).enqueueUniqueWork("PagosWorker", ExistingWorkPolicy.REPLACE, (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PagosWorker.class).setInitialDelay(15L, TimeUnit.MINUTES)).build());
        Log.d((String)"ClientesWorker", (String)"Worker PagosWorker reprogramado para ejecutarse en 11 minuto.");
    }

    private void loadAllData(SQLiteDatabase db) {
        Context context = this.getApplicationContext();
        if (context == null) {
            return;
        }
        this.sesion = context.getSharedPreferences("sesion", 0);
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"index_app_Pagos");
            JSONArray pagosArray = new JSONArray();
            for (Integer pagoId : allPagos) {
                pagosArray.put((Object)pagoId);
            }
            data.put("PrestamosId", (Object)pagosArray);
            Log.d((String)"PAGOS", (String)("Par\u00e1metros enviados WORKER Pagos: " + data));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, response -> {
            try {
                JSONArray data1 = response.getJSONArray("data");
                ArrayList<Pago> batchPagos = new ArrayList<Pago>();
                for (int i = 0; i < data1.length(); ++i) {
                    JSONObject obj = data1.getJSONObject(i);
                    Gson gson = new Gson();
                    Pago pago = (Pago)gson.fromJson(obj.toString(), Pago.class);
                    batchPagos.add(pago);
                }
                this.insertPagosIntoSQLiteAllData(context, batchPagos, db);
                if (batchPagos.size() < 999999) {
                    allDataLoadedPagos = true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            finally {
                allDataLoadedPagos = true;
            }
        }, error -> {
            Log.e((String)"PAGOS", (String)("Error de red Pagos: " + error.toString()));
            if (error.networkResponse != null && error.networkResponse.data != null) {
                String string2 = new String(error.networkResponse.data);
            } else {
                Log.e((String)"PAGOS", (String)"No se recibi\u00f3 respuesta del servidor.");
            }
            this.handleNetworkError(context);
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPagosIntoSQLiteAllData(Context context, List<Pago> pagos, SQLiteDatabase db) {
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        Log.d((String)"SQLite", (String)"Iniciando inserci\u00f3n masiva en SQLite...");
        int BATCH_SIZE = 500;
        db.beginTransaction();
        try {
            for (int i = 0; i < pagos.size(); i += 500) {
                int end = Math.min(i + 500, pagos.size());
                List<Pago> batch = pagos.subList(i, end);
                for (Pago pago : batch) {
                    ContentValues values = new ContentValues();
                    values.put("id", pago.getId());
                    values.put("prestamo_id", pago.getPrestamo_id());
                    values.put("cantidad_esperada_pago", pago.getCantidad_esperada_pago());
                    values.put("cantidad_normal_pagada", pago.getCantidad_normal_pagada());
                    values.put("cantidad_multa", pago.getCantidad_multa());
                    values.put("cantidad_pendiente", pago.getCantidad_pendiente());
                    values.put("cantidad_total_pagada", pago.getCantidad_total_pagada());
                    values.put("concepto", pago.getConcepto());
                    values.put("fecha_pago", pago.getFecha_pago());
                    values.put("fecha_pago_realizada", pago.getFecha_pago_realizada());
                    values.put("folio", pago.getFolio());
                    values.put("semana", pago.getSemana());
                    values.put("balance", pago.getBalance());
                    values.put("empleado_id", pago.getEmpleado_id() != null ? pago.getEmpleado_id() : "NULL");
                    values.put("status", pago.getStatus());
                    values.put("updated_at", pago.getUpdated_at());
                    values.put("tipo_pago", pago.getTipo_pago());
                    values.put("recuperado", pago.getRecuperado());
                    long newRowId = db.insertWithOnConflict("pagos", null, values, 5);
                    if (newRowId != -1L) continue;
                }
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error durante la inserci\u00f3n masiva: " + e.getMessage()));
        }
        finally {
            db.endTransaction();
            isTaskPagosCompleted = true;
        }
    }

    private void insertPagosIntoSQLite(Context context, List<Pago> pagos, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        try {
            for (Pago pago : pagos) {
                ContentValues values = new ContentValues();
                values.put("id", pago.getId());
                values.put("prestamo_id", pago.getPrestamo_id());
                values.put("cantidad_esperada_pago", pago.getCantidad_esperada_pago());
                values.put("cantidad_normal_pagada", pago.getCantidad_normal_pagada());
                values.put("cantidad_multa", pago.getCantidad_multa());
                values.put("cantidad_pendiente", pago.getCantidad_pendiente());
                values.put("cantidad_total_pagada", pago.getCantidad_total_pagada());
                values.put("concepto", pago.getConcepto());
                values.put("fecha_pago", pago.getFecha_pago());
                values.put("fecha_pago_realizada", pago.getFecha_pago_realizada());
                values.put("folio", pago.getFolio());
                values.put("semana", pago.getSemana());
                values.put("balance", pago.getBalance());
                values.put("empleado_id", pago.getEmpleado_id() != null ? pago.getEmpleado_id() : "NULL");
                values.put("status", pago.getStatus());
                values.put("updated_at", pago.getUpdated_at());
                values.put("tipo_pago", pago.getTipo_pago());
                values.put("recuperado", pago.getRecuperado());
                long newRowId = db.insertWithOnConflict("pagos", null, values, 5);
                remainingComparisons.decrementAndGet();
                if (newRowId != -1L) continue;
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error durante la inserci\u00f3n en lote: " + e.getMessage()));
        }
    }

    private void handleNetworkError(Context context) {
        if (this.isNetworkAvailable(context)) {
            Log.d((String)"PagosWorker", (String)"Network available, resuming work.");
            PagosWorker.enqueueWork(context);
        } else {
            Log.d((String)"PagosWorker", (String)"No network available, stopping work.");
            this.cancelAndRescheduleWork(context);
        }
    }

    private void cancelAndRescheduleWork(Context context) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest retryWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PagosWorker.class).setConstraints(constraints)).setInitialDelay(15L, TimeUnit.MINUTES)).build();
        WorkManager.getInstance((Context)context).enqueue((WorkRequest)retryWorkRequest);
        Log.d((String)"PagosWorker", (String)"Reprogramado trabajo debido a error.");
    }

    private boolean isWithinAllowedTime() {
        Calendar calendar = Calendar.getInstance();
        int hourOfDay = calendar.get(11);
        return hourOfDay >= 7 && hourOfDay <= 22;
    }

    private boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo activeNetworkInfo = this.connectivityManager.getActiveNetworkInfo();
            return activeNetworkInfo != null && activeNetworkInfo.isConnected();
        }
        catch (Exception e) {
            Log.e((String)"PagosWorker", (String)"Error checking network availability", (Throwable)e);
            return false;
        }
    }

    public static void enqueueWork(Context context) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest oneTimeWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PagosWorker.class).setConstraints(constraints)).build();
        WorkManager.getInstance((Context)context.getApplicationContext()).enqueueUniqueWork("PagosWorker", ExistingWorkPolicy.REPLACE, oneTimeWorkRequest);
        Log.d((String)"PagosWorker", (String)"Se ha encolado un OneTimeWorkRequest para PagosWorker.");
    }

    private void insertDatosLocalAlServidor(Context context, Map<String, String> pagoLocal, SQLiteDatabase db, Runnable onComplete) {
        Log.d((String)"PrestamoWorker", (String)"Sending insertDatosLocalAlServidor local data to the server PRESTAMOS...");
        Handler mainHandler = new Handler(Looper.getMainLooper());
        if (context == null) {
            Log.e((String)"PrestamosWorker", (String)"Context is null. Cannot send data to server.");
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        String prestamoIdLocalOK = pagoLocal.get("id");
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"updateFromLocal");
            data.put("prestamo_id", (Object)pagoLocal.get("prestamo_id"));
            data.put("semana", (Object)pagoLocal.get("semana"));
            data.put("tipo_pago", (Object)pagoLocal.get("tipo_pago"));
            data.put("statusPago", (Object)pagoLocal.get("status"));
            data.put("empleado_id", (Object)pagoLocal.get("empleado_id"));
            data.put("concepto", (Object)pagoLocal.get("concepto"));
            data.put("updated_at", (Object)pagoLocal.get("updated_at"));
            data.put("fecha_pago_realizada", (Object)pagoLocal.get("fecha_pago_realizada"));
            data.put("cantidad_normal_pagada", (Object)pagoLocal.get("cantidad_normal_pagada"));
            data.put("cantidad_multa", (Object)pagoLocal.get("cantidad_multa"));
            data.put("folio", (Object)pagoLocal.get("folio"));
            Log.d((String)"PrestamoWorker", (String)("Parametros enviados al servidor: " + data));
        }
        catch (JSONException e) {
            Log.e((String)"PrestamoWorker", (String)("Error al crear JSON para el pr\u00e9stamo: " + e.getMessage()), (Throwable)e);
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        Log.d((String)"PrestamoWorker", (String)("Realizando la solicitud POST al servidor: " + API.urlPagos));
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, response -> {
            Log.d((String)"PrestamoWorker", (String)("Datos locales enviados y respuesta recibida PRESTAMOS: " + response.toString()));
            try {
                JSONObject data2 = response.getJSONObject("data");
                String pagoIdServidor = data2.getString("pago_id");
                Log.d((String)"PrestamoWorker", (String)("ID del pr\u00e9stamo recibido del servidor: " + pagoIdServidor));
                if (pagoIdServidor != null && !pagoIdServidor.isEmpty()) {
                    String prestamoIdLocal = (String)pagoLocal.get("id");
                    Log.d((String)"PrestamoWorker", (String)("Actualizando el pr\u00e9stamo en SQLite con el ID: " + pagoIdServidor));
                    this.updatePagoIdInSQLite(context, prestamoIdLocal, pagoIdServidor, db);
                } else {
                    Log.e((String)"PrestamoWorker", (String)"El servidor no ha devuelto un prestamo_id v\u00e1lido.");
                }
            }
            catch (JSONException e) {
                Log.e((String)"PrestamoWorker", (String)("Error al procesar la respuesta del servidor: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (onComplete != null) {
                    onComplete.run();
                }
            }
        }, error -> mainHandler.post(() -> {
            try {
                String errorMessage = error.getMessage();
                if (error.networkResponse != null) {
                    Log.e((String)"PrestamoWorker", (String)("C\u00f3digo de respuesta del error: " + error.networkResponse.statusCode));
                    String responseBody = new String(error.networkResponse.data, "UTF-8");
                    JSONObject jsonObject = new JSONObject(responseBody);
                    if (jsonObject.has("message")) {
                        String serverMessage = jsonObject.getString("message");
                        Log.e((String)"PrestamoWorker", (String)("Mensaje del servidor: " + serverMessage));
                        if (serverMessage.contains("semana ya registrada")) {
                            this.updatePagoIdInSQLite(context, prestamoIdLocalOK, "", db);
                            Log.i((String)"PrestamoWorker", (String)"Funci\u00f3n updatePagoIdInSQLite ejecutada debido al mensaje del servidor.");
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"PrestamoWorker", (String)"Error al procesar el mensaje de error", (Throwable)e);
            }
            if (onComplete != null) {
                onComplete.run();
            }
        }));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void updatePagoIdInSQLite(Context context, String pagoIdServidor, String idServidor, SQLiteDatabase db) {
        ContentValues values = new ContentValues();
        values.put("sinc", Integer.valueOf(0));
        int rowsUpdatedPrestamos = db.update("pagos", values, "id = ?", new String[]{pagoIdServidor});
        if (rowsUpdatedPrestamos > 0) {
            Log.d((String)"SQLite", (String)"Prestamo actualizado correctamente con el ID del servidor: ");
        } else {
            Log.e((String)"SQLite", (String)"No se pudo actualizar el pr\u00e9stamo en SQLite.");
        }
    }

    private void checkForUpdates(Context context, SQLiteDatabase db) {
        Log.d((String)"PagosWorker", (String)"Checking for updates Pagos...");
        if (context == null) {
            Log.e((String)"PagosWorker", (String)"Context is null, cannot proceed with checkForUpdates.");
            return;
        }
        List<Map<String, String>> pagosPendientes = this.obtenerPagosPendientes(context, db);
        if (!pagosPendientes.isEmpty()) {
            Log.d((String)"PrestamosWorker", (String)("Encontrados " + pagosPendientes.size() + " pago pendientes para enviar al servidor."));
            AtomicInteger tareasPendientes = new AtomicInteger(pagosPendientes.size());
            for (Map<String, String> pago : pagosPendientes) {
                this.insertDatosLocalAlServidor(context, pago, db, () -> {
                    int restantes = tareasPendientes.decrementAndGet();
                    Log.d((String)"PrestamosWorker", (String)("Tareas pendientes: " + restantes));
                    if (restantes == 0) {
                        this.continuarConElRestante(context, db);
                    }
                });
            }
        } else {
            Log.d((String)"PrestamosWorker", (String)"No hay pr\u00e9stamos pendientes de enviar al servidor.");
            this.continuarConElRestante(context, db);
        }
    }

    private void continuarConElRestante(Context context, SQLiteDatabase db) {
        Gson gson = new Gson();
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        List<Pago> localPagos = dbHelper.getLast100PagosFromSQLite();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"index_app_PagosUpd");
            JSONArray pagosArray = new JSONArray();
            for (Integer pagoId : allPagos) {
                pagosArray.put((Object)pagoId);
            }
            data.put("PrestamosId", (Object)pagosArray);
            Log.d((String)"PAGOS", (String)("Parametros enviados WORKER Pagos: " + data));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, response -> {
            try {
                JSONArray data1 = response.getJSONArray("data");
                ArrayList<Pago> newPagos = new ArrayList<Pago>();
                for (int i = 0; i < data1.length(); ++i) {
                    JSONObject obj = data1.getJSONObject(i);
                    Pago pago = (Pago)gson.fromJson(obj.toString(), Pago.class);
                    newPagos.add(pago);
                }
                new SyncTask(context, newPagos, localPagos, db).execute(new Void[0]);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }, error -> Log.e((String)"PagosWorker", (String)("Error en la solicitud de actualizaci\u00f3n de datos de Pagos: " + error.toString())));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void updatePagoInSQLite(Context context, List<Pago> serverPagos, List<Pago> localPagos, SQLiteDatabase db) {
        Log.d((String)"Sync", (String)"Actualizando el pago updatePagoInSQLite.............................");
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        HashMap<String, Pago> serverPagosMap = new HashMap<String, Pago>();
        for (Pago serverPago : serverPagos) {
            serverPagosMap.put(serverPago.getId(), serverPago);
        }
        AtomicInteger remainingComparisons = new AtomicInteger(serverPagos.size());
        block1: for (Pago serverPago : serverPagos) {
            Pago localPago = null;
            for (Pago pago : localPagos) {
                if (!pago.getId().equals(serverPago.getId())) continue;
                localPago = pago;
                break;
            }
            if (localPago != null) {
                String localUpdatedAt = localPago.getUpdated_at();
                if (localUpdatedAt == null || localUpdatedAt.isEmpty()) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        LocalDateTime now = LocalDateTime.now();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                        localUpdatedAt = now.format(formatter);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                        localUpdatedAt = sdf.format(new Date());
                    }
                    ContentValues values = new ContentValues();
                    values.put("updated_at", localUpdatedAt);
                    int rowsUpdated = db.update("pagos", values, "id = ?", new String[]{localPago.getId()});
                    if (rowsUpdated > 0) {
                        Log.d((String)"SQLite", (String)("Updated 'updated_at' for pagos ID: " + localPago.getId()));
                    } else {
                        Log.e((String)"SQLite", (String)("Failed to update 'updated_at' for pagos ID: " + localPago.getId()));
                    }
                }
                if (localUpdatedAt.isEmpty() || this.isNewer(serverPago.getUpdated_at(), localUpdatedAt)) {
                    this.updateValuesInDatabase(db, serverPago, remainingComparisons);
                    continue;
                }
                if (this.isNewer(localUpdatedAt, serverPago.getUpdated_at())) {
                    if (localPago.getCantidad_normal_pagada() != serverPago.getCantidad_normal_pagada() && localPago.getCantidad_multa() != serverPago.getCantidad_multa()) {
                        this.enviarDatosLocalAlServidor(context, localPago, db, remainingComparisons);
                        continue;
                    }
                    remainingComparisons.decrementAndGet();
                    continue;
                }
                remainingComparisons.decrementAndGet();
                continue;
            }
            boolean existePagoConMismaSemana = false;
            for (Pago localPagoCheck : localPagos) {
                if (!localPagoCheck.getPrestamo_id().equals(serverPago.getPrestamo_id()) || !localPagoCheck.getSemana().equals(serverPago.getSemana())) continue;
                existePagoConMismaSemana = true;
                break;
            }
            if (!existePagoConMismaSemana) {
                this.insertPagosIntoSQLite(context, Collections.singletonList(serverPago), db, remainingComparisons);
                continue;
            }
            for (Pago localPagoCheck : localPagos) {
                if (!localPagoCheck.getPrestamo_id().equals(serverPago.getPrestamo_id()) || !localPagoCheck.getSemana().equals(serverPago.getSemana())) continue;
                localPagoCheck.setId(serverPago.getId());
                this.updatePagoInSQLite(db, localPagoCheck);
                remainingComparisons.decrementAndGet();
                continue block1;
            }
        }
        Log.d((String)"Sync", (String)("Actualizando remainingComparisons............................." + remainingComparisons));
    }

    private void updatePagoInSQLite(SQLiteDatabase db, Pago pago) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", pago.getId());
        db.update("Pagos", contentValues, "prestamo_id = ? AND semana = ?", new String[]{pago.getPrestamo_id(), pago.getSemana()});
    }

    private void enviarDatosLocalAlServidor(Context context, final Pago localPago, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        Log.d((String)"PagoWorker", (String)"Sending PAGOS local data to the server...");
        Handler mainHandler = new Handler(Looper.getMainLooper());
        if (context == null) {
            Log.e((String)"PagosWorker", (String)"Context is null. Cannot send data to server.");
            return;
        }
        final JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"updateFromLocal");
            data.put("prestamo_id", (Object)localPago.getPrestamo_id());
            data.put("semana", (Object)localPago.getSemana());
            data.put("tipo_pago", (Object)localPago.getTipo_pago());
            data.put("statusPago", (Object)localPago.getStatus());
            data.put("empleado_id", (Object)localPago.getEmpleado_id());
            data.put("concepto", (Object)localPago.getConcepto());
            data.put("updated_at", (Object)localPago.getUpdated_at());
            data.put("fecha_pago_realizada", (Object)localPago.getFecha_pago_realizada());
            data.put("cantidad_normal_pagada", (Object)localPago.getCantidad_normal_pagada());
            data.put("cantidad_multa", (Object)localPago.getCantidad_multa());
            data.put("folio", (Object)localPago.getFolio());
            remainingComparisons.decrementAndGet();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        StringRequest stringRequest = new StringRequest(1, API.urlPagos, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"PagoWorker", (String)("Respuesta del servidor: " + response));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.e((String)"Volley Error", (String)("Error occurred while sending request: " + error.toString()));
                if (error.networkResponse != null) {
                    Log.e((String)"Volley Error", (String)("C\u00f3digo de estado: " + error.networkResponse.statusCode));
                    String errorMessage = new String(error.networkResponse.data);
                    Log.e((String)"Volley Error", (String)("Respuesta del servidor enviarDatosLocalAlServidor con id:" + localPago.getPrestamo_id() + " SEMANA: " + localPago.getSemana() + " ERROR: " + errorMessage));
                }
            }
        }){

            public byte[] getBody() {
                return data.toString().getBytes(StandardCharsets.UTF_8);
            }

            public String getBodyContentType() {
                return "application/json; charset=utf-8";
            }
        };
        RequestQueue requestQueue = Volley.newRequestQueue((Context)context);
        requestQueue.add((Request)stringRequest);
        isTaskPagosCompleted = true;
    }

    private void updateValuesInDatabase(SQLiteDatabase db, Pago pago, AtomicInteger remainingComparisons) {
        ContentValues values = new ContentValues();
        values.put("id", pago.getId());
        values.put("prestamo_id", pago.getPrestamo_id());
        values.put("cantidad_esperada_pago", pago.getCantidad_esperada_pago());
        values.put("cantidad_normal_pagada", pago.getCantidad_normal_pagada());
        values.put("cantidad_multa", pago.getCantidad_multa());
        values.put("cantidad_pendiente", pago.getCantidad_pendiente());
        values.put("cantidad_total_pagada", pago.getCantidad_total_pagada());
        values.put("concepto", pago.getConcepto());
        values.put("fecha_pago", pago.getFecha_pago());
        values.put("fecha_pago_realizada", pago.getFecha_pago_realizada());
        values.put("folio", pago.getFolio());
        values.put("semana", pago.getSemana());
        values.put("balance", pago.getBalance());
        values.put("empleado_id", pago.getEmpleado_id());
        values.put("status", pago.getStatus());
        values.put("updated_at", pago.getUpdated_at());
        values.put("tipo_pago", pago.getTipo_pago());
        values.put("recuperado", pago.getRecuperado());
        int rowsUpdated = db.update("pagos", values, "id=?", new String[]{String.valueOf(pago.getId())});
        remainingComparisons.decrementAndGet();
        if (rowsUpdated > 0) {
            Log.d((String)"SQLite", (String)("Registro actualizado correctamente pagos: ID = " + pago.getId()));
        } else {
            Log.e((String)"SQLite", (String)"Error al actualizar el registro. ID no encontrado o fallo en la base de datos.");
        }
    }

    private boolean isNewer(String serverDate, String localDate) {
        if (serverDate == null || localDate == null || serverDate.isEmpty() || localDate.isEmpty()) {
            Log.e((String)"isNewer", (String)("Una de las fechas es nula o vac\u00eda: serverDate=" + serverDate + ", localDate=" + localDate));
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        try {
            Date server = sdf.parse(serverDate);
            Date local = sdf.parse(localDate);
            return server != null && local != null && server.after(local);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    @SuppressLint(value={"Range"})
    private List<Map<String, String>> obtenerPagosPendientes(Context context, SQLiteDatabase db) {
        ArrayList<Map<String, String>> pagosPendientes = new ArrayList<Map<String, String>>();
        String query = "SELECT * FROM pagos WHERE sinc = 1";
        Cursor cursor = db.rawQuery(query, null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                HashMap<String, String> pago = new HashMap<String, String>();
                pago.put("id", cursor.getString(cursor.getColumnIndex("id")));
                pago.put("prestamo_id", cursor.getString(cursor.getColumnIndex("prestamo_id")));
                pago.put("cantidad_esperada_pago", cursor.getString(cursor.getColumnIndex("cantidad_esperada_pago")));
                pago.put("cantidad_normal_pagada", cursor.getString(cursor.getColumnIndex("cantidad_normal_pagada")));
                pago.put("cantidad_multa", cursor.getString(cursor.getColumnIndex("cantidad_multa")));
                pago.put("cantidad_pendiente", cursor.getString(cursor.getColumnIndex("cantidad_pendiente")));
                pago.put("cantidad_total_pagada", cursor.getString(cursor.getColumnIndex("cantidad_total_pagada")));
                pago.put("concepto", cursor.getString(cursor.getColumnIndex("concepto")));
                pago.put("fecha_pago", cursor.getString(cursor.getColumnIndex("fecha_pago")));
                pago.put("fecha_pago_realizada", cursor.getString(cursor.getColumnIndex("fecha_pago_realizada")));
                pago.put("folio", cursor.getString(cursor.getColumnIndex("folio")));
                pago.put("semana", cursor.getString(cursor.getColumnIndex("semana")));
                pago.put("balance", cursor.getString(cursor.getColumnIndex("balance")));
                pago.put("empleado_id", cursor.getString(cursor.getColumnIndex("empleado_id")));
                pago.put("status", cursor.getString(cursor.getColumnIndex("status")));
                pago.put("updated_at", cursor.getString(cursor.getColumnIndex("updated_at")));
                pago.put("tipo_pago", cursor.getString(cursor.getColumnIndex("tipo_pago")));
                pago.put("recuperado", cursor.getString(cursor.getColumnIndex("recuperado")));
                pago.put("sinc", cursor.getString(cursor.getColumnIndex("sinc")));
                pagosPendientes.add(pago);
            } while (cursor.moveToNext());
        }
        return pagosPendientes;
    }

    private class SyncTask
    extends AsyncTask<Void, Void, Void> {
        private Context context;
        private SQLiteDatabase db;
        private List<Pago> serverPagos;
        private List<Pago> localPagos;

        public SyncTask(Context context, List<Pago> serverPagos, List<Pago> localPagos, SQLiteDatabase db) {
            this.context = context;
            this.db = db;
            this.serverPagos = serverPagos;
            this.localPagos = localPagos;
        }

        protected Void doInBackground(Void ... voids) {
            PagosWorker.this.updatePagoInSQLite(this.context, this.serverPagos, this.localPagos, this.db);
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
            isTaskPagosCompleted = true;
        }
    }
}

