/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Prestamo;
import com.google.gson.Gson;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PrestamosWorker
extends Worker {
    private SharedPreferences sesion;
    private final ConnectivityManager connectivityManager;
    public static final int BATCH_SIZE_PRESTAMOS = 999999;
    public static int currentPagePrestamos = 0;
    public static boolean allDataLoadedPrestamos = false;
    public static List<Prestamo> allPrestamos = new ArrayList<Prestamo>();
    public static boolean isTaskPrestamosCompleted = false;

    public PrestamosWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        this.sesion = context.getSharedPreferences("sesion", 0);
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    @NonNull
    public ListenableWorker.Result doWork() {
        SQLiteDatabase db = null;
        try {
            if (!this.isNetworkAvailable(this.getApplicationContext())) {
                Log.d((String)"PrestamosWorker", (String)"No internet connection, retrying later.");
                ListenableWorker.Result result = ListenableWorker.Result.failure();
                return result;
            }
            if (!this.isWithinAllowedTime()) {
                Log.d((String)"PrestamosWorker", (String)"Current time is outside allowed range, retrying later.");
                ListenableWorker.Result result = ListenableWorker.Result.failure();
                return result;
            }
            DatabaseHelper dbHelper = new DatabaseHelper(this.getApplicationContext());
            db = dbHelper.getWritableDatabase();
            if (!allDataLoadedPrestamos) {
                this.loadAllData(db);
                Log.d((String)"PrestamosWorker", (String)"ENTRO EN CARGAR TODOS LOS DATOS Prestamos........................");
            } else {
                this.checkForUpdates(this.getApplicationContext(), db);
                Log.d((String)"ClientesWorker", (String)"ENTRO EN ACTUALIZAR TODOS LOS DATOS Prestamos.......................");
            }
            this.reprogramarWorker();
            ListenableWorker.Result result = ListenableWorker.Result.success();
            return result;
        }
        catch (Exception e) {
            Log.e((String)"PrestamosWorker", (String)"Error in doWork", (Throwable)e);
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            return result;
        }
        finally {
            if (isTaskPrestamosCompleted && db != null && db.isOpen()) {
                db.close();
            }
        }
    }

    private void reprogramarWorker() {
        WorkManager.getInstance((Context)this.getApplicationContext()).enqueueUniqueWork("PrestamosWorker", ExistingWorkPolicy.REPLACE, (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PrestamosWorker.class).setInitialDelay(10L, TimeUnit.MINUTES)).build());
        Log.d((String)"AvalesWorker", (String)"Worker PrestamosWorker reprogramado para ejecutarse en 9 minuto.");
    }

    private void loadAllData(SQLiteDatabase db) {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        Context context = this.getApplicationContext();
        if (context == null) {
            Log.e((String)"PrestamosWorker", (String)"Contexto es nulo. No se puede cargar la data.");
            return;
        }
        this.sesion = context.getSharedPreferences("sesion", 0);
        JSONObject data = new JSONObject();
        try {
            String nombrePerfil;
            data.put("page", currentPagePrestamos);
            data.put("size", 999999);
            switch (nombrePerfil = this.sesion.getString("nombre_perfil", "")) {
                case "COBRADOR": 
                case "GESTOR": {
                    data.put("func", (Object)"prestamosConSemanasSinPagar");
                    break;
                }
                case "JURIDICO": {
                    data.put("func", (Object)"prestamosConSemanasSinPagar");
                    data.put("estatus", (Object)"4");
                    break;
                }
                default: {
                    data.put("func", (Object)"index_app_lotes");
                    data.put("estatus", (Object)"0");
                }
            }
            Log.d((String)"PRESTAMOS", (String)("Par\u00e1metros enviados WORKER Prestamos: " + data));
        }
        catch (JSONException e) {
            Log.e((String)"PrestamosWorker", (String)"Error construyendo JSON", (Throwable)e);
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, response -> {
            try {
                JSONArray data1 = response.getJSONArray("data");
                ArrayList<Prestamo> prestamosBatch = new ArrayList<Prestamo>();
                for (int i = 0; i < data1.length(); ++i) {
                    JSONObject obj = data1.getJSONObject(i);
                    Gson gson = new Gson();
                    Prestamo prestamo = (Prestamo)gson.fromJson(obj.toString(), Prestamo.class);
                    prestamosBatch.add(prestamo);
                }
                for (Prestamo prestamo : prestamosBatch) {
                    Log.d((String)"PRESTAMOS", (String)("\ud83d\udcc4 Pr\u00e9stamo a insertar: Tarjet\u00f3n: " + prestamo.getNumero_tarjeton() + ", Updated_at: " + prestamo.getUpdated_at() + ", Id Prestamo: " + prestamo.getId() + ", Nombre_completo: " + prestamo.getNombre_completo()));
                }
                this.insertPrestamoIntoSQLiteAllData(context, prestamosBatch, db);
                if (prestamosBatch.size() < 999999) {
                    allDataLoadedPrestamos = true;
                }
            }
            catch (JSONException e) {
                Log.e((String)"PrestamosWorker", (String)"Error procesando respuesta JSON", (Throwable)e);
            }
        }, error -> mainHandler.post(() -> this.handleNetworkError(context)));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPrestamoIntoSQLiteAllData(Context context, List<Prestamo> prestamos, SQLiteDatabase db) {
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        try {
            for (Prestamo prestamo : prestamos) {
                ContentValues values = new ContentValues();
                values.put("id", prestamo.getId());
                values.put("cliente_id", prestamo.getCliente_id());
                values.put("direccion_cliente", prestamo.getDireccion_cliente());
                values.put("telefono_cliente", prestamo.getTelefono_cliente());
                values.put("ruta_id", prestamo.getRuta_id());
                values.put("poblacion_id", prestamo.getPoblacion_id());
                values.put("colocadora_id", prestamo.getColocadora_id());
                values.put("aval_id", prestamo.getAval_id());
                values.put("grupo_poblacion", prestamo.getGrupo_poblacion() != null ? prestamo.getGrupo_poblacion() : "NULLOO");
                values.put("monto_prestado", prestamo.getMonto_prestado() != null ? prestamo.getMonto_prestado() : "NULLOO");
                values.put("pago_semanal", prestamo.getPago_semanal() != null ? prestamo.getPago_semanal() : "NULLOO");
                values.put("fecha_prestamo", prestamo.getFecha_prestamo());
                values.put("modalidad_semanas", prestamo.getModalidad_semanas());
                values.put("numero_tarjeton", prestamo.getNumero_tarjeton());
                values.put("status", prestamo.getStatus());
                values.put("created_at", prestamo.getCreated_at());
                values.put("updated_at", prestamo.getUpdated_at());
                Cursor cursor = db.rawQuery("SELECT id FROM prestamos WHERE id = ?", new String[]{String.valueOf(prestamo.getId())});
                cursor.close();
                long newRowId = db.insertWithOnConflict("prestamos", null, values, 4);
                if (newRowId == -1L) {
                    db.update("prestamos", values, "id = ?", new String[]{prestamo.getId()});
                    continue;
                }
                Log.d((String)"SQLite", (String)("\u2705 Pr\u00e9stamo insertado en BD: Tarjet\u00f3n: " + prestamo.getNumero_tarjeton() + ", Id: " + prestamo.getId() + ", Nombre: " + prestamo.getNombre_completo()));
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)"Error durante la inserci\u00f3n en lote", (Throwable)e);
        }
        finally {
            isTaskPrestamosCompleted = true;
        }
    }

    private void handleNetworkError(Context context) {
        if (this.isNetworkAvailable(context)) {
            PrestamosWorker.enqueueWork(context);
        } else {
            this.cancelAndRescheduleWork(context);
        }
    }

    private void cancelAndRescheduleWork(Context context) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest retryWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PrestamosWorker.class).setConstraints(constraints)).setInitialDelay(10L, TimeUnit.MINUTES)).build();
        WorkManager.getInstance((Context)context).enqueue((WorkRequest)retryWorkRequest);
        Log.d((String)"PrestamosWorker", (String)"Reprogramado trabajo debido a error.");
    }

    private boolean isWithinAllowedTime() {
        Calendar calendar = Calendar.getInstance();
        int hourOfDay = calendar.get(11);
        return hourOfDay >= 7 && hourOfDay <= 22;
    }

    private boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo activeNetworkInfo = this.connectivityManager.getActiveNetworkInfo();
            return activeNetworkInfo != null && activeNetworkInfo.isConnected();
        }
        catch (Exception e) {
            Log.e((String)"PrestamosWorker", (String)"Error checking network availability", (Throwable)e);
            return false;
        }
    }

    public static void enqueueWork(Context context) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest oneTimeWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PrestamosWorker.class).setConstraints(constraints)).build();
        WorkManager.getInstance((Context)context.getApplicationContext()).enqueueUniqueWork("PrestamosWorker", ExistingWorkPolicy.REPLACE, oneTimeWorkRequest);
        Log.d((String)"PrestamosWorker", (String)"Se ha encolado un OneTimeWorkRequest para PrestamosWorker.");
    }

    private void checkForUpdates(Context context, SQLiteDatabase db) {
        if (context == null) {
            Log.e((String)"PrestamosWorker", (String)"Context is null, cannot proceed with checkForUpdates.");
            return;
        }
        List<Map<String, String>> prestamosPendientes = this.obtenerPrestamosPendientes(context, db);
        if (!prestamosPendientes.isEmpty()) {
            Log.d((String)"PrestamosWorker", (String)("Encontrados " + prestamosPendientes.size() + " pr\u00e9stamos pendientes para enviar al servidor."));
            for (Map<String, String> prestamo : prestamosPendientes) {
                this.insertDatosLocalAlServidor(context, prestamo, db);
            }
        } else {
            Log.d((String)"PrestamosWorker", (String)"No hay pr\u00e9stamos pendientes de enviar al servidor.");
        }
        Gson gson = new Gson();
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        List<Prestamo> localPrestamos = dbHelper.getLast40PrestamosFromSQLite();
        JSONObject data = new JSONObject();
        try {
            String nombrePerfil;
            switch (nombrePerfil = this.sesion.getString("nombre_perfil", "")) {
                case "COBRADOR": 
                case "GESTOR": {
                    data.put("func", (Object)"prestamosConSemanasSinPagar");
                    break;
                }
                case "JURIDICO": {
                    data.put("func", (Object)"prestamosConSemanasSinPagar");
                    data.put("estatus", (Object)"4");
                    break;
                }
                default: {
                    data.put("func", (Object)"indexApp_Upd");
                    data.put("estatus", (Object)"0");
                    break;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, response -> {
            try {
                JSONArray data1 = response.getJSONArray("data");
                ArrayList<Prestamo> newPrestamos = new ArrayList<Prestamo>();
                for (int i = 0; i < data1.length(); ++i) {
                    JSONObject obj = data1.getJSONObject(i);
                    Prestamo prestamo = (Prestamo)gson.fromJson(obj.toString(), Prestamo.class);
                    newPrestamos.add(prestamo);
                }
                this.updatePrestamoInSQLite(context, newPrestamos, localPrestamos, db);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }, error -> Log.e((String)"PrestamosWorker", (String)("Error en la solicitud de actualizaci\u00f3n de datos de prestamos: " + error.toString())));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void updatePrestamoInSQLite(Context context, List<Prestamo> serverData, List<Prestamo> localPrestamos, SQLiteDatabase db) {
        if (!db.isOpen()) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            db = dbHelper.getWritableDatabase();
        }
        for (Prestamo object : serverData) {
        }
        HashSet<String> localPrestamoIds = new HashSet<String>();
        for (Prestamo localPrestamo : localPrestamos) {
            localPrestamoIds.add(localPrestamo.getNumero_tarjeton());
        }
        AtomicInteger atomicInteger = new AtomicInteger(serverData.size());
        for (Prestamo serverPrestamo : serverData) {
            if (localPrestamoIds.contains(serverPrestamo.getNumero_tarjeton())) {
                Prestamo localPrestamo = null;
                for (Prestamo prestamo : localPrestamos) {
                    if (!prestamo.getNumero_tarjeton().equals(serverPrestamo.getNumero_tarjeton())) continue;
                    localPrestamo = prestamo;
                    break;
                }
                if (localPrestamo == null) continue;
                String localUpdatedAt = localPrestamo.getUpdated_at();
                String serverUpdatedAt = serverPrestamo.getUpdated_at();
                if (localUpdatedAt == null || localUpdatedAt.isEmpty()) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        LocalDateTime now = LocalDateTime.now();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                        localUpdatedAt = now.format(formatter);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                        localUpdatedAt = sdf.format(new Date());
                    }
                    ContentValues values = new ContentValues();
                    values.put("updated_at", localUpdatedAt);
                    int rowsUpdated = db.update("prestamos", values, "id = ?", new String[]{localPrestamo.getId()});
                    if (rowsUpdated > 0) {
                        Log.d((String)"SQLite", (String)("Updated 'updated_at' for prestamos ID: " + localPrestamo.getId()));
                    } else {
                        Log.e((String)"SQLite", (String)("Failed to update 'updated_at' for prestamos ID: " + localPrestamo.getId()));
                    }
                }
                if (localUpdatedAt.isEmpty() || this.isNewer(serverUpdatedAt, localUpdatedAt)) {
                    this.updateValuesInDatabase(db, serverPrestamo, atomicInteger);
                    continue;
                }
                if (this.isNewer(localUpdatedAt, serverUpdatedAt)) {
                    this.enviarDatosLocalAlServidor(context, localPrestamo, db, atomicInteger);
                    continue;
                }
                atomicInteger.decrementAndGet();
                continue;
            }
            this.insertPrestamoIntoSQLite(context, Collections.singletonList(serverPrestamo), db, atomicInteger);
        }
        if (atomicInteger.get() == 0) {
            isTaskPrestamosCompleted = true;
        }
    }

    private void insertPrestamoIntoSQLite(Context context, List<Prestamo> prestamos, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        try {
            for (Prestamo prestamo : prestamos) {
                ContentValues values = new ContentValues();
                values.put("id", prestamo.getId());
                values.put("cliente_id", prestamo.getCliente_id());
                values.put("direccion_cliente", prestamo.getDireccion_cliente());
                values.put("telefono_cliente", prestamo.getTelefono_cliente());
                values.put("ruta_id", prestamo.getRuta_id());
                values.put("poblacion_id", prestamo.getPoblacion_id());
                values.put("colocadora_id", prestamo.getColocadora_id());
                values.put("aval_id", prestamo.getAval_id());
                values.put("grupo_poblacion", prestamo.getGrupo_poblacion() != null ? prestamo.getGrupo_poblacion() : "NULLOO");
                values.put("monto_prestado", prestamo.getMonto_prestado() != null ? prestamo.getMonto_prestado() : "NULLOO");
                values.put("pago_semanal", prestamo.getPago_semanal() != null ? prestamo.getPago_semanal() : "NULLOO");
                values.put("fecha_prestamo", prestamo.getFecha_prestamo());
                values.put("modalidad_semanas", prestamo.getModalidad_semanas());
                values.put("numero_tarjeton", prestamo.getNumero_tarjeton());
                values.put("status", prestamo.getStatus());
                values.put("created_at", prestamo.getCreated_at());
                values.put("updated_at", prestamo.getUpdated_at());
                long newRowId = db.insertWithOnConflict("prestamos", null, values, 4);
                remainingComparisons.decrementAndGet();
                if (newRowId != -1L) continue;
                db.update("prestamos", values, "id = ?", new String[]{prestamo.getId()});
            }
        }
        catch (Exception e) {
            remainingComparisons.decrementAndGet();
            Log.e((String)"SQLite", (String)"Error durante la inserci\u00f3n en lote", (Throwable)e);
        }
    }

    private void enviarDatosLocalAlServidor(Context context, Prestamo prestamoLocal, SQLiteDatabase db, AtomicInteger remainingComparisons) {
        Log.d((String)"PrestamoWorker", (String)"Sending local data to the server PRESTAMOS...");
        Handler mainHandler = new Handler(Looper.getMainLooper());
        if (context == null) {
            Log.e((String)"PrestamosWorker", (String)"Context is null. Cannot send data to server.");
            return;
        }
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"updateFromLocal");
            data.put("id", (Object)prestamoLocal.getId());
            data.put("aval_id", (Object)prestamoLocal.getAval_id());
            data.put("updated_at", (Object)prestamoLocal.getUpdated_at());
            Log.d((String)"PRESTSMOS", (String)("Parametros PRESTAMOS enviados al servidor para actualizar: " + data));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, response -> {
            remainingComparisons.decrementAndGet();
            Log.d((String)"PrestamosWorker", (String)("Datos locales enviados y respuesta recibida PRESTAMOS: " + response.toString()));
        }, error -> mainHandler.post(() -> {
            String errorMessage = error.getMessage();
            Log.e((String)"PrestamosWorker", (String)("ERROR occurred al enviar datos locales Prestamos: " + errorMessage), (Throwable)error);
            remainingComparisons.decrementAndGet();
            if (error.networkResponse != null) {
                Log.e((String)"PrestamosWorker", (String)("ERROR C\u00f3digo de estado PRESTAMOS: " + error.networkResponse.statusCode));
            }
        }));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    @SuppressLint(value={"Range"})
    private List<Map<String, String>> obtenerPrestamosPendientes(Context context, SQLiteDatabase db) {
        ArrayList<Map<String, String>> prestamosPendientes = new ArrayList<Map<String, String>>();
        String query = "SELECT * FROM prestamos WHERE status = 8";
        Cursor cursor = db.rawQuery(query, null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                HashMap<String, String> prestamo = new HashMap<String, String>();
                prestamo.put("id", cursor.getString(cursor.getColumnIndex("id")));
                prestamo.put("cliente_id", cursor.getString(cursor.getColumnIndex("cliente_id")));
                prestamo.put("aval_id", cursor.getString(cursor.getColumnIndex("aval_id")));
                prestamo.put("monto_prestado", cursor.getString(cursor.getColumnIndex("monto_prestado")));
                prestamo.put("pago_semanal", cursor.getString(cursor.getColumnIndex("pago_semanal")));
                prestamo.put("fecha_prestamo", cursor.getString(cursor.getColumnIndex("fecha_prestamo")));
                prestamo.put("modalidad_semanas", cursor.getString(cursor.getColumnIndex("modalidad_semanas")));
                prestamo.put("numero_tarjeton", cursor.getString(cursor.getColumnIndex("numero_tarjeton")));
                prestamo.put("grupo_poblacion", cursor.getString(cursor.getColumnIndex("grupo_poblacion")));
                prestamo.put("status", cursor.getString(cursor.getColumnIndex("status")));
                prestamosPendientes.add(prestamo);
            } while (cursor.moveToNext());
        }
        return prestamosPendientes;
    }

    private void insertDatosLocalAlServidor(Context context, Map<String, String> prestamoLocal, SQLiteDatabase db) {
        Log.d((String)"PrestamoWorker", (String)"Sending insertDatosLocalAlServidor local data to the server PRESTAMOS...");
        Handler mainHandler = new Handler(Looper.getMainLooper());
        if (context == null) {
            Log.e((String)"PrestamosWorker", (String)"Context is null. Cannot send data to server.");
            return;
        }
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"create");
            data.put("cliente_id", (Object)prestamoLocal.get("cliente_id"));
            data.put("aval_id", (Object)prestamoLocal.get("aval_id"));
            data.put("grupo", (Object)prestamoLocal.get("grupo_poblacion"));
            data.put("monto_prestado", (Object)prestamoLocal.get("monto_prestado"));
            data.put("pago_semanal", (Object)prestamoLocal.get("pago_semanal"));
            data.put("fecha_prestamo", (Object)prestamoLocal.get("fecha_prestamo"));
            data.put("modalidad", (Object)prestamoLocal.get("modalidad_semanas"));
            data.put("tarjeton", (Object)prestamoLocal.get("numero_tarjeton"));
            Log.d((String)"PrestamoWorker", (String)("Parametros enviados al servidor: " + data));
        }
        catch (JSONException e) {
            Log.e((String)"PrestamoWorker", (String)("Error al crear JSON para el pr\u00e9stamo: " + e.getMessage()), (Throwable)e);
            return;
        }
        Log.d((String)"PrestamoWorker", (String)("Realizando la solicitud POST al servidor: " + API.urlPrestamos));
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, response -> {
            Log.d((String)"PrestamoWorker", (String)("Datos locales enviados y respuesta recibida PRESTAMOS: " + response.toString()));
            try {
                JSONObject data2 = response.getJSONObject("data");
                String prestamoIdServidor = data2.getString("prestamo_id");
                Log.d((String)"PrestamoWorker", (String)("ID del pr\u00e9stamo recibido del servidor: " + prestamoIdServidor));
                if (prestamoIdServidor != null && !prestamoIdServidor.isEmpty()) {
                    String prestamoIdLocal = (String)prestamoLocal.get("id");
                    Log.d((String)"PrestamoWorker", (String)("Actualizando el pr\u00e9stamo en SQLite con el ID: " + prestamoIdServidor));
                    this.updatePrestamoIdInSQLite(context, prestamoIdLocal, prestamoIdServidor, db);
                } else {
                    Log.e((String)"PrestamoWorker", (String)"El servidor no ha devuelto un prestamo_id v\u00e1lido.");
                }
            }
            catch (JSONException e) {
                Log.e((String)"PrestamoWorker", (String)("Error al procesar la respuesta del servidor: " + e.getMessage()), (Throwable)e);
            }
        }, error -> mainHandler.post(() -> {
            String errorMessage = error.getMessage();
            Log.e((String)"PrestamoWorker", (String)("ERROR al enviar datos locales Prestamos: " + errorMessage), (Throwable)error);
            if (error.networkResponse != null) {
                Log.e((String)"PrestamoWorker", (String)("C\u00f3digo de respuesta del error: " + error.networkResponse.statusCode));
            }
        }));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        VolleySingleton.getInstance(context.getApplicationContext()).addToRequestQueue(request);
    }

    private void updatePrestamoIdInSQLite(Context context, String prestamoIdServidor, String idServidor, SQLiteDatabase db) {
        ContentValues values = new ContentValues();
        values.put("id", idServidor);
        values.put("status", Integer.valueOf(0));
        int rowsUpdatedPrestamos = db.update("prestamos", values, "id = ?", new String[]{prestamoIdServidor});
        if (rowsUpdatedPrestamos > 0) {
            Log.d((String)"SQLite", (String)("Prestamo actualizado correctamente con el ID del servidor: " + idServidor));
        } else {
            Log.e((String)"SQLite", (String)"No se pudo actualizar el pr\u00e9stamo en SQLite.");
        }
        ContentValues paymentValues = new ContentValues();
        paymentValues.put("prestamo_id", idServidor);
        int rowsUpdatedPagos = db.update("pagos", paymentValues, "prestamo_id = ?", new String[]{prestamoIdServidor});
        if (rowsUpdatedPagos > 0) {
            Log.d((String)"SQLite", (String)("Pagos actualizados correctamente con el nuevo prestamo_id: " + idServidor));
        } else {
            Log.e((String)"SQLite", (String)"No se pudo actualizar los pagos en SQLite.");
        }
    }

    private void updateValuesInDatabase(SQLiteDatabase db, Prestamo prestamo, AtomicInteger remainingComparisons) {
        ContentValues values = new ContentValues();
        values.put("id", prestamo.getId());
        values.put("cliente_id", prestamo.getCliente_id());
        values.put("direccion_cliente", prestamo.getDireccion_cliente());
        values.put("telefono_cliente", prestamo.getTelefono_cliente());
        values.put("ruta_id", prestamo.getRuta_id());
        values.put("poblacion_id", prestamo.getPoblacion_id());
        values.put("colocadora_id", prestamo.getColocadora_id());
        values.put("aval_id", prestamo.getAval_id());
        values.put("grupo_poblacion", prestamo.getGrupo_poblacion());
        values.put("monto_prestado", prestamo.getMonto_prestado());
        values.put("pago_semanal", prestamo.getPago_semanal());
        values.put("fecha_prestamo", prestamo.getFecha_prestamo());
        values.put("modalidad_semanas", prestamo.getModalidad_semanas());
        values.put("numero_tarjeton", prestamo.getNumero_tarjeton());
        values.put("status", prestamo.getStatus());
        values.put("created_at", prestamo.getCreated_at());
        values.put("updated_at", prestamo.getUpdated_at());
        int rowsUpdated = db.update("prestamos", values, "id=?", new String[]{String.valueOf(prestamo.getId())});
        remainingComparisons.decrementAndGet();
        if (rowsUpdated > 0) {
            Log.d((String)"SQLite", (String)("Registro actualizado correctamente prestamos: ID = " + prestamo.getId()));
        } else {
            Log.e((String)"SQLite", (String)"Error al actualizar el registro. ID no encontrado o fallo en la base de datos.");
        }
    }

    private boolean isNewer(String serverDate, String localDate) {
        if (serverDate == null || localDate == null || serverDate.isEmpty() || localDate.isEmpty()) {
            Log.e((String)"isNewer", (String)("Una de las fechas es nula o vac\u00eda: serverDate=" + serverDate + ", localDate=" + localDate));
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        try {
            Date server = sdf.parse(serverDate);
            Date local = sdf.parse(localDate);
            return server != null && local != null && server.after(local);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }
}

