/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app;

import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.RelativeLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.RegistroCredito;
import com.example.sefinsa_app.utilities.HorizontalScroll;
import com.example.sefinsa_app.utilities.VerticalScroll;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TableActivity
extends AppCompatActivity
implements HorizontalScroll.ScrollViewListener,
VerticalScroll.ScrollViewListener {
    private ArrayList<RegistroCredito> pagos;
    private ArrayList<RegistroCredito> pagosFiltrados;
    private ArrayList<Modalidad> modalidades;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private static int SCREEN_HEIGHT;
    private static int SCREEN_WIDTH;
    RelativeLayout relativeLayoutMain;
    RelativeLayout relativeLayoutA;
    RelativeLayout relativeLayoutB;
    RelativeLayout relativeLayoutC;
    RelativeLayout relativeLayoutD;
    TableLayout tableLayoutA;
    TableLayout tableLayoutB;
    TableLayout tableLayoutC;
    TableLayout tableLayoutD;
    TableRow tableRow;
    TableRow tableRowB;
    HorizontalScroll horizontalScrollViewB;
    HorizontalScroll horizontalScrollViewD;
    VerticalScroll scrollViewC;
    VerticalScroll scrollViewD;
    private AutoCompleteTextView acModalidad;
    private ArrayAdapter<Modalidad> modalidadesAdapter;
    private String modalidad_id = "";
    private int previousLength;
    private boolean backSpace;
    int tableColumnCountB = 0;
    int tableRowCountC = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492897);
        this.setRequestedOrientation(0);
        this.relativeLayoutMain = (RelativeLayout)this.findViewById(2131296953);
        this.getScreenDimension();
        this.initializeRelativeLayout();
        this.initializeScrollers();
        this.initializeTableLayout();
        this.horizontalScrollViewB.setScrollViewListener(this);
        this.horizontalScrollViewD.setScrollViewListener(this);
        this.scrollViewC.setScrollViewListener(this);
        this.scrollViewD.setScrollViewListener(this);
        this.addRowToTableA();
        this.initializeRowForTableB();
        this.acModalidad = (AutoCompleteTextView)this.findViewById(2131296280);
        this.pagos = new ArrayList();
        this.modalidades = new ArrayList();
        this.getPagos();
        this.getModalidades();
        this.modalidadesAdapter = new ArrayAdapter((Context)this, 17367050, this.modalidades);
        this.acModalidad.setThreshold(1);
        this.acModalidad.setAdapter(this.modalidadesAdapter);
        this.acModalidad.setImeOptions(0x10000000);
        this.acModalidad.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Modalidad modalidad = (Modalidad)TableActivity.this.modalidadesAdapter.getItem(i);
                TableActivity.this.modalidad_id = modalidad.getId();
            }
        });
        this.acModalidad.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                TableActivity.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                TableActivity.this.backSpace = TableActivity.this.previousLength > s.length();
                if (TableActivity.this.backSpace && !TableActivity.this.modalidad_id.equals("")) {
                    TableActivity.this.acModalidad.setText((CharSequence)"");
                    TableActivity.this.modalidad_id = "";
                }
            }
        });
        this.addColumnsToTableB("Direcci\u00f3n", 0);
        this.addColumnsToTableB("Telef\u00f3no", 1);
        this.addColumnsToTableB("Aval", 2);
        this.addColumnsToTableB("Direcci\u00f3n", 3);
        this.addColumnsToTableB("Telef\u00f3no", 4);
        this.addColumnsToTableB("Monto", 5);
        this.addColumnsToTableB("Pago", 6);
        for (int i = 1; i <= 20; ++i) {
            this.addColumnsToTableB("Sem. " + i, i + 6);
        }
    }

    private void getPagos() {
        this.vs = VolleyS.getInstance((Context)this);
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"reporteRegistroCredito");
            data.put("modalidad", (Object)"2");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    TableActivity.this.pagos.clear();
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Gson gson = new Gson();
                        RegistroCredito pago = (RegistroCredito)gson.fromJson(obj.toString(), RegistroCredito.class);
                        TableActivity.this.pagos.add(pago);
                        TableActivity.this.initializeRowForTableD(i);
                        TableActivity.this.addRowToTableC(pago.getNumero_tarjeton() + " " + pago.getNombre_completo());
                        TableActivity.this.initializeRowForTableD(i);
                        TableActivity.this.addColumnToTableAtD(i, pago.getDireccion());
                        TableActivity.this.addColumnToTableAtD(i, pago.getTelefono());
                        TableActivity.this.addColumnToTableAtD(i, pago.getNombre_aval());
                        TableActivity.this.addColumnToTableAtD(i, pago.getDireccion_aval());
                        TableActivity.this.addColumnToTableAtD(i, pago.getTelefono_aval());
                        TableActivity.this.addColumnToTableAtD(i, pago.getMonto_prestado());
                        TableActivity.this.addColumnToTableAtD(i, pago.getPago_semanal());
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana1().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana2().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana3().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana4().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana5().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana6().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana7().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana8().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana9().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana10().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana11().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana12().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana13().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana14().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana15().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana16() == null ? "" : pago.getSemana16().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana17() == null ? "" : pago.getSemana17().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana18() == null ? "" : pago.getSemana18().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana19() == null ? "" : pago.getSemana19().split(" ")[0]);
                        TableActivity.this.addColumnToTableAtD(i, pago.getSemana20() == null ? "" : pago.getSemana20().split(" ")[0]);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                String statusCode = String.valueOf(error.networkResponse.statusCode);
                if (error.networkResponse.data != null) {
                    String body = new String(error.networkResponse.data, StandardCharsets.UTF_8);
                    Log.e((String)"BODY", (String)body);
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    private void getModalidades() {
        this.vs = VolleyS.getInstance((Context)this);
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"semanasActivas");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlConfiguraciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Gson gson = new Gson();
                        Modalidad modalidad = (Modalidad)gson.fromJson(obj.toString(), Modalidad.class);
                        Log.d((String)"MOD", (String)modalidad.getId());
                        TableActivity.this.modalidades.add(modalidad);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                String statusCode = String.valueOf(error.networkResponse.statusCode);
                if (error.networkResponse.data != null) {
                    String body = new String(error.networkResponse.data, StandardCharsets.UTF_8);
                    Log.e((String)"body", (String)body);
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    private void getScreenDimension() {
        WindowManager wm = (WindowManager)this.getApplicationContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        SCREEN_WIDTH = size.x;
        SCREEN_HEIGHT = size.y;
    }

    private void initializeRelativeLayout() {
        this.relativeLayoutA = new RelativeLayout(this.getApplicationContext());
        this.relativeLayoutA.setId(2131296949);
        this.relativeLayoutA.setPadding(0, 0, 0, 0);
        this.relativeLayoutB = new RelativeLayout(this.getApplicationContext());
        this.relativeLayoutB.setId(2131296950);
        this.relativeLayoutB.setPadding(0, 0, 0, 0);
        this.relativeLayoutC = new RelativeLayout(this.getApplicationContext());
        this.relativeLayoutC.setId(2131296951);
        this.relativeLayoutC.setPadding(0, 0, 0, 0);
        this.relativeLayoutD = new RelativeLayout(this.getApplicationContext());
        this.relativeLayoutD.setId(2131296952);
        this.relativeLayoutD.setPadding(0, 0, 0, 0);
        this.relativeLayoutA.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 10));
        this.relativeLayoutMain.addView((View)this.relativeLayoutA);
        RelativeLayout.LayoutParams layoutParamsRelativeLayoutB = new RelativeLayout.LayoutParams(SCREEN_WIDTH - SCREEN_WIDTH / 5, SCREEN_HEIGHT / 10);
        layoutParamsRelativeLayoutB.addRule(1, 2131296949);
        this.relativeLayoutB.setLayoutParams((ViewGroup.LayoutParams)layoutParamsRelativeLayoutB);
        this.relativeLayoutMain.addView((View)this.relativeLayoutB);
        RelativeLayout.LayoutParams layoutParamsRelativeLayoutC = new RelativeLayout.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT - SCREEN_HEIGHT / 5);
        layoutParamsRelativeLayoutC.addRule(3, 2131296949);
        this.relativeLayoutC.setLayoutParams((ViewGroup.LayoutParams)layoutParamsRelativeLayoutC);
        this.relativeLayoutMain.addView((View)this.relativeLayoutC);
        RelativeLayout.LayoutParams layoutParamsRelativeLayoutD = new RelativeLayout.LayoutParams(SCREEN_WIDTH - SCREEN_WIDTH / 5, SCREEN_HEIGHT - SCREEN_HEIGHT / 5);
        layoutParamsRelativeLayoutD.addRule(3, 2131296950);
        layoutParamsRelativeLayoutD.addRule(1, 2131296951);
        this.relativeLayoutD.setLayoutParams((ViewGroup.LayoutParams)layoutParamsRelativeLayoutD);
        this.relativeLayoutMain.addView((View)this.relativeLayoutD);
    }

    private void initializeScrollers() {
        this.horizontalScrollViewB = new HorizontalScroll(this.getApplicationContext());
        this.horizontalScrollViewB.setPadding(0, 0, 0, 0);
        this.horizontalScrollViewD = new HorizontalScroll(this.getApplicationContext());
        this.horizontalScrollViewD.setPadding(0, 0, 0, 0);
        this.scrollViewC = new VerticalScroll(this.getApplicationContext());
        this.scrollViewC.setPadding(0, 0, 0, 0);
        this.scrollViewD = new VerticalScroll(this.getApplicationContext());
        this.scrollViewD.setPadding(0, 0, 0, 0);
        this.horizontalScrollViewB.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH - SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5));
        this.scrollViewC.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT - SCREEN_HEIGHT / 5));
        this.scrollViewD.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH - SCREEN_WIDTH / 5, SCREEN_HEIGHT - SCREEN_HEIGHT / 5));
        this.horizontalScrollViewD.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH - SCREEN_WIDTH / 5, SCREEN_HEIGHT - SCREEN_HEIGHT / 5));
        this.relativeLayoutB.addView((View)this.horizontalScrollViewB);
        this.relativeLayoutC.addView((View)this.scrollViewC);
        this.scrollViewD.addView((View)this.horizontalScrollViewD);
        this.relativeLayoutD.addView((View)this.scrollViewD);
    }

    private void initializeTableLayout() {
        this.tableLayoutA = new TableLayout(this.getApplicationContext());
        this.tableLayoutA.setPadding(0, 0, 0, 0);
        this.tableLayoutB = new TableLayout(this.getApplicationContext());
        this.tableLayoutB.setPadding(0, 0, 0, 0);
        this.tableLayoutB.setId(2131297086);
        this.tableLayoutC = new TableLayout(this.getApplicationContext());
        this.tableLayoutC.setPadding(0, 0, 0, 0);
        this.tableLayoutD = new TableLayout(this.getApplicationContext());
        this.tableLayoutD.setPadding(0, 0, 0, 0);
        TableLayout.LayoutParams layoutParamsTableLayoutA = new TableLayout.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        this.tableLayoutA.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableLayoutA);
        this.tableLayoutA.setBackgroundColor(this.getResources().getColor(2131099771));
        this.relativeLayoutA.addView((View)this.tableLayoutA);
        TableLayout.LayoutParams layoutParamsTableLayoutB = new TableLayout.LayoutParams(SCREEN_WIDTH - SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        this.tableLayoutB.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableLayoutB);
        this.tableLayoutB.setBackgroundColor(this.getResources().getColor(2131099771));
        this.horizontalScrollViewB.addView((View)this.tableLayoutB);
        TableLayout.LayoutParams layoutParamsTableLayoutC = new TableLayout.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT - SCREEN_HEIGHT / 5);
        this.tableLayoutC.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableLayoutC);
        this.tableLayoutC.setBackgroundColor(this.getResources().getColor(2131099771));
        this.scrollViewC.addView((View)this.tableLayoutC);
        TableLayout.LayoutParams layoutParamsTableLayoutD = new TableLayout.LayoutParams(-1, -1);
        this.tableLayoutD.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableLayoutD);
        this.horizontalScrollViewD.addView((View)this.tableLayoutD);
    }

    @Override
    public void onScrollChanged(HorizontalScroll scrollView, int x, int y, int oldx, int oldy) {
        if (scrollView == this.horizontalScrollViewB) {
            this.horizontalScrollViewD.scrollTo(x, y);
        } else if (scrollView == this.horizontalScrollViewD) {
            this.horizontalScrollViewB.scrollTo(x, y);
        }
    }

    @Override
    public void onScrollChanged(VerticalScroll scrollView, int x, int y, int oldx, int oldy) {
        if (scrollView == this.scrollViewC) {
            this.scrollViewD.scrollTo(x, y);
        } else if (scrollView == this.scrollViewD) {
            this.scrollViewC.scrollTo(x, y);
        }
    }

    private void addRowToTableA() {
        this.tableRow = new TableRow(this.getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow = new TableRow.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        this.tableRow.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableRow);
        TextView label_date = new TextView(this.getApplicationContext());
        label_date.setGravity(17);
        label_date.setGravity(17);
        label_date.setText((CharSequence)"Tarjet\u00f3n / Cliente");
        label_date.setTypeface(label_date.getTypeface(), 1);
        label_date.setTextColor(this.getResources().getColor(2131099681));
        this.tableRow.setGravity(1);
        label_date.setTextSize(this.getResources().getDimension(2131165271));
        this.tableRow.addView((View)label_date);
        this.tableLayoutA.addView((View)this.tableRow);
    }

    private void initializeRowForTableB() {
        this.tableRowB = new TableRow(this.getApplicationContext());
        this.tableRow.setPadding(0, 0, 0, 0);
        this.tableLayoutB.addView((View)this.tableRowB);
    }

    private synchronized void addColumnsToTableB(String text, int id2) {
        this.tableRow = new TableRow(this.getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow = new TableRow.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        this.tableRow.setPadding(3, 3, 3, 4);
        this.tableRow.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableRow);
        TextView label_date = new TextView(this.getApplicationContext());
        label_date.setTextColor(this.getResources().getColor(2131099681));
        label_date.setGravity(17);
        label_date.setText((CharSequence)text);
        label_date.setTypeface(label_date.getTypeface(), 1);
        label_date.setTextSize(this.getResources().getDimension(2131165271));
        this.tableRow.addView((View)label_date);
        this.tableRow.setTag((Object)id2);
        this.tableRowB.addView((View)this.tableRow);
        ++this.tableColumnCountB;
    }

    private synchronized void addRowToTableC(String text) {
        TableRow tableRow1 = new TableRow(this.getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow1 = new TableRow.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        tableRow1.setPadding(3, 3, 3, 4);
        tableRow1.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableRow1);
        TextView label_date = new TextView(this.getApplicationContext());
        label_date.setTextColor(this.getResources().getColor(2131099681));
        label_date.setGravity(17);
        label_date.setText((CharSequence)text);
        label_date.setTextSize(this.getResources().getDimension(2131165271));
        tableRow1.addView((View)label_date);
        TableRow tableRow = new TableRow(this.getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow = new TableRow.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        tableRow.setPadding(0, 0, 0, 0);
        tableRow.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableRow);
        tableRow.addView((View)tableRow1);
        this.tableLayoutC.addView((View)tableRow, this.tableRowCountC);
        ++this.tableRowCountC;
    }

    private synchronized void initializeRowForTableD(int pos) {
        TableRow tableRowB = new TableRow(this.getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow = new TableRow.LayoutParams(-2, SCREEN_HEIGHT / 5);
        tableRowB.setPadding(0, 0, 0, 0);
        tableRowB.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableRow);
        this.tableLayoutD.addView((View)tableRowB, pos);
    }

    private synchronized void addColumnToTableAtD(int rowPos, String text) {
        TableRow tableRowAdd = (TableRow)this.tableLayoutD.getChildAt(rowPos);
        this.tableRow = new TableRow(this.getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow = new TableRow.LayoutParams(SCREEN_WIDTH / 5, SCREEN_HEIGHT / 5);
        this.tableRow.setPadding(3, 3, 3, 4);
        this.tableRow.setBackground(this.getResources().getDrawable(2131230851));
        this.tableRow.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTableRow);
        TextView label_date = new TextView(this.getApplicationContext());
        label_date.setGravity(17);
        label_date.setText((CharSequence)text);
        label_date.setTextSize(this.getResources().getDimension(2131165271));
        label_date.setTextColor(this.getResources().getColor(2131099681));
        this.tableRow.setTag((Object)label_date);
        this.tableRow.addView((View)label_date);
        tableRowAdd.addView((View)this.tableRow);
    }

    private void createCompleteColumn(String value) {
        int i = 0;
        int j = this.tableRowCountC - 1;
        for (int k = i; k <= j; ++k) {
            this.addColumnToTableAtD(k, value);
        }
    }

    private void createCompleteRow(String value) {
        this.initializeRowForTableD(0);
        int i = 0;
        int j = this.tableColumnCountB - 1;
        int pos = this.tableRowCountC - 1;
        for (int k = i; k <= j; ++k) {
            this.addColumnToTableAtD(pos, value);
        }
    }
}

