/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import java.util.ArrayList;

public class AvalController {
    private final DatabaseHelper databaseHelper;
    private final String NOMBRE_TABLA = "avales";

    public AvalController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, nombre_completo text, direccion text, telefono text, garantias text, carpeta_comprobantes text, carpeta_garantias  text, otras_referencias text, created_at text, updated_at text, ruta_id text, poblacion_id text, colocadora_id TEXT, update_comprobantes TEXT, update_garantias TEXT) ", "avales");
        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, nombre_completo text, direccion text, telefono text, garantias text, carpeta_comprobantes text, carpeta_garantias  text, otras_referencias text, created_at text, updated_at text, ruta_id text, poblacion_id text, colocadora_id TEXT, update_comprobantes TEXT, update_garantias TEXT) ", "avales");
        db.execSQL("DROP TABLE IF EXISTS avales");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"avales");
    }

    public int eliminar(Aval aval) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(aval.getNombre_completo())};
        return db.delete("avales", "nombre_completo = ?", argumentos);
    }

    public long nueva(Aval aval) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", aval.getId());
        valoresParaInsertar.put("nombre_completo", aval.getNombre_completo());
        valoresParaInsertar.put("direccion", aval.getDireccion());
        valoresParaInsertar.put("telefono", aval.getTelefono());
        valoresParaInsertar.put("garantias", aval.getGarantias());
        valoresParaInsertar.put("carpeta_comprobantes", aval.getCarpeta_comprobantes());
        valoresParaInsertar.put("carpeta_garantias", aval.getCarpeta_garantias());
        valoresParaInsertar.put("otras_referencias", aval.getOtras_referencias());
        valoresParaInsertar.put("created_at", aval.getCreated_at());
        valoresParaInsertar.put("updated_at", aval.getUpdated_at());
        valoresParaInsertar.put("ruta_id", aval.getRuta_id());
        valoresParaInsertar.put("poblacion_id", aval.getPoblacion_id());
        valoresParaInsertar.put("colocadora_id", aval.getColocadora_id());
        return db.insert("avales", null, valoresParaInsertar);
    }

    @SuppressLint(value={"Range"})
    public ArrayList<Aval> obtener() {
        String query;
        ArrayList<Aval> avales = new ArrayList<Aval>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT avales.*, poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, rutas.nombre_ruta, colocadoras.nombre_completo as nombre_colocadora, colocadoras.status as status_colocadora, colocadoras.ruta_id as ruta_colocadora,  colocadoras.poblacion_id as 'poblacion_colocadora',  avales.update_comprobantes as 'update_comprobantes_aval',  avales.update_garantias as 'update_garantias_aval' FROM avales INNER JOIN poblaciones ON poblaciones.id = avales.poblacion_id INNER JOIN colocadoras ON avales.colocadora_id = colocadoras.id INNER JOIN rutas ON rutas.id = avales.ruta_id", null);
        if (cursor == null || !cursor.moveToFirst()) {
            return avales;
        }
        do {
            String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
            String nombre_completo = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String direccion = cursor.getString(cursor.getColumnIndexOrThrow("direccion"));
            String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
            String garantias = cursor.getString(cursor.getColumnIndexOrThrow("garantias"));
            String carpeta_comprobantes = cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes"));
            String carpeta_garantias = cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias"));
            String otras_referencias = cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias"));
            String created_at = cursor.getString(cursor.getColumnIndexOrThrow("created_at"));
            String updated_at = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
            String ruta_id = cursor.getString(cursor.getColumnIndexOrThrow("ruta_id"));
            String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
            String colocadora_id = cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id"));
            String update_comprobantes = cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval"));
            String update_garantias = cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval"));
            Aval avalObtenidoDeBD = new Aval(id2, nombre_completo, direccion, telefono, garantias, carpeta_comprobantes, carpeta_garantias, otras_referencias, created_at, updated_at, ruta_id, poblacion_id, colocadora_id, update_comprobantes, update_garantias);
            avales.add(avalObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return avales;
    }

    public ArrayList<Aval> obtener(String ruta) {
        String query;
        ArrayList<Aval> avales = new ArrayList<Aval>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT avales.*, poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, rutas.nombre_ruta, colocadoras.nombre_completo as 'nombre_colocadora', colocadoras.status as 'status_colocadora', colocadoras.ruta_id as 'ruta_colocadora',  colocadoras.poblacion_id as 'poblacion_colocadora',  avales.update_comprobantes as 'update_comprobantes_aval',  avales.update_garantias as 'update_garantias_aval'  FROM avales INNER JOIN poblaciones  ON poblaciones.id = avales.poblacion_id  INNER JOIN colocadoras ON avales.colocadora_id = colocadoras.id  INNER JOIN rutas ON rutas.id = avales.ruta_id WHERE avales.ruta_id = " + ruta + " ORDER BY avales.id desc", null);
        if (cursor == null) {
            return avales;
        }
        if (!cursor.moveToFirst()) {
            return avales;
        }
        do {
            String id2 = cursor.getString(0);
            String nombre_completo = cursor.getString(1);
            String direccion = cursor.getString(2);
            String telefono = cursor.getString(3);
            String garantias = cursor.getString(4);
            String carpeta_comprobantes = cursor.getString(5);
            String carpeta_garantias = cursor.getString(6);
            String otras_referencias = cursor.getString(7);
            String created_at = cursor.getString(8);
            String updated_at = cursor.getString(9);
            String ruta_id = cursor.getString(10);
            String poblacion_id = cursor.getString(11);
            String colocadora_id = cursor.getString(12);
            String update_comprobantes = cursor.getString(13);
            String update_garantias = cursor.getString(14);
            Aval avalObtenidoDeBD = new Aval(id2, nombre_completo, direccion, telefono, garantias, carpeta_comprobantes, carpeta_garantias, otras_referencias, created_at, updated_at, ruta_id, poblacion_id, colocadora_id, update_comprobantes, update_garantias);
            avales.add(avalObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return avales;
    }

    public String getAvalByNombre(String nombre) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT id FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        String id2 = "";
        if (cursor.moveToFirst()) {
            id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
        }
        cursor.close();
        return id2;
    }
}

