/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import java.util.ArrayList;

public class ClienteController {
    private final DatabaseHelper databaseHelper;
    private final String NOMBRE_TABLA = "clientes";

    public ClienteController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer , nombre_completo text, direccion text, telefono text, garantias text, carpeta_comprobantes text, carpeta_garantias  text, otras_referencias text, ruta_id text, poblacion_id text, colocadora_id text, created_at text, updated_at text, update_comprobantes TEXT, update_garantias TEXT, prestanombre TEXT DEFAULT '0', aval_id TEXT)", "clientes");
        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer , nombre_completo text, direccion text, telefono text, garantias text, carpeta_comprobantes text, carpeta_garantias  text, otras_referencias text, ruta_id text, poblacion_id text, colocadora_id text, created_at text, updated_at text, prestanombre text, aval_id text) ", "clientes");
        db.execSQL("DROP TABLE IF EXISTS clientes");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"clientes");
    }

    public boolean tablaExiste() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = 'clientes'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }

    public int eliminar(Cliente cliente) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(cliente.getNombre_completo())};
        return db.delete("clientes", "nombre_completo = ?", argumentos);
    }

    public long nueva(Cliente cliente) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", cliente.getId());
        valoresParaInsertar.put("nombre_completo", cliente.getNombre_completo());
        valoresParaInsertar.put("direccion", cliente.getDireccion());
        valoresParaInsertar.put("telefono", cliente.getTelefono());
        valoresParaInsertar.put("garantias", cliente.getGarantias());
        valoresParaInsertar.put("carpeta_comprobantes", cliente.getCarpeta_comprobantes());
        valoresParaInsertar.put("carpeta_garantias", cliente.getCarpeta_garantias());
        valoresParaInsertar.put("otras_referencias", cliente.getOtras_referencias());
        valoresParaInsertar.put("ruta_id", cliente.getRuta_cliente());
        valoresParaInsertar.put("poblacion_id", cliente.getPoblacion_cliente());
        valoresParaInsertar.put("colocadora_id", cliente.getColocadora_id());
        valoresParaInsertar.put("created_at", cliente.getCreated_at());
        valoresParaInsertar.put("updated_at", cliente.getUpdated_at());
        valoresParaInsertar.put("aval_id", cliente.getAval_id());
        return db.insert("clientes", null, valoresParaInsertar);
    }

    public ArrayList<Cliente> obtener() {
        String query;
        ArrayList<Cliente> clientes = new ArrayList<Cliente>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT clientes.*, poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, rutas.nombre_ruta, colocadoras.nombre_completo as 'nombre_colocadora', colocadoras.status as 'status_colocadora', colocadoras.ruta_id as 'ruta_colocadora',  colocadoras.poblacion_id as 'poblacion_colocadora',  clientes.update_comprobantes as 'update_comprobantes_cliente',  clientes.update_garantias as 'update_garantias_cliente'  FROM clientes INNER JOIN poblaciones  ON poblaciones.id = clientes.poblacion_id  INNER JOIN colocadoras ON clientes.colocadora_id = colocadoras.id  INNER JOIN rutas ON rutas.id = clientes.ruta_id ", null);
        if (cursor == null) {
            return clientes;
        }
        if (!cursor.moveToFirst()) {
            return clientes;
        }
        do {
            String id2 = cursor.getString(0);
            String nombre_completo = cursor.getString(1);
            String direccion = cursor.getString(2);
            String telefono = cursor.getString(3);
            String garantias = cursor.getString(4);
            String carpeta_comprobantes = cursor.getString(5);
            String carpeta_garantias = cursor.getString(6);
            String otras_referencias = cursor.getString(7);
            String ruta_id = cursor.getString(8);
            String poblacion_id = cursor.getString(9);
            String colocadora_id = cursor.getString(10);
            String created_at = cursor.getString(11);
            String updated_at = cursor.getString(12);
            String aval_id = cursor.getString(13);
            String poblacion_nombre = cursor.getString(14);
            String poblacion_fecha_grupo = cursor.getString(15);
            String poblacion_grupo = cursor.getString(16);
            String ruta_nombre = cursor.getString(17);
            String colocadora_nombre = cursor.getString(18);
            String update_comprobantes_cliente = cursor.getString(19);
            String update_garantias_cliente = cursor.getString(20);
            String prestanombre = cursor.isNull(22) ? "0" : cursor.getString(22);
            Cliente clienteObtenidoDeBD = new Cliente(id2, nombre_completo, direccion, telefono, garantias, carpeta_comprobantes, carpeta_garantias, otras_referencias, ruta_id, poblacion_id, colocadora_id, created_at, updated_at, prestanombre, update_comprobantes_cliente, update_garantias_cliente, aval_id);
            clienteObtenidoDeBD.setNombre_poblacion(poblacion_nombre);
            clienteObtenidoDeBD.setFecha_inicio(poblacion_fecha_grupo);
            clienteObtenidoDeBD.setGrupo(poblacion_grupo);
            clienteObtenidoDeBD.setNombre_ruta(ruta_nombre);
            clienteObtenidoDeBD.setNombre_colocadora(colocadora_nombre);
            clientes.add(clienteObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return clientes;
    }

    public ArrayList<Cliente> obtener(String ruta) {
        String query;
        ArrayList<Cliente> clientes = new ArrayList<Cliente>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT clientes.*, poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, rutas.nombre_ruta, colocadoras.nombre_completo as 'nombre_colocadora', colocadoras.status as 'status_colocadora', colocadoras.ruta_id as 'ruta_colocadora',  colocadoras.poblacion_id as 'poblacion_colocadora',  clientes.update_comprobantes as 'update_comprobantes_cliente',  clientes.update_garantias as 'update_garantias_cliente'  FROM clientes INNER JOIN poblaciones  ON poblaciones.id = clientes.poblacion_id  INNER JOIN colocadoras ON clientes.colocadora_id = colocadoras.id  INNER JOIN rutas ON rutas.id = clientes.ruta_id WHERE clientes.ruta_id = " + ruta + " ORDER BY clientes.id desc", null);
        if (cursor == null) {
            return clientes;
        }
        if (!cursor.moveToFirst()) {
            return clientes;
        }
        do {
            String id2 = cursor.getString(0);
            String nombre_completo = cursor.getString(1);
            String direccion = cursor.getString(2);
            String telefono = cursor.getString(3);
            String garantias = cursor.getString(4);
            String carpeta_comprobantes = cursor.getString(5);
            String carpeta_garantias = cursor.getString(6);
            String otras_referencias = cursor.getString(7);
            String ruta_id = cursor.getString(8);
            String poblacion_id = cursor.getString(9);
            String colocadora_id = cursor.getString(10);
            String created_at = cursor.getString(11);
            String updated_at = cursor.getString(12);
            String aval_id = cursor.getString(13);
            String poblacion_nombre = cursor.getString(14);
            String poblacion_fecha_grupo = cursor.getString(15);
            String poblacion_grupo = cursor.getString(16);
            String ruta_nombre = cursor.getString(17);
            String colocadora_nombre = cursor.getString(18);
            String colocadora_status = cursor.getString(19);
            String colocadora_ruta = cursor.getString(20);
            String colocadora_poblacion = cursor.getString(21);
            String prestanombre = cursor.getString(22);
            String update_comprobantes_cliente = cursor.getString(23);
            String update_garantias_cliente = cursor.getString(24);
            Cliente clienteObtenidoDeBD = new Cliente(id2, nombre_completo, direccion, telefono, garantias, carpeta_comprobantes, carpeta_garantias, otras_referencias, ruta_id, poblacion_id, colocadora_id, created_at, updated_at, prestanombre, update_comprobantes_cliente, update_garantias_cliente, aval_id);
            clienteObtenidoDeBD.setNombre_poblacion(poblacion_nombre);
            clienteObtenidoDeBD.setFecha_inicio(poblacion_fecha_grupo);
            clienteObtenidoDeBD.setGrupo(poblacion_grupo);
            clienteObtenidoDeBD.setNombre_ruta(ruta_nombre);
            clienteObtenidoDeBD.setNombre_colocadora(colocadora_nombre);
            clientes.add(clienteObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return clientes;
    }

    public String getNombre(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT nombre_completo FROM clientes WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            String nombre = cursor.getString(0);
            cursor.close();
            return nombre;
        }
        cursor.close();
        return null;
    }

    public String getClienteRuta(String cid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT ruta_id FROM clientes WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{cid});
        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return "";
    }

    public String getClientePoblacion(String cid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT poblacion_id FROM clientes WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{cid});
        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return "";
    }

    public String getClienteColocadora(String cid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT colocadora_id FROM clientes WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{cid});
        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return "";
    }

    public String getNombreCliente(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT nombre_completo FROM clientes WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            String nombre = cursor.getString(0);
            cursor.close();
            return nombre;
        }
        cursor.close();
        return null;
    }

    public String getPrestaNombreFromAvalEnCliente(String nombre) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT prestanombre FROM clientes WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        String prestanombre = "";
        if (cursor.moveToFirst()) {
            prestanombre = cursor.getString(0);
        }
        cursor.close();
        return prestanombre;
    }
}

