/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Colocadora;
import java.util.ArrayList;

public class ColocadoraController {
    private final DatabaseHelper databaseHelper;
    private final String NOMBRE_TABLA = "colocadoras";

    public ColocadoraController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key autoincrement, nombre_completo text, direccion text, telefono text, status text, ruta_id text, poblacion_id text, created_at text, updated_at text) ", "colocadoras");
        db.execSQL(TABLE_SCHEMA);
    }

    public boolean tablaExiste() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = 'colocadoras'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }

    public void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key autoincrement, nombre_completo text, direccion text, telefono text, status text, ruta_id text, poblacion_id text, created_at text, updated_at text) ", "colocadoras");
        db.execSQL("DROP TABLE IF EXISTS colocadoras");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"colocadoras");
    }

    public long nueva(Colocadora colocadora) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT id from colocadoras where colocadoras.id = " + colocadora.getId(), null);
        if (cursor.moveToFirst()) {
            return 0L;
        }
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", colocadora.getId());
        valoresParaInsertar.put("nombre_completo", colocadora.getNombre_completo());
        valoresParaInsertar.put("direccion", colocadora.getDireccion());
        valoresParaInsertar.put("telefono", colocadora.getTelefono());
        valoresParaInsertar.put("status", colocadora.getStatus());
        valoresParaInsertar.put("ruta_id", colocadora.getRuta_id());
        valoresParaInsertar.put("poblacion_id", colocadora.getPoblacion_id());
        valoresParaInsertar.put("created_at", colocadora.getCreated_at());
        valoresParaInsertar.put("updated_at", colocadora.getUpdated_at());
        return db.insert("colocadoras", null, valoresParaInsertar);
    }

    public ArrayList<Colocadora> obtener() {
        String query;
        ArrayList<Colocadora> colocadoras = new ArrayList<Colocadora>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT colocadoras.*, rutas.nombre_ruta, poblaciones.nombre_poblacion FROM colocadoras        INNER JOIN rutas ON rutas.id = colocadoras.ruta_id\n        INNER JOIN poblaciones ON poblaciones.id = colocadoras.poblacion_id\n        ORDER BY colocadoras.id DESC", null);
        if (cursor == null) {
            return colocadoras;
        }
        if (!cursor.moveToFirst()) {
            return colocadoras;
        }
        do {
            String id2 = cursor.getString(0);
            String nombre_completo = cursor.getString(1);
            String direccion = cursor.getString(2);
            String telefono = cursor.getString(3);
            String status = cursor.getString(4);
            String ruta_id = cursor.getString(5);
            String poblacion_id = cursor.getString(6);
            String created_at = cursor.getString(7);
            String updated_at = cursor.getString(8);
            Colocadora colocadoraObtenidoDeBD = new Colocadora(id2, nombre_completo, direccion, telefono, status, ruta_id, poblacion_id, created_at, updated_at);
            colocadoras.add(colocadoraObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return colocadoras;
    }

    public ArrayList<Colocadora> getColocadoras(String cid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM colocadoras WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{cid});
        ArrayList<Colocadora> colocadoras = new ArrayList<Colocadora>();
        if (cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(0);
                String nombre = cursor.getString(1);
                String direccion = cursor.getString(2);
                String telefono = cursor.getString(3);
                String status = cursor.getString(4);
                String rid = cursor.getString(5);
                String pid = cursor.getString(6);
                String ca = cursor.getString(7);
                String ua = cursor.getString(8);
                colocadoras.add(new Colocadora(id2, nombre, direccion, telefono, status, rid, pid, ca, ua));
            } while (cursor.moveToNext());
        }
        return colocadoras;
    }

    public String getNombreColocadora(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String q = "SELECT nombre_completo FROM colocadoras WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{id2});
        String nombre = "";
        if (cursor.moveToFirst()) {
            do {
                nombre = cursor.getString(0);
            } while (cursor.moveToNext());
        }
        return nombre;
    }
}

