/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ConfiguracionSemana;
import java.util.ArrayList;

public class ConfiguracionSemanasController {
    private final DatabaseHelper databaseHelper;
    private final String NOMBRE_TABLA = "configuracion_semanas";

    public ConfiguracionSemanasController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key, cantidad int, interes text, tipo_abono text, semana_renovacion int, status int) ", "configuracion_semanas");
        db.execSQL(TABLE_SCHEMA);
    }

    public boolean tablaExiste() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = 'configuracion_semanas'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }

    public int eliminar(ConfiguracionSemana configuracionsemana) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(configuracionsemana.getId())};
        return db.delete("configuracion_semanas", "id = ?", argumentos);
    }

    public long nueva(ConfiguracionSemana configuracionsemana) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT id from configuracion_semanas where configuracion_semanas.id = " + configuracionsemana.getId(), null);
        if (cursor.moveToFirst()) {
            return 0L;
        }
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", configuracionsemana.getId());
        valoresParaInsertar.put("cantidad", configuracionsemana.getCantidad());
        valoresParaInsertar.put("interes", configuracionsemana.getInteres());
        valoresParaInsertar.put("tipo_abono", configuracionsemana.getTipo_Abono());
        valoresParaInsertar.put("semana_renovacion", configuracionsemana.getSemana_Renovacion());
        valoresParaInsertar.put("status", configuracionsemana.getStatus());
        return db.insert("configuracion_semanas", null, valoresParaInsertar);
    }

    public void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key, cantidad int, interes text, tipo_abono text, semana_renovacion int, status int) ", "configuracion_semanas");
        db.execSQL("DROP TABLE IF EXISTS configuracion_semanas");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"configuracion_semanas");
    }

    public ArrayList<ConfiguracionSemana> obtener() {
        ArrayList<ConfiguracionSemana> configuracionsemana = new ArrayList<ConfiguracionSemana>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String[] columnasAConsultar = new String[]{"id", "cantidad", "interes", "tipo_abono", "semana_renovacion", "status"};
        Cursor cursor = db.query("configuracion_semanas", columnasAConsultar, null, null, null, null, "id DESC");
        if (cursor == null) {
            return configuracionsemana;
        }
        if (!cursor.moveToFirst()) {
            return configuracionsemana;
        }
        do {
            String id2 = cursor.getString(0);
            String cantidad = cursor.getString(1);
            String interes = cursor.getString(2);
            String tipo_abono = cursor.getString(3);
            String semana_renovacion = cursor.getString(4);
            String status = cursor.getString(5);
            ConfiguracionSemana configuracionSemanasObtenidaDeBD = new ConfiguracionSemana(id2, cantidad, interes, tipo_abono, semana_renovacion, status);
            configuracionsemana.add(configuracionSemanasObtenidaDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return configuracionsemana;
    }
}

