/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import android.widget.Toast;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.UsuarioFolio;
import com.example.sefinsa_app.utilities.VolleyS;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FolioController {
    private final DatabaseHelper databaseHelper;
    private final Context context;

    public FolioController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        this.context = contexto;
        String createTableQuery = "CREATE TABLE IF NOT EXISTS folios (id INTEGER PRIMARY KEY,fecha VARCHAR(10),hora TIME,cliente_id VARCHAR(100),ruta_id INTEGER,poblacion_id INTEGER,monto VARCHAR(50),monto_letra VARCHAR(200),concepto VARCHAR(1000),firma_usuario VARCHAR(200000),firma_cliente VARCHAR(200000),sync VARCHAR(1));";
        db.execSQL(createTableQuery);
        String createUsuariosFoliosTable = "CREATE TABLE IF NOT EXISTS usuarios_folios (usuario_id INTEGER,folio_id INTEGER);";
        db.execSQL(createUsuariosFoliosTable);
        String createFoliosCanceladosTable = "CREATE TABLE IF NOT EXISTS folios_cancelados (folio_id INTEGER,fecha VARCHAR(50))";
        db.execSQL(createFoliosCanceladosTable);
    }

    public void getFoliosCanceladosServidor(final FolioEliminarCallback callback) {
        VolleyS vs = new VolleyS(this.context);
        RequestQueue rq = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getFoliosCancelados");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = response.getJSONArray("data");
                    Log.d((String)"Folios Cancelados", (String)String.valueOf(data));
                    if (data.length() == 0) {
                        callback.onSuccess();
                    }
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject folio = data.getJSONObject(i);
                        String folioId = folio.getString("folio_id");
                        SQLiteDatabase db = FolioController.this.databaseHelper.getWritableDatabase();
                        String query = "DELETE FROM folios WHERE id = ?";
                        db.execSQL(query, (Object[])new String[]{folioId});
                        Log.d((String)"folioEliminado", (String)folioId);
                        callback.onSuccess();
                    }
                }
                catch (JSONException e) {
                    callback.onError(String.valueOf((Object)e));
                    throw new RuntimeException(e);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    public double store(Folio folio) {
        if (this.folioExists(folio.getId())) {
            return -1.0;
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("id", folio.getId());
        cv.put("fecha", folio.getFecha());
        cv.put("hora", folio.getHora());
        cv.put("cliente_id", folio.getCliente_id());
        cv.put("ruta_id", folio.getRuta_id());
        cv.put("poblacion_id", folio.getPoblacion_id());
        cv.put("monto", folio.getMonto());
        cv.put("monto_letra", folio.getMonto_letra());
        cv.put("concepto", folio.getConcepto());
        cv.put("firma_usuario", folio.getFirma_usuario());
        cv.put("firma_cliente", folio.getFirma_cliente());
        cv.put("sync", Integer.valueOf(0));
        String query = "DELETE FROM usuarios_folios WHERE folio_id = ?";
        db.execSQL(query, (Object[])new String[]{folio.getId()});
        Log.d((String)"FadeMove", (String)("store: " + folio.getId()));
        return db.insert("folios", null, cv);
    }

    public boolean folioExists(String folioId) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT id FROM folios WHERE id = ?", new String[]{folioId});
        boolean exists = cursor.moveToFirst();
        cursor.close();
        db.close();
        return exists;
    }

    public ArrayList<Folio> index() {
        String query;
        ArrayList<Folio> folios = new ArrayList<Folio>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT * FROM folios", null);
        if (cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String colocadora_id = cursor.getString(6);
                String monto = cursor.getString(7);
                String monto_letra = cursor.getString(8);
                String concepto = cursor.getString(9);
                String firma_usuario = cursor.getString(10);
                String firma_cliente = cursor.getString(11);
                Folio folio = new Folio(id2, fecha, hora, cliente_id, ruta_id, poblacion_id, colocadora_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return folios;
    }

    public Folio show(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT * FROM folios WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            String fecha = cursor.getString(1);
            String hora = cursor.getString(2);
            String cliente_id = cursor.getString(3);
            String ruta_id = cursor.getString(4);
            String poblacion_id = cursor.getString(5);
            String colocadora_id = cursor.getString(6);
            String monto = cursor.getString(7);
            String monto_letra = cursor.getString(8);
            String concepto = cursor.getString(9);
            String firma_usuario = cursor.getString(10);
            String firma_cliente = cursor.getString(11);
            Folio folio = new Folio(id2, fecha, hora, cliente_id, ruta_id, poblacion_id, colocadora_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
            cursor.close();
            return folio;
        }
        cursor.close();
        return null;
    }

    public ArrayList<Folio> getLikeFolios(String id2, ArrayList<String> rutas) {
        ArrayList<Folio> folios = new ArrayList<Folio>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        StringBuilder query = new StringBuilder("SELECT * FROM folios WHERE id LIKE ? AND ruta_id IN (");
        for (int i = 0; i < rutas.size(); ++i) {
            query.append(rutas.get(i));
            if (i >= rutas.size() - 1) continue;
            query.append(",");
        }
        query.append(") ORDER BY id DESC");
        Cursor cursor = db.rawQuery(String.valueOf(query), new String[]{"%" + id2 + "%"});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getLikeNombre(String id2, String date, ArrayList<String> rutas) {
        ArrayList<Folio> folios = new ArrayList<Folio>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        StringBuilder query = new StringBuilder("SELECT * FROM folios WHERE cliente_id LIKE ? AND fecha = ? AND ruta_id IN (");
        for (int i = 0; i < rutas.size(); ++i) {
            query.append(rutas.get(i));
            if (i >= rutas.size() - 1) continue;
            query.append(",");
        }
        query.append(") ORDER BY id DESC");
        Cursor cursor = db.rawQuery(String.valueOf(query), new String[]{"%" + id2 + "%", date});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioCliente(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE cliente_id = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioFechaRutaId(String id2, ArrayList<String> rutas) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        StringBuilder query = new StringBuilder("SELECT * FROM folios WHERE fecha = ? AND ruta_id IN (");
        for (int i = 0; i < rutas.size(); ++i) {
            query.append(rutas.get(i));
            if (i >= rutas.size() - 1) continue;
            query.append(",");
        }
        query.append(") ORDER BY id DESC");
        Log.d((String)"FadeMove", (String)("getFolioFechaRutaId: " + query));
        Cursor cursor = db.rawQuery(query.toString(), new String[]{id2});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioClienteFecha(String id2, String date) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE fecha = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{date, id2});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioRuta(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE ruta_id = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioRutaFecha(String id2, String date) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE ruta_id = ? AND fecha = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{id2, date});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioFechaRuta(String id2, String date) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE ruta_id = ? AND fecha = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{id2, date});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioPoblacion(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE poblacion_id = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioPoblacionFecha(String id2, String date) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE poblacion_id = ? AND fecha = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{id2, date});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioFechaRutaPoblacion(String id2, String date, String pid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE ruta_id = ? AND fecha = ? AND poblacion_id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2, date, pid});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioClienteRutaPoblacion(String cid, String rid, String pid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE cliente_id = ? AND ruta_id = ? AND poblacion_id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{cid, rid, pid});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioClienteRutaPoblacionFecha(String cid, String rid, String pid, String date) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE cliente_id = ? AND ruta_id = ? AND poblacion_id = ? AND fecha = ?";
        Cursor cursor = db.rawQuery(query, new String[]{cid, rid, pid, date});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioRutaPoblacion(String rid, String pid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE ruta_id = ? AND poblacion_id = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{rid, pid});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public ArrayList<Folio> getFolioRutaPoblacionFecha(String rid, String pid, String date) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE ruta_id = ? AND poblacion_id = ? AND fecha = ? ORDER BY id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{rid, pid, date});
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return folios;
    }

    public void recreate() {
        String q = "DROP TABLE folios";
        SQLiteDatabase wdb = this.databaseHelper.getWritableDatabase();
        wdb.execSQL(q);
        String createTableQuery = "CREATE TABLE IF NOT EXISTS folios (id INTEGER PRIMARY KEY,fecha VARCHAR(10),hora TIME,cliente_id VARCHAR(100),ruta_id INTEGER,poblacion_id INTEGER,monto VARCHAR(50),monto_letra VARCHAR(200),concepto VARCHAR(1000),firma_usuario VARCHAR(200000),firma_cliente VARCHAR(200000),sync VARCHAR(1));";
        wdb.execSQL(createTableQuery);
        wdb.close();
    }

    public ArrayList<Folio> getUnsyncedFolios() {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList<Folio> folios = new ArrayList<Folio>();
        String query = "SELECT * FROM folios WHERE sync = 0";
        Cursor cursor = db.rawQuery(query, new String[0]);
        if (cursor.moveToFirst()) {
            do {
                String nFolio = cursor.getString(0);
                String fecha = cursor.getString(1);
                String hora = cursor.getString(2);
                String cliente_id = cursor.getString(3);
                String ruta_id = cursor.getString(4);
                String poblacion_id = cursor.getString(5);
                String monto = cursor.getString(6);
                String monto_letra = cursor.getString(7);
                String concepto = cursor.getString(8);
                String firma_usuario = cursor.getString(9);
                String firma_cliente = cursor.getString(10);
                Folio folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
                folios.add(folio);
            } while (cursor.moveToNext());
            cursor.close();
            db.close();
        }
        db.close();
        return folios;
    }

    public String getLastestFolioID() {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT id FROM folios ORDER BY id DESC LIMIT 1";
        Cursor cursor = db.rawQuery(query, new String[0]);
        String folio = "";
        if (cursor.moveToFirst()) {
            folio = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return folio;
    }

    public void syncFolio(final String folio, String fecha, String hora, String cliente_id, String ruta_id, String poblacion_id, String monto, String monto_letra, String concepto, String firma_usuario, String firma_cliente) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"storeFolio");
            data.put("folio", (Object)folio);
            data.put("fecha", (Object)fecha);
            data.put("hora", (Object)hora);
            data.put("cliente_id", (Object)cliente_id);
            data.put("ruta_id", (Object)ruta_id);
            data.put("poblacion_id", (Object)poblacion_id);
            data.put("monto", (Object)monto);
            data.put("monto_letra", (Object)monto_letra);
            data.put("concepto", (Object)concepto);
            data.put("firma_usuario", (Object)firma_usuario);
            data.put("firma_cliente", (Object)firma_cliente);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Log.d((String)"sync repsonse", (String)("onResponse: " + response));
                String query = "UPDATE folios SET sync = 1 WHERE id = ?";
                SQLiteDatabase db = FolioController.this.databaseHelper.getWritableDatabase();
                db.execSQL(query, (Object[])new String[]{folio});
                db.close();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"sync error", (String)("onErrorResponse: " + error));
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        VolleyS vs = VolleyS.getInstance(this.context);
        RequestQueue requestQueue = vs.getRequestQueue();
        requestQueue.add((Request)request);
    }

    public String getPoblacionA(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT nombre_poblacion FROM poblaciones WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        String poblacion = "";
        if (cursor.moveToFirst()) {
            poblacion = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return poblacion;
    }

    public void getTotalFolios(final FolioCountCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"countFolios");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray data = response.getJSONArray("data");
                        if (data.length() > 0) {
                            JSONObject obj = data.getJSONObject(0);
                            int total = obj.getInt("total");
                            callback.onSuccess(total);
                        } else {
                            callback.onError("No se encontr\u00f3 informaci\u00f3n.");
                        }
                    } else {
                        callback.onError("Error del servidor: " + response.getString("message"));
                    }
                }
                catch (JSONException e) {
                    callback.onError("Error al parsear respuesta JSON.");
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                callback.onError("Error de red: " + error.getMessage());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        VolleyS.getInstance(this.context).getRequestQueue().add((Request)request);
    }

    public Integer getFolioCount() {
        SQLiteDatabase db = new DatabaseHelper(this.context).getReadableDatabase();
        String query = "SELECT COUNT(*) FROM folios";
        Cursor cursor = db.rawQuery(query, null);
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        cursor.close();
        db.close();
        return count;
    }

    public void getFolioDataAndSave(final FolioDownloadCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"indexFolio");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray dataArray = response.getJSONArray("data");
                        for (int i = 0; i < dataArray.length(); ++i) {
                            JSONObject folioObject = dataArray.getJSONObject(i);
                            Folio newFolio = new Folio(folioObject.getString("id"), folioObject.getString("fecha"), folioObject.getString("hora"), folioObject.getString("cliente_id"), folioObject.getString("ruta_id"), folioObject.getString("poblacion_id"), folioObject.getString("monto"), folioObject.getString("monto_letra"), folioObject.getString("concepto"), folioObject.getString("firma_usuario"), folioObject.getString("firma_cliente"));
                            Log.d((String)"folioDescargado", (String)newFolio.toString());
                            Folio existingFolio = FolioController.this.getFolioFromDbById(newFolio.getId());
                            if (existingFolio == null) {
                                FolioController.this.storeSync(newFolio);
                                continue;
                            }
                            if (!newFolio.equals(existingFolio)) {
                                FolioController.this.updateFolioInDb(newFolio);
                                Log.d((String)"folioActualizado", (String)newFolio.toString());
                                continue;
                            }
                            Log.d((String)"folioSinCambios", (String)newFolio.getId());
                        }
                        callback.onDownloadComplete();
                    } else {
                        Toast.makeText((Context)FolioController.this.context, (CharSequence)("Error del servidor: " + response.getString("message")), (int)0).show();
                    }
                }
                catch (JSONException e) {
                    Toast.makeText((Context)FolioController.this.context, (CharSequence)"Error al parsear respuesta JSON.", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Toast.makeText((Context)FolioController.this.context, (CharSequence)("Error de red: " + error.getMessage()), (int)0).show();
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        VolleyS.getInstance(this.context).getRequestQueue().add((Request)request);
    }

    private void updateFolioInDb(Folio newFolio) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("fecha", newFolio.getFecha());
        cv.put("hora", newFolio.getHora());
        cv.put("cliente_id", newFolio.getCliente_id());
        cv.put("ruta_id", newFolio.getRuta_id());
        cv.put("poblacion_id", newFolio.getPoblacion_id());
        cv.put("monto", newFolio.getMonto());
        cv.put("monto_letra", newFolio.getMonto_letra());
        cv.put("concepto", newFolio.getConcepto());
        cv.put("firma_usuario", newFolio.getFirma_usuario());
        cv.put("firma_cliente", newFolio.getFirma_cliente());
        cv.put("sync", Integer.valueOf(1));
        db.update("folios", cv, "id = ?", new String[]{newFolio.getId()});
        db.close();
    }

    private Folio getFolioFromDbById(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT * FROM folios WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        Folio folio = null;
        if (cursor.moveToFirst()) {
            String nFolio = cursor.getString(0);
            String fecha = cursor.getString(1);
            String hora = cursor.getString(2);
            String cliente_id = cursor.getString(3);
            String ruta_id = cursor.getString(4);
            String poblacion_id = cursor.getString(5);
            String monto = cursor.getString(6);
            String monto_letra = cursor.getString(7);
            String concepto = cursor.getString(8);
            String firma_usuario = cursor.getString(9);
            String firma_cliente = cursor.getString(10);
            folio = new Folio(nFolio, fecha, hora, cliente_id, ruta_id, poblacion_id, monto, monto_letra, concepto, firma_usuario, firma_cliente);
            cursor.close();
            db.close();
            return folio;
        }
        cursor.close();
        db.close();
        return folio;
    }

    public double storeSync(Folio folio) {
        if (this.folioExists(folio.getId())) {
            return -1.0;
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("id", folio.getId());
        cv.put("fecha", folio.getFecha());
        cv.put("hora", folio.getHora());
        cv.put("cliente_id", folio.getCliente_id());
        cv.put("ruta_id", folio.getRuta_id());
        cv.put("poblacion_id", folio.getPoblacion_id());
        cv.put("monto", folio.getMonto());
        cv.put("monto_letra", folio.getMonto_letra());
        cv.put("concepto", folio.getConcepto());
        cv.put("firma_usuario", folio.getFirma_usuario());
        cv.put("firma_cliente", folio.getFirma_cliente());
        cv.put("sync", Integer.valueOf(1));
        String query = "DELETE FROM usuarios_folios WHERE folio_id = ?";
        db.execSQL(query, (Object[])new String[]{folio.getId()});
        Log.d((String)"FadeMove", (String)("storeSync: " + folio.getId()));
        return db.insert("folios", null, cv);
    }

    public void prepararFolios(String empleadoId, String cantidad) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"prepararFolios");
            data.put("usuario_id", (Object)empleadoId);
            data.put("cantidad", (Object)cantidad);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray dataArray = response.getJSONArray("data");
                        for (int i = 0; i < dataArray.length(); ++i) {
                            JSONObject folioObject = dataArray.getJSONObject(i);
                            UsuarioFolio usuarioFolio = new UsuarioFolio(folioObject.getString("usuario_id"), folioObject.getString("folio_id"));
                            FolioController.this.storeUsuarioFolio(usuarioFolio);
                        }
                    } else {
                        Toast.makeText((Context)FolioController.this.context, (CharSequence)("Error del servidor: " + response.getString("message")), (int)0).show();
                    }
                }
                catch (JSONException e) {
                    Toast.makeText((Context)FolioController.this.context, (CharSequence)"Error al parsear respuesta JSON.", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"sync error", (String)("onErrorResponse: " + error));
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        VolleyS.getInstance(this.context).getRequestQueue().add((Request)request);
    }

    public void storeUsuarioFolio(UsuarioFolio usuarioFolio) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("usuario_id", usuarioFolio.getUsuarioId());
        cv.put("folio_id", usuarioFolio.getFolioId());
        db.insert("usuarios_folios", null, cv);
        db.close();
    }

    public ArrayList<UsuarioFolio> getUsuarioFolios(String usuarioId) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        ArrayList folios = new ArrayList();
        String query = "SELECT * FROM usuarios_folios WHERE usuario_id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{usuarioId});
        ArrayList<UsuarioFolio> usuarioFolios = new ArrayList<UsuarioFolio>();
        if (cursor.moveToFirst()) {
            do {
                String folioId = cursor.getString(1);
                usuarioFolios.add(new UsuarioFolio(folioId));
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return usuarioFolios;
    }

    public String getFirstAvailableFolioId(String empeladoId) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT folio_id FROM usuarios_folios WHERE usuario_id = ? ORDER BY folio_id ASC LIMIT 1";
        Cursor cursor = db.rawQuery(query, new String[]{empeladoId});
        String folioId = "";
        if (cursor.moveToFirst()) {
            folioId = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return folioId;
    }

    public String getPoblacion(String id2) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT nombre_poblacion FROM poblaciones WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        String poblacion = "";
        if (cursor.moveToFirst()) {
            poblacion = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return poblacion;
    }

    public String verificarRuta(String txt) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT id FROM rutas WHERE nombre_ruta = ?";
        Cursor cursor = db.rawQuery(query, new String[]{txt});
        String ruta = "";
        if (cursor.moveToFirst()) {
            ruta = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return ruta;
    }

    public String verificarPoblacion(String txt) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String query = "SELECT id FROM poblaciones WHERE nombre_poblacion = ?";
        Cursor cursor = db.rawQuery(query, new String[]{txt});
        String poblacion = "";
        if (cursor.moveToFirst()) {
            poblacion = cursor.getString(0);
        }
        cursor.close();
        db.close();
        return poblacion;
    }

    public static interface FolioEliminarCallback {
        public void onSuccess();

        public void onError(String var1);

        public void onSucess();
    }

    public static interface FolioCountCallback {
        public void onSuccess(int var1);

        public void onError(String var1);
    }

    public static interface FolioDownloadCallback {
        public void onDownloadComplete();
    }
}

