/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Gastos;
import com.example.sefinsa_app.models.ReporteDiarioDeRutas;
import java.util.ArrayList;

public class GastosController {
    private final DatabaseHelper databaseHelper;
    private final String NOMBRE_TABLA = "gastos";

    public GastosController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, otros TEXT, gasolina TEXT, hotel TEXT, alimentos TEXT, casetas TEXT, total TEXT, status TEXT DEFAULT '0')", "gastos");
        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, otros TEXT, gasolina TEXT, hotel TEXT, alimentos TEXT, casetas TEXT, total TEXT, status TEXT DEFAULT '0')", "gastos");
        db.execSQL("DROP TABLE IF EXISTS gastos");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"gastos");
    }

    public int eliminar(Gastos gastos) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(gastos.getId())};
        return db.delete("gastos", "id = ?", argumentos);
    }

    public long nueva(ReporteDiarioDeRutas reportediarioderutas) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", reportediarioderutas.getId());
        valoresParaInsertar.put("otros", reportediarioderutas.getPoblacion_id());
        valoresParaInsertar.put("gasolina", reportediarioderutas.getEstimacion());
        valoresParaInsertar.put("hotel", reportediarioderutas.getAbonos_semana());
        valoresParaInsertar.put("alimentos", reportediarioderutas.getRecuperacion_semana());
        valoresParaInsertar.put("casetas", reportediarioderutas.getRecuperacion_vencida());
        valoresParaInsertar.put("total", reportediarioderutas.getAnticipos());
        return db.insert("gastos", null, valoresParaInsertar);
    }

    public ArrayList<Gastos> obtener() {
        String query;
        ArrayList<Gastos> gastos = new ArrayList<Gastos>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT * FROM gastos", null);
        if (cursor == null) {
            return gastos;
        }
        if (!cursor.moveToFirst()) {
            return gastos;
        }
        do {
            String id2 = cursor.getString(0);
            String otros = cursor.getString(1);
            String gasolina = cursor.getString(2);
            String hotel = cursor.getString(3);
            String alimentos = cursor.getString(4);
            String casetas = cursor.getString(5);
            String total_1 = cursor.getString(6);
            String status = cursor.getString(7);
            Gastos gastosObtenidoDeBD = new Gastos(id2, otros, gasolina, hotel, alimentos, casetas, total_1, status);
            gastos.add(gastosObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return gastos;
    }
}

