/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.bumptech.glide.Glide;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;

public class RMDController {
    private static final Logger log = LoggerFactory.getLogger(RMDController.class);
    private final DatabaseHelper databaseHelper;
    private final SQLiteDatabase wdb;
    private final SQLiteDatabase rdb;
    private final Context context;
    private final Activity activity;
    private final VolleyS vs;
    private static RequestQueue rq = null;
    public String ruta = API.urlPrestamos;
    static String lat = "";
    static String lgt = "";
    private static FusedLocationProviderClient client;

    public RMDController(Context context, Activity activity) {
        this.context = context;
        this.activity = activity;
        this.databaseHelper = new DatabaseHelper(this.context);
        this.wdb = this.databaseHelper.getWritableDatabase();
        this.rdb = this.databaseHelper.getReadableDatabase();
        if (activity != null) {
            RMDController.getCurrentLocation(activity);
        }
        this.vs = new VolleyS(this.context);
        rq = this.vs.getRequestQueue();
        String createRMDSTable = "CREATE TABLE IF NOT EXISTS rmds(id INT PRIMARY KEY, prestamo_id INT, valor_garantia DECIMAL(10, 2), pagara DECIMAL(10, 2), fecha VARCHAR(10), recibe_mercancia VARCHAR(200), firma_cliente VARCHAR(2000000), firma_asesor VARCHAR(2000000), fecha_pago VARCHAR(10), sync INTEGER DEFAULT 0)";
        String createRMDUsuariosTable = "CREATE TABLE IF NOT EXISTS rmds_usuarios(rmd_id INT PRIMARY KEY, usuario_id INT)";
        String createRMDArticulosTable = "CREATE TABLE IF NOT EXISTS rmd_articulos(id INTEGER PRIMARY KEY AUTOINCREMENT, rmd_id INT, articulo VARCHAR(100), marca VARCHAR(100), color VARCHAR(100), detalles_condiciones VARCHAR(1000))";
        String createArticulosFotosTable = "CREATE TABLE IF NOT EXISTS fotos_articulo(id INTEGER PRIMARY KEY AUTOINCREMENT, articulo_id int, ruta varchar(200000))";
        this.wdb.execSQL(createRMDSTable);
        this.wdb.execSQL(createRMDUsuariosTable);
        this.wdb.execSQL(createRMDArticulosTable);
        this.wdb.execSQL(createArticulosFotosTable);
    }

    public RMD getDatosBaseRMD(String prestamoId) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, clientes.telefono, rutas.nombre_ruta, poblaciones.nombre_poblacion FROM prestamos JOIN clientes ON clientes.id = prestamos.cliente_id JOIN rutas ON rutas.id = clientes.ruta_id JOIN poblaciones ON poblaciones.id = clientes.poblacion_id WHERE prestamos.id = ?";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{prestamoId});
        if (cursor.moveToFirst()) {
            String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
            String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
            String ruta = cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta"));
            String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
            RMD rmdBase = new RMD(prestamoId, numeroCuenta, nombre, telefono, ruta, poblacion);
            return rmdBase;
        }
        return null;
    }

    public String getRMDSCount(String empelado_id) {
        String query = "SELECT COUNT(*) FROM rmds_usuarios WHERE usuario_id = ?";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{empelado_id});
        if (cursor.moveToFirst()) {
            int count = cursor.getInt(0);
            return String.valueOf(count);
        }
        return "0";
    }

    public void prepararRMDSBDLocal(String id2, String usuarioId, prerararRMDSBDLocalCallback callback) {
        String query = "INSERT INTO rmds_usuarios (rmd_id, usuario_id) VALUES (?, ?)";
        this.wdb.execSQL(query, (Object[])new String[]{id2, usuarioId});
        callback.onSucess();
    }

    public String getPrimerRMDId(String usuario_id) {
        String query = "SELECT MIN(rmd_id) FROM rmds_usuarios WHERE usuario_id = ?";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{usuario_id});
        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return null;
    }

    public void postRMD(RMD rmd, String prestamoId, prerararRMDSCallback callback) {
        try {
            String folio = rmd.getId();
            ArrayList<Articulo> articulos = rmd.getArticulos();
            String valorGarantia = rmd.getValorGarantia();
            String pagara = rmd.getPagara();
            String fecha = rmd.getFecha();
            String firmaCliente = rmd.getFirmaCliente();
            String firmaAsesor = rmd.getFirmaAsesor();
            String recibeMercancia = rmd.getRecibeMercancia();
            String fechaPago = rmd.getFechaIns();
            String queryRMD = "INSERT INTO rmds (id, prestamo_id, valor_garantia, pagara, fecha, firma_cliente, firma_asesor, recibe_mercancia, fecha_pago) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.wdb.execSQL(queryRMD, (Object[])new String[]{folio, prestamoId, valorGarantia, pagara, fecha, firmaCliente, firmaAsesor, recibeMercancia, fechaPago});
            for (Articulo articulo : articulos) {
                String nombreArticulo = articulo.getArticulo();
                String marca = articulo.getMarca();
                String color2 = articulo.getColor();
                String detallesCondiciones = articulo.getDetalleCondiciones();
                ArrayList<Bitmap> imagenes = articulo.getImagenes();
                String queryArticulo = "INSERT INTO rmd_articulos (rmd_id, articulo, marca, color, detalles_condiciones) VALUES (?, ?, ?, ?, ?)";
                this.wdb.execSQL(queryArticulo, (Object[])new String[]{folio, nombreArticulo, marca, color2, detallesCondiciones});
                String queryLtsArticulo = "SELECT id FROM rmd_articulos ORDER BY id DESC LIMIT 1";
                Cursor cursor = this.rdb.rawQuery(queryLtsArticulo, null);
                if (!cursor.moveToFirst()) continue;
                String articuloId = cursor.getString(0);
                String queryFotosArticulo = "INSERT INTO fotos_articulo (articulo_id, ruta) VALUES (?, ?)";
                if (articulo.getUrisImagenes().isEmpty()) continue;
                for (Uri uri : articulo.getUrisImagenes()) {
                    this.wdb.execSQL(queryFotosArticulo, (Object[])new String[]{articuloId, uri.toString()});
                }
            }
            String queryDeleteUserRMD = "DELETE FROM rmds_usuarios WHERE rmd_id = ?";
            this.wdb.execSQL(queryDeleteUserRMD, (Object[])new String[]{folio});
            callback.onSuccess("RMD agregado correctamente");
        }
        catch (Exception e) {
            callback.onError(e.getMessage());
        }
    }

    public void intertarRMDServidor(RMD rmd, SincronizarDelServidorCallback callback) {
        String id2 = rmd.getId();
        String prestamoId = rmd.getPrestamo_id();
        String valorGarantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fecha = rmd.getFecha();
        String firmaCliente = rmd.getFirmaCliente();
        String firmaAsesor = rmd.getFirmaAsesor();
        String recibeMercancia = rmd.getRecibeMercancia();
        String fechaPago = rmd.getFechaIns();
        ArrayList<Articulo> articulos = rmd.getArticulos();
        String query = "INSERT INTO rmds (id, prestamo_id, valor_garantia, pagara, fecha, firma_cliente, firma_asesor, recibe_mercancia, fecha_pago) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.wdb.execSQL(query, (Object[])new String[]{id2, prestamoId, valorGarantia, pagara, fecha, firmaCliente, firmaAsesor, recibeMercancia, fechaPago});
        String querySync = "UPDATE rmds SET sync = 1 WHERE id = ?";
        this.wdb.execSQL(querySync, (Object[])new String[]{id2});
        if (articulos != null && !articulos.isEmpty()) {
            for (Articulo articulo : articulos) {
                String nombreArticulo = articulo.getArticulo();
                String marca = articulo.getMarca();
                String color2 = articulo.getColor();
                String detallesCondiciones = articulo.getDetalleCondiciones();
                Log.d((String)"askldlas", (String)nombreArticulo);
                String queryArticulo = "INSERT INTO rmd_articulos (rmd_id, articulo, marca, color, detalles_condiciones) VALUES (?, ?, ?, ?, ?)";
                this.wdb.execSQL(queryArticulo, (Object[])new String[]{id2, nombreArticulo, marca, color2, detallesCondiciones});
                callback.onSuccess();
            }
        } else {
            callback.onSuccess();
        }
    }

    public static Bitmap escalarBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width < 1000 && height < 1000) {
            return bitmap;
        }
        int proporcion = 8;
        int newWidth = width / proporcion;
        int newHeight = height / proporcion;
        Log.d((String)"bitmapsizenuevo", (String)(newWidth + " " + newHeight));
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)false);
    }

    public ArrayList<RMD> indexRMD() {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rmds.id, rmds.fecha FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rmds ON rmds.prestamo_id = prestamos.id ORDER BY rmds.id DESC";
        Cursor cursor = this.rdb.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            ArrayList<RMD> rmds = new ArrayList<RMD>();
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                rmds.add(new RMD(id2, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
            return rmds;
        }
        return null;
    }

    public RMD getRMD(String id2) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rutas.nombre_ruta, rmds.valor_garantia, rmds.pagara, rmds.fecha, rmds.recibe_mercancia, rmds.firma_cliente, rmds.firma_asesor, rmds.fecha_pago FROM prestamos JOIN rmds ON rmds.prestamo_id = prestamos.id JOIN clientes ON clientes.id = prestamos.cliente_id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rutas ON poblaciones.ruta_id = rutas.id WHERE rmds.id = ?";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
            String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
            String ruta = cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta"));
            String valorGarantia = cursor.getString(cursor.getColumnIndexOrThrow("valor_garantia"));
            String pagara = cursor.getString(cursor.getColumnIndexOrThrow("pagara"));
            String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
            String recibeMercancia = cursor.getString(cursor.getColumnIndexOrThrow("recibe_mercancia"));
            String firmaCliente = cursor.getString(cursor.getColumnIndexOrThrow("firma_cliente"));
            String firmaAsesor = cursor.getString(cursor.getColumnIndexOrThrow("firma_asesor"));
            String fechaPago = cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago"));
            return new RMD(id2, numeroCuenta, nombre, poblacion, ruta, valorGarantia, pagara, fecha, recibeMercancia, firmaCliente, firmaAsesor, fechaPago);
        }
        return null;
    }

    public ArrayList<Articulo> getArticulos(String id2) {
        String query = "SELECT * FROM rmd_articulos WHERE rmd_id = ?";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{id2});
        if (cursor.moveToFirst()) {
            ArrayList<Articulo> articulos = new ArrayList<Articulo>();
            do {
                String articulo = cursor.getString(cursor.getColumnIndexOrThrow("articulo"));
                String marca = cursor.getString(cursor.getColumnIndexOrThrow("marca"));
                String color2 = cursor.getString(cursor.getColumnIndexOrThrow("color"));
                String detallesCondiciones = cursor.getString(cursor.getColumnIndexOrThrow("detalles_condiciones"));
                Articulo articuloObj = new Articulo(articulo, marca, color2, detallesCondiciones);
                articulos.add(articuloObj);
            } while (cursor.moveToNext());
            return articulos;
        }
        return null;
    }

    public RMD getRMDParaImpresion(String folio) {
        String query = "SELECT rmds.id, rmds.fecha, prestamos.numero_tarjeton, clientes.nombre_completo, clientes.telefono, rutas.nombre_ruta, poblaciones.nombre_poblacion, rmds.valor_garantia, rmds.pagara, rmds.fecha_pago, rmds.firma_cliente, rmds.firma_asesor, rmds.recibe_mercancia FROM prestamos JOIN rmds ON prestamos.id = rmds.prestamo_id JOIN clientes ON clientes.id = prestamos.cliente_id JOIN rutas ON rutas.id = clientes.ruta_id JOIN poblaciones on poblaciones.id = clientes.poblacion_id WHERE rmds.id = ?";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{folio});
        String queryArticulos = "SELECT * FROM rmd_articulos WHERE rmd_articulos.rmd_id = ?";
        Cursor cursorArticulos = this.rdb.rawQuery(queryArticulos, new String[]{folio});
        if (cursor.moveToFirst()) {
            String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
            String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
            String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
            String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
            String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
            String ruta = cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta"));
            String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
            String valorGarantia = cursor.getString(cursor.getColumnIndexOrThrow("valor_garantia"));
            String pagara = cursor.getString(cursor.getColumnIndexOrThrow("pagara"));
            String fechaPago = cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago"));
            String firmaCliente = cursor.getString(cursor.getColumnIndexOrThrow("firma_cliente"));
            String firmaAsesor = cursor.getString(cursor.getColumnIndexOrThrow("firma_asesor"));
            String recibeMercancia = cursor.getString(cursor.getColumnIndexOrThrow("recibe_mercancia"));
            ArrayList<Articulo> articulos = new ArrayList<Articulo>();
            if (cursorArticulos.moveToFirst()) {
                do {
                    String articulo = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("articulo"));
                    String marca = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("marca"));
                    String color2 = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("color"));
                    String detallesCondiciones = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("detalles_condiciones"));
                    Articulo articuloObj = new Articulo(articulo, marca, color2, detallesCondiciones);
                    articulos.add(articuloObj);
                } while (cursorArticulos.moveToNext());
            }
            return new RMD(id2, numeroCuenta, nombre, ruta, poblacion, fecha, articulos, valorGarantia, pagara, fechaPago, firmaCliente, firmaAsesor, recibeMercancia, telefono);
        }
        return null;
    }

    public ArrayList<RMD> getRMDsDesincronizados() {
        String query = "SELECT * FROM rmds WHERE sync = 0";
        Cursor cursor = this.rdb.rawQuery(query, null);
        ArrayList<RMD> rmds = new ArrayList<RMD>();
        if (cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String prestamo_id = cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id"));
                String valor_garantia = cursor.getString(cursor.getColumnIndexOrThrow("valor_garantia"));
                String pagara = cursor.getString(cursor.getColumnIndexOrThrow("pagara"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                String fecha_pago = cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago"));
                String firma_cliente = cursor.getString(cursor.getColumnIndexOrThrow("firma_cliente"));
                String firma_asesor = cursor.getString(cursor.getColumnIndexOrThrow("firma_asesor"));
                String recibe_mercancia = cursor.getString(cursor.getColumnIndexOrThrow("recibe_mercancia"));
                String queryArticulos = "SELECT * FROM rmd_articulos WHERE rmd_id = ?";
                Cursor cursorArticulos = this.rdb.rawQuery(queryArticulos, new String[]{id2});
                ArrayList<Articulo> articulos = new ArrayList<Articulo>();
                if (cursorArticulos.moveToFirst()) {
                    do {
                        String id_articulo = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("id"));
                        String articulo = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("articulo"));
                        String marca = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("marca"));
                        String color2 = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("color"));
                        String detalles_condiciones = cursorArticulos.getString(cursorArticulos.getColumnIndexOrThrow("detalles_condiciones"));
                        ArrayList<Uri> rutas = new ArrayList<Uri>();
                        String queryRutas = "SELECT * FROM fotos_articulo WHERE articulo_id = ?";
                        Cursor cursorRutas = this.rdb.rawQuery(queryRutas, new String[]{id_articulo});
                        if (cursorRutas.moveToFirst()) {
                            do {
                                String ruta = cursorRutas.getString(cursorRutas.getColumnIndexOrThrow("ruta"));
                                rutas.add(Uri.parse((String)ruta));
                            } while (cursorRutas.moveToNext());
                        }
                        cursorRutas.close();
                        Articulo articuloObj = new Articulo(articulo, marca, color2, detalles_condiciones, null, rutas);
                        articulos.add(articuloObj);
                    } while (cursorArticulos.moveToNext());
                }
                cursorArticulos.close();
                rmds.add(new RMD(id2, prestamo_id, valor_garantia, pagara, fecha, fecha_pago, firma_cliente, firma_asesor, recibe_mercancia, articulos));
            } while (cursor.moveToNext());
        }
        cursor.close();
        return rmds;
    }

    public int getRMDSCount() {
        String query = "SELECT COUNT(*) FROM rmds";
        Cursor cursor = this.rdb.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            int count = cursor.getInt(0);
            return count;
        }
        return 0;
    }

    public String getAllRMDSIds() {
        String query = "SELECT id FROM rmds";
        Cursor cursor = this.rdb.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            String ids = "";
            do {
                ids = ids + cursor.getString(0) + ",";
            } while (cursor.moveToNext());
            return ids.substring(0, ids.length() - 1);
        }
        return "";
    }

    public ArrayList<RMD> filtroFecha(String fechaFiltro) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rmds.id, rmds.fecha FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rmds ON rmds.prestamo_id = prestamos.id WHERE rmds.fecha = ? ORDER BY rmds.id DESC";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{fechaFiltro});
        ArrayList<RMD> rmds = new ArrayList<RMD>();
        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                rmds.add(new RMD(id2, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroRutaFecha(String fechaFiltro, String rutaFiltro) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rmds.id, rmds.fecha FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rmds ON rmds.prestamo_id = prestamos.id WHERE rmds.fecha = ? AND clientes.ruta_id = ?ORDER BY rmds.id DESC";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{fechaFiltro, rutaFiltro});
        ArrayList<RMD> rmds = new ArrayList<RMD>();
        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                rmds.add(new RMD(id2, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroPoblacionFecha(String fechaFiltro, String poblacionFiltro) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rmds.id, rmds.fecha FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rmds ON rmds.prestamo_id = prestamos.id WHERE rmds.fecha = ? AND clientes.poblacion_id = ?ORDER BY rmds.id DESC";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{fechaFiltro, poblacionFiltro});
        ArrayList<RMD> rmds = new ArrayList<RMD>();
        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                rmds.add(new RMD(id2, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroNombre(String nombreFiltro) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rmds.id, rmds.fecha FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rmds ON rmds.prestamo_id = prestamos.id WHERE clientes.nombre_completo LIKE ? ORDER BY rmds.id DESC";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{"%" + nombreFiltro + "%"});
        ArrayList<RMD> rmds = new ArrayList<RMD>();
        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                rmds.add(new RMD(id2, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public ArrayList<RMD> filtroFolio(String folioFiltro) {
        String query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, poblaciones.nombre_poblacion, rmds.id, rmds.fecha FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id JOIN poblaciones ON clientes.poblacion_id = poblaciones.id JOIN rmds ON rmds.prestamo_id = prestamos.id WHERE rmds.id LIKE ? ORDER BY rmds.id DESC";
        Cursor cursor = this.rdb.rawQuery(query, new String[]{"%" + folioFiltro + "%"});
        ArrayList<RMD> rmds = new ArrayList<RMD>();
        if (cursor.moveToFirst()) {
            do {
                String numeroCuenta = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String poblacion = cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion"));
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                rmds.add(new RMD(id2, numeroCuenta, nombre, poblacion, fecha));
            } while (cursor.moveToNext());
        }
        return rmds;
    }

    public void getCountRMDsServidor(final GetCountRMDsServidorCallback callback) {
        JSONObject data = new JSONObject();
        final int[] count = new int[]{0};
        try {
            data.put("func", (Object)"getRMDCount");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, this.ruta, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    count[0] = response.getInt("data");
                    callback.onSuccess(count[0]);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                callback.onError(error.getMessage());
            }
        });
        rq.add((Request)req);
    }

    public void prepararRMDS(String cantidad, String usuarioId, final prerararRMDSCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"prepararRMDS");
            data.put("cantidad", (Object)cantidad);
            data.put("usuario_id", (Object)usuarioId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, this.ruta, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                JSONArray data = response.optJSONArray("data");
                for (int i = 0; i < data.length(); ++i) {
                    String rmd_id = data.optJSONObject(i).optString("rmd_id");
                    String usuario_id = data.optJSONObject(i).optString("usuario_id");
                    RMDController.this.prepararRMDSBDLocal(rmd_id, usuario_id, new prerararRMDSBDLocalCallback(){

                        @Override
                        public void onSuccess(String response) {
                            callback.onSuccess(response);
                        }

                        @Override
                        public void onError(String error) {
                            callback.onError(error);
                        }

                        @Override
                        public void onSucess() {
                            callback.onSucess();
                        }
                    });
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    public static File bitmapToFile(Context context, Bitmap bitmap, String fileName) {
        File file;
        File file2 = new File(context.getCacheDir(), fileName);
        FileOutputStream fos = new FileOutputStream(file2);
        try {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        fos.close();
        return file;
    }

    public static void subirFotoRetrofit(Context context, String rmdId, Bitmap bitmap, final String articuloId) {
        Bitmap bitmapEscalado = RMDController.escalarBitmap(bitmap);
        File file = RMDController.bitmapToFile(context, bitmapEscalado, "foto_" + System.currentTimeMillis() + ".jpg");
        if (file == null) {
            Log.e((String)"RetrofitUpload", (String)"Error al crear archivo desde bitmap");
            return;
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        ApiService apiService = (ApiService)retrofit.create(ApiService.class);
        RequestBody rmdIdBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)rmdId);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"image/jpeg"), (File)file);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
        Call<ResponseBody> call = apiService.subirFoto(rmdIdBody, body);
        call.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                String responseString = null;
                try {
                    responseString = ((ResponseBody)response.body()).string();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Log.d((String)"retrofitResp", (String)responseString);
                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(responseString);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                JSONObject dataObject = null;
                try {
                    dataObject = jsonObject.getJSONObject("data");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                String imageUrl = null;
                try {
                    imageUrl = dataObject.getString("url");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                Log.d((String)"retrofitResp", (String)("Image URL: " + imageUrl));
                RMDController.postRutasFotos(articuloId, imageUrl);
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                Log.e((String)"RetrofitUpload", (String)"Error en llamada Retrofit", (Throwable)t);
            }
        });
    }

    public void subirRMDServidor(RMD rmd, String prestamoId) {
        final String id2 = rmd.getId();
        String prestamo_id = prestamoId;
        String valor_garantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fecha = rmd.getFecha();
        String fecha_pago = rmd.getFechaIns();
        String firma_cliente = rmd.getFirmaCliente();
        String firma_asesor = rmd.getFirmaAsesor();
        String recibe_mercancia = rmd.getRecibeMercancia();
        final ArrayList<Articulo> articulos = rmd.getArticulos();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"postRMD");
            data.put("id", (Object)id2);
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("valor_garantia", (Object)valor_garantia);
            data.put("pagara", (Object)pagara);
            data.put("fecha", (Object)fecha);
            data.put("recibe_mercancia", (Object)recibe_mercancia);
            data.put("firma_cliente", (Object)firma_cliente);
            data.put("firma_asesor", (Object)firma_asesor);
            data.put("fecha_pago", (Object)fecha_pago);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                String query = "UPDATE rmds SET sync = 1 WHERE id = ?";
                RMDController.this.rdb.execSQL(query, (Object[])new String[]{id2});
                for (Articulo articulo : articulos) {
                    RMDController.postArticulos(articulo, id2, RMDController.this.context);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    public static void postArticulos(Articulo articulos, String rmdId, final Context context) {
        final String rmd_id = rmdId;
        String articulo = articulos.getArticulo();
        String marca = articulos.getMarca();
        String color2 = articulos.getColor();
        String detalles_condiciones = articulos.getDetalleCondiciones();
        final ArrayList<Bitmap> imagenes = articulos.getImagenes();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"postArticulo");
            data.put("rmd_id", (Object)rmd_id);
            data.put("articulo", (Object)articulo);
            data.put("marca", (Object)marca);
            data.put("color", (Object)color2);
            data.put("detalles_condiciones", (Object)detalles_condiciones);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                String articulo_id = response.optString("data");
                Log.d((String)"responsePostArticulos", (String)articulo_id);
                for (Bitmap bitmap : imagenes) {
                    RMDController.subirFotoRetrofit(context, rmd_id, bitmap, articulo_id);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    public static void postRutasFotos(String articulo_id, String ruta) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"postRutasFotos");
            data.put("articulo_id", (Object)articulo_id);
            data.put("ruta", (Object)ruta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    public void getRutasFotosFromServer(String rmdId, String articulo) {
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getRutasFotos");
            data.put("articulo_id", (Object)rmdId);
            data.put("articulo", (Object)articulo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                JSONArray data = response.optJSONArray("data");
                ArrayList<String> rutas = new ArrayList<String>();
                for (int i = 0; i < data.length(); ++i) {
                    String ruta = data.optJSONObject(i).optString("ruta");
                    rutas.add(ruta);
                }
                Log.d((String)"rutasalskdlkasl", (String)rutas.toString());
                if (rutas.isEmpty()) {
                    Toast.makeText((Context)RMDController.this.context, (CharSequence)"El art\u00edculo no tiene im\u00e1genes", (int)0).show();
                } else {
                    String ruta1;
                    AlertDialog.Builder builder = new AlertDialog.Builder(RMDController.this.context);
                    builder.setTitle((CharSequence)"Im\u00e1genes del art\u00edculo");
                    View dialogLayout = LayoutInflater.from((Context)RMDController.this.context).inflate(2131493067, null);
                    builder.setView(dialogLayout);
                    ImageView imgVw1 = (ImageView)dialogLayout.findViewById(2131296736);
                    ImageView imgVw2 = (ImageView)dialogLayout.findViewById(2131296737);
                    if (rutas.size() == 1) {
                        ruta1 = (String)rutas.get(0);
                        Glide.with((Context)RMDController.this.context).load(ruta1).into(imgVw1);
                    } else if (rutas.size() == 2) {
                        ruta1 = (String)rutas.get(0);
                        String ruta2 = (String)rutas.get(1);
                        Glide.with((Context)RMDController.this.context).load(ruta1).into(imgVw1);
                        Glide.with((Context)RMDController.this.context).load(ruta2).into(imgVw2);
                    }
                    builder.setPositiveButton((CharSequence)"Cerrar", null);
                    AlertDialog dialog = builder.create();
                    dialog.show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    public void subirRMDsDesincronizadosServidor(RMD rmd, final SubirRMDsDesincronizadosServidorCallback callback) {
        final String id2 = rmd.getId();
        String prestamo_id = rmd.getPrestamo_id();
        String valor_garantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fecha = rmd.getFecha();
        String fecha_pago = rmd.getFechaIns();
        String firma_cliente = rmd.getFirmaCliente();
        String firma_asesor = rmd.getFirmaAsesor();
        String recibe_mercancia = rmd.getRecibeMercancia();
        Log.d((String)"ddid", (String)id2);
        Log.d((String)"ddprestamo_id", (String)prestamo_id);
        Log.d((String)"ddvalor_garantia", (String)valor_garantia);
        Log.d((String)"ddpagara", (String)pagara);
        Log.d((String)"ddfecha", (String)fecha);
        Log.d((String)"ddfecha_pago", (String)fecha_pago);
        Log.d((String)"ddfirma_cliente", (String)firma_cliente);
        Log.d((String)"ddfirma_asesor", (String)firma_asesor);
        Log.d((String)"ddrecibe_mercancia", (String)recibe_mercancia);
        final ArrayList<Articulo> articulos = rmd.getArticulos();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"postRMD");
            data.put("id", (Object)id2);
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("valor_garantia", (Object)valor_garantia);
            data.put("pagara", (Object)pagara);
            data.put("fecha", (Object)fecha);
            data.put("recibe_mercancia", (Object)recibe_mercancia);
            data.put("firma_cliente", (Object)firma_cliente);
            data.put("firma_asesor", (Object)firma_asesor);
            data.put("fecha_pago", (Object)fecha_pago);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                String query = "UPDATE rmds SET sync = 1 WHERE id = ?";
                RMDController.this.rdb.execSQL(query, (Object[])new String[]{id2});
                final int[] c = new int[]{0};
                for (Articulo articulo : articulos) {
                    RMDController.postArticulosDesinconizados(articulo, id2, RMDController.this.context, RMDController.this.activity, new PostArticulosDesinconizadosCallback(){

                        @Override
                        public void onSuccess() {
                            c[0] = c[0] + 1;
                            Log.d((String)"asdsdasd", (String)(c[0] + "/" + articulos.size()));
                            if (c[0] == articulos.size()) {
                                callback.onSuccess();
                            }
                        }

                        @Override
                        public void onError(String error) {
                        }
                    });
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"ERRORRMDSV", (String)String.valueOf(error));
            }
        });
        rq.add((Request)req);
    }

    public static void postArticulosDesinconizados(Articulo articulos, String rmdId, final Context context, final Activity activity, final PostArticulosDesinconizadosCallback callback) {
        final String rmd_id = rmdId;
        String articulo = articulos.getArticulo();
        String marca = articulos.getMarca();
        String color2 = articulos.getColor();
        String detalles_condiciones = articulos.getDetalleCondiciones();
        final ArrayList<Uri> imagenes = articulos.getUrisImagenes();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"postArticulo");
            data.put("rmd_id", (Object)rmd_id);
            data.put("articulo", (Object)articulo);
            data.put("marca", (Object)marca);
            data.put("color", (Object)color2);
            data.put("detalles_condiciones", (Object)detalles_condiciones);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                String articulo_id = response.optString("data");
                Log.d((String)"responsePostArticulos", (String)articulo_id);
                final int[] c = new int[]{0};
                if (imagenes != null && !imagenes.isEmpty()) {
                    int totalImagenesValidas = 0;
                    for (Uri uri : imagenes) {
                        if (!RMDController.uriExiste(context, uri)) {
                            Log.w((String)"URI", (String)("La imagen no existe o no se puede acceder: " + uri.toString()));
                            continue;
                        }
                        ++totalImagenesValidas;
                        try {
                            final int finalTotalImagenesValidas = totalImagenesValidas;
                            RMDController.subirFotoRetrofitDesdeUri(context, rmd_id, uri, articulo_id, activity, new SubirFotoRetrofitDesdeUriCallback(){

                                @Override
                                public void onSuccess() {
                                    c[0] = c[0] + 1;
                                    if (c[0] == finalTotalImagenesValidas) {
                                        callback.onSuccess();
                                    }
                                }

                                @Override
                                public void onError(String error) {
                                    callback.onError(error);
                                }
                            });
                        }
                        catch (IOException e) {
                            Log.e((String)"SubirFoto", (String)("IOException al subir imagen: " + uri.toString()), (Throwable)e);
                        }
                    }
                    if (totalImagenesValidas == 0) {
                        Toast.makeText((Context)context, (CharSequence)"No se pudo subir ninguna imagen (archivos no encontrados)", (int)1).show();
                        callback.onSuccess();
                    }
                } else {
                    callback.onSuccess();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    private static boolean uriExiste(Context context, Uri uri) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                inputStream.close();
                return true;
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)"uriExiste", (String)("Archivo no encontrado: " + uri.toString()));
        }
        catch (IOException e) {
            Log.e((String)"uriExiste", (String)("Error al cerrar InputStream: " + uri.toString()));
        }
        return false;
    }

    public static void subirFotoRetrofitDesdeUri(Context context, String rmdId, Uri uri, final String articuloId, Activity activity, final SubirFotoRetrofitDesdeUriCallback callback) throws IOException {
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        Bitmap original = BitmapFactory.decodeStream((InputStream)inputStream);
        if (inputStream != null) {
            inputStream.close();
        }
        Bitmap mutableBitmap = original.copy(Bitmap.Config.ARGB_8888, true);
        Bitmap bitmapEscalado = RMDController.escalarBitmap(mutableBitmap = RMDController.agregarFechaYUbicacionAImagen(mutableBitmap, activity));
        File file = RMDController.bitmapToFile(context, bitmapEscalado, "foto_" + System.currentTimeMillis() + ".jpg");
        if (file == null) {
            Log.e((String)"RetrofitUpload", (String)"Error al crear archivo desde bitmap");
            return;
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        ApiService apiService = (ApiService)retrofit.create(ApiService.class);
        RequestBody rmdIdBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)rmdId);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"image/jpeg"), (File)file);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
        Call<ResponseBody> call = apiService.subirFoto(rmdIdBody, body);
        call.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                String responseString = null;
                try {
                    responseString = ((ResponseBody)response.body()).string();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Log.d((String)"retrofitResp", (String)responseString);
                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(responseString);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                JSONObject dataObject = null;
                try {
                    dataObject = jsonObject.getJSONObject("data");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                String imageUrl = null;
                try {
                    imageUrl = dataObject.getString("url");
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                callback.onSuccess();
                Log.d((String)"retrofitResp", (String)("Image URL: " + imageUrl));
                RMDController.postRutasFotos(articuloId, imageUrl);
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                Log.e((String)"RetrofitUpload", (String)"Error en llamada Retrofit", (Throwable)t);
            }
        });
    }

    public void getRMDSinSincronizar(final GetRMDsSinSincronizarCallback callback) {
        String excluidos = this.getAllRMDSIds();
        final ArrayList rmds = new ArrayList();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getRMDSParaSinconizar");
            data.put("excluidos", (Object)excluidos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                JSONArray data = response.optJSONArray("data");
                if (data == null) {
                    callback.onSuccess(rmds);
                    return;
                }
                int total = data.length();
                if (total == 0) {
                    callback.onSuccess(rmds);
                    return;
                }
                AtomicInteger respuestasRecibidas = new AtomicInteger(0);
                for (int i = 0; i < total; ++i) {
                    JSONObject rmdJson = data.optJSONObject(i);
                    String id2 = rmdJson.optString("id");
                    String prestamo_id = rmdJson.optString("prestamo_id");
                    String valor_garantia = rmdJson.optString("valor_garantia");
                    String pagara = rmdJson.optString("pagara");
                    String fecha = rmdJson.optString("fecha");
                    String fecha_pago = rmdJson.optString("fecha_pago");
                    String recibe_mercancia = rmdJson.optString("recibe_mercancia");
                    String firma_cliente = rmdJson.optString("firma_cliente");
                    String firma_asesor = rmdJson.optString("firma_asesor");
                    JSONObject data2 = new JSONObject();
                    try {
                        data2.put("func", (Object)"getArticulosRMDParaSincronizar");
                        data2.put("rmd_id", (Object)id2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JsonObjectRequest req2 = new JsonObjectRequest(1, API.urlPrestamos, data2, response2 -> {
                        JSONArray dataA = response2.optJSONArray("data");
                        ArrayList<Articulo> articulos = new ArrayList<Articulo>();
                        if (dataA != null) {
                            for (int j = 0; j < dataA.length(); ++j) {
                                JSONObject artJson = dataA.optJSONObject(j);
                                String articulo = artJson.optString("articulo");
                                String marca = artJson.optString("marca");
                                String color2 = artJson.optString("color");
                                String detalles_condiciones = artJson.optString("detalles_condiciones");
                                articulos.add(new Articulo(articulo, marca, color2, detalles_condiciones));
                            }
                        }
                        ArrayList arrayList = rmds;
                        synchronized (arrayList) {
                            rmds.add(new RMD(id2, prestamo_id, valor_garantia, pagara, fecha, fecha_pago, firma_cliente, firma_asesor, recibe_mercancia, articulos));
                        }
                        if (respuestasRecibidas.incrementAndGet() == total) {
                            callback.onSuccess(rmds);
                        }
                    }, error -> {
                        Log.e((String)"ErrorArticulos", (String)error.toString());
                        if (respuestasRecibidas.incrementAndGet() == total) {
                            callback.onSuccess(rmds);
                        }
                    });
                    rq.add((Request)req2);
                }
            }
        }, error -> callback.onError(error.toString()));
        rq.add((Request)req);
    }

    public void getRMDsEditados() throws JSONException {
        JSONObject data = new JSONObject();
        data.put("func", (Object)"getRMDEditados");
        JsonObjectRequest req = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                JSONArray data = response.optJSONArray("data");
                for (int i = 0; i < data.length(); ++i) {
                    JSONObject rmdJson = data.optJSONObject(i);
                    String id2 = rmdJson.optString("id");
                    String valor_garantia = rmdJson.optString("valor_garantia");
                    String pagara = rmdJson.optString("pagara");
                    String fecha_pago = rmdJson.optString("fecha_pago");
                    String recibeMercancia = rmdJson.optString("recibe_mercancia");
                    String query = "UPDATE rmds SET valor_garantia = ?, pagara = ?, fecha_pago = ?, recibe_mercancia = ? WHERE id = ?";
                    RMDController.this.rdb.execSQL(query, (Object[])new String[]{valor_garantia, pagara, fecha_pago, recibeMercancia, id2});
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        rq.add((Request)req);
    }

    private static Bitmap agregarFechaYUbicacionAImagen(Bitmap bitmap, Activity activity) {
        RMDController.addDateTimeToBitmap(bitmap, activity);
        RMDController.addCoordsToBitmap(bitmap, activity);
        return bitmap;
    }

    private static void addCoordsToBitmap(Bitmap bitmap, Activity activity) {
        client = LocationServices.getFusedLocationProviderClient((Activity)activity);
        RMDController.getCurrentLocation(activity);
        String text = lat + ", " + lgt;
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(100.0f);
        textPaint.setAntiAlias(true);
        float textWidth = textPaint.measureText(text);
        float textHeight = textPaint.getTextSize();
        float padding = 10.0f;
        float x = (float)bitmap.getWidth() - textWidth - padding;
        float y = (float)bitmap.getHeight() - padding;
        canvas.drawRect(x - padding, y - textHeight - padding / 2.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        canvas.drawText(text, x, y, textPaint);
    }

    @SuppressLint(value={"MissingPermission"})
    private static void getCurrentLocation(Activity activity) {
        LocationManager locationManager = (LocationManager)activity.getSystemService("location");
        client = LocationServices.getFusedLocationProviderClient((Activity)activity);
        if (locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network")) {
            client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    final Location location = (Location)task.getResult();
                    if (location != null) {
                        lat = String.valueOf(location.getLatitude());
                        lgt = String.valueOf(location.getLongitude());
                    } else {
                        LocationRequest locationRequest = new LocationRequest().setPriority(100).setInterval(10000L).setFastestInterval(1000L).setNumUpdates(1);
                        LocationCallback locationCallback = new LocationCallback(){

                            public void onLocationResult(LocationResult locationResult) {
                                Location location1 = locationResult.getLastLocation();
                                lat = String.valueOf(location.getLatitude());
                                lgt = String.valueOf(location.getLongitude());
                            }
                        };
                        client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                    }
                }
            });
        }
    }

    private static String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private static void addDateTimeToBitmap(Bitmap bitmap, Activity activity) {
        String currentDateTime = RMDController.getCurrentDateTime();
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(bitmap.getHeight() - 110), (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(100.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = bitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public static interface prerararRMDSBDLocalCallback {
        public void onSuccess(String var1);

        public void onError(String var1);

        public void onSucess();
    }

    public static interface prerararRMDSCallback {
        public void onSuccess(String var1);

        public void onError(String var1);

        public void onSucess();
    }

    public static interface SincronizarDelServidorCallback {
        public void onSuccess();

        public void onError(String var1);
    }

    public static interface GetCountRMDsServidorCallback {
        public void onSuccess(int var1);

        public void onError(String var1);
    }

    public static interface ApiService {
        @Multipart
        @POST(value="Prestamos/FotosRMD.php")
        public Call<ResponseBody> subirFoto(@Part(value="rmd_id") RequestBody var1, @Part MultipartBody.Part var2);
    }

    public static interface SubirRMDsDesincronizadosServidorCallback {
        public void onSuccess();

        public void onError(String var1);
    }

    public static interface PostArticulosDesinconizadosCallback {
        public void onSuccess();

        public void onError(String var1);
    }

    public static interface SubirFotoRetrofitDesdeUriCallback {
        public void onSuccess();

        public void onError(String var1);
    }

    public static interface GetRMDsSinSincronizarCallback {
        public void onSuccess(ArrayList<RMD> var1);

        public void onError(String var1);
    }

    public static interface CountRMDServidorCallback {
        public void onSuccess(int var1);
    }
}

