/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ReporteCreditos;
import java.util.ArrayList;

public class ReporteCreditosController {
    private final DatabaseHelper reporteCreditosMigration;
    private final String NOMBRE_TABLA = "reporte_creditos";

    public ReporteCreditosController(Context contexto) {
        this.reporteCreditosMigration = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.reporteCreditosMigration.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, poblacion_id TEXT, observaciones TEXT, creditos_otorgados TEXT, total_prestamos TEXT, prestamos_nuevos TEXT, monto_nuevos TEXT, prestamos_renovados TEXT, monto_renovados TEXT, empleado_id TEXT, fecha TEXT, fecha_registro TEXT, status TEXT DEFAULT '0')", "reporte_creditos");
        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate() {
        SQLiteDatabase db = this.reporteCreditosMigration.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, poblacion_id TEXT, observaciones TEXT, creditos_otorgados TEXT, total_prestamos TEXT, prestamos_nuevos TEXT, monto_nuevos TEXT, prestamos_renovados TEXT, monto_renovados TEXT, empleado_id TEXT, fecha TEXT, fecha_registro TEXT, status TEXT DEFAULT '0')", "reporte_creditos");
        db.execSQL("DROP TABLE IF EXISTS reporte_creditos");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"reporte_creditos");
    }

    public int eliminar(ReporteCreditos reporteCreditos) {
        SQLiteDatabase db = this.reporteCreditosMigration.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(reporteCreditos.getId())};
        return db.delete("reporte_creditos", "id = ?", argumentos);
    }

    public long nueva(ReporteCreditos reporteCreditos) {
        SQLiteDatabase db = this.reporteCreditosMigration.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", reporteCreditos.getId());
        valoresParaInsertar.put("poblacion_id", reporteCreditos.getPoblacion_id());
        valoresParaInsertar.put("observaciones", reporteCreditos.getObservaciones());
        valoresParaInsertar.put("creditos_otorgados", reporteCreditos.getCreditos_otorgados());
        valoresParaInsertar.put("total_prestamos", reporteCreditos.getTotal_prestamos());
        valoresParaInsertar.put("prestamos_nuevos", reporteCreditos.getPrestamos_nuevos());
        valoresParaInsertar.put("monto_nuevos", reporteCreditos.getMonto_nuevos());
        valoresParaInsertar.put("prestamos_renovados", reporteCreditos.getPrestamos_renovados());
        valoresParaInsertar.put("montos_renovados", reporteCreditos.getMonto_renovados());
        valoresParaInsertar.put("empleado_id", reporteCreditos.getEmpleado_id());
        valoresParaInsertar.put("fecha", reporteCreditos.getFecha());
        valoresParaInsertar.put("fecha_registro", reporteCreditos.getFecha_registro());
        valoresParaInsertar.put("status", reporteCreditos.getStatus());
        return db.insert("reporte_creditos", null, valoresParaInsertar);
    }

    public ArrayList<ReporteCreditos> obtener() {
        String query;
        ArrayList<ReporteCreditos> reportecreditos = new ArrayList<ReporteCreditos>();
        SQLiteDatabase db = this.reporteCreditosMigration.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT * FROM reporte_creditos", null);
        if (cursor == null) {
            return reportecreditos;
        }
        if (!cursor.moveToFirst()) {
            return reportecreditos;
        }
        do {
            String id2 = cursor.getString(0);
            String poblacion_id = cursor.getString(1);
            String observaciones = cursor.getString(2);
            String creditos_otorgados = cursor.getString(3);
            String total_prestamos = cursor.getString(4);
            String prestamos_nuevos = cursor.getString(5);
            String monto_nuevos = cursor.getString(6);
            String prestamos_renovados = cursor.getString(7);
            String montos_renovados = cursor.getString(8);
            String empleado_id = cursor.getString(9);
            String fecha = cursor.getString(10);
            String fecha_registro = cursor.getString(11);
            String status = cursor.getString(12);
            ReporteCreditos reporteObtenidoDeBD = new ReporteCreditos(id2, poblacion_id, observaciones, creditos_otorgados, total_prestamos, prestamos_nuevos, monto_nuevos, prestamos_renovados, montos_renovados, empleado_id, fecha, fecha_registro, status);
            reportecreditos.add(reporteObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return reportecreditos;
    }
}

