/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ReporteDiarioDeRutas;
import java.util.ArrayList;

public class ReporteDiarioDeRutasController {
    private final DatabaseHelper reportediarioderutasMigration;
    private final String NOMBRE_TABLA = "reporte_diario_rutas";

    public ReporteDiarioDeRutasController(Context contexto) {
        this.reportediarioderutasMigration = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.reportediarioderutasMigration.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, poblacion_id TEXT, estimacion TEXT, abonos_semana TEXT, recuperacion_semana TEXT, recuperacion_vencida TEXT, anticipos TEXT, total_1 TEXT, recuperacion_prestamos TEXT, colocacion TEXT, prestamo_colocadora TEXT, comision TEXT, bono_colocadora TEXT, total_2 TEXT, saldo TEXT, pendiente_recuperar TEXT, abonos_recuperar TEXT, comentario TEXT, empleado_id TEXT, gastos_id TEXT, fecha TEXT, fecha_registro TEXT, status TEXT DEFAULT '0')", "reporte_diario_rutas");
        db.execSQL(TABLE_SCHEMA);
    }

    public void truncate() {
        SQLiteDatabase db = this.reportediarioderutasMigration.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id INTEGER PRIMARY KEY, poblacion_id TEXT, estimacion TEXT, abonos_semana TEXT, recuperacion_semana TEXT, recuperacion_vencida TEXT, anticipos TEXT, total_1 TEXT, recuperacion_prestamos TEXT, colocacion TEXT, prestamo_colocadora TEXT, comision TEXT, bono_colocadora TEXT, total_2 TEXT, saldo TEXT, pendiente_recuperar TEXT, abonos_recuperar TEXT, comentario TEXT, empleado_id TEXT, gastos_id TEXT, fecha TEXT, fecha_registro TEXT, status TEXT DEFAULT '0')", "reporte_diario_rutas");
        db.execSQL("DROP TABLE IF EXISTS reporte_diario_rutas");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"reporte_diario_rutas");
    }

    public int eliminar(ReporteDiarioDeRutas reportediarioderutas) {
        SQLiteDatabase db = this.reportediarioderutasMigration.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(reportediarioderutas.getId())};
        return db.delete("reporte_diario_rutas", "id = ?", argumentos);
    }

    public long nueva(ReporteDiarioDeRutas reportediarioderutas) {
        SQLiteDatabase db = this.reportediarioderutasMigration.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", reportediarioderutas.getId());
        valoresParaInsertar.put("poblacion_id", reportediarioderutas.getPoblacion_id());
        valoresParaInsertar.put("estimacion", reportediarioderutas.getEstimacion());
        valoresParaInsertar.put("abonos_semana", reportediarioderutas.getAbonos_semana());
        valoresParaInsertar.put("recuperacion_semana", reportediarioderutas.getRecuperacion_semana());
        valoresParaInsertar.put("recuperacion_vencida", reportediarioderutas.getRecuperacion_vencida());
        valoresParaInsertar.put("anticipos", reportediarioderutas.getAnticipos());
        valoresParaInsertar.put("total_1", reportediarioderutas.getTotal_1());
        valoresParaInsertar.put("recuperacion_prestamos", reportediarioderutas.getRecuperacion_prestamos());
        valoresParaInsertar.put("colocacion", reportediarioderutas.getColocacion());
        valoresParaInsertar.put("prestamo_colocadora", reportediarioderutas.getPrestamo_colocadora());
        valoresParaInsertar.put("comision", reportediarioderutas.getComision());
        valoresParaInsertar.put("bono_colocadora", reportediarioderutas.getBono_colocadora());
        valoresParaInsertar.put("total_2", reportediarioderutas.getBono_colocadora());
        valoresParaInsertar.put("saldo", reportediarioderutas.getSaldo());
        valoresParaInsertar.put("pendiente_recuperar", reportediarioderutas.getPendiente_recuperar());
        valoresParaInsertar.put("abonos_recuperar", reportediarioderutas.getAbonos_recuperar());
        valoresParaInsertar.put("comentario", reportediarioderutas.getComentario());
        valoresParaInsertar.put("empleado_id", reportediarioderutas.getEmpleado_id());
        valoresParaInsertar.put("gastos_id", reportediarioderutas.getGastos_id());
        valoresParaInsertar.put("fecha", reportediarioderutas.getFecha());
        valoresParaInsertar.put("fecha_registro", reportediarioderutas.getFecha_registro());
        valoresParaInsertar.put("status", reportediarioderutas.getStatus());
        return db.insert("reporte_diario_rutas", null, valoresParaInsertar);
    }

    public ArrayList<ReporteDiarioDeRutas> obtener() {
        String query;
        ArrayList<ReporteDiarioDeRutas> reporterutasdiaro = new ArrayList<ReporteDiarioDeRutas>();
        SQLiteDatabase db = this.reportediarioderutasMigration.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT * FROM reporte_diario_rutas", null);
        if (cursor == null) {
            return reporterutasdiaro;
        }
        if (!cursor.moveToFirst()) {
            return reporterutasdiaro;
        }
        do {
            String id2 = cursor.getString(0);
            String poblacion_id = cursor.getString(1);
            String estimacion = cursor.getString(2);
            String abonos_semana = cursor.getString(3);
            String recuperacion_semana = cursor.getString(4);
            String recuperacion_vencida = cursor.getString(5);
            String anticipos = cursor.getString(6);
            String total_1 = cursor.getString(7);
            String recuperacion_prestamos = cursor.getString(8);
            String colocacion = cursor.getString(9);
            String prestamo_colocadora = cursor.getString(10);
            String comision = cursor.getString(11);
            String bono_colocadora = cursor.getString(12);
            String total_2 = cursor.getString(13);
            String saldo = cursor.getString(14);
            String pendiente_recuperar = cursor.getString(15);
            String abonos_recuperar = cursor.getString(16);
            String comentario = cursor.getString(17);
            String empleado_id = cursor.getString(18);
            String gastos_id = cursor.getString(19);
            String fecha = cursor.getString(20);
            String fecha_registro = cursor.getString(21);
            String status = cursor.getString(22);
            ReporteDiarioDeRutas reporteObtenidoDeBD = new ReporteDiarioDeRutas(id2, poblacion_id, estimacion, abonos_semana, recuperacion_semana, recuperacion_vencida, anticipos, total_1, recuperacion_prestamos, colocacion, prestamo_colocadora, comision, bono_colocadora, total_2, saldo, pendiente_recuperar, abonos_recuperar, comentario, empleado_id, gastos_id, fecha, fecha_registro, status);
            reporterutasdiaro.add(reporteObtenidoDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return reporterutasdiaro;
    }
}

