/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import java.util.ArrayList;

public class RutaController {
    private final DatabaseHelper databaseHelper;
    private final String NOMBRE_TABLA = "rutas";

    public RutaController(Context contexto) {
        this.databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key autoincrement, nombre_ruta text, empleado_id int, status int, created_at text, updated_at text)", "rutas");
        db.execSQL(TABLE_SCHEMA);
    }

    public boolean tablaExiste() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = 'rutas'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }

    public ArrayList<Poblacion> getPoblaciones(String ruta) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM poblaciones WHERE ruta_id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{ruta});
        ArrayList<Poblacion> poblaciones = new ArrayList<Poblacion>();
        if (cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(0);
                String nombre = cursor.getString(1);
                poblaciones.add(new Poblacion(id2, nombre));
            } while (cursor.moveToNext());
        }
        return poblaciones;
    }

    public int eliminar(Ruta ruta) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String[] argumentos = new String[]{String.valueOf(ruta.getId())};
        return db.delete("rutas", "id = ?", argumentos);
    }

    public long nueva(Ruta ruta) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT id from RUTAS where rutas.id = " + ruta.getId(), null);
        if (cursor.moveToFirst()) {
            return 0L;
        }
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("id", ruta.getId());
        valoresParaInsertar.put("nombre_ruta", ruta.getNombre_ruta());
        valoresParaInsertar.put("empleado_id", ruta.getEmpleado_id());
        valoresParaInsertar.put("status", ruta.getStatus());
        valoresParaInsertar.put("created_at", ruta.getCreated_at());
        valoresParaInsertar.put("updated_at", ruta.getUpdated_at());
        return db.insert("rutas", null, valoresParaInsertar);
    }

    public void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key autoincrement, nombre_ruta text, empleado_id int, status int, created_at text, updated_at text)", "rutas");
        db.execSQL("DROP TABLE IF EXISTS rutas");
        db.execSQL(TABLE_SCHEMA);
        Log.d((String)"TRUNCATE", (String)"rutas");
    }

    public ArrayList<Ruta> obtener() {
        ArrayList<Ruta> rutas = new ArrayList<Ruta>();
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String[] columnasAConsultar = new String[]{"id", "nombre_ruta", "empleado_id", "status", "created_at", "updated_at"};
        Cursor cursor = db.query("rutas", columnasAConsultar, null, null, null, null, "id DESC");
        if (cursor == null) {
            return rutas;
        }
        if (!cursor.moveToFirst()) {
            return rutas;
        }
        do {
            String id2 = cursor.getString(0);
            String nombre_ruta = cursor.getString(1);
            String empleado_id = cursor.getString(2);
            String status = cursor.getString(3);
            String created_at = cursor.getString(4);
            String updated_at = cursor.getString(5);
            Ruta rutaObtenidaDeBD = new Ruta(id2, nombre_ruta, empleado_id, status, created_at, updated_at);
            rutas.add(rutaObtenidaDeBD);
        } while (cursor.moveToNext());
        cursor.close();
        return rutas;
    }

    public ArrayList<Ruta> getRutas(String rid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM rutas WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{rid});
        ArrayList<Ruta> rutas = new ArrayList<Ruta>();
        if (cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(0);
                String nombre = cursor.getString(1);
                String empleado = cursor.getString(2);
                String status = cursor.getString(3);
                String ca = cursor.getString(4);
                String ua = cursor.getString(5);
                rutas.add(new Ruta(id2, nombre, empleado, status, ca, ua));
            } while (cursor.moveToNext());
        }
        return rutas;
    }

    public ArrayList<Ruta> getRutas() {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM rutas";
        Cursor cursor = db.rawQuery(q, new String[0]);
        ArrayList<Ruta> rutas = new ArrayList<Ruta>();
        if (cursor.moveToFirst()) {
            do {
                String id2 = cursor.getString(0);
                String nombre = cursor.getString(1);
                rutas.add(new Ruta(id2, nombre));
            } while (cursor.moveToNext());
        }
        return rutas;
    }

    public String getNombreRuta(String rid) {
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        String q = "SELECT nombre_ruta FROM rutas WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{rid});
        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return null;
    }
}

