/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.migrations;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.example.sefinsa_app.models.Ruta;

public class RutaMigration
extends SQLiteOpenHelper {
    private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_proyecto2";
    private static final String NOMBRE_TABLA = "rutas";
    private static final int VERSION_BASE_DE_DATOS = 12;

    public RutaMigration(Context context) {
        super(context, NOMBRE_BASE_DE_DATOS, null, 12);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(String.format("CREATE TABLE IF NOT EXISTS %s(id integer primary key, nombre_ruta text, empleado_id int, status int, created_at text, updated_at text) ", NOMBRE_TABLA));
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(String.format("DROP TABLE IF EXISTS rutas", new Object[0]));
        this.onCreate(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS rutas");
        this.onCreate(db);
    }

    public void deleteAllRutas() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("DELETE FROM rutas");
        db.close();
    }

    public boolean doesRutaExist(SQLiteDatabase db, String id2) {
        String query = "SELECT COUNT(*) FROM rutas WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        boolean exists = false;
        if (cursor != null) {
            cursor.moveToFirst();
            exists = cursor.getInt(0) > 0;
            cursor.close();
        }
        return exists;
    }

    public Ruta getRutaById(SQLiteDatabase db, String id2) {
        String query = "SELECT id, nombre_ruta, empleado_id, status, created_at, updated_at  FROM rutas WHERE id = ?";
        Log.d((String)"getRutaById", (String)("Ejecutando consulta: " + query + " con id: " + id2));
        Cursor cursor = db.rawQuery(query, new String[]{id2});
        Ruta ruta = null;
        if (cursor != null && cursor.moveToFirst()) {
            String id22 = cursor.getString(0);
            String nombre_ruta = cursor.getString(1);
            String empleado_id = cursor.getString(2);
            String status = cursor.getString(3);
            String created_at = cursor.getString(4);
            String updated_at = cursor.getString(5);
            ruta = new Ruta(id22, nombre_ruta, empleado_id, status, created_at, updated_at);
            cursor.close();
        } else {
            Log.e((String)"getClienteById", (String)("No se encontr\u00f3 ning\u00fan registro con el id: " + id2));
        }
        return ruta;
    }

    public void updateRutaInSQLite(SQLiteDatabase db, Ruta ruta) {
        ContentValues values = new ContentValues();
        values.put("nombre_ruta", ruta.getNombre_ruta());
        values.put("empleado_id", ruta.getEmpleado_id());
        values.put("status", ruta.getStatus());
        values.put("created_at", ruta.getCreated_at());
        values.put("updated_at", ruta.getUpdated_at());
        db.update(NOMBRE_TABLA, values, "id = ?", new String[]{ruta.getId()});
    }
}

