/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.avales;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.NetworkSpeedChecker;
import com.example.sefinsa_app.VolleySingleton;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.AvalesViewModel;
import com.example.sefinsa_app.utilities.AvalesAdapter;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AvalesFragment
extends Fragment
implements NetworkChangeReceiver.NetworkChangeListener {
    private AvalesViewModel mViewModel;
    public static ArrayList<Aval> avales;
    public static ArrayList<Aval> avalesFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;
    public static SearchView svAvales;
    private static ShimmerFrameLayout shimmer;
    private static RecyclerView recyclerView;
    public static AvalesAdapter avalesAdapter;
    private LinearLayoutManager linearLayoutManager;
    private FloatingActionButton fabCrearAval;
    private boolean isReceiverRegistered = false;
    private boolean isNetworkReceiverRegistered = false;
    private SharedPreferences sesion;
    private TextView textViewMensajes;
    private AvalController avalController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private ArrayList<Ruta> rutas;
    private ArrayList<Poblacion> poblaciones;
    private ArrayList<Colocadora> colocadoras;
    private static ProgressDialog dialog;
    private NetworkChangeReceiver networkChangeReceiver;
    private NetworkSpeedChecker speedChecker;
    private boolean isConnected = true;
    private static boolean isShimmerActive;
    private int retryCount = 0;
    private static final int MAX_RETRIES = 80;
    private static final int BATCH_SIZE = 10;
    private int offset = 0;
    private boolean isLoading = false;
    private static boolean isFiltering;
    private final Handler handler = new Handler(Looper.getMainLooper());

    public static AvalesFragment newInstance() {
        return new AvalesFragment();
    }

    public boolean isFragmentVisible() {
        return this.isVisible();
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                avales.clear();
                avalesFiltrados.clear();
                if (avalesAdapter != null) {
                    avalesAdapter.clear();
                    avalesAdapter.notifyDataSetChanged();
                }
                if (this.requestQueue != null) {
                    this.requestQueue.getCache().clear();
                }
                if (shimmer != null) {
                    shimmer.setVisibility(0);
                    shimmer.startShimmer();
                    isShimmerActive = true;
                }
                this.refrescarAvalesDesdeServidor();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void refrescarAvalesDesdeServidor() {
        if (!this.isAdded() || this.getContext() == null) {
            return;
        }
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"indexApp_lotes");
            data.put("page", 0);
            data.put("size", 999999);
        }
        catch (JSONException e) {
            e.printStackTrace();
            AvalesFragment.stopShimmer();
            return;
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, response -> {
            try {
                JSONArray dataArray = response.getJSONArray("data");
                ArrayList<Aval> avalesServidor = new ArrayList<Aval>();
                Gson gson = new Gson();
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject obj = dataArray.getJSONObject(i);
                    Aval aval = (Aval)gson.fromJson(obj.toString(), Aval.class);
                    avalesServidor.add(aval);
                }
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.execute(() -> {
                    DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
                    SQLiteDatabase db = dbHelper.getWritableDatabase();
                    db.beginTransaction();
                    try {
                        for (Aval aval : avalesServidor) {
                            ContentValues values = new ContentValues();
                            values.put("id", aval.getId());
                            values.put("nombre_completo", aval.getNombre_completo());
                            values.put("direccion", aval.getDireccion());
                            values.put("telefono", aval.getTelefono());
                            values.put("garantias", aval.getGarantias());
                            values.put("carpeta_comprobantes", aval.getCarpeta_comprobantes());
                            values.put("carpeta_garantias", aval.getCarpeta_garantias());
                            values.put("otras_referencias", aval.getOtras_referencias());
                            values.put("created_at", aval.getCreated_at());
                            values.put("updated_at", aval.getUpdated_at());
                            values.put("update_comprobantes", aval.getUpdate_comprobantes_Enaval());
                            values.put("update_garantias", aval.getUpdate_garantias_Enaval());
                            values.put("ruta_id", aval.getRuta_id() != null ? aval.getRuta_id() : "NULL");
                            values.put("poblacion_id", aval.getPoblacion_id() != null ? aval.getPoblacion_id() : "NULL");
                            values.put("colocadora_id", aval.getColocadora_id() != null ? aval.getColocadora_id() : "NULL");
                            db.insertWithOnConflict("avales", null, values, 5);
                        }
                        db.setTransactionSuccessful();
                    }
                    finally {
                        db.endTransaction();
                        db.close();
                    }
                    ArrayList<Aval> avalesActualizados = new ArrayList<Aval>();
                    SQLiteDatabase dbRead = dbHelper.getReadableDatabase();
                    Cursor cursor = dbRead.rawQuery("SELECT * FROM avales ORDER BY id DESC", null);
                    if (cursor != null && cursor.moveToFirst()) {
                        do {
                            Aval aval = new Aval(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("created_at")), cursor.getString(cursor.getColumnIndexOrThrow("updated_at")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")));
                            avalesActualizados.add(aval);
                        } while (cursor.moveToNext());
                        cursor.close();
                    }
                    dbRead.close();
                    this.getActivity().runOnUiThread(() -> {
                        avales.clear();
                        avales.addAll(avalesActualizados);
                        AvalesFragment.updateUIWithAvales(avales);
                        AvalesFragment.stopShimmer();
                    });
                });
                executor.shutdown();
            }
            catch (JSONException e) {
                e.printStackTrace();
                AvalesFragment.stopShimmer();
            }
        }, error -> {
            Log.e((String)"AvalesFragment", (String)("Error al refrescar avales: " + error.toString()));
            AvalesFragment.stopShimmer();
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(15000, 1, 1.0f));
        VolleySingleton.getInstance(this.getContext()).addToRequestQueue(request);
    }

    private void cargarAvalesDesdeSQLiteDesc() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            String query = "SELECT * FROM avales ORDER BY id DESC";
            Cursor cursor = db.rawQuery(query, null);
            ArrayList<Aval> nuevosAvales = new ArrayList<Aval>();
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    Aval aval = new Aval(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("created_at")), cursor.getString(cursor.getColumnIndexOrThrow("updated_at")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")));
                    nuevosAvales.add(aval);
                } while (cursor.moveToNext());
                cursor.close();
            }
            db.close();
            this.getActivity().runOnUiThread(() -> {
                avales.clear();
                avales.addAll(nuevosAvales);
                AvalesFragment.updateUIWithAvales(avales);
            });
            executor.shutdown();
        });
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        this.requireActivity().setRequestedOrientation(-1);
        this.networkChangeReceiver = new NetworkChangeReceiver(this);
        return inflater.inflate(2131492950, container, false);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (svAvales != null) {
            svAvales.setQuery((CharSequence)"", false);
        }
    }

    public static void startShimmer() {
        if (shimmer != null) {
            shimmer.startShimmer();
            shimmer.setVisibility(0);
            isShimmerActive = true;
        }
    }

    public static void stopShimmer() {
        if (shimmer != null) {
            shimmer.stopShimmer();
            shimmer.setVisibility(8);
            isShimmerActive = false;
        }
    }

    public void onPause() {
        super.onPause();
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.retryCount = 0;
        this.vs = VolleyS.getInstance(this.requireContext());
        this.requestQueue = this.vs.getRequestQueue();
        CurrentFragment.fragment = "AvalesFragment";
        this.textViewMensajes = (TextView)this.requireActivity().findViewById(2131296802);
        this.sesion = this.requireActivity().getSharedPreferences("sesion", 0);
        this.avalController = new AvalController((Context)this.requireActivity());
        this.rutaController = new RutaController((Context)this.requireActivity());
        this.poblacionController = new PoblacionController((Context)this.requireActivity());
        this.colocadoraController = new ColocadoraController((Context)this.requireActivity());
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        avales = new ArrayList();
        FragmentManager fm = this.requireActivity().getSupportFragmentManager();
        for (int i = 0; i < fm.getBackStackEntryCount(); ++i) {
            fm.popBackStack();
        }
        shimmer = (ShimmerFrameLayout)view.findViewById(2131297034);
        AvalesFragment.startShimmer();
        recyclerView = (RecyclerView)view.findViewById(2131296976);
        svAvales = (SearchView)view.findViewById(2131297081);
        this.fabCrearAval = (FloatingActionButton)view.findViewById(2131296633);
        avales = new ArrayList();
        if (this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            this.fabCrearAval.setVisibility(4);
        }
        this.fabCrearAval.setOnClickListener(view1 -> {
            try {
                Navigation.findNavController((Activity)this.requireActivity(), (int)2131296862).navigate(2131296844);
            }
            catch (Exception e) {
                Log.e((String)"NavigationError", (String)"Error al navegar", (Throwable)e);
                Toast.makeText((Context)this.requireActivity(), (CharSequence)"Error al navegar", (int)0).show();
            }
        });
        svAvales.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                AvalesFragment.this.filtrarAvales(query);
                return false;
            }

            public boolean onQueryTextChange(String newText) {
                AvalesFragment.this.filtrarAvales(newText);
                return false;
            }
        });
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        avalesAdapter = new AvalesAdapter((Context)this.requireActivity(), avales);
        recyclerView.setAdapter((RecyclerView.Adapter)avalesAdapter);
        if (!this.sesion.getString("nombre_perfil", "").equals("JURIDICO")) {
            dialog = new ProgressDialog((Context)this.requireActivity(), 2131951627);
            dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
            dialog.setCanceledOnTouchOutside(false);
            dialog.show();
        }
        if (!this.isNetworkAvailable()) {
            AvalesWorker.isTaskAvalesCompleted = true;
            this.checkForUpdatesAndLoadCache();
            AvalesFragment.stopShimmer();
            recyclerView.setVisibility(0);
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    AvalesFragment.this.checkForUpdatesAndLoadCache();
                }
            }, 500L);
        }
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (isFiltering) {
                    return;
                }
                LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                if (layoutManager != null && !AvalesFragment.this.isLoading) {
                    int preloadMargin;
                    int visibleItemCount = layoutManager.getChildCount();
                    int totalItemCount = layoutManager.getItemCount();
                    int pastVisibleItems = layoutManager.findFirstVisibleItemPosition();
                    if (visibleItemCount + pastVisibleItems >= totalItemCount - (preloadMargin = 5)) {
                        recyclerView.post(() -> AvalesFragment.this.loadMoreAvales());
                    }
                }
            }
        });
        if (!this.isAdded() || this.getContext() == null) {
            Log.e((String)"ClientesFragment", (String)"El fragmento no est\u00e1 listo. Operaci\u00f3n abortada onResume.");
            return;
        }
        avales.clear();
        avalesAdapter.notifyDataSetChanged();
        this.getRutas();
        this.getPoblaciones();
        if (this.rutaController.tablaExiste() && this.poblacionController.tablaExiste()) {
            this.getColocadoras();
        }
        if (this.isNetworkAvailable()) {
            this.countAvalesInSQLite(this.requireContext(), 2, new CountAvalesCallback(){

                @Override
                public void onResult(boolean result) {
                    if (result) {
                        AvalesWorker.currentPageAvales = 0;
                        AvalesWorker.allDataLoadedAvales = false;
                        AvalesWorker.isTaskAvalesCompleted = false;
                        AvalesWorker.enqueueWork(AvalesFragment.this.requireContext());
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                AvalesFragment.this.checkForUpdatesAndLoadCache();
                            }
                        }, 3000L);
                        Log.d((String)"PRESTAMOS", (String)"Cargando enqueueWork menos de 2 registros.");
                    } else {
                        AvalesWorker.currentPageAvales = 0;
                        AvalesWorker.allDataLoadedAvales = true;
                        AvalesWorker.isTaskAvalesCompleted = false;
                        AvalesWorker.enqueueWork(AvalesFragment.this.requireContext());
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                AvalesFragment.this.checkForUpdatesAndLoadCache();
                            }
                        }, 1000L);
                        Log.d((String)"PRESTAMOS", (String)"Cargando desde cach\u00e9, m\u00e1s de 2 registros.");
                    }
                }
            });
        } else {
            AvalesWorker.isTaskAvalesCompleted = true;
            AvalesFragment.stopShimmer();
            recyclerView.setVisibility(0);
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    AvalesFragment.this.checkForUpdatesAndLoadCache();
                }
            }, 500L);
        }
    }

    public void onResume() {
        super.onResume();
    }

    private void checkForUpdatesAndLoadCache() {
        if (!this.isAdded() || this.getContext() == null) {
            Log.e((String)"AvalesFragment", (String)"El fragmento no est\u00e1 adjunto. Operaci\u00f3n abortada.");
            return;
        }
        if (AvalesWorker.isTaskAvalesCompleted) {
            Log.d((String)"Avales", (String)("Cargando AvalesWorker.isTaskAvalesCompleted: " + AvalesWorker.isTaskAvalesCompleted));
            this.cargarAvalesDesdeSQLite(this.offset, 10);
            AvalesWorker.isTaskAvalesCompleted = false;
            this.retryCount = 0;
        } else if (this.retryCount < 80) {
            ++this.retryCount;
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                if (this.isAdded() && this.getContext() != null) {
                    this.checkForUpdatesAndLoadCache();
                } else {
                    Log.e((String)"ClientesFragment", (String)"El fragmento no est\u00e1 adjunto. Operaci\u00f3n abortada.");
                    this.cargarAvalesDesdeSQLite(this.offset, 10);
                }
            }, 2000L);
        } else {
            Log.d((String)"PRESTAMOS", (String)"N\u00famero m\u00e1ximo de reintentos alcanzado. No se puede cargar la cach\u00e9.");
        }
    }

    private void cargarAvalesDesdeSQLite(int offset, int batchSize) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            String query = "SELECT avales.* FROM avales GROUP BY avales.id ORDER BY avales.id DESC LIMIT ? OFFSET ?";
            Cursor cursor = db.rawQuery(query, new String[]{String.valueOf(batchSize), String.valueOf(offset)});
            ArrayList<Aval> nuevosAvales = new ArrayList<Aval>();
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    Aval aval = new Aval(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("created_at")), cursor.getString(cursor.getColumnIndexOrThrow("updated_at")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")));
                    nuevosAvales.add(aval);
                } while (cursor.moveToNext());
                cursor.close();
            }
            db.close();
            int totalAvales = nuevosAvales.size();
            this.getActivity().runOnUiThread(() -> {
                if (this.isAdded() && this.isVisible() && this.getActivity() != null) {
                    avales.addAll(nuevosAvales);
                    if (totalAvales > 0 && this.isAdded() && this.isVisible()) {
                        Log.d((String)"ClientesFragment", (String)("totalAvales avales para updateUIWithClientes." + avales.size()));
                        AvalesFragment.updateUIWithAvales(avales);
                        this.isLoading = false;
                    } else {
                        Log.d((String)"AvalesFragment", (String)"No hay m\u00e1s avales para cargar.");
                    }
                }
            });
            executor.shutdown();
        });
    }

    public static void updateUIWithAvales(List<Aval> avales) {
        if (avales == null || avales.isEmpty()) {
            Log.w((String)"AvalesFragment", (String)"La lista de clientes est\u00e1 vac\u00eda o es nula. No hay nada que mostrar.");
            return;
        }
        for (Aval aval : avales) {
            if (aval != null) continue;
            Log.e((String)"AvalesFragment", (String)"Se encontr\u00f3 un cliente nulo en la lista.");
            return;
        }
        if (avalesAdapter == null) {
            Log.e((String)"AvalesFragment", (String)"El adaptador de clientes es nulo. Aseg\u00farate de inicializarlo.");
            return;
        }
        if (recyclerView == null) {
            Log.e((String)"AvalesFragment", (String)"El RecyclerView no est\u00e1 inicializado.");
            return;
        }
        avalesAdapter.setListaFiltrada((ArrayList)avales);
        avalesAdapter.notifyDataSetChanged();
        Log.d((String)"AvalesFragment", (String)("Avales Adapter Data (despu\u00e9s): " + avalesAdapter.getItemCount()));
        if (recyclerView.getVisibility() != 0) {
            recyclerView.setVisibility(0);
            Log.d((String)"AvalesFragment", (String)"RecyclerView ahora est\u00e1 visible.");
        }
        if (shimmer != null && shimmer.getVisibility() == 0) {
            Log.d((String)"AvalesFragment", (String)"Deteniendo el shimmer...");
            AvalesFragment.stopShimmer();
            isShimmerActive = false;
        }
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.requireContext().getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;
        if (this.speedChecker == null) {
            this.speedChecker = new NetworkSpeedChecker((Context)this.requireActivity(), this.textViewMensajes);
        }
        if (isConnected) {
            this.speedChecker.startChecking();
            AvalesWorker.isTaskAvalesCompleted = false;
            AvalesWorker.enqueueWork(this.getContext());
            this.checkForUpdatesAndLoadCache();
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            }
        } else {
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"\u00a1SIN INTERNET!");
                AvalesFragment.stopShimmer();
                recyclerView.setVisibility(0);
            }
            if (this.speedChecker != null) {
                this.speedChecker.stopChecking();
                AvalesFragment.stopShimmer();
                recyclerView.setVisibility(0);
            }
        }
        if ((this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) && isConnected && AvalesWorker.allDataLoadedAvales) {
            this.hideTextViewAfterDelay();
        }
    }

    private void hideTextViewAfterDelay() {
        if (this.textViewMensajes != null && this.textViewMensajes.getVisibility() == 0) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            }, 3000L);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.speedChecker != null) {
            this.speedChecker.stopChecking();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.handler.removeCallbacksAndMessages(null);
    }

    private void countAvalesInSQLite(Context context, int threshold, CountAvalesCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            int totalAvales;
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM avales", null);
            if (cursor != null) {
                totalAvales = cursor.moveToFirst() ? cursor.getInt(0) : 0;
                cursor.close();
            } else {
                totalAvales = 0;
            }
            db.close();
            Log.d((String)"SQLite", (String)("Total registros en SQLite: " + totalAvales));
            this.getActivity().runOnUiThread(() -> callback.onResult(totalAvales < threshold));
            executor.shutdown();
        });
    }

    private void buscarAvales(String query) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            if (this.isAdded() && this.getContext() != null) {
                DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
                SQLiteDatabase db = dbHelper.getReadableDatabase();
                Log.d((String)"AvalesFragment", (String)("Ejecutando b\u00fasqueda en la base de datos con query: " + query));
                String sqlQuery = "SELECT avales.*, clientes.nombre_completo as nombre_cliente, clientes.direccion as direccion_cliente, clientes.telefono as telefono_cliente FROM avales LEFT JOIN prestamos ON prestamos.aval_id = avales.id LEFT JOIN clientes ON clientes.id = prestamos.cliente_id WHERE avales.nombre_completo LIKE ? ORDER BY avales.id DESC ";
                Cursor cursor = db.rawQuery(sqlQuery, new String[]{"%" + query + "%"});
                if (cursor != null && cursor.moveToFirst()) {
                    Log.d((String)"AvalesFragment", (String)("Avales encontrados en la base de datos: " + cursor.getCount()));
                    HashSet<String> idsEncontrados = new HashSet<String>();
                    do {
                        String avalId;
                        if (idsEncontrados.contains(avalId = cursor.getString(cursor.getColumnIndexOrThrow("id")))) continue;
                        Aval aval = new Aval(avalId, cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("created_at")), cursor.getString(cursor.getColumnIndexOrThrow("updated_at")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")));
                        avales.add(aval);
                        idsEncontrados.add(avalId);
                        if (avalesFiltrados == null) {
                            avalesFiltrados = new ArrayList();
                        }
                        avalesFiltrados.add(aval);
                        this.getActivity().runOnUiThread(() -> {
                            avalesAdapter.setListaFiltrada(avalesFiltrados);
                            avalesAdapter.notifyItemInserted(avalesFiltrados.size() - 1);
                        });
                    } while (cursor.moveToNext());
                    cursor.close();
                } else {
                    Log.d((String)"AvalesFragment", (String)("No se encontraron avales para la query: " + query));
                }
                db.close();
            } else {
                Log.e((String)"AvalesFragment", (String)"Fragment no activo o contexto no disponible.");
            }
            executor.shutdown();
        });
    }

    public void filtrarAvales(String text) {
        Log.d((String)"AvalesFragment", (String)("Texto para filtrar: " + text));
        if (text.isEmpty()) {
            Log.d((String)"AvalesFragment", (String)"Texto vac\u00edo, restableciendo lista completa.");
            avalesFiltrados = new ArrayList<Aval>(avales);
            isFiltering = false;
            avalesAdapter.setListaFiltrada(avalesFiltrados);
            avalesAdapter.notifyDataSetChanged();
        } else {
            Log.d((String)"AvalesFragment", (String)"Realizando filtrado en memoria.");
            HashSet<Aval> uniqueAvalesFiltrados = new HashSet<Aval>();
            for (Aval aval : avales) {
                String textoFiltro = aval.getNombre_completo();
                if (!textoFiltro.toLowerCase().contains(text.toLowerCase())) continue;
                uniqueAvalesFiltrados.add(aval);
            }
            avalesFiltrados = new ArrayList(uniqueAvalesFiltrados);
            Log.d((String)"AvalesFragment", (String)("Avales encontrados en memoria: " + avalesFiltrados.size()));
            if (!avalesFiltrados.isEmpty()) {
                isFiltering = true;
                avalesAdapter.setListaFiltrada(avalesFiltrados);
                avalesAdapter.notifyDataSetChanged();
            } else {
                Log.d((String)"AvalesFragment", (String)"No se encontraron coincidencias en memoria. Buscando en SQLite.");
                this.buscarAvales(text);
            }
        }
    }

    private void loadMoreAvales() {
        if (!this.isLoading) {
            this.isLoading = true;
            this.offset += 10;
            this.cargarAvalesDesdeSQLite(this.offset, 10);
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.isReceiverRegistered) {
            this.isReceiverRegistered = true;
        }
        if (!this.isNetworkReceiverRegistered) {
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.requireActivity().registerReceiver((BroadcastReceiver)this.networkChangeReceiver, filter);
            this.isNetworkReceiverRegistered = true;
        }
        if (this.speedChecker != null) {
            this.speedChecker.startChecking();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.isReceiverRegistered) {
            this.isReceiverRegistered = false;
        }
        if (this.isNetworkReceiverRegistered) {
            this.requireActivity().unregisterReceiver((BroadcastReceiver)this.networkChangeReceiver);
            this.isNetworkReceiverRegistered = false;
        }
        if (this.speedChecker != null) {
            this.speedChecker.stopChecking();
        }
    }

    private void getPoblaciones() {
        if (this.poblacionController.obtener().isEmpty()) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, response -> {
                try {
                    JSONArray data1 = (JSONArray)response.get("data");
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Gson gson = new Gson();
                        Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                        this.poblaciones.add(poblacion);
                        this.poblacionController.nueva(poblacion);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> ErrorChecker.checker(error, (Context)this.requireActivity()));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(80000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
        }
    }

    private void getRutas() {
        if (this.rutaController.obtener().isEmpty()) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, response -> {
                try {
                    JSONArray data1 = (JSONArray)response.get("data");
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Gson gson = new Gson();
                        Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                        this.rutas.add(ruta);
                        this.rutaController.nueva(ruta);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> ErrorChecker.checker(error, (Context)this.requireActivity()));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        }
    }

    private void getColocadoras() {
        if (this.colocadoraController.obtener().isEmpty()) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, response -> {
                try {
                    JSONArray data1 = (JSONArray)response.get("data");
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Gson gson = new Gson();
                        Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                        this.colocadoras.add(colocadora);
                        this.colocadoraController.nueva(colocadora);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> ErrorChecker.checker(error, (Context)this.requireActivity()));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.colocadoras = this.colocadoraController.obtener();
        }
    }

    static {
        isShimmerActive = false;
        isFiltering = false;
    }

    private static interface CountAvalesCallback {
        public void onResult(boolean var1);
    }
}

