/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.avales.crear;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.crear.AvalesCrearViewModel;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesCrearFragment
extends Fragment
implements AvalesFotosFragment.OnPhotosSelectedListener {
    private AvalesCrearViewModel mViewModel;
    private Button btnRegistrarAval;
    private Button btnSubirFotos;
    private TextInputLayout tlNombreAval;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlGarantiasAval;
    private Uri image_uri;
    private Uri uri;
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private final boolean camaraGarantiasClienteAbierta = false;
    private final boolean camaraComprobantesClienteAbierta = false;
    private final boolean camaraGarantiasAvalAbierta = false;
    private final boolean camaraComprobantesAvalAbierta = false;
    private final boolean camarapathsINEAval = false;
    private final boolean camarapathsFotoAval = false;
    private final boolean camarapathsFachadaAval = false;
    private AutoCompleteTextView clientesAutoCompleteTextView;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView avalesAutoCompleteTextView;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private ArrayList<Aval> avales;
    private ArrayAdapter<Aval> avalesAdapter;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private String aval_id = "";
    private int previousLengthAval;
    private boolean backSpaceAval;
    private AvalController avalController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private SharedPreferences sesion;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private ArrayList<String> pathsFotoAval;
    private ArrayList<String> pathsIneAval;
    private ArrayList<String> pathsFachadaAval;
    List<MultipartBody.Part> archivosGeneral;
    Bundle bundle;
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
    String path;
    String lat = "";
    String lgt = "";
    private int banderaGarantiasAval;
    private int banderaComprobantesAval;
    Button btnUbicacion;
    FusedLocationProviderClient client;

    public static AvalesCrearFragment newInstance() {
        return new AvalesCrearFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492951, container, false);
    }

    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval2, ArrayList<String> pathsGarantiasAval2, ArrayList<String> pathsIneAval2, ArrayList<String> pathsFotoAval2, ArrayList<String> pathsFachadaAval2, List<MultipartBody.Part> archivosGeneral2) {
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        }
        this.archivosGeneral.clear();
        if (this.pathsComprobantesAval == null) {
            this.pathsComprobantesAval = new ArrayList();
        }
        this.pathsComprobantesAval.clear();
        if (this.pathsGarantiasAval == null) {
            this.pathsGarantiasAval = new ArrayList();
        }
        this.pathsGarantiasAval.clear();
        if (this.pathsIneAval == null) {
            this.pathsIneAval = new ArrayList();
        }
        this.pathsIneAval.clear();
        if (this.pathsFotoAval == null) {
            this.pathsFotoAval = new ArrayList();
        }
        this.pathsFotoAval.clear();
        if (this.pathsFachadaAval == null) {
            this.pathsFachadaAval = new ArrayList();
        }
        this.pathsFachadaAval.clear();
        if (pathsIneAval2 != null) {
            this.pathsIneAval.addAll(pathsIneAval2);
        }
        if (pathsComprobantesAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsComprobantesAval2);
        }
        if (pathsFotoAval2 != null) {
            this.pathsFotoAval.addAll(pathsFotoAval2);
        }
        if (pathsFachadaAval2 != null) {
            this.pathsFachadaAval.addAll(pathsFachadaAval2);
        }
        if (pathsGarantiasAval2 != null) {
            this.pathsGarantiasAval.addAll(pathsGarantiasAval2);
        }
        int index = 0;
        if (this.pathsIneAval != null) {
            for (String path : this.pathsIneAval) {
                this.procesarArchivo(path, index, "CA.jpeg");
                ++index;
            }
        }
        if (this.pathsComprobantesAval != null) {
            for (String path : this.pathsComprobantesAval) {
                this.procesarArchivo(path, index, "CA.jpeg");
                ++index;
            }
        }
        if (this.pathsFotoAval != null) {
            for (String path : this.pathsFotoAval) {
                this.procesarArchivo(path, index, "CA.jpeg");
                ++index;
            }
        }
        if (this.pathsFachadaAval != null) {
            for (String path : this.pathsFachadaAval) {
                this.procesarArchivo(path, index, "CA.jpeg");
                ++index;
            }
        }
        int indexGarantias = 0;
        if (this.pathsGarantiasAval != null) {
            for (String path : this.pathsGarantiasAval) {
                this.procesarArchivoGarantia(path, indexGarantias);
                ++indexGarantias;
            }
        }
    }

    private void procesarArchivo(String path, int index, String suffix) {
        File file = new File(path);
        if (file.exists()) {
            try {
                Bitmap bitmap = BitmapFactory.decodeFile((String)path);
                Bitmap reduceBitmap = this.resizeBitmap(bitmap, 1400);
                File compressedFile = this.saveBitmapToFile(reduceBitmap);
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)compressedFile);
                MultipartBody.Part body = MultipartBody.Part.createFormData((String)("archivo_aval_" + index), (String)(index + suffix), (RequestBody)requestFile);
                this.archivosGeneral.add(body);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Log.d((String)"log", (String)("El archivo no existe: " + path));
        }
    }

    private void procesarArchivoGarantia(String path, int index) {
        File file = new File(path);
        if (file.exists()) {
            try {
                Bitmap bitmap = BitmapFactory.decodeFile((String)path);
                Bitmap reduceBitmap = this.resizeBitmap(bitmap, 1400);
                File compressedFile = this.saveBitmapToFile(reduceBitmap);
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)compressedFile);
                MultipartBody.Part body = MultipartBody.Part.createFormData((String)("garantia_aval_" + index), (String)(index + "GA.jpeg"), (RequestBody)requestFile);
                this.archivosGeneral.add(body);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Log.d((String)"log", (String)("El archivo de garant\u00eda no existe: " + path));
        }
    }

    private Bitmap makeMutable(Bitmap bitmap) {
        return bitmap.copy(Bitmap.Config.ARGB_8888, true);
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int height;
        int width = bitmap.getWidth();
        float bitmapRatio = (float)width / (float)(height = bitmap.getHeight());
        if (bitmapRatio > 1.0f) {
            width = maxSize;
            height = (int)((float)width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int)((float)height * bitmapRatio);
        }
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        this.addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }

    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
        fos.flush();
        fos.close();
        return file;
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        Bitmap mutableBitmap = this.makeMutable(bitmap);
        String currentDateTime = this.getCurrentDateTime();
        Canvas canvas = new Canvas(mutableBitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(mutableBitmap.getHeight() - 40), (float)mutableBitmap.getWidth(), (float)mutableBitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(18.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = mutableBitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private void showAlert(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setMessage((CharSequence)message);
        TextView title = new TextView((Context)this.getActivity());
        title.setText((CharSequence)"Alerta");
        title.setGravity(17);
        title.setTextSize(2, 20.0f);
        title.setTextColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170444));
        title.setPadding(0, 20, 0, 20);
        builder.setCustomTitle((View)title);
        builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.initElements(view);
        this.avales = new ArrayList();
        this.avalesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.avales);
        this.avalesAutoCompleteTextView.setThreshold(1);
        this.avalesAutoCompleteTextView.setAdapter(this.avalesAdapter);
        this.avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (!AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().isEmpty() || AvalesCrearFragment.this.tlNombreAval.getEditText().getText() != null) {
                    ClienteController cc = new ClienteController(AvalesCrearFragment.this.getContext());
                    String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                    if (Objects.equals(prestaNombre, "1")) {
                        AlertDialog.Builder b = new AlertDialog.Builder(AvalesCrearFragment.this.getContext());
                        b.setTitle((CharSequence)"Aviso");
                        b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                        b.setPositiveButton((CharSequence)"Aceptar", null);
                        AvalesCrearFragment.this.tlNombreAval.getEditText().setText((CharSequence)"");
                        AlertDialog dialog = b.create();
                        dialog.show();
                    } else {
                        Aval aval = (Aval)AvalesCrearFragment.this.avalesAdapter.getItem(i);
                        AvalesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
                        AvalesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
                        AvalesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
                        AvalesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
                    }
                } else {
                    Aval aval = (Aval)AvalesCrearFragment.this.avalesAdapter.getItem(i);
                    AvalesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
                    AvalesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
                    AvalesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
                    AvalesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
                }
            }
        });
        this.avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                AvalesCrearFragment.this.previousLengthAval = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AvalesCrearFragment.this.backSpaceAval = AvalesCrearFragment.this.previousLengthAval > s.length();
                if (AvalesCrearFragment.this.backSpaceAval && !AvalesCrearFragment.this.aval_id.equals("")) {
                    AvalesCrearFragment.this.avalesAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.aval_id = "";
                }
            }
        });
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)AvalesCrearFragment.this.rutasAdapter.getItem(i);
                AvalesCrearFragment.this.ruta_id = ruta.getId();
                if (AvalesCrearFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (AvalesCrearFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List poblacionesFiltro = AvalesCrearFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(AvalesCrearFragment.this.ruta_id)).collect(Collectors.toList());
                AvalesCrearFragment.this.poblacionesAdapter = new ArrayAdapter(AvalesCrearFragment.this.getContext(), 17367050, poblacionesFiltro);
                AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)AvalesCrearFragment.this.poblacionesAdapter);
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones(this.ruta_id);
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)AvalesCrearFragment.this.poblacionesAdapter.getItem(i);
                AvalesCrearFragment.this.poblacion_id = poblacion.getId();
                if (AvalesCrearFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List colocadorasFiltro = AvalesCrearFragment.this.colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(AvalesCrearFragment.this.poblacion_id)).collect(Collectors.toList());
                AvalesCrearFragment.this.colocadorasAdapter = new ArrayAdapter(AvalesCrearFragment.this.getContext(), 17367050, colocadorasFiltro);
                AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)AvalesCrearFragment.this.colocadorasAdapter);
            }
        });
        if (this.colocadoras.size() == 0) {
            this.getColocadoras();
        }
        this.colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Colocadora colocadora = (Colocadora)AvalesCrearFragment.this.colocadorasAdapter.getItem(i);
                AvalesCrearFragment.this.colocadora_id = colocadora.getId();
            }
        });
        this.btnSubirFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();
                Bundle args = new Bundle();
                args.putString("aval", "");
                args.putString("avalNombre", "Nuevo Aval");
                dialogFragment.setArguments(args);
                dialogFragment.show(AvalesCrearFragment.this.getChildFragmentManager(), "AvalesFotosDialog");
            }
        });
        this.btnRegistrarAval.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AvalesCrearFragment.this.aval_id.equals("")) {
                    if (Validator.fieldValidation(AvalesCrearFragment.this.tlNombreAval, "Ingresa un nombre de Aval") && Validator.fieldValidation(AvalesCrearFragment.this.tlTelefonoAval, "Ingresa un tel\u00e9fono") && Validator.fieldValidation(AvalesCrearFragment.this.tlDireccionAval, "Ingresa una direcci\u00f3n") && Validator.fieldValidation(AvalesCrearFragment.this.tlOtrasReferenciasAval, "Ingresa otras referencias") && Validator.fieldValidation(AvalesCrearFragment.this.tlGarantiasAval, "Ingresa otras garant\u00edas")) {
                        if (!AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().isEmpty() || AvalesCrearFragment.this.tlNombreAval.getEditText().getText() != null) {
                            AvalController ac = new AvalController(AvalesCrearFragment.this.getContext());
                            String avalId = ac.getAvalByNombre(AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                            if (!avalId.isEmpty() || avalId != null) {
                                ClienteController cc = new ClienteController(AvalesCrearFragment.this.getContext());
                                String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                                if (Objects.equals(prestaNombre, "1")) {
                                    AlertDialog.Builder b = new AlertDialog.Builder(AvalesCrearFragment.this.getContext());
                                    b.setTitle((CharSequence)"Aviso");
                                    b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                    b.setPositiveButton((CharSequence)"Aceptar", null);
                                    AlertDialog dialog = b.create();
                                    dialog.show();
                                } else {
                                    AvalesCrearFragment.this.registrarAvalNuevo();
                                }
                            } else {
                                AvalesCrearFragment.this.registrarAvalNuevo();
                            }
                        } else {
                            AvalesCrearFragment.this.registrarAvalNuevo();
                        }
                    }
                } else {
                    String nombre = AvalesCrearFragment.this.avalesAutoCompleteTextView.getText().toString();
                    new MaterialAlertDialogBuilder((Context)AvalesCrearFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)("El aval " + nombre + " ya fue registrado")).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                }
            }
        });
        this.configurarAutoCompleteTextView();
    }

    @SuppressLint(value={"MissingPermission"})
    public void getCurrentLocation() {
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        LocationManager locationManager = (LocationManager)this.getActivity().getSystemService("location");
        if (locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network")) {
            this.client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    Location location = (Location)task.getResult();
                    if (location != null) {
                        AvalesCrearFragment.this.lat = String.valueOf(location.getLatitude());
                        AvalesCrearFragment.this.lgt = String.valueOf(location.getLongitude());
                        Toast.makeText((Context)AvalesCrearFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
                    } else {
                        LocationRequest locationRequest = new LocationRequest().setPriority(100).setInterval(10000L).setFastestInterval(1000L).setNumUpdates(1);
                        LocationCallback locationCallback = new LocationCallback(){

                            public void onLocationResult(LocationResult locationResult) {
                                Location location1 = locationResult.getLastLocation();
                                AvalesCrearFragment.this.lat = String.valueOf(location1.getLatitude());
                                AvalesCrearFragment.this.lgt = String.valueOf(location1.getLongitude());
                                Toast.makeText((Context)AvalesCrearFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
                            }
                        };
                        AvalesCrearFragment.this.client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                    }
                }
            });
        } else {
            this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS").setFlags(0x10000000));
        }
    }

    private void initElements(View view) {
        CurrentFragment.fragment = "AvalesCrearFragment";
        this.btnUbicacion = (Button)view.findViewById(2131296457);
        this.btnUbicacion.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AvalesCrearFragment.this.getCurrentLocation();
            }
        });
        this.avalesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296282);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.colocadorasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296275);
        this.tlNombreAval = (TextInputLayout)view.findViewById(2131297201);
        this.tlTelefonoAval = (TextInputLayout)view.findViewById(2131297235);
        this.tlDireccionAval = (TextInputLayout)view.findViewById(2131297172);
        this.tlOtrasReferenciasAval = (TextInputLayout)view.findViewById(2131297209);
        this.tlGarantiasAval = (TextInputLayout)view.findViewById(2131297184);
        this.btnRegistrarAval = (Button)view.findViewById(2131296446);
        this.btnSubirFotos = (Button)view.findViewById(2131296451);
        this.avalController = new AvalController((Context)this.getActivity());
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.colocadoraController = new ColocadoraController((Context)this.getActivity());
        this.pathsGarantiasAval = new ArrayList();
        this.pathsComprobantesAval = new ArrayList();
        this.pathsIneAval = new ArrayList();
        this.pathsFotoAval = new ArrayList();
        this.pathsFachadaAval = new ArrayList();
        this.archivosGeneral = new ArrayList<MultipartBody.Part>();
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    private void getRutas() {
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            AvalesCrearFragment.this.rutas.add(ruta);
                            AvalesCrearFragment.this.rutaController.nueva(ruta);
                        }
                        AvalesCrearFragment.this.rutasAdapter = new ArrayAdapter(AvalesCrearFragment.this.getContext(), 17367050, (List)AvalesCrearFragment.this.rutas);
                        AvalesCrearFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        AvalesCrearFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)AvalesCrearFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)AvalesCrearFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.rutas = this.rutaController.obtener();
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            AvalesCrearFragment.this.poblaciones.add(poblacion);
                            AvalesCrearFragment.this.poblacionController.nueva(poblacion);
                        }
                        AvalesCrearFragment.this.poblacionesAdapter = new ArrayAdapter(AvalesCrearFragment.this.getContext(), 17367050, (List)AvalesCrearFragment.this.poblaciones);
                        AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)AvalesCrearFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)AvalesCrearFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getColocadoras() {
        if (this.colocadoraController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                            AvalesCrearFragment.this.colocadoras.add(colocadora);
                            AvalesCrearFragment.this.colocadoraController.nueva(colocadora);
                        }
                        AvalesCrearFragment.this.colocadorasAdapter = new ArrayAdapter(AvalesCrearFragment.this.getContext(), 17367050, (List)AvalesCrearFragment.this.colocadoras);
                        AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                        AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)AvalesCrearFragment.this.colocadorasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)AvalesCrearFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.colocadoras = this.colocadoraController.obtener();
            this.colocadorasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.colocadoras);
            this.colocadorasAutoCompleteTextView.setThreshold(1);
            this.colocadorasAutoCompleteTextView.setAdapter(this.colocadorasAdapter);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (AvalesCrearViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(AvalesCrearViewModel.class);
    }

    private void registrarAvalNuevo() {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        if (!this.pathsIneAval.isEmpty()) {
            this.pathsComprobantesAval.addAll(this.pathsIneAval);
        }
        if (!this.pathsFotoAval.isEmpty()) {
            this.pathsComprobantesAval.addAll(this.pathsFotoAval);
        }
        if (!this.pathsFachadaAval.isEmpty()) {
            this.pathsComprobantesAval.addAll(this.pathsFachadaAval);
        }
        HashSet<String> set = new HashSet<String>(this.pathsComprobantesAval);
        this.pathsComprobantesAval.clear();
        this.pathsComprobantesAval.addAll(set);
        HashSet<String> set2 = new HashSet<String>(this.pathsGarantiasAval);
        this.pathsGarantiasAval.clear();
        this.pathsGarantiasAval.addAll(set2);
        final String nombre = this.tlNombreAval.getEditText().getText().toString();
        String nombreFormateado = nombre.replace("\u00f1", "n").replace("\u00d1", "N");
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"createAPP");
        RequestBody nombre_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreFormateado);
        RequestBody direccion_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlDireccionAval.getEditText().getText().toString());
        RequestBody telefono_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlTelefonoAval.getEditText().getText().toString());
        RequestBody or_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlOtrasReferenciasAval.getEditText().getText().toString());
        RequestBody poblacionId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.poblacion_id);
        RequestBody colocadoraId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.colocadora_id);
        RequestBody garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlGarantiasAval.getEditText().getText().toString());
        RequestBody rutaId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.ruta_id);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasAval.size() + ""));
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesAval.size() + ""));
        RequestBody latitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lat);
        RequestBody longitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lgt);
        final String direccion = this.tlDireccionAval.getEditText().getText().toString();
        final String telefono = this.tlTelefonoAval.getEditText().getText().toString();
        final String orCliente = this.tlOtrasReferenciasAval.getEditText().getText().toString();
        final String garantias = this.tlGarantiasAval.getEditText().getText().toString();
        final String cantidadGarantias = String.valueOf(this.pathsGarantiasAval.size());
        final String cantidadArchivos = String.valueOf(this.pathsComprobantesAval.size());
        Call<ResponseMe> call = retrofitInterface.registrarAval(this.archivosGeneral, func, nombre_aval, direccion_aval, telefono_aval, rutaId, poblacionId, colocadoraId, or_aval, garantias_aval, cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud);
        call.enqueue((Callback)new Callback<ResponseMe>(){
            FusedLocationProviderClient client;

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    String serverId = ((ResponseMe)response.body()).getClienteId();
                    AvalesCrearFragment.this.registrarAvalEnSQLite(AvalesCrearFragment.this.archivosGeneral, nombre, direccion, telefono, orCliente, garantias, AvalesCrearFragment.this.ruta_id, AvalesCrearFragment.this.poblacion_id, AvalesCrearFragment.this.colocadora_id, cantidadGarantias, cantidadArchivos, serverId);
                    Toast.makeText((Context)AvalesCrearFragment.this.getActivity(), (CharSequence)"El aval ha sido registrado", (int)1).show();
                    dialog.cancel();
                    AvalesCrearFragment.this.tlNombreAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.aval_id = "";
                    AvalesCrearFragment.this.ruta_id = "";
                    AvalesCrearFragment.this.poblacion_id = "";
                    AvalesCrearFragment.this.colocadora_id = "";
                    AvalesCrearFragment.this.lat = "";
                    AvalesCrearFragment.this.lgt = "";
                    AvalesCrearFragment.this.pathsGarantiasAval.clear();
                    AvalesCrearFragment.this.pathsComprobantesAval.clear();
                    AvalesCrearFragment.this.archivosGeneral.clear();
                } else {
                    try {
                        String errorBody = response.errorBody().string();
                        if (errorBody.startsWith("{")) {
                            JSONObject jObjError = new JSONObject(errorBody);
                            new MaterialAlertDialogBuilder((Context)AvalesCrearFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)jObjError.getString("message")).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            }).show();
                        } else {
                            new MaterialAlertDialogBuilder((Context)AvalesCrearFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)errorBody).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            }).show();
                        }
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)AvalesCrearFragment.this.getContext(), (CharSequence)e.getMessage(), (int)1).show();
                    }
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage() + " | " + t.getMessage()));
                if (t.getLocalizedMessage().contains("Unable to resolve host")) {
                    String tipo = "InsertAval";
                    AvalesCrearFragment.this.registrarAvalEnSQLite(AvalesCrearFragment.this.archivosGeneral, nombre, direccion, telefono, orCliente, garantias, AvalesCrearFragment.this.ruta_id, AvalesCrearFragment.this.poblacion_id, AvalesCrearFragment.this.colocadora_id, cantidadGarantias, cantidadArchivos, "");
                    SolicitudSubida solicitud = new SolicitudSubida(AvalesCrearFragment.this.archivosGeneral, nombre, direccion, telefono, orCliente, garantias, AvalesCrearFragment.this.ruta_id, AvalesCrearFragment.this.poblacion_id, AvalesCrearFragment.this.colocadora_id, cantidadGarantias, cantidadArchivos, tipo, "", "");
                    AvalesCrearFragment.this.colaSolicitudes.agregarSolicitud(solicitud);
                    new MaterialAlertDialogBuilder((Context)AvalesCrearFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"Se perdio la conexi\u00f3n y se guardar\u00f3n los datos en local").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                    AvalesCrearFragment.this.avalesAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                    AvalesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                    AvalesCrearFragment.this.aval_id = "";
                    AvalesCrearFragment.this.ruta_id = "";
                    AvalesCrearFragment.this.poblacion_id = "";
                    AvalesCrearFragment.this.colocadora_id = "";
                    AvalesCrearFragment.this.pathsGarantiasAval.clear();
                    AvalesCrearFragment.this.pathsComprobantesAval.clear();
                }
            }
        });
    }

    private void registrarAvalEnSQLite(List<MultipartBody.Part> archivosGeneral2, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String rutaId, String poblacionId, String colocadoraId, String cantidadGarantias, String cantidadArchivos, String idServer) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        if (this.verificarAvalExistente(db, nombre)) {
            Log.d((String)"SQLite", (String)("El aval con nombre " + nombre + " ya existe en la base de datos."));
            Toast.makeText((Context)this.requireContext(), (CharSequence)"El aval con este nombre ya existe.", (int)1).show();
            db.close();
            return;
        }
        this.aval_id = idServer != "" ? idServer : String.valueOf(this.obtenerSiguienteIdAval(db));
        ContentValues valores = new ContentValues();
        valores.put("id", this.aval_id);
        valores.put("nombre_completo", nombre);
        valores.put("direccion", direccion);
        valores.put("telefono", telefono);
        valores.put("otras_referencias", otrasReferencias);
        valores.put("garantias", garantias);
        valores.put("ruta_id", rutaId);
        valores.put("poblacion_id", poblacionId);
        valores.put("colocadora_id", colocadoraId);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        Date nuevaFecha = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);
        valores.put("created_at", fechaRestada);
        valores.put("updated_at", fechaRestada);
        long resultado = db.insert("avales", null, valores);
        if (resultado != -1L) {
            Log.d((String)"SQLite", (String)("Cliente registrado con \u00e9xito en SQLite con ID: " + this.aval_id));
        } else {
            Log.d((String)"SQLite", (String)"Error al registrar el cliente en SQLite.");
        }
        db.close();
    }

    private boolean verificarAvalExistente(SQLiteDatabase db, String nombre) {
        String query = "SELECT COUNT(*) FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        boolean existe = false;
        if (cursor.moveToFirst()) {
            existe = cursor.getInt(0) > 0;
        }
        cursor.close();
        return existe;
    }

    private int obtenerSiguienteIdAval(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM avales", null);
        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();
        return ultimoId + 1;
    }

    private void configurarAutoCompleteTextView() {
        final List<Cliente> listaClientes = this.obtenerListaClientes();
        if (Build.VERSION.SDK_INT >= 24) {
            listaClientes.sort((cliente1, cliente2) -> {
                int id1 = Integer.parseInt(cliente1.getId());
                int id2 = Integer.parseInt(cliente2.getId());
                return Integer.compare(id2, id1);
            });
        } else {
            Collections.sort(listaClientes, new Comparator<Cliente>(){

                @Override
                public int compare(Cliente cliente1, Cliente cliente2) {
                    int id1 = Integer.parseInt(cliente1.getId());
                    int id2 = Integer.parseInt(cliente2.getId());
                    return Integer.compare(id2, id1);
                }
            });
        }
        ArrayList<String> nombresClientes = new ArrayList<String>();
        for (Cliente cliente : listaClientes) {
            nombresClientes.add(cliente.getNombre_completo());
        }
        ArrayAdapter adapter = new ArrayAdapter(this.requireContext(), 17367050, nombresClientes);
        this.avalesAutoCompleteTextView.setAdapter((ListAdapter)adapter);
        this.avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
                Log.d((String)"aksdklaksldkl", (String)AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString());
                if (!AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().isEmpty() || AvalesCrearFragment.this.tlNombreAval.getEditText().getText() != null) {
                    ClienteController cc = new ClienteController(AvalesCrearFragment.this.getContext());
                    String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(AvalesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                    Log.d((String)"aksdklaksldkl122", (String)prestaNombre);
                    if (Objects.equals(prestaNombre, "1")) {
                        AlertDialog.Builder b = new AlertDialog.Builder(AvalesCrearFragment.this.getContext());
                        b.setTitle((CharSequence)"Aviso");
                        b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                        b.setPositiveButton((CharSequence)"Aceptar", null);
                        AvalesCrearFragment.this.tlNombreAval.getEditText().setText((CharSequence)"");
                        AlertDialog dialog = b.create();
                        dialog.show();
                    } else {
                        String nombreSeleccionado = (String)adapterView.getItemAtPosition(position);
                        Cliente clienteSeleccionado = null;
                        if (Build.VERSION.SDK_INT >= 24) {
                            clienteSeleccionado = listaClientes.stream().filter(cliente -> cliente.getNombre_completo().equals(nombreSeleccionado)).findFirst().orElse(null);
                        } else {
                            for (Cliente cliente2 : listaClientes) {
                                if (!cliente2.getNombre_completo().equals(nombreSeleccionado)) continue;
                                clienteSeleccionado = cliente2;
                                break;
                            }
                        }
                        if (clienteSeleccionado != null) {
                            AvalesCrearFragment.this.llenarCamposCliente(clienteSeleccionado);
                        }
                    }
                } else {
                    String nombreSeleccionado = (String)adapterView.getItemAtPosition(position);
                    Cliente clienteSeleccionado = null;
                    if (Build.VERSION.SDK_INT >= 24) {
                        clienteSeleccionado = listaClientes.stream().filter(cliente -> cliente.getNombre_completo().equals(nombreSeleccionado)).findFirst().orElse(null);
                    } else {
                        for (Cliente cliente3 : listaClientes) {
                            if (!cliente3.getNombre_completo().equals(nombreSeleccionado)) continue;
                            clienteSeleccionado = cliente3;
                            break;
                        }
                    }
                    if (clienteSeleccionado != null) {
                        AvalesCrearFragment.this.llenarCamposCliente(clienteSeleccionado);
                    }
                }
            }
        });
        this.avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private void limpiarCampos() {
        this.tlNombreAval.getEditText().setText((CharSequence)"");
        this.tlTelefonoAval.getEditText().setText((CharSequence)"");
        this.tlDireccionAval.getEditText().setText((CharSequence)"");
        this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
        this.tlGarantiasAval.getEditText().setText((CharSequence)"");
        this.rutasAutoCompleteTextView.setText((CharSequence)"", false);
        this.poblacionesAutoCompleteTextView.setText((CharSequence)"", false);
        this.colocadorasAutoCompleteTextView.setText((CharSequence)"", false);
    }

    private void llenarCamposCliente(Cliente cliente) {
        if (cliente != null) {
            int i;
            this.tlNombreAval.getEditText().setText((CharSequence)cliente.getNombre_completo());
            this.tlTelefonoAval.getEditText().setText((CharSequence)cliente.getTelefono());
            this.tlDireccionAval.getEditText().setText((CharSequence)cliente.getDireccion());
            this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)cliente.getOtras_referencias());
            this.tlGarantiasAval.getEditText().setText((CharSequence)cliente.getGarantias());
            if (cliente.getRuta_cliente() != null) {
                for (i = 0; i < this.rutas.size(); ++i) {
                    if (!this.rutas.get(i).getId().equals(cliente.getRuta_cliente())) continue;
                    this.rutasAutoCompleteTextView.setText((CharSequence)this.rutas.get(i).toString(), false);
                    break;
                }
            }
            if (cliente.getPoblacion_cliente() != null) {
                for (i = 0; i < this.poblaciones.size(); ++i) {
                    if (!this.poblaciones.get(i).getId().equals(cliente.getPoblacion_cliente())) continue;
                    this.poblacionesAutoCompleteTextView.setText((CharSequence)this.poblaciones.get(i).toString(), false);
                    break;
                }
            }
            if (cliente.getColocadora_id() != null) {
                for (i = 0; i < this.colocadoras.size(); ++i) {
                    if (!this.colocadoras.get(i).getId().equals(cliente.getColocadora_id())) continue;
                    this.colocadorasAutoCompleteTextView.setText((CharSequence)this.colocadoras.get(i).toString(), false);
                    break;
                }
            }
        }
    }

    private List<Cliente> obtenerListaClientes() {
        String sqlQuery;
        ArrayList<Cliente> listaClientes = new ArrayList<Cliente>();
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(sqlQuery = "SELECT * FROM clientes ORDER BY nombre_completo ASC", null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Cliente cliente = new Cliente(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")));
                listaClientes.add(cliente);
            } while (cursor.moveToNext());
            cursor.close();
        } else {
            Log.d((String)"SQLiteCliente", (String)"No se encontraron clientes en la base de datos.");
        }
        db.close();
        return listaClientes;
    }
}

