/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.avales.documentos;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.ui.avales.documentos.AvalesDocumentosViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.MemoryPolicy;
import com.squareup.picasso.NetworkPolicy;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AvalesDocumentosFragment
extends Fragment {
    private AvalesDocumentosViewModel mViewModel;
    private TextView tvAval;
    private Aval aval;
    private String avalId;
    private LinearLayoutCompat comprobantesAval;
    private LinearLayoutCompat garantiasAval;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private final Set<String> showingSets = new HashSet<String>();

    public static AvalesDocumentosFragment newInstance() {
        return new AvalesDocumentosFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        return inflater.inflate(2131492952, container, false);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.getFiles("comprobantes/avales/" + this.aval.getId() + "_" + this.aval.getNombre_completo().toUpperCase(), this.comprobantesAval);
                this.getFiles("garantias/avales/" + this.aval.getId() + "_" + this.aval.getNombre_completo().toUpperCase(), this.garantiasAval);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initElements(view);
        this.getFiles("comprobantes/avales/" + this.aval.getId() + "_" + this.aval.getNombre_completo().toUpperCase().toUpperCase(), this.comprobantesAval);
        this.getFiles("garantias/avales/" + this.aval.getId() + "_" + this.aval.getNombre_completo().toUpperCase().toUpperCase(), this.garantiasAval);
        Log.d((String)"DEBUG1", (String)String.valueOf(this.aval));
        Log.d((String)"DEBUG2", (String)this.avalId);
    }

    public void initElements(View view) {
        CurrentFragment.fragment = "AvalesDocumentosFragment";
        Bundle args = this.getArguments();
        String personJsonString = args.getString("aval");
        String personJsonString3 = args.getString("avalId");
        this.aval = (Aval)Utils.getGsonParser().fromJson(personJsonString, Aval.class);
        this.avalId = personJsonString3;
        this.tvAval = (TextView)view.findViewById(2131297267);
        this.tvAval.setText((CharSequence)("AVAL: \n" + this.aval.getNombre_completo()));
        this.comprobantesAval = (LinearLayoutCompat)view.findViewById(2131296507);
        this.garantiasAval = (LinearLayoutCompat)view.findViewById(2131296657);
    }

    public void getFiles(final String carpeta, final LinearLayoutCompat contenedor) {
        final ArrayList CAE = new ArrayList();
        final ArrayList GAE = new ArrayList();
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Log.d((String)"archivos", (String)"Entro a getFiles AVALES:.................");
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        final String path = API.url.replace("php/", "resources/");
        final String ruta2 = "../../resources/" + carpeta;
        String ruta = "../../resources/" + carpeta + "/9Expediente";
        Log.d((String)"ruta", (String)("RUTA:..........." + ruta));
        Log.d((String)"ruta", (String)("LIGA COMPLETA:..........." + carpeta));
        final JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"archivos");
            data.put("ruta", (Object)ruta);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"ruta", (String)("LIGA COMPLETA EN DATA:..........." + data));
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                block12: {
                    try {
                        dialog.cancel();
                        Log.d((String)"data", (String)String.valueOf(data));
                        Log.d((String)"response11", (String)("onResponse: " + response));
                        if (!response.get("data").toString().equals("false")) {
                            JSONArray jsonArray = (JSONArray)response.get("data");
                            Log.d((String)"archivos", (String)(jsonArray.length() + ""));
                            ArrayList<String> fileNames = new ArrayList<String>();
                            for (int i = 2; i < jsonArray.length(); ++i) {
                                if (jsonArray.getString(i).matches("[0-4]CAE\\.jpeg")) {
                                    CAE.add(jsonArray.getString(i));
                                    continue;
                                }
                                if (jsonArray.getString(i).matches("[0-3]GAE\\.jpeg")) {
                                    GAE.add(jsonArray.getString(i));
                                    continue;
                                }
                                if (!jsonArray.getString(i).matches("[0-6]CCE\\.jpeg")) continue;
                                fileNames.add(jsonArray.getString(i));
                            }
                            Boolean r = false;
                            if (!CAE.isEmpty()) {
                                AvalesDocumentosFragment.this.showImageSequentially2(CAE, 0, path, AvalesDocumentosFragment.this.comprobantesAval, carpeta);
                                r = true;
                            }
                            if (!GAE.isEmpty()) {
                                AvalesDocumentosFragment.this.showImageSequentially2(GAE, 0, path, AvalesDocumentosFragment.this.garantiasAval, carpeta);
                                r = true;
                            }
                            if (r.booleanValue()) {
                                return;
                            }
                            Collections.sort(fileNames, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return Integer.compare(this.extractLeadingNumber(o1), this.extractLeadingNumber(o2));
                                }

                                private int extractLeadingNumber(String fileName) {
                                    StringBuilder number = new StringBuilder();
                                    for (char c : fileName.toCharArray()) {
                                        if (!Character.isDigit(c)) break;
                                        number.append(c);
                                    }
                                    return Integer.parseInt(number.toString());
                                }
                            });
                            if (GAE.isEmpty() && CAE.isEmpty()) {
                                AvalesDocumentosFragment.this.showImageSequentially2(fileNames, 0, path, contenedor, carpeta);
                            }
                            break block12;
                        }
                        final JSONObject data2 = new JSONObject();
                        try {
                            data2.put("func", (Object)"archivos");
                            data2.put("ruta", (Object)ruta2);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        JsonObjectRequest request2 = new JsonObjectRequest(1, API.urlAvales, data2, (Response.Listener)new Response.Listener<JSONObject>(){

                            public void onResponse(JSONObject response) {
                                block5: {
                                    try {
                                        dialog.cancel();
                                        Log.d((String)"data2", (String)String.valueOf(data2));
                                        Log.d((String)"response2", (String)("onResponse: " + response));
                                        if (response.get("data").toString().equals("false")) break block5;
                                        JSONArray jsonArray = (JSONArray)response.get("data");
                                        Log.d((String)"archivos", (String)(jsonArray.length() + ""));
                                        if (jsonArray.length() >= 4) {
                                            ArrayList<String> fileNames = new ArrayList<String>();
                                            for (int i = 2; i < jsonArray.length(); ++i) {
                                                fileNames.add(jsonArray.getString(i));
                                            }
                                            Collections.sort(fileNames, new Comparator<String>(){

                                                @Override
                                                public int compare(String o1, String o2) {
                                                    return Integer.compare(this.extractLeadingNumber(o1), this.extractLeadingNumber(o2));
                                                }

                                                private int extractLeadingNumber(String fileName) {
                                                    StringBuilder number = new StringBuilder();
                                                    for (char c : fileName.toCharArray()) {
                                                        if (!Character.isDigit(c)) break;
                                                        number.append(c);
                                                    }
                                                    return Integer.parseInt(number.toString());
                                                }
                                            });
                                            Log.d((String)"fileNames", (String)("onResponse: " + fileNames));
                                            Log.d((String)"path", (String)("onResponse: " + path));
                                            Log.d((String)"carpeta", (String)("onResponse: " + carpeta));
                                            Log.d((String)"contenedor", (String)("onResponse: " + contenedor));
                                            AvalesDocumentosFragment.this.showImageSequentially(fileNames, 0, path, contenedor, carpeta);
                                            break block5;
                                        }
                                        DatabaseHelper dbh = new DatabaseHelper(AvalesDocumentosFragment.this.getContext());
                                        SQLiteDatabase db = dbh.getReadableDatabase();
                                        String query = "SELECT * FROM clientes WHERE aval_id = ?";
                                        Cursor cursor = db.rawQuery(query, new String[]{AvalesDocumentosFragment.this.avalId});
                                        String cc = "";
                                        String cg = "";
                                        if (cursor.moveToFirst()) {
                                            cc = cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes"));
                                            cg = cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias"));
                                            AvalesDocumentosFragment.this.getFiles("comprobantes/clientes/" + cc, AvalesDocumentosFragment.this.comprobantesAval);
                                        }
                                        return;
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }, new Response.ErrorListener(){

                            public void onErrorResponse(VolleyError error) {
                                dialog.cancel();
                                ErrorChecker.checker(error, (Context)AvalesDocumentosFragment.this.getActivity());
                            }
                        });
                        request2.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
                        request2.setShouldCache(false);
                        AvalesDocumentosFragment.this.requestQueue.add((Request)request2);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)AvalesDocumentosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void showImageSequentially(final List<String> fileNames, final int index, final String path, final LinearLayoutCompat contenedor, final String carpeta) {
        String title;
        int fileType;
        if (index >= fileNames.size()) {
            return;
        }
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;
        float percentage = 0.85f;
        final int calculatedWidth = (int)((float)windowWidth * percentage);
        String fileName = fileNames.get(index);
        Log.d((String)"FILE", (String)fileName);
        String prefix = fileName.substring(0, 3);
        HashMap<Integer, String> comprobanteTitleMap = new HashMap<Integer, String>();
        comprobanteTitleMap.put(0, "INE FRENTE");
        comprobanteTitleMap.put(1, "INE REVERSE");
        comprobanteTitleMap.put(2, "COMPROBANTE");
        comprobanteTitleMap.put(3, "FOTO");
        comprobanteTitleMap.put(4, "FACHADA");
        String garantiaTitle = "GARANTIA";
        try {
            fileType = Integer.parseInt(fileName.substring(0, 1));
        }
        catch (NumberFormatException e) {
            Log.e((String)"Error", (String)("No se pudo extraer el n\u00famero del archivo: " + fileName));
            return;
        }
        if (prefix.endsWith("CA")) {
            title = comprobanteTitleMap.containsKey(fileType) ? (String)comprobanteTitleMap.get(fileType) : "T\u00cdTULO DESCONOCIDO";
        } else if (prefix.endsWith("GA")) {
            title = garantiaTitle;
        } else {
            Log.e((String)"Error", (String)("Archivo no reconocido: " + fileName));
            return;
        }
        final ImageView image = new ImageView((Context)this.getActivity());
        final String imageUrl = path + carpeta + "/" + fileName;
        ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this.getActivity()).asBitmap().load(imageUrl).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true)).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                int imageWidth = resource.getWidth();
                int imageHeight = resource.getHeight();
                int calculatedHeight = (int)((float)imageHeight / (float)imageWidth * (float)calculatedWidth);
                LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(calculatedWidth, calculatedHeight);
                params.setMargins(0, 0, 0, 15);
                image.setLayoutParams((ViewGroup.LayoutParams)params);
                image.setScaleType(ImageView.ScaleType.FIT_CENTER);
                image.setImageBitmap(resource);
                Context context = AvalesDocumentosFragment.this.getContext();
                if (context == null) {
                    return;
                }
                TextView titleTextView = new TextView((Context)AvalesDocumentosFragment.this.getActivity());
                titleTextView.setText((CharSequence)title);
                titleTextView.setTextSize(16.0f);
                titleTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-2, -2));
                titleTextView.setPadding(0, 0, 0, 5);
                contenedor.addView((View)titleTextView);
                contenedor.addView((View)image);
                image.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        View dialogView = LayoutInflater.from((Context)AvalesDocumentosFragment.this.getActivity()).inflate(2131492931, null);
                        TouchImageView touchImageView = (TouchImageView)dialogView.findViewById(2131296693);
                        Picasso.get().load(imageUrl).memoryPolicy(MemoryPolicy.NO_CACHE, new MemoryPolicy[]{MemoryPolicy.NO_STORE}).networkPolicy(NetworkPolicy.NO_CACHE, new NetworkPolicy[0]).into((ImageView)touchImageView);
                        new MaterialAlertDialogBuilder((Context)AvalesDocumentosFragment.this.getActivity()).setTitle((CharSequence)"").setView(dialogView).setCancelable(false).setPositiveButton((CharSequence)"CERRAR", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                    }
                });
                new Handler(Looper.getMainLooper()).postDelayed(() -> AvalesDocumentosFragment.this.showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 1000L);
            }
        });
    }

    private void showImageSequentially2(final List<String> fileNames, final int index, final String path, final LinearLayoutCompat contenedor, final String carpeta) {
        String title;
        int fileType;
        final String key = path + carpeta + contenedor.hashCode();
        Context context = this.getContext();
        if (context == null) {
            this.showingSets.remove(key);
            return;
        }
        if (index == 0) {
            if (this.showingSets.contains(key)) {
                Log.d((String)"DEBUG", (String)("Ya se est\u00e1 mostrando esta secuencia: " + key));
                return;
            }
            this.showingSets.add(key);
        }
        if (index >= fileNames.size()) {
            this.showingSets.remove(key);
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;
        float percentage = 0.85f;
        final int calculatedWidth = (int)((float)windowWidth * percentage);
        final String fileName = fileNames.get(index);
        Log.d((String)"FILE", (String)fileName);
        String prefix = fileName.substring(0, 3);
        HashMap<Integer, String> comprobanteTitleMap = new HashMap<Integer, String>();
        comprobanteTitleMap.put(0, "INE FRENTE");
        comprobanteTitleMap.put(1, "INE REVERSE");
        comprobanteTitleMap.put(2, "COMPROBANTE");
        comprobanteTitleMap.put(3, "FOTO");
        comprobanteTitleMap.put(4, "FACHADA");
        String garantiaTitle = "GARANTIA";
        try {
            fileType = Integer.parseInt(fileName.substring(0, 1));
        }
        catch (NumberFormatException e) {
            Log.e((String)"Error", (String)("No se pudo extraer el n\u00famero del archivo: " + fileName));
            this.showingSets.remove(key);
            return;
        }
        if (prefix.endsWith("CA")) {
            title = comprobanteTitleMap.getOrDefault(fileType, "T\u00cdTULO DESCONOCIDO");
        } else if (prefix.endsWith("GA")) {
            title = garantiaTitle;
        } else {
            Log.e((String)"Error", (String)("Archivo no reconocido: " + fileName));
            this.showingSets.remove(key);
            return;
        }
        final ImageView image = new ImageView((Context)this.getActivity());
        final String imageUrl = path + carpeta + "/9Expediente/" + fileName;
        ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this.getActivity()).asBitmap().load(imageUrl).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true)).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                int imageWidth = resource.getWidth();
                int imageHeight = resource.getHeight();
                int calculatedHeight = (int)((float)imageHeight / (float)imageWidth * (float)calculatedWidth);
                LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(calculatedWidth, calculatedHeight);
                params.setMargins(0, 0, 0, 15);
                image.setLayoutParams((ViewGroup.LayoutParams)params);
                image.setScaleType(ImageView.ScaleType.FIT_CENTER);
                image.setImageBitmap(resource);
                Context context = AvalesDocumentosFragment.this.getContext();
                if (context == null) {
                    Log.e((String)"ERROR", (String)("Contexto es null, se aborta la carga de la imagen: " + fileName));
                    AvalesDocumentosFragment.this.showingSets.remove(key);
                    return;
                }
                TextView titleTextView = new TextView(context);
                titleTextView.setText((CharSequence)title);
                titleTextView.setTextSize(16.0f);
                titleTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-2, -2));
                titleTextView.setPadding(0, 0, 0, 5);
                contenedor.addView((View)titleTextView);
                contenedor.addView((View)image);
                image.setOnClickListener(view -> {
                    View dialogView = LayoutInflater.from((Context)AvalesDocumentosFragment.this.getActivity()).inflate(2131492931, null);
                    TouchImageView touchImageView = (TouchImageView)dialogView.findViewById(2131296693);
                    Picasso.get().load(imageUrl).memoryPolicy(MemoryPolicy.NO_CACHE, new MemoryPolicy[]{MemoryPolicy.NO_STORE}).networkPolicy(NetworkPolicy.NO_CACHE, new NetworkPolicy[0]).into((ImageView)touchImageView);
                    new MaterialAlertDialogBuilder((Context)AvalesDocumentosFragment.this.getActivity()).setTitle((CharSequence)"").setView(dialogView).setCancelable(false).setPositiveButton((CharSequence)"CERRAR", (dialogInterface, i) -> {}).show();
                });
                new Handler(Looper.getMainLooper()).postDelayed(() -> AvalesDocumentosFragment.this.showImageSequentially2(fileNames, index + 1, path, contenedor, carpeta), 100L);
            }
        });
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (AvalesDocumentosViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(AvalesDocumentosViewModel.class);
    }
}

