/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.avales.editar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.editar.AvalesEditarViewModel;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesEditarFragment
extends Fragment {
    private Aval avalActual;
    private String pendingRutaId = "";
    private String pendingPoblacionId = "";
    private String pendingColocadoraId = "";
    private AvalesEditarViewModel mViewModel;
    private TextInputLayout tlAval;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlGarantiasAval;
    private TextInputLayout tlRuta;
    private TextInputLayout tlPoblacion;
    private TextInputLayout tlColocadora;
    private AutoCompleteTextView avalesAutoCompleteTextView;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private Uri image_uri;
    private Uri selectedImageUri;
    private Uri uri;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private Button btnEditarAval;
    private Button btnSubirFotos;
    private Button btnUbicacion;
    private Bitmap bitmap;
    private ArrayList<Bitmap> bitmaps;
    private String aval_id = "";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private final String cliente_id2 = "";
    private int previousLengthAval;
    private boolean backSpaceAval;
    private final boolean camaraGarantiasAvalAbierta = false;
    private final boolean camaraComprobantesAvalAbierta = false;
    List<MultipartBody.Part> archivosGeneral;
    private ArrayList<Aval> avales;
    private ArrayAdapter<Aval> avalesAdapter;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private int banderaGarantiasAvales;
    private int banderaComprobantesAvales;
    String path;
    Bundle bundle;
    String lat = "";
    String lgt = "";
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    FusedLocationProviderClient client;

    public static AvalesEditarFragment newInstance() {
        return new AvalesEditarFragment();
    }

    private void showAlert(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(BluetoothUtils.context);
        builder.setMessage((CharSequence)message);
        TextView title = new TextView(BluetoothUtils.context);
        title.setText((CharSequence)"Alerta");
        title.setGravity(17);
        title.setTextSize(2, 20.0f);
        title.setTextColor(ContextCompat.getColor((Context)BluetoothUtils.context, (int)17170444));
        title.setPadding(0, 20, 0, 20);
        builder.setCustomTitle((View)title);
        builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492953, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        AvalesWorker.cancelWork(this.requireContext());
        Bundle bundle = this.getArguments();
        this.initElements(view);
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.getRutas();
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones();
        }
        if (this.colocadoras.size() == 0) {
            this.getColocadoras();
        }
        Bundle args = this.getArguments();
        String personJsonString = args.getString("aval");
        final Aval aval = (Aval)Utils.getGsonParser().fromJson(personJsonString, Aval.class);
        this.tlAval.getEditText().setText((CharSequence)aval.getNombre_completo());
        this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
        this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
        this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
        this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
        this.setRutaAutoComplete(aval.getRuta_id());
        this.setPoblacionAutoComplete(aval.getPoblacion_id());
        this.setColocadoraAutoComplete(aval.getColocadora_id());
        this.aval_id = aval.getId();
        this.avales = new ArrayList();
        Log.d((String)"DATA_ENVIADA", (String)("Json de avales aval_id: " + this.aval_id));
        bundle = this.getArguments();
        if (bundle != null) {
            this.avales = (ArrayList)bundle.getSerializable("avales");
        }
        if (this.avales == null) {
            this.avales = new ArrayList();
        }
        if (this.avales.size() == 0) {
            // empty if block
        }
        this.avalesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.avales);
        this.avalesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296282);
        if (this.avalesAutoCompleteTextView != null) {
            this.avalesAutoCompleteTextView.setThreshold(1);
            this.avalesAutoCompleteTextView.setAdapter(this.avalesAdapter);
        }
        this.avalesAutoCompleteTextView.setThreshold(1);
        this.avalesAutoCompleteTextView.setAdapter(this.avalesAdapter);
        this.avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (!AvalesEditarFragment.this.tlAval.getEditText().getText().toString().isEmpty() || AvalesEditarFragment.this.tlAval.getEditText().getText() != null) {
                    AvalController ac = new AvalController(AvalesEditarFragment.this.getContext());
                    String avalId = ac.getAvalByNombre(AvalesEditarFragment.this.tlAval.getEditText().getText().toString().toUpperCase());
                    if (!avalId.isEmpty() || avalId != null) {
                        ClienteController cc = new ClienteController(AvalesEditarFragment.this.getContext());
                        String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(AvalesEditarFragment.this.tlAval.getEditText().getText().toString().toUpperCase());
                        if (Objects.equals(prestaNombre, "1")) {
                            AlertDialog.Builder b = new AlertDialog.Builder(AvalesEditarFragment.this.getContext());
                            b.setTitle((CharSequence)"Aviso");
                            b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                            b.setPositiveButton((CharSequence)"Aceptar", null);
                            AvalesEditarFragment.this.tlAval.getEditText().setText((CharSequence)"");
                            AlertDialog dialog = b.create();
                            dialog.show();
                        } else {
                            Aval aval = (Aval)AvalesEditarFragment.this.avalesAdapter.getItem(i);
                            AvalesEditarFragment.this.aval_id = aval.getId();
                            AvalesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
                            AvalesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
                            AvalesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
                            AvalesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
                        }
                    } else {
                        Aval aval = (Aval)AvalesEditarFragment.this.avalesAdapter.getItem(i);
                        AvalesEditarFragment.this.aval_id = aval.getId();
                        AvalesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
                        AvalesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
                        AvalesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
                        AvalesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
                    }
                } else {
                    Aval aval = (Aval)AvalesEditarFragment.this.avalesAdapter.getItem(i);
                    AvalesEditarFragment.this.aval_id = aval.getId();
                    AvalesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
                    AvalesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
                    AvalesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
                    AvalesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
                }
            }
        });
        this.avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int i, int i1, int i2) {
                AvalesEditarFragment.this.previousLengthAval = s.length();
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable s) {
                AvalesEditarFragment.this.backSpaceAval = AvalesEditarFragment.this.previousLengthAval > s.length();
                if (AvalesEditarFragment.this.backSpaceAval && !AvalesEditarFragment.this.aval_id.equals("")) {
                    AvalesEditarFragment.this.avalesAutoCompleteTextView.setText((CharSequence)"");
                    AvalesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                    AvalesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                    AvalesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                    AvalesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                    AvalesEditarFragment.this.aval_id = "";
                }
            }
        });
        this.btnSubirFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AvalesEditarFragment.this.getCurrentLocation();
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();
                Bundle args = new Bundle();
                String personJsonString = Utils.getGsonParser().toJson((Object)aval);
                String personJsonString3 = AvalesEditarFragment.this.aval_id;
                String personJsonString4 = "2";
                args.putString("aval", personJsonString);
                args.putString("avalId", personJsonString3);
                args.putString("tipo", personJsonString4);
                Log.d((String)"DATA_ENVIADA", (String)("Json de avale: " + personJsonString));
                Log.d((String)"DATA_ENVIADA", (String)("ID de avaleId: " + personJsonString3));
                Log.d((String)"DATA_ENVIADA", (String)("ID de tipo: " + personJsonString4));
                dialogFragment.setArguments(args);
                dialogFragment.show(AvalesEditarFragment.this.getChildFragmentManager(), "AvalesFotosDialog");
            }
        });
        this.btnEditarAval.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Validator.fieldValidation(AvalesEditarFragment.this.tlAval, "Ingresa un nombre de aval") && Validator.fieldValidation(AvalesEditarFragment.this.tlTelefonoAval, "Ingresa un tel\u00e9fono") && Validator.fieldValidation(AvalesEditarFragment.this.tlDireccionAval, "Ingresa una direcci\u00f3n") && Validator.fieldValidation(AvalesEditarFragment.this.tlOtrasReferenciasAval, "Ingresa otras referencias") && Validator.fieldValidation(AvalesEditarFragment.this.tlGarantiasAval, "Ingresa las garant\u00edas") && Validator.fieldValidation(AvalesEditarFragment.this.tlRuta, "Ingresa una ruta") && Validator.fieldValidation(AvalesEditarFragment.this.tlPoblacion, "Ingresa una poblaci\u00f3n") && Validator.fieldValidation(AvalesEditarFragment.this.tlColocadora, "Ingresa una colocadora")) {
                    try {
                        AvalesEditarFragment.this.editarAval();
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        this.btnUbicacion.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AvalesEditarFragment.this.getCurrentLocation();
                Toast.makeText((Context)AvalesEditarFragment.this.getContext(), (CharSequence)"Obteniendo ubicaci\u00f3n", (int)0).show();
            }
        });
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)AvalesEditarFragment.this.rutasAdapter.getItem(i);
                AvalesEditarFragment.this.ruta_id = ruta.getId();
                if (AvalesEditarFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    AvalesEditarFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (AvalesEditarFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    AvalesEditarFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List poblacionesFiltro = AvalesEditarFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(AvalesEditarFragment.this.ruta_id)).collect(Collectors.toList());
                AvalesEditarFragment.this.poblacionesAdapter = new ArrayAdapter(AvalesEditarFragment.this.getContext(), 17367050, poblacionesFiltro);
                AvalesEditarFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                AvalesEditarFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)AvalesEditarFragment.this.poblacionesAdapter);
            }
        });
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)AvalesEditarFragment.this.poblacionesAdapter.getItem(i);
                AvalesEditarFragment.this.poblacion_id = poblacion.getId();
                if (AvalesEditarFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    AvalesEditarFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List colocadorasFiltro = AvalesEditarFragment.this.colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(AvalesEditarFragment.this.poblacion_id)).collect(Collectors.toList());
                AvalesEditarFragment.this.colocadorasAdapter = new ArrayAdapter(AvalesEditarFragment.this.getContext(), 17367050, colocadorasFiltro);
                AvalesEditarFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                AvalesEditarFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)AvalesEditarFragment.this.colocadorasAdapter);
            }
        });
        this.colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Colocadora colocadora = (Colocadora)AvalesEditarFragment.this.colocadorasAdapter.getItem(i);
                AvalesEditarFragment.this.colocadora_id = colocadora.getId();
            }
        });
    }

    private void setRutaAutoComplete(String rutaId) {
        for (Ruta ruta : this.rutas) {
            if (!ruta.getId().equals(rutaId)) continue;
            this.rutasAutoCompleteTextView.setText((CharSequence)ruta.getNombre_ruta(), false);
            this.ruta_id = ruta.getId();
            break;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void getCurrentLocation() {
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        LocationManager locationManager = (LocationManager)this.getActivity().getSystemService("location");
        if (locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network")) {
            this.client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    Location location = (Location)task.getResult();
                    if (location != null) {
                        AvalesEditarFragment.this.lat = String.valueOf(location.getLatitude());
                        AvalesEditarFragment.this.lgt = String.valueOf(location.getLongitude());
                        Toast.makeText((Context)AvalesEditarFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
                    } else {
                        LocationRequest locationRequest = new LocationRequest().setPriority(100).setInterval(10000L).setFastestInterval(1000L).setNumUpdates(1);
                        LocationCallback locationCallback = new LocationCallback(){

                            public void onLocationResult(LocationResult locationResult) {
                                Location location1 = locationResult.getLastLocation();
                                AvalesEditarFragment.this.lat = String.valueOf(location1.getLatitude());
                                AvalesEditarFragment.this.lgt = String.valueOf(location1.getLongitude());
                                Toast.makeText((Context)AvalesEditarFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
                            }
                        };
                        AvalesEditarFragment.this.client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                    }
                }
            });
        } else {
            this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS").setFlags(0x10000000));
        }
    }

    private void setPoblacionAutoComplete(String poblacionId) {
        for (Poblacion poblacion : this.poblaciones) {
            if (!poblacion.getId().equals(poblacionId)) continue;
            this.poblacionesAutoCompleteTextView.setText((CharSequence)poblacion.getNombre_poblacion(), false);
            this.poblacion_id = poblacion.getId();
            break;
        }
    }

    private void setColocadoraAutoComplete(String colocadoraId) {
        for (Colocadora colocadora : this.colocadoras) {
            if (!colocadora.getId().equals(colocadoraId)) continue;
            this.colocadorasAutoCompleteTextView.setText((CharSequence)colocadora.getNombre_completo(), false);
            this.colocadora_id = colocadora.getId();
            break;
        }
    }

    private void initElements(View view) {
        CurrentFragment.fragment = "AvalesEditarFragment";
        this.btnSubirFotos = (Button)view.findViewById(2131296451);
        this.btnEditarAval = (Button)view.findViewById(2131296418);
        this.btnUbicacion = (Button)view.findViewById(2131296457);
        if (this.btnEditarAval == null) {
            Log.e((String)"AvalesEditarFragment", (String)"btnEditarAval es null. Aseg\u00farate de que el ID sea correcto en el layout.");
        } else {
            Log.d((String)"AvalesEditarFragment", (String)"btnEditarAval inicializado correctamente.");
        }
        this.tlAval = (TextInputLayout)view.findViewById(2131297201);
        this.tlDireccionAval = (TextInputLayout)view.findViewById(2131297172);
        this.tlTelefonoAval = (TextInputLayout)view.findViewById(2131297235);
        this.tlOtrasReferenciasAval = (TextInputLayout)view.findViewById(2131297209);
        this.tlGarantiasAval = (TextInputLayout)view.findViewById(2131297184);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297217);
        this.tlColocadora = (TextInputLayout)view.findViewById(2131297161);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.colocadorasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296275);
        this.pathsComprobantesAval = new ArrayList();
        this.pathsGarantiasAval = new ArrayList();
        this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.colocadoraController = new ColocadoraController((Context)this.getActivity());
    }

    private void getRutas() {
        this.rutas = this.rutaController.obtener();
        if (this.rutas.size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = response.getJSONArray("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            AvalesEditarFragment.this.rutas.add(ruta);
                            AvalesEditarFragment.this.rutaController.nueva(ruta);
                        }
                        AvalesEditarFragment.this.rutasAdapter = new ArrayAdapter(AvalesEditarFragment.this.getContext(), 17367050, (List)AvalesEditarFragment.this.rutas);
                        AvalesEditarFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        AvalesEditarFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)AvalesEditarFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)AvalesEditarFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getPoblaciones() {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            AvalesEditarFragment.this.poblaciones.add(poblacion);
                            AvalesEditarFragment.this.poblacionController.nueva(poblacion);
                        }
                        AvalesEditarFragment.this.poblacionesAdapter = new ArrayAdapter(AvalesEditarFragment.this.getContext(), 17367050, (List)AvalesEditarFragment.this.poblaciones);
                        AvalesEditarFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        AvalesEditarFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)AvalesEditarFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)AvalesEditarFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getColocadoras() {
        if (this.colocadoraController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                            AvalesEditarFragment.this.colocadoras.add(colocadora);
                        }
                        AvalesEditarFragment.this.colocadorasAdapter = new ArrayAdapter(AvalesEditarFragment.this.getContext(), 17367050, (List)AvalesEditarFragment.this.colocadoras);
                        AvalesEditarFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                        AvalesEditarFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)AvalesEditarFragment.this.colocadorasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)AvalesEditarFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.colocadoras = this.colocadoraController.obtener();
            this.colocadorasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.colocadoras);
            this.colocadorasAutoCompleteTextView.setThreshold(1);
            this.colocadorasAutoCompleteTextView.setAdapter(this.colocadorasAdapter);
        }
    }

    private void editarAval() throws JSONException {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"editAPP");
        RequestBody avalId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.aval_id);
        final String nombreAval = this.tlAval.getEditText().getText().toString().trim();
        final String direccionAval = this.tlDireccionAval.getEditText().getText().toString();
        final String telefonoAval = this.tlTelefonoAval.getEditText().getText().toString();
        final String orAval = this.tlOtrasReferenciasAval.getEditText().getText().toString();
        final String garantiasAval = this.tlGarantiasAval.getEditText().getText().toString();
        if (this.ruta_id == null || this.ruta_id.isEmpty()) {
            this.ruta_id = this.rutasAutoCompleteTextView.getText().toString().trim();
        }
        if (this.poblacion_id == null || this.poblacion_id.isEmpty()) {
            this.poblacion_id = this.poblacionesAutoCompleteTextView.getText().toString().trim();
        }
        if (this.colocadora_id == null || this.colocadora_id.isEmpty()) {
            this.colocadora_id = this.colocadorasAutoCompleteTextView.getText().toString().trim();
        }
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasAval.size() + ""));
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesAval.size() + ""));
        Call<ResponseMe> call = retrofitInterface.editarAval(this.archivosGeneral, func, avalId, RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreAval), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)direccionAval), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)telefonoAval), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.ruta_id), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.poblacion_id), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.colocadora_id), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)orAval), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)garantiasAval), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lat), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lgt), cantidad_archivos_garantias_aval, cantidad_archivos_aval);
        JSONObject data = new JSONObject();
        data.put("func", (Object)"editCoords");
        data.put("id", (Object)this.aval_id);
        data.put("latitud", (Object)this.lat);
        data.put("longitud", (Object)this.lgt);
        this.vs = VolleyS.getInstance(this.getContext());
        this.requestQueue = this.vs.getRequestQueue();
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        this.requestQueue.add((Request)request);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    Log.d((String)"response", (String)((ResponseMe)response.body()).getMessage());
                    Toast.makeText((Context)AvalesEditarFragment.this.getActivity(), (CharSequence)"El aval se ha editado", (int)1).show();
                    AvalesEditarFragment.this.actualizarAvalEnSQLite(AvalesEditarFragment.this.aval_id, nombreAval, direccionAval, telefonoAval, orAval, garantiasAval, AvalesEditarFragment.this.ruta_id, AvalesEditarFragment.this.poblacion_id, AvalesEditarFragment.this.colocadora_id);
                    NavOptions navOptions = new NavOptions.Builder().setPopUpTo(2131296843, true).build();
                    Navigation.findNavController((Activity)AvalesEditarFragment.this.getActivity(), (int)2131296862).navigate(2131296843, null, navOptions);
                } else {
                    Toast.makeText((Context)AvalesEditarFragment.this.getActivity(), (CharSequence)"Error de red, se guard\u00f3 la edici\u00f3n en local", (int)1).show();
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                Toast.makeText((Context)AvalesEditarFragment.this.getActivity(), (CharSequence)"Error de red, se guard\u00f3 la edici\u00f3n en local", (int)1).show();
                AvalesEditarFragment.this.actualizarAvalEnSQLite(AvalesEditarFragment.this.aval_id, nombreAval, direccionAval, telefonoAval, orAval, garantiasAval, AvalesEditarFragment.this.ruta_id, AvalesEditarFragment.this.poblacion_id, AvalesEditarFragment.this.colocadora_id);
            }
        });
    }

    private void actualizarAvalEnSQLite(String avalId, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String rutaId, String poblacionId, String colocadoraId) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        if (rutaId == null) {
            rutaId = "";
        }
        if (poblacionId == null) {
            poblacionId = "";
        }
        if (colocadoraId == null) {
            colocadoraId = "";
        }
        ContentValues valores = new ContentValues();
        valores.put("nombre_completo", nombre != null ? nombre : "");
        valores.put("direccion", direccion != null ? direccion : "");
        valores.put("telefono", telefono != null ? telefono : "");
        valores.put("otras_referencias", otrasReferencias != null ? otrasReferencias : "");
        valores.put("garantias", garantias != null ? garantias : "");
        valores.put("ruta_id", rutaId);
        valores.put("poblacion_id", poblacionId);
        valores.put("colocadora_id", colocadoraId);
        long timestamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(new Date(timestamp));
        valores.put("updated_at", formattedDate);
        int filasActualizadas = db.update("avales", valores, "id = ?", new String[]{avalId});
        if (filasActualizadas > 0) {
            Log.d((String)"SQLite", (String)("Aval actualizado en SQLite con id: " + avalId));
            Toast.makeText((Context)this.requireActivity(), (CharSequence)("El aval " + nombre + " se ha editado correctamente"), (int)1).show();
        } else {
            Log.d((String)"SQLite", (String)("No se pudo actualizar el aval en SQLite con id: " + avalId));
        }
        db.close();
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int height;
        int width = bitmap.getWidth();
        float bitmapRatio = (float)width / (float)(height = bitmap.getHeight());
        if (bitmapRatio > 1.0f) {
            width = maxSize;
            height = (int)((float)width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int)((float)height * bitmapRatio);
        }
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        this.addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }

    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
        fos.flush();
        fos.close();
        return file;
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = this.getCurrentDateTime();
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(bitmap.getHeight() - 40), (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(18.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = bitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (AvalesEditarViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(AvalesEditarViewModel.class);
    }
}

