/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.avales.fotos;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.navigation.Navigation;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesFotosGarantiasFragment
extends Fragment {
    private AvalesFotosViewModel mViewModel;
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private Button btnImagenesGarantiasAval;
    private Button btnImagenesComprobantesAval;
    private Button btnGuardarFotos;
    private boolean camaraGarantiasAvalAbierta = false;
    private boolean camaraComprobantesAvalAbierta = false;
    List<MultipartBody.Part> archivosGeneral;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private Aval aval;
    private int banderaGarantiasAvales;
    private int banderaComprobantesAvales;
    String path;
    private Uri image_uri;
    private TextView tvAval;

    public static AvalesFotosGarantiasFragment newInstance() {
        return new AvalesFotosGarantiasFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492961, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle args = this.getArguments();
        String personJsonString = args.getString("aval");
        this.aval = (Aval)Utils.getGsonParser().fromJson(personJsonString, Aval.class);
        this.initElements(view);
    }

    private void initElements(View view) {
        CurrentFragment.fragment = "ClientesFotosGarantiasFragment";
        this.tvAval = (TextView)view.findViewById(2131297267);
        this.tvAval.setText((CharSequence)("Aval " + this.aval.getNombre_completo()));
        this.pathsComprobantesAval = new ArrayList();
        this.pathsGarantiasAval = new ArrayList();
        this.btnImagenesGarantiasAval = (Button)view.findViewById(2131296408);
        this.btnImagenesComprobantesAval = (Button)view.findViewById(2131296401);
        this.btnGuardarFotos = (Button)view.findViewById(2131296435);
        this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        this.btnImagenesComprobantesAval.setOnClickListener(view13 -> {
            int permisoCamara = ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA");
            int permisoAlmacen = ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (permisoCamara == 0 && permisoAlmacen == 0) {
                this.camaraGarantiasAvalAbierta = false;
                this.camaraComprobantesAvalAbierta = true;
                this.openCameraIntent();
            } else {
                ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
            }
        });
        this.btnImagenesGarantiasAval.setOnClickListener(view14 -> {
            int permisoCamara = ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA");
            int permisoAlmacen = ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (permisoCamara == 0 && permisoAlmacen == 0) {
                this.camaraGarantiasAvalAbierta = true;
                this.camaraComprobantesAvalAbierta = false;
                this.openCameraIntent();
            } else {
                ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
            }
        });
        this.btnGuardarFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AvalesFotosGarantiasFragment.this.pathsComprobantesAval.size() == 0 && AvalesFotosGarantiasFragment.this.pathsGarantiasAval.size() == 0) {
                    new MaterialAlertDialogBuilder((Context)AvalesFotosGarantiasFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"No se han tomado fotos para subir").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                } else {
                    AvalesFotosGarantiasFragment.this.subirFotos();
                }
            }
        });
    }

    private void openCameraIntent() {
        ContentValues values = new ContentValues();
        values.put("title", "Imagen ejemplo");
        values.put("description", "Camara ejemplo");
        this.image_uri = this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        Intent i = new Intent("android.media.action.IMAGE_CAPTURE");
        i.putExtra("output", (Parcelable)this.image_uri);
        this.startActivityForResult(i, 1);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            MultipartBody.Part body;
            RequestBody requestFile;
            File file;
            Bitmap reduceBitmap;
            Bitmap fullBitmap;
            Bitmap bitmap;
            if (this.camaraComprobantesAvalAbierta) {
                this.path = RealPathUtil.getRealPath((Context)this.getActivity(), this.image_uri);
                bitmap = BitmapFactory.decodeFile((String)this.path);
                this.pathsComprobantesAval.add(this.path);
                this.banderaComprobantesAvales = this.pathsComprobantesAval.size() - 1;
                fullBitmap = BitmapFactory.decodeFile((String)this.path);
                reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                file = Utils.getBitmapFile(reduceBitmap, this.path);
                requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                body = MultipartBody.Part.createFormData((String)("archivo_aval_" + this.banderaComprobantesAvales), (String)(this.banderaComprobantesAvales + "CA.jpeg"), (RequestBody)requestFile);
                this.archivosGeneral.add(body);
                this.btnImagenesComprobantesAval.setText((CharSequence)("Comprobantes (" + this.pathsComprobantesAval.size() + ")"));
            }
            if (this.camaraGarantiasAvalAbierta) {
                this.path = RealPathUtil.getRealPath((Context)this.getActivity(), this.image_uri);
                bitmap = BitmapFactory.decodeFile((String)this.path);
                this.pathsGarantiasAval.add(this.path);
                this.banderaGarantiasAvales = this.pathsGarantiasAval.size() - 1;
                fullBitmap = BitmapFactory.decodeFile((String)this.path);
                reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                file = Utils.getBitmapFile(reduceBitmap, this.path);
                requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                body = MultipartBody.Part.createFormData((String)("garantia_aval_" + this.banderaGarantiasAvales), (String)(this.banderaGarantiasAvales + "GA.jpeg"), (RequestBody)requestFile);
                this.archivosGeneral.add(body);
            }
        }
    }

    public void subirFotos() {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"subirFotos");
        RequestBody cliente_id = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.aval.getId());
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasAval.size() + ""));
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesAval.size() + ""));
        Log.d((String)"ARCHIVOS", (String)this.archivosGeneral.toString());
        Call<ResponseMe> call = retrofitInterface.subirFotosA(this.archivosGeneral, func, cliente_id, cantidad_archivos_garantias_aval, cantidad_archivos_aval);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    Log.d((String)"response", (String)((ResponseMe)response.body()).getMessage());
                    Toast.makeText((Context)AvalesFotosGarantiasFragment.this.getActivity(), (CharSequence)"Se han subido las imagenes del cliente y su aval", (int)1).show();
                    dialog.cancel();
                    Navigation.findNavController((Activity)AvalesFotosGarantiasFragment.this.getActivity(), (int)2131296862).navigate(2131296849);
                } else {
                    try {
                        JSONObject jObjError = new JSONObject(response.errorBody().string());
                        new MaterialAlertDialogBuilder((Context)AvalesFotosGarantiasFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)jObjError.getString("message")).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)AvalesFotosGarantiasFragment.this.getContext(), (CharSequence)e.getMessage(), (int)1).show();
                    }
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
            }
        });
    }
}

