/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.clientes;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.WorkManager;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.ClientesWorker;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.NetworkSpeedChecker;
import com.example.sefinsa_app.PrestamosWorker;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.clientes.ClientesViewModel;
import com.example.sefinsa_app.utilities.ClientesAdapter;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientesFragment
extends Fragment
implements NetworkChangeReceiver.NetworkChangeListener {
    private ClientesViewModel mViewModel;
    public static ArrayList<Cliente> clientes;
    public static ArrayList<Cliente> clientesFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;
    public static SearchView svClientes;
    private static ShimmerFrameLayout shimmer;
    private static RecyclerView recyclerView;
    public static ClientesAdapter clientesAdapter;
    private LinearLayoutManager linearLayoutManager;
    private FloatingActionButton fabCrearCliente;
    private SharedPreferences sesion;
    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private static ProgressDialog dialog;
    private ArrayList<Ruta> rutas;
    private ArrayList<Poblacion> poblaciones;
    private ArrayList<Colocadora> colocadoras;
    private NetworkChangeReceiver networkChangeReceiver;
    private TextView textViewMensajes;
    private NetworkSpeedChecker speedChecker;
    private boolean isConnected = true;
    private static boolean isShimmerActive;
    private int retryCount = 0;
    private static final int MAX_RETRIES = 80;
    private static final int BATCH_SIZE = 10;
    private int offset = 0;
    private boolean isLoading = false;
    private static boolean isFiltering;

    public static ClientesFragment newInstance() {
        return new ClientesFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        this.requireActivity().setRequestedOrientation(-1);
        this.networkChangeReceiver = new NetworkChangeReceiver(this);
        return inflater.inflate(2131492955, container, false);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (svClientes != null) {
            svClientes.setQuery((CharSequence)"", false);
        }
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public static void startShimmer() {
        if (shimmer != null) {
            shimmer.startShimmer();
            shimmer.setVisibility(0);
            isShimmerActive = true;
        }
    }

    public static void stopShimmer() {
        if (shimmer != null) {
            shimmer.stopShimmer();
            shimmer.setVisibility(8);
            isShimmerActive = false;
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        super.onCreate(savedInstanceState);
        Log.e((String)"ClientesFragment", (String)"SE ABRIO EL CLIENTES FRAGMENT.......................... ");
        this.textViewMensajes = (TextView)this.requireActivity().findViewById(2131296802);
        this.vs = VolleyS.getInstance(this.requireContext());
        this.requestQueue = this.vs.getRequestQueue();
        CurrentFragment.fragment = "ClientesFragment";
        this.retryCount = 0;
        this.sesion = this.requireActivity().getSharedPreferences("sesion", 0);
        this.rutaController = new RutaController((Context)this.requireActivity());
        this.poblacionController = new PoblacionController((Context)this.requireActivity());
        this.colocadoraController = new ColocadoraController((Context)this.requireActivity());
        this.clienteController = new ClienteController((Context)this.requireActivity());
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        clientes = new ArrayList();
        this.getRutas();
        this.getPoblaciones();
        if (this.rutaController.tablaExiste() && this.poblacionController.tablaExiste()) {
            this.getColocadoras();
        }
        FragmentManager fm = this.requireActivity().getSupportFragmentManager();
        for (int i = 0; i < fm.getBackStackEntryCount(); ++i) {
            fm.popBackStack();
        }
        shimmer = (ShimmerFrameLayout)view.findViewById(2131297035);
        recyclerView = (RecyclerView)view.findViewById(2131296977);
        svClientes = (SearchView)view.findViewById(2131297082);
        this.fabCrearCliente = (FloatingActionButton)view.findViewById(2131296634);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (isFiltering) {
                    return;
                }
                LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                if (layoutManager != null && !ClientesFragment.this.isLoading) {
                    int preloadMargin;
                    int visibleItemCount = layoutManager.getChildCount();
                    int totalItemCount = layoutManager.getItemCount();
                    int pastVisibleItems = layoutManager.findFirstVisibleItemPosition();
                    if (visibleItemCount + pastVisibleItems >= totalItemCount - (preloadMargin = 5)) {
                        recyclerView.post(() -> ClientesFragment.this.loadMoreClientes());
                    }
                }
            }
        });
        if (this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            this.fabCrearCliente.setVisibility(4);
        } else {
            this.fabCrearCliente.setOnClickListener(view1 -> {
                Bundle bundle = new Bundle();
                bundle.putSerializable("clientes", clientes);
                Navigation.findNavController((Activity)this.requireActivity(), (int)2131296862).navigate(2131296851, bundle);
            });
        }
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        clientesAdapter = new ClientesAdapter((Context)this.requireActivity(), new ArrayList<Cliente>());
        recyclerView.setAdapter((RecyclerView.Adapter)clientesAdapter);
        if (!this.isAdded() || this.getContext() == null) {
            Log.e((String)"ClientesFragment", (String)"El fragmento no est\u00e1 listo. Operaci\u00f3n abortada onResume.");
            return;
        }
        clientes.clear();
    }

    public void onResume() {
        super.onResume();
        CurrentFragment.fragment = "ClientesFragment";
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.speedChecker != null) {
            this.speedChecker.stopChecking();
        }
    }

    public void logLastFiveClientes(SQLiteDatabase db) {
        String query = "SELECT c.id, c.nombre_completo, c.aval_id, a.nombre_completo AS aval_nombre, c.updated_at, c.update_comprobantes, c.update_garantias FROM clientes c LEFT JOIN avales a ON c.aval_id = a.id ORDER BY c.updated_at DESC LIMIT 5";
        Cursor cursor = db.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            do {
                int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String aval_id = cursor.getString(cursor.getColumnIndexOrThrow("aval_id"));
                String avalNombre = cursor.getString(cursor.getColumnIndexOrThrow("aval_nombre"));
                String updated_at = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
                String update_comprobantes = cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes"));
                String update_garantias = cursor.getString(cursor.getColumnIndexOrThrow("update_garantias"));
                Log.d((String)"ClientesWorker", (String)("DATOS EN CONSULTA SQL: ID: " + id2 + " | Nombre: " + nombre + " | Aval_id: " + aval_id + " | Aval Nombre: " + avalNombre + " | updated_at: " + updated_at + " | update_comprobantes: " + update_comprobantes + " | update_garantias: " + update_garantias));
            } while (cursor.moveToNext());
        } else {
            Log.d((String)"ClientesWorker", (String)"No hay registros en la tabla de clientes.");
        }
        cursor.close();
    }

    public void logLastFiveAvales(SQLiteDatabase db) {
        String query = "SELECT * FROM avales ORDER BY id DESC LIMIT 5";
        Cursor cursor = db.rawQuery(query, null);
        if (cursor.moveToFirst()) {
            do {
                int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String updated_at = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
                Log.d((String)"AvalesWorker", (String)("AvalesWorker ID: " + id2 + " | Nombre: " + nombre + " | updated_at: " + updated_at));
            } while (cursor.moveToNext());
        } else {
            Log.d((String)"AvalesWorker", (String)"No hay registros en la tabla de avales.");
        }
        cursor.close();
    }

    public void onStart() {
        super.onStart();
        DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        db.close();
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.requireActivity().registerReceiver((BroadcastReceiver)this.networkChangeReceiver, filter);
        if (this.speedChecker != null) {
            this.speedChecker.startChecking();
        }
        dialog = new ProgressDialog((Context)this.requireActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        ClientesFragment.startShimmer();
        if (this.isNetworkAvailable()) {
            this.isTableEmpty("prestamos", new IsTableEmptyCallback(){

                @Override
                public void onResult(boolean isEmpty) {
                    if (isEmpty) {
                        Log.d((String)"PRESTAMOS", (String)"PRESTAMOS EST\u00c1 VAC\u00cdA. Ejecutando PrestamosWorker FULL...");
                        PrestamosWorker.allDataLoadedPrestamos = false;
                        PrestamosWorker.currentPagePrestamos = 0;
                        PrestamosWorker.isTaskPrestamosCompleted = false;
                        PrestamosWorker.enqueueWork(ClientesFragment.this.requireContext());
                    } else {
                        Log.d((String)"PRESTAMOS", (String)"PRESTAMOS NO EST\u00c1 VAC\u00cdA. Ejecutando PrestamosWorker UPDATE...");
                        PrestamosWorker.allDataLoadedPrestamos = true;
                        PrestamosWorker.currentPagePrestamos = 0;
                        PrestamosWorker.isTaskPrestamosCompleted = true;
                    }
                    ClientesFragment.this.checckBanderaPrestamos();
                }
            });
        } else {
            ClientesWorker.isTaskClientesCompleted = true;
            AvalesWorker.isTaskAvalesCompleted = true;
            PrestamosWorker.isTaskPrestamosCompleted = true;
            this.cargarClientesDesdeSQLite(this.offset, 10);
        }
        svClientes.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                ClientesFragment.this.filtrarClientes(query);
                return false;
            }

            public boolean onQueryTextChange(String newText) {
                ClientesFragment.this.filtrarClientes(newText);
                return false;
            }
        });
    }

    public void onStop() {
        super.onStop();
        this.requireActivity().unregisterReceiver((BroadcastReceiver)this.networkChangeReceiver);
        if (this.speedChecker != null) {
            this.speedChecker.stopChecking();
        }
        if (clientesAdapter != null) {
            clientesAdapter.clear();
        }
        if (clientesFiltrados != null) {
            clientesFiltrados.clear();
        }
        if (clientes != null) {
            clientes.clear();
        }
        WorkManager workManager = WorkManager.getInstance((Context)this.requireContext());
        workManager.cancelAllWorkByTag("ClientesWorker");
    }

    private void checckBanderaPrestamos() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (PrestamosWorker.isTaskPrestamosCompleted) {
                this.isTableEmpty("avales", new IsTableEmptyCallback(){

                    @Override
                    public void onResult(boolean isAvalesEmpty) {
                        if (isAvalesEmpty) {
                            AvalesWorker.allDataLoadedAvales = false;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = false;
                            AvalesWorker.enqueueWork(ClientesFragment.this.requireContext());
                        } else {
                            AvalesWorker.allDataLoadedAvales = true;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = true;
                        }
                        ClientesFragment.this.checckBanderaAvales();
                    }
                });
            } else {
                Log.d((String)"PRESTAMOS", (String)"Tarea PRESTAMOS a\u00fan no completada. Reintentando en 500ms...");
                this.checckBanderaPrestamos();
            }
        }, 1000L);
    }

    private void checckBanderaAvalesRefresh() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                Log.d((String)"AvalesWorker", (String)"Ambas tareas completadas. Ejecutando l\u00f3gica de ejecutarLogicaClientes().......");
                this.ejecutarLogicaClientesRefresh();
            } else {
                Log.d((String)"AvalesWorker", (String)"Tarea avales a\u00fan no completadas. Reintentando en 500ms...");
                this.checckBanderaAvalesRefresh();
            }
        }, 1000L);
    }

    private void checckBanderaAvales() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                Log.d((String)"PRESTAMOS", (String)"Ambas tareas completadas. Ejecutando l\u00f3gica de ejecutarLogicaClientes().......");
                this.ejecutarLogicaClientes();
            } else {
                Log.d((String)"PRESTAMOS", (String)"Tarea avales a\u00fan no completadas. Reintentando en 500ms...");
                this.checckBanderaAvales();
            }
        }, 1000L);
    }

    private void ejecutarLogicaClientesRefresh() {
        ClientesWorker.currentPageClientes = 0;
        ClientesWorker.allDataLoadedClientes = true;
        ClientesWorker.isTaskClientesCompleted = false;
        ClientesWorker.enqueueWork(this.requireContext());
        this.checkForUpdatesAndLoadCache();
        Log.d((String)"PRESTAMOS", (String)"Cargando desde cach\u00e9, m\u00e1s de 2 registros.");
    }

    private void ejecutarLogicaClientes() {
        this.countClientesInSQLite(this.requireContext(), 2, new CountClientesCallback(){

            @Override
            public void onResult(boolean result) {
                if (result) {
                    ClientesWorker.currentPageClientes = 0;
                    ClientesWorker.allDataLoadedClientes = false;
                    ClientesWorker.isTaskClientesCompleted = false;
                    ClientesWorker.enqueueWork(ClientesFragment.this.requireContext());
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ClientesFragment.this.checkForUpdatesAndLoadCache();
                        }
                    }, 1000L);
                    Log.d((String)"PRESTAMOS", (String)"Cargando enqueueWork menos de 2 registros.");
                } else {
                    ClientesWorker.currentPageClientes = 0;
                    ClientesWorker.allDataLoadedClientes = true;
                    ClientesWorker.isTaskClientesCompleted = true;
                    ClientesFragment.this.checkForUpdatesAndLoadCache();
                    Log.d((String)"PRESTAMOS", (String)"Cargando desde cach\u00e9, m\u00e1s de 2 registros.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cargarClientesDesdeSQLite(int offset, int batchSize) {
        ArrayList<Cliente> nuevosClientes = new ArrayList<Cliente>();
        this.mostrarPrimeros5Avales();
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String query = "SELECT clientes.*, clientes.ruta_id as ruta_cliente, clientes.poblacion_id as poblacion_cliente, clientes.colocadora_id as colocadora_id, colocadoras.nombre_completo as nombre_colocadora, colocadoras.ruta_id as ruta_colocadora, colocadoras.poblacion_id as poblacion_colocadora, rutas.nombre_ruta, poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, MAX(prestamos.grupo_poblacion) as grupo_anterior, MAX(prestamos.fecha_prestamo) as fecha_prestamo, COUNT(prestamos.id) as cantidad_prestamos, avales_cliente.nombre_completo as nombre_aval, avales_cliente.direccion as direccion_aval, avales_cliente.telefono as telefono_aval, avales_cliente.otras_referencias as otras_referencias_aval, avales_cliente.garantias as garantias_aval, avales_cliente.update_comprobantes as update_comprobantes_aval, avales_cliente.update_garantias as update_garantias_aval FROM clientes LEFT JOIN prestamos ON prestamos.cliente_id = clientes.id LEFT JOIN avales as avales_cliente ON avales_cliente.id = clientes.aval_id INNER JOIN colocadoras ON colocadoras.id = clientes.colocadora_id INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id INNER JOIN rutas ON rutas.id = clientes.ruta_id LEFT JOIN avales ON avales.id = clientes.aval_id GROUP BY clientes.id ORDER BY clientes.updated_at DESC LIMIT ? OFFSET ?";
        Cursor cursor = db.rawQuery(query, new String[]{String.valueOf(batchSize), String.valueOf(offset)});
        if (cursor != null && cursor.moveToFirst()) {
            try {
                do {
                    Cliente cliente = new Cliente(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")) : "", cursor.getString(cursor.getColumnIndexOrThrow("direccion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion")) : "", cursor.getString(cursor.getColumnIndexOrThrow("telefono")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono")) : "", cursor.getString(cursor.getColumnIndexOrThrow("garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")) : "", cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("ruta_cliente")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("ruta_cliente")) : "", cursor.getString(cursor.getColumnIndexOrThrow("poblacion_cliente")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("poblacion_cliente")) : "", cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")) : "", cursor.getString(cursor.getColumnIndexOrThrow("created_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("created_at")) : "", cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) : "", cursor.getString(cursor.getColumnIndexOrThrow("fecha_inicio")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_inicio")) : "", cursor.getString(cursor.getColumnIndexOrThrow("grupo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo")) : "", cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "Sin Aval", cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) : "", cursor.getString(cursor.getColumnIndexOrThrow("grupo_anterior")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo_anterior")) : "", cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) : "");
                    nuevosClientes.add(cliente);
                } while (cursor.moveToNext());
            }
            finally {
                clientes.addAll(nuevosClientes);
                Log.d((String)"PrestamosWorker", (String)("Total de Clientes a\u00f1adidos: " + nuevosClientes.size()));
                cursor.close();
            }
        }
        db.close();
        if (this.getActivity() != null && this.isAdded() && this.isVisible() && recyclerView != null && recyclerView.getAdapter() != null) {
            int totalClientes = nuevosClientes.size();
            Log.d((String)"ClientesFragment", (String)("totalClientes Clientes para updateUIWithClientes." + totalClientes));
            if (totalClientes >= 0) {
                ClientesFragment.updateUIWithClientes(clientes);
                this.isLoading = false;
            } else {
                Log.d((String)"ClientesFragment", (String)"No hay m\u00e1s Clientes para cargar.");
            }
        } else {
            Log.e((String)"ClientesFragment", (String)"ALGUN DARO ES NULO.................................................");
        }
    }

    private void loadMoreClientes() {
        if (!this.isLoading) {
            this.isLoading = true;
            this.offset += 10;
            this.cargarClientesDesdeSQLite(this.offset, 10);
        }
    }

    private void countClientesInSQLite(Context context, int threshold, CountClientesCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            int totalClientes;
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            Log.d((String)"SQLite", (String)"Abriendo base de datos...");
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM clientes", null);
            if (cursor != null) {
                totalClientes = cursor.moveToFirst() ? cursor.getInt(0) : 0;
                cursor.close();
            } else {
                totalClientes = 0;
            }
            db.close();
            Log.d((String)"SQLite", (String)("Total registros en SQLite CLIENTES: " + totalClientes));
            if (callback != null) {
                this.getActivity().runOnUiThread(() -> callback.onResult(totalClientes < threshold));
            }
            executor.shutdown();
        });
    }

    private void isTableEmpty(String tableName, IsTableEmptyCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            boolean isEmpty = true;
            try {
                if (tableName.equalsIgnoreCase("avales")) {
                    db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
                } else if (tableName.equalsIgnoreCase("prestamos")) {
                    db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
                } else {
                    throw new IllegalArgumentException("Tabla desconocida: " + tableName);
                }
                cursor = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
                if (cursor != null && cursor.moveToFirst()) {
                    isEmpty = cursor.getInt(0) == 0;
                }
            }
            finally {
                executor.shutdown();
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
            boolean finalIsEmpty = isEmpty;
            this.getActivity().runOnUiThread(() -> callback.onResult(finalIsEmpty));
        });
    }

    private void checkForUpdatesAndLoadCache() {
        if (ClientesWorker.isTaskClientesCompleted) {
            this.cargarClientesDesdeSQLite(this.offset, 10);
            ClientesWorker.isTaskClientesCompleted = false;
            this.retryCount = 0;
        } else if (this.retryCount < 80) {
            ++this.retryCount;
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                if (this.isAdded() && this.getContext() != null) {
                    this.checkForUpdatesAndLoadCache();
                } else {
                    Log.e((String)"ClientesFragment", (String)"El fragmento no est\u00e1 adjunto. Operaci\u00f3n abortada.");
                    this.cargarClientesDesdeSQLite(this.offset, 10);
                }
            }, 4000L);
        } else {
            Log.d((String)"PRESTAMOS", (String)"N\u00famero m\u00e1ximo de reintentos alcanzado. No se puede cargar la cach\u00e9.");
            this.cargarClientesDesdeSQLite(this.offset, 10);
        }
    }

    public static void updateUIWithClientes(List<Cliente> clientes) {
        clientesAdapter.setListaFiltrada((ArrayList)clientes);
        clientesAdapter.notifyDataSetChanged();
        if (shimmer != null && shimmer.getVisibility() == 0) {
            Log.d((String)"ClientesFragment", (String)"Deteniendo el shimmer...");
            ClientesFragment.stopShimmer();
            isShimmerActive = false;
        }
        if (recyclerView != null) {
            recyclerView.setVisibility(0);
        }
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mostrarPrimeros5Avales() {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT * FROM avales ORDER BY id DESC limit 5", null);
            Log.d((String)"SQLite", (String)"Mostrando los primeros 5 avales ordenados por ID:");
            while (cursor.moveToNext()) {
                int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
                String updatedAt = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
                String direccion = cursor.getString(cursor.getColumnIndexOrThrow("direccion"));
                Log.d((String)"SQLite", (String)("ID Aval : " + id2 + ", Nombre: " + nombre + ", Tel\u00e9fono: " + telefono + ", updatedAt: " + updatedAt + ", direccion: " + direccion));
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)"Error al obtener los primeros 5 avales", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            db.close();
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                isFiltering = true;
                this.isLoading = true;
                dialog = new ProgressDialog((Context)this.requireActivity(), 2131951627);
                dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
                dialog.setCanceledOnTouchOutside(false);
                dialog.show();
                ClientesFragment.startShimmer();
                isShimmerActive = true;
                clientes.clear();
                clientesAdapter.clear();
                clientesAdapter.notifyDataSetChanged();
                this.retryCount = 0;
                ClientesWorker.currentPageClientes = 0;
                ClientesWorker.allDataLoadedClientes = true;
                ClientesWorker.isTaskClientesCompleted = false;
                AvalesWorker.currentPageAvales = 0;
                AvalesWorker.allDataLoadedAvales = true;
                AvalesWorker.isTaskAvalesCompleted = false;
                Context context = this.getContext();
                if (context != null) {
                    Log.e((String)"ClientesFragment", (String)"Entro en ejecutar AvalesWorker.");
                    AvalesWorker.enqueueWork(context);
                    this.checckBanderaAvalesRefresh();
                } else {
                    Log.e((String)"ClientesFragment", (String)"El contexto es nulo. No se puede ejecutar AvalesWorker.");
                }
                this.filtrarClientes(svClientes.getQuery().toString());
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void buscarClientes(String query) {
        Log.d((String)"ClientesFragment", (String)"ENTRO EN BUSCAR CLIENTES.........................................: ");
        if (this.isAdded() && this.getContext() != null) {
            DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Log.d((String)"ClientesFragment", (String)("Ejecutando b\u00fasqueda en la base de datos con query: " + query));
            String sqlQuery = "SELECT clientes.*, clientes.ruta_id as ruta_cliente, clientes.poblacion_id as poblacion_cliente, clientes.colocadora_id as colocadora_id, colocadoras.nombre_completo as nombre_colocadora, colocadoras.ruta_id as ruta_colocadora, colocadoras.poblacion_id as poblacion_colocadora, rutas.nombre_ruta, poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, MAX(prestamos.grupo_poblacion) as grupo_anterior, MAX(prestamos.fecha_prestamo) as fecha_prestamo, COUNT(prestamos.id) as cantidad_prestamos, COALESCE(avales_prestamo.nombre_completo, avales_cliente.nombre_completo, 'Sin Aval') as nombre_aval, COALESCE(avales_prestamo.direccion, avales_cliente.direccion, '') as direccion_aval, COALESCE(avales_prestamo.telefono, avales_cliente.telefono, '') as telefono_aval, COALESCE(avales_prestamo.otras_referencias, avales_cliente.otras_referencias, '') as otras_referencias_aval, COALESCE(avales_prestamo.garantias, avales_cliente.garantias, '') as garantias_aval, COALESCE(avales_prestamo.id, avales_cliente.id, NULL) as id_aval, COALESCE(avales_prestamo.update_comprobantes, avales_cliente.update_comprobantes, '') as update_comprobantes_aval, COALESCE(avales_prestamo.update_garantias, avales_cliente.update_garantias, '') as update_garantias_aval FROM clientes LEFT JOIN prestamos ON prestamos.cliente_id = clientes.id LEFT JOIN avales as avales_prestamo ON avales_prestamo.id = prestamos.aval_id LEFT JOIN avales as avales_cliente ON avales_cliente.id = clientes.aval_id INNER JOIN colocadoras ON colocadoras.id = clientes.colocadora_id INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id INNER JOIN rutas ON rutas.id = clientes.ruta_id LEFT JOIN avales ON avales.id = prestamos.aval_id WHERE clientes.nombre_completo LIKE ? OR avales.nombre_completo LIKE ? GROUP BY clientes.id ORDER BY clientes.id DESC ";
            Cursor cursor = db.rawQuery(sqlQuery, new String[]{"%" + query + "%", "%" + query + "%"});
            if (cursor != null && cursor.moveToFirst()) {
                Log.d((String)"ClientesFragment", (String)("Clientes encontrados en la base de datos: " + cursor.getCount()));
                HashSet<String> idsEncontrados = new HashSet<String>();
                do {
                    String clienteId;
                    if (idsEncontrados.contains(clienteId = cursor.getString(cursor.getColumnIndexOrThrow("id")))) continue;
                    Cliente cliente = new Cliente(clienteId, cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")), cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_cliente")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_cliente")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("created_at")), cursor.getString(cursor.getColumnIndexOrThrow("updated_at")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")), cursor.getString(cursor.getColumnIndexOrThrow("fecha_inicio")), cursor.getString(cursor.getColumnIndexOrThrow("grupo")), cursor.getString(cursor.getColumnIndexOrThrow("id_aval")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "Sin Aval", cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")), cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")), cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")), cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")), cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) : "", cursor.getString(cursor.getColumnIndexOrThrow("grupo_anterior")), cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")));
                    clientes.add(cliente);
                    idsEncontrados.add(clienteId);
                    if (clientesFiltrados == null) {
                        clientesFiltrados = new ArrayList();
                    }
                    clientesFiltrados.add(cliente);
                    isFiltering = true;
                } while (cursor.moveToNext());
                cursor.close();
            } else {
                Log.d((String)"ClientesFragment", (String)("No se encontraron clientes para la query: " + query));
            }
            db.close();
            this.getActivity().runOnUiThread(() -> {
                if (clientesFiltrados != null) {
                    clientesAdapter.setListaFiltrada(clientesFiltrados);
                    clientesAdapter.notifyDataSetChanged();
                }
            });
        }
    }

    public void filtrarClientes(String text) {
        Log.d((String)"ClientesFragment", (String)("Texto para filtrar: " + text));
        if (text.isEmpty()) {
            Log.d((String)"ClientesFragment", (String)"Texto vac\u00edo, restableciendo lista completa.");
            clientesFiltrados = new ArrayList<Cliente>(clientes);
            isFiltering = false;
            clientesAdapter.setListaFiltrada(clientesFiltrados);
            clientesAdapter.notifyDataSetChanged();
        } else {
            Log.d((String)"ClientesFragment", (String)"Realizando filtrado en memoria.");
            HashSet<Cliente> uniqueClientesFiltrados = new HashSet<Cliente>();
            for (Cliente cliente : clientes) {
                String textoFiltro = cliente.getNombre_completo() + " " + cliente.getNombre_aval();
                if (!textoFiltro.toLowerCase().contains(text.toLowerCase())) continue;
                uniqueClientesFiltrados.add(cliente);
            }
            clientesFiltrados = new ArrayList(uniqueClientesFiltrados);
            Log.d((String)"ClientesFragment", (String)("Clientes encontrados en memoria: " + clientesFiltrados.size()));
            if (!clientesFiltrados.isEmpty()) {
                isFiltering = true;
                clientesAdapter.setListaFiltrada(clientesFiltrados);
                clientesAdapter.notifyDataSetChanged();
            } else {
                Log.d((String)"ClientesFragment", (String)"No se encontraron coincidencias en memoria. Buscando en SQLite.");
                this.buscarClientes(text);
            }
        }
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.requireContext().getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;
        if (this.speedChecker == null) {
            this.speedChecker = new NetworkSpeedChecker((Context)this.requireActivity(), this.textViewMensajes);
        }
        if (isConnected) {
            this.speedChecker.startChecking();
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            }
        } else {
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"\u00a1SIN INTERNET!");
                ClientesFragment.stopShimmer();
                recyclerView.setVisibility(0);
            }
            if (this.speedChecker != null) {
                this.speedChecker.stopChecking();
                ClientesFragment.stopShimmer();
                recyclerView.setVisibility(0);
            }
        }
        if ((this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) && isConnected) {
            this.hideTextViewAfterDelay();
        }
    }

    private void hideTextViewAfterDelay() {
        if (this.textViewMensajes != null && this.textViewMensajes.getVisibility() == 0) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            }, 3000L);
        }
    }

    private void getColocadoras() {
        if (this.colocadoraController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, response -> {
                try {
                    JSONArray data1 = (JSONArray)response.get("data");
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Gson gson = new Gson();
                        Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                        this.colocadoras.add(colocadora);
                        this.colocadoraController.nueva(colocadora);
                    }
                    Log.d((String)"Colocadoras", (String)("Registros insertados en colocadoras: " + this.colocadoras.size()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> ErrorChecker.checker(error, (Context)this.requireActivity()));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.colocadoras = this.colocadoraController.obtener();
        }
    }

    private void getRutas() {
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, response -> {
                try {
                    JSONArray data1 = (JSONArray)response.get("data");
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Gson gson = new Gson();
                        Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                        this.rutas.add(ruta);
                        this.rutaController.nueva(ruta);
                    }
                    Log.d((String)"Rutas", (String)("Registros insertados en rutas: " + this.rutas.size()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> ErrorChecker.checker(error, (Context)this.requireActivity()));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        }
    }

    private void getPoblaciones() {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, response -> {
                try {
                    JSONArray data1 = (JSONArray)response.get("data");
                    for (int i = 0; i < data1.length(); ++i) {
                        JSONObject obj = data1.getJSONObject(i);
                        Gson gson = new Gson();
                        Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                        this.poblaciones.add(poblacion);
                        this.poblacionController.nueva(poblacion);
                    }
                    Log.d((String)"Poblaciones", (String)("Registros insertados en poblaciones: " + this.poblaciones.size()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }, error -> ErrorChecker.checker(error, (Context)this.requireActivity()));
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
        }
    }

    static {
        isShimmerActive = false;
        isFiltering = false;
    }

    public static interface IsTableEmptyCallback {
        public void onResult(boolean var1);
    }

    private static interface CountClientesCallback {
        public void onResult(boolean var1);
    }
}

