/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.clientes.crear;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosFragment;
import com.example.sefinsa_app.ui.clientes.crear.ClientesCrearViewModel;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosDialogFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ClientesCrearFragment
extends Fragment
implements ClientesFotosFragment.OnPhotosSelectedListener,
AvalesFotosFragment.OnPhotosSelectedListener {
    private static final Logger log = LoggerFactory.getLogger(ClientesCrearFragment.class);
    private ClientesCrearViewModel mViewModel;
    private Button btnRegistrarCliente;
    private Button btnUbicacion;
    private Button btnSubirFotos;
    private Button btnSubirFotosAval;
    private Button btnUbicacionAval;
    private TextInputLayout tlNombreCliente;
    private TextInputLayout tlTelefono;
    private TextInputLayout tlDireccion;
    private TextInputLayout tlRuta;
    private TextInputLayout tlPoblacion;
    private TextInputLayout tlColocadora;
    private TextInputLayout tlOtrasReferencias;
    private TextInputLayout tlGarantias;
    private TextInputLayout tlNombreGrupo;
    private TextInputLayout tlNombreAval;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlGarantiasAval;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView avalesAutoCompleteTextView;
    private AutoCompleteTextView avalesAutoCompleteTextViewNuevo;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private String cliente_id = "";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private String ruta_idAval = "";
    private String poblacion_idAval = "";
    private String colocadora_idAval = "";
    private String aval_id = "";
    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private String selectedAval = "";
    private SharedPreferences sesion;
    private HashMap<String, String> avalMap;
    private ArrayList<String> pathsGarantiasCliente;
    private ArrayList<String> pathsComprobantesCliente;
    private ArrayList<String> pathsFotoCliente;
    private ArrayList<String> pathsIneCliente;
    private ArrayList<String> pathsFachadaCliente;
    private ArrayList<String> pathsContratoCliente;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private ArrayList<String> pathsFotoAval;
    private ArrayList<String> pathsIneAval;
    private ArrayList<String> pathsFachadaAval;
    List<MultipartBody.Part> archivosGeneral;
    List<MultipartBody.Part> archivosGeneralAval;
    FusedLocationProviderClient client;
    private int previousLengthCliente;
    private int previousLengthAval;
    private boolean backSpaceCliente;
    private boolean backSpaceAval;
    String lat = "";
    String lgt = "";
    String latAval = "";
    String lgtAval = "";
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();

    public static ClientesCrearFragment newInstance() {
        return new ClientesCrearFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492957, container, false);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesCliente2, ArrayList<String> pathsGarantiasCliente2, ArrayList<String> pathsIneCliente2, ArrayList<String> pathsFotoCliente2, ArrayList<String> pathsContratoCliente2, ArrayList<String> pathsFachadaCliente2, List<MultipartBody.Part> archivosGeneral2) {
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected pathsComprobantesCliente2: " + pathsComprobantesCliente2.toString()));
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected pathsContratoCliente2: " + pathsContratoCliente2.toString()));
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected pathsGarantiasCliente: " + pathsGarantiasCliente2.toString()));
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected pathsIneCliente: " + pathsIneCliente2.toString()));
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected pathsFotoCliente: " + pathsFotoCliente2.toString()));
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected pathsFachadaCliente: " + pathsFachadaCliente2.toString()));
        Log.d((String)"LOG_PHOTOS", (String)("onPhotosSelected archivosGeneral2: " + archivosGeneral2.toString()));
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        }
        this.archivosGeneral.addAll(archivosGeneral2);
        Log.d((String)"LOG_PHOTOS", (String)("this.archivosGeneral: " + this.archivosGeneral.toString()));
        for (MultipartBody.Part part : this.archivosGeneral) {
            Log.d((String)"DEBUG_ARCHIVOS", (String)("this.archivosGeneral Archivo en archivosGeneral: " + part.toString()));
        }
        for (String path : pathsContratoCliente2) {
            File file = new File(path);
            Log.d((String)"DEBUG_ARCHIVOS", (String)("this.archivosGeneral Archivo: " + path + " - Existe: " + file.exists() + " - Tama\u00f1o: " + file.length()));
        }
        if (this.pathsComprobantesCliente == null) {
            this.pathsComprobantesCliente = new ArrayList();
        }
        this.pathsComprobantesCliente.clear();
        if (this.pathsGarantiasCliente == null) {
            this.pathsGarantiasCliente = new ArrayList();
        }
        this.pathsGarantiasCliente.clear();
        if (this.pathsIneCliente == null) {
            this.pathsIneCliente = new ArrayList();
        }
        this.pathsIneCliente.clear();
        if (this.pathsFotoCliente == null) {
            this.pathsFotoCliente = new ArrayList();
        }
        this.pathsFotoCliente.clear();
        if (this.pathsFachadaCliente == null) {
            this.pathsFachadaCliente = new ArrayList();
        }
        this.pathsFachadaCliente.clear();
        if (this.pathsContratoCliente == null) {
            this.pathsContratoCliente = new ArrayList();
        }
        this.pathsContratoCliente.clear();
        if (pathsIneCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsIneCliente2);
        }
        if (pathsComprobantesCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsComprobantesCliente2);
        }
        if (pathsFotoCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsFotoCliente2);
        }
        if (pathsContratoCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsContratoCliente2);
        }
        if (pathsFachadaCliente2 != null) {
            this.pathsComprobantesCliente.addAll(pathsFachadaCliente2);
        }
        if (pathsGarantiasCliente2 != null) {
            this.pathsGarantiasCliente.addAll(pathsGarantiasCliente2);
        }
        Log.d((String)"log", (String)("Total de archivos en archivosGeneral: " + this.archivosGeneral.size()));
    }

    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval2, ArrayList<String> pathsGarantiasAval2, ArrayList<String> pathsIneAval2, ArrayList<String> pathsFotoAval2, ArrayList<String> pathsFachadaAval2, List<MultipartBody.Part> archivosGeneral2) {
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        }
        this.archivosGeneral.addAll(archivosGeneral2);
        Log.d((String)"LOG_PHOTOS", (String)("this.archivosGeneral AVAL: " + this.archivosGeneral.toString()));
        if (this.pathsComprobantesAval == null) {
            this.pathsComprobantesAval = new ArrayList();
        }
        this.pathsComprobantesAval.clear();
        if (this.pathsGarantiasAval == null) {
            this.pathsGarantiasAval = new ArrayList();
        }
        this.pathsGarantiasAval.clear();
        if (this.pathsIneAval == null) {
            this.pathsIneAval = new ArrayList();
        }
        this.pathsIneAval.clear();
        if (this.pathsFotoAval == null) {
            this.pathsFotoAval = new ArrayList();
        }
        this.pathsFotoAval.clear();
        if (this.pathsFachadaAval == null) {
            this.pathsFachadaAval = new ArrayList();
        }
        this.pathsFachadaAval.clear();
        if (pathsIneAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsIneAval2);
        }
        if (pathsComprobantesAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsComprobantesAval2);
        }
        if (pathsFotoAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFotoAval2);
        }
        if (pathsFachadaAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFachadaAval2);
        }
        if (pathsGarantiasAval2 != null) {
            this.pathsGarantiasAval.addAll(pathsGarantiasAval2);
        }
        Log.d((String)"log", (String)("Total de archivos en archivosGeneral: " + this.archivosGeneral.size()));
    }

    private Bitmap makeMutable(Bitmap bitmap) {
        return bitmap.copy(Bitmap.Config.ARGB_8888, true);
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int height;
        int width = bitmap.getWidth();
        float bitmapRatio = (float)width / (float)(height = bitmap.getHeight());
        if (bitmapRatio > 1.0f) {
            width = maxSize;
            height = (int)((float)width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int)((float)height * bitmapRatio);
        }
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        this.addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }

    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
        fos.flush();
        fos.close();
        return file;
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        Bitmap mutableBitmap = this.makeMutable(bitmap);
        String currentDateTime = this.getCurrentDateTime();
        Canvas canvas = new Canvas(mutableBitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(mutableBitmap.getHeight() - 40), (float)mutableBitmap.getWidth(), (float)mutableBitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(18.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = mutableBitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        Bundle bundle = this.getArguments();
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        this.initElements(view);
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)ClientesCrearFragment.this.rutasAdapter.getItem(i);
                ClientesCrearFragment.this.ruta_id = ruta.getId();
                if (ClientesCrearFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (ClientesCrearFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List poblacionesFiltro = ClientesCrearFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ClientesCrearFragment.this.ruta_id)).collect(Collectors.toList());
                ClientesCrearFragment.this.poblacionesAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, poblacionesFiltro);
                ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.poblacionesAdapter);
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones(this.ruta_id);
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)ClientesCrearFragment.this.poblacionesAdapter.getItem(i);
                ClientesCrearFragment.this.poblacion_id = poblacion.getId();
                if (ClientesCrearFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List colocadorasFiltro = ClientesCrearFragment.this.colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(ClientesCrearFragment.this.poblacion_id)).collect(Collectors.toList());
                ClientesCrearFragment.this.colocadorasAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, colocadorasFiltro);
                ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.colocadorasAdapter);
            }
        });
        if (this.colocadoras.size() == 0) {
            this.getColocadoras();
        }
        this.colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Colocadora colocadora = (Colocadora)ClientesCrearFragment.this.colocadorasAdapter.getItem(i);
                ClientesCrearFragment.this.colocadora_id = colocadora.getId();
            }
        });
        this.rutasAutoCompleteTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus && ClientesCrearFragment.this.rutasAutoCompleteTextView.getText().toString().isEmpty()) {
                    ClientesCrearFragment.this.poblacionesAdapter = null;
                    ClientesCrearFragment.this.poblacionesAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, (List)ClientesCrearFragment.this.poblaciones);
                    ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                    ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.poblacionesAdapter);
                    ClientesCrearFragment.this.colocadorasAdapter = null;
                    ClientesCrearFragment.this.colocadorasAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, (List)ClientesCrearFragment.this.colocadoras);
                    ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                    ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.colocadorasAdapter);
                }
            }
        });
        this.btnRegistrarCliente.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ClientesCrearFragment.this.cliente_id.equals("")) {
                    if (Validator.fieldValidation(ClientesCrearFragment.this.tlNombreCliente, "Ingresa un nombre de cliente") && Validator.fieldValidation(ClientesCrearFragment.this.tlTelefono, "Ingresa un tel\u00e9fono") && Validator.fieldValidation(ClientesCrearFragment.this.tlDireccion, "Ingresa una direcci\u00f3n") && ClientesCrearFragment.validarVariableGlobal(ClientesCrearFragment.this.tlRuta, ClientesCrearFragment.this.ruta_id, "Selecciona una ruta") && ClientesCrearFragment.validarVariableGlobal(ClientesCrearFragment.this.tlPoblacion, ClientesCrearFragment.this.poblacion_id, "Selecciona una poblaci\u00f3n") && ClientesCrearFragment.validarVariableGlobal(ClientesCrearFragment.this.tlColocadora, ClientesCrearFragment.this.colocadora_id, "Selecciona una colocadora") && Validator.fieldValidation(ClientesCrearFragment.this.tlOtrasReferencias, "Ingresa otras referencias") && Validator.fieldValidation(ClientesCrearFragment.this.tlGarantias, "Ingresa otras garant\u00edas")) {
                        if (!ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().isEmpty() || ClientesCrearFragment.this.tlNombreAval.getEditText().getText() != null) {
                            AvalController ac = new AvalController(ClientesCrearFragment.this.getContext());
                            String avalId = ac.getAvalByNombre(ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                            if (!avalId.isEmpty() || avalId != null) {
                                ClienteController cc = new ClienteController(ClientesCrearFragment.this.getContext());
                                String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                                if (Objects.equals(prestaNombre, "1")) {
                                    AlertDialog.Builder b = new AlertDialog.Builder(ClientesCrearFragment.this.getContext());
                                    b.setTitle((CharSequence)"Aviso");
                                    b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                    b.setPositiveButton((CharSequence)"Aceptar", null);
                                    AlertDialog dialog = b.create();
                                    dialog.show();
                                } else {
                                    ClientesCrearFragment.this.registrarClienteNuevo();
                                }
                            } else {
                                ClientesCrearFragment.this.registrarClienteNuevo();
                            }
                        } else {
                            ClientesCrearFragment.this.registrarClienteNuevo();
                        }
                    }
                } else {
                    String nombre = ClientesCrearFragment.this.tlNombreCliente.getEditText().getText().toString();
                    new MaterialAlertDialogBuilder((Context)ClientesCrearFragment.this.requireActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)("El cliente " + nombre + " ya fue registrado")).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                }
            }
        });
        this.btnSubirFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClientesFotosDialogFragment dialogFragment = new ClientesFotosDialogFragment();
                Bundle args = new Bundle();
                ClientesCrearFragment.this.getCurrentLocation("cliente");
                args.putString("cliente", "");
                args.putString("clienteNombre", "Nuevo Aval");
                dialogFragment.setArguments(args);
                dialogFragment.show(ClientesCrearFragment.this.getChildFragmentManager(), "ClientesFotosDialog");
            }
        });
        this.btnSubirFotosAval.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();
                Bundle args = new Bundle();
                if (ClientesCrearFragment.this.avalMap == null || ClientesCrearFragment.this.avalMap.isEmpty()) {
                    ClientesCrearFragment.this.getCurrentLocation("aval");
                    args.putString("aval", "");
                    args.putString("avalNombre", "Nuevo Aval");
                } else {
                    String personJsonString = Utils.getGsonParser().toJson((Object)ClientesCrearFragment.this.avalMap);
                    String personJsonString3 = ClientesCrearFragment.this.aval_id;
                    String personJsonString4 = "2";
                    args.putString("aval", personJsonString);
                    args.putString("avalId", personJsonString3);
                    args.putString("tipo", personJsonString4);
                }
                String nombreAval = ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().trim();
                Log.e((String)"DATA_ENVIADA", (String)("Datos de nombreAval..............................." + nombreAval));
                dialogFragment.setArguments(args);
                dialogFragment.show(ClientesCrearFragment.this.getChildFragmentManager(), "AvalesFotosDialog");
            }
        });
        this.configurarAutoCompleteTextView();
        SQLiteDatabase db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
        this.llenarAutoComplete(db);
    }

    public static boolean validarVariableGlobal(TextInputLayout textInputLayout, String variableGlobal, String errorMessage) {
        if (variableGlobal == null || variableGlobal.isEmpty()) {
            textInputLayout.setError((CharSequence)errorMessage);
            return false;
        }
        textInputLayout.setError(null);
        return true;
    }

    private void initElements(View view) {
        CurrentFragment.fragment = "ClientesCrearFragment";
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.colocadorasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296275);
        this.tlNombreCliente = (TextInputLayout)view.findViewById(2131297203);
        this.avalesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296277);
        this.avalesAutoCompleteTextViewNuevo = (AutoCompleteTextView)view.findViewById(2131296282);
        this.tlTelefono = (TextInputLayout)view.findViewById(2131297234);
        this.tlDireccion = (TextInputLayout)view.findViewById(2131297171);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297217);
        this.tlColocadora = (TextInputLayout)view.findViewById(2131297161);
        this.tlOtrasReferencias = (TextInputLayout)view.findViewById(2131297208);
        this.tlGarantias = (TextInputLayout)view.findViewById(2131297183);
        this.tlNombreAval = (TextInputLayout)view.findViewById(2131297201);
        this.tlTelefonoAval = (TextInputLayout)view.findViewById(2131297235);
        this.tlDireccionAval = (TextInputLayout)view.findViewById(2131297172);
        this.tlOtrasReferenciasAval = (TextInputLayout)view.findViewById(2131297209);
        this.tlGarantiasAval = (TextInputLayout)view.findViewById(2131297184);
        this.btnRegistrarCliente = (Button)view.findViewById(2131296447);
        this.btnSubirFotos = (Button)view.findViewById(2131296451);
        this.btnSubirFotosAval = (Button)view.findViewById(2131296452);
        this.btnUbicacion = (Button)view.findViewById(2131296457);
        this.btnUbicacionAval = (Button)view.findViewById(2131296458);
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.colocadoraController = new ColocadoraController((Context)this.getActivity());
        this.clienteController = new ClienteController((Context)this.getActivity());
        this.pathsGarantiasCliente = new ArrayList();
        this.pathsComprobantesCliente = new ArrayList();
        this.pathsIneCliente = new ArrayList();
        this.pathsFotoCliente = new ArrayList();
        this.pathsContratoCliente = new ArrayList();
        this.pathsFachadaCliente = new ArrayList();
        this.pathsGarantiasAval = new ArrayList();
        this.pathsComprobantesAval = new ArrayList();
        this.pathsIneAval = new ArrayList();
        this.pathsFotoAval = new ArrayList();
        this.pathsFachadaAval = new ArrayList();
        this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        this.btnUbicacion.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClientesCrearFragment.this.getCurrentLocation("cliente");
                ClientesCrearFragment.this.btnUbicacion.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                Toast.makeText((Context)ClientesCrearFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
            }
        });
        this.btnUbicacionAval.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClientesCrearFragment.this.getCurrentLocation("aval");
                ClientesCrearFragment.this.btnUbicacionAval.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                Toast.makeText((Context)ClientesCrearFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void getCurrentLocation(final String rol) {
        LocationManager locationManager = (LocationManager)this.getActivity().getSystemService("location");
        if (locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network")) {
            this.client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    Location location = (Location)task.getResult();
                    if (location != null) {
                        if (rol.equals("cliente")) {
                            ClientesCrearFragment.this.lat = String.valueOf(location.getLatitude());
                            ClientesCrearFragment.this.lgt = String.valueOf(location.getLongitude());
                            ClientesCrearFragment.this.btnUbicacion.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                        } else if (rol.equals("aval")) {
                            ClientesCrearFragment.this.latAval = String.valueOf(location.getLatitude());
                            ClientesCrearFragment.this.lgtAval = String.valueOf(location.getLongitude());
                            ClientesCrearFragment.this.btnUbicacionAval.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                        }
                    } else {
                        LocationRequest locationRequest = new LocationRequest().setPriority(100).setInterval(10000L).setFastestInterval(1000L).setNumUpdates(1);
                        LocationCallback locationCallback = new LocationCallback(){

                            public void onLocationResult(LocationResult locationResult) {
                                Location location1 = locationResult.getLastLocation();
                                if (Objects.equals(rol, "cliente")) {
                                    ClientesCrearFragment.this.lat = String.valueOf(location1.getLatitude());
                                    ClientesCrearFragment.this.lgt = String.valueOf(location1.getLongitude());
                                    ClientesCrearFragment.this.btnUbicacion.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                                } else if (Objects.equals(rol, "aval")) {
                                    ClientesCrearFragment.this.latAval = String.valueOf(location1.getLatitude());
                                    ClientesCrearFragment.this.lgtAval = String.valueOf(location1.getLongitude());
                                    ClientesCrearFragment.this.btnUbicacionAval.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                                }
                            }
                        };
                        ClientesCrearFragment.this.client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                    }
                }
            });
        } else {
            this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS").setFlags(0x10000000));
        }
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    private List<Aval> obtenerListaAvales() {
        String sqlQuery;
        ArrayList<Aval> listaAvales = new ArrayList<Aval>();
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(sqlQuery = "SELECT * FROM avales WHERE nombre_completo IS NOT NULL AND nombre_completo != '' ORDER BY nombre_completo ASC", null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Aval aval = new Aval(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")));
                listaAvales.add(aval);
            } while (cursor.moveToNext());
            cursor.close();
        }
        db.close();
        return listaAvales;
    }

    private void configurarAutoCompleteTextView() {
        new ObtenerClientesYAvalesTask().execute(new Void[0]);
    }

    private void limpiarCampos() {
        this.aval_id = "";
        this.tlNombreCliente.getEditText().setText((CharSequence)"");
        this.tlTelefono.getEditText().setText((CharSequence)"");
        this.tlDireccion.getEditText().setText((CharSequence)"");
        this.tlOtrasReferencias.getEditText().setText((CharSequence)"");
        this.tlGarantias.getEditText().setText((CharSequence)"");
        this.rutasAutoCompleteTextView.setText((CharSequence)"", false);
        this.poblacionesAutoCompleteTextView.setText((CharSequence)"", false);
        this.colocadorasAutoCompleteTextView.setText((CharSequence)"", false);
    }

    private void llenarCamposAval(Aval aval) {
        if (aval != null) {
            int i;
            this.tlNombreCliente.getEditText().setText((CharSequence)aval.getNombre_completo());
            this.tlTelefono.getEditText().setText((CharSequence)aval.getTelefono());
            this.tlDireccion.getEditText().setText((CharSequence)aval.getDireccion());
            this.tlOtrasReferencias.getEditText().setText((CharSequence)aval.getOtras_referencias());
            this.tlGarantias.getEditText().setText((CharSequence)aval.getGarantias());
            if (aval.getRuta_id() != null) {
                for (i = 0; i < this.rutas.size(); ++i) {
                    if (!this.rutas.get(i).getId().equals(aval.getRuta_id())) continue;
                    this.rutasAutoCompleteTextView.setText((CharSequence)this.rutas.get(i).toString(), false);
                    break;
                }
            }
            if (aval.getPoblacion_id() != null) {
                for (i = 0; i < this.poblaciones.size(); ++i) {
                    if (!this.poblaciones.get(i).getId().equals(aval.getPoblacion_id())) continue;
                    this.poblacionesAutoCompleteTextView.setText((CharSequence)this.poblaciones.get(i).toString(), false);
                    break;
                }
            }
            if (aval.getColocadora_id() != null) {
                for (i = 0; i < this.colocadoras.size(); ++i) {
                    if (!this.colocadoras.get(i).getId().equals(aval.getColocadora_id())) continue;
                    this.colocadorasAutoCompleteTextView.setText((CharSequence)this.colocadoras.get(i).toString(), false);
                    break;
                }
            }
        }
    }

    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        String queryAvales;
        Cursor cursorAvales;
        ArrayList clientes = new ArrayList();
        ArrayList avales = new ArrayList();
        ArrayList<Map<String, String>> resultado = new ArrayList<Map<String, String>>();
        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo FROM clientes WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }
        if ((cursorAvales = db.rawQuery(queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo FROM avales WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''", null)) != null) {
            while (cursorAvales.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }
        HashSet<String> nombresUnicos = new HashSet<String>();
        HashSet<String> nombresAvales = new HashSet<String>();
        for (Map map : avales) {
            nombresAvales.add((String)map.get("nombre_completo"));
        }
        for (Map map : clientes) {
            String nombreCliente = (String)map.get("nombre_completo");
            if (nombresAvales.contains(nombreCliente) || nombresUnicos.contains(nombreCliente)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreCliente);
        }
        for (Map map : avales) {
            String nombreAval = (String)map.get("nombre_completo");
            if (nombresUnicos.contains(nombreAval)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreAval);
        }
        Log.d((String)"DEBUG", (String)("Clientes: " + clientes.size() + ", Avales: " + avales.size()));
        Log.d((String)"DEBUG", (String)("Resultados combinados (filtrados): " + resultado.size()));
        return resultado;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarAutoComplete(final SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>(){

            protected List<Map<String, String>> doInBackground(Void ... voids) {
                return ClientesCrearFragment.this.getClientesYDisponibles(db);
            }

            protected void onPostExecute(List<Map<String, String>> datos) {
                ArrayList<String> nombres = new ArrayList<String>();
                HashMap<String, Map<String, String>> idMap = new HashMap<String, Map<String, String>>();
                Log.d((String)"DEBUG", (String)("Datos obtenidos para llenar el AutoComplete: " + datos));
                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre == null || nombre.trim().isEmpty()) continue;
                    nombres.add(nombre);
                    idMap.put(nombre, registro);
                }
                ArrayAdapter adapter = new ArrayAdapter(ClientesCrearFragment.this.requireContext(), 17367050, nombres);
                ClientesCrearFragment.this.avalesAutoCompleteTextViewNuevo.setAdapter((ListAdapter)adapter);
                ClientesCrearFragment.this.avalesAutoCompleteTextViewNuevo.setOnItemClickListener((parent, view, position, id2) -> {
                    if (!ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().isEmpty() || ClientesCrearFragment.this.tlNombreAval.getEditText().getText() != null) {
                        AvalController ac = new AvalController(ClientesCrearFragment.this.getContext());
                        String avalId = ac.getAvalByNombre(ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                        if (!avalId.isEmpty() || avalId != null) {
                            ClienteController cc = new ClienteController(ClientesCrearFragment.this.getContext());
                            String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(ClientesCrearFragment.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                            if (Objects.equals(prestaNombre, "1")) {
                                AlertDialog.Builder b = new AlertDialog.Builder(ClientesCrearFragment.this.getContext());
                                b.setTitle((CharSequence)"Aviso");
                                b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                b.setPositiveButton((CharSequence)"Aceptar", null);
                                ClientesCrearFragment.this.tlNombreAval.getEditText().setText((CharSequence)"");
                                AlertDialog dialog = b.create();
                                dialog.show();
                            } else {
                                String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                                Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                                if (seleccionado != null) {
                                    String idSeleccionado = (String)seleccionado.get("id");
                                    String tipoSeleccionado = (String)seleccionado.get("tipo");
                                    if ("aval".equals(tipoSeleccionado)) {
                                        ClientesCrearFragment.this.verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                    } else {
                                        ClientesCrearFragment.this.aval_id = "";
                                        ClientesCrearFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                    }
                                }
                            }
                        } else {
                            String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                            Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                            if (seleccionado != null) {
                                String idSeleccionado = (String)seleccionado.get("id");
                                String tipoSeleccionado = (String)seleccionado.get("tipo");
                                if ("aval".equals(tipoSeleccionado)) {
                                    ClientesCrearFragment.this.verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                } else {
                                    ClientesCrearFragment.this.aval_id = "";
                                    ClientesCrearFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                }
                            }
                        }
                    } else {
                        String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                        Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                        if (seleccionado != null) {
                            String idSeleccionado = (String)seleccionado.get("id");
                            String tipoSeleccionado = (String)seleccionado.get("tipo");
                            if ("aval".equals(tipoSeleccionado)) {
                                ClientesCrearFragment.this.verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                            } else {
                                ClientesCrearFragment.this.aval_id = "";
                                ClientesCrearFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                            }
                        }
                    }
                });
            }
        }.execute((Object[])new Void[0]);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void verificarAvalAsync(final SQLiteDatabase db, final String idSeleccionado, final String tipoSeleccionado) {
        new AsyncTask<Void, Void, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doInBackground(Void ... voids) {
                String nombreCliente = null;
                try (Cursor cursor = null;){
                    String query = "SELECT clientes.nombre_completo FROM clientes INNER JOIN prestamos on clientes.id = prestamos.cliente_id WHERE prestamos.aval_id = ? AND prestamos.status='0'";
                    cursor = db.rawQuery(query, new String[]{idSeleccionado});
                    if (cursor != null && cursor.moveToFirst()) {
                        nombreCliente = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                    }
                }
                return nombreCliente;
            }

            protected void onPostExecute(String nombreCliente) {
                if (nombreCliente != null) {
                    new AlertDialog.Builder(ClientesCrearFragment.this.getContext()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)("Este aval ya est\u00e1 ligado al cliente: " + nombreCliente + ". \u00bfDesea continuar?")).setCancelable(false).setPositiveButton((CharSequence)"S\u00ed", (dialog, which) -> {
                        ClientesCrearFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                        ClientesCrearFragment.this.aval_id = idSeleccionado;
                    }).setNegativeButton((CharSequence)"No", (dialog, which) -> dialog.dismiss()).show();
                } else {
                    ClientesCrearFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarCamposAsync(final SQLiteDatabase db, final String id2, final String tipo) {
        new AsyncTask<Void, Void, Map<String, String>>(){

            protected Map<String, String> doInBackground(Void ... voids) {
                HashMap<String, String> resultado = new HashMap<String, String>();
                String tabla = tipo.equals("cliente") ? "clientes" : "avales";
                String query = "SELECT id, direccion, telefono, garantias, otras_referencias, nombre_completo, carpeta_comprobantes, carpeta_garantias FROM " + tabla + " WHERE id = ?";
                Log.d((String)"DEBUG", (String)("Ejecutando query asincr\u00f3nica para llenar campos: " + query));
                Cursor cursor = db.rawQuery(query, new String[]{id2});
                if (cursor != null && cursor.moveToFirst()) {
                    resultado.put("id", cursor.getString(0));
                    resultado.put("direccion", cursor.getString(1));
                    resultado.put("telefono", cursor.getString(2));
                    resultado.put("garantias", cursor.getString(3));
                    resultado.put("otras_referencias", cursor.getString(4));
                    resultado.put("nombre_completo", cursor.getString(5));
                    resultado.put("carpeta_comprobantes", cursor.getString(6));
                    resultado.put("carpeta_garantias", cursor.getString(7));
                    ClientesCrearFragment.this.aval_id = id2;
                    cursor.close();
                }
                return resultado;
            }

            protected void onPostExecute(Map<String, String> resultado) {
                if (resultado != null && !resultado.isEmpty()) {
                    if (tipo.equals("cliente")) {
                        ClientesCrearFragment.this.aval_id = "";
                        ClientesCrearFragment.this.avalMap = null;
                        Log.d((String)"DEBUG", (String)("Ejecutando query para llenar campos SIN AVAL: " + ClientesCrearFragment.this.aval_id));
                    }
                    ClientesCrearFragment.this.avalMap = (HashMap)resultado;
                    ClientesCrearFragment.this.selectedAval = id2;
                    ClientesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)resultado.get("direccion"));
                    ClientesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)resultado.get("telefono"));
                    ClientesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)resultado.get("garantias"));
                    ClientesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)resultado.get("otras_referencias"));
                    Log.d((String)"DEBUG", (String)("Contenido de avalMap: " + ClientesCrearFragment.this.avalMap + " tipo: " + tipo));
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private void llenarCamposEnClientes(Cliente cliente) {
        if (cliente != null) {
            this.tlNombreAval.getEditText().setText((CharSequence)cliente.getNombre_completo());
            this.tlTelefonoAval.getEditText().setText((CharSequence)cliente.getTelefono());
            this.tlDireccionAval.getEditText().setText((CharSequence)cliente.getDireccion());
            this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)cliente.getOtras_referencias());
            this.tlGarantiasAval.getEditText().setText((CharSequence)cliente.getGarantias());
        }
    }

    private void limpiarCamposAval() {
        this.aval_id = "";
        this.tlNombreAval.getEditText().setText((CharSequence)"");
        this.tlTelefonoAval.getEditText().setText((CharSequence)"");
        this.tlDireccionAval.getEditText().setText((CharSequence)"");
        this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
        this.tlGarantiasAval.getEditText().setText((CharSequence)"");
    }

    private void llenarCamposEnAvales(Aval aval) {
        if (aval != null) {
            this.aval_id = "";
            this.tlNombreAval.getEditText().setText((CharSequence)aval.getNombre_completo());
            this.tlTelefonoAval.getEditText().setText((CharSequence)aval.getTelefono());
            this.tlDireccionAval.getEditText().setText((CharSequence)aval.getDireccion());
            this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)aval.getOtras_referencias());
            this.tlGarantiasAval.getEditText().setText((CharSequence)aval.getGarantias());
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarCamposClienteDesdeDB(final SQLiteDatabase db, final String id2, final String tipo) {
        new AsyncTask<Void, Void, Map<String, String>>(){

            protected Map<String, String> doInBackground(Void ... voids) {
                HashMap<String, String> resultado = new HashMap<String, String>();
                String tabla = tipo.equals("cliente") ? "clientes" : "avales";
                String query = "SELECT id, direccion, telefono, garantias, otras_referencias, nombre_completo, ruta_id, poblacion_id, colocadora_id FROM " + tabla + " WHERE id = ?";
                Log.d((String)"DEBUG", (String)("Ejecutando query para llenar campos del cliente: " + query));
                Cursor cursor = db.rawQuery(query, new String[]{id2});
                if (cursor != null && cursor.moveToFirst()) {
                    resultado.put("id", cursor.getString(0));
                    resultado.put("direccion", cursor.getString(1));
                    resultado.put("telefono", cursor.getString(2));
                    resultado.put("garantias", cursor.getString(3));
                    resultado.put("otras_referencias", cursor.getString(4));
                    resultado.put("nombre_completo", cursor.getString(5));
                    resultado.put("ruta_id", cursor.getString(6));
                    resultado.put("poblacion_id", cursor.getString(7));
                    resultado.put("colocadora_id", cursor.getString(8));
                    cursor.close();
                }
                return resultado;
            }

            protected void onPostExecute(Map<String, String> resultado) {
                if (resultado != null && !resultado.isEmpty()) {
                    int i;
                    ClientesCrearFragment.this.tlNombreCliente.getEditText().setText((CharSequence)resultado.get("nombre_completo"));
                    ClientesCrearFragment.this.tlDireccion.getEditText().setText((CharSequence)resultado.get("direccion"));
                    ClientesCrearFragment.this.tlTelefono.getEditText().setText((CharSequence)resultado.get("telefono"));
                    ClientesCrearFragment.this.tlGarantias.getEditText().setText((CharSequence)resultado.get("garantias"));
                    ClientesCrearFragment.this.tlOtrasReferencias.getEditText().setText((CharSequence)resultado.get("otras_referencias"));
                    if (resultado.get("ruta_id") != null && ClientesCrearFragment.this.rutas != null) {
                        for (i = 0; i < ClientesCrearFragment.this.rutas.size(); ++i) {
                            if (!((Ruta)ClientesCrearFragment.this.rutas.get(i)).getId().equals(resultado.get("ruta_id"))) continue;
                            ClientesCrearFragment.this.rutasAutoCompleteTextView.setText((CharSequence)((Ruta)ClientesCrearFragment.this.rutas.get(i)).toString(), false);
                            ClientesCrearFragment.this.ruta_id = ((Ruta)ClientesCrearFragment.this.rutas.get(i)).getId();
                            break;
                        }
                    }
                    if (resultado.get("poblacion_id") != null && ClientesCrearFragment.this.poblaciones != null) {
                        for (i = 0; i < ClientesCrearFragment.this.poblaciones.size(); ++i) {
                            if (!((Poblacion)ClientesCrearFragment.this.poblaciones.get(i)).getId().equals(resultado.get("poblacion_id"))) continue;
                            ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)((Poblacion)ClientesCrearFragment.this.poblaciones.get(i)).toString(), false);
                            ClientesCrearFragment.this.poblacion_id = ((Poblacion)ClientesCrearFragment.this.poblaciones.get(i)).getId();
                            break;
                        }
                    }
                    if (resultado.get("colocadora_id") != null && ClientesCrearFragment.this.colocadoras != null) {
                        for (i = 0; i < ClientesCrearFragment.this.colocadoras.size(); ++i) {
                            if (!((Colocadora)ClientesCrearFragment.this.colocadoras.get(i)).getId().equals(resultado.get("colocadora_id"))) continue;
                            ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)((Colocadora)ClientesCrearFragment.this.colocadoras.get(i)).toString(), false);
                            ClientesCrearFragment.this.colocadora_id = ((Colocadora)ClientesCrearFragment.this.colocadoras.get(i)).getId();
                            break;
                        }
                    }
                    Log.d((String)"DEBUG", (String)("Campos del cliente rellenados desde " + tipo + " con ID: " + id2));
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private List<Cliente> obtenerListaClientes() {
        String sqlQuery;
        ArrayList<Cliente> listaClientes = new ArrayList<Cliente>();
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(sqlQuery = "SELECT * FROM clientes ORDER BY nombre_completo ASC", null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Cliente cliente = new Cliente(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")), cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")));
                listaClientes.add(cliente);
            } while (cursor.moveToNext());
            cursor.close();
        } else {
            Log.d((String)"SQLiteCliente", (String)"No se encontraron clientes en la base de datos.");
        }
        db.close();
        return listaClientes;
    }

    private void getRutas() {
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance((Context)this.requireActivity());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            ClientesCrearFragment.this.rutas.add(ruta);
                            ClientesCrearFragment.this.rutaController.nueva(ruta);
                        }
                        ClientesCrearFragment.this.rutasAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, (List)ClientesCrearFragment.this.rutas);
                        ClientesCrearFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        ClientesCrearFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ClientesCrearFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.rutas = this.rutaController.obtener();
            this.rutasAdapter = new ArrayAdapter((Context)this.requireActivity(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance((Context)this.requireActivity());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            ClientesCrearFragment.this.poblaciones.add(poblacion);
                            ClientesCrearFragment.this.poblacionController.nueva(poblacion);
                        }
                        ClientesCrearFragment.this.poblacionesAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, (List)ClientesCrearFragment.this.poblaciones);
                        ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ClientesCrearFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter((Context)this.requireActivity(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getColocadoras() {
        if (this.colocadoraController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance((Context)this.requireActivity());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                            ClientesCrearFragment.this.colocadoras.add(colocadora);
                            ClientesCrearFragment.this.colocadoraController.nueva(colocadora);
                        }
                        ClientesCrearFragment.this.colocadorasAdapter = new ArrayAdapter((Context)ClientesCrearFragment.this.requireActivity(), 17367050, (List)ClientesCrearFragment.this.colocadoras);
                        ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                        ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)ClientesCrearFragment.this.colocadorasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ClientesCrearFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.colocadoras = this.colocadoraController.obtener();
            this.colocadorasAdapter = new ArrayAdapter((Context)this.requireActivity(), 17367050, this.colocadoras);
            this.colocadorasAutoCompleteTextView.setThreshold(1);
            this.colocadorasAutoCompleteTextView.setAdapter(this.colocadorasAdapter);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (ClientesCrearViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ClientesCrearViewModel.class);
    }

    public byte[] getBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream byteBuff = new ByteArrayOutputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            Log.d((String)"BUFFER", (String)(String.valueOf(data[0]) + " | " + nRead));
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    private void registrarClienteNuevo() {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        HashSet<String> set = new HashSet<String>(this.pathsComprobantesCliente);
        this.pathsComprobantesCliente.clear();
        this.pathsComprobantesCliente.addAll(set);
        HashSet<String> set2 = new HashSet<String>(this.pathsGarantiasCliente);
        this.pathsGarantiasCliente.clear();
        this.pathsGarantiasCliente.addAll(set2);
        HashSet<String> setAval = new HashSet<String>(this.pathsComprobantesAval);
        this.pathsComprobantesAval.clear();
        this.pathsComprobantesAval.addAll(setAval);
        HashSet<String> set2Aval = new HashSet<String>(this.pathsGarantiasAval);
        this.pathsGarantiasAval.clear();
        this.pathsGarantiasAval.addAll(set2Aval);
        final String nombre = this.tlNombreCliente.getEditText().getText().toString().trim();
        final String nombreFormateado = nombre.replace("\u00f1", "n").replace("\u00d1", "N").toUpperCase();
        final String direccion = this.tlDireccion.getEditText().getText().toString();
        final String telefono = this.tlTelefono.getEditText().getText().toString();
        final String orCliente = this.tlOtrasReferencias.getEditText().getText().toString();
        final String garantias = this.tlGarantias.getEditText().getText().toString();
        final String nombreAval = this.tlNombreAval.getEditText().getText().toString().trim();
        final String nombreAvalFormateado = nombreAval.replace("\u00f1", "n").replace("\u00d1", "N").toUpperCase();
        final String direccionAval = this.tlDireccionAval.getEditText().getText().toString();
        final String telefonoAval = this.tlTelefonoAval.getEditText().getText().toString();
        final String orAval = this.tlOtrasReferenciasAval.getEditText().getText().toString();
        final String garantiasAval = this.tlGarantiasAval.getEditText().getText().toString();
        Log.d((String)"ARCHIVOS", (String)("CLIENTE nombre.......................................................: " + nombre));
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"createNuevoClienteConAvalAPP");
        RequestBody nombre_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreFormateado);
        RequestBody direccion_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlDireccion.getEditText().getText().toString());
        RequestBody telefono_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlTelefono.getEditText().getText().toString());
        RequestBody or_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlOtrasReferencias.getEditText().getText().toString());
        RequestBody colocadoraId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.colocadora_id);
        RequestBody rutaId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.ruta_id);
        RequestBody poblacionId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.poblacion_id);
        RequestBody garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlGarantias.getEditText().getText().toString());
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasCliente.size() + ""));
        RequestBody cantidad_archivos_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesCliente.size() + ""));
        RequestBody latitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lat);
        RequestBody longitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lgt);
        RequestBody nombre_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreAvalFormateado);
        RequestBody direccion_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlDireccionAval.getEditText().getText().toString());
        RequestBody telefono_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlTelefonoAval.getEditText().getText().toString());
        RequestBody or_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlOtrasReferenciasAval.getEditText().getText().toString());
        RequestBody garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlGarantiasAval.getEditText().getText().toString());
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasAval.size() + ""));
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesAval.size() + ""));
        RequestBody colocadoraIdAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.colocadora_idAval);
        RequestBody rutaIdAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.ruta_idAval);
        RequestBody poblacionIdAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.poblacion_idAval);
        RequestBody latitudAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.latAval);
        RequestBody longitudAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lgtAval);
        Log.d((String)"DEBUG_ENVIO", (String)("Total de archivos a enviar antes de subir: " + this.archivosGeneral.size()));
        Call<ResponseMe> call = retrofitInterface.registrarCliente(this.archivosGeneral, func, nombre_cliente, direccion_cliente, telefono_cliente, or_cliente, garantias_cliente, rutaId, poblacionId, colocadoraId, cantidad_archivos_garantias_cliente, cantidad_archivos_cliente, nombre_aval, direccion_aval, telefono_aval, or_aval, garantias_aval, cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud, colocadoraIdAval, rutaIdAval, poblacionIdAval, latitudAval, longitudAval);
        final String cantidadGarantias = String.valueOf(this.pathsGarantiasCliente.size());
        final String cantidadGarantiasAval = String.valueOf(this.pathsGarantiasAval.size());
        final String cantidadArchivosAval = String.valueOf(this.pathsComprobantesAval.size());
        final String cantidadArchivos = String.valueOf(this.pathsComprobantesCliente.size());
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    if (response.body() != null && ((ResponseMe)response.body()).getStatus().equals("success")) {
                        Log.d((String)"response", (String)((ResponseMe)response.body()).getMessage());
                        LayoutInflater inflater = ClientesCrearFragment.this.getLayoutInflater();
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se registraron los datos correctamente.");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder((Context)ClientesCrearFragment.this.getActivity());
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        String clienteIdR = ((ResponseMe)response.body()).getClienteId();
                        String avalIdR = ((ResponseMe)response.body()).getAvalId();
                        Log.d((String)"response", (String)("Cliente registrado EN SERVER con ID clienteIdR: " + clienteIdR));
                        Log.d((String)"response", (String)("Aval registrado EN SERVER con ID avalIdR: " + avalIdR));
                        if (!ClientesCrearFragment.this.clienteExisteEnSQLite(nombreFormateado)) {
                            ClientesCrearFragment.this.registrarClienteEnSQLite(ClientesCrearFragment.this.archivosGeneral, nombreFormateado, direccion, telefono, orCliente, garantias, ClientesCrearFragment.this.ruta_id, ClientesCrearFragment.this.poblacion_id, ClientesCrearFragment.this.colocadora_id, cantidadGarantias, cantidadArchivos, clienteIdR, avalIdR, "on");
                        } else {
                            Log.d((String)"SQLite", (String)"El cliente ya existe en SQLite.");
                        }
                        if (!ClientesCrearFragment.this.avalExisteEnSQLite(nombreAvalFormateado)) {
                            Log.d((String)"SQLite", (String)"ENTRO EN REGISTRAR AVAL.................");
                            ClientesCrearFragment.this.registrarAvalEnSQLite(ClientesCrearFragment.this.archivosGeneral, nombreAvalFormateado, direccionAval, telefonoAval, orAval, garantiasAval, ClientesCrearFragment.this.ruta_id, ClientesCrearFragment.this.poblacion_id, ClientesCrearFragment.this.colocadora_id, cantidadGarantiasAval, cantidadArchivosAval, avalIdR, "on");
                        } else {
                            Log.d((String)"SQLite", (String)"El aval ya existe en SQLite.");
                        }
                        dialog.cancel();
                        ClientesCrearFragment.this.tlNombreCliente.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlTelefono.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlDireccion.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                        ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                        ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                        ClientesCrearFragment.this.tlOtrasReferencias.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlGarantias.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlNombreAval.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                        ClientesCrearFragment.this.aval_id = "";
                        ClientesCrearFragment.this.cliente_id = "";
                        ClientesCrearFragment.this.ruta_id = "";
                        ClientesCrearFragment.this.poblacion_id = "";
                        ClientesCrearFragment.this.colocadora_id = "";
                        ClientesCrearFragment.this.lat = "";
                        ClientesCrearFragment.this.lgt = "";
                        ClientesCrearFragment.this.btnUbicacion.setText((CharSequence)"OBTENER UBICACI\u00d3N");
                        ClientesCrearFragment.this.pathsGarantiasCliente.clear();
                        ClientesCrearFragment.this.pathsComprobantesCliente.clear();
                        ClientesCrearFragment.this.pathsGarantiasAval.clear();
                        ClientesCrearFragment.this.pathsComprobantesAval.clear();
                        NavOptions navOptions = new NavOptions.Builder().setPopUpTo(2131296849, true).build();
                        Navigation.findNavController((Activity)ClientesCrearFragment.this.getActivity(), (int)2131296862).navigate(2131296849, null, navOptions);
                    }
                } else {
                    try {
                        String errorBody = response.errorBody().string();
                        if (errorBody.startsWith("{")) {
                            JSONObject jObjError = new JSONObject(errorBody);
                            new MaterialAlertDialogBuilder((Context)ClientesCrearFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)jObjError.getString("message")).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            }).show();
                        } else {
                            new MaterialAlertDialogBuilder((Context)ClientesCrearFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)errorBody).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            }).show();
                        }
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)ClientesCrearFragment.this.requireActivity(), (CharSequence)e.getMessage(), (int)1).show();
                    }
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage() + " | " + t.getMessage()));
                if (t.getLocalizedMessage().contains("Unable to resolve host")) {
                    LayoutInflater inflater = ClientesCrearFragment.this.getLayoutInflater();
                    View dialogView = inflater.inflate(2131492944, null);
                    TextView messageText = (TextView)dialogView.findViewById(2131296802);
                    messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder((Context)ClientesCrearFragment.this.getActivity());
                    builder.setView(dialogView);
                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();
                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                    ClientesCrearFragment.this.registrarAvalEnSQLite(ClientesCrearFragment.this.archivosGeneral, nombreAvalFormateado, direccionAval, telefonoAval, orAval, garantiasAval, ClientesCrearFragment.this.ruta_id, ClientesCrearFragment.this.poblacion_id, ClientesCrearFragment.this.colocadora_id, cantidadGarantiasAval, cantidadArchivosAval, "", "off");
                    if (!ClientesCrearFragment.this.clienteExisteEnSQLite(nombreFormateado)) {
                        ClientesCrearFragment.this.registrarClienteEnSQLite(ClientesCrearFragment.this.archivosGeneral, nombreFormateado, direccion, telefono, orCliente, garantias, ClientesCrearFragment.this.ruta_id, ClientesCrearFragment.this.poblacion_id, ClientesCrearFragment.this.colocadora_id, cantidadGarantias, cantidadArchivos, "", "", "off");
                    }
                    String tipo = "InsertCliente";
                    Log.d((String)"SQLite", (String)("Valor Id AVAL PARA Solicitud de subida: " + ClientesCrearFragment.this.aval_id));
                    SolicitudSubida solicitud = new SolicitudSubida(ClientesCrearFragment.this.archivosGeneral, nombre, direccion, telefono, orCliente, garantias, ClientesCrearFragment.this.ruta_id, ClientesCrearFragment.this.poblacion_id, ClientesCrearFragment.this.colocadora_id, cantidadGarantias, cantidadArchivos, tipo, "", ClientesCrearFragment.this.aval_id);
                    ClientesCrearFragment.this.colaSolicitudes.agregarSolicitud(solicitud);
                    SolicitudSubida solicitud2 = new SolicitudSubida(ClientesCrearFragment.this.archivosGeneral, nombreAval, direccionAval, telefonoAval, orAval, garantiasAval, ClientesCrearFragment.this.ruta_id, ClientesCrearFragment.this.poblacion_id, ClientesCrearFragment.this.colocadora_id, cantidadGarantiasAval, cantidadArchivosAval, "InsertAval", ClientesCrearFragment.this.cliente_id, "");
                    ClientesCrearFragment.this.colaSolicitudes.agregarSolicitud(solicitud2);
                    ClientesCrearFragment.this.tlNombreCliente.getEditText().setText((CharSequence)"");
                    ClientesCrearFragment.this.tlTelefono.getEditText().setText((CharSequence)"");
                    ClientesCrearFragment.this.tlDireccion.getEditText().setText((CharSequence)"");
                    ClientesCrearFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    ClientesCrearFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    ClientesCrearFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                    ClientesCrearFragment.this.tlOtrasReferencias.getEditText().setText((CharSequence)"");
                    ClientesCrearFragment.this.tlGarantias.getEditText().setText((CharSequence)"");
                    ClientesCrearFragment.this.cliente_id = "";
                    ClientesCrearFragment.this.ruta_id = "";
                    ClientesCrearFragment.this.poblacion_id = "";
                    ClientesCrearFragment.this.colocadora_id = "";
                    ClientesCrearFragment.this.pathsGarantiasCliente.clear();
                    ClientesCrearFragment.this.pathsComprobantesCliente.clear();
                    NavOptions navOptions = new NavOptions.Builder().setPopUpTo(2131296849, true).build();
                    Navigation.findNavController((Activity)ClientesCrearFragment.this.getActivity(), (int)2131296862).navigate(2131296849, null, navOptions);
                }
            }
        });
    }

    public boolean clienteExisteEnSQLite(String nombre) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM clientes WHERE nombre_completo = ?", new String[]{nombre});
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        cursor.close();
        return count > 0;
    }

    public boolean avalExisteEnSQLite(String nombre) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM avales WHERE nombre_completo = ?", new String[]{nombre});
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        cursor.close();
        return count > 0;
    }

    private void registrarClienteEnSQLite(List<MultipartBody.Part> archivosGeneral2, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String rutaId, String poblacionId, String colocadoraId, String cantidadGarantias, String cantidadArchivos, String clienteIdR, String avalIdR, String on) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        if (this.verificarClienteExistente(db, nombre)) {
            Log.d((String)"SQLite", (String)("El cliente con nombre " + nombre + " ya existe en la base de datos."));
            Toast.makeText((Context)this.requireContext(), (CharSequence)"El cliente con este nombre ya existe.", (int)1).show();
            db.close();
            return;
        }
        Log.d((String)"SQLite", (String)("ANTES D EENTRAR EN avalIdR..................." + avalIdR + " / " + this.aval_id));
        if (avalIdR.isEmpty()) {
            Log.d((String)"SQLite", (String)("ENTRO EN avalIdR..................." + avalIdR + " / " + this.aval_id));
            avalIdR = this.aval_id;
        }
        if (!clienteIdR.isEmpty()) {
            this.cliente_id = clienteIdR;
            Log.d((String)"SQLite", (String)("ENTRO EN clienteIdR..................." + clienteIdR + " / " + this.cliente_id));
        } else {
            Log.d((String)"SQLite", (String)("El cliente con nombre " + nombre + " ya existe en la base de datos."));
            this.cliente_id = String.valueOf(this.obtenerSiguienteIdCliente(db));
            Log.d((String)"SQLite", (String)("ENTRO EN ELSE........................ clienteIdR" + clienteIdR + " / " + this.cliente_id));
        }
        Log.d((String)"SQLite", (String)("Valores recibidos para inserci\u00f3n: rutaId=" + rutaId + ", poblacionId=" + poblacionId));
        Log.d((String)"SQLite", (String)("VALR DE CLIENTE PARA AVAL_ID LIGADO MODO OFFLINE " + avalIdR + " / " + avalIdR));
        ContentValues valores = new ContentValues();
        valores.put("id", this.cliente_id);
        valores.put("nombre_completo", nombre);
        valores.put("direccion", direccion);
        valores.put("telefono", telefono);
        valores.put("otras_referencias", otrasReferencias);
        valores.put("garantias", garantias);
        valores.put("ruta_id", rutaId != null && !rutaId.isEmpty() ? rutaId : null);
        valores.put("poblacion_id", poblacionId != null && !poblacionId.isEmpty() ? poblacionId : null);
        valores.put("colocadora_id", this.colocadora_id);
        valores.put("aval_id", avalIdR);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        Date nuevaFecha = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);
        valores.put("created_at", fechaRestada);
        valores.put("updated_at", fechaRestada);
        valores.put("prestanombre", "0");
        long resultado = db.insert("clientes", null, valores);
        if (resultado != -1L) {
            Log.d((String)"SQLite", (String)("Cliente registrado con \u00e9xito en SQLite con ID: " + this.cliente_id));
        } else {
            Log.d((String)"SQLite", (String)"Error al registrar el cliente en SQLite.");
        }
        db.close();
    }

    private boolean verificarClienteExistente(SQLiteDatabase db, String nombre) {
        String query = "SELECT COUNT(*) FROM clientes WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        boolean existe = false;
        if (cursor.moveToFirst()) {
            existe = cursor.getInt(0) > 0;
        }
        cursor.close();
        return existe;
    }

    private int obtenerSiguienteIdCliente(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM clientes", null);
        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();
        return ultimoId + 1;
    }

    private void registrarAvalEnSQLite(List<MultipartBody.Part> archivosGeneral2, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String rutaId, String poblacionId, String colocadoraId, String cantidadGarantias, String cantidadArchivos, String idServer, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        String query = "SELECT id FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -5);
        Date nuevaFecha = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);
        if (cursor.moveToFirst()) {
            this.aval_id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
            Log.d((String)"SQLite", (String)("El aval ya existe en SQLite con ID: " + this.aval_id));
            ContentValues valores = new ContentValues();
            valores.put("direccion", direccion);
            valores.put("telefono", telefono);
            valores.put("otras_referencias", otrasReferencias);
            valores.put("garantias", garantias);
            valores.put("ruta_id", rutaId);
            valores.put("poblacion_id", poblacionId);
            valores.put("colocadora_id", colocadoraId);
            valores.put("updated_at", fechaRestada);
            int filasAfectadas = db.update("avales", valores, "id = ?", new String[]{this.aval_id});
            if (filasAfectadas > 0) {
                Log.d((String)"SQLite", (String)("Aval actualizado con \u00e9xito en SQLite con ID: " + this.aval_id));
            } else {
                Log.d((String)"SQLite", (String)"Error al actualizar el aval en SQLite.");
            }
        } else {
            if (!online.equals("off")) {
                Log.d((String)"SQLite", (String)"ENTRO EN TOMAR ID EN L\u00cdNEA");
                this.aval_id = idServer;
            } else {
                Log.d((String)"SQLite", (String)"ENTRO EN TOMAR ID SIN CONEXI\u00d3N");
                this.aval_id = String.valueOf(this.obtenerSiguienteIdAval(db));
            }
            ContentValues valores = new ContentValues();
            valores.put("id", this.aval_id);
            valores.put("nombre_completo", nombre);
            valores.put("direccion", direccion);
            valores.put("telefono", telefono);
            valores.put("otras_referencias", otrasReferencias);
            valores.put("garantias", garantias);
            valores.put("ruta_id", rutaId);
            valores.put("poblacion_id", poblacionId);
            valores.put("colocadora_id", colocadoraId);
            valores.put("created_at", fechaRestada);
            valores.put("updated_at", fechaRestada);
            long resultado = db.insert("avales", null, valores);
            if (resultado != -1L) {
                Log.d((String)"SQLite", (String)("Aval registrado con \u00e9xito en SQLite con ID: " + this.aval_id));
            } else {
                Log.d((String)"SQLite", (String)"Error al registrar el aval en SQLite.");
            }
        }
        cursor.close();
        db.close();
    }

    private boolean verificarAvalExistente(SQLiteDatabase db, String nombre) {
        String query = "SELECT COUNT(*) FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        boolean existe = false;
        if (cursor.moveToFirst()) {
            existe = cursor.getInt(0) > 0;
        }
        cursor.close();
        return existe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int obtenerSiguienteIdAval(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = null;
        try {
            Log.d((String)"SQLite", (String)"Ejecutando consulta para obtener el m\u00e1ximo ID en la tabla 'avales'");
            cursor = db.rawQuery("SELECT MAX(id) FROM avales", null);
            if (cursor != null && cursor.moveToFirst()) {
                ultimoId = cursor.getInt(0);
                Log.d((String)"SQLite", (String)("\u00daltimo ID obtenido de la tabla 'avales': " + ultimoId));
            } else {
                Log.w((String)"SQLite", (String)"Cursor est\u00e1 vac\u00edo o no contiene datos al consultar MAX(id)");
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error al obtener el siguiente ID disponible en 'avales': " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
                Log.d((String)"SQLite", (String)"Cursor cerrado despu\u00e9s de consultar MAX(id) en 'avales'");
            }
        }
        int siguienteId = ultimoId + 1;
        Log.d((String)"SQLite", (String)("Siguiente ID calculado para la tabla 'avales': " + siguienteId));
        return siguienteId;
    }

    private class ObtenerClientesYAvalesTask
    extends AsyncTask<Void, Void, List<Map<String, String>>> {
        private ObtenerClientesYAvalesTask() {
        }

        protected List<Map<String, String>> doInBackground(Void ... voids) {
            DatabaseHelper dbHelper = new DatabaseHelper(ClientesCrearFragment.this.requireContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            return ClientesCrearFragment.this.getClientesYDisponibles(db);
        }

        protected void onPostExecute(List<Map<String, String>> datos) {
            ArrayList<String> nombres = new ArrayList<String>();
            HashMap<String, Map<String, String>> idMap = new HashMap<String, Map<String, String>>();
            Log.d((String)"DEBUG", (String)("Datos obtenidos para llenar el AutoComplete del cliente: " + datos));
            for (Map<String, String> registro : datos) {
                String nombre = registro.get("nombre_completo");
                if (nombre == null || nombre.trim().isEmpty()) continue;
                nombres.add(nombre);
                idMap.put(nombre, registro);
            }
            ArrayAdapter adapter = new ArrayAdapter(ClientesCrearFragment.this.requireContext(), 17367050, nombres);
            ClientesCrearFragment.this.avalesAutoCompleteTextView.setAdapter((ListAdapter)adapter);
            ClientesCrearFragment.this.avalesAutoCompleteTextView.setOnItemClickListener((parent, view, position, id2) -> {
                String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                if (seleccionado != null) {
                    String idSeleccionado = (String)seleccionado.get("id");
                    String tipoSeleccionado = (String)seleccionado.get("tipo");
                    DatabaseHelper dbHelper = new DatabaseHelper(ClientesCrearFragment.this.requireContext());
                    SQLiteDatabase db = dbHelper.getReadableDatabase();
                    if ("aval".equals(tipoSeleccionado)) {
                        ClientesCrearFragment.this.aval_id = idSeleccionado;
                        ClientesCrearFragment.this.llenarCamposClienteDesdeDB(db, idSeleccionado, tipoSeleccionado);
                    } else {
                        ClientesCrearFragment.this.aval_id = "";
                        ClientesCrearFragment.this.llenarCamposClienteDesdeDB(db, idSeleccionado, tipoSeleccionado);
                    }
                }
            });
        }
    }
}

