/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.clientes.documentos;

import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.ui.clientes.documentos.ClientesDocumentosViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.MemoryPolicy;
import com.squareup.picasso.NetworkPolicy;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientesDocumentosFragment
extends Fragment {
    private ClientesDocumentosViewModel mViewModel;
    private TextView tvCliente;
    private TextView tvAval;
    private Cliente cliente;
    private String clienteId;
    private LinearLayoutCompat comprobantesCliente;
    private LinearLayoutCompat garantiasCliente;
    private LinearLayoutCompat comprobantesAval;
    private LinearLayoutCompat garantiasAval;
    private VolleyS vs;
    private RequestQueue requestQueue;
    int maxRetries = 3;
    int maxRetriesAval = 3;

    public static ClientesDocumentosFragment newInstance() {
        return new ClientesDocumentosFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        return inflater.inflate(2131492958, container, false);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.getFiles("comprobantes/clientes/" + this.cliente.getId() + "_" + this.cliente.getNombre_completo().toUpperCase(), this.comprobantesCliente);
                this.getFiles("garantias/clientes/" + this.cliente.getId() + "_" + this.cliente.getNombre_completo().toUpperCase(), this.garantiasCliente);
                this.getFiles("comprobantes/avales/" + this.cliente.getAval_id() + "_" + this.cliente.getNombre_aval().toUpperCase(), this.comprobantesAval);
                this.getFiles("garantias/avales/" + this.cliente.getAval_id() + "_" + this.cliente.getNombre_aval().toUpperCase(), this.garantiasAval);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initElements(view);
        this.getFiles("comprobantes/clientes/" + this.clienteId + "_" + this.cliente.getNombre_completo().toUpperCase(), this.comprobantesCliente);
        this.getFiles("garantias/clientes/" + this.clienteId + "_" + this.cliente.getNombre_completo().toUpperCase(), this.garantiasCliente);
        this.getFilesA("comprobantes/avales/" + this.cliente.getAval_id() + "_" + this.cliente.getNombre_aval().toUpperCase(), this.comprobantesAval);
        this.getFilesA("garantias/avales/" + this.cliente.getAval_id() + "_" + this.cliente.getNombre_aval().toUpperCase(), this.garantiasAval);
        Log.d((String)"DEBUG1", (String)("ARREGLO EN CLIENTES DOCUMENTOS................" + this.cliente.toString()));
        Log.d((String)"DEBUG1", (String)String.valueOf(this.cliente));
        Log.d((String)"DEBUG2", (String)this.clienteId);
        Log.d((String)"DEBUG2", (String)("ID de aval en DocumentosClientes................" + this.cliente.getAval_id()));
    }

    public void initElements(View view) {
        CurrentFragment.fragment = "ClientesDocumentosFragment";
        Bundle args = this.getArguments();
        String personJsonString = args.getString("cliente");
        String personJsonString3 = args.getString("clienteId");
        this.cliente = (Cliente)Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
        Log.e((String)"Error", (String)("Archivo cliente.........................: " + this.cliente.toString()));
        this.clienteId = personJsonString3;
        this.tvCliente = (TextView)view.findViewById(2131297272);
        this.tvCliente.setText((CharSequence)("EXPEDIENTE DE: \n" + this.cliente.getNombre_completo()));
        this.tvAval = (TextView)view.findViewById(2131297267);
        this.tvAval.setText((CharSequence)("AVAL: \n" + this.cliente.getNombre_aval()));
        this.comprobantesCliente = (LinearLayoutCompat)view.findViewById(2131296508);
        this.garantiasCliente = (LinearLayoutCompat)view.findViewById(2131296658);
        this.comprobantesAval = (LinearLayoutCompat)view.findViewById(2131296507);
        this.garantiasAval = (LinearLayoutCompat)view.findViewById(2131296657);
    }

    private void checkIfImageExists(String url, Runnable onSuccess, Runnable onFailure) {
        StringRequest headRequest = new StringRequest(4, url, response -> onSuccess.run(), error -> onFailure.run());
        this.requestQueue.add((Request)headRequest);
    }

    public void getFiles(final String carpeta, final LinearLayoutCompat contenedor) {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        final String path = API.url.replace("php/", "resources/");
        String ruta = "../../resources/" + carpeta;
        Log.d((String)"ruta", (String)("RUTA COMPLETA............:" + ruta));
        final JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"archivos");
            data.put("ruta", (Object)ruta);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"4", (String)"loadAllData: ");
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    dialog.cancel();
                    Log.d((String)"data", (String)String.valueOf(data));
                    if (!response.get("data").toString().equals("false")) {
                        JSONArray jsonArray = (JSONArray)response.get("data");
                        Log.d((String)"archivos", (String)(jsonArray.length() + ""));
                        ArrayList<String> fileNames = new ArrayList<String>();
                        for (int i = 2; i < jsonArray.length(); ++i) {
                            String fileName = jsonArray.getString(i);
                            if (fileName.endsWith("9Expediente") || fileName.endsWith("9Thumbnail")) {
                                Log.d((String)"OMITIR", (String)("Archivo omitido porque termina en 'T' o es una subcarpeta: " + fileName));
                                continue;
                            }
                            fileNames.add(fileName);
                        }
                        ClientesDocumentosFragment.this.showImageSequentially(fileNames, 0, path, contenedor, carpeta);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)ClientesDocumentosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void showImageSequentially(final List<String> fileNames, final int index, final String path, final LinearLayoutCompat contenedor, final String carpeta) {
        if (index >= fileNames.size()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;
        float percentage = 0.85f;
        final int calculatedWidth = (int)((float)windowWidth * percentage);
        String fileName = fileNames.get(index);
        final ImageView image = new ImageView((Context)this.getActivity());
        String imageUrl = path + carpeta + "/" + fileName;
        String fileNameConE = "";
        fileNameConE = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) + "E" + fileName.substring(fileName.lastIndexOf(".")) : fileName + "E";
        final String subcarpetaUrl = path + carpeta + "/9Expediente/" + fileNameConE;
        this.checkIfImageExists(subcarpetaUrl, () -> ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this.getActivity()).asBitmap().load(subcarpetaUrl).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true)).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                ClientesDocumentosFragment.this.processImage(resource, calculatedWidth, contenedor, image, subcarpetaUrl);
                new Handler(Looper.getMainLooper()).postDelayed(() -> ClientesDocumentosFragment.this.showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 80L);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                Log.e((String)"GlideError", (String)("No se pudo cargar la imagen desde la URL: " + subcarpetaUrl));
            }
        }), () -> this.loadImageWithRetries(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, this.maxRetries, 0));
    }

    private void loadImageWithRetries(final String imageUrl, final int calculatedWidth, final LinearLayoutCompat contenedor, final ImageView image, final List<String> fileNames, final int index, final String path, final String carpeta, final int maxRetries, final int currentRetry) {
        if (this.getActivity() == null || !this.isAdded()) {
            Log.e((String)"GlideError", (String)"Fragmento no adjunto, cancelando carga de imagen.");
            return;
        }
        ((RequestBuilder)((RequestBuilder)Glide.with((Fragment)this).asBitmap().load(imageUrl).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true)).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                ClientesDocumentosFragment.this.processImage(resource, calculatedWidth, contenedor, image, imageUrl);
                new Handler(Looper.getMainLooper()).postDelayed(() -> ClientesDocumentosFragment.this.showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 80L);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                Log.e((String)"GlideError", (String)("Fallo al cargar la imagen desde: " + imageUrl));
                if (currentRetry < maxRetries) {
                    Log.d((String)"GlideRetry", (String)("Reintentando carga. Intento " + (currentRetry + 1) + " de " + maxRetries));
                    ClientesDocumentosFragment.this.loadImageWithRetries(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, maxRetries, currentRetry + 1);
                } else {
                    Log.e((String)"GlideError", (String)("Todos los reintentos fallaron para la URL: " + imageUrl));
                }
            }
        });
    }

    private void loadImageWithRetriesAval(final String imageUrl, final int calculatedWidth, final LinearLayoutCompat contenedor, final ImageView image, final List<String> fileNames, final int index, final String path, final String carpeta, final int maxRetries, final int currentRetry) {
        ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this.getActivity()).asBitmap().load(imageUrl).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true)).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                ClientesDocumentosFragment.this.processImage(resource, calculatedWidth, contenedor, image, imageUrl);
                new Handler(Looper.getMainLooper()).postDelayed(() -> ClientesDocumentosFragment.this.showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 80L);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                Log.e((String)"GlideError", (String)("Fallo al cargar la imagen desde: " + imageUrl));
                if (currentRetry < ClientesDocumentosFragment.this.maxRetriesAval) {
                    Log.d((String)"GlideRetry", (String)("Reintentando carga. Intento " + (currentRetry + 1) + " de " + maxRetries));
                    ClientesDocumentosFragment.this.loadImageWithRetriesAval(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, maxRetries, currentRetry + 1);
                } else {
                    Log.e((String)"GlideError", (String)("Todos los reintentos fallaron para la URL: " + imageUrl));
                }
            }
        });
    }

    private void processImage(Bitmap resource, int calculatedWidth, LinearLayoutCompat contenedor, ImageView image, String imageUrl) {
        int imageWidth = resource.getWidth();
        int imageHeight = resource.getHeight();
        int calculatedHeight = (int)((float)imageHeight / (float)imageWidth * (float)calculatedWidth);
        LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(calculatedWidth, calculatedHeight);
        params.setMargins(0, 0, 0, 15);
        image.setLayoutParams((ViewGroup.LayoutParams)params);
        image.setScaleType(ImageView.ScaleType.FIT_CENTER);
        image.setImageBitmap(resource);
        contenedor.addView((View)image);
        image.setOnClickListener(view -> {
            View dialogView = LayoutInflater.from((Context)this.requireActivity()).inflate(2131492931, null);
            TouchImageView touchImageView = (TouchImageView)dialogView.findViewById(2131296693);
            Picasso.get().load(imageUrl).memoryPolicy(MemoryPolicy.NO_CACHE, new MemoryPolicy[]{MemoryPolicy.NO_STORE}).networkPolicy(NetworkPolicy.NO_CACHE, new NetworkPolicy[0]).into((ImageView)touchImageView);
            new MaterialAlertDialogBuilder((Context)this.getActivity()).setTitle((CharSequence)"").setView(dialogView).setCancelable(false).setPositiveButton((CharSequence)"CERRAR", (dialogInterface, i) -> {}).show();
        });
    }

    public void getFilesA(final String carpeta, final LinearLayoutCompat contenedor) {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        Log.d((String)"ruta", (String)("solo carpeta de aval:" + carpeta));
        final String path = API.url.replace("php/", "resources/");
        String ruta = "../../resources/" + carpeta;
        Log.d((String)"ruta", (String)("RUTA COMPLETA............:" + ruta));
        final JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"archivos");
            data.put("ruta", (Object)ruta);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlAvales, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    dialog.cancel();
                    Log.d((String)"data", (String)String.valueOf(data));
                    if (!response.get("data").toString().equals("false")) {
                        JSONArray jsonArray = (JSONArray)response.get("data");
                        Log.d((String)"archivos", (String)(jsonArray.length() + ""));
                        ArrayList<String> fileNames = new ArrayList<String>();
                        for (int i = 2; i < jsonArray.length(); ++i) {
                            String fileName = jsonArray.getString(i);
                            if (fileName.endsWith("9Expediente") || fileName.endsWith("9Thumbnail")) {
                                Log.d((String)"OMITIR", (String)("Archivo omitido porque termina en 'T' o es una subcarpeta: " + fileName));
                                continue;
                            }
                            fileNames.add(jsonArray.getString(i));
                        }
                        Log.d((String)"OMITIR", (String)("Archivo en fileNames AVALES: " + fileNames));
                        ClientesDocumentosFragment.this.showImageSequentiallyA(fileNames, 0, path, contenedor, carpeta);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)ClientesDocumentosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void showImageSequentiallyA(final List<String> fileNames, final int index, final String path, final LinearLayoutCompat contenedor, final String carpeta) {
        if (index >= fileNames.size()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;
        float percentage = 0.85f;
        final int calculatedWidth = (int)((float)windowWidth * percentage);
        String fileName = fileNames.get(index);
        final ImageView image = new ImageView((Context)this.getActivity());
        String imageUrl = path + carpeta + "/" + fileName;
        String fileNameConE = "";
        fileNameConE = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) + "E" + fileName.substring(fileName.lastIndexOf(".")) : fileName + "E";
        final String subcarpetaUrl = path + carpeta + "/9Expediente/" + fileNameConE;
        this.checkIfImageExists(subcarpetaUrl, () -> ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this.getActivity()).asBitmap().load(subcarpetaUrl).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true)).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                ClientesDocumentosFragment.this.processImage(resource, calculatedWidth, contenedor, image, subcarpetaUrl);
                new Handler(Looper.getMainLooper()).postDelayed(() -> ClientesDocumentosFragment.this.showImageSequentiallyA(fileNames, index + 1, path, contenedor, carpeta), 80L);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                Log.e((String)"GlideError", (String)("No se pudo cargar la imagen desde la URL: " + subcarpetaUrl));
            }
        }), () -> this.loadImageWithRetriesAval(imageUrl, calculatedWidth, contenedor, image, fileNames, index, path, carpeta, this.maxRetries, 0));
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (ClientesDocumentosViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ClientesDocumentosViewModel.class);
    }
}

