/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.clientes.editar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigation;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosFragment;
import com.example.sefinsa_app.ui.clientes.editar.ClientesEditarViewModel;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesFotosDialogFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ClientesEditarFragment
extends Fragment
implements AvalesFotosFragment.OnPhotosSelectedListener {
    private ClientesEditarViewModel mViewModel;
    private TextInputLayout tlCliente;
    private TextInputLayout tlTelefono;
    private TextInputLayout tlDireccion;
    private TextInputLayout tlRuta;
    private TextInputLayout tlPoblacion;
    private TextInputLayout tlColocadora;
    private TextInputLayout tlOtrasReferencias;
    private TextInputLayout tlGarantias;
    private TextInputLayout tlAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlGarantiasAval;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView clientesAutoCompleteTextView;
    private AutoCompleteTextView avalesAutoCompleteTextView;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private Button btnEditarCliente;
    private Button btnUbicacion;
    private Button btnSubirFotos;
    private Button btnSubirFotosA;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private ArrayList<Cliente> clientes;
    private ArrayAdapter<Cliente> clientesAdapter;
    private String selectedAval = "";
    private String cliente_id = "";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private String aval_id = "";
    private String rutaId_aval = "";
    private String poblacionId_aval = "";
    private String colocadoraId_aval = "";
    private int previousLengthCliente;
    private boolean backSpaceCliente;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private int previousLengthAval;
    private boolean backSpaceAval;
    List<MultipartBody.Part> archivosGeneral;
    List<MultipartBody.Part> archivosGeneralAval;
    private ArrayList<String> pathsGarantiasCliente;
    private ArrayList<String> pathsComprobantesCliente;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private HashMap<String, String> avalMap;
    String lat = "";
    String lgt = "";
    String latAval = "";
    String lgtAval = "";
    Button btnUbicacionAval;
    FusedLocationProviderClient client;
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();

    public static ClientesEditarFragment newInstance() {
        return new ClientesEditarFragment();
    }

    private void showAlert(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(BluetoothUtils.context);
        builder.setMessage((CharSequence)message);
        TextView title = new TextView(BluetoothUtils.context);
        title.setText((CharSequence)"Alerta");
        title.setGravity(17);
        title.setTextSize(2, 20.0f);
        title.setTextColor(ContextCompat.getColor((Context)BluetoothUtils.context, (int)17170444));
        title.setPadding(0, 20, 0, 20);
        builder.setCustomTitle((View)title);
        builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval2, ArrayList<String> pathsGarantiasAval2, ArrayList<String> pathsIneAval2, ArrayList<String> pathsFotoAval2, ArrayList<String> pathsFachadaAval2, List<MultipartBody.Part> archivosGeneral2) {
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        }
        this.archivosGeneral.addAll(archivosGeneral2);
        Log.d((String)"LOG_PHOTOS", (String)("this.archivosGeneral AVAL: " + this.archivosGeneral.toString()));
        if (this.pathsComprobantesAval == null) {
            this.pathsComprobantesAval = new ArrayList();
        }
        this.pathsComprobantesAval.clear();
        if (this.pathsGarantiasAval == null) {
            this.pathsGarantiasAval = new ArrayList();
        }
        this.pathsGarantiasAval.clear();
        if (pathsIneAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsIneAval2);
        }
        if (pathsComprobantesAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsComprobantesAval2);
        }
        if (pathsFotoAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFotoAval2);
        }
        if (pathsFachadaAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsFachadaAval2);
        }
        if (pathsGarantiasAval2 != null) {
            this.pathsGarantiasAval.addAll(pathsGarantiasAval2);
        }
        Log.d((String)"log", (String)("Total de archivos en archivosGeneral: " + this.archivosGeneral.size()));
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492959, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle bundle = this.getArguments();
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        this.initElements(view);
        this.aval_id = "";
        this.rutaId_aval = "";
        this.poblacionId_aval = "";
        this.colocadoraId_aval = "";
        Bundle args = this.getArguments();
        String personJsonString = args.getString("cliente");
        final Cliente cliente = (Cliente)Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
        int prestan = Integer.parseInt(cliente.getPrestanombre());
        this.tlCliente.getEditText().setText((CharSequence)cliente.getNombre_completo());
        this.tlTelefono.getEditText().setText((CharSequence)cliente.getTelefono());
        this.tlDireccion.getEditText().setText((CharSequence)cliente.getDireccion());
        this.rutasAutoCompleteTextView.setText((CharSequence)cliente.getNombre_ruta());
        this.poblacionesAutoCompleteTextView.setText((CharSequence)cliente.getNombre_poblacion());
        this.colocadorasAutoCompleteTextView.setText((CharSequence)cliente.getNombre_colocadora());
        this.tlOtrasReferencias.getEditText().setText((CharSequence)cliente.getOtras_referencias());
        this.tlGarantias.getEditText().setText((CharSequence)cliente.getGarantias());
        this.btnUbicacion = (Button)view.findViewById(2131296457);
        this.btnUbicacionAval = (Button)view.findViewById(2131296458);
        this.cliente_id = cliente.getId();
        this.ruta_id = cliente.getRuta_cliente();
        this.poblacion_id = cliente.getPoblacion_cliente();
        this.colocadora_id = cliente.getColocadora_id();
        this.clientes = new ArrayList();
        bundle = this.getArguments();
        if (bundle != null) {
            this.clientes = (ArrayList)bundle.getSerializable("clientes");
        }
        if (this.clientes == null) {
            this.clientes = new ArrayList();
        }
        if (this.clientes.size() == 0) {
            // empty if block
        }
        this.clientesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.clientes);
        this.clientesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296284);
        if (this.clientesAutoCompleteTextView != null) {
            this.clientesAutoCompleteTextView.setThreshold(1);
            this.clientesAutoCompleteTextView.setAdapter(this.clientesAdapter);
        }
        this.clientesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Cliente cliente = (Cliente)ClientesEditarFragment.this.clientesAdapter.getItem(i);
                int prestan = Integer.parseInt(cliente.getPrestanombre());
                if (prestan > 0) {
                    ClientesEditarFragment.this.showAlert("\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                    ClientesEditarFragment.this.tlCliente.getEditText().setText((CharSequence)"");
                } else {
                    ClientesEditarFragment.this.cliente_id = ClientesEditarFragment.this.cliente_id;
                    ClientesEditarFragment.this.ruta_id = cliente.getRuta_cliente();
                    ClientesEditarFragment.this.poblacion_id = cliente.getPoblacion_cliente();
                    ClientesEditarFragment.this.colocadora_id = cliente.getColocadora_id();
                    ClientesEditarFragment.this.tlTelefono.getEditText().setText((CharSequence)cliente.getTelefono());
                    ClientesEditarFragment.this.tlDireccion.getEditText().setText((CharSequence)cliente.getDireccion());
                    ClientesEditarFragment.this.tlRuta.getEditText().setText((CharSequence)cliente.getNombre_ruta());
                    ClientesEditarFragment.this.tlPoblacion.getEditText().setText((CharSequence)cliente.getNombre_poblacion());
                    ClientesEditarFragment.this.tlColocadora.getEditText().setText((CharSequence)cliente.getNombre_colocadora());
                    ClientesEditarFragment.this.tlOtrasReferencias.getEditText().setText((CharSequence)cliente.getOtras_referencias());
                    ClientesEditarFragment.this.tlGarantias.getEditText().setText((CharSequence)cliente.getGarantias());
                }
            }
        });
        this.clientesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ClientesEditarFragment.this.previousLengthCliente = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ClientesEditarFragment.this.backSpaceCliente = ClientesEditarFragment.this.previousLengthCliente > s.length();
                if (ClientesEditarFragment.this.backSpaceCliente && !ClientesEditarFragment.this.cliente_id.equals("")) {
                    ClientesEditarFragment.this.clientesAutoCompleteTextView.setText((CharSequence)"");
                    ClientesEditarFragment.this.tlTelefono.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.tlDireccion.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    ClientesEditarFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                    ClientesEditarFragment.this.tlOtrasReferencias.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.tlGarantias.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.ruta_id = "";
                    ClientesEditarFragment.this.poblacion_id = "";
                    ClientesEditarFragment.this.colocadora_id = "";
                }
            }
        });
        this.avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ClientesEditarFragment.this.previousLengthAval = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ClientesEditarFragment.this.backSpaceAval = ClientesEditarFragment.this.previousLengthAval > s.length();
                if (ClientesEditarFragment.this.backSpaceAval && !ClientesEditarFragment.this.aval_id.equals("")) {
                    ClientesEditarFragment.this.avalesAutoCompleteTextView.setText((CharSequence)"");
                    ClientesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                    ClientesEditarFragment.this.aval_id = "";
                    ClientesEditarFragment.this.avalMap = null;
                }
            }
        });
        this.btnSubirFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClientesFotosDialogFragment dialogFragment = new ClientesFotosDialogFragment();
                Bundle args = new Bundle();
                String personJsonString = Utils.getGsonParser().toJson((Object)cliente);
                String personJsonString3 = ClientesEditarFragment.this.cliente_id;
                String personJsonString4 = "2";
                args.putString("cliente", personJsonString);
                args.putString("clienteId", personJsonString3);
                args.putString("tipo", personJsonString4);
                ClientesEditarFragment.this.getCurrentLocation("cliente");
                dialogFragment.setArguments(args);
                dialogFragment.show(ClientesEditarFragment.this.getChildFragmentManager(), "ClientesFotosDialog");
            }
        });
        this.btnSubirFotosA.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();
                ClientesEditarFragment.this.getCurrentLocation("aval");
                if (ClientesEditarFragment.this.avalMap == null || ClientesEditarFragment.this.avalMap.isEmpty()) {
                    Toast.makeText((Context)ClientesEditarFragment.this.getContext(), (CharSequence)"No hay datos del aval para enviar.", (int)0).show();
                    ClientesEditarFragment.this.aval_id = "";
                    dialogFragment.show(ClientesEditarFragment.this.getChildFragmentManager(), "AvalesFotosDialog");
                } else {
                    Bundle args = new Bundle();
                    String personJsonString = Utils.getGsonParser().toJson((Object)ClientesEditarFragment.this.avalMap);
                    String personJsonString3 = ClientesEditarFragment.this.aval_id;
                    String personJsonString4 = "2";
                    args.putString("aval", personJsonString);
                    args.putString("avalId", personJsonString3);
                    args.putString("tipo", personJsonString4);
                    dialogFragment.setArguments(args);
                    dialogFragment.show(ClientesEditarFragment.this.getChildFragmentManager(), "AvalesFotosDialog");
                }
            }
        });
        this.btnEditarCliente.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Validator.fieldValidation(ClientesEditarFragment.this.tlCliente, "Ingresa un nombre de cliente") && Validator.fieldValidation(ClientesEditarFragment.this.tlTelefono, "Ingresa un tel\u00e9fono") && Validator.fieldValidation(ClientesEditarFragment.this.tlDireccion, "Ingresa una direcci\u00f3n") && Validator.fieldValidation(ClientesEditarFragment.this.tlRuta, "Ingresa una ruta") && Validator.fieldValidation(ClientesEditarFragment.this.tlPoblacion, "Ingresa una poblaci\u00f3n") && Validator.fieldValidation(ClientesEditarFragment.this.tlColocadora, "Ingresa una colocadora") && Validator.fieldValidation(ClientesEditarFragment.this.tlOtrasReferencias, "Ingresa otras referencias") && Validator.fieldValidation(ClientesEditarFragment.this.tlGarantias, "Ingresa las garant\u00edas") && Validator.fieldValidation(ClientesEditarFragment.this.tlDireccionAval, "Ingresa una direcci\u00f3n al aval") && Validator.fieldValidation(ClientesEditarFragment.this.tlTelefonoAval, "Ingresa un tel\u00e9fono al aval") && Validator.fieldValidation(ClientesEditarFragment.this.tlOtrasReferenciasAval, "Ingresa otras referencias al aval") && Validator.fieldValidation(ClientesEditarFragment.this.tlGarantiasAval, "Ingresa las garant\u00edas del aval")) {
                    ArrayList<String> pathsComprobantesAval2 = new ArrayList<String>();
                    ArrayList<String> pathsGarantiasAval2 = new ArrayList<String>();
                    ArrayList<String> pathsIneAval2 = new ArrayList<String>();
                    ArrayList<String> pathsFotoAval2 = new ArrayList<String>();
                    ArrayList<String> pathsFachadaAval2 = new ArrayList<String>();
                    ArrayList<MultipartBody.Part> archivosGeneral2 = new ArrayList<MultipartBody.Part>();
                    ClientesEditarFragment.this.onPhotosSelected(pathsComprobantesAval2, pathsGarantiasAval2, pathsIneAval2, pathsFotoAval2, pathsFachadaAval2, archivosGeneral2);
                }
                if (!ClientesEditarFragment.this.tlAval.getEditText().getText().toString().isEmpty() || ClientesEditarFragment.this.tlAval.getEditText().getText() != null) {
                    AvalController ac = new AvalController(ClientesEditarFragment.this.getContext());
                    String avalId = ac.getAvalByNombre(ClientesEditarFragment.this.tlAval.getEditText().getText().toString().toUpperCase());
                    if (!avalId.isEmpty() || avalId != null) {
                        ClienteController cc = new ClienteController(ClientesEditarFragment.this.getContext());
                        String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(ClientesEditarFragment.this.tlAval.getEditText().getText().toString().toUpperCase());
                        if (Objects.equals(prestaNombre, "1")) {
                            AlertDialog.Builder b = new AlertDialog.Builder(ClientesEditarFragment.this.getContext());
                            b.setTitle((CharSequence)"Aviso");
                            b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                            b.setPositiveButton((CharSequence)"Aceptar", null);
                            AlertDialog dialog = b.create();
                            dialog.show();
                        } else {
                            ClientesEditarFragment.this.editarCliente();
                        }
                    } else {
                        ClientesEditarFragment.this.editarCliente();
                    }
                } else {
                    ClientesEditarFragment.this.editarCliente();
                }
            }
        });
        this.btnUbicacion.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClientesEditarFragment.this.getCurrentLocation("cliente");
                ClientesEditarFragment.this.btnUbicacion.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                Toast.makeText((Context)ClientesEditarFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
            }
        });
        this.btnUbicacionAval.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ClientesEditarFragment.this.getCurrentLocation("aval");
                ClientesEditarFragment.this.btnUbicacionAval.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                Toast.makeText((Context)ClientesEditarFragment.this.getActivity(), (CharSequence)"Ubicaci\u00f3n obtenida", (int)0).show();
            }
        });
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)ClientesEditarFragment.this.rutasAdapter.getItem(i);
                ClientesEditarFragment.this.ruta_id = ruta.getId();
                if (ClientesEditarFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    ClientesEditarFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (ClientesEditarFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List poblacionesFiltro = ClientesEditarFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ClientesEditarFragment.this.ruta_id)).collect(Collectors.toList());
                ClientesEditarFragment.this.poblacionesAdapter = new ArrayAdapter(ClientesEditarFragment.this.getContext(), 17367050, poblacionesFiltro);
                ClientesEditarFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                ClientesEditarFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ClientesEditarFragment.this.poblacionesAdapter);
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones();
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)ClientesEditarFragment.this.poblacionesAdapter.getItem(i);
                ClientesEditarFragment.this.poblacion_id = poblacion.getId();
                if (ClientesEditarFragment.this.colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setText((CharSequence)"");
                }
                List colocadorasFiltro = ClientesEditarFragment.this.colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(ClientesEditarFragment.this.poblacion_id)).collect(Collectors.toList());
                ClientesEditarFragment.this.colocadorasAdapter = new ArrayAdapter(ClientesEditarFragment.this.getContext(), 17367050, colocadorasFiltro);
                ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)ClientesEditarFragment.this.colocadorasAdapter);
            }
        });
        if (this.colocadoras.size() == 0) {
            this.getColocadoras();
        }
        this.colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Colocadora colocadora = (Colocadora)ClientesEditarFragment.this.colocadorasAdapter.getItem(i);
                ClientesEditarFragment.this.colocadora_id = colocadora.getId();
            }
        });
        this.setRutaAutoComplete(cliente.getRuta_cliente());
        this.setPoblacionAutoComplete(cliente.getPoblacion_cliente());
        this.setColocadoraAutoComplete(cliente.getColocadora_id());
        new GetAvalTask().execute(new String[]{this.cliente_id});
        SQLiteDatabase db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
        this.llenarAutoComplete(db);
    }

    private void setRutaAutoComplete(String rutaId) {
        for (Ruta ruta : this.rutas) {
            if (!ruta.getId().equals(rutaId)) continue;
            this.rutasAutoCompleteTextView.setText((CharSequence)ruta.getNombre_ruta(), false);
            break;
        }
    }

    private void setPoblacionAutoComplete(String poblacionId) {
        for (Poblacion poblacion : this.poblaciones) {
            if (!poblacion.getId().equals(poblacionId)) continue;
            this.poblacionesAutoCompleteTextView.setText((CharSequence)poblacion.getNombre_poblacion(), false);
            break;
        }
    }

    private void setColocadoraAutoComplete(String colocadoraId) {
        for (Colocadora colocadora : this.colocadoras) {
            if (!colocadora.getId().equals(colocadoraId)) continue;
            this.colocadorasAutoCompleteTextView.setText((CharSequence)colocadora.getNombre_completo(), false);
            break;
        }
    }

    private void initElements(View view) {
        CurrentFragment.fragment = "ClientesEditarFragment";
        this.clientesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296284);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296289);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296286);
        this.colocadorasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296276);
        this.avalesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296283);
        this.btnEditarCliente = (Button)view.findViewById(2131296420);
        this.btnSubirFotos = (Button)view.findViewById(2131296451);
        this.tlCliente = (TextInputLayout)view.findViewById(2131297204);
        this.tlTelefono = (TextInputLayout)view.findViewById(2131297237);
        this.tlDireccion = (TextInputLayout)view.findViewById(2131297174);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297229);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297218);
        this.tlColocadora = (TextInputLayout)view.findViewById(2131297162);
        this.tlOtrasReferencias = (TextInputLayout)view.findViewById(2131297211);
        this.tlGarantias = (TextInputLayout)view.findViewById(2131297186);
        this.btnSubirFotosA = (Button)view.findViewById(2131296452);
        this.tlAval = (TextInputLayout)view.findViewById(2131297202);
        this.tlDireccionAval = (TextInputLayout)view.findViewById(2131297173);
        this.tlTelefonoAval = (TextInputLayout)view.findViewById(2131297236);
        this.tlOtrasReferenciasAval = (TextInputLayout)view.findViewById(2131297210);
        this.tlGarantiasAval = (TextInputLayout)view.findViewById(2131297185);
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.colocadoraController = new ColocadoraController((Context)this.getActivity());
        this.pathsGarantiasCliente = new ArrayList();
        this.pathsComprobantesCliente = new ArrayList();
        this.pathsGarantiasAval = new ArrayList();
        this.pathsComprobantesAval = new ArrayList();
        this.archivosGeneral = new ArrayList<MultipartBody.Part>();
        this.archivosGeneralAval = new ArrayList<MultipartBody.Part>();
    }

    @SuppressLint(value={"MissingPermission"})
    private void getCurrentLocation(final String rol) {
        LocationManager locationManager = (LocationManager)this.getActivity().getSystemService("location");
        if (locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network")) {
            this.client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    Location location = (Location)task.getResult();
                    if (location != null) {
                        if (rol.equals("cliente")) {
                            ClientesEditarFragment.this.lat = String.valueOf(location.getLatitude());
                            ClientesEditarFragment.this.lgt = String.valueOf(location.getLongitude());
                            ClientesEditarFragment.this.btnUbicacion.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                        } else if (rol.equals("aval")) {
                            ClientesEditarFragment.this.latAval = String.valueOf(location.getLatitude());
                            ClientesEditarFragment.this.lgtAval = String.valueOf(location.getLongitude());
                            ClientesEditarFragment.this.btnUbicacionAval.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                        }
                    } else {
                        LocationRequest locationRequest = new LocationRequest().setPriority(100).setInterval(10000L).setFastestInterval(1000L).setNumUpdates(1);
                        LocationCallback locationCallback = new LocationCallback(){

                            public void onLocationResult(LocationResult locationResult) {
                                Location location1 = locationResult.getLastLocation();
                                if (Objects.equals(rol, "cliente")) {
                                    ClientesEditarFragment.this.lat = String.valueOf(location1.getLatitude());
                                    ClientesEditarFragment.this.lgt = String.valueOf(location1.getLongitude());
                                    ClientesEditarFragment.this.btnUbicacion.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                                } else if (Objects.equals(rol, "aval")) {
                                    ClientesEditarFragment.this.latAval = String.valueOf(location1.getLatitude());
                                    ClientesEditarFragment.this.lgtAval = String.valueOf(location1.getLongitude());
                                    ClientesEditarFragment.this.btnUbicacionAval.setText((CharSequence)"Ubicaci\u00f3n obtenida");
                                }
                            }
                        };
                        ClientesEditarFragment.this.client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                    }
                }
            });
        } else {
            this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS").setFlags(0x10000000));
        }
    }

    private void getRutas() {
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        ClientesEditarFragment.this.rutas.clear();
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            ClientesEditarFragment.this.rutas.add(ruta);
                            ClientesEditarFragment.this.rutaController.nueva(ruta);
                        }
                        ClientesEditarFragment.this.rutasAdapter = new ArrayAdapter(ClientesEditarFragment.this.getContext(), 17367050, (List)ClientesEditarFragment.this.rutas);
                        ClientesEditarFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        ClientesEditarFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)ClientesEditarFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ClientesEditarFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.rutas = this.rutaController.obtener();
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getPoblaciones() {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            ClientesEditarFragment.this.poblaciones.add(poblacion);
                            ClientesEditarFragment.this.poblacionController.nueva(poblacion);
                        }
                        ClientesEditarFragment.this.poblacionesAdapter = new ArrayAdapter(ClientesEditarFragment.this.getContext(), 17367050, (List)ClientesEditarFragment.this.poblaciones);
                        ClientesEditarFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        ClientesEditarFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ClientesEditarFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ClientesEditarFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getColocadoras() {
        if (this.colocadoraController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlColocadoras, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Colocadora colocadora = (Colocadora)gson.fromJson(obj.toString(), Colocadora.class);
                            ClientesEditarFragment.this.colocadoras.add(colocadora);
                        }
                        ClientesEditarFragment.this.colocadorasAdapter = new ArrayAdapter(ClientesEditarFragment.this.getContext(), 17367050, (List)ClientesEditarFragment.this.colocadoras);
                        ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setThreshold(1);
                        ClientesEditarFragment.this.colocadorasAutoCompleteTextView.setAdapter((ListAdapter)ClientesEditarFragment.this.colocadorasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ClientesEditarFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.colocadoras = this.colocadoraController.obtener();
            this.colocadorasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.colocadoras);
            this.colocadorasAutoCompleteTextView.setThreshold(1);
            this.colocadorasAutoCompleteTextView.setAdapter(this.colocadorasAdapter);
        }
    }

    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        String queryAvales;
        Cursor cursorAvales;
        ArrayList clientes = new ArrayList();
        ArrayList avales = new ArrayList();
        ArrayList<Map<String, String>> resultado = new ArrayList<Map<String, String>>();
        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo FROM clientes WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }
        if ((cursorAvales = db.rawQuery(queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo FROM avales WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''", null)) != null) {
            while (cursorAvales.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }
        HashSet<String> nombresUnicos = new HashSet<String>();
        HashSet<String> nombresAvales = new HashSet<String>();
        for (Map map : avales) {
            nombresAvales.add((String)map.get("nombre_completo"));
        }
        for (Map map : clientes) {
            String nombreCliente = (String)map.get("nombre_completo");
            if (nombresAvales.contains(nombreCliente) || nombresUnicos.contains(nombreCliente)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreCliente);
        }
        for (Map map : avales) {
            String nombreAval = (String)map.get("nombre_completo");
            if (nombresUnicos.contains(nombreAval)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreAval);
        }
        return resultado;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarAutoComplete(final SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>(){

            protected List<Map<String, String>> doInBackground(Void ... voids) {
                return ClientesEditarFragment.this.getClientesYDisponibles(db);
            }

            protected void onPostExecute(List<Map<String, String>> datos) {
                ArrayList<String> nombres = new ArrayList<String>();
                HashMap<String, Map<String, String>> idMap = new HashMap<String, Map<String, String>>();
                Log.d((String)"DEBUG", (String)("Datos obtenidos para llenar el AutoComplete: " + datos));
                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre == null || nombre.trim().isEmpty()) continue;
                    nombres.add(nombre);
                    idMap.put(nombre, registro);
                }
                ArrayAdapter adapter = new ArrayAdapter(ClientesEditarFragment.this.requireContext(), 17367050, nombres);
                ClientesEditarFragment.this.avalesAutoCompleteTextView.setAdapter((ListAdapter)adapter);
                ClientesEditarFragment.this.avalesAutoCompleteTextView.setOnItemClickListener((parent, view, position, id2) -> {
                    if (!ClientesEditarFragment.this.tlAval.getEditText().getText().toString().isEmpty() || ClientesEditarFragment.this.tlAval.getEditText().getText() != null) {
                        AvalController ac = new AvalController(ClientesEditarFragment.this.getContext());
                        String avalId = ac.getAvalByNombre(ClientesEditarFragment.this.tlAval.getEditText().getText().toString().toUpperCase());
                        if (!avalId.isEmpty() || avalId != null) {
                            ClienteController cc = new ClienteController(ClientesEditarFragment.this.getContext());
                            String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(ClientesEditarFragment.this.tlAval.getEditText().getText().toString().toUpperCase());
                            if (Objects.equals(prestaNombre, "1")) {
                                AlertDialog.Builder b = new AlertDialog.Builder(ClientesEditarFragment.this.getContext());
                                b.setTitle((CharSequence)"Aviso");
                                b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                b.setPositiveButton((CharSequence)"Aceptar", null);
                                ClientesEditarFragment.this.tlAval.getEditText().setText((CharSequence)"");
                                AlertDialog dialog = b.create();
                                dialog.show();
                            } else {
                                String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                                Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                                if (seleccionado != null) {
                                    String idSeleccionado = (String)seleccionado.get("id");
                                    String tipoSeleccionado = (String)seleccionado.get("tipo");
                                    if ("aval".equals(tipoSeleccionado)) {
                                        ClientesEditarFragment.this.verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                    } else {
                                        ClientesEditarFragment.this.aval_id = "";
                                        ClientesEditarFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                    }
                                }
                            }
                        } else {
                            String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                            Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                            if (seleccionado != null) {
                                String idSeleccionado = (String)seleccionado.get("id");
                                String tipoSeleccionado = (String)seleccionado.get("tipo");
                                if ("aval".equals(tipoSeleccionado)) {
                                    ClientesEditarFragment.this.verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                                } else {
                                    ClientesEditarFragment.this.aval_id = "";
                                    ClientesEditarFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                                }
                            }
                        }
                    } else {
                        String nombreSeleccionado = (String)parent.getItemAtPosition(position);
                        Map seleccionado = (Map)idMap.get(nombreSeleccionado);
                        if (seleccionado != null) {
                            String idSeleccionado = (String)seleccionado.get("id");
                            String tipoSeleccionado = (String)seleccionado.get("tipo");
                            if ("aval".equals(tipoSeleccionado)) {
                                ClientesEditarFragment.this.verificarAvalAsync(db, idSeleccionado, tipoSeleccionado);
                            } else {
                                ClientesEditarFragment.this.aval_id = "";
                                ClientesEditarFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                            }
                        }
                    }
                });
            }
        }.execute((Object[])new Void[0]);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void verificarAvalAsync(final SQLiteDatabase db, final String idSeleccionado, final String tipoSeleccionado) {
        new AsyncTask<Void, Void, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doInBackground(Void ... voids) {
                String nombreCliente = null;
                try (Cursor cursor = null;){
                    String query = "SELECT clientes.nombre_completo FROM clientes INNER JOIN prestamos on clientes.id = prestamos.cliente_id WHERE prestamos.aval_id = ? AND prestamos.status='0'";
                    cursor = db.rawQuery(query, new String[]{idSeleccionado});
                    if (cursor != null && cursor.moveToFirst()) {
                        nombreCliente = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                    }
                }
                return nombreCliente;
            }

            protected void onPostExecute(String nombreCliente) {
                if (nombreCliente != null) {
                    new AlertDialog.Builder(ClientesEditarFragment.this.getContext()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)("Este aval ya est\u00e1 ligado al cliente: " + nombreCliente + ". \u00bfDesea continuar?")).setCancelable(false).setPositiveButton((CharSequence)"S\u00ed", (dialog, which) -> {
                        ClientesEditarFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                        ClientesEditarFragment.this.aval_id = idSeleccionado;
                    }).setNegativeButton((CharSequence)"No", (dialog, which) -> dialog.dismiss()).show();
                } else {
                    ClientesEditarFragment.this.llenarCamposAsync(db, idSeleccionado, tipoSeleccionado);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarCamposAsync(final SQLiteDatabase db, final String id2, final String tipo) {
        new AsyncTask<Void, Void, Map<String, String>>(){

            protected Map<String, String> doInBackground(Void ... voids) {
                HashMap<String, String> resultado = new HashMap<String, String>();
                String tabla = tipo.equals("cliente") ? "clientes" : "avales";
                String query = "SELECT id, direccion, telefono, garantias, otras_referencias, nombre_completo, carpeta_comprobantes, carpeta_garantias FROM " + tabla + " WHERE id = ?";
                Log.d((String)"DEBUG", (String)("Ejecutando query asincr\u00f3nica para llenar campos: " + query));
                Cursor cursor = db.rawQuery(query, new String[]{id2});
                if (cursor != null && cursor.moveToFirst()) {
                    resultado.put("id", cursor.getString(0));
                    resultado.put("direccion", cursor.getString(1));
                    resultado.put("telefono", cursor.getString(2));
                    resultado.put("garantias", cursor.getString(3));
                    resultado.put("otras_referencias", cursor.getString(4));
                    resultado.put("nombre_completo", cursor.getString(5));
                    resultado.put("carpeta_comprobantes", cursor.getString(6));
                    resultado.put("carpeta_garantias", cursor.getString(7));
                    ClientesEditarFragment.this.aval_id = id2;
                    cursor.close();
                }
                return resultado;
            }

            protected void onPostExecute(Map<String, String> resultado) {
                if (resultado != null && !resultado.isEmpty()) {
                    if (tipo.equals("cliente")) {
                        ClientesEditarFragment.this.aval_id = "";
                        ClientesEditarFragment.this.avalMap = null;
                        Log.d((String)"DEBUG", (String)("Ejecutando query para llenar campos SIN AVAL: " + ClientesEditarFragment.this.aval_id));
                    }
                    ClientesEditarFragment.this.avalMap = (HashMap)resultado;
                    ClientesEditarFragment.this.selectedAval = id2;
                    ClientesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)resultado.get("direccion"));
                    ClientesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)resultado.get("telefono"));
                    ClientesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)resultado.get("garantias"));
                    ClientesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)resultado.get("otras_referencias"));
                    Log.d((String)"DEBUG", (String)("Contenido de avalMap: " + ClientesEditarFragment.this.avalMap + " tipo: " + tipo));
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private void editarCliente() {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
        final String nombre = this.tlCliente.getEditText().getText().toString().trim();
        final String nombreFormateado = nombre.replace("\u00f1", "n").replace("\u00d1", "N").toUpperCase();
        final String direccion = this.tlDireccion.getEditText().getText().toString();
        final String telefono = this.tlTelefono.getEditText().getText().toString();
        final String orCliente = this.tlOtrasReferencias.getEditText().getText().toString();
        final String garantias = this.tlGarantias.getEditText().getText().toString();
        final String nombreAv = this.tlAval.getEditText().getText().toString().trim();
        final String nombreAvFormateado = nombreAv.replace("\u00f1", "n").replace("\u00d1", "N").toUpperCase();
        final String direccionAv = this.tlDireccionAval.getEditText().getText().toString();
        final String telefonoAv = this.tlTelefonoAval.getEditText().getText().toString();
        final String orAv = this.tlOtrasReferenciasAval.getEditText().getText().toString();
        final String garantiasAv = this.tlGarantiasAval.getEditText().getText().toString();
        RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"editAPP");
        RequestBody clienteId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.cliente_id);
        RequestBody nombre_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreFormateado);
        RequestBody direccion_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlDireccion.getEditText().getText().toString());
        RequestBody telefono_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlTelefono.getEditText().getText().toString());
        RequestBody or_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlOtrasReferencias.getEditText().getText().toString());
        RequestBody colocadoraId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.colocadora_id);
        RequestBody rutaId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.ruta_id);
        RequestBody poblacionId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.poblacion_id);
        RequestBody garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlGarantias.getEditText().getText().toString());
        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasCliente.size() + ""));
        RequestBody cantidad_archivos_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesCliente.size() + ""));
        RequestBody latitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lat);
        RequestBody longitud = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lgt);
        RequestBody latitudAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.latAval);
        RequestBody longitudAval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.lgtAval);
        RequestBody avalId = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.aval_id);
        RequestBody nombre_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)nombreAvFormateado);
        RequestBody direccion_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlDireccionAval.getEditText().getText().toString());
        RequestBody telefono_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlTelefonoAval.getEditText().getText().toString());
        RequestBody or_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlOtrasReferenciasAval.getEditText().getText().toString());
        RequestBody garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.tlGarantiasAval.getEditText().getText().toString());
        RequestBody ruta_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.ruta_id);
        RequestBody poblacion_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.poblacion_id);
        RequestBody colocadora_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.colocadora_id);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsGarantiasAval.size() + ""));
        RequestBody cantidad_archivos_aval = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(this.pathsComprobantesAval.size() + ""));
        Log.d((String)"ARCHIVOS", (String)("archivosGeneral....................." + this.archivosGeneral.toString()));
        Log.d((String)"ARCHIVOS", (String)("rutaId_CLIENTE....................." + this.ruta_id));
        Log.d((String)"ARCHIVOS", (String)("rutaId_aval....................." + this.ruta_id));
        Log.d((String)"ARCHIVOS", (String)("poblacionId_aval................." + this.poblacion_id));
        Log.d((String)"ARCHIVOS", (String)("colocadoraId_aval..............." + this.colocadora_id));
        Call<ResponseMe> call = retrofitInterface.editarCliente(this.archivosGeneral, func, clienteId, nombre_cliente, direccion_cliente, telefono_cliente, or_cliente, garantias_cliente, rutaId, poblacionId, colocadoraId, avalId, nombre_aval, direccion_aval, telefono_aval, or_aval, garantias_aval, latitud, longitud, ruta_aval, poblacion_aval, colocadora_aval, latitudAval, longitudAval);
        call.enqueue((Callback)new Callback<ResponseMe>(){

            public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                dialog.cancel();
                if (response.isSuccessful()) {
                    Log.d((String)"response", (String)((ResponseMe)response.body()).getMessage());
                    String updatedAt = ((ResponseMe)response.body()).getData().getUpdated_at();
                    Log.d((String)"Updated At", (String)("Updated At Cliente y Aval...................." + updatedAt));
                    String idAval = ((ResponseMe)response.body()).getData().getAvalID();
                    Log.d((String)"Updated At", (String)("ANTES idAval DEVUELTO POR EL SERVIDOR..................." + idAval));
                    Log.d((String)"Updated At", (String)("ANTES aval_id At Cliente y Aval ID AVAL: aval_id...................." + ClientesEditarFragment.this.aval_id));
                    LayoutInflater inflater = ClientesEditarFragment.this.getLayoutInflater();
                    View dialogView = inflater.inflate(2131492944, null);
                    TextView messageText = (TextView)dialogView.findViewById(2131296802);
                    messageText.setText((CharSequence)"Se editaron los datos correctamente.");
                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder((Context)ClientesEditarFragment.this.getActivity());
                    builder.setView(dialogView);
                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();
                    ClientesEditarFragment.this.actualizarAvalEnSQLite(nombreAvFormateado, direccionAv, telefonoAv, orAv, garantiasAv, ClientesEditarFragment.this.ruta_id, ClientesEditarFragment.this.poblacion_id, ClientesEditarFragment.this.colocadora_id, updatedAt, "on", idAval);
                    ClientesEditarFragment.this.actualizarClienteEnSQLite(ClientesEditarFragment.this.cliente_id, nombreFormateado, direccion, telefono, orCliente, garantias, ClientesEditarFragment.this.ruta_id, ClientesEditarFragment.this.poblacion_id, ClientesEditarFragment.this.colocadora_id, updatedAt, "on", idAval);
                    dialog.cancel();
                    ClientesEditarFragment.this.lat = "";
                    ClientesEditarFragment.this.lgt = "";
                    ClientesEditarFragment.this.btnUbicacion.setText((CharSequence)"OBTENER UBICACI\u00d3N");
                    new Handler().postDelayed(() -> {
                        confirmationDialog.dismiss();
                        NavOptions navOptions = new NavOptions.Builder().setPopUpTo(2131296849, true).build();
                        Navigation.findNavController((Activity)ClientesEditarFragment.this.getActivity(), (int)2131296862).navigate(2131296849, null, navOptions);
                    }, 3000L);
                } else {
                    try {
                        JSONObject jObjError = new JSONObject(response.errorBody().string());
                        new MaterialAlertDialogBuilder((Context)ClientesEditarFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)jObjError.getString("message")).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)ClientesEditarFragment.this.getContext(), (CharSequence)e.getMessage(), (int)1).show();
                    }
                }
            }

            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                ClientesEditarFragment.this.actualizarAvalEnSQLite(nombreAv, direccionAv, telefonoAv, orAv, garantiasAv, ClientesEditarFragment.this.ruta_id, ClientesEditarFragment.this.poblacion_id, ClientesEditarFragment.this.colocadora_id, "", "off", "");
                ClientesEditarFragment.this.actualizarClienteEnSQLite(ClientesEditarFragment.this.cliente_id, nombre, direccion, telefono, orCliente, garantias, ClientesEditarFragment.this.ruta_id, ClientesEditarFragment.this.poblacion_id, ClientesEditarFragment.this.colocadora_id, "", "off", "");
                LayoutInflater inflater = ClientesEditarFragment.this.getLayoutInflater();
                View dialogView = inflater.inflate(2131492944, null);
                TextView messageText = (TextView)dialogView.findViewById(2131296802);
                messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder((Context)ClientesEditarFragment.this.getActivity());
                builder.setView(dialogView);
                AlertDialog confirmationDialog = builder.create();
                confirmationDialog.show();
                new Handler().postDelayed(() -> {
                    confirmationDialog.dismiss();
                    NavOptions navOptions = new NavOptions.Builder().setPopUpTo(2131296849, true).build();
                    Navigation.findNavController((Activity)ClientesEditarFragment.this.getActivity(), (int)2131296862).navigate(2131296849, null, navOptions);
                }, 3000L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualizarClienteEnSQLite(String clienteId, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String ruta_id2, String poblacion_id2, String colocadora_id2, String updatedAt, String on, String idAval) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        ContentValues valores = new ContentValues();
        valores.put("nombre_completo", nombre);
        valores.put("direccion", direccion);
        valores.put("telefono", telefono);
        valores.put("garantias", garantias);
        valores.put("otras_referencias", otrasReferencias);
        valores.put("ruta_id", ruta_id2);
        valores.put("poblacion_id", poblacion_id2);
        valores.put("colocadora_id", colocadora_id2);
        long timestamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(new Date(timestamp));
        if (!updatedAt.isEmpty()) {
            valores.put("updated_at", updatedAt);
        } else {
            valores.put("updated_at", formattedDate);
        }
        if (idAval != null && !idAval.isEmpty()) {
            valores.put("aval_id", idAval);
        } else {
            valores.put("aval_id", this.aval_id);
        }
        int filasActualizadas = db.update("clientes", valores, "id = ?", new String[]{clienteId});
        if (filasActualizadas > 0) {
            Log.d((String)"SQLite", (String)("Cliente actualizado en SQLite Con ID AVAL: " + this.aval_id + " y fecha updated_at: " + formattedDate));
        } else {
            Log.d((String)"SQLite", (String)"No se pudo actualizar el Cliente en SQLite");
        }
        try {
            String queryPrestamo = "SELECT id FROM prestamos WHERE cliente_id = ? ORDER BY id DESC LIMIT 1";
            Cursor cursor = db.rawQuery(queryPrestamo, new String[]{clienteId});
            if (cursor != null && cursor.moveToFirst()) {
                String prestamoId = cursor.getString(0);
                ContentValues valoresPrestamo = new ContentValues();
                valoresPrestamo.put("aval_id", this.aval_id);
                int filasPrestamoActualizadas = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{prestamoId});
                if (filasPrestamoActualizadas > 0) {
                    Log.d((String)"SQLite", (String)("Pr\u00e9stamo actualizado con nuevo aval_id: " + this.aval_id));
                } else {
                    Log.d((String)"SQLite", (String)"No se pudo actualizar el aval_id del pr\u00e9stamo m\u00e1s reciente.");
                }
                cursor.close();
            } else {
                Log.d((String)"SQLite", (String)("No se encontr\u00f3 un pr\u00e9stamo reciente para el cliente con ID: " + clienteId));
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLite", (String)("Error al actualizar el aval_id del pr\u00e9stamo: " + e.getMessage()));
        }
        finally {
            db.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void actualizarAvalEnSQLite(String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String ruta_id2, String poblacion_id2, String colocadora_id2, String updatedAt, String online, String idAval) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Log.d((String)"SQLite", (String)("AVAL SELECCIONADO......................... ID: " + this.aval_id));
        if (this.aval_id == null || this.aval_id.isEmpty()) {
            if (online.equals("off")) {
                SolicitudSubida solicitud = new SolicitudSubida(this.archivosGeneral, nombre, direccion, telefono, otrasReferencias, garantias, ruta_id2, poblacion_id2, colocadora_id2, "0", "0", "InsertAval", this.cliente_id, "");
                this.colaSolicitudes.agregarSolicitud(solicitud);
            }
            if (idAval != null && !idAval.isEmpty()) {
                Log.d((String)"Updated At", (String)"ENTRO EN IF idAval NO ES NULO...............................................");
                this.aval_id = idAval;
            } else {
                this.aval_id = String.valueOf(this.obtenerSiguienteIdAval(db));
            }
            Log.d((String)"SQLite", (String)("AVAL DESPU\u00c9S DE obtenerSiguienteIdAval......................... ID: " + this.aval_id));
            ContentValues valoresAval = new ContentValues();
            valoresAval.put("id", this.aval_id);
            valoresAval.put("nombre_completo", nombre != null ? nombre : "Nombre por Definir");
            valoresAval.put("direccion", direccion != null ? direccion : "Direcci\u00f3n por Definir");
            valoresAval.put("telefono", telefono != null ? telefono : "Tel\u00e9fono por Definir");
            valoresAval.put("garantias", garantias != null ? garantias : "Garant\u00edas por Definir");
            valoresAval.put("otras_referencias", otrasReferencias != null ? otrasReferencias : "Referencias por Definir");
            valoresAval.put("ruta_id", ruta_id2 != null ? ruta_id2 : "1");
            valoresAval.put("poblacion_id", poblacion_id2 != null ? poblacion_id2 : "1");
            valoresAval.put("colocadora_id", colocadora_id2 != null ? colocadora_id2 : "1");
            long nuevoAvalId = db.insertWithOnConflict("avales", null, valoresAval, 5);
            if (nuevoAvalId == -1L) {
                Log.e((String)"SQLite", (String)"Error al insertar el nuevo aval.........................");
                db.close();
                return;
            }
            Log.d((String)"SQLite", (String)("Nuevo aval insertado con........................... ID: " + this.aval_id));
        } else {
            Log.d((String)"SQLite", (String)("Nuevo aval ID: " + this.aval_id + ". No se realizar\u00e1 una nueva inserci\u00f3n."));
            long timestamp = System.currentTimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
            String formattedDate = sdf.format(new Date(timestamp));
            ContentValues valores = new ContentValues();
            valores.put("nombre_completo", nombre);
            valores.put("direccion", direccion);
            valores.put("telefono", telefono);
            valores.put("otras_referencias", otrasReferencias);
            valores.put("garantias", garantias);
            valores.put("ruta_id", ruta_id2);
            valores.put("poblacion_id", poblacion_id2);
            valores.put("colocadora_id", colocadora_id2);
            valores.put("updated_at", formattedDate);
            int filasAfectadas = db.update("avales", valores, "id = ?", new String[]{this.aval_id});
            if (filasAfectadas > 0) {
                Log.d((String)"SQLite", (String)("AVAL actualizado en SQLite con ID: " + this.aval_id));
            } else {
                Log.d((String)"SQLite", (String)("No se encontr\u00f3 el AVAL con ID: " + this.aval_id + ". No se actualiz\u00f3."));
            }
        }
        db.close();
    }

    private int obtenerSiguienteIdAval(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM avales", null);
        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();
        return ultimoId + 1;
    }

    public byte[] getFileDataFromDrawable(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream byteBuff = new ByteArrayOutputStream();
        int buffSize = 1024;
        byte[] buff = new byte[buffSize];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            byteBuff.write(buff, 0, len);
        }
        return byteBuff.toByteArray();
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int height;
        int width = bitmap.getWidth();
        float bitmapRatio = (float)width / (float)(height = bitmap.getHeight());
        if (bitmapRatio > 1.0f) {
            width = maxSize;
            height = (int)((float)width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int)((float)height * bitmapRatio);
        }
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        this.addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }

    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
        fos.flush();
        fos.close();
        return file;
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = this.getCurrentDateTime();
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(bitmap.getHeight() - 40), (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(18.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = bitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (ClientesEditarViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ClientesEditarViewModel.class);
    }

    private class GetAvalTask
    extends AsyncTask<String, Void, HashMap<String, String>> {
        private ProgressDialog progressDialog;

        private GetAvalTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = new ProgressDialog(ClientesEditarFragment.this.requireContext());
            this.progressDialog.setMessage((CharSequence)"Cargando datos...");
            this.progressDialog.setCancelable(false);
            this.progressDialog.show();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HashMap<String, String> doInBackground(String ... params) {
            String cliente_id = params[0];
            HashMap<String, String> avalData = new HashMap<String, String>();
            DatabaseHelper dbHelper = new DatabaseHelper(ClientesEditarFragment.this.requireContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Cursor cursor = null;
            try {
                String query = "SELECT avales.* FROM avales INNER JOIN clientes ON avales.id = clientes.aval_id WHERE clientes.id = ? ORDER BY avales.id DESC LIMIT 1";
                cursor = db.rawQuery(query, new String[]{cliente_id});
                if (cursor != null && cursor.moveToFirst()) {
                    String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                    avalData.put("id", cursor.getString(cursor.getColumnIndexOrThrow("id")));
                    avalData.put("nombre_completo", cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")));
                    avalData.put("direccion", cursor.getString(cursor.getColumnIndexOrThrow("direccion")));
                    avalData.put("telefono", cursor.getString(cursor.getColumnIndexOrThrow("telefono")));
                    avalData.put("otras_referencias", cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")));
                    avalData.put("garantias", cursor.getString(cursor.getColumnIndexOrThrow("garantias")));
                    avalData.put("ruta_id", cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    avalData.put("poblacion_id", cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    avalData.put("colocadora_id", cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")));
                    avalData.put("carpeta_comprobantes", cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")));
                    avalData.put("carpeta_garantias", cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")));
                } else {
                    String query2 = "SELECT clientes.* FROM clientes WHERE clientes.id = ? ORDER BY clientes.id DESC LIMIT 1";
                    cursor = db.rawQuery(query2, new String[]{cliente_id});
                    if (cursor != null && cursor.moveToFirst()) {
                        String id3 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                        String nombre_completo = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("aval_id"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)"GetAvalTask", (String)("Error al consultar los datos del aval: " + e.getMessage()));
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
            return avalData;
        }

        protected void onPostExecute(HashMap<String, String> result) {
            super.onPostExecute(result);
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            if (result != null && !result.isEmpty()) {
                String id2 = result.get("id");
                String nombreCompleto = result.get("nombre_completo");
                String direccion = result.get("direccion");
                String telefono = result.get("telefono");
                String otrasReferencias = result.get("otras_referencias");
                String garantias = result.get("garantias");
                String rutaId = result.get("ruta_id");
                String poblacionId = result.get("poblacion_id");
                String colocadoraId = result.get("colocadora_id");
                String carpeta_comprobantes = result.get("carpeta_comprobantes");
                String carpeta_garantias = result.get("carpeta_garantias");
                ClientesEditarFragment.this.avalMap = new HashMap();
                ClientesEditarFragment.this.avalMap.put("id", id2);
                ClientesEditarFragment.this.avalMap.put("nombre_completo", nombreCompleto);
                ClientesEditarFragment.this.avalMap.put("direccion", direccion);
                ClientesEditarFragment.this.avalMap.put("telefono", telefono);
                ClientesEditarFragment.this.avalMap.put("otras_referencias", otrasReferencias);
                ClientesEditarFragment.this.avalMap.put("garantias", garantias);
                ClientesEditarFragment.this.avalMap.put("ruta_id", rutaId);
                ClientesEditarFragment.this.avalMap.put("poblacion_id", poblacionId);
                ClientesEditarFragment.this.avalMap.put("colocadora_id", colocadoraId);
                ClientesEditarFragment.this.avalMap.put("carpeta_comprobantes", carpeta_comprobantes);
                ClientesEditarFragment.this.avalMap.put("carpeta_garantias", carpeta_garantias);
                ClientesEditarFragment.this.tlAval.getEditText().setText((CharSequence)(nombreCompleto != null ? nombreCompleto : "N/A"));
                ClientesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)(direccion != null ? direccion : "N/A"));
                ClientesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)(telefono != null ? telefono : "N/A"));
                ClientesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)(otrasReferencias != null ? otrasReferencias : "N/A"));
                ClientesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)(garantias != null ? garantias : "N/A"));
                ClientesEditarFragment.this.aval_id = result.get("id");
                ClientesEditarFragment.this.rutaId_aval = rutaId;
                ClientesEditarFragment.this.poblacionId_aval = poblacionId;
                ClientesEditarFragment.this.colocadoraId_aval = colocadoraId;
            } else {
                ClientesEditarFragment.this.tlAval.getEditText().setText((CharSequence)"");
                ClientesEditarFragment.this.tlDireccionAval.getEditText().setText((CharSequence)"");
                ClientesEditarFragment.this.tlTelefonoAval.getEditText().setText((CharSequence)"");
                ClientesEditarFragment.this.tlOtrasReferenciasAval.getEditText().setText((CharSequence)"");
                ClientesEditarFragment.this.tlGarantiasAval.getEditText().setText((CharSequence)"");
                ClientesEditarFragment.this.avalMap = null;
                ClientesEditarFragment.this.rutaId_aval = "";
                ClientesEditarFragment.this.poblacionId_aval = "";
                ClientesEditarFragment.this.colocadoraId_aval = "";
            }
        }
    }
}

