/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.folios;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.clientes.crear.ClientesCrearViewModel;
import com.example.sefinsa_app.ui.folios.ver.FolioAdapter;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Folios
extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private static final Logger log = LoggerFactory.getLogger(Folios.class);
    private String mParam1;
    private String mParam2;
    FloatingActionButton btnAgregar;
    ArrayList<Folio> folios;
    TextInputLayout tlNombreFolio;
    AutoCompleteTextView acRuta;
    AutoCompleteTextView acPoblacion;
    ProgressDialog dialog;
    String empleado_id;
    private RecyclerView rv;
    private ClientesCrearViewModel mViewModel;
    private TextInputLayout tlNombreCliente;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView clientesAutoCompleteTextView;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private ArrayList<Ruta> rutas;
    private ArrayList<String> iRutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private String ruta_id = "";
    private String poblacion_id = "";
    private String cliente_id = "";
    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private String selectedAval = "";
    private HashMap<String, String> avalMap;
    FusedLocationProviderClient client;
    TextInputLayout tlFecha;
    TextInputLayout tlHora;
    private String fecha = null;
    private SharedPreferences sesion;

    public static Folios newInstance(String param1, String param2) {
        Folios fragment = new Folios();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mParam1 = this.getArguments().getString(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
        }
    }

    public void filtrar() {
        FolioController fc = new FolioController((Context)this.getActivity());
        if (this.fecha != null) {
            if (!Objects.equals(this.ruta_id, "") && !Objects.equals(this.poblacion_id, "")) {
                this.setUpRecyclerN(fc.getFolioRutaPoblacionFecha(this.ruta_id, this.poblacion_id, this.fecha));
            } else if (!Objects.equals(this.ruta_id, "") && Objects.equals(this.poblacion_id, "")) {
                this.setUpRecyclerN(fc.getFolioRutaFecha(this.ruta_id, this.fecha));
            } else if (Objects.equals(this.ruta_id, "") && !Objects.equals(this.poblacion_id, "")) {
                this.setUpRecyclerN(fc.getFolioPoblacionFecha(this.poblacion_id, this.fecha));
            } else if (!Objects.equals(this.cliente_id, "")) {
                this.setUpRecyclerN(fc.getFolioClienteFecha(this.cliente_id, this.fecha));
            } else {
                this.setUpRecyclerN(fc.getFolioFechaRutaId(this.fecha, this.iRutas));
            }
        } else if (!Objects.equals(this.ruta_id, "") && !Objects.equals(this.poblacion_id, "")) {
            this.setUpRecyclerN(fc.getFolioRutaPoblacion(this.ruta_id, this.poblacion_id));
        } else if (!Objects.equals(this.ruta_id, "") && Objects.equals(this.poblacion_id, "")) {
            this.setUpRecyclerN(fc.getFolioRuta(this.ruta_id));
        } else if (Objects.equals(this.ruta_id, "") && !Objects.equals(this.poblacion_id, "")) {
            this.setUpRecyclerN(fc.getFolioPoblacion(this.poblacion_id));
        } else if (!Objects.equals(this.cliente_id, "")) {
            this.setUpRecyclerN(fc.getFolioCliente(this.cliente_id));
        } else {
            if (Build.VERSION.SDK_INT >= 26) {
                LocalDate today = LocalDate.now();
                String[] pFecha = String.valueOf(today).split("-");
                this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
                this.fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
            }
            this.setUpRecyclerN(fc.getFolioFechaRutaId(this.fecha, this.iRutas));
        }
    }

    public void onResume() {
        super.onResume();
        this.cliente_id = "";
        this.ruta_id = "";
        this.poblacion_id = "";
        this.fecha = null;
        this.tlNombreFolio.getEditText().setText((CharSequence)"");
        this.acRuta.setText((CharSequence)"");
        this.acPoblacion.setText((CharSequence)"");
        this.tlFecha.getEditText().setText((CharSequence)"");
        if (Build.VERSION.SDK_INT >= 26) {
            LocalDate today = LocalDate.now();
            String[] pFecha = String.valueOf(today).split("-");
            this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
            this.fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
        }
        this.filtrar();
    }

    public void syncServerDB() {
        final FolioController fc = new FolioController(this.getContext());
        ArrayList<Object> unsyncedFolios = new ArrayList();
        try {
            unsyncedFolios = fc.getUnsyncedFolios();
        }
        catch (Exception e) {
            fc.recreate();
            unsyncedFolios = fc.getUnsyncedFolios();
        }
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        if (!unsyncedFolios.isEmpty()) {
            for (Folio folio : unsyncedFolios) {
                fc.syncFolio(String.valueOf(folio.getId()), String.valueOf(folio.getFecha()), String.valueOf(folio.getHora()), String.valueOf(folio.getCliente_id()), String.valueOf(folio.getRuta_id()), String.valueOf(folio.getPoblacion_id()), String.valueOf(folio.getMonto()), String.valueOf(folio.getMonto_letra()), String.valueOf(folio.getConcepto()), String.valueOf(folio.getFirma_usuario()), String.valueOf(folio.getFirma_cliente()));
                Log.d((String)"sync", (String)"onCreateView: sync");
            }
        }
        fc.getTotalFolios(new FolioController.FolioCountCallback(){

            @Override
            public void onSuccess(int total) {
                fc.getFolioDataAndSave(new FolioController.FolioDownloadCallback(){

                    @Override
                    public void onDownloadComplete() {
                        fc.getFoliosCanceladosServidor(new FolioController.FolioEliminarCallback(){

                            @Override
                            public void onSuccess() {
                                Folios.this.filtrar();
                                Folios.this.dialog.dismiss();
                            }

                            @Override
                            public void onError(String error) {
                                Folios.this.filtrar();
                                Folios.this.dialog.dismiss();
                            }

                            @Override
                            public void onSucess() {
                                Folios.this.filtrar();
                                Folios.this.dialog.dismiss();
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(String error) {
                Log.e((String)"FoliosCount", (String)("Error: " + error));
                fc.getFolioDataAndSave(new FolioController.FolioDownloadCallback(){

                    @Override
                    public void onDownloadComplete() {
                        fc.getFoliosCanceladosServidor(new FolioController.FolioEliminarCallback(){

                            @Override
                            public void onSuccess() {
                                Folios.this.filtrar();
                                Folios.this.dialog.dismiss();
                            }

                            @Override
                            public void onError(String error) {
                                Folios.this.filtrar();
                                Folios.this.dialog.dismiss();
                            }

                            @Override
                            public void onSucess() {
                                Folios.this.filtrar();
                                Folios.this.dialog.dismiss();
                            }
                        });
                    }
                });
            }
        });
    }

    public void prepararFolios() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogLayout = inflater.inflate(2131493055, null);
        builder.setView(dialogLayout);
        final TextInputLayout tlCantidad = (TextInputLayout)dialogLayout.findViewById(2131297158);
        builder.setTitle((CharSequence)"Preparar folios").setPositiveButton((CharSequence)"Crear", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                FolioController fc = new FolioController(Folios.this.getContext());
                fc.prepararFolios(Folios.this.empleado_id, tlCantidad.getEditText().getText().toString());
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.dialog.show();
                this.syncServerDB();
                this.acRuta.setText((CharSequence)"");
                this.acPoblacion.setText((CharSequence)"");
                this.ruta_id = "";
                this.poblacion_id = "";
                this.tlNombreFolio.getEditText().setText((CharSequence)"");
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void compartirPagoReporteFolio(Folio folio) throws ParseException {
        try {
            String text = "----------------------------------------------------\n";
            text = text + "PRESTAMO GRUSEF S.A. de C.V.\n";
            text = text + "Folio: " + folio.getId() + "\n";
            text = text + "Fecha: " + folio.getFecha() + "\n";
            RutaController rc = new RutaController(this.getContext());
            String ruta = rc.getNombreRuta(folio.getRuta_id());
            text = text + "Ruta: " + ruta + "\n";
            PoblacionController pc = new PoblacionController(this.getContext());
            String poblacion = pc.getNombrePoblacion(folio.getPoblacion_id());
            text = text + "Poblaci\u00f3n: " + poblacion + "\n";
            ClienteController cc = new ClienteController(this.getContext());
            String cliente = folio.getCliente_id();
            text = text + "Recib\u00ed de:\n" + cliente + "\n";
            text = text + "Cantidad: $" + folio.getMonto() + "\n";
            text = text + Folios.saltoLinea(folio.getMonto_letra());
            text = text + "\nConcepto: \n";
            text = text + Folios.saltoLinea(folio.getConcepto());
            File pdfFile = this.generarPDF(text, folio.getFirma_cliente(), folio.getFirma_usuario());
            this.compartirPDF(pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String saltoLinea(String texto) {
        String[] palabras = texto.split(" ");
        StringBuilder contenido = new StringBuilder();
        Integer cont = 0;
        for (String palabra : palabras) {
            if (cont + palabra.length() < 28) {
                contenido.append(palabra).append(" ");
                cont = cont + (palabra.length() + 1);
                continue;
            }
            contenido.append("\n").append(palabra).append(" ");
            cont = palabra.length() + 1;
        }
        return contenido.toString();
    }

    private void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile((Context)this.getContext(), (String)(this.getContext().getApplicationContext().getPackageName() + ".provider"), (File)pdfFile);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)pdfUri);
            this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Compartir mediante"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File generarPDF(String content, String fc, String fu) throws IOException {
        File pdfFile = new File(this.getContext().getCacheDir(), "Folio.pdf");
        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);
        Drawable drawable2 = this.getResources().getDrawable(2131231010);
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        ImageData imageData = ImageDataFactory.create((byte[])stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);
        Paragraph p = new Paragraph(content);
        p.setFontSize(6.0f);
        document.add((IBlockElement)p);
        Paragraph p2 = new Paragraph("Firma del administrador: \n");
        p2.setFontSize(8.0f);
        document.add((IBlockElement)p2);
        byte[] decodedBytes2 = Base64.decode((String)fu, (int)0);
        bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes2, (int)0, (int)decodedBytes2.length);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos2);
        ImageData imageData3 = ImageDataFactory.create((byte[])baos2.toByteArray());
        Image image3 = new Image(imageData3);
        image3.scaleToFit(100.0f, 100.0f);
        document.add(image3);
        Paragraph p3 = new Paragraph("Firma del colocador(a): \n");
        p3.setFontSize(8.0f);
        document.add((IBlockElement)p3);
        byte[] decodedBytes = Base64.decode((String)fc, (int)0);
        bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos1);
        ImageData imageData2 = ImageDataFactory.create((byte[])baos1.toByteArray());
        Image image2 = new Image(imageData2);
        image2.scaleToFit(100.0f, 100.0f);
        document.add(image2);
        document.close();
        return pdfFile;
    }

    @SuppressLint(value={"MissingInflatedId"})
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(2131492965, container, false);
        SharedPreferences sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.empleado_id = sesion.getString("id", null);
        Log.d((String)"empleadoID", (String)("onCreateView: " + this.empleado_id));
        this.dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        this.dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        this.dialog.setCanceledOnTouchOutside(false);
        this.dialog.show();
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        FolioController fc = new FolioController(this.getContext());
        this.btnAgregar = (FloatingActionButton)view.findViewById(2131296387);
        this.rv = (RecyclerView)view.findViewById(2131296980);
        this.btnAgregar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FolioController fc = new FolioController(Folios.this.getContext());
                if (fc.getUsuarioFolios(Folios.this.empleado_id).isEmpty()) {
                    if (NetworkChange.isConnectedToInternet(Folios.this.getContext())) {
                        Folios.this.prepararFolios();
                    } else {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)Folios.this.getActivity());
                        builder.setTitle((CharSequence)"No hay conexi\u00f3n a internet").setMessage((CharSequence)"No se pueden preparar folios").setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int id2) {
                                dialog.dismiss();
                            }
                        });
                        AlertDialog dialog = builder.create();
                        dialog.show();
                    }
                } else {
                    Navigation.findNavController((Activity)Folios.this.requireActivity(), (int)2131296862).navigate(2131296857);
                }
            }

            private Object getSystemService(String connectivityService) {
                return null;
            }
        });
        this.tlNombreFolio = (TextInputLayout)view.findViewById(2131297205);
        this.acRuta = (AutoCompleteTextView)view.findViewById(2131296288);
        this.acPoblacion = (AutoCompleteTextView)view.findViewById(2131296285);
        this.tlNombreFolio.getEditText().addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String input = s.toString();
                FolioController fc = new FolioController(Folios.this.getContext());
                Folios.this.acRuta.setText((CharSequence)"");
                Folios.this.acPoblacion.setText((CharSequence)"");
                Folios.this.poblacion_id = "";
                Folios.this.ruta_id = "";
                if (input.matches("\\d+")) {
                    Folios.this.setUpRecyclerN(fc.getLikeFolios(String.valueOf(s), Folios.this.iRutas));
                } else if (input.isEmpty()) {
                    Folios.this.cliente_id = "";
                    Folios.this.filtrar();
                } else {
                    Folios.this.acPoblacion.setText((CharSequence)"");
                    Folios.this.acRuta.setText((CharSequence)"");
                    Folios.this.poblacion_id = "";
                    Folios.this.ruta_id = "";
                    Folios.this.setUpRecyclerN(fc.getLikeNombre(String.valueOf(s), Folios.this.fecha, Folios.this.iRutas));
                }
            }
        });
        this.acRuta.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String input = s.toString();
                if (input.isEmpty()) {
                    Folios.this.ruta_id = "";
                    Folios.this.poblacion_id = "";
                    Folios.this.filtrar();
                }
            }
        });
        this.acPoblacion.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String input = s.toString();
                Log.d((String)"weqweqw", (String)("afterTextChanged: " + s));
                if (input.isEmpty()) {
                    if (!Objects.equals(Folios.this.poblacion_id, "")) {
                        Folios.this.filtrar();
                    }
                    Folios.this.poblacion_id = "";
                } else {
                    Folios.this.filtrar();
                }
            }
        });
        this.folios = fc.index();
        this.setHasOptionsMenu(true);
        return view;
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public void setUpRecyclerN(ArrayList<Folio> folios) {
        FolioAdapter adapter = new FolioAdapter(folios, this.getContext(), this.getActivity(), this);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.rv.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.rv.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.rv.setAdapter((RecyclerView.Adapter)adapter);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        this.initElements(view);
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)Folios.this.rutasAdapter.getItem(i);
                Folios.this.ruta_id = ruta.getId();
                Folios.this.filtrar();
                if (Folios.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    Folios.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                List poblacionesFiltro = Folios.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(Folios.this.ruta_id)).collect(Collectors.toList());
                Folios.this.poblacionesAdapter = new ArrayAdapter((Context)Folios.this.requireActivity(), 17367050, poblacionesFiltro);
                Folios.this.poblacionesAutoCompleteTextView.setThreshold(1);
                Folios.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)Folios.this.poblacionesAdapter);
            }
        });
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.length() == 0) {
                    Folios.this.ruta_id = "";
                    Folios.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    Folios.this.poblacion_id = "";
                    Folios.this.filtrar();
                } else {
                    FolioController fc;
                    String rutaId;
                    String[] rutaArr = s.toString().split(" ");
                    if (rutaArr.length > 1 && Folios.this.iRutas.contains(rutaArr[1]) && (!Objects.equals(rutaId = (fc = new FolioController(Folios.this.getContext())).verificarRuta(s.toString()), "") || rutaId != null)) {
                        Folios.this.ruta_id = rutaId;
                        List poblacionesFiltro = null;
                        if (Build.VERSION.SDK_INT >= 24) {
                            poblacionesFiltro = Folios.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(Folios.this.ruta_id)).collect(Collectors.toList());
                        }
                        Folios.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                        Folios.this.poblacionesAdapter = new ArrayAdapter((Context)Folios.this.requireActivity(), 17367050, poblacionesFiltro);
                        Folios.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        Folios.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)Folios.this.poblacionesAdapter);
                        Folios.this.filtrar();
                    }
                }
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones(this.ruta_id);
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)Folios.this.poblacionesAdapter.getItem(i);
                Folios.this.poblacion_id = poblacion.getId();
                Folios.this.filtrar();
            }
        });
        this.poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.length() == 0) {
                    Folios.this.poblacion_id = "";
                    Folios.this.filtrar();
                } else {
                    FolioController fc = new FolioController(Folios.this.getContext());
                    String poblacionId = fc.verificarPoblacion(s.toString());
                    if (!Objects.equals(poblacionId, "") || poblacionId != null) {
                        Folios.this.poblacion_id = poblacionId;
                        Folios.this.filtrar();
                    }
                }
            }
        });
        this.rutasAutoCompleteTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus && Folios.this.rutasAutoCompleteTextView.getText().toString().isEmpty()) {
                    Folios.this.poblacionesAdapter = null;
                    Folios.this.poblacionesAdapter = new ArrayAdapter((Context)Folios.this.requireActivity(), 17367050, (List)Folios.this.poblaciones);
                    Folios.this.poblacionesAutoCompleteTextView.setThreshold(1);
                    Folios.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)Folios.this.poblacionesAdapter);
                }
            }
        });
        this.configurarAutoCompleteTextView();
        SQLiteDatabase db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
        this.llenarAutoComplete(db);
    }

    private void initElements(View view) {
        CurrentFragment.fragment = "ClientesCrearFragment";
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        if (Build.VERSION.SDK_INT >= 26) {
            LocalDate today = LocalDate.now();
            String[] pFecha = String.valueOf(today).split("-");
            this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
        }
        this.tlHora = (TextInputLayout)view.findViewById(2131297191);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.colocadorasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296275);
        this.tlNombreCliente = (TextInputLayout)view.findViewById(2131297203);
        this.clientesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296277);
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.colocadoraController = new ColocadoraController((Context)this.getActivity());
        this.clienteController = new ClienteController((Context)this.getActivity());
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                Folios.this.dialog.dismiss();
            }
        }, 25L, TimeUnit.SECONDS);
        this.syncServerDB();
        this.tlFecha.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FolioController fc = new FolioController(Folios.this.getContext());
                LocalDate today = null;
                String date = null;
                Folios.this.acRuta.setText((CharSequence)"");
                Folios.this.acPoblacion.setText((CharSequence)"");
                Folios.this.ruta_id = "";
                Folios.this.poblacion_id = "";
                Folios.this.tlNombreFolio.getEditText().setText((CharSequence)"");
                if (Build.VERSION.SDK_INT >= 26) {
                    today = LocalDate.now();
                    String[] pFecha = String.valueOf(today).split("-");
                    date = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                }
                if (!Objects.equals(Folios.this.fecha, date)) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        Folios.this.tlFecha.getEditText().setText(date);
                        Folios.this.fecha = date;
                        Folios.this.filtrar();
                    }
                } else {
                    MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                    materialDateBuilder.setTitleText((CharSequence)"Fecha");
                    CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                    constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());
                    materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());
                    MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                    materialDatePicker.show(Folios.this.getChildFragmentManager(), "MATERIAL_DATE_PICKER");
                    materialDatePicker.addOnPositiveButtonClickListener((MaterialPickerOnPositiveButtonClickListener)new MaterialPickerOnPositiveButtonClickListener<Long>(){

                        @SuppressLint(value={"SetTextI18n"})
                        public void onPositiveButtonClick(Long selection) {
                            TimeZone timeZoneUTC = TimeZone.getDefault();
                            int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                            Date date = new Date(selection + (long)offsetFromUTC);
                            if (Build.VERSION.SDK_INT >= 26) {
                                ZoneId zoneId;
                                LocalDate today = LocalDate.now();
                                Instant instant = date.toInstant();
                                LocalDate selectedDate = instant.atZone(zoneId = ZoneId.systemDefault()).toLocalDate();
                                if (selectedDate.isAfter(today)) {
                                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)Folios.this.getActivity());
                                    builder.setTitle((CharSequence)"Fecha invalida");
                                    builder.setMessage((CharSequence)"La fecha ingresada no puede ser mayor a la de hoy.");
                                    builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int id2) {
                                            dialog.dismiss();
                                        }
                                    });
                                    AlertDialog dialog = builder.create();
                                    dialog.show();
                                } else {
                                    String f = simpleFormat.format(date);
                                    String[] pFecha = f.split("-");
                                    String mFecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                                    Folios.this.tlFecha.getEditText().setText((CharSequence)mFecha);
                                    Folios.this.fecha = mFecha;
                                    Folios.this.filtrar();
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private List<Aval> obtenerListaAvales() {
        String sqlQuery;
        ArrayList<Aval> listaAvales = new ArrayList<Aval>();
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(sqlQuery = "SELECT * FROM clientes WHERE nombre_completo IS NOT NULL AND nombre_completo != '' ORDER BY nombre_completo ASC", null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Aval aval = new Aval(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")));
                listaAvales.add(aval);
            } while (cursor.moveToNext());
            cursor.close();
        }
        db.close();
        return listaAvales;
    }

    private void configurarAutoCompleteTextView() {
        new ObtenerAvalesTask().execute(new Void[0]);
    }

    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        String queryAvales;
        Cursor cursorAvales;
        ArrayList clientes = new ArrayList();
        ArrayList avales = new ArrayList();
        ArrayList<Map<String, String>> resultado = new ArrayList<Map<String, String>>();
        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo FROM clientes WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }
        if ((cursorAvales = db.rawQuery(queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo FROM avales WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''", null)) != null) {
            while (cursorAvales.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }
        HashSet<String> nombresUnicos = new HashSet<String>();
        HashSet<String> nombresAvales = new HashSet<String>();
        for (Map map : avales) {
            nombresAvales.add((String)map.get("nombre_completo"));
        }
        for (Map map : clientes) {
            String nombreCliente = (String)map.get("nombre_completo");
            if (nombresAvales.contains(nombreCliente) || nombresUnicos.contains(nombreCliente)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreCliente);
        }
        for (Map map : avales) {
            String nombreAval = (String)map.get("nombre_completo");
            if (nombresUnicos.contains(nombreAval)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreAval);
        }
        return resultado;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarAutoComplete(final SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>(){

            protected List<Map<String, String>> doInBackground(Void ... voids) {
                return Folios.this.getClientesYDisponibles(db);
            }

            protected void onPostExecute(List<Map<String, String>> datos) {
                ArrayList<String> nombres = new ArrayList<String>();
                HashMap<String, Map<String, String>> idMap = new HashMap<String, Map<String, String>>();
                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre == null || nombre.trim().isEmpty()) continue;
                    nombres.add(nombre);
                    idMap.put(nombre, registro);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (ClientesCrearViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ClientesCrearViewModel.class);
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
        if (this.rutaController.obtener().size() == 0) {
            Log.d((String)"getRutas", (String)"No se encontraron rutas guardadas localmente. Solicitando desde el servidor.");
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    Log.d((String)"getRutas", (String)("Respuesta del servidor: " + response.toString()));
                    try {
                        JSONArray data = response.getJSONArray("data");
                        Log.d((String)"getRutas", (String)("Cantidad de rutas recibidas: " + data.length()));
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Log.d((String)"getRutas", (String)("Ruta JSON recibida: " + obj.toString()));
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            Folios.this.rutas.add(ruta);
                            Folios.this.rutaController.nueva(ruta);
                            Log.d((String)"getRutas", (String)("Ruta a\u00f1adida: " + ruta.toString()));
                        }
                        Folios.this.rutasAdapter = new ArrayAdapter(Folios.this.getContext(), 17367050, (List)Folios.this.rutas);
                        Folios.this.rutasAutoCompleteTextView.setThreshold(1);
                        Folios.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)Folios.this.rutasAdapter);
                        Log.d((String)"getRutas", (String)("Adaptador configurado con " + Folios.this.rutas.size() + " rutas."));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Log.e((String)"getRutas", (String)("Error al procesar respuesta del servidor: " + e.getMessage()));
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.e((String)"getRutas", (String)("Error en la solicitud de rutas: " + error.getMessage()));
                    ErrorChecker.checker(error, (Context)Folios.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
            this.requestQueue.add((Request)request);
            Log.d((String)"getRutas", (String)"Solicitud enviada al servidor.");
        } else {
            Log.d((String)"getRutas", (String)"Recuperando rutas guardadas localmente.");
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            Log.d((String)"getRutas", (String)("Cantidad de rutas locales encontradas: " + rutasGuardadas.size()));
            if (this.iRutas == null) {
                this.iRutas = new ArrayList();
            }
            for (Ruta ruta : rutasGuardadas) {
                Log.d((String)"getRutas", (String)("Ruta local encontrada: " + ruta.toString()));
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
                Log.d((String)"getRutas", (String)("Ruta a\u00f1adida tras filtrar: " + ruta));
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
            Log.d((String)"getRutas", (String)("Adaptador configurado con " + this.rutas.size() + " rutas locales."));
            Log.d((String)"aweqw", (String)("getRutas: " + this.rutas.toString()));
            for (int i = 0; i < this.rutas.size(); ++i) {
                String r = String.valueOf(this.rutas.get(i));
                String[] ar = r.split(" ");
                String c = ar[1];
                Log.d((String)"qweqweqw", (String)("getRutas: " + c));
                this.iRutas.add(c);
            }
            Log.d((String)"irutas", (String)("getRutas: " + this.iRutas));
        }
        this.filtrar();
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            Folios.this.poblaciones.add(poblacion);
                            Folios.this.poblacionController.nueva(poblacion);
                        }
                        Folios.this.poblacionesAdapter = new ArrayAdapter(Folios.this.getContext(), 17367050, (List)Folios.this.poblaciones);
                        Folios.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        Folios.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)Folios.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)Folios.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private class ObtenerAvalesTask
    extends AsyncTask<Void, Void, List<Aval>> {
        private ObtenerAvalesTask() {
        }

        protected List<Aval> doInBackground(Void ... voids) {
            List listaAvales = Folios.this.obtenerListaAvales();
            listaAvales.sort((aval1, aval2) -> {
                try {
                    int id1 = Integer.parseInt(aval1.getId() != null ? aval1.getId() : "0");
                    int id2 = Integer.parseInt(aval2.getId() != null ? aval2.getId() : "0");
                    return Integer.compare(id2, id1);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            });
            HashSet<String> nombresUnicos = new HashSet<String>();
            ArrayList<String> nombresAvales = new ArrayList<String>();
            for (Aval aval : listaAvales) {
                if (!nombresUnicos.add(aval.getNombre_completo())) continue;
                nombresAvales.add(aval.getNombre_completo());
            }
            return listaAvales;
        }
    }
}

