/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.folios.crear;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.clientes.crear.ClientesCrearViewModel;
import com.example.sefinsa_app.ui.folios.crear.DibujarFirmaActivity;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrearFolio
extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private static final Logger log = LoggerFactory.getLogger(CrearFolio.class);
    private String mParam1;
    private String mParam2;
    Button btnFirmaUsuario;
    Button btnFirmaCliente;
    TextInputEditText etMonto;
    TextView tvMonto;
    ImageView imgFirmaUsuario;
    ImageView imgFirmaCliente;
    Button btnCrearFolio;
    EditText etFecha;
    EditText etHora;
    EditText etConcepto;
    String montoN;
    TextInputLayout tlRuta;
    TextInputLayout tlPoblacion;
    TextInputLayout tlColocadora;
    TextInputLayout tlMonto;
    TextInputLayout tlConcepto;
    TextInputLayout tlFolio;
    String folio_id;
    private final String[] UNIDADES = new String[]{"", "uno ", "dos ", "tres ", "cuatro ", "cinco ", "seis ", "siete ", "ocho ", "nueve "};
    private final String[] DECENAS = new String[]{"diez ", "once ", "doce ", "trece ", "catorce ", "quince ", "dieciseis ", "diecisiete ", "dieciocho ", "diecinueve", "veinte ", "treinta ", "cuarenta ", "cincuenta ", "sesenta ", "setenta ", "ochenta ", "noventa "};
    private final String[] CENTENAS = new String[]{"", "ciento ", "doscientos ", "trecientos ", "cuatrocientos ", "quinientos ", "seiscientos ", "setecientos ", "ochocientos ", "novecientos "};
    private ClientesCrearViewModel mViewModel;
    private Button btnRegistrarCliente;
    private Button btnUbicacion;
    private Button btnSubirFotos;
    private Button btnSubirFotosAval;
    private TextInputLayout tlNombreCliente;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlGarantiasAval;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView clientesAutoCompleteTextView;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    private String cliente_id = "";
    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private String selectedAval = "";
    private HashMap<String, String> avalMap;
    FusedLocationProviderClient client;
    TextInputLayout tlFecha;
    TextInputLayout tlHora;
    TextInputLayout tlRecibiDe;
    String empleado_id;
    private SharedPreferences sesion;
    private ArrayList<String> iRutas;

    public static CrearFolio newInstance(String param1, String param2) {
        CrearFolio fragment = new CrearFolio();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mParam1 = this.getArguments().getString(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        SharedPreferences p = this.requireActivity().getSharedPreferences("firmas", 0);
        SharedPreferences.Editor editor = p.edit();
        editor.remove("firmaCliente");
        editor.remove("firmaUsuario");
        editor.apply();
    }

    public void onResume() {
        String firmaCliente;
        super.onResume();
        SharedPreferences p = this.requireActivity().getSharedPreferences("firmas", 0);
        String firmaUsuario = p.getString("firmaUsuario", null);
        if (firmaUsuario != null) {
            byte[] decodedBytes = Base64.decode((String)firmaUsuario, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
            this.imgFirmaUsuario.setImageBitmap(bitmap);
        }
        if ((firmaCliente = p.getString("firmaCliente", null)) != null) {
            byte[] decodedBytes = Base64.decode((String)firmaCliente, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
            this.imgFirmaCliente.setImageBitmap(bitmap);
        }
    }

    public void agregarFolio() {
        if (Validator.fieldValidation(this.tlFecha, "La fecha es requerida") && Validator.fieldValidation(this.tlHora, "La hora es requerida") && Validator.fieldValidation(this.tlRecibiDe, "El campo Recibi de es requerido") && Validator.fieldValidation(this.tlRuta, "La ruta es requerida") && Validator.fieldValidation(this.tlPoblacion, "La pobalci\u00f3n es requerida") && Validator.fieldValidation(this.tlMonto, "El monto es requerido") && Validator.fieldValidation(this.tlConcepto, "El concepto es requerido")) {
            FolioController fc = new FolioController(this.getContext());
            String fecha = String.valueOf(this.etFecha.getText());
            String hora = String.valueOf(this.etHora.getText());
            final String nombre_cliente = String.valueOf(this.tlRecibiDe.getEditText().getText());
            String ruta = this.ruta_id;
            String poblacion = fc.getPoblacion(this.poblacion_id);
            String monto = String.valueOf(Objects.requireNonNull(this.tlMonto.getEditText()).getText());
            String montoLetra = String.valueOf(this.tvMonto.getText());
            String concepto = String.valueOf(this.etConcepto.getText());
            if (Objects.equals(ruta, "") || ruta == null) {
                String rutaTxt = String.valueOf(this.tlRuta.getEditText().getText());
                String rutaId = fc.verificarRuta(rutaTxt);
                String[] rutaArr = rutaTxt.split(" ");
                if (!this.iRutas.contains(rutaArr[1])) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.requireActivity());
                    builder.setTitle((CharSequence)"Ruta inv\u00e1lida");
                    builder.setMessage((CharSequence)"La ruta escrita es inv\u00e1lida.");
                    builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id2) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog2 = builder.create();
                    dialog2.show();
                    return;
                }
                if (Objects.equals(rutaId, "")) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.requireActivity());
                    builder.setTitle((CharSequence)"Ruta invalida2");
                    builder.setMessage((CharSequence)"La ruta escrita es invalida.");
                    builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id2) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog3 = builder.create();
                    dialog3.show();
                    return;
                }
                ruta = rutaId;
            }
            if (Objects.equals(poblacion, "") || !poblacion.matches("\\d+")) {
                String poblacionTxt = String.valueOf(Objects.requireNonNull(this.tlPoblacion.getEditText()).getText());
                String poblacionId = fc.verificarPoblacion(poblacionTxt);
                if (Objects.equals(poblacionId, "") || poblacionId == null) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.requireActivity());
                    builder.setTitle((CharSequence)"Poblaci\u00f3n invalida");
                    builder.setMessage((CharSequence)"La poblaci\u00f3n escrita es invalida.");
                    builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id2) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog4 = builder.create();
                    dialog4.show();
                    return;
                }
                poblacion = poblacionId;
            }
            SharedPreferences p = this.requireActivity().getSharedPreferences("firmas", 0);
            String firmaUsuario = p.getString("firmaUsuario", null);
            String firmaCliente = p.getString("firmaCliente", null);
            if (firmaCliente == null || firmaUsuario == null) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.requireActivity());
                builder.setTitle((CharSequence)"Ambas firmas son requeridas");
                builder.setMessage((CharSequence)"Faltan una o ambas firmas de ser dibujadas.");
                builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog5 = builder.create();
                dialog5.show();
            } else {
                try {
                    final Folio folio = new Folio(this.folio_id, fecha, hora, nombre_cliente, ruta, poblacion, monto, montoLetra, concepto, firmaUsuario, firmaCliente);
                    fc.store(folio);
                    try {
                        fc.syncFolio(folio.getId(), folio.getFecha(), folio.getHora(), folio.getCliente_id(), this.ruta_id, this.poblacion_id, folio.getMonto(), folio.getMonto_letra(), folio.getConcepto(), folio.getFirma_usuario(), folio.getFirma_cliente());
                    }
                    catch (Exception e) {
                        Toast.makeText((Context)this.getContext(), (CharSequence)"Error al sincronizar", (int)0).show();
                    }
                    final String finalRuta = ruta;
                    String finalPoblacion = poblacion;
                    new AlertDialog.Builder(this.getContext()).setTitle((CharSequence)"\u00c9xito").setMessage((CharSequence)"El folio se guard\u00f3 correctamente.").setPositiveButton((CharSequence)"Aceptar", (dialog, which) -> this.requireActivity().getSupportFragmentManager().popBackStack()).setNegativeButton((CharSequence)"Imprimir", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            byte[] decodedBytes = Base64.decode((String)folio.getFirma_cliente(), (int)0);
                            final Bitmap bitmapFC = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
                            byte[] decodedBytes2 = Base64.decode((String)folio.getFirma_usuario(), (int)0);
                            final Bitmap bitmapFA = BitmapFactory.decodeByteArray((byte[])decodedBytes2, (int)0, (int)decodedBytes2.length);
                            if (BluetoothUtils.mConnectedThread == null) {
                                Toast.makeText((Context)CrearFolio.this.getContext(), (CharSequence)"No hay impresora conectada", (int)0).show();
                                CrearFolio.this.requireActivity().getSupportFragmentManager().popBackStack();
                            } else if (Build.VERSION.SDK_INT >= 26) {
                                BluetoothUtils.context = CrearFolio.this.getContext();
                                BluetoothUtils.printPhoto(2131230871);
                                try {
                                    FolioController folco = new FolioController(CrearFolio.this.getContext());
                                    final String p = folco.getPoblacionA(folio.getPoblacion_id());
                                    BluetoothUtils.printReimpresion(folio, finalRuta, p, nombre_cliente, bitmapFA, bitmapFC);
                                    new AlertDialog.Builder(CrearFolio.this.getContext()).setTitle((CharSequence)"Imprimir segundo ticket").setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();
                                            CrearFolio.this.requireActivity().getSupportFragmentManager().popBackStack();
                                        }
                                    }).setPositiveButton((CharSequence)"Imprimir", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            if (Build.VERSION.SDK_INT >= 26) {
                                                BluetoothUtils.context = CrearFolio.this.getContext();
                                                BluetoothUtils.printPhoto(2131230871);
                                                try {
                                                    BluetoothUtils.printReimpresion(folio, finalRuta, p, nombre_cliente, bitmapFA, bitmapFC);
                                                    CrearFolio.this.requireActivity().getSupportFragmentManager().popBackStack();
                                                }
                                                catch (ParseException e) {
                                                    throw new RuntimeException(e);
                                                }
                                                catch (IOException e) {
                                                    throw new RuntimeException(e);
                                                }
                                            }
                                        }
                                    }).setCancelable(false).show();
                                }
                                catch (ParseException e) {
                                    throw new RuntimeException(e);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }).setCancelable(false).show();
                }
                catch (Exception e) {
                    Log.d((String)"dberr", (String)("Error: " + e.getMessage()));
                }
            }
        } else {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.requireActivity());
            builder.setTitle((CharSequence)"Campos requeridos");
            builder.setMessage((CharSequence)"Falta alg\u00fan campo por llenar.");
            builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.dismiss();
                }
            });
            AlertDialog dialog6 = builder.create();
            dialog6.show();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        SharedPreferences p = this.requireActivity().getSharedPreferences("firmas", 0);
        SharedPreferences.Editor editor = p.edit();
        editor.remove("firmaCliente");
        editor.remove("firmaUsuario");
        editor.apply();
        View view = inflater.inflate(2131492962, container, false);
        this.btnFirmaUsuario = (Button)view.findViewById(2131296425);
        this.btnFirmaCliente = (Button)view.findViewById(2131296424);
        this.etMonto = (TextInputEditText)view.findViewById(2131296568);
        this.tvMonto = (TextView)view.findViewById(2131297306);
        this.imgFirmaUsuario = (ImageView)view.findViewById(2131296721);
        this.imgFirmaCliente = (ImageView)view.findViewById(2131296720);
        this.btnCrearFolio = (Button)view.findViewById(2131296394);
        this.etFecha = (EditText)view.findViewById(2131296593);
        this.etHora = (EditText)view.findViewById(2131296604);
        this.etConcepto = (EditText)view.findViewById(2131296585);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297217);
        this.tlMonto = (TextInputLayout)view.findViewById(2131297197);
        this.tlConcepto = (TextInputLayout)view.findViewById(2131297167);
        this.tlFolio = (TextInputLayout)view.findViewById(2131297182);
        this.btnCrearFolio.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CrearFolio.this.agregarFolio();
            }
        });
        this.etMonto.setFilters(new InputFilter[]{new DecimalDigitsInputFilter(9, 2)});
        this.btnFirmaUsuario.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)CrearFolio.this.getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma del administrador");
                CrearFolio.this.startActivity(intent);
            }
        });
        this.btnFirmaCliente.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)CrearFolio.this.getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma de colocadora");
                CrearFolio.this.startActivity(intent);
            }
        });
        this.etMonto.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String cadena;
                CrearFolio.this.montoN = cadena = s.toString();
                if (cadena.matches(".*\\.\\d+.*")) {
                    String[] partes = cadena.split("\\.");
                    String p1 = CrearFolio.this.Convertir(partes[0].toString(), true);
                    String p2 = CrearFolio.this.Convertir(partes[1].toString(), true);
                    p1 = Objects.equals(partes[0], "1") ? p1 + "PESO CON " : p1 + "PESOS CON ";
                    p2 = Objects.equals(partes[1], "1") || Objects.equals(partes[1], "01") ? "UN CENTAVO" : p2 + "CENTAVOS";
                    CrearFolio.this.tvMonto.setText((CharSequence)(p1 + p2));
                } else {
                    String[] partes = cadena.split("\\.");
                    String n = CrearFolio.this.Convertir(partes[0].toString(), true);
                    n = Objects.equals(partes[0], "1") ? "UN PESO" : n + "PESOS";
                    CrearFolio.this.tvMonto.setText((CharSequence)n);
                }
                if (cadena.isEmpty()) {
                    CrearFolio.this.tvMonto.setText((CharSequence)"");
                }
            }
        });
        return view;
    }

    public String Convertir(String numero, boolean mayusculas) {
        String literal = "";
        if ((numero = numero.replace(".", ",")).indexOf(",") == -1) {
            numero = numero + ",00";
        }
        if (Pattern.matches("\\d{1,9},\\d{1,2}", numero)) {
            String[] Num = numero.split(",");
            literal = Integer.parseInt(Num[0]) == 0 ? "cero " : (Integer.parseInt(Num[0]) > 999999 ? this.getMillones(Num[0]) : (Integer.parseInt(Num[0]) > 999 ? this.getMiles(Num[0]) : (Integer.parseInt(Num[0]) > 99 ? this.getCentenas(Num[0]) : (Integer.parseInt(Num[0]) > 9 ? this.getDecenas(Num[0]) : this.getUnidades(Num[0])))));
            if (mayusculas) {
                return literal.toUpperCase();
            }
            return literal;
        }
        literal = null;
        return null;
    }

    private String getUnidades(String numero) {
        String num = numero.substring(numero.length() - 1);
        return this.UNIDADES[Integer.parseInt(num)];
    }

    private String getDecenas(String num) {
        int n = Integer.parseInt(num);
        if (n < 10) {
            return this.getUnidades(num);
        }
        if (n > 19) {
            String u = this.getUnidades(num);
            if (u.equals("")) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8];
            }
            return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8] + "y " + u;
        }
        return this.DECENAS[n - 10];
    }

    private String getCentenas(String num) {
        if (Integer.parseInt(num) > 99) {
            if (Integer.parseInt(num) == 100) {
                return "cien ";
            }
            return this.CENTENAS[Integer.parseInt(num.substring(0, 1))] + this.getDecenas(num.substring(1));
        }
        return this.getDecenas(Integer.parseInt(num) + "");
    }

    private String getMiles(String numero) {
        String c = numero.substring(numero.length() - 3);
        String m = numero.substring(0, numero.length() - 3);
        String n = "";
        if (numero.length() == 4 && m.equals("1")) {
            return "mil " + this.getCentenas(c);
        }
        if (Integer.parseInt(m) > 0) {
            n = this.getCentenas(m);
            return n + "mil " + this.getCentenas(c);
        }
        return "" + this.getCentenas(c);
    }

    private String getMillones(String numero) {
        String miles = numero.substring(numero.length() - 6);
        String millon = numero.substring(0, numero.length() - 6);
        String n = "";
        int millonInt = Integer.parseInt(millon);
        if (millonInt == 1) {
            n = "un millon ";
        } else if (millonInt > 1) {
            n = this.getCentenas(millon) + "millones ";
        }
        return n + this.getMiles(miles);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        this.initElements(view);
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)CrearFolio.this.rutasAdapter.getItem(i);
                CrearFolio.this.ruta_id = ruta.getId();
                if (CrearFolio.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    CrearFolio.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                List poblacionesFiltro = CrearFolio.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(CrearFolio.this.ruta_id)).collect(Collectors.toList());
                CrearFolio.this.poblacionesAdapter = new ArrayAdapter((Context)CrearFolio.this.requireActivity(), 17367050, poblacionesFiltro);
                CrearFolio.this.poblacionesAutoCompleteTextView.setThreshold(1);
                CrearFolio.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)CrearFolio.this.poblacionesAdapter);
            }
        });
        this.getPoblaciones("1");
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                FolioController fc = new FolioController(CrearFolio.this.getContext());
                if (s.toString().length() > 5) {
                    String rutaId = fc.verificarRuta(String.valueOf(s));
                    for (Ruta ruta : CrearFolio.this.rutas) {
                        if (!ruta.getId().equals(rutaId)) continue;
                        List poblacionesFiltro = null;
                        if (Build.VERSION.SDK_INT < 24) continue;
                        poblacionesFiltro = CrearFolio.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(rutaId)).collect(Collectors.toList());
                        CrearFolio.this.poblacionesAdapter = new ArrayAdapter((Context)CrearFolio.this.requireActivity(), 17367050, poblacionesFiltro);
                        CrearFolio.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        CrearFolio.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)CrearFolio.this.poblacionesAdapter);
                    }
                } else if (Build.VERSION.SDK_INT >= 24) {
                    CrearFolio.this.tlPoblacion.getEditText().setText((CharSequence)"");
                    CrearFolio.this.poblacionesAutoCompleteTextView.setThreshold(1);
                    CrearFolio.this.poblacionesAutoCompleteTextView.setAdapter(null);
                }
            }
        });
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)CrearFolio.this.poblacionesAdapter.getItem(i);
                CrearFolio.this.poblacion_id = poblacion.getId();
            }
        });
        this.configurarAutoCompleteTextView();
        SQLiteDatabase db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
        this.llenarAutoComplete(db);
    }

    public static boolean validarVariableGlobal(TextInputLayout textInputLayout, String variableGlobal, String errorMessage) {
        if (variableGlobal == null || variableGlobal.isEmpty()) {
            textInputLayout.setError((CharSequence)errorMessage);
            return false;
        }
        textInputLayout.setError(null);
        return true;
    }

    private void initElements(View view) {
        SharedPreferences sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.empleado_id = sesion.getString("id", null);
        FolioController fc = new FolioController(this.getContext());
        CurrentFragment.fragment = "ClientesCrearFragment";
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        this.tlHora = (TextInputLayout)view.findViewById(2131297191);
        this.tlRecibiDe = (TextInputLayout)view.findViewById(2131297225);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.colocadorasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296275);
        this.tlNombreCliente = (TextInputLayout)view.findViewById(2131297203);
        this.clientesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296277);
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.colocadoraController = new ColocadoraController((Context)this.getActivity());
        this.clienteController = new ClienteController((Context)this.getActivity());
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        if (Build.VERSION.SDK_INT >= 26) {
            LocalDate today = LocalDate.now();
            String[] pFecha = String.valueOf(today).split("-");
            this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
            this.tlHora.getEditText().setText((CharSequence)String.valueOf(hour + ":" + minute));
        }
        this.tlFecha.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha");
                CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());
                materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(CrearFolio.this.getChildFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener((MaterialPickerOnPositiveButtonClickListener)new MaterialPickerOnPositiveButtonClickListener<Long>(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Long selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date(selection + (long)offsetFromUTC);
                        if (Build.VERSION.SDK_INT >= 26) {
                            ZoneId zoneId;
                            LocalDate today = LocalDate.now();
                            Instant instant = date.toInstant();
                            LocalDate selectedDate = instant.atZone(zoneId = ZoneId.systemDefault()).toLocalDate();
                            if (selectedDate.isAfter(today)) {
                                AlertDialog.Builder builder = new AlertDialog.Builder((Context)CrearFolio.this.getActivity());
                                builder.setTitle((CharSequence)"Fecha invalida");
                                builder.setMessage((CharSequence)"La fecha ingresada no puede ser mayor a la de hoy.");
                                builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int id2) {
                                        dialog.dismiss();
                                    }
                                });
                                AlertDialog dialog = builder.create();
                                dialog.show();
                            } else {
                                String f = simpleFormat.format(date);
                                String[] pFecha = f.split("-");
                                CrearFolio.this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
                            }
                        }
                    }
                });
            }
        });
        this.tlHora.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Calendar calendar = Calendar.getInstance();
                int hour = calendar.get(11);
                int minute = calendar.get(12);
                TimePickerDialog timePickerDialog = new TimePickerDialog(v.getContext(), (timePicker, selectedHour, selectedMinute) -> {
                    String formattedTime = String.format(Locale.getDefault(), "%02d:%02d", selectedHour, selectedMinute);
                    CrearFolio.this.tlHora.getEditText().setText((CharSequence)formattedTime);
                }, hour, minute, true);
                timePickerDialog.show();
            }
        });
        this.tlFolio.getEditText().setText((CharSequence)fc.getFirstAvailableFolioId(this.empleado_id));
        this.folio_id = fc.getFirstAvailableFolioId(this.empleado_id);
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    private List<Aval> obtenerListaAvales() {
        String sqlQuery;
        ArrayList<Aval> listaAvales = new ArrayList<Aval>();
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(sqlQuery = "SELECT * FROM clientes WHERE nombre_completo IS NOT NULL AND nombre_completo != '' ORDER BY nombre_completo ASC", null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Aval aval = new Aval(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")), cursor.getString(cursor.getColumnIndexOrThrow("telefono")), cursor.getString(cursor.getColumnIndexOrThrow("garantias")), cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")), cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")), cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")), cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")));
                listaAvales.add(aval);
            } while (cursor.moveToNext());
            cursor.close();
        }
        db.close();
        return listaAvales;
    }

    private void configurarAutoCompleteTextView() {
        new ObtenerAvalesTask().execute(new Void[0]);
    }

    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        String queryAvales;
        Cursor cursorAvales;
        ArrayList clientes = new ArrayList();
        ArrayList avales = new ArrayList();
        ArrayList<Map<String, String>> resultado = new ArrayList<Map<String, String>>();
        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo FROM clientes WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }
        if ((cursorAvales = db.rawQuery(queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo FROM avales WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''", null)) != null) {
            while (cursorAvales.moveToNext()) {
                HashMap<String, String> registro = new HashMap<String, String>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase());
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }
        HashSet<String> nombresUnicos = new HashSet<String>();
        HashSet<String> nombresAvales = new HashSet<String>();
        for (Map map : avales) {
            nombresAvales.add((String)map.get("nombre_completo"));
        }
        for (Map map : clientes) {
            String nombreCliente = (String)map.get("nombre_completo");
            if (nombresAvales.contains(nombreCliente) || nombresUnicos.contains(nombreCliente)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreCliente);
        }
        for (Map map : avales) {
            String nombreAval = (String)map.get("nombre_completo");
            if (nombresUnicos.contains(nombreAval)) continue;
            resultado.add(map);
            nombresUnicos.add(nombreAval);
        }
        return resultado;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void llenarAutoComplete(final SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>(){

            protected List<Map<String, String>> doInBackground(Void ... voids) {
                return CrearFolio.this.getClientesYDisponibles(db);
            }

            protected void onPostExecute(List<Map<String, String>> datos) {
                ArrayList<String> nombres = new ArrayList<String>();
                HashMap<String, Map<String, String>> idMap = new HashMap<String, Map<String, String>>();
                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre == null || nombre.trim().isEmpty()) continue;
                    nombres.add(nombre);
                    idMap.put(nombre, registro);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
        if (this.rutaController.obtener().size() == 0) {
            Log.d((String)"getRutas", (String)"No se encontraron rutas guardadas localmente. Solicitando desde el servidor.");
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    Log.d((String)"getRutas", (String)("Respuesta del servidor: " + response.toString()));
                    try {
                        JSONArray data = response.getJSONArray("data");
                        Log.d((String)"getRutas", (String)("Cantidad de rutas recibidas: " + data.length()));
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Log.d((String)"getRutas", (String)("Ruta JSON recibida: " + obj.toString()));
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            CrearFolio.this.rutas.add(ruta);
                            CrearFolio.this.rutaController.nueva(ruta);
                            Log.d((String)"getRutas", (String)("Ruta a\u00f1adida: " + ruta.toString()));
                        }
                        CrearFolio.this.rutasAdapter = new ArrayAdapter(CrearFolio.this.getContext(), 17367050, (List)CrearFolio.this.rutas);
                        CrearFolio.this.rutasAutoCompleteTextView.setThreshold(1);
                        CrearFolio.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)CrearFolio.this.rutasAdapter);
                        Log.d((String)"getRutas", (String)("Adaptador configurado con " + CrearFolio.this.rutas.size() + " rutas."));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Log.e((String)"getRutas", (String)("Error al procesar respuesta del servidor: " + e.getMessage()));
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.e((String)"getRutas", (String)("Error en la solicitud de rutas: " + error.getMessage()));
                    ErrorChecker.checker(error, (Context)CrearFolio.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
            this.requestQueue.add((Request)request);
            Log.d((String)"getRutas", (String)"Solicitud enviada al servidor.");
        } else {
            Log.d((String)"getRutas", (String)"Recuperando rutas guardadas localmente.");
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            Log.d((String)"getRutas", (String)("Cantidad de rutas locales encontradas: " + rutasGuardadas.size()));
            if (this.iRutas == null) {
                this.iRutas = new ArrayList();
            }
            for (Ruta ruta : rutasGuardadas) {
                Log.d((String)"getRutas", (String)("Ruta local encontrada: " + ruta.toString()));
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
                Log.d((String)"getRutas", (String)("Ruta a\u00f1adida tras filtrar: " + ruta));
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
            Log.d((String)"getRutas", (String)("Adaptador configurado con " + this.rutas.size() + " rutas locales."));
            Log.d((String)"aweqw", (String)("getRutas: " + this.rutas.toString()));
            for (int i = 0; i < this.rutas.size(); ++i) {
                String r = String.valueOf(this.rutas.get(i));
                String[] ar = r.split(" ");
                String c = ar[1];
                Log.d((String)"qweqweqw", (String)("getRutas: " + c));
                this.iRutas.add(c);
            }
            Log.d((String)"irutas", (String)("getRutas: " + this.iRutas));
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance((Context)this.requireActivity());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            CrearFolio.this.poblaciones.add(poblacion);
                            CrearFolio.this.poblacionController.nueva(poblacion);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)CrearFolio.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (ClientesCrearViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ClientesCrearViewModel.class);
    }

    public class DecimalDigitsInputFilter
    implements InputFilter {
        private final int digitsBeforeZero;
        private final int digitsAfterZero;

        public DecimalDigitsInputFilter(int digitsBeforeZero, int digitsAfterZero) {
            this.digitsBeforeZero = digitsBeforeZero;
            this.digitsAfterZero = digitsAfterZero;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            String newVal = dest.subSequence(0, dstart) + source.toString() + dest.subSequence(dend, dest.length());
            if (newVal.equals(".")) {
                return "0.";
            }
            if (newVal.indexOf(46) != newVal.lastIndexOf(46)) {
                return "";
            }
            if (newVal.startsWith("0") && newVal.length() > 1 && !newVal.startsWith("0.")) {
                return "";
            }
            if (newVal.contains(".")) {
                String[] parts = newVal.split("\\.");
                if (parts[0].length() > this.digitsBeforeZero) {
                    return "";
                }
                if (parts.length > 1 && parts[1].length() > this.digitsAfterZero) {
                    return "";
                }
            } else if (newVal.length() > this.digitsBeforeZero) {
                return "";
            }
            return null;
        }
    }

    private class ObtenerAvalesTask
    extends AsyncTask<Void, Void, List<Aval>> {
        private ObtenerAvalesTask() {
        }

        protected List<Aval> doInBackground(Void ... voids) {
            List listaAvales = CrearFolio.this.obtenerListaAvales();
            listaAvales.sort((aval1, aval2) -> {
                try {
                    int id1 = Integer.parseInt(aval1.getId() != null ? aval1.getId() : "0");
                    int id2 = Integer.parseInt(aval2.getId() != null ? aval2.getId() : "0");
                    return Integer.compare(id2, id1);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            });
            HashSet<String> nombresUnicos = new HashSet<String>();
            ArrayList<String> nombresAvales = new ArrayList<String>();
            for (Aval aval : listaAvales) {
                if (!nombresUnicos.add(aval.getNombre_completo())) continue;
                nombresAvales.add(aval.getNombre_completo());
            }
            return listaAvales;
        }

        protected void onPostExecute(List<Aval> listaAvales) {
            if (listaAvales != null) {
                ArrayList<String> nombresAvales = new ArrayList<String>();
                HashSet<String> nombresUnicos = new HashSet<String>();
                for (Aval aval : listaAvales) {
                    if (!nombresUnicos.add(aval.getNombre_completo())) continue;
                    nombresAvales.add(aval.getNombre_completo());
                }
                ArrayAdapter arrayAdapter = new ArrayAdapter(CrearFolio.this.requireContext(), 17367050, nombresAvales);
            }
        }
    }
}

