/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.folios.crear;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.util.Base64;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;

public class DibujarFirmaActivity
extends AppCompatActivity {
    ImageView imgFirma;
    Button btnReiniciarFirma;
    Button btnGuardarFirma;
    TextView txtTitulo;
    private Bitmap bitmap;
    private Canvas canvas;
    private Paint paint = new Paint();
    private float floatStartX = -1.0f;
    private float floatStartY = -1.0f;
    private float floatEndX = -1.0f;
    private float floatEndY = -1.0f;
    private boolean firma = false;

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable((ComponentActivity)this);
        this.setContentView(2131492893);
        this.imgFirma = (ImageView)this.findViewById(2131296718);
        this.btnGuardarFirma = (Button)this.findViewById(2131296434);
        this.btnReiniciarFirma = (Button)this.findViewById(2131296450);
        this.txtTitulo = (TextView)this.findViewById(2131297349);
        Bundle bundle = this.getIntent().getExtras();
        String titulo = bundle.getString("titulo");
        this.txtTitulo.setText((CharSequence)titulo);
        this.imgFirma.post(() -> {
            int width = this.imgFirma.getWidth();
            int height = this.imgFirma.getHeight();
            this.initCanvas(width, height);
        });
        this.btnReiniciarFirma.setOnClickListener(v -> {
            this.firma = false;
            int width = this.imgFirma.getWidth();
            int height = this.imgFirma.getHeight();
            this.initCanvas(width, height);
        });
        this.btnGuardarFirma.setOnClickListener(v -> {
            if (!this.firma) {
                new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Dibujar firma").setMessage((CharSequence)"Se tiene que dibujar una firma para poder continuar.").setPositiveButton((CharSequence)"Aceptar", (dialog, id2) -> dialog.dismiss()).show();
            } else {
                Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)300, (int)200, (boolean)true);
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Firma guardada", (int)0).show();
                SharedPreferences p = this.getSharedPreferences("firmas", 0);
                SharedPreferences.Editor e = p.edit();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                scaledBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
                byte[] bm = baos.toByteArray();
                String imageEncoded = Base64.encodeToString((byte[])bm, (int)0);
                if (Objects.equals(titulo, "Dibujar firma del administrador")) {
                    e.putString("firmaUsuario", imageEncoded);
                } else if (Objects.equals(titulo, "Dibujar firma de colocadora")) {
                    e.putString("firmaCliente", imageEncoded);
                } else if (Objects.equals(titulo, "Dibujar firma de cliente")) {
                    e.putString("firmaClienteRMD", imageEncoded);
                } else if (Objects.equals(titulo, "Dibujar firma de asesor")) {
                    e.putString("firmaAsesorRMD", imageEncoded);
                }
                e.apply();
                this.finish();
            }
        });
        this.imgFirma.setOnTouchListener((v, event) -> {
            this.firma = true;
            switch (event.getAction()) {
                case 0: {
                    this.floatStartX = event.getX();
                    this.floatStartY = event.getY();
                    break;
                }
                case 1: 
                case 2: {
                    this.floatEndX = event.getX();
                    this.floatEndY = event.getY();
                    this.drawLine();
                    this.floatStartX = this.floatEndX;
                    this.floatStartY = this.floatEndY;
                }
            }
            return true;
        });
    }

    private void initCanvas(int width, int height) {
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.bitmap);
        this.canvas.drawColor(-1);
        this.paint.setColor(-16777216);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(8.0f);
        this.imgFirma.setImageBitmap(this.bitmap);
    }

    private void drawLine() {
        if (this.canvas != null) {
            this.canvas.drawLine(this.floatStartX, this.floatStartY, this.floatEndX, this.floatEndY, this.paint);
            this.imgFirma.setImageBitmap(this.bitmap);
        }
    }
}

