/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.folios.ver;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.ui.folios.Folios;
import com.example.sefinsa_app.ui.folios.ver.VerFirmasFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;

public class FolioAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<Folio> folios;
    private Context context;
    private FragmentActivity activity;
    private final Folios fragment;

    public FolioAdapter(ArrayList<Folio> folios, Context context, FragmentActivity activity, Folios fragment) {
        this.folios = folios;
        this.context = context;
        this.activity = activity;
        this.fragment = fragment;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(2131492947, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, @SuppressLint(value={"RecyclerView"}) int position) {
        final Folio folio = this.folios.get(position);
        String nFolio = folio.getId();
        String fecha = folio.getFecha();
        final String cliente_id = folio.getCliente_id();
        String monto = folio.getMonto();
        final String concepto = folio.getConcepto();
        final String firmaUsuario = folio.getFirma_usuario();
        final String firmaCliente = folio.getFirma_cliente();
        holder.tvnFolio.setText((CharSequence)("Folio: " + nFolio));
        holder.tvfechaHora.setText((CharSequence)fecha);
        holder.tvNombre.setText((CharSequence)("Recibido de: " + cliente_id));
        FolioController fc = new FolioController(this.context);
        String p = fc.getPoblacion(folio.getPoblacion_id());
        holder.tvPoblacion.setText((CharSequence)("Poblaci\u00f3n: " + p));
        holder.tvMonto.setText((CharSequence)("Monto: $" + monto));
        holder.btnConcepto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(FolioAdapter.this.context);
                builder.setTitle((CharSequence)"Concepto");
                builder.setMessage((CharSequence)concepto);
                builder.setPositiveButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
        holder.btnFirmas.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SharedPreferences p = FolioAdapter.this.context.getSharedPreferences("firmas", 0);
                SharedPreferences.Editor e = p.edit();
                e.putString("firmaUsuario", firmaUsuario);
                e.putString("firmaCliente", firmaCliente);
                e.commit();
                VerFirmasFragment dialog = new VerFirmasFragment();
                dialog.show(FolioAdapter.this.activity.getSupportFragmentManager(), "verFirmasDialog");
            }
        });
        RutaController rc = new RutaController(this.context);
        final String ruta = rc.getNombreRuta(folio.getRuta_id());
        PoblacionController pc = new PoblacionController(this.context);
        final String poblacion = pc.getNombrePoblacion(folio.getPoblacion_id());
        byte[] decodedBytes = Base64.decode((String)folio.getFirma_cliente(), (int)0);
        final Bitmap bitmapFC = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
        byte[] decodedBytes2 = Base64.decode((String)folio.getFirma_usuario(), (int)0);
        final Bitmap bitmapFA = BitmapFactory.decodeByteArray((byte[])decodedBytes2, (int)0, (int)decodedBytes2.length);
        holder.btnImpresora.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder6 = new AlertDialog.Builder(FolioAdapter.this.context);
                builder6.setTitle((CharSequence)"Seleccionar Opcion").setPositiveButton((CharSequence)"Reimprimir Folio", new DialogInterface.OnClickListener(){

                    @RequiresApi(api=26)
                    public void onClick(DialogInterface dialog, int which) {
                        new MaterialAlertDialogBuilder(FolioAdapter.this.context).setTitle((CharSequence)"Reimprimir folio").setMessage((CharSequence)("\u00bfQuieres reimprimir el folio de " + folio.getId() + "?")).setPositiveButton((CharSequence)"S\u00ed", new DialogInterface.OnClickListener(){

                            @RequiresApi(api=26)
                            public void onClick(DialogInterface dialogInterface, int i) {
                                BluetoothUtils.context = FolioAdapter.this.context;
                                BluetoothUtils.printPhoto(2131230871);
                                try {
                                    if (BluetoothUtils.mConnectedThread != null) {
                                        BluetoothUtils.printReimpresion(folio, ruta, poblacion, cliente_id, bitmapFA, bitmapFC);
                                    } else {
                                        Toast.makeText((Context)FolioAdapter.this.context, (CharSequence)"No hay conexi\u00f3n con la impresora", (int)0).show();
                                    }
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                    }
                }).setNeutralButton((CharSequence)"Compartir", new DialogInterface.OnClickListener(){

                    @RequiresApi(api=26)
                    public void onClick(DialogInterface dialog, int which) {
                        try {
                            FolioAdapter.this.fragment.compartirPagoReporteFolio(folio);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                }).show();
            }
        });
    }

    public int getItemCount() {
        return this.folios.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvnFolio;
        private TextView tvfechaHora;
        private TextView tvNombre;
        private TextView tvPoblacion;
        private TextView tvMonto;
        private MaterialButton btnConcepto;
        private MaterialButton btnFirmas;
        private MaterialButton btnImpresora;

        public ViewHolder(View view) {
            super(view);
            this.tvnFolio = (TextView)view.findViewById(2131297348);
            this.tvfechaHora = (TextView)view.findViewById(2131297347);
            this.tvNombre = (TextView)view.findViewById(2131297313);
            this.tvPoblacion = (TextView)view.findViewById(2131297319);
            this.tvMonto = (TextView)view.findViewById(2131297306);
            this.btnConcepto = (MaterialButton)view.findViewById(2131296415);
            this.btnFirmas = (MaterialButton)view.findViewById(2131296426);
            this.btnImpresora = (MaterialButton)view.findViewById(2131296438);
        }
    }
}

