/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.historial;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Grupo;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.ReporteHistorial;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteHistorialAdapter;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HistorialPagosFragment
extends Fragment {
    private ArrayList<ReporteHistorial> reportes;
    private ArrayList<ReporteHistorial> reportesFiltrados;
    private ArrayList<ReporteHistorial> reportesFiltradosNombres;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private RecyclerView recyclerView;
    private ReporteHistorialAdapter reporteHistorialAdapter;
    private LinearLayoutManager linearLayoutManager;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private TextView tvRuta;
    private TextView tvPoblacion;
    private TextView tvColumnaPagado;
    private TextView tvColumnaCobranza;
    private AutoCompleteTextView modalidadesAutoCompleteTextView;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView estatusAutoCompleteTextView;
    private TextInputLayout tlGrupos;
    private TextInputLayout tlNombre;
    private String modalidad_id = "1";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String grupo = "";
    private String estatus = "";
    private String busquedaTexto = "";
    private static TextInputEditText svPrestamos;
    private int previousLength;
    private boolean backSpace;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Grupo> grupos;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Modalidad> modalidades;
    private ArrayAdapter<Modalidad> modalidadesAdapter;
    private int totalPagados = 0;
    private int totalCobranza = 0;
    private Map<Integer, String> detallesSemanas;
    private TableLayout headerTable;
    private SharedPreferences sesion;

    public static HistorialPagosFragment newInstance() {
        return new HistorialPagosFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        return inflater.inflate(2131492966, container, false);
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.requestQueue.getCache().clear();
                this.getReporteHistorial("1", null, null, null, null);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        this.modalidadesAutoCompleteTextView.setText((CharSequence)this.modalidadesAutoCompleteTextView.getAdapter().getItem(0).toString(), false);
        if (this.rutasAutoCompleteTextView != null) {
            this.rutasAutoCompleteTextView.setText((CharSequence)"");
        }
        if (this.poblacionesAutoCompleteTextView != null) {
            this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
        }
        if (this.tlGrupos != null) {
            this.tlGrupos.getEditText().setText((CharSequence)"");
        }
        if (svPrestamos != null) {
            svPrestamos.setText((CharSequence)"");
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "HistorialPagosFragment";
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296290);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296287);
        this.modalidadesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296281);
        this.headerTable = (TableLayout)view.findViewById(2131296673);
        svPrestamos = (TextInputEditText)view.findViewById(2131297310);
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.tlGrupos = (TextInputLayout)view.findViewById(2131297190);
        this.estatusAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296278);
        this.initElements(view);
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.reporteHistorialAdapter = new ReporteHistorialAdapter((Context)this.getActivity(), this.reportes);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.reporteHistorialAdapter);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 0);
        this.getEstatus();
        this.getReporteHistorial("1", null, null, null, null);
    }

    private void getEstatus() {
        Object[] estatusOptions = new String[]{};
        estatusOptions = this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR") ? new String[]{"Vigente", "Vencido"} : (this.sesion.getString("nombre_perfil", "").equals("JURIDICO") ? new String[]{"Vigente", "Vencido", "Pagado", "Renovado", "Jur\u00eddico"} : new String[]{"Vigente"});
        ArrayAdapter estatusAdapter = new ArrayAdapter(this.getContext(), 17367050, estatusOptions);
        this.estatusAutoCompleteTextView.setAdapter((ListAdapter)estatusAdapter);
        this.estatusAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String selectedEstatus = (String)parent.getItemAtPosition(position);
                HistorialPagosFragment.this.estatus = "";
                switch (selectedEstatus) {
                    case "Vigente": {
                        HistorialPagosFragment.this.estatus = "0";
                        break;
                    }
                    case "Vencido": {
                        HistorialPagosFragment.this.estatus = "-1";
                        break;
                    }
                    case "Pagado": {
                        HistorialPagosFragment.this.estatus = "1";
                        break;
                    }
                    case "Renovado": {
                        HistorialPagosFragment.this.estatus = "2";
                        break;
                    }
                    case "Jur\u00eddico": {
                        HistorialPagosFragment.this.estatus = "4";
                    }
                }
                HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
            }
        });
        this.estatusAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                HistorialPagosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                HistorialPagosFragment.this.backSpace = HistorialPagosFragment.this.previousLength > s.length();
                if (HistorialPagosFragment.this.backSpace && !HistorialPagosFragment.this.ruta_id.equals("")) {
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
                }
            }
        });
    }

    private void filtrarSoloPorNombre(String text) {
        this.reportesFiltrados = new ArrayList();
        this.reportesFiltrados.clear();
        this.reportesFiltradosNombres = new ArrayList();
        for (ReporteHistorial reporte : this.reportesFiltrados) {
            String texto_filtro = reporte.getNombre_completo();
            if (!reporte.getTarjeton().toLowerCase().contains(text.toLowerCase()) && !reporte.getNombre_completo().toLowerCase().contains(text.toLowerCase()) && !texto_filtro.toLowerCase().contains(text.toLowerCase())) continue;
            this.reportesFiltradosNombres.add(reporte);
        }
        if (!this.reportesFiltradosNombres.isEmpty()) {
            this.reporteHistorialAdapter.setListaFiltrada(this.reportesFiltradosNombres);
        }
    }

    public void initElements(View view) {
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.reportes = new ArrayList();
        this.detallesSemanas = new HashMap<Integer, String>();
        this.recyclerView = (RecyclerView)view.findViewById(2131296981);
        svPrestamos.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                HistorialPagosFragment.this.busquedaTexto = editable.toString();
                Log.d((String)"TextoBusqueda", (String)("Texto ingresado: " + HistorialPagosFragment.this.busquedaTexto));
                Log.d((String)"TextoBusqueda", (String)("modalidad_id ingresado: " + HistorialPagosFragment.this.modalidad_id));
                Log.d((String)"TextoBusqueda", (String)("ruta_id ingresado: " + HistorialPagosFragment.this.ruta_id));
                Log.d((String)"TextoBusqueda", (String)("poblacion_id ingresado: " + HistorialPagosFragment.this.poblacion_id));
                Log.d((String)"TextoBusqueda", (String)("estatus ingresado: " + HistorialPagosFragment.this.estatus));
                Log.d((String)"TextoBusqueda", (String)("grupo ingresado: " + HistorialPagosFragment.this.grupo));
                if (!(Objects.equals(HistorialPagosFragment.this.modalidad_id, "") || Objects.equals(HistorialPagosFragment.this.ruta_id, "") || Objects.equals(HistorialPagosFragment.this.poblacion_id, "") || Objects.equals(HistorialPagosFragment.this.estatus, "") || Objects.equals(HistorialPagosFragment.this.grupo, ""))) {
                    Log.d((String)"Filtrar", (String)"Entrando en la condici\u00f3n: Todos los filtros tienen valores");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
                } else if (!(Objects.equals(HistorialPagosFragment.this.modalidad_id, "") || Objects.equals(HistorialPagosFragment.this.ruta_id, "") || Objects.equals(HistorialPagosFragment.this.poblacion_id, "") || Objects.equals(HistorialPagosFragment.this.estatus, ""))) {
                    Log.d((String)"Filtrar", (String)"Entrando en la condici\u00f3n: Todos los filtros tienen valores MENOS GRUPO");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, "", HistorialPagosFragment.this.busquedaTexto);
                } else if (!Objects.equals(HistorialPagosFragment.this.modalidad_id, "") && !Objects.equals(HistorialPagosFragment.this.ruta_id, "") && !Objects.equals(HistorialPagosFragment.this.poblacion_id, "") && Objects.equals(HistorialPagosFragment.this.estatus, "")) {
                    Log.d((String)"Filtrar", (String)"Entrando en la condici\u00f3n: Todos los filtros tienen valores MENOS ESTATUS");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, "", "", HistorialPagosFragment.this.busquedaTexto);
                } else if (!Objects.equals(HistorialPagosFragment.this.modalidad_id, "") && !Objects.equals(HistorialPagosFragment.this.ruta_id, "") && Objects.equals(HistorialPagosFragment.this.poblacion_id, "") && Objects.equals(HistorialPagosFragment.this.estatus, "")) {
                    Log.d((String)"Filtrar", (String)"Entrando en la condici\u00f3n: Todos los filtros tienen valores MENOS ESTATUS Y POBLACION");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, "", "", "", HistorialPagosFragment.this.busquedaTexto);
                } else if (!Objects.equals(HistorialPagosFragment.this.modalidad_id, "") && Objects.equals(HistorialPagosFragment.this.ruta_id, "") && Objects.equals(HistorialPagosFragment.this.poblacion_id, "") && Objects.equals(HistorialPagosFragment.this.estatus, "")) {
                    Log.d((String)"Filtrar", (String)"Entrando en la condici\u00f3n: Todos los filtros tienen valores MENOS ESTATUS, POBLACION Y RUTA");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, "", "", "", "", HistorialPagosFragment.this.busquedaTexto);
                } else {
                    Log.d((String)"Filtrar", (String)"Entrando en la condici\u00f3n: SIN FILTROS");
                    HistorialPagosFragment.this.filtrarSoloPorNombre(HistorialPagosFragment.this.busquedaTexto);
                }
            }
        });
        this.modalidades = new ArrayList();
        this.getModalidades();
        this.modalidadesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                HistorialPagosFragment.this.detallesSemanas = new HashMap();
                Modalidad modalidad = (Modalidad)HistorialPagosFragment.this.modalidadesAdapter.getItem(i);
                HistorialPagosFragment.this.modalidad_id = modalidad.getId();
                HistorialPagosFragment.this.estatus = "";
                HistorialPagosFragment.this.estatusAutoCompleteTextView.setText((CharSequence)"");
                HistorialPagosFragment.this.ruta_id = "";
                HistorialPagosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                HistorialPagosFragment.this.poblacion_id = "";
                HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                HistorialPagosFragment.this.grupo = "";
                HistorialPagosFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                HistorialPagosFragment.this.getReporteHistorial(HistorialPagosFragment.this.modalidad_id, null, null, null, null);
            }
        });
        this.modalidadesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                HistorialPagosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                HistorialPagosFragment.this.backSpace = HistorialPagosFragment.this.previousLength > s.length();
                if (HistorialPagosFragment.this.backSpace && !HistorialPagosFragment.this.modalidad_id.equals("")) {
                    HistorialPagosFragment.this.detallesSemanas = new HashMap();
                    HistorialPagosFragment.this.modalidad_id = "";
                    HistorialPagosFragment.this.modalidadesAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.ruta_id = "";
                    HistorialPagosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.poblacion_id = "";
                    HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.grupo = "";
                    HistorialPagosFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    HistorialPagosFragment.this.estatus = "";
                    HistorialPagosFragment.this.estatusAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.getReporteHistorial("1", null, null, null, null);
                }
            }
        });
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.grupos = new ArrayList();
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)HistorialPagosFragment.this.rutasAdapter.getItem(i);
                HistorialPagosFragment.this.ruta_id = ruta.getId();
                Log.d((String)"getRutas", (String)("Ruta ID de la rutasAutoCompleteTextView: " + HistorialPagosFragment.this.ruta_id));
                if (HistorialPagosFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (HistorialPagosFragment.this.tlGrupos.getEditText().getText().toString().length() > 0) {
                    HistorialPagosFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                }
                List poblacionesFiltro = HistorialPagosFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(HistorialPagosFragment.this.ruta_id)).collect(Collectors.toList());
                HistorialPagosFragment.this.poblacionesAdapter = new ArrayAdapter(HistorialPagosFragment.this.getContext(), 17367050, poblacionesFiltro);
                HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)HistorialPagosFragment.this.poblacionesAdapter);
                HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
            }
        });
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                HistorialPagosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                HistorialPagosFragment.this.backSpace = HistorialPagosFragment.this.previousLength > s.length();
                if (HistorialPagosFragment.this.backSpace && !HistorialPagosFragment.this.ruta_id.equals("")) {
                    HistorialPagosFragment.this.ruta_id = "";
                    HistorialPagosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.poblacion_id = "";
                    HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.grupo = "";
                    HistorialPagosFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    HistorialPagosFragment.this.estatus = "";
                    HistorialPagosFragment.this.estatusAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
                }
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones(this.ruta_id);
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)HistorialPagosFragment.this.poblacionesAdapter.getItem(i);
                HistorialPagosFragment.this.poblacion_id = poblacion.getId();
                HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
            }
        });
        this.poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                HistorialPagosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                HistorialPagosFragment.this.backSpace = HistorialPagosFragment.this.previousLength > s.length();
                if (HistorialPagosFragment.this.backSpace && !HistorialPagosFragment.this.poblacion_id.equals("")) {
                    HistorialPagosFragment.this.poblacion_id = "";
                    HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.estatus = "";
                    HistorialPagosFragment.this.estatusAutoCompleteTextView.setText((CharSequence)"");
                    HistorialPagosFragment.this.grupo = "";
                    HistorialPagosFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, HistorialPagosFragment.this.grupo, HistorialPagosFragment.this.busquedaTexto);
                }
            }
        });
        this.tlGrupos.getEditText().addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                HistorialPagosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String textoPrestamos = svPrestamos.getText().toString();
                HistorialPagosFragment.this.backSpace = HistorialPagosFragment.this.previousLength > s.length();
                if (HistorialPagosFragment.this.backSpace) {
                    HistorialPagosFragment.this.grupo = "";
                    HistorialPagosFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, textoPrestamos, HistorialPagosFragment.this.grupo);
                } else if (s.length() > 0) {
                    HistorialPagosFragment.this.grupo = s.toString();
                    HistorialPagosFragment.this.filtrarReporte(HistorialPagosFragment.this.modalidad_id, HistorialPagosFragment.this.ruta_id, HistorialPagosFragment.this.poblacion_id, HistorialPagosFragment.this.estatus, textoPrestamos, HistorialPagosFragment.this.grupo);
                }
            }
        });
    }

    private void getModalidades() {
        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        this.modalidades.add(modalidad15);
        this.modalidades.add(modalidad20);
        this.modalidadesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.modalidades);
        this.modalidadesAutoCompleteTextView.setThreshold(1);
        this.modalidadesAutoCompleteTextView.setAdapter(this.modalidadesAdapter);
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            Gson gson = new Gson();
                            JSONObject obj = data.getJSONObject(i);
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            HistorialPagosFragment.this.rutas.add(ruta);
                            HistorialPagosFragment.this.rutaController.nueva(ruta);
                            Log.d((String)"getRutas", (String)("Ruta a\u00f1adida: " + ruta.toString()));
                        }
                        HistorialPagosFragment.this.rutasAdapter = new ArrayAdapter(HistorialPagosFragment.this.getContext(), 17367050, (List)HistorialPagosFragment.this.rutas);
                        HistorialPagosFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        HistorialPagosFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)HistorialPagosFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)HistorialPagosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            Log.d((String)"getRutas", (String)"Recuperando rutas guardadas localmente.");
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            Log.d((String)"getRutas", (String)("Cantidad de rutas locales encontradas: " + rutasGuardadas.size()));
            for (Ruta ruta : rutasGuardadas) {
                Log.d((String)"getRutas", (String)("Ruta local encontrada: " + ruta.toString()));
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
                Log.d((String)"getRutas", (String)("Ruta a\u00f1adida tras filtrar: " + ruta));
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            HistorialPagosFragment.this.poblaciones.add(poblacion);
                            HistorialPagosFragment.this.poblacionController.nueva(poblacion);
                        }
                        HistorialPagosFragment.this.poblacionesAdapter = new ArrayAdapter(HistorialPagosFragment.this.getContext(), 17367050, (List)HistorialPagosFragment.this.poblaciones);
                        HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        HistorialPagosFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)HistorialPagosFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)HistorialPagosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getReporteHistorial(String modalidad_id, String ruta_id, String poblacion_id, String grupo, String estatus) {
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.headerTable.removeAllViews();
        this.headerTable.invalidate();
        Log.d((String)"filtrarReporte", (String)("modalidad_id: " + modalidad_id));
        this.reporteHistorialAdapter.actualizarModalidad(modalidad_id);
        this.reporteHistorialAdapter.notifyDataSetChanged();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            String query;
            Cursor cursor;
            DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            this.reportes.clear();
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("WHERE cs.id = ").append(modalidad_id).append(" ");
            if (ruta_id != null && !ruta_id.isEmpty()) {
                whereClause.append("AND clientes.ruta_id = ").append(ruta_id).append(" ");
            }
            if (poblacion_id != null && !poblacion_id.isEmpty()) {
                whereClause.append("AND clientes.poblacion_id = ").append(poblacion_id).append(" ");
            }
            if (grupo != null && !grupo.isEmpty()) {
                whereClause.append("AND prestamos.grupo_poblacion = ").append(grupo).append(" ");
            }
            if (estatus != null) {
                if (estatus.equals("3")) {
                    whereClause.append("AND prestamos.status != ").append(estatus).append(" ");
                } else {
                    whereClause.append("AND prestamos.status = ").append(estatus).append(" ");
                }
            }
            int numeroSemanas = Integer.parseInt(modalidad_id.equals("1") ? "15" : "20");
            StringBuilder columnasSemanas = new StringBuilder();
            for (int i = 1; i <= numeroSemanas; ++i) {
                columnasSemanas.append("MAX(CASE WHEN pagos.semana = ").append(i).append(" THEN pagos.fecha_pago || '<br>' || ").append("CASE ").append("WHEN pagos.status = 3 THEN 'Pago con multa' ").append("WHEN pagos.status = 1 THEN 'Pago a tiempo' ").append("WHEN pagos.status = -1 THEN 'No pag\u00f3' ").append("WHEN pagos.status = 2 THEN 'Pago omitido' ").append("WHEN pagos.status = 0 THEN 'Pago vigente' ").append("ELSE '' END || '<br>' || ").append("CASE WHEN pagos.folio != '0' THEN pagos.folio ELSE '' END || '<br>' || ").append("CASE WHEN pagos.cantidad_pendiente != '0.00' THEN '$' || pagos.cantidad_pendiente ELSE '' END || '<br>' || ").append("pagos.tipo_pago END) AS semana").append(i).append(", ");
            }
            if (columnasSemanas.length() > 0) {
                columnasSemanas.setLength(columnasSemanas.length() - 2);
            }
            if ((cursor = db.rawQuery(query = "SELECT prestamos.numero_tarjeton, clientes.nombre_completo, clientes.ruta_id,clientes.poblacion_id, clientes.direccion, clientes.telefono, clientes.garantias, avales.nombre_completo AS nombre_aval, avales.direccion AS direccion_aval, avales.telefono AS telefono_aval, prestamos.monto_prestado, prestamos.pago_semanal, pagos.prestamo_id, prestamos.modalidad_semanas, prestamos.status, prestamos.grupo_poblacion, pagos.status AS pago_status, poblaciones.nombre_poblacion AS nombre_poblacion, (prestamos.pago_semanal * cs.cantidad) AS balance_original, ((prestamos.pago_semanal * cs.cantidad) - SUM(CASE WHEN pagos.status = 2 THEN pagos.cantidad_esperada_pago ELSE pagos.cantidad_normal_pagada END)) AS balance, " + columnasSemanas.toString() + " FROM prestamos JOIN clientes ON clientes.id = prestamos.cliente_id LEFT JOIN avales ON avales.id = prestamos.aval_id LEFT JOIN pagos ON pagos.prestamo_id = prestamos.id LEFT JOIN poblaciones ON poblaciones.id = clientes.poblacion_id INNER JOIN configuracion_semanas AS cs ON prestamos.modalidad_semanas = cs.id " + whereClause.toString() + "GROUP BY prestamos.id, clientes.poblacion_id ORDER BY clientes.poblacion_id DESC", null)) != null && cursor.moveToFirst()) {
                do {
                    ReporteHistorial reporte = new ReporteHistorial();
                    reporte.setTarjeton(cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")));
                    reporte.setNombre_completo(cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")));
                    reporte.setMonto_prestado(cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")));
                    reporte.setPago_semanal(cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")));
                    reporte.setPrestamo_id(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id")));
                    reporte.setModalidad_semanas(cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")));
                    reporte.setStatus(cursor.getString(cursor.getColumnIndexOrThrow("status")));
                    reporte.setBalance_original(cursor.getString(cursor.getColumnIndexOrThrow("balance_original")));
                    reporte.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporte.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporte.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporte.setGrupo(cursor.getString(cursor.getColumnIndexOrThrow("grupo_poblacion")));
                    for (int i = 1; i <= numeroSemanas; ++i) {
                        String columnaSemana = "semana" + i;
                        reporte.setDetalleSemana(i, cursor.getString(cursor.getColumnIndexOrThrow(columnaSemana)));
                        reporte.setPago_status(cursor.getString(cursor.getColumnIndexOrThrow("pago_status")));
                    }
                    this.reportes.add(reporte);
                } while (cursor.moveToNext());
                cursor.close();
            }
            db.close();
            executor.shutdown();
            this.getActivity().runOnUiThread(() -> {
                TableRow headerRow = new TableRow((Context)this.requireActivity());
                String[] headers = new String[]{"Tarjeton", "Poblacion", "Cliente", "Monto", "Pago"};
                float[] weights = new float[]{1.0f, 1.8f, 2.8f, 1.5f, 2.0f};
                for (int i = 0; i < headers.length; ++i) {
                    TextView tvHeader = new TextView((Context)this.requireActivity());
                    tvHeader.setText((CharSequence)headers[i]);
                    tvHeader.setGravity(17);
                    tvHeader.setTextSize(14.0f);
                    tvHeader.setTypeface(Typeface.DEFAULT_BOLD);
                    tvHeader.setPadding(10, 10, 10, 0);
                    tvHeader.setBackgroundColor(ContextCompat.getColor((Context)this.requireActivity(), (int)2131100470));
                    TableRow.LayoutParams params = new TableRow.LayoutParams(0, -2, weights[i]);
                    tvHeader.setLayoutParams((ViewGroup.LayoutParams)params);
                    headerRow.addView((View)tvHeader);
                }
                int numSemanas = Integer.parseInt(modalidad_id.equals("1") ? "15" : "20");
                for (int i = 1; i <= numSemanas; ++i) {
                    TextView tvSemana = new TextView((Context)this.requireActivity());
                    tvSemana.setText((CharSequence)("Semana " + i));
                    tvSemana.setGravity(17);
                    tvSemana.setTextSize(14.0f);
                    tvSemana.setTypeface(Typeface.DEFAULT_BOLD);
                    tvSemana.setPadding(10, 10, 10, 0);
                    tvSemana.setBackgroundColor(ContextCompat.getColor((Context)this.requireActivity(), (int)2131100470));
                    TableRow.LayoutParams params = new TableRow.LayoutParams(0, -2, 1.4f);
                    params.setMargins(10, 0, 0, 0);
                    tvSemana.setLayoutParams((ViewGroup.LayoutParams)params);
                    headerRow.addView((View)tvSemana);
                }
                this.headerTable.addView((View)headerRow);
                dialog.cancel();
                this.reporteHistorialAdapter.addAll(this.reportes);
                this.reporteHistorialAdapter.notifyItemRangeChanged(0, this.reportes.size());
            });
        });
    }

    private void filtrarReporte(String modalidad_id, String ruta_id, String poblacion_id, String status, String grupo, String busqueda) {
        this.reportesFiltrados = new ArrayList();
        this.reportesFiltrados.clear();
        for (ReporteHistorial reporte : this.reportes) {
            boolean busquedaCoincide;
            boolean modalidadCoincide = modalidad_id == null || modalidad_id.isEmpty() || modalidad_id.equals(reporte.getModalidad_semanas());
            boolean rutaCoincide = ruta_id == null || ruta_id.isEmpty() || ruta_id.equals(reporte.getRuta_id());
            boolean poblacionCoincide = poblacion_id == null || poblacion_id.isEmpty() || poblacion_id.equals(reporte.getPoblacion_id());
            boolean grupoCoincide = grupo == null || grupo.isEmpty() || grupo.equals(reporte.getGrupo());
            boolean statusCoincide = status == null || status.isEmpty() || status.equals(reporte.getStatus());
            String textoFiltro = reporte.getNombre_completo() + "\nTarjeton: " + reporte.getTarjeton();
            boolean bl = busquedaCoincide = busqueda == null || busqueda.isEmpty() || reporte.getNombre_completo().toLowerCase().contains(busqueda.toLowerCase()) || textoFiltro.toLowerCase().contains(busqueda.toLowerCase());
            if (!modalidadCoincide || !rutaCoincide || !poblacionCoincide || !grupoCoincide || !statusCoincide || !busquedaCoincide) continue;
            this.reportesFiltrados.add(reporte);
        }
        if (!this.reportesFiltrados.isEmpty()) {
            this.reporteHistorialAdapter.setListaFiltrada(this.reportesFiltrados);
        } else {
            this.reporteHistorialAdapter.setListaFiltrada(new ArrayList<ReporteHistorial>());
            Log.d((String)"filtrarReporte", (String)"No se encontraron coincidencias.");
        }
    }

    private int safeParseInt(String value) {
        try {
            return value != null ? Integer.parseInt(value) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

