/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.pagos;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.ui.pagos.PagosViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.HorizontalScroll;
import com.example.sefinsa_app.utilities.PagosAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VerticalScroll;
import com.example.sefinsa_app.utilities.VolleyMultipartRequest;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PagosFragment
extends Fragment
implements HorizontalScroll.ScrollViewListener,
VerticalScroll.ScrollViewListener {
    private PagosViewModel mViewModel;
    private ArrayList<Pago> pagos;
    private ArrayList<Pago> pagosFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;
    Button btnPagar;
    Button btnPagarConMulta;
    Button btnNoPagar;
    private SearchView svPagos;
    private RecyclerView recyclerViewInfo;
    private RecyclerView recyclerViewNombre0;
    private RecyclerView recyclerViewPagos;
    private ShimmerFrameLayout shimmer;
    private PagosAdapter pagosAdapter;
    private LinearLayoutManager linearLayoutManager;
    private TextView informacionPrestamo;
    private Pago pagoSeleccionado;
    public String prestramoJsonString;
    public Prestamo prestamo;
    private ArrayList<PagosHechos> pagosHechos;
    private SharedPreferences sesion;
    private ArrayList<Prestamo> prestamosFiltrados;

    public static PagosFragment newInstance() {
        return new PagosFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492967, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "PagosFragment";
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        Bundle args = this.getArguments();
        this.prestramoJsonString = args.getString("prestamo");
        this.prestamo = (Prestamo)Utils.getGsonParser().fromJson(this.prestramoJsonString, Prestamo.class);
        this.prestamosFiltrados = args.getParcelableArrayList("lista_filtrada");
        Log.d((String)"LISTA", (String)this.prestamosFiltrados.toString());
        this.shimmer = (ShimmerFrameLayout)view.findViewById(2131297036);
        this.informacionPrestamo = (TextView)view.findViewById(2131296743);
        this.informacionPrestamo.setText((CharSequence)(this.prestamo.getNombre_completo() + " (" + this.prestamo.getNumero_tarjeton() + ")"));
        this.recyclerViewPagos = (RecyclerView)view.findViewById(2131296983);
        this.pagos = new ArrayList();
        this.getPagos(this.prestamo.getId());
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerViewPagos.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.pagosAdapter = new PagosAdapter((Context)this.getActivity(), this.pagos, this.prestamo);
        this.recyclerViewPagos.setAdapter((RecyclerView.Adapter)this.pagosAdapter);
        this.recyclerViewPagos.getRecycledViewPool().setMaxRecycledViews(0, 0);
        this.btnPagar = (Button)view.findViewById(2131296443);
        this.btnPagarConMulta = (Button)view.findViewById(2131296444);
        this.btnNoPagar = (Button)view.findViewById(2131296442);
        this.btnPagar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (Pago pago : PagosFragment.this.pagos) {
                    if (!pago.getStatus().equals("0")) continue;
                    PagosFragment.this.pagoSeleccionado = pago;
                    break;
                }
                if (PagosFragment.this.pagoSeleccionado != null) {
                    new MaterialAlertDialogBuilder((Context)PagosFragment.this.getActivity()).setTitle((CharSequence)("Pagar Semana " + PagosFragment.this.pagoSeleccionado.getSemana())).setMessage((CharSequence)("Se aplicara un pago de $" + PagosFragment.this.pagoSeleccionado.getCantidad_esperada_pago())).setPositiveButton((CharSequence)"Pagar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            PagosFragment.this.pagar(PagosFragment.this.pagoSeleccionado.getPrestamo_id(), PagosFragment.this.pagoSeleccionado.getSemana(), PagosFragment.this.pagoSeleccionado.getTipo_pago());
                        }
                    }).show();
                }
            }
        });
        this.btnPagarConMulta.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (Pago pago : PagosFragment.this.pagos) {
                    if (!pago.getStatus().equals("0")) continue;
                    PagosFragment.this.pagoSeleccionado = pago;
                    break;
                }
                if (PagosFragment.this.pagoSeleccionado != null) {
                    new MaterialAlertDialogBuilder((Context)PagosFragment.this.getActivity()).setTitle((CharSequence)("Pagar Semana " + PagosFragment.this.pagoSeleccionado.getSemana())).setMessage((CharSequence)("Se aplicara un pago de $" + PagosFragment.this.pagoSeleccionado.getCantidad_esperada_pago() + " con una multa de $" + PagosFragment.this.pagoSeleccionado.getMonto_multa())).setPositiveButton((CharSequence)"Pagar con multa", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            PagosFragment.this.pagarConMulta(PagosFragment.this.pagoSeleccionado.getPrestamo_id(), PagosFragment.this.pagoSeleccionado.getSemana(), PagosFragment.this.pagoSeleccionado.getTipo_pago());
                        }
                    }).show();
                }
            }
        });
        this.btnNoPagar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (Pago pago : PagosFragment.this.pagos) {
                    if (!pago.getStatus().equals("0")) continue;
                    PagosFragment.this.pagoSeleccionado = pago;
                    break;
                }
                if (PagosFragment.this.pagoSeleccionado != null) {
                    new MaterialAlertDialogBuilder((Context)PagosFragment.this.getActivity()).setTitle((CharSequence)("Semana " + PagosFragment.this.pagoSeleccionado.getSemana())).setMessage((CharSequence)"Se marcara la semana como No pagada").setPositiveButton((CharSequence)"No pagar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            PagosFragment.this.noPagar(PagosFragment.this.pagoSeleccionado.getPrestamo_id(), PagosFragment.this.pagoSeleccionado.getSemana());
                        }
                    }).show();
                }
            }
        });
    }

    private void getPagos(String prestamo_id) {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"pagosPrestamo");
            data.put("prestamo_id", (Object)prestamo_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    dialog.cancel();
                    JSONArray data = (JSONArray)response.get("data");
                    PagosFragment.this.pagosAdapter.clear();
                    PagosFragment.this.pagos.clear();
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Gson gson = new Gson();
                        Pago pago = (Pago)gson.fromJson(obj.toString(), Pago.class);
                        PagosFragment.this.pagos.add(pago);
                    }
                    PagosFragment.this.pagosAdapter.addAll(PagosFragment.this.pagos);
                    PagosFragment.this.pagosAdapter.notifyItemRangeChanged(PagosFragment.this.pagos.size(), 1);
                    PagosFragment.this.shimmer.startShimmer();
                    PagosFragment.this.shimmer.setVisibility(8);
                    PagosFragment.this.recyclerViewPagos.setVisibility(0);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)PagosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void pagar(String prestamo_id, String semana, String tipo_pago) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"pagarSiguiente");
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("semana", (Object)semana);
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
            data.put("tipo_pago", (Object)tipo_pago);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    String data = response.get("status").toString();
                    Date c = Calendar.getInstance().getTime();
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                    String formattedDate = df.format(c);
                    PagosHechos pagoHecho = new PagosHechos(formattedDate, PagosFragment.this.prestamo.getNombre_poblacion(), PagosFragment.this.prestamo.getNombre_completo(), PagosFragment.this.prestamo.getPago_semanal(), PagosFragment.this.sesion.getString("nombre_perfil", ""), PagosFragment.this.prestamo.getMonto_multa(), PagosFragment.this.prestamo.getNombre_ruta());
                    if (data.equals("success")) {
                        PagosFragment.this.getPagos(PagosFragment.this.prestamo.getId());
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PagosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        requestQueue.add((Request)request);
    }

    private void pagarConMulta(String prestamo_id, String semana, String tipo_pago) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"pagarSiguienteConMulta");
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("semana", (Object)semana);
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
            data.put("tipo_pago", (Object)tipo_pago);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    String data = response.get("status").toString();
                    Date c = Calendar.getInstance().getTime();
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                    String formattedDate = df.format(c);
                    PagosHechos pagoHecho = new PagosHechos(formattedDate, PagosFragment.this.prestamo.getNombre_poblacion(), PagosFragment.this.prestamo.getNombre_completo(), String.valueOf(Utils.convertirDouble(PagosFragment.this.prestamo.getPago_semanal())), PagosFragment.this.sesion.getString("nombre_perfil", ""), PagosFragment.this.prestamo.getMonto_multa(), PagosFragment.this.prestamo.getNombre_ruta());
                    if (data.equals("success")) {
                        PagosFragment.this.getPagos(PagosFragment.this.prestamo.getId());
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PagosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        requestQueue.add((Request)request);
    }

    private void noPagar(String prestamo_id, String semana) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"noPagarSiguiente");
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("semana", (Object)semana);
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    String data = response.get("status").toString();
                    if (data.equals("success")) {
                        PagosFragment.this.getPagos(PagosFragment.this.prestamo.getId());
                        Toast.makeText((Context)PagosFragment.this.getActivity(), (CharSequence)"Pago no recibido", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PagosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        request.setShouldCache(false);
        requestQueue.add((Request)request);
    }

    private void pagos2() {
        VolleyMultipartRequest volleyMultipartRequest = new VolleyMultipartRequest(1, API.urlPagos, (Response.Listener)new Response.Listener<NetworkResponse>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onResponse(NetworkResponse response) {
                try {
                    JSONObject obj = new JSONObject(new String(response.data));
                    String status = obj.get("status").toString();
                    if (!status.equals("success")) return;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PagosFragment.this.getActivity());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("func", "reporteRegistroCredito");
                params.put("modalidad", "2");
                return params;
            }
        };
        Volley.newRequestQueue((Context)this.getActivity()).add((Request)volleyMultipartRequest);
    }

    @Override
    public void onScrollChanged(HorizontalScroll scrollView, int x, int y, int oldx, int oldy) {
    }

    @Override
    public void onScrollChanged(VerticalScroll scrollView, int x, int y, int oldx, int oldy) {
    }
}

