/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.pagos.pagar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.Navigation;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.ui.pagos.pagar.PagosPagarViewModel;
import com.example.sefinsa_app.utilities.BluetoothPrint;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NumeroLetras;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputLayout;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class PagosPagarFragment
extends Fragment {
    private PagosPagarViewModel mViewModel;
    private TextInputLayout tlFechaPago;
    private TextInputLayout tlFolio;
    private TextInputLayout tlPagoRecibido;
    private TextInputLayout tlConcepto;
    public String pagoJsonString;
    public String prestamoJsonString;
    public String pagoMulta = "0.0";
    public Pago pago;
    public Prestamo prestamo;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private CheckBox cbMulta;
    private SharedPreferences sesion;
    private Button btnRegistrarPago;
    private final int CODIGO_PERMISOS_BLUETOOTH = 666;

    public static PagosPagarFragment newInstance() {
        return new PagosPagarFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492968, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "PagosPagarFragment";
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        Bundle args = this.getArguments();
        this.pagoJsonString = args.getString("pago");
        this.pago = (Pago)Utils.getGsonParser().fromJson(this.pagoJsonString, Pago.class);
        this.prestamoJsonString = args.getString("prestamo");
        this.prestamo = (Prestamo)Utils.getGsonParser().fromJson(this.prestamoJsonString, Prestamo.class);
        this.tlFechaPago = (TextInputLayout)view.findViewById(2131297181);
        this.tlFolio = (TextInputLayout)view.findViewById(2131297182);
        this.tlPagoRecibido = (TextInputLayout)view.findViewById(2131297214);
        this.tlConcepto = (TextInputLayout)view.findViewById(2131297167);
        this.btnRegistrarPago = (Button)view.findViewById(2131296448);
        this.cbMulta = (CheckBox)view.findViewById(2131296475);
        this.cbMulta.setText((CharSequence)("Aplicar multa de $" + this.pago.getMonto_multa()));
        this.tlPagoRecibido.getEditText().setText((CharSequence)this.pago.getCantidad_esperada_pago());
        this.tlFechaPago.getEditText().setText((CharSequence)this.pago.getFecha_pago());
        this.cbMulta.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                PagosPagarFragment.this.pagoMulta = b ? PagosPagarFragment.this.pago.getMonto_multa() : "0.0";
            }
        });
        this.tlFechaPago.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha de pago");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(PagosPagarFragment.this.getFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Object selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date((Long)selection + (long)offsetFromUTC);
                        PagosPagarFragment.this.tlFechaPago.getEditText().setText((CharSequence)simpleFormat.format(date));
                    }
                });
            }
        });
        this.btnRegistrarPago.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int permisoBT1 = ContextCompat.checkSelfPermission((Context)PagosPagarFragment.this.getActivity(), (String)"android.permission.BLUETOOTH_CONNECT");
                int permisoBT2 = ContextCompat.checkSelfPermission((Context)PagosPagarFragment.this.getActivity(), (String)"android.permission.BLUETOOTH");
                if (Validator.fieldValidation(PagosPagarFragment.this.tlFechaPago, "Ingrese una fecha") && Validator.fieldValidation(PagosPagarFragment.this.tlFolio, "Ingrese un folio") && Validator.fieldValidation(PagosPagarFragment.this.tlPagoRecibido, "Ingrese un pago")) {
                    String pago_recibido = PagosPagarFragment.this.tlPagoRecibido.getEditText().getText().toString();
                    String concepto = PagosPagarFragment.this.tlConcepto.getEditText().getText().toString();
                    String fecha = PagosPagarFragment.this.tlFechaPago.getEditText().getText().toString();
                    String folio = PagosPagarFragment.this.tlFolio.getEditText().getText().toString();
                    NumeroLetras numeroLetras = new NumeroLetras();
                    String recibido_con_letra = numeroLetras.Convertir(pago_recibido, "", "", "", "", "", true);
                    PagosPagarFragment.this.pagar(PagosPagarFragment.this.pago.getId(), PagosPagarFragment.this.pago.getPrestamo_id(), pago_recibido, PagosPagarFragment.this.pagoMulta, concepto, fecha, folio, PagosPagarFragment.this.pago.getTipo_pago());
                    BluetoothPrint printBT = new BluetoothPrint((Context)PagosPagarFragment.this.getActivity(), PagosPagarFragment.this.getActivity().getResources());
                    BluetoothPrint.printer_id = PagosPagarFragment.this.sesion.getString("impresora", "SP-T12 Printer");
                    try {
                        printBT.findBT();
                        printBT.openBT();
                        printBT.printPhoto(2131230871);
                        printBT.printText(PagosPagarFragment.this.pago, PagosPagarFragment.this.tlFolio.getEditText().getText().toString(), PagosPagarFragment.this.tlPagoRecibido.getEditText().getText().toString(), PagosPagarFragment.this.pagoMulta, PagosPagarFragment.this.tlConcepto.getEditText().getText().toString(), PagosPagarFragment.this.tlFechaPago.getEditText().getText().toString(), recibido_con_letra);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 666: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    BluetoothPrint printBT = new BluetoothPrint((Context)this.getActivity(), this.getActivity().getResources());
                    BluetoothPrint.printer_id = "SP-T12 Printer";
                    try {
                        printBT.findBT();
                        printBT.openBT();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Es necesario dar los permisos de bluetooth", (int)0).show();
            }
        }
    }

    private void pagar(String pago_id, String prestamo_id, final String pago_recibido, final String pago_multa, final String concepto, String fecha_pago, final String folio, String tipo_pago) {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"pagar");
            data.put("pago_id", (Object)pago_id);
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("pago_recibido", (Object)pago_recibido);
            data.put("pago_multa", (Object)pago_multa);
            data.put("concepto", (Object)concepto);
            data.put("fecha_pago", (Object)fecha_pago);
            data.put("folio", (Object)folio);
            data.put("tipo_pago", (Object)tipo_pago);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    Date c = Calendar.getInstance().getTime();
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                    String formattedDate = df.format(c);
                    PagosHechos pagoHecho = new PagosHechos(formattedDate, PagosPagarFragment.this.pago.getNombre_poblacion(), PagosPagarFragment.this.pago.getNombre_completo(), folio, concepto, String.valueOf(Utils.convertirDouble(pago_recibido)), PagosPagarFragment.this.sesion.getString("nombre_perfil", ""), pago_multa, PagosPagarFragment.this.pago.getNombre_ruta());
                    String data = response.get("message").toString();
                    dialog.cancel();
                    Bundle args = new Bundle();
                    String prestamoJsonString = Utils.getGsonParser().toJson((Object)PagosPagarFragment.this.prestamo);
                    args.putString("prestamo", prestamoJsonString);
                    Navigation.findNavController((Activity)PagosPagarFragment.this.getActivity(), (int)2131296862).navigate(2131296864, args);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)PagosPagarFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    public void folioConsecutivo() {
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (PagosPagarViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(PagosPagarViewModel.class);
    }
}

