/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.prestamos;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.WorkManager;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.ClientesWorker;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.NetworkSpeedChecker;
import com.example.sefinsa_app.PagosWorker;
import com.example.sefinsa_app.PrestamosWorker;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ConfiguracionSemanasController;
import com.example.sefinsa_app.controllers.PagoController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ConfiguracionSemana;
import com.example.sefinsa_app.models.Grupo;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.prestamos.PrestamosViewModel;
import com.example.sefinsa_app.utilities.BluetoothPrint;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.PrestamosAdapter;
import com.example.sefinsa_app.utilities.ProgressDialogFragment;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PrestamosFragment
extends Fragment
implements NetworkChangeReceiver.NetworkChangeListener {
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private boolean camaraGarantiasRetiradas = false;
    public Uri image_uri;
    public Uri selectedImageUri;
    private static final List<Prestamo> prestamosTotales = new ArrayList<Prestamo>();
    private PrestamosViewModel mViewModel;
    public static ArrayList<Prestamo> prestamos;
    public static ArrayList<Prestamo> prestamosFiltrados;
    public static ArrayList<Prestamo> prestamosFiltradosNombres;
    public static ArrayList<Pago> pagos;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private static TextInputEditText svPrestamos;
    private static ShimmerFrameLayout shimmer;
    private static RecyclerView recyclerView;
    public static PrestamosAdapter prestamosAdapter;
    private LinearLayoutManager linearLayoutManager;
    private View dialogView2;
    private SharedPreferences sesion;
    private AutoCompleteTextView modalidadesAutoCompleteTextView;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private TextView gruposAutoCompleteTextView;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<ConfiguracionSemana> configuracionSemanas;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private Button btnCamGarantiasRetiradas;
    private Button btnGuardarGarantiasRetiradas;
    private ArrayList<Grupo> grupos;
    private ArrayAdapter<Grupo> gruposAdapter;
    private ArrayList<Modalidad> modalidades;
    private ArrayAdapter<Modalidad> modalidadesAdapter;
    private static String modalidad_id;
    private static String ruta_id;
    private static String poblacion_id;
    private String grupo = "";
    private int previousLength;
    private boolean backSpace;
    private ConfiguracionSemanasController configuracionSemanaController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private PagoController pagoController;
    private Button btnPagar;
    private Button btnPagarConMulta;
    private Button btnNoPagar;
    private Button btnAplicar;
    private Button btnCancelar;
    private Button btnCambiarAval;
    private Button btnAdelantar;
    private TextView tvSeleccion;
    private TextView textViewMensajes;
    private LinearLayoutCompat botones;
    String path;
    private int banderaGarantiasRetiradas = 0;
    private ArrayList<PagosHechos> pagosHechos;
    private Fragment fragmento;
    private ArrayList<MultipartBody.Part> archivosGeneral = new ArrayList();
    private ArrayList<String> pathsGarantiasRetiradas = new ArrayList();
    private final int CODIGO_PERMISOS_BLUETOOTH = 666;
    File pdfFile;
    private NetworkSpeedChecker speedChecker;
    private static ProgressDialog dialog;
    public static boolean shouldStartPolling;
    private static final boolean shouldStopLoading = false;
    private static boolean isShimmerActive;
    private int retryCount = 0;
    private int retryCountPagos = 0;
    private static final int MAX_RETRIES = 80;
    private boolean isConnected = true;
    private static final boolean isPrestamosWorkerRunning = false;
    private ProgressDialogFragment progressDialogFragment;
    private boolean isDialogShown = false;
    private NetworkChangeReceiver networkChangeReceiver;
    private static boolean isSessionActive;

    public static PrestamosFragment newInstance() {
        return new PrestamosFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        this.getActivity().setRequestedOrientation(1);
        View view = inflater.inflate(2131492969, container, false);
        isSessionActive = true;
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList();
        }
        if (this.pathsGarantiasRetiradas == null) {
            this.pathsGarantiasRetiradas = new ArrayList();
        }
        if (this.speedChecker != null) {
            this.speedChecker.startChecking();
        }
        return view;
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        isSessionActive = true;
        this.modalidadesAutoCompleteTextView.setText((CharSequence)this.modalidadesAutoCompleteTextView.getAdapter().getItem(0).toString(), false);
        if (this.rutasAutoCompleteTextView != null) {
            this.rutasAutoCompleteTextView.setText((CharSequence)"");
        }
        if (this.poblacionesAutoCompleteTextView != null) {
            this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
        }
        if (this.gruposAutoCompleteTextView != null) {
            this.gruposAutoCompleteTextView.setText((CharSequence)"");
        }
        if (svPrestamos != null) {
            svPrestamos.setText((CharSequence)"");
        }
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.refreshData("");
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 666: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    BluetoothPrint printBT = new BluetoothPrint((Context)this.getActivity(), this.getActivity().getResources());
                    BluetoothPrint.printer_id = "SP-T12 Printer";
                    Log.d((String)"DEBUG", (String)("URI de printBT: " + (Object)((Object)printBT)));
                    try {
                        printBT.findBT();
                        printBT.openBT();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Es necesario dar los permisos de bluetooth", (int)0).show();
            }
        }
    }

    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int height;
        int width = bitmap.getWidth();
        float bitmapRatio = (float)width / (float)(height = bitmap.getHeight());
        if (bitmapRatio > 1.0f) {
            width = maxSize;
            height = (int)((float)width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int)((float)height * bitmapRatio);
        }
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        this.addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }

    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
        fos.flush();
        fos.close();
        return file;
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = this.getCurrentDateTime();
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(bitmap.getHeight() - 40), (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(18.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = bitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void openCameraIntent() {
        ContentValues values = new ContentValues();
        values.put("title", "Imagen ejemplo");
        values.put("description", "Camara ejemplo");
        this.camaraGarantiasRetiradas = true;
        this.image_uri = null;
        this.image_uri = this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        Intent i = new Intent("android.media.action.IMAGE_CAPTURE");
        i.putExtra("output", (Parcelable)this.image_uri);
        this.startActivityForResult(i, 1);
    }

    public void openGalleryIntent() {
        this.camaraGarantiasRetiradas = true;
        Intent pickPhotoIntent = new Intent("android.intent.action.GET_CONTENT");
        pickPhotoIntent.setType("image/*");
        pickPhotoIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        this.startActivityForResult(Intent.createChooser((Intent)pickPhotoIntent, (CharSequence)"Selecciona im\u00e1genes"), 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        block12: {
            block13: {
                block11: {
                    ClipData clipData;
                    block16: {
                        block14: {
                            String path;
                            block15: {
                                super.onActivityResult(requestCode, resultCode, data);
                                if (requestCode != 1 || resultCode != -1) break block12;
                                if (!this.camaraGarantiasRetiradas) break block13;
                                if (data == null) break block14;
                                clipData = data.getClipData();
                                if (clipData == null) break block15;
                                break block16;
                            }
                            Uri uri = data.getData();
                            if (uri == null || (path = RealPathUtil.getRealPath((Context)this.getActivity(), uri)) == null || this.pathsGarantiasRetiradas.contains(path)) break block11;
                            this.pathsGarantiasRetiradas.add(path);
                            Bitmap fullBitmap = BitmapFactory.decodeFile((String)path);
                            Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                            try {
                                File file = Utils.getBitmapFile(reduceBitmap, path);
                                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                                MultipartBody.Part body = MultipartBody.Part.createFormData((String)"garantia_retirada_0", (String)"0GA.jpeg", (RequestBody)requestFile);
                                if (!this.archivosGeneral.contains(body)) {
                                    this.archivosGeneral.add(body);
                                }
                                break block11;
                            }
                            catch (Exception e) {
                                Toast.makeText((Context)this.getActivity(), (CharSequence)e.getMessage(), (int)1).show();
                            }
                            break block11;
                        }
                        String path = RealPathUtil.getRealPath((Context)this.getActivity(), this.image_uri);
                        if (path == null || this.pathsGarantiasRetiradas.contains(path)) break block11;
                        this.pathsGarantiasRetiradas.add(path);
                        Bitmap fullBitmap = BitmapFactory.decodeFile((String)path);
                        Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                        try {
                            File file = Utils.getBitmapFile(reduceBitmap, path);
                            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                            MultipartBody.Part body = MultipartBody.Part.createFormData((String)"garantia_retirada_0", (String)"0GA.jpeg", (RequestBody)requestFile);
                            if (!this.archivosGeneral.contains(body)) {
                                this.archivosGeneral.add(body);
                            }
                            break block11;
                        }
                        catch (Exception e) {
                            Toast.makeText((Context)this.getActivity(), (CharSequence)e.getMessage(), (int)1).show();
                        }
                        break block11;
                    }
                    for (int i = 0; i < clipData.getItemCount(); ++i) {
                        String path;
                        Uri uri = clipData.getItemAt(i).getUri();
                        if (uri == null || (path = RealPathUtil.getRealPath((Context)this.getActivity(), uri)) == null || this.pathsGarantiasRetiradas.contains(path)) continue;
                        this.pathsGarantiasRetiradas.add(path);
                        Bitmap fullBitmap = BitmapFactory.decodeFile((String)path);
                        Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                        try {
                            File file = Utils.getBitmapFile(reduceBitmap, path);
                            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                            MultipartBody.Part body = MultipartBody.Part.createFormData((String)("garantia_retirada_" + i), (String)(i + "GA.jpeg"), (RequestBody)requestFile);
                            if (this.archivosGeneral.contains(body)) continue;
                            this.archivosGeneral.add(body);
                            continue;
                        }
                        catch (Exception e) {
                            Toast.makeText((Context)this.getActivity(), (CharSequence)e.getMessage(), (int)1).show();
                        }
                    }
                }
                this.banderaGarantiasRetiradas = this.pathsGarantiasRetiradas.size() - 1;
                HashSet<String> set = new HashSet<String>(this.pathsGarantiasRetiradas);
                this.pathsGarantiasRetiradas.clear();
                this.pathsGarantiasRetiradas.addAll(set);
                HashSet<MultipartBody.Part> setArchivos = new HashSet<MultipartBody.Part>(this.archivosGeneral);
                this.archivosGeneral.clear();
                this.archivosGeneral.addAll(setArchivos);
                prestamosAdapter.updateButtonText();
                if (prestamosAdapter == null) {
                    prestamosAdapter = new PrestamosAdapter((Context)this.getActivity(), this, prestamos, this.archivosGeneral, this.pathsGarantiasRetiradas, null, null);
                    recyclerView.setAdapter((RecyclerView.Adapter)prestamosAdapter);
                } else {
                    prestamosAdapter.addFilesAndPaths(this.archivosGeneral, this.pathsGarantiasRetiradas);
                    prestamosAdapter.notifyDataSetChanged();
                    prestamosAdapter.notifyDataSetChanged();
                }
            }
            this.camaraGarantiasRetiradas = false;
        }
    }

    public void compartirTexto(String titulo_ticket, String ruta_ticket, String Poblacion_ticket, String Nombre_ticket, String Atraso_ticket, String pago_ticket, String aviso, String aviso2, String empleado_ticket, String colocadora_ticket, String aval_ticket, String recargos_ticket, String monto_tot_ticket) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "\n";
            text = text + titulo_ticket + "\n";
            text = text + fechaConvert + "\n";
            text = text + ruta_ticket + "\n";
            text = text + Poblacion_ticket + "\n";
            text = text + colocadora_ticket + "\n";
            text = text + Nombre_ticket + "\n";
            text = text + aval_ticket + "\n";
            text = text + pago_ticket + "\n";
            text = text + Atraso_ticket + "\n";
            text = text + recargos_ticket + "\n";
            text = text + monto_tot_ticket + "\n";
            text = text + aviso + "\n";
            text = text + empleado_ticket + "\n";
            text = text + aviso2 + "\n";
            this.pdfFile = this.generarPDF(text, "");
            this.compartirPDF(this.pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void compartirTextoPago(Prestamo pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra, String tipo_ticket) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "--------------------------\n";
            text = text + "Folio: " + folio + "\n";
            text = text + fechaConvert + "\n";
            text = text + "Ruta: " + pago.getNombre_ruta() + "\n";
            text = text + "Poblacion: " + pago.getNombre_poblacion() + "\n";
            text = text + "Recibi de: " + pago.getNombre_completo() + "\n";
            text = text + "Cantidad: $" + recibido + "\n";
            text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
            if (pago_multa != "0.0") {
                text = text + "Multa: $" + pago_multa + "\n";
            }
            text = text + "Concepto: " + concepto + "\n";
            text = text + "--------------------------\n";
            this.pdfFile = this.generarPDF(text, tipo_ticket);
            this.compartirPDF(this.pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File generarPDF(String content, String tipo_ticket) throws IOException {
        this.pdfFile = tipo_ticket.equals("Pago") ? new File(this.getContext().getCacheDir(), "Recibo de pago.pdf") : new File(this.getContext().getCacheDir(), "Requerimiento de pago.pdf");
        PdfWriter writer = new PdfWriter(this.pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);
        Drawable drawable2 = this.getResources().getDrawable(2131231010);
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        ImageData imageData = ImageDataFactory.create((byte[])stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);
        document.add((IBlockElement)new Paragraph(content));
        document.close();
        return this.pdfFile;
    }

    private void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile((Context)this.getContext(), (String)(this.getContext().getApplicationContext().getPackageName() + ".provider"), (File)pdfFile);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)pdfUri);
            this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Compartir mediante"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startShimmer() {
        if (shimmer != null) {
            PrestamosFragment.startShimmer();
            shimmer.setVisibility(0);
            isShimmerActive = true;
        }
    }

    public static void stopShimmer() {
        if (shimmer != null) {
            shimmer.stopShimmer();
            shimmer.setVisibility(8);
            isShimmerActive = false;
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "PrestamosFragment";
        ruta_id = "";
        poblacion_id = "";
        modalidad_id = "1";
        this.retryCount = 0;
        this.retryCountPagos = 0;
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        prestamos = new ArrayList();
        pagos = new ArrayList();
        prestamosFiltrados = new ArrayList();
        this.pagoController = new PagoController((Context)this.getActivity());
        View dialogView4 = LayoutInflater.from((Context)this.getContext()).inflate(2131492945, null);
        this.btnCamGarantiasRetiradas = (Button)dialogView4.findViewById(2131296398);
        if (this.btnCamGarantiasRetiradas != null) {
            Log.d((String)"DEBUG", (String)"El bot\u00f3n es nulo");
        } else {
            Log.d((String)"DEBUG", (String)"El bot\u00f3n es nulo");
        }
        Bundle bundle = this.getArguments();
        this.pagosHechos = new ArrayList();
        this.configuracionSemanaController = new ConfiguracionSemanasController((Context)this.getActivity());
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.pagoController = new PagoController((Context)this.getActivity());
        shimmer = (ShimmerFrameLayout)view.findViewById(2131297035);
        recyclerView = (RecyclerView)view.findViewById(2131296984);
        svPrestamos = (TextInputEditText)view.findViewById(2131297084);
        shimmer.startShimmer();
        this.tvSeleccion = (TextView)this.getView().findViewById(2131297327);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.gruposAutoCompleteTextView = (TextView)view.findViewById(2131297297);
        this.modalidadesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296280);
        this.textViewMensajes = (TextView)this.getActivity().findViewById(2131296802);
        this.btnPagar = (Button)view.findViewById(2131296443);
        this.btnNoPagar = (Button)view.findViewById(2131296442);
        this.btnAdelantar = (Button)view.findViewById(2131296390);
        this.btnPagarConMulta = (Button)view.findViewById(2131296444);
        this.btnAplicar = (Button)view.findViewById(2131296396);
        this.btnAplicar.setOnClickListener(view1 -> {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
            View dialogView = inflater.inflate(2131492945, null);
            Spinner spinnerOptions = (Spinner)dialogView.findViewById(2131297057);
            Object[] opciones = new String[]{"", "Efectivo", "Transferencia", "Garant\u00eda"};
            ArrayAdapter adapter = new ArrayAdapter((Context)this.getActivity(), 17367048, opciones);
            adapter.setDropDownViewResource(0x1090009);
            spinnerOptions.setAdapter((SpinnerAdapter)adapter);
            TextView textPlaceholder2 = (TextView)dialogView.findViewById(2131297134);
            textPlaceholder2.setOnClickListener(v -> {
                textPlaceholder2.setVisibility(8);
                spinnerOptions.performClick();
            });
            AlertDialog dialog = new AlertDialog.Builder((Context)this.getActivity()).setView(dialogView).setTitle((CharSequence)"Aplicar acciones").setPositiveButton((CharSequence)"S\u00ed", (dialogInterface, i) -> {
                if (PrestamosFragment.prestamosAdapter.prestamosPagar.size() == 0 && PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.size() == 0 && PrestamosFragment.prestamosAdapter.prestamosNoPagar.size() == 0 && PrestamosFragment.prestamosAdapter.prestamosAdelantar.size() == 0) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)"Debes seleccionar al menos una semana", (int)0).show();
                } else {
                    String tipo_pago;
                    if (PrestamosFragment.prestamosAdapter.prestamosPagar.size() != 0) {
                        tipo_pago = (String)spinnerOptions.getSelectedItem();
                        Iterator<Prestamo> idsPrestamos = new ArrayList();
                        for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosPagar) {
                            idsPrestamos.add((Prestamo)((Object)Integer.valueOf(prestamo.getId())));
                        }
                        Map<Integer, String> prestamosConPagosAdelantados = this.obtenerPrestamosConPagosAdelantados((List<Integer>)((Object)idsPrestamos));
                        ArrayList<Prestamo> prestamosValidos = new ArrayList<Prestamo>();
                        for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosPagar) {
                            if (!prestamosConPagosAdelantados.containsKey(Integer.valueOf(prestamo.getId()))) {
                                prestamosValidos.add(prestamo);
                                continue;
                            }
                            prestamo.setSelectedPagar(false);
                        }
                        if (!prestamosConPagosAdelantados.isEmpty()) {
                            StringBuilder mensaje = new StringBuilder("Los siguientes pr\u00e9stamos tienen pagos adelantados y no ser\u00e1n procesados:\n");
                            for (Map.Entry<Integer, String> entry : prestamosConPagosAdelantados.entrySet()) {
                                mensaje.append("N\u00famero de Tarjet\u00f3n: ").append(entry.getValue()).append("\n");
                            }
                            new AlertDialog.Builder(this.requireContext()).setTitle((CharSequence)"Advertencia").setMessage((CharSequence)mensaje.toString()).setPositiveButton((CharSequence)"Aceptar", (dialogSA, which) -> dialogSA.dismiss()).setCancelable(false).show();
                        }
                        if (prestamosValidos.isEmpty()) {
                            this.btnPagar.setText((CharSequence)"");
                            PrestamosFragment.prestamosAdapter.prestamosPagar.clear();
                            return;
                        }
                        for (Prestamo prestamo : prestamosValidos) {
                            prestamo.setSelectedPagar(false);
                            this.pagar(prestamo, tipo_pago);
                        }
                        this.btnPagar.setText((CharSequence)"");
                        PrestamosFragment.prestamosAdapter.prestamosPagar.clear();
                    }
                    if (PrestamosFragment.prestamosAdapter.prestamosAdelantar.size() != 0) {
                        tipo_pago = (String)spinnerOptions.getSelectedItem();
                        for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosAdelantar) {
                            prestamo.setSelectedAdelantar(false);
                            this.pagoAdelantar(prestamo, tipo_pago);
                        }
                        this.btnAdelantar.setText((CharSequence)"");
                        PrestamosFragment.prestamosAdapter.prestamosAdelantar.clear();
                    }
                    if (PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.size() != 0) {
                        tipo_pago = (String)spinnerOptions.getSelectedItem();
                        for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosPagarConMulta) {
                            prestamo.setSelectedPagarConMulta(false);
                            this.pagarConMulta(prestamo, tipo_pago);
                        }
                        this.btnPagarConMulta.setText((CharSequence)"M");
                        PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.clear();
                    }
                    if (PrestamosFragment.prestamosAdapter.prestamosNoPagar.size() != 0) {
                        for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosNoPagar) {
                            prestamo.setSelectedNoPagar(false);
                            this.noPagar(prestamo);
                        }
                        this.btnNoPagar.setText((CharSequence)"");
                        PrestamosFragment.prestamosAdapter.prestamosNoPagar.clear();
                    }
                    if (!(modalidad_id.equals("") || ruta_id.equals("") || poblacion_id.equals("") || this.grupo.equals(""))) {
                        PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                    } else if (!(modalidad_id.equals("") || ruta_id.equals("") || poblacion_id.equals(""))) {
                        PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, "");
                    } else if (!modalidad_id.equals("") && !ruta_id.equals("")) {
                        PrestamosFragment.filtrarPrestamos(modalidad_id, "");
                    } else if (!modalidad_id.equals("")) {
                        PrestamosFragment.filtrarPrestamos(modalidad_id);
                    }
                    this.btnCancelar.setText((CharSequence)("Cancelar (" + (PrestamosFragment.prestamosAdapter.prestamosPagar.size() + PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.size() + PrestamosFragment.prestamosAdapter.prestamosNoPagar.size()) + ")"));
                    PrestamosFragment.prestamosAdapter.seleccionAdelantar = false;
                    PrestamosFragment.prestamosAdapter.seleccionPagar = false;
                    PrestamosFragment.prestamosAdapter.seleccionPagarConMulta = false;
                    PrestamosFragment.prestamosAdapter.seleccionNoPagar = false;
                    this.tvSeleccion.setText((CharSequence)"");
                }
            }).setNegativeButton((CharSequence)"No", (dialogInterface, i) -> {}).create();
            dialog.show();
        });
        this.btnCancelar = (Button)view.findViewById(2131296412);
        this.btnCancelar.setOnClickListener(view12 -> new MaterialAlertDialogBuilder((Context)this.getActivity()).setCancelable(false).setTitle((CharSequence)"Cancelar selecci\u00f3n").setMessage((CharSequence)"\u00bfEstas seguro de cancelar la selecci\u00f3n?").setPositiveButton((CharSequence)"S\u00ed", (dialogInterface, i) -> {
            if (PrestamosFragment.prestamosAdapter.prestamosPagar.size() != 0) {
                for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosPagar) {
                    prestamo.setSelectedPagar(false);
                }
                this.btnPagar.setText((CharSequence)"");
                PrestamosFragment.prestamosAdapter.prestamosPagar.clear();
            }
            if (PrestamosFragment.prestamosAdapter.prestamosAdelantar.size() != 0) {
                for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosAdelantar) {
                    prestamo.setSelectedAdelantar(false);
                }
                this.btnAdelantar.setText((CharSequence)"");
                PrestamosFragment.prestamosAdapter.prestamosAdelantar.clear();
            }
            if (PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.size() != 0) {
                for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosPagarConMulta) {
                    prestamo.setSelectedPagarConMulta(false);
                }
                this.btnPagarConMulta.setText((CharSequence)"M");
                PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.clear();
            }
            if (PrestamosFragment.prestamosAdapter.prestamosNoPagar.size() != 0) {
                for (Prestamo prestamo : PrestamosFragment.prestamosAdapter.prestamosNoPagar) {
                    prestamo.setSelectedNoPagar(false);
                }
                this.btnNoPagar.setText((CharSequence)"");
                PrestamosFragment.prestamosAdapter.prestamosNoPagar.clear();
            }
            if (!(modalidad_id.equals("") || ruta_id.equals("") || poblacion_id.equals("") || this.grupo.equals(""))) {
                PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
            } else if (!(modalidad_id.equals("") || ruta_id.equals("") || poblacion_id.equals(""))) {
                PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, "");
            } else if (!modalidad_id.equals("") && !ruta_id.equals("")) {
                PrestamosFragment.filtrarPrestamos(modalidad_id, "");
            } else if (!modalidad_id.equals("")) {
                PrestamosFragment.filtrarPrestamos(modalidad_id);
            }
            this.btnPagar.setText((CharSequence)"");
            this.btnPagarConMulta.setText((CharSequence)"M");
            this.btnNoPagar.setText((CharSequence)"");
            prestamosAdapter.notifyDataSetChanged();
            this.btnCancelar.setText((CharSequence)("Cancelar (" + (PrestamosFragment.prestamosAdapter.prestamosPagar.size() + PrestamosFragment.prestamosAdapter.prestamosPagarConMulta.size() + PrestamosFragment.prestamosAdapter.prestamosNoPagar.size()) + ")"));
            PrestamosFragment.prestamosAdapter.seleccionPagar = false;
            PrestamosFragment.prestamosAdapter.seleccionPagarConMulta = false;
            PrestamosFragment.prestamosAdapter.seleccionNoPagar = false;
            this.tvSeleccion.setText((CharSequence)"");
            PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
        }).setNegativeButton((CharSequence)"No", (dialogInterface, i) -> {}).show());
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int screenHeight = displayMetrics.heightPixels;
        double porcentajeGestor = 0.7;
        double porcentajeAdministrador = 0.55;
        if (this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            this.btnNoPagar.setVisibility(8);
            this.btnPagarConMulta.setVisibility(8);
            this.btnPagar.setVisibility(8);
            this.btnCancelar.setVisibility(8);
            this.btnAplicar.setVisibility(8);
            this.btnAdelantar.setVisibility(8);
            PrestamosFragment.recyclerView.getLayoutParams().height = (int)((double)screenHeight * porcentajeGestor);
        } else {
            PrestamosFragment.recyclerView.getLayoutParams().height = (int)((double)screenHeight * porcentajeAdministrador);
        }
        svPrestamos.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (modalidad_id != "" && ruta_id != "" && poblacion_id != "") {
                    PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, editable.toString());
                } else {
                    PrestamosFragment.this.filtrarPrestamosBusqueda(editable.toString());
                }
            }
        });
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        prestamosAdapter = new PrestamosAdapter((Context)this.getActivity(), this, prestamos, this.archivosGeneral, this.pathsGarantiasRetiradas, null, null);
        recyclerView.setAdapter((RecyclerView.Adapter)prestamosAdapter);
        recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 0);
        this.modalidades = new ArrayList();
        this.getModalidades();
        this.modalidadesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Modalidad modalidad = (Modalidad)PrestamosFragment.this.modalidadesAdapter.getItem(i);
                modalidad_id = modalidad.getId();
                ruta_id = "";
                PrestamosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                poblacion_id = "";
                PrestamosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                PrestamosFragment.this.grupo = "";
                PrestamosFragment.this.gruposAutoCompleteTextView.setText((CharSequence)"");
                svPrestamos.setText((CharSequence)"");
                PrestamosFragment.filtrarPrestamos(modalidad_id);
            }
        });
        this.modalidadesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                PrestamosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PrestamosFragment.this.backSpace = PrestamosFragment.this.previousLength > s.length();
                if (PrestamosFragment.this.backSpace && !modalidad_id.equals("")) {
                    modalidad_id = "";
                    PrestamosFragment.this.modalidadesAutoCompleteTextView.setText((CharSequence)"");
                    ruta_id = "";
                    PrestamosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    poblacion_id = "";
                    PrestamosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    PrestamosFragment.this.grupo = "";
                    PrestamosFragment.this.gruposAutoCompleteTextView.setText((CharSequence)"");
                    PrestamosFragment.filtrarPrestamos("1");
                }
            }
        });
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.grupos = new ArrayList();
        this.configuracionSemanas = new ArrayList();
        this.getConfiguracionSemana();
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)PrestamosFragment.this.rutasAdapter.getItem(i);
                ruta_id = ruta.getId();
                if (PrestamosFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    PrestamosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (PrestamosFragment.this.gruposAutoCompleteTextView.getText().toString().length() > 0) {
                    PrestamosFragment.this.gruposAutoCompleteTextView.setText((CharSequence)"");
                }
                PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, "");
                List poblacionesFiltro = PrestamosFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());
                PrestamosFragment.this.poblacionesAdapter = new ArrayAdapter(PrestamosFragment.this.getContext(), 17367050, poblacionesFiltro);
                PrestamosFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                PrestamosFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)PrestamosFragment.this.poblacionesAdapter);
            }
        });
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                PrestamosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PrestamosFragment.this.backSpace = PrestamosFragment.this.previousLength > s.length();
                if (PrestamosFragment.this.backSpace && !ruta_id.equals("")) {
                    ruta_id = "";
                    PrestamosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    poblacion_id = "";
                    PrestamosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    PrestamosFragment.this.grupo = "";
                    PrestamosFragment.this.gruposAutoCompleteTextView.setText((CharSequence)"");
                    svPrestamos.setText((CharSequence)"");
                    PrestamosFragment.filtrarPrestamos(modalidad_id);
                }
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones(ruta_id);
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener((adapterView, view13, i, l) -> {
            Poblacion poblacion = (Poblacion)this.poblacionesAdapter.getItem(i);
            poblacion_id = poblacion.getId();
            PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
        });
        this.poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                PrestamosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PrestamosFragment.this.backSpace = PrestamosFragment.this.previousLength > s.length();
                if (PrestamosFragment.this.backSpace && !poblacion_id.equals("")) {
                    poblacion_id = "";
                    PrestamosFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    PrestamosFragment.this.grupo = "";
                    PrestamosFragment.this.gruposAutoCompleteTextView.setText((CharSequence)"");
                    svPrestamos.setText((CharSequence)"");
                    PrestamosFragment.filtrarPrestamos(modalidad_id);
                }
            }
        });
        this.gruposAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                PrestamosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PrestamosFragment.this.backSpace = PrestamosFragment.this.previousLength > s.length();
                if (PrestamosFragment.this.backSpace) {
                    PrestamosFragment.this.grupo = "";
                    PrestamosFragment.this.gruposAutoCompleteTextView.setText((CharSequence)"");
                    PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id);
                } else if (s.length() > 0) {
                    PrestamosFragment.this.grupo = s.toString();
                    PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, s.toString());
                }
            }
        });
        svPrestamos.setText((CharSequence)"");
        if (this.getParentFragmentManager().findFragmentByTag("progressDialog") == null) {
            this.progressDialogFragment = new ProgressDialogFragment();
            this.progressDialogFragment.show(this.getParentFragmentManager(), "progressDialog");
        }
        if (!this.isNetworkAvailable()) {
            PrestamosWorker.isTaskPrestamosCompleted = true;
            PagosWorker.isTaskPagosCompleted = true;
            this.cargarPrestamosConsulta();
        } else {
            this.isTableEmpty("clientes", new IsTableEmptyCallback(){

                @Override
                public void onResult(boolean isClientesEmpty) {
                    if (isClientesEmpty) {
                        ClientesWorker.allDataLoadedClientes = false;
                        ClientesWorker.currentPageClientes = 0;
                        ClientesWorker.isTaskClientesCompleted = false;
                        ClientesWorker.enqueueWork(PrestamosFragment.this.requireContext());
                    } else {
                        ClientesWorker.allDataLoadedClientes = true;
                        ClientesWorker.currentPageClientes = 0;
                        ClientesWorker.isTaskClientesCompleted = false;
                        ClientesWorker.enqueueWork(PrestamosFragment.this.requireContext());
                    }
                    PrestamosFragment.this.checckBanderaClientes();
                }
            });
        }
    }

    public Map<Integer, String> obtenerPrestamosConPagosAdelantados(List<Integer> prestamoIds) {
        String ids = TextUtils.join((CharSequence)",", prestamoIds);
        String query = "SELECT DISTINCT p.prestamo_id, pr.numero_tarjeton FROM pagos p INNER JOIN prestamos pr ON p.prestamo_id = pr.id WHERE p.prestamo_id IN (" + ids + ") AND p.status = 4";
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query, null);
        HashMap<Integer, String> resultados = new HashMap<Integer, String>();
        while (cursor.moveToNext()) {
            int prestamoId = cursor.getInt(0);
            String numeroTarjeton = cursor.getString(1);
            resultados.put(prestamoId, numeroTarjeton);
        }
        cursor.close();
        db.close();
        return resultados;
    }

    public void onResume() {
        super.onResume();
        CurrentFragment.fragment = "PrestamosFragment";
        Log.d((String)"CurrentFragment", (String)("El fragmento actual es: " + CurrentFragment.fragment));
    }

    private void checckBanderaClientes() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (ClientesWorker.isTaskClientesCompleted) {
                this.isTableEmpty("avales", new IsTableEmptyCallback(){

                    @Override
                    public void onResult(boolean isAvalesEmpty) {
                        if (isAvalesEmpty) {
                            Log.d((String)"PRESTAMOS", (String)"AVALES EST\u00c1 VAC\u00cdA. Ejecutando AvalesWorker FULL...");
                            AvalesWorker.allDataLoadedAvales = false;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = false;
                            AvalesWorker.enqueueWork(PrestamosFragment.this.requireContext());
                        } else {
                            Log.d((String)"PRESTAMOS", (String)"AVALES NO EST\u00c1 VAC\u00cdA. Ejecutando AvalesWorker UPDATE EN PRESTAMOS...");
                            AvalesWorker.allDataLoadedAvales = true;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = false;
                            AvalesWorker.enqueueWork(PrestamosFragment.this.requireContext());
                        }
                        PrestamosFragment.this.checckBanderaAvales();
                    }
                });
            } else {
                Log.d((String)"PRESTAMOS", (String)"Tareas a\u00fan no completadas. Reintentando en 500ms... AvalesWorker");
                this.checckBanderaClientes();
            }
        }, 1000L);
    }

    private void checckBanderaAvales() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                Log.d((String)"PRESTAMOS", (String)"Ambas tareas completadas. Ejecutando l\u00f3gica de pr\u00e9stamos...");
                this.ejecutarLogicaPrestamos();
            } else {
                Log.d((String)"PRESTAMOS", (String)"Tareas a\u00fan no completadas. Reintentando en 500ms...");
                this.checckBanderaAvales();
            }
        }, 1000L);
    }

    private void ejecutarLogicaPrestamos() {
        this.countPrestamosInSQLite(this.requireContext(), 3, new CountPrestamosCallback(){

            @Override
            public void onResult(boolean result) {
                if (result) {
                    PrestamosWorker.currentPagePrestamos = 0;
                    PrestamosWorker.allDataLoadedPrestamos = false;
                    PrestamosWorker.isTaskPrestamosCompleted = false;
                    PrestamosWorker.enqueueWork(PrestamosFragment.this.requireContext());
                    new Handler(Looper.getMainLooper()).postDelayed(() -> PrestamosFragment.this.checkForUpdatesAndLoadCache(), 4000L);
                    Log.d((String)"PRESTAMOS", (String)"Cargando enqueueWork menos de 2 registros.");
                } else {
                    PrestamosWorker.currentPagePrestamos = 0;
                    PrestamosWorker.allDataLoadedPrestamos = true;
                    PrestamosWorker.isTaskPrestamosCompleted = false;
                    PrestamosWorker.enqueueWork(PrestamosFragment.this.requireContext());
                    new Handler(Looper.getMainLooper()).postDelayed(() -> PrestamosFragment.this.checkForUpdatesAndLoadCache(), 1000L);
                    Log.d((String)"PRESTAMOS", (String)"Cargando desde cach\u00e9, m\u00e1s de 2 registros. PrestamosWorker");
                }
            }
        });
    }

    private void isTableEmpty(String tableName, IsTableEmptyCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            boolean isEmpty = true;
            try {
                if (tableName.equalsIgnoreCase("clientes")) {
                    db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
                } else if (tableName.equalsIgnoreCase("avales")) {
                    db = new DatabaseHelper(this.requireContext()).getReadableDatabase();
                } else {
                    throw new IllegalArgumentException("Tabla desconocida: " + tableName);
                }
                cursor = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
                if (cursor != null && cursor.moveToFirst()) {
                    isEmpty = cursor.getInt(0) == 0;
                }
            }
            finally {
                executor.shutdown();
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
            boolean finalIsEmpty = isEmpty;
            this.getActivity().runOnUiThread(() -> callback.onResult(finalIsEmpty));
        });
    }

    private void cargarPagosDesdeSQLite() {
        DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String[] columnas = new String[]{"id", "prestamo_id", "cantidad_esperada_pago", "cantidad_normal_pagada", "cantidad_multa", "cantidad_pendiente", "cantidad_total_pagada", "concepto", "fecha_pago", "fecha_pago_realizada", "folio", "semana", "balance", "empleado_id", "status", "updated_at", "tipo_pago", "recuperado", "sinc"};
        Cursor cursor = db.query("pagos", columnas, null, null, null, null, "id DESC");
        pagos.clear();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Pago pago = new Pago(cursor.getString(cursor.getColumnIndexOrThrow("id")), cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id")), cursor.getString(cursor.getColumnIndexOrThrow("cantidad_esperada_pago")), cursor.getString(cursor.getColumnIndexOrThrow("cantidad_normal_pagada")), cursor.getString(cursor.getColumnIndexOrThrow("cantidad_multa")), cursor.getString(cursor.getColumnIndexOrThrow("cantidad_pendiente")), cursor.getString(cursor.getColumnIndexOrThrow("cantidad_total_pagada")), cursor.getString(cursor.getColumnIndexOrThrow("concepto")), cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago")), cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago_realizada")), cursor.getString(cursor.getColumnIndexOrThrow("folio")), cursor.getString(cursor.getColumnIndexOrThrow("semana")), cursor.getString(cursor.getColumnIndexOrThrow("balance")), cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")), cursor.getString(cursor.getColumnIndexOrThrow("status")), cursor.getString(cursor.getColumnIndexOrThrow("updated_at")), cursor.getString(cursor.getColumnIndexOrThrow("tipo_pago")), cursor.getString(cursor.getColumnIndexOrThrow("recuperado")), cursor.getString(cursor.getColumnIndexOrThrow("sinc")));
                pagos.add(pago);
            } while (cursor.moveToNext());
            cursor.close();
        }
        db.close();
        int totalRegistros = pagos.size();
        Log.d((String)"SQLitePrestamos", (String)("Total de Pagos registros en SQLite: " + totalRegistros));
        if (totalRegistros >= 0) {
            this.cargarPrestamosConsulta();
        } else {
            Log.d((String)"PrestamosFragment", (String)"No hay registros o la tarea no est\u00e1 completa.");
        }
    }

    private void cargarPrestamosDesdeSQLite() {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Log.d((String)"PagosWorker", (String)"Entro en cargarPrestamosDesdeSQLite()...................");
        String[] columnas = new String[]{"id", "numero_tarjeton", "updated_at"};
        Cursor cursor = null;
        cursor = this.sesion.getString("nombre_perfil", "").equals("VOCERO") || this.sesion.getString("nombre_perfil", "").equals("Administrador") || this.sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR") ? db.query("prestamos", columnas, "status != ?", new String[]{"-1"}, null, null, "id DESC") : db.query("prestamos", columnas, null, null, null, null, "id DESC");
        if (cursor == null) {
            Log.e((String)"PagosWorker", (String)"El cursor es null, no se pudo realizar la consulta a la base de datos.");
        }
        prestamos.clear();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String numeroTarjeton = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String updatedAt = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
                Log.d((String)"PagosWorker", (String)("Consulta de pr\u00e9stamo: ID = " + prestamoId + ", N\u00famero Tarjet\u00f3n = " + numeroTarjeton));
                Prestamo prestamo = new Prestamo(prestamoId, numeroTarjeton, updatedAt);
                prestamos.add(prestamo);
            } while (cursor.moveToNext());
            cursor.close();
        } else {
            Log.e((String)"PagosWorker", (String)"No se encontraron registros en la base de datos.");
        }
        int totalRegistros = prestamos.size();
        Log.d((String)"PagosWorker", (String)("Total de registros de pr\u00e9stamos encontrados: " + totalRegistros));
        if (totalRegistros >= 0 && PrestamosWorker.isTaskPrestamosCompleted) {
            PagosWorker.allPagos = new ArrayList<Integer>();
            prestamos.sort((p1, p2) -> {
                String updatedAt1 = p1.getUpdated_at();
                String updatedAt2 = p2.getUpdated_at();
                String prestamoId1 = p1.getId();
                String prestamoId2 = p2.getId();
                if (updatedAt1 == null && updatedAt2 == null) {
                    return 0;
                }
                if (updatedAt1 == null) {
                    return 1;
                }
                if (updatedAt2 == null) {
                    return -1;
                }
                return updatedAt2.compareTo(updatedAt1);
            });
            for (Prestamo prestamo : prestamos) {
                String prestamoId = prestamo.getId();
                if (prestamoId != null && !prestamoId.isEmpty()) {
                    try {
                        PagosWorker.allPagos.add(Integer.valueOf(prestamoId));
                    }
                    catch (NumberFormatException e) {
                        Log.e((String)"PagosWorker", (String)("ID de pr\u00e9stamo no es un n\u00famero v\u00e1lido: " + prestamoId));
                    }
                    continue;
                }
                Log.w((String)"PagosWorker", (String)"ID de pr\u00e9stamo nulo o vac\u00edo omitido.");
            }
            Log.d((String)"PagosWorker", (String)("Lista de pr\u00e9stamos enviados a allPagos: " + PagosWorker.allPagos.toString()));
        } else {
            Log.d((String)"PrestamosFragment", (String)"No hay registros o la tarea no est\u00e1 completa.");
        }
    }

    private void verificarPrestamosSinCliente() {
        String query;
        DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query = "SELECT prestamos.id, prestamos.cliente_id FROM prestamos LEFT JOIN clientes ON prestamos.cliente_id = clientes.id WHERE clientes.id IS NULL", null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("cliente_id"));
            }
            cursor.close();
        }
        db.close();
    }

    private void cargarPrestamosConsulta() {
        this.verificarPrestamosSinCliente();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            String nombrePerfil;
            String consultaTarjeton;
            DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Cursor cursorTarjeton = db.rawQuery(consultaTarjeton = "SELECT * FROM prestamos WHERE numero_tarjeton = ?", new String[]{"117801"});
            if (cursorTarjeton != null && cursorTarjeton.moveToFirst()) {
                do {
                    int idPrestamo = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("id"));
                    int clienteId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("cliente_id"));
                    String direccionCliente = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("direccion_cliente"));
                    String telefonoCliente = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("telefono_cliente"));
                    int rutaId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("ruta_id"));
                    int poblacionId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("poblacion_id"));
                    int colocadoraId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("colocadora_id"));
                    int avalId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("aval_id"));
                    int grupoPoblacion = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("grupo_poblacion"));
                    int montoPrestado = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("monto_prestado"));
                    int pagoSemanal = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("pago_semanal"));
                    String fechaPrestamo = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("fecha_prestamo"));
                    int modalidadSemanas = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("modalidad_semanas"));
                    int numeroTarjeton = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("numero_tarjeton"));
                    int status = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("status"));
                    String createdAt = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("created_at"));
                    String updatedAt = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("updated_at"));
                    Log.d((String)"SQLite", (String)("\ud83d\udccc Registro encontrado: ID: " + idPrestamo + ", Cliente ID: " + clienteId + ", Direcci\u00f3n Cliente: " + direccionCliente + ", Tel\u00e9fono Cliente: " + telefonoCliente + ", Ruta ID: " + rutaId + ", Poblaci\u00f3n ID: " + poblacionId + ", Colocadora ID: " + colocadoraId + ", Aval ID: " + avalId + ", Grupo Poblaci\u00f3n: " + grupoPoblacion + ", Monto Prestado: " + montoPrestado + ", Pago Semanal: " + pagoSemanal + ", Fecha Pr\u00e9stamo: " + fechaPrestamo + ", Modalidad Semanas: " + modalidadSemanas + ", N\u00famero Tarjet\u00f3n: " + numeroTarjeton + ", Status: " + status + ", Created At: " + createdAt + ", Updated At: " + updatedAt));
                    String consultaPagos = "SELECT * FROM pagos WHERE prestamo_id = ?";
                    Cursor cursorPagos = db.rawQuery(consultaPagos, new String[]{String.valueOf(idPrestamo)});
                    if (cursorPagos != null && cursorPagos.moveToFirst()) {
                        do {
                            int pagoId = cursorPagos.getInt(cursorPagos.getColumnIndexOrThrow("id"));
                            String cantidadEsperadaPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_esperada_pago"));
                            String cantidadNormalPagada = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_normal_pagada"));
                            String cantidadMulta = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_multa"));
                            String cantidadPendiente = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_pendiente"));
                            String cantidadTotalPagada = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_total_pagada"));
                            String concepto = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("concepto"));
                            String fechaPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("fecha_pago"));
                            String fechaPagoRealizada = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("fecha_pago_realizada"));
                            String folio = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("folio"));
                            String semana = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("semana"));
                            String balance = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("balance"));
                            String empleadoId = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("empleado_id"));
                            String statusPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("status"));
                            String updatedAtPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("updated_at"));
                            String tipoPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("tipo_pago"));
                            String recuperado = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("recuperado"));
                            String sinc = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("sinc"));
                            Log.d((String)"SQLite", (String)("\ud83d\udcb0 Pago encontrado: ID: " + pagoId + ", Cantidad Esperada Pago: " + cantidadEsperadaPago + ", Cantidad Normal Pagada: " + cantidadNormalPagada + ", Cantidad Multa: " + cantidadMulta + ", Cantidad Pendiente: " + cantidadPendiente + ", Cantidad Total Pagada: " + cantidadTotalPagada + ", Concepto: " + concepto + ", Fecha Pago: " + fechaPago + ", Fecha Pago Realizada: " + fechaPagoRealizada + ", Folio: " + folio + ", Semana: " + semana + ", Balance: " + balance + ", Empleado ID: " + empleadoId + ", Status: " + statusPago + ", Updated At: " + updatedAtPago + ", Tipo Pago: " + tipoPago + ", Recuperado: " + recuperado + ", Sinc: " + sinc));
                        } while (cursorPagos.moveToNext());
                        cursorPagos.close();
                        continue;
                    }
                    Log.d((String)"SQLite", (String)("\u26a0\ufe0f No se encontraron pagos para el pr\u00e9stamo con ID: " + idPrestamo));
                } while (cursorTarjeton.moveToNext());
                cursorTarjeton.close();
            } else {
                Log.d((String)"SQLite", (String)"\u26a0\ufe0f No se encontr\u00f3 un pr\u00e9stamo con Tarjet\u00f3n 117801 en la base de datos.");
            }
            if (this.sesion.getString("nombre_perfil", "").equals("VOCERO") || this.sesion.getString("nombre_perfil", "").equals("Administrador") || this.sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {
                String fechaActual = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date());
                Log.d((String)"PagosWorker", (String)("Fecha actual antes de actualizar: " + fechaActual));
                String selectQuery = "SELECT prestamos.id, prestamos.numero_tarjeton, pagos_max.ultima_fecha FROM prestamos JOIN (    SELECT prestamo_id, MAX(fecha_pago) AS ultima_fecha    FROM pagos GROUP BY prestamo_id ) pagos_max ON prestamos.id = pagos_max.prestamo_id WHERE DATE(pagos_max.ultima_fecha) < DATE('" + fechaActual + "') AND prestamos.status = 0";
                Cursor cursor3 = db.rawQuery(selectQuery, null);
                StringBuilder idsAActualizar = new StringBuilder();
                while (cursor3.moveToNext()) {
                    String prestamoId = cursor3.getString(cursor3.getColumnIndexOrThrow("id"));
                    String numero_tarjeton2 = cursor3.getString(cursor3.getColumnIndexOrThrow("numero_tarjeton"));
                    String ultimaFecha = cursor3.getString(cursor3.getColumnIndexOrThrow("ultima_fecha"));
                    idsAActualizar.append(prestamoId).append(", ");
                }
                Log.d((String)"PagosWorker", (String)("IDs a actualizar en idsAActualizar: " + idsAActualizar.toString()));
                cursor3.close();
                if (idsAActualizar.length() > 0) {
                    idsAActualizar.setLength(idsAActualizar.length() - 2);
                    Log.d((String)"PagosWorker", (String)("Actualizando los registros: " + idsAActualizar.toString()));
                    String updateQuery = "UPDATE prestamos SET status = -1 WHERE status = 0 AND id IN (" + idsAActualizar.toString() + ")";
                    db.execSQL(updateQuery);
                    Log.d((String)"PagosWorker", (String)"Actualizaci\u00f3n ejecutada.");
                } else {
                    Log.d((String)"PagosWorker", (String)"No hay registros para actualizar.");
                }
            }
            boolean filtrarPendientes = (nombrePerfil = this.sesion.getString("nombre_perfil", "")).equals("GESTOR") || nombrePerfil.equals("COBRADOR") || nombrePerfil.equals("JURIDICO");
            String query = "SELECT prestamos.id, prestamos.cliente_id, clientes.nombre_completo, clientes.direccion, clientes.telefono, clientes.garantias, prestamos.status, prestamos.fecha_prestamo, prestamos.monto_prestado, colocadoras.nombre_completo AS nombre_colocadora, avales.nombre_completo AS nombre_aval, avales.direccion AS direccion_aval, avales.telefono AS telefono_aval, rutas.nombre_ruta AS nombre_ruta, poblaciones.nombre_poblacion AS nombre_poblacion, poblaciones.monto_multa, configuracion_semanas.cantidad AS semanas, MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 14 and prestamos.modalidad_semanas = 1 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_14, MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 19 and prestamos.modalidad_semanas = 2 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_19, COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) as tiene_pendientes, COUNT(CASE WHEN pagos.status = 3 THEN pagos.id END) AS tiene_multas, COUNT(CASE WHEN pagos.folio is not null and pagos.folio != 0 THEN pagos.id END ) as tiene_folios, prestamos.created_at, prestamos.updated_at, prestamos.numero_tarjeton, prestamos.grupo_poblacion, avales.garantias AS garantias_aval, avales.otras_referencias  AS otras_referencias_aval, prestamos.pago_semanal, clientes.ruta_id, clientes.poblacion_id, prestamos.modalidad_semanas, prestamos.aval_id FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id LEFT JOIN colocadoras ON clientes.colocadora_id = colocadoras.id LEFT JOIN avales ON prestamos.aval_id = avales.id LEFT JOIN rutas ON clientes.ruta_id = rutas.id LEFT JOIN poblaciones ON clientes.poblacion_id = poblaciones.id LEFT JOIN configuracion_semanas ON prestamos.modalidad_semanas = configuracion_semanas.id LEFT JOIN pagos ON prestamos.id = pagos.prestamo_id ";
            if (this.sesion.getString("nombre_perfil", "").equals("VOCERO") || this.sesion.getString("nombre_perfil", "").equals("Administrador") || this.sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {
                query = query + " AND prestamos.status NOT IN (1, 2, -1) ";
            }
            query = query + " GROUP BY prestamos.id ";
            query = filtrarPendientes ? query + "HAVING COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) > 0 " : query + "HAVING COUNT(CASE WHEN pagos.status IN (0,-1) THEN pagos.id END) > 0 OR COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) > 0 AND COUNT(CASE WHEN pagos.status NOT IN (1,3) THEN pagos.id END) = 0 ";
            query = query + "ORDER BY prestamos.id DESC";
            Cursor cursor = db.rawQuery(query, null);
            prestamos.clear();
            if (cursor != null && cursor.moveToFirst()) {
                ArrayList<Prestamo> prestamosBatch = new ArrayList<Prestamo>();
                do {
                    String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                    String clienteId = cursor.getString(cursor.getColumnIndexOrThrow("cliente_id"));
                    String prestamoStat = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    String nombre_aval = cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval"));
                    String aval_id = cursor.getString(cursor.getColumnIndexOrThrow("aval_id"));
                    String numero_tarjeton = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    if (prestamoId != null && !prestamoId.isEmpty() && clienteId != null && !clienteId.isEmpty()) {
                        Prestamo prestamo = new Prestamo(prestamoId, clienteId, cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion")) : "", cursor.getString(cursor.getColumnIndexOrThrow("telefono")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono")) : "", cursor.getString(cursor.getColumnIndexOrThrow("garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("status")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("status")) : "", cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) : "", cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) : "", cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) : "", cursor.getString(cursor.getColumnIndexOrThrow("semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("semanas")) : "", cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("created_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("created_at")) : "", cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) : "", cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) : "", cursor.getString(cursor.getColumnIndexOrThrow("grupo_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo_poblacion")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) : "", cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) : "", cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) : "", cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) : "", cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) : "");
                        prestamosBatch.add(prestamo);
                        continue;
                    }
                    Log.e((String)"SQLitePrestamos", (String)"Registro con id o cliente_id nulo encontrado, omitiendo registro.");
                } while (cursor.moveToNext());
                prestamos.addAll(prestamosBatch);
                Log.d((String)"PrestamosWorker", (String)("Total de pr\u00e9stamos a\u00f1adidos: " + prestamosBatch.size()));
                cursor.close();
            }
            db.close();
            Log.d((String)"PrestamosWorker", (String)("Total de registros en LISTA prestamos DESPU\u00c9S DE CONSULTA FRAGMENT: " + prestamos));
            int totalRegistros = prestamos.size();
            Log.d((String)"SQLitePrestamos", (String)("Total de registros en SQLite EN CONSULTA SQL: " + totalRegistros));
            if (totalRegistros >= 0) {
                this.requireActivity().runOnUiThread(() -> {
                    PrestamosFragment.updateUIWithPrestamos(prestamos);
                    this.progressDialogFragment.dismissAllowingStateLoss();
                });
            } else {
                Log.d((String)"PrestamosFragment", (String)"No hay registros o la tarea no est\u00e1 completa.");
            }
            executor.shutdown();
        });
    }

    private void verificarConfiguracionSemanas(SQLiteDatabase db) {
        String query = "SELECT * FROM configuracion_semanas";
        Cursor cursor = db.rawQuery(query, null);
        if (cursor != null && cursor.moveToFirst()) {
            Log.d((String)"ConfigSemanas", (String)"Registros en la tabla configuracion_semanas:");
            do {
                int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String cantidad = cursor.getString(cursor.getColumnIndexOrThrow("cantidad"));
                Log.d((String)"ConfigSemanas", (String)("ID: " + id2 + ", Cantidad: " + cantidad));
            } while (cursor.moveToNext());
            cursor.close();
        } else {
            Log.d((String)"ConfigSemanas", (String)"La tabla configuracion_semanas est\u00e1 vac\u00eda o no se pudo encontrar.");
        }
    }

    private void countPagosInSQLite(Context context, int threshold, CountPagosCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            int totalPagos = 0;
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM pagos", null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    totalPagos = cursor.getInt(0);
                }
                cursor.close();
            }
            db.close();
            Log.d((String)"SQLite", (String)("Total registros en PAGOS SQLite: " + totalPagos));
            boolean result = totalPagos < threshold;
            this.getActivity().runOnUiThread(() -> callback.onResult(result));
            executor.shutdown();
        });
    }

    private void countPrestamosInSQLite(Context context, int threshold, CountPrestamosCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            int totalPrestamos = 0;
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM prestamos", null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    totalPrestamos = cursor.getInt(0);
                }
                cursor.close();
            }
            db.close();
            Log.d((String)"SQLite", (String)("Total registros en PRESTAMOS SQLite: " + totalPrestamos));
            executor.shutdown();
            boolean result = totalPrestamos < threshold;
            this.getActivity().runOnUiThread(() -> callback.onResult(result));
        });
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.requireContext().getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    private void checkForUpdatesAndLoadCache() {
        if (PrestamosWorker.isTaskPrestamosCompleted) {
            Log.d((String)"Prestamos", (String)("Cargando PrestamosWorker.isTaskPrestamosCompleted: " + PrestamosWorker.isTaskPrestamosCompleted));
            this.cargarPrestamosDesdeSQLite();
            this.countPagosInSQLite(this.requireContext(), 3, new CountPagosCallback(){

                @Override
                public void onResult(boolean result) {
                    if (result) {
                        PagosWorker.currentPagePagos = 0;
                        PagosWorker.allDataLoadedPagos = false;
                        PagosWorker.isTaskPagosCompleted = false;
                        PagosWorker.enqueueWork(PrestamosFragment.this.requireContext());
                        PrestamosFragment.this.getActivity().runOnUiThread(() -> new Handler(Looper.getMainLooper()).postDelayed(() -> PrestamosFragment.this.checkForUpdatesAndLoadCachePagos(), 2000L));
                        Log.d((String)"PAGOS", (String)"Cargando enqueueWork PAGOS..... menos de 100 registros.");
                    } else {
                        Log.e((String)"PagosWorker", (String)("LISTA DE PRESTAMOS PARA PAGOS..................: " + PagosWorker.allPagos));
                        PrestamosFragment.this.cargarPagosDesdeSQLite();
                        PagosWorker.currentPagePagos = 0;
                        PagosWorker.allDataLoadedPagos = true;
                        PagosWorker.isTaskPagosCompleted = false;
                        PagosWorker.enqueueWork(PrestamosFragment.this.requireContext());
                        Log.d((String)"PAGOS", (String)"MODO ACTUALIZAR: Cargando desde cach\u00e9 PAGOS..... m\u00e1s de 100 registros.");
                    }
                }
            });
            PrestamosWorker.isTaskPrestamosCompleted = false;
            this.retryCount = 0;
        } else if (this.retryCount < 80) {
            ++this.retryCount;
            new Handler(Looper.getMainLooper()).postDelayed(this::checkForUpdatesAndLoadCache, 1000L);
        } else {
            Log.d((String)"PRESTAMOS", (String)"N\u00famero m\u00e1ximo de reintentos alcanzado. No se puede cargar la cach\u00e9.");
        }
    }

    private void checkForUpdatesAndLoadCachePagos() {
        if (PagosWorker.isTaskPagosCompleted) {
            Log.d((String)"Pagos", (String)("Cargando PagosWorker.isTaskPagosCompleted: " + PagosWorker.isTaskPagosCompleted));
            this.cargarPagosDesdeSQLite();
            PagosWorker.isTaskPagosCompleted = false;
            this.retryCountPagos = 0;
        } else if (this.retryCountPagos < 80) {
            ++this.retryCountPagos;
            Log.d((String)"PRESTAMOS", (String)("N\u00famero m\u00e1ximo de reintentos EN PAGOS...................................... " + this.retryCountPagos));
            Log.d((String)"Pagos", (String)("N\u00famero m\u00e1ximo de reintentos EN PAGOS.............................: " + PagosWorker.isTaskPagosCompleted));
            new Handler(Looper.getMainLooper()).postDelayed(() -> this.checkForUpdatesAndLoadCachePagos(), 1000L);
        } else {
            Log.d((String)"PRESTAMOS", (String)"N\u00famero m\u00e1ximo de reintentos alcanzado. No se puede cargar la cach\u00e9.");
            this.cargarPagosDesdeSQLite();
        }
    }

    private void pagoAdelantar(final Prestamo prestamo, final String tipo_pago) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"pagarSiguienteAdelantado");
            data.put("prestamo_id", (Object)prestamo.getId());
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
            data.put("tipo_pago", (Object)tipo_pago);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String updatedAt = response.getJSONObject("data").getString("updated_at");
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                        PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "4", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "on", "", updatedAt);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity()) == 1 || ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity()) == 4) {
                    PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "4", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "off", "", "");
                    new MaterialAlertDialogBuilder((Context)PrestamosFragment.this.getActivity()).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"Se perdio la conexi\u00f3n y se guardar\u00f3n los datos en local").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
        requestQueue.add((Request)request);
    }

    private void pagar(final Prestamo prestamo, final String tipo_pago) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        if (this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            try {
                data.put("func", (Object)"pagarSiguiente");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("statusPago", (Object)"-1");
                data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                data.put("func", (Object)"pagarSiguiente");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String updatedAt = response.getJSONObject("data").getString("updated_at");
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                        if (PrestamosFragment.this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || PrestamosFragment.this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                            PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "-1", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "on", "", updatedAt);
                        } else {
                            PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "1", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "on", "", updatedAt);
                        }
                        if (!PrestamosFragment.this.isDialogShown) {
                            PrestamosFragment.this.isDialogShown = true;
                            LayoutInflater inflater = (LayoutInflater)PrestamosFragment.this.getContext().getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosFragment.this.getContext());
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> {
                                confirmationDialog.dismiss();
                                PrestamosFragment.this.isDialogShown = false;
                            }, 3000L);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity()) == 1 || ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity()) == 4) {
                    if (PrestamosFragment.this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || PrestamosFragment.this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                        PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "1", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "off", "", "");
                    } else {
                        PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "1", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "off", "", "");
                    }
                    if (!PrestamosFragment.this.isDialogShown) {
                        PrestamosFragment.this.isDialogShown = true;
                        LayoutInflater inflater = (LayoutInflater)PrestamosFragment.this.getContext().getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n y se guardar\u00f3n los datos en local");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosFragment.this.getContext());
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> {
                            confirmationDialog.dismiss();
                            PrestamosFragment.this.isDialogShown = false;
                        }, 3000L);
                    }
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
        requestQueue.add((Request)request);
    }

    @SuppressLint(value={"Range"})
    private void actualizarPagoEnSQLite(Prestamo prestamo, int prestamo_id, String semana, String tipo_pago, String status, String empleado_id, String concepto, String pagoSemanal, String pagoMultaLocal, String tipo_p, String off, String folio, String updatedAt) {
        int filasActualizadas;
        double pagoTotalNuevo;
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        if (semana == null || semana.isEmpty()) {
            String query = "SELECT semana FROM pagos WHERE prestamo_id = ? AND status == '0' ORDER BY CAST(semana AS INTEGER) ASC LIMIT 1";
            Cursor cursor = db.rawQuery(query, new String[]{String.valueOf(prestamo_id)});
            if (cursor != null && cursor.moveToFirst()) {
                semana = cursor.getString(cursor.getColumnIndex("semana"));
                Log.d((String)"SQLite", (String)("Semanas pendientes para este pr\u00e9stamo." + semana));
                cursor.close();
            } else {
                Log.d((String)"SQLite", (String)"No hay semanas pendientes para este pr\u00e9stamo.");
                semana = null;
            }
        }
        ContentValues valores = new ContentValues();
        valores.put("prestamo_id", Integer.valueOf(prestamo_id));
        valores.put("semana", semana);
        valores.put("tipo_pago", tipo_pago);
        valores.put("status", status);
        valores.put("empleado_id", empleado_id);
        valores.put("concepto", concepto);
        valores.put("cantidad_multa", pagoMultaLocal);
        if (!folio.isEmpty()) {
            valores.put("folio", folio);
        } else {
            valores.put("folio", "0");
        }
        long timestamp = System.currentTimeMillis();
        if (off.equals("off")) {
            valores.put("sinc", "1");
            Log.d((String)"PrestamosFragment", (String)"ENTRO EN MODO OFFLINE EL PAGO.......");
            timestamp += 10000L;
        } else {
            Log.d((String)"PrestamosFragment", (String)"ENTRO EN MODO CON CONEXION EL PAGO.......: ");
            timestamp -= 10000L;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(new Date(timestamp));
        valores.put("updated_at", formattedDate);
        if (!updatedAt.equals("")) {
            Log.d((String)"PrestamosFragment", (String)("ENTRO EN MODO CON CONEXION EL PAGO + regreso el tiempo del servidor.......: " + updatedAt));
            valores.put("updated_at", updatedAt);
        }
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate2 = sdf2.format(new Date(timestamp));
        valores.put("fecha_pago_realizada", formattedDate2);
        String cantidadNormalExistenteStr = "#.00";
        String queryNormal = "SELECT cantidad_normal_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
        Cursor cursorNormal = db.rawQuery(queryNormal, new String[]{String.valueOf(prestamo_id), semana});
        if (cursorNormal.moveToFirst()) {
            cantidadNormalExistenteStr = cursorNormal.getString(cursorNormal.getColumnIndex("cantidad_normal_pagada"));
        }
        cursorNormal.close();
        double cantidadNormalExistente = Utils.convertirDouble(cantidadNormalExistenteStr);
        double cantidadPagada = Utils.convertirDouble(pagoSemanal);
        double nuevaCantidadNormalPagada = cantidadNormalExistente + cantidadPagada;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String pagoNormalTotCantidad = decimalFormat.format(nuevaCantidadNormalPagada);
        valores.put("cantidad_normal_pagada", pagoNormalTotCantidad);
        valores.put("recuperado", pagoNormalTotCantidad);
        String cantidadTotalExistenteStr = "0.00";
        String queryTotal = "SELECT cantidad_total_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
        Cursor cursorTotal = db.rawQuery(queryTotal, new String[]{String.valueOf(prestamo_id), semana});
        if (cursorTotal.moveToFirst()) {
            cantidadTotalExistenteStr = cursorTotal.getString(cursorTotal.getColumnIndex("cantidad_total_pagada"));
        }
        cursorTotal.close();
        double cantidadTotalExistente = Utils.convertirDouble(cantidadTotalExistenteStr);
        double nuevaCantidadTotalPagada = pagoTotalNuevo = Utils.convertirDouble(pagoNormalTotCantidad) + Utils.convertirDouble(pagoMultaLocal);
        String pagoTotCantidad = decimalFormat.format(nuevaCantidadTotalPagada);
        valores.put("cantidad_total_pagada", pagoTotCantidad);
        valores.put("recuperado", pagoTotCantidad);
        double pago_semana = Utils.convertirDouble(prestamo.getPago_semanal());
        double pendiente_final = pago_semana - nuevaCantidadNormalPagada;
        if (pendiente_final > 0.0) {
            String pagoPenCantidad = decimalFormat.format(pendiente_final);
            valores.put("cantidad_pendiente", pagoPenCantidad);
        } else {
            valores.put("cantidad_pendiente", "0.00");
        }
        int tiene_multas = Integer.parseInt(prestamo.getTiene_multas());
        int tiene_pendientes = Integer.parseInt(prestamo.getTiene_pendientes());
        int tiene_folios = Integer.parseInt(prestamo.getTiene_folios());
        if ("14".equals(semana) || "19".equals(semana) || "15".equals(semana) || "20".equals(semana)) {
            Log.d((String)"DEBUG", (String)"Semana coincide con 14 o 19");
            if (tiene_multas == 0 && tiene_pendientes == 0 && tiene_folios == 0) {
                String ultimaSemana = "14".equals(semana) ? "15" : "20";
                DecimalFormat decimalFormat4 = new DecimalFormat("#.00");
                String cantidadPagadaFormatted = decimalFormat4.format(cantidadPagada);
                ContentValues valoresUltimaSemana = new ContentValues();
                valoresUltimaSemana.put("prestamo_id", Integer.valueOf(prestamo_id));
                valoresUltimaSemana.put("semana", ultimaSemana);
                valoresUltimaSemana.put("status", "2");
                valoresUltimaSemana.put("empleado_id", empleado_id);
                valoresUltimaSemana.put("concepto", "Semana omitida");
                valoresUltimaSemana.put("cantidad_normal_pagada", cantidadPagadaFormatted);
                valoresUltimaSemana.put("cantidad_total_pagada", cantidadPagadaFormatted);
                valoresUltimaSemana.put("recuperado", cantidadPagadaFormatted);
                valoresUltimaSemana.put("updated_at", formattedDate);
                valoresUltimaSemana.put("fecha_pago_realizada", formattedDate2);
                long insertResult = db.update("pagos", valoresUltimaSemana, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), ultimaSemana});
                if (insertResult != -1L) {
                    Log.d((String)"SQLite", (String)("Registro insertado en la \u00faltima semana de pago con status 2: Semana " + ultimaSemana));
                    ContentValues valoresPrestamo = new ContentValues();
                    valoresPrestamo.put("status", "1");
                    int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                    if (updatePrestamoResult > 0) {
                        Log.d((String)"SQLite", (String)("Status del pr\u00e9stamo actualizado a 1 para prestamo_id: " + prestamo_id));
                    } else {
                        Log.d((String)"SQLite", (String)("Error al actualizar el status del pr\u00e9stamo para prestamo_id: " + prestamo_id));
                    }
                } else {
                    Log.d((String)"SQLite", (String)"Error al insertar registro en la \u00faltima semana de pago");
                }
            }
            if (tiene_pendientes == 0 || "15".equals(semana) || "20".equals(semana)) {
                ContentValues valoresPrestamo = new ContentValues();
                valoresPrestamo.put("status", "1");
                int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                if (updatePrestamoResult > 0) {
                    Log.d((String)"SQLite", (String)("Status del pr\u00e9stamo actualizado a 1 para prestamo_id: " + prestamo_id));
                } else {
                    Log.d((String)"SQLite", (String)("Error al actualizar el status del pr\u00e9stamo para prestamo_id: " + prestamo_id));
                }
            }
        }
        if ((filasActualizadas = db.update("pagos", valores, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), semana})) > 0) {
            // empty if block
        }
        db.close();
    }

    private void pagarConMulta(final Prestamo prestamo, final String tipo_pago) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        if (this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            try {
                data.put("func", (Object)"pagarSiguienteConMulta");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            try {
                data.put("func", (Object)"pagarSiguienteConMulta");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("statusPago", (Object)"0");
                data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String updatedAt = response.getJSONObject("data").getString("updated_at");
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                        PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "3", PrestamosFragment.this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "50.00", tipo_pago, "on", "", updatedAt);
                        if (!PrestamosFragment.this.isDialogShown) {
                            PrestamosFragment.this.isDialogShown = true;
                            LayoutInflater inflater = (LayoutInflater)PrestamosFragment.this.getContext().getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosFragment.this.getContext());
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> {
                                confirmationDialog.dismiss();
                                PrestamosFragment.this.isDialogShown = false;
                            }, 3000L);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, error -> {
            if (ErrorChecker.checker(error, (Context)this.getActivity()) == 1 || ErrorChecker.checker(error, (Context)this.getActivity()) == 4) {
                this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "3", this.sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "50.00", tipo_pago, "off", "", "");
                if (!this.isDialogShown) {
                    LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
                    View dialogView = inflater.inflate(2131492944, null);
                    TextView messageText = (TextView)dialogView.findViewById(2131296802);
                    messageText.setText((CharSequence)"Se perdio la conexi\u00f3n y se guardar\u00f3n los datos en local");
                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(this.getContext());
                    builder.setView(dialogView);
                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();
                    new Handler().postDelayed(() -> {
                        confirmationDialog.dismiss();
                        this.isDialogShown = false;
                    }, 3000L);
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
        requestQueue.add((Request)request);
    }

    private void noPagar(final Prestamo prestamo) {
        VolleyS vs = VolleyS.getInstance((Context)this.getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"noPagarSiguiente");
            data.put("prestamo_id", (Object)prestamo.getId());
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String updatedAt = response.getJSONObject("data").getString("updated_at");
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                        PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", "", "-1", PrestamosFragment.this.sesion.getString("id", "0"), "", "0.00", "0.00", "", "on", "", updatedAt);
                        if (!PrestamosFragment.this.isDialogShown) {
                            PrestamosFragment.this.isDialogShown = true;
                            LayoutInflater inflater = (LayoutInflater)PrestamosFragment.this.getContext().getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosFragment.this.getContext());
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> {
                                confirmationDialog.dismiss();
                                PrestamosFragment.this.isDialogShown = false;
                            }, 3000L);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity()) == 1 || ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity()) == 4) {
                    PrestamosFragment.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", "", "-1", PrestamosFragment.this.sesion.getString("id", "0"), "", "0.00", "0.00", "", "off", "", "");
                    if (!PrestamosFragment.this.isDialogShown) {
                        LayoutInflater inflater = (LayoutInflater)PrestamosFragment.this.getContext().getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n y se guardar\u00f3n los datos en local");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosFragment.this.getContext());
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> {
                            confirmationDialog.dismiss();
                            PrestamosFragment.this.isDialogShown = false;
                        }, 3000L);
                    }
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
        requestQueue.add((Request)request);
    }

    public static void updateUIWithPrestamos(List<Prestamo> prestamos2) {
        if (prestamosAdapter == null) {
            Log.e((String)"PrestamosFragment", (String)"prestamosAdapter es nulo.");
            return;
        }
        if (prestamosAdapter != null && prestamos != null) {
            prestamosAdapter.setListaFiltrada(prestamos);
            prestamosAdapter.notifyDataSetChanged();
        }
        if (shimmer != null && shimmer.getVisibility() == 0) {
            Log.d((String)"PrestamosFragment", (String)"Deteniendo el shimmer...");
            PrestamosFragment.stopShimmer();
            isShimmerActive = false;
        }
        if (recyclerView != null) {
            recyclerView.setVisibility(0);
        }
    }

    public void refreshData(String modalidadId) {
        if (this.getParentFragmentManager().findFragmentByTag("progressDialog") == null) {
            this.progressDialogFragment = new ProgressDialogFragment();
            this.progressDialogFragment.setMessage("Sincronizando informaci\u00f3n...");
            this.progressDialogFragment.show(this.getParentFragmentManager(), "progressDialog");
        }
        WorkManager workManager = WorkManager.getInstance((Context)this.requireContext());
        workManager.cancelAllWorkByTag("PrestamosWorker");
        workManager.cancelAllWorkByTag("PagosWorker");
        this.retryCountPagos = 0;
        this.retryCount = 0;
        prestamos.clear();
        prestamosAdapter.clear();
        pagos.clear();
        PrestamosWorker.currentPagePrestamos = 0;
        PrestamosWorker.allDataLoadedPrestamos = false;
        PrestamosWorker.isTaskPrestamosCompleted = false;
        PagosWorker.isTaskPagosCompleted = false;
        PagosWorker.allDataLoadedPagos = false;
        PrestamosWorker.enqueueWork(this.requireContext());
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                PrestamosFragment.this.checkForUpdatesAndLoadCache();
            }
        }, 1000L);
        modalidad_id = "1";
        ruta_id = "";
        this.rutasAutoCompleteTextView.setText((CharSequence)"");
        poblacion_id = "";
        this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
        svPrestamos.setText((CharSequence)"");
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.networkChangeReceiver = new NetworkChangeReceiver(this);
    }

    public void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.getActivity().registerReceiver((BroadcastReceiver)this.networkChangeReceiver, filter);
    }

    public void onStop() {
        super.onStop();
        this.getActivity().unregisterReceiver((BroadcastReceiver)this.networkChangeReceiver);
        if (this.speedChecker != null) {
            this.speedChecker.stopChecking();
        }
        isSessionActive = false;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.speedChecker != null) {
            this.speedChecker.stopChecking();
        }
        isSessionActive = false;
    }

    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;
        if (this.speedChecker == null) {
            this.speedChecker = new NetworkSpeedChecker((Context)this.getActivity(), this.textViewMensajes);
        }
        if (isConnected) {
            this.speedChecker.startChecking();
            isSessionActive = true;
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            }
        } else {
            isSessionActive = false;
            shouldStartPolling = true;
            if (this.textViewMensajes != null) {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"\u00a1SIN INTERNET!");
            }
            if (this.speedChecker != null) {
                this.speedChecker.stopChecking();
            }
            this.speedChecker.stopChecking();
        }
    }

    private void hideTextViewAfterDelay() {
        if (this.textViewMensajes != null && this.textViewMensajes.getVisibility() == 0) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                this.textViewMensajes.setVisibility(0);
                this.textViewMensajes.setText((CharSequence)"");
            }, 3000L);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        isSessionActive = false;
    }

    public static void applyFilters() {
        String texto = svPrestamos.getText().toString();
        if (!(modalidad_id.equals("") || svPrestamos == null || ruta_id.equals("") || poblacion_id.equals(""))) {
            PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, texto);
            Log.d((String)"PRESTAMOS", (String)("filtro: " + modalidad_id + "/" + ruta_id + "/" + poblacion_id + "/" + texto));
        } else if (!(modalidad_id.equals("") || ruta_id.equals("") || poblacion_id.equals(""))) {
            PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, poblacion_id);
            Log.d((String)"PRESTAMOS", (String)("filtro: " + modalidad_id + "/" + ruta_id + "/" + poblacion_id));
        } else if (!modalidad_id.equals("") && !ruta_id.equals("")) {
            PrestamosFragment.filtrarPrestamos(modalidad_id, ruta_id, "");
            Log.d((String)"PRESTAMOS", (String)("filtro: " + modalidad_id + "/" + ruta_id));
        } else if (!modalidad_id.equals("")) {
            PrestamosFragment.filtrarPrestamos(modalidad_id);
            Log.d((String)"PRESTAMOS", (String)("filtro: " + modalidad_id));
        } else if (!modalidad_id.equals("") && svPrestamos != null) {
            PrestamosFragment.filtrarPrestamos(modalidad_id, texto);
            Log.d((String)"PRESTAMOS", (String)("filtro: " + modalidad_id + "/" + texto));
        }
    }

    private void getModalidades() {
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        this.modalidades.add(modalidad15);
        this.modalidades.add(modalidad20);
        this.modalidadesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.modalidades);
        this.modalidadesAutoCompleteTextView.setThreshold(1);
        this.modalidadesAutoCompleteTextView.setAdapter(this.modalidadesAdapter);
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
        if (this.rutaController.obtener().size() == 0) {
            Log.d((String)"getRutas", (String)"No se encontraron rutas guardadas localmente. Solicitando desde el servidor.");
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
                Log.d((String)"getRutas", (String)("JSON enviado al servidor: " + data.toString()));
            }
            catch (JSONException e) {
                e.printStackTrace();
                Log.e((String)"getRutas", (String)("Error al crear JSON: " + e.getMessage()));
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    Log.d((String)"getRutas", (String)("Respuesta del servidor: " + response.toString()));
                    try {
                        JSONArray data = response.getJSONArray("data");
                        Log.d((String)"getRutas", (String)("Cantidad de rutas recibidas: " + data.length()));
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Log.d((String)"getRutas", (String)("Ruta JSON recibida: " + obj.toString()));
                            Gson gson = new Gson();
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            PrestamosFragment.this.rutas.add(ruta);
                            PrestamosFragment.this.rutaController.nueva(ruta);
                            Log.d((String)"getRutas", (String)("Ruta a\u00f1adida: " + ruta.toString()));
                        }
                        PrestamosFragment.this.rutasAdapter = new ArrayAdapter(PrestamosFragment.this.getContext(), 17367050, (List)PrestamosFragment.this.rutas);
                        PrestamosFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        PrestamosFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)PrestamosFragment.this.rutasAdapter);
                        Log.d((String)"getRutas", (String)("Adaptador configurado con " + PrestamosFragment.this.rutas.size() + " rutas."));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Log.e((String)"getRutas", (String)("Error al procesar respuesta del servidor: " + e.getMessage()));
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.e((String)"getRutas", (String)("Error en la solicitud de rutas: " + error.getMessage()));
                    ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 3, 1.0f));
            this.requestQueue.add((Request)request);
            Log.d((String)"getRutas", (String)"Solicitud enviada al servidor.");
        } else {
            Log.d((String)"getRutas", (String)"Recuperando rutas guardadas localmente.");
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            Log.d((String)"getRutas", (String)("Cantidad de rutas locales encontradas: " + rutasGuardadas.size()));
            for (Ruta ruta : rutasGuardadas) {
                Log.d((String)"getRutas", (String)("Ruta local encontrada: " + ruta.toString()));
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
                Log.d((String)"getRutas", (String)("Ruta a\u00f1adida tras filtrar: " + ruta));
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
            Log.d((String)"getRutas", (String)("Adaptador configurado con " + this.rutas.size() + " rutas locales."));
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            PrestamosFragment.this.poblaciones.add(poblacion);
                            PrestamosFragment.this.poblacionController.nueva(poblacion);
                        }
                        PrestamosFragment.this.poblacionesAdapter = new ArrayAdapter(PrestamosFragment.this.getContext(), 17367050, (List)PrestamosFragment.this.poblaciones);
                        PrestamosFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        PrestamosFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)PrestamosFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getGrupos() {
        this.vs = VolleyS.getInstance(this.getContext());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"grupos");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    if (data.length() > 0) {
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Grupo grupo = (Grupo)gson.fromJson(obj.toString(), Grupo.class);
                            PrestamosFragment.this.grupos.add(grupo);
                        }
                    } else {
                        Toast.makeText((Context)PrestamosFragment.this.getActivity(), (CharSequence)"La poblaci\u00f3n seleccionada no tiene grupos", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    private void filtrarPrestamosBusqueda(String text) {
        prestamosFiltrados = new ArrayList();
        prestamosFiltrados.clear();
        if (prestamosFiltrados.size() == 0) {
            for (Prestamo prestamo : prestamos) {
                String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
                if (!prestamo.getNumero_tarjeton().toLowerCase().contains(text.toLowerCase()) && !prestamo.getNombre_completo().toLowerCase().contains(text.toLowerCase()) && !texto_filtro.toLowerCase().contains(text.toLowerCase())) continue;
                prestamosFiltrados.add(prestamo);
            }
            if (!prestamosFiltrados.isEmpty()) {
                prestamosAdapter.setListaFiltrada(prestamosFiltrados);
            }
        } else {
            prestamosFiltradosNombres = new ArrayList();
            for (Prestamo prestamo : prestamosFiltrados) {
                String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
                if (!prestamo.getNumero_tarjeton().toLowerCase().contains(text.toLowerCase()) && !prestamo.getNombre_completo().toLowerCase().contains(text.toLowerCase()) && !texto_filtro.toLowerCase().contains(text.toLowerCase())) continue;
                prestamosFiltradosNombres.add(prestamo);
            }
            if (!prestamosFiltradosNombres.isEmpty()) {
                prestamosAdapter.setListaFiltrada(prestamosFiltradosNombres);
            }
        }
    }

    private static void filtrarPrestamos(String modalidad_id, String ruta_id, String poblacion_id, String text) {
        prestamosFiltrados = new ArrayList();
        for (Prestamo prestamo : prestamos) {
            boolean cumpleCondiciones;
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            boolean bl = cumpleCondiciones = prestamo.getModalidad_semanas().equals(modalidad_id) && prestamo.getRuta_id().equals(ruta_id) && prestamo.getPoblacion_id().equals(poblacion_id);
            if (!text.isEmpty()) {
                boolean bl2 = cumpleCondiciones = cumpleCondiciones && prestamo.getNombre_completo().toLowerCase().contains(text.toLowerCase()) || texto_filtro.toLowerCase().contains(text.toLowerCase());
            }
            if (!cumpleCondiciones) continue;
            prestamosFiltrados.add(prestamo);
        }
        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        } else {
            prestamosAdapter.setListaFiltrada(new ArrayList<Prestamo>());
        }
    }

    private static void filtrarPrestamos(String modalidad_id) {
        prestamosFiltrados = new ArrayList();
        prestamosFiltrados.clear();
        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            if (!prestamo.getModalidad_semanas().equals(modalidad_id)) continue;
            prestamosFiltrados.add(prestamo);
        }
        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        }
    }

    private static void filtrarPrestamos(String modalidad_id, String ruta_id, String text) {
        prestamosFiltrados = new ArrayList();
        prestamosFiltrados.clear();
        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            if (!prestamo.getModalidad_semanas().equals(modalidad_id) || !prestamo.getRuta_id().equals(ruta_id)) continue;
            prestamosFiltrados.add(prestamo);
        }
        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        }
    }

    private static void filtrarPrestamos(String modalidad_id, String text) {
        prestamosFiltrados.clear();
        prestamosFiltrados = new ArrayList();
        prestamosFiltrados.clear();
        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            if (!prestamo.getModalidad_semanas().equals(modalidad_id)) continue;
            prestamosFiltrados.add(prestamo);
        }
        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        }
    }

    public void getConfiguracionSemana() {
        Log.d((String)"DEBUG", (String)"Entro en getConfiguracionSemana()............");
        if (this.configuracionSemanaController.obtener().size() >= 0) {
            Log.d((String)"DEBUG", (String)"Entro en configuracionSemanaController().size() >= 0............");
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"indexApp_UpdConfiguraciones");
            }
            catch (JSONException e) {
                Log.d((String)"DEBUG", (String)("Error al crear el JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = response.getJSONArray("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            ConfiguracionSemana configuracion = (ConfiguracionSemana)gson.fromJson(obj.toString(), ConfiguracionSemana.class);
                            PrestamosFragment.this.configuracionSemanas.add(configuracion);
                            PrestamosFragment.this.configuracionSemanaController.nueva(configuracion);
                        }
                    }
                    catch (JSONException e) {
                        Log.d((String)"DEBUG", (String)("Error en el procesamiento de la respuesta: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.d((String)"DEBUG", (String)"Entro en request ERROR getConfiguracionSemana!!!!!............");
                    if (error.networkResponse != null) {
                        int statusCode = error.networkResponse.statusCode;
                        Log.d((String)"DEBUG", (String)("HTTP Status Code: " + statusCode));
                        String responseBody = new String(error.networkResponse.data);
                        Log.d((String)"DEBUG", (String)("Response Body: " + responseBody));
                    } else {
                        Log.d((String)"DEBUG", (String)"No hay respuesta del servidor.");
                    }
                    ErrorChecker.checker(error, (Context)PrestamosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            Log.d((String)"DEBUG", (String)"No hay configuraciones disponibles en configuracionSemanaController.");
        }
    }

    static {
        modalidad_id = "1";
        ruta_id = "";
        poblacion_id = "";
        shouldStartPolling = true;
        isShimmerActive = false;
        isSessionActive = true;
    }

    public static interface IsTableEmptyCallback {
        public void onResult(boolean var1);
    }

    private static interface CountPrestamosCallback {
        public void onResult(boolean var1);
    }

    private static interface CountPagosCallback {
        public void onResult(boolean var1);
    }
}

