/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.prestamos.crear;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.net.ParseException;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.Navigation;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.PrestamoController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.prestamos.crear.PrestamosCrearViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class PrestamosCrearFragment
extends Fragment {
    private PrestamosCrearViewModel mViewModel;
    private TextInputLayout tlFechaGrupo;
    private TextInputLayout tlGrupo;
    private TextInputLayout tlMonto;
    private TextInputLayout tlModalidad;
    private TextInputLayout tlPagoSemana;
    private TextInputLayout tlTarjeton;
    private TextInputLayout tlNombreAvalNuevo;
    private TextInputLayout tlTelefonoAval;
    private TextInputLayout tlDireccionAval;
    private TextInputLayout tlRuta;
    private TextInputLayout tlPoblacion;
    private TextInputLayout tlColocadora;
    private TextInputLayout tlOtrasReferenciasAval;
    private TextInputLayout tlGarantiasAval;
    private AutoCompleteTextView acModalidad;
    private Button btnRegistrarPrestamo;
    private Button btnSubirFotos;
    private Uri image_uri;
    private Uri uri;
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private int banderaGarantiasAval;
    private int banderaComprobantesAval;
    ArrayList<Modalidad> modalidades = new ArrayList();
    private ArrayAdapter<Modalidad> modalidadesAdapter;
    private String modalidad_id = "";
    private String cliente_id;
    private String aval_id;
    private String abono;
    private String tipo_abono;
    private String por_cada;
    private int previousLength;
    private boolean backSpace;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private AvalController avalController;
    private ClienteController clienteController;
    private PrestamoController prestamoController;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;
    private String ruta_id = "";
    private String poblacion_id = "";
    private String colocadora_id = "";
    String lat = "";
    String lgt = "";
    private SharedPreferences sesion;
    private TextView tvFechaGrupoAnt;
    private TextView tvGrupoAnt;
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();

    public static PrestamosCrearFragment newInstance() {
        return new PrestamosCrearFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(2131492970, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "PrestamosCrearFragment";
        this.prestamoController = new PrestamoController((Context)this.getActivity());
        this.tlFechaGrupo = (TextInputLayout)view.findViewById(2131297179);
        this.tlGrupo = (TextInputLayout)view.findViewById(2131297188);
        this.tlMonto = (TextInputLayout)view.findViewById(2131297197);
        this.tlModalidad = (TextInputLayout)view.findViewById(2131297195);
        this.tlPagoSemana = (TextInputLayout)view.findViewById(2131297215);
        this.tlTarjeton = (TextInputLayout)view.findViewById(2131297233);
        this.tlTelefonoAval = (TextInputLayout)view.findViewById(2131297235);
        this.tlDireccionAval = (TextInputLayout)view.findViewById(2131297172);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297217);
        this.tlColocadora = (TextInputLayout)view.findViewById(2131297161);
        this.tlOtrasReferenciasAval = (TextInputLayout)view.findViewById(2131297209);
        this.tlGarantiasAval = (TextInputLayout)view.findViewById(2131297184);
        this.tvFechaGrupoAnt = (TextView)view.findViewById(2131297289);
        this.tvGrupoAnt = (TextView)view.findViewById(2131297298);
        this.acModalidad = (AutoCompleteTextView)view.findViewById(2131296280);
        this.btnRegistrarPrestamo = (Button)view.findViewById(2131296449);
        this.btnSubirFotos = (Button)view.findViewById(2131296451);
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        Bundle args = this.getArguments();
        String personJsonString = args.getString("cliente");
        Cliente cliente = (Cliente)Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
        if (cliente != null) {
            Log.d((String)"DEBUG", (String)("Datos del cliente: " + Utils.getGsonParser().toJson((Object)cliente)));
        } else {
            Log.d((String)"DEBUG", (String)"El objeto Cliente es nulo. Verifica la cadena JSON de entrada.");
        }
        String fecha = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date());
        this.aval_id = cliente.getAval_id();
        this.cliente_id = cliente.getId();
        Log.d((String)"Success", (String)("Cliente con aval en cliente tomado con id: " + this.aval_id));
        Log.d((String)"Success", (String)("CLiente tomado con id: " + this.cliente_id));
        this.getGrupoPoblacion(cliente.getPoblacion_cliente());
        this.tvFechaGrupoAnt.setText((CharSequence)("Fecha grupo ant. : " + cliente.getFecha_prestamo()));
        this.tvGrupoAnt.setText((CharSequence)("Grupo ant. : " + cliente.getGrupo_anterior()));
        this.tlFechaGrupo.getEditText().setText((CharSequence)fecha);
        this.getSemanasPendientes(this.cliente_id);
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.colocadoras = new ArrayList();
        this.modalidades = new ArrayList();
        this.getModalidades();
        this.acModalidad.setOnItemClickListener((adapterView, view1, i, l) -> {
            Modalidad modalidad = (Modalidad)this.modalidadesAdapter.getItem(i);
            this.tlMonto.getEditText().getText().clear();
            this.tlPagoSemana.getEditText().getText().clear();
            this.tlMonto.setError(null);
            this.modalidad_id = modalidad.getId();
            this.abono = modalidad.getCantidad_abono();
            this.tipo_abono = modalidad.getTipo_cantidad();
            this.por_cada = modalidad.getPor_cada() != null ? modalidad.getPor_cada() : "";
        });
        this.acModalidad.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                PrestamosCrearFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PrestamosCrearFragment.this.backSpace = PrestamosCrearFragment.this.previousLength > s.length();
                if (PrestamosCrearFragment.this.backSpace && !PrestamosCrearFragment.this.modalidad_id.equals("")) {
                    PrestamosCrearFragment.this.acModalidad.setText((CharSequence)"");
                    PrestamosCrearFragment.this.modalidad_id = "";
                    PrestamosCrearFragment.this.tlMonto.getEditText().getText().clear();
                    PrestamosCrearFragment.this.tlPagoSemana.getEditText().getText().clear();
                }
            }
        });
        this.tlMonto.getEditText().addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (!PrestamosCrearFragment.this.modalidad_id.equals("")) {
                    PrestamosCrearFragment.this.tlMonto.setError(null);
                    if (editable.toString().length() > 0) {
                        if (PrestamosCrearFragment.this.tipo_abono.equals("%")) {
                            int pago_semana = Integer.parseInt(editable.toString()) * Integer.parseInt(PrestamosCrearFragment.this.abono) / 100;
                            PrestamosCrearFragment.this.tlPagoSemana.getEditText().setText((CharSequence)String.valueOf(pago_semana));
                        } else if (PrestamosCrearFragment.this.tipo_abono.equals("$")) {
                            int pago_semana = Integer.parseInt(PrestamosCrearFragment.this.abono) * (Integer.parseInt(editable.toString()) / Integer.parseInt(PrestamosCrearFragment.this.por_cada));
                            PrestamosCrearFragment.this.tlPagoSemana.getEditText().setText((CharSequence)String.valueOf(pago_semana));
                        }
                    }
                } else {
                    PrestamosCrearFragment.this.tlMonto.getEditText().getText().clear();
                    PrestamosCrearFragment.this.tlMonto.setError((CharSequence)"Ingresa una modalidad");
                }
            }
        });
        this.tlFechaGrupo.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha inicio de grupo");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(PrestamosCrearFragment.this.getFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Object selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date((Long)selection + (long)offsetFromUTC);
                        PrestamosCrearFragment.this.tlFechaGrupo.getEditText().setText((CharSequence)simpleFormat.format(date));
                    }
                });
            }
        });
        this.btnRegistrarPrestamo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Validator.fieldValidation(PrestamosCrearFragment.this.tlFechaGrupo, "Ingresa una fecha") && Validator.fieldValidation(PrestamosCrearFragment.this.tlGrupo, "Ingresa un grupo") && Validator.fieldValidation(PrestamosCrearFragment.this.tlMonto, "Ingresa una monto") && Validator.fieldValidation(PrestamosCrearFragment.this.tlModalidad, "Ingresa una modalidad") && Validator.fieldValidation(PrestamosCrearFragment.this.tlPagoSemana, "Ingresa un pago por semana") && Validator.fieldValidation(PrestamosCrearFragment.this.tlTarjeton, "Ingresa un tarjet\u00f3n")) {
                    PrestamosCrearFragment.this.crearPrestamo(PrestamosCrearFragment.this.cliente_id, PrestamosCrearFragment.this.aval_id, PrestamosCrearFragment.this.tlMonto.getEditText().getText().toString(), PrestamosCrearFragment.this.tlPagoSemana.getEditText().getText().toString(), PrestamosCrearFragment.this.tlFechaGrupo.getEditText().getText().toString(), PrestamosCrearFragment.this.modalidad_id, "0", PrestamosCrearFragment.this.tlTarjeton.getEditText().getText().toString(), PrestamosCrearFragment.this.tlGrupo.getEditText().getText().toString(), PrestamosCrearFragment.this.tlFechaGrupo.getEditText().getText().toString());
                }
            }
        });
    }

    private void getModalidades() {
        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        modalidad15.setInteres("40");
        modalidad15.setSemana_renovacion("10");
        modalidad15.setCantidad_abono("10");
        modalidad15.setTipo_cantidad("%");
        modalidad15.setDe("Monto prestado");
        modalidad15.setAbono_descripcion("10% de Monto prestado");
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        modalidad20.setInteres("55");
        modalidad20.setSemana_renovacion("15");
        modalidad20.setCantidad_abono("80");
        modalidad20.setTipo_cantidad("$");
        modalidad20.setPor_cada("1000");
        modalidad20.setAbono_descripcion("$80 por cada $1000");
        this.modalidades.add(modalidad15);
        this.modalidades.add(modalidad20);
        this.modalidadesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.modalidades);
        this.acModalidad.setThreshold(1);
        this.acModalidad.setAdapter(this.modalidadesAdapter);
    }

    private void crearPrestamo(String cliente_id, String aval_id, String monto_prestado, String pago_semanal, String fecha_prestamo, String modalidad, String monto_prestado_intereses, String tarjeton, String grupo, String fecha_inicio_grupo) {
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.registrarPrestamo(cliente_id, aval_id, monto_prestado, pago_semanal, fecha_prestamo, modalidad, monto_prestado_intereses, tarjeton, grupo, fecha_inicio_grupo, dialog);
    }

    private void registrarPrestamo(final String cliente_id, final String aval_id, final String monto_prestado, final String pago_semanal, final String fecha_prestamo, final String modalidad, final String monto_prestado_intereses, final String tarjeton, final String grupo, final String fecha_inicio_grupo, final ProgressDialog dialog) {
        JSONObject dataPrestamo = new JSONObject();
        try {
            dataPrestamo.put("func", (Object)"create");
            dataPrestamo.put("cliente_id", (Object)cliente_id);
            dataPrestamo.put("aval_id", (Object)aval_id);
            dataPrestamo.put("monto_prestado", (Object)monto_prestado);
            dataPrestamo.put("pago_semanal", (Object)pago_semanal);
            dataPrestamo.put("fecha_prestamo", (Object)fecha_prestamo);
            dataPrestamo.put("modalidad", (Object)modalidad);
            dataPrestamo.put("tarjeton", (Object)tarjeton);
            dataPrestamo.put("grupo", (Object)grupo);
            dataPrestamo.put("fecha_inicio_grupo", (Object)fecha_inicio_grupo);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest requestPrestamo = new JsonObjectRequest(1, API.urlPrestamos, dataPrestamo, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String prestamoID = response.getJSONObject("data").getString("prestamo_id");
                        Log.d((String)"IDprestamo", (String)("ID del servidor del prestamo.............." + prestamoID));
                        Toast.makeText((Context)PrestamosCrearFragment.this.getActivity(), (CharSequence)"Se ha registrado el pr\u00e9stamo", (int)1).show();
                        PrestamosCrearFragment.this.guardarPrestamoSQLite(cliente_id, aval_id, monto_prestado, pago_semanal, fecha_prestamo, modalidad, monto_prestado_intereses, tarjeton, grupo, fecha_inicio_grupo, "on", prestamoID);
                        dialog.dismiss();
                        Navigation.findNavController((Activity)PrestamosCrearFragment.this.getActivity(), (int)2131296862).navigate(2131296849);
                    }
                }
                catch (JSONException e) {
                    dialog.dismiss();
                    e.printStackTrace();
                    Toast.makeText((Context)PrestamosCrearFragment.this.getActivity(), (CharSequence)"Error al procesar datos del servidor", (int)1).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.dismiss();
                if (ErrorChecker.checker(error, (Context)PrestamosCrearFragment.this.getActivity()) == 1 || ErrorChecker.checker(error, (Context)PrestamosCrearFragment.this.getActivity()) == 4) {
                    PrestamosCrearFragment.this.guardarPrestamoSQLite(cliente_id, aval_id, monto_prestado, pago_semanal, fecha_prestamo, modalidad, monto_prestado_intereses, tarjeton, grupo, fecha_inicio_grupo, "off", "");
                    Toast.makeText((Context)PrestamosCrearFragment.this.getActivity(), (CharSequence)"Error al registrar el pr\u00e9stamo, Se Guardo en local", (int)1).show();
                    Navigation.findNavController((Activity)PrestamosCrearFragment.this.getActivity(), (int)2131296862).navigate(2131296849);
                }
            }
        });
        requestPrestamo.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        requestPrestamo.setShouldCache(false);
        this.requestQueue.add((Request)requestPrestamo);
    }

    public void guardarPrestamoSQLite(String cliente_id, String aval_id, String monto_prestado, String pago_semanal, String fecha_prestamo, String modalidad, String monto_prestado_intereses, String tarjeton, String grupo, String fecha_inicio_grupo, String online, String prestamoID) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        if (!prestamoID.isEmpty()) {
            values.put("id", prestamoID);
        }
        values.put("cliente_id", cliente_id);
        values.put("aval_id", aval_id);
        values.put("monto_prestado", monto_prestado);
        values.put("pago_semanal", pago_semanal);
        values.put("fecha_prestamo", fecha_prestamo);
        values.put("modalidad_semanas", modalidad);
        values.put("numero_tarjeton", tarjeton);
        values.put("grupo_poblacion", grupo);
        long timestamp = System.currentTimeMillis();
        Date date = new Date(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(date);
        values.put("updated_at", formattedDate);
        if (online.equals("off")) {
            values.put("status", Integer.valueOf(8));
        } else {
            values.put("status", Integer.valueOf(0));
        }
        long result = db.insert("prestamos", null, values);
        if (result == -1L) {
            Log.e((String)"Error", (String)"No se pudo insertar el pr\u00e9stamo en la base de datos");
        } else {
            long prestamo_id = result;
            if (online.equals("off")) {
                this.guardarPagosSQLite(String.valueOf(prestamo_id), pago_semanal, fecha_prestamo, Integer.parseInt(modalidad));
            }
        }
        db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DefaultLocale"})
    public void guardarPagosSQLite(String prestamo_id, String monto_semanal, String fecha_prestamo, int modalidadId) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        int modalidadCantidad = this.obtenerCantidadSemanas(db, modalidadId);
        if (modalidadCantidad <= 0) {
            Log.e((String)"Error", (String)("Modalidad no v\u00e1lida o no se encontraron semanas para la modalidad con ID: " + modalidadId));
            db.close();
            return;
        }
        double montoSemanalFormateado = Utils.convertirDouble(monto_semanal);
        String montoSemanalCon2Decimales = String.format("%.2f", montoSemanalFormateado);
        double balance = montoSemanalFormateado * (double)modalidadCantidad;
        String balanceFormateado = String.format("%.2f", balance);
        String fechaHoraActual = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(new Date());
        Log.d((String)"FechaHoraActual", (String)("Fecha y hora actual: " + fechaHoraActual));
        StringBuilder insertQuery = new StringBuilder();
        insertQuery.append("INSERT INTO pagos (prestamo_id, cantidad_esperada_pago, cantidad_normal_pagada, ").append("cantidad_multa, cantidad_pendiente, cantidad_total_pagada, fecha_pago, semana, balance, status, updated_at) VALUES ");
        for (int i = 1; i <= modalidadCantidad; ++i) {
            String fecha_pago = this.calcularFechaPago(fecha_prestamo, i);
            Log.d((String)"Insertando Pago", (String)String.format("Prestamo ID: %s, Cantidad Esperada: %.2f, Normal Pagada: %.2f, Multa: %.2f, Total Pagada: %.2f, Fecha Pago: %s, Semana: %d, Balance: %.2f, Status: %d", prestamo_id, montoSemanalFormateado, 0.0, 0.0, 0.0, fecha_pago, i, balance, 0));
            if (i > 1) {
                insertQuery.append(", ");
            }
            insertQuery.append(String.format("('%s', '%.2f', '%.2f', '%.2f', '%.2f', '%.2f', '%s', %d, '%.2f', 0, '%s')", prestamo_id, montoSemanalFormateado, 0.0, 0.0, 0.0, 0.0, fecha_pago, i, balance, fechaHoraActual));
        }
        try {
            db.execSQL(insertQuery.toString());
            Log.d((String)"Success", (String)"Pagos insertados correctamente en SQLite");
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"No se pudo insertar los pagos en la base de datos", (Throwable)e);
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Range"})
    private int obtenerCantidadSemanas(SQLiteDatabase db, int modalidadId) {
        int cantidad = 0;
        try (Cursor cursor = null;){
            cursor = db.rawQuery("SELECT cantidad FROM configuracion_semanas WHERE id = ?", new String[]{String.valueOf(modalidadId)});
            if (cursor != null && cursor.moveToFirst()) {
                cantidad = cursor.getInt(cursor.getColumnIndex("cantidad"));
            } else {
                Log.e((String)"Error", (String)("No se encontr\u00f3 la modalidad con ID: " + modalidadId));
            }
        }
        return cantidad;
    }

    private String calcularFechaPago(String fechaInicio, int semana) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            Date fechaInicioDate = sdf.parse(fechaInicio);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fechaInicioDate);
            calendar.add(3, 1);
            calendar.add(3, semana - 1);
            return sdf.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        catch (java.text.ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSemanasPendientes(String cliente_id) {
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        SQLiteDatabase db = new DatabaseHelper(this.getContext()).getReadableDatabase();
        String query = "SELECT prestamos.numero_tarjeton, prestamos.id as prestamo_id, (prestamos.pago_semanal * cs.cantidad) as balance_original, ((prestamos.pago_semanal * cs.cantidad) - SUM(pagos.cantidad_normal_pagada)) as balance, COUNT( CASE WHEN pagos.status = 0 THEN pagos.id END ) semanas_pendientes, COUNT( CASE WHEN pagos.status = -1 and pagos.folio is null THEN pagos.id END ) semanas_punto, COUNT( CASE WHEN pagos.folio is not null and pagos.folio != 0 THEN pagos.id END ) semanas_folio FROM clientes INNER JOIN prestamos on prestamos.cliente_id = clientes.id INNER JOIN configuracion_semanas as cs on cs.id = prestamos.modalidad_semanas INNER JOIN pagos on pagos.prestamo_id = prestamos.id WHERE clientes.id = ? AND prestamos.status = 0 GROUP BY prestamos.numero_tarjeton ORDER BY prestamos.id DESC";
        Cursor cursor = db.rawQuery(query, new String[]{cliente_id});
        if (cursor != null && cursor.moveToFirst()) {
            try {
                String tarjeton = cursor.getString(cursor.getColumnIndex("numero_tarjeton"));
                final String prestamo_id = cursor.getString(cursor.getColumnIndex("prestamo_id"));
                double balance = cursor.getDouble(cursor.getColumnIndex("balance"));
                int semanasPendientes = cursor.getInt(cursor.getColumnIndex("semanas_pendientes"));
                int semanasPunto = cursor.getInt(cursor.getColumnIndex("semanas_punto"));
                int semanasFolio = cursor.getInt(cursor.getColumnIndex("semanas_folio"));
                Log.d((String)"SemanasPendientes", (String)("Tarjeton: " + tarjeton + ", Prestamo ID: " + prestamo_id));
                Log.d((String)"SemanasPendientes", (String)("Balance: " + balance + ", Semanas Pendientes: " + semanasPendientes));
                if (semanasPendientes > 0) {
                    int startPendientes;
                    int startFolio;
                    int startPunto;
                    int startMonto;
                    String mensaje = "Este cliente tiene un pr\u00e9stamo (" + tarjeton + ") con:\n " + semanasPendientes + " semanas pendientes,\n " + semanasPunto + " semanas con punto,\n " + semanasFolio + " semanas con folio y un\n monto de $" + balance + ", \n\nAntes de continuar verifica las semanas pendientes o comun\u00edcate con tu administrador,\n\n \u00bfQuieres renovarlo?";
                    SpannableString spannableMessage = new SpannableString((CharSequence)mensaje);
                    String textoResaltar = "Antes de continura verifica las semanas pendientes o comun\u00edcate con tu administrador";
                    int start = mensaje.indexOf(textoResaltar);
                    int end = start + textoResaltar.length();
                    if (start >= 0) {
                        spannableMessage.setSpan((Object)new ForegroundColorSpan(-65536), start, end, 33);
                        spannableMessage.setSpan((Object)new StyleSpan(1), start, end, 33);
                    }
                    if ((startMonto = mensaje.indexOf("monto de $" + balance)) >= 0) {
                        spannableMessage.setSpan((Object)new StyleSpan(1), startMonto, startMonto + ("monto de $" + balance).length(), 33);
                    }
                    if ((startPunto = mensaje.indexOf(semanasPunto + " semanas con punto")) >= 0) {
                        spannableMessage.setSpan((Object)new StyleSpan(1), startPunto, startPunto + String.valueOf(semanasPunto).length(), 33);
                    }
                    if ((startFolio = mensaje.indexOf(semanasFolio + " semanas con folio")) >= 0) {
                        spannableMessage.setSpan((Object)new StyleSpan(1), startFolio, startFolio + String.valueOf(semanasFolio).length(), 33);
                    }
                    if ((startPendientes = mensaje.indexOf(semanasPendientes + " semanas pendientes")) >= 0) {
                        spannableMessage.setSpan((Object)new StyleSpan(1), startPendientes, startPendientes + String.valueOf(semanasPendientes).length(), 33);
                    }
                    new MaterialAlertDialogBuilder((Context)this.getActivity()).setCancelable(false).setTitle((CharSequence)"Pagar pendientes").setMessage((CharSequence)spannableMessage).setPositiveButton((CharSequence)"S\u00cd", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            PrestamosCrearFragment.this.pagarSemanasPendientes(prestamo_id);
                        }
                    }).setNegativeButton((CharSequence)"NO", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                }
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Este cliente no tiene pr\u00e9stamos anteriores", (int)0).show();
            }
            catch (Exception e) {
                Log.e((String)"SQLiteError", (String)"Error al procesar los datos de la base de datos local", (Throwable)e);
            }
            finally {
                cursor.close();
            }
        } else {
            Log.d((String)"RESPONSE", (String)"El cliente no tiene datos pendientes en la base de datos.");
            Toast.makeText((Context)this.getActivity(), (CharSequence)"No se encontraron datos de pr\u00e9stamos pendientes.", (int)0).show();
        }
        dialog.cancel();
    }

    private void pagarSemanasPendientes(final String prestamo_id) {
        this.vs = VolleyS.getInstance(this.getContext());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"pagarSemanasPendientes");
            data.put("prestamo_id", (Object)prestamo_id);
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Toast.makeText((Context)PrestamosCrearFragment.this.getActivity(), (CharSequence)"Se ha realizado la renovaci\u00f3n del pr\u00e9stamo", (int)1).show();
                PrestamosCrearFragment.this.actualizarPrestamoYSemanas(prestamo_id);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PrestamosCrearFragment.this.getActivity());
                PrestamosCrearFragment.this.actualizarPrestamoYSemanas(prestamo_id);
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    @SuppressLint(value={"Range"})
    private void actualizarPrestamoYSemanas(String prestamo_id) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.query("prestamos", new String[]{"pago_semanal"}, "id = ?", new String[]{prestamo_id}, null, null, null);
        String pagoSemanal = "";
        if (cursor == null || !cursor.moveToFirst()) {
            Log.d((String)"SQLite", (String)("No se encontr\u00f3 el pr\u00e9stamo con prestamo_id: " + prestamo_id));
            return;
        }
        pagoSemanal = cursor.getString(cursor.getColumnIndex("pago_semanal"));
        cursor.close();
        ContentValues valoresPrestamo = new ContentValues();
        valoresPrestamo.put("status", Integer.valueOf(2));
        int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{prestamo_id});
        if (updatePrestamoResult > 0) {
            Log.d((String)"SQLite", (String)("Status del pr\u00e9stamo actualizado a 2 para prestamo_id: " + prestamo_id));
            ContentValues valoresPagos = new ContentValues();
            valoresPagos.put("cantidad_normal_pagada", pagoSemanal);
            valoresPagos.put("cantidad_total_pagada", pagoSemanal);
            valoresPagos.put("cantidad_pendiente", "0.00");
            valoresPagos.put("balance", "0");
            valoresPagos.put("status", "1");
            valoresPagos.put("empleado_id", this.sesion.getString("id", "0"));
            int updatePagosResult = db.update("pagos", valoresPagos, "prestamo_id = ? AND status = 0", new String[]{prestamo_id});
            if (updatePagosResult > 0) {
                Log.d((String)"SQLite", (String)("Semanas pendientes actualizadas a pagadas para prestamo_id: " + prestamo_id));
            } else {
                Log.d((String)"SQLite", (String)("No se encontraron semanas pendientes para actualizar para prestamo_id: " + prestamo_id));
            }
        } else {
            Log.d((String)"SQLite", (String)("Error al actualizar el status del pr\u00e9stamo para prestamo_id: " + prestamo_id));
        }
        db.close();
    }

    private void getGrupoPoblacion(String poblacion_id) {
        this.vs = VolleyS.getInstance(this.getContext());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getGrupoPoblacion");
            data.put("poblacion_id", (Object)poblacion_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONObject data = (JSONObject)response.get("data");
                    PrestamosCrearFragment.this.tlGrupo.getEditText().setText((CharSequence)data.get("grupo").toString());
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)PrestamosCrearFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        this.requestQueue.add((Request)request);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mViewModel = (PrestamosCrearViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(PrestamosCrearViewModel.class);
    }
}

