/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.reporte;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Grupo;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Reporte;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.reporte.ReporteViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteAdapter;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReporteFragment
extends Fragment {
    private ReporteViewModel mViewModel;
    private ArrayList<Reporte> reportes;
    private ArrayList<Reporte> reportesFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private RecyclerView recyclerView;
    private ReporteAdapter reporteAdapter;
    private LinearLayoutManager linearLayoutManager;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private TextView tvRuta;
    private TextView tvPoblacion;
    private TextView tvColumnaPagado;
    private TextView tvColumnaCobranza;
    private AutoCompleteTextView modalidadesAutoCompleteTextView;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private TextInputLayout tlGrupos;
    private String modalidad_id = "1";
    private String ruta_id = "";
    private String poblacion_id = "";
    private String grupo = "";
    private int previousLength;
    private boolean backSpace;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private ArrayList<Grupo> grupos;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private ArrayList<Modalidad> modalidades;
    private ArrayAdapter<Modalidad> modalidadesAdapter;
    private int totalPagados = 0;
    private int totalCobranza = 0;
    private SharedPreferences sesion;

    public static ReporteFragment newInstance() {
        return new ReporteFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        return inflater.inflate(2131492972, container, false);
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.requestQueue.getCache().clear();
                this.getReporteEstimado("1", null, null, null);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        this.modalidadesAutoCompleteTextView.setText((CharSequence)this.modalidadesAutoCompleteTextView.getAdapter().getItem(0).toString(), false);
        if (this.rutasAutoCompleteTextView != null) {
            this.rutasAutoCompleteTextView.setText((CharSequence)"");
        }
        if (this.poblacionesAutoCompleteTextView != null) {
            this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
        }
        if (this.tlGrupos != null) {
            this.tlGrupos.getEditText().setText((CharSequence)"");
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "ReporteFragment";
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.modalidadesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296280);
        this.tvColumnaPagado = (TextView)view.findViewById(2131296505);
        this.tvColumnaCobranza = (TextView)view.findViewById(2131296504);
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.tlGrupos = (TextInputLayout)view.findViewById(2131297189);
        this.initElements(view);
        this.getReporteEstimado("1", null, null, null);
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.reporteAdapter = new ReporteAdapter((Context)this.getActivity(), this.reportes);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.reporteAdapter);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 0);
    }

    public void initElements(View view) {
        this.rutaController = new RutaController((Context)this.getActivity());
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.reportes = new ArrayList();
        this.recyclerView = (RecyclerView)view.findViewById(2131296979);
        this.modalidades = new ArrayList();
        this.getModalidades();
        this.modalidadesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Modalidad modalidad = (Modalidad)ReporteFragment.this.modalidadesAdapter.getItem(i);
                ReporteFragment.this.modalidad_id = modalidad.getId();
                ReporteFragment.this.ruta_id = "";
                ReporteFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                ReporteFragment.this.poblacion_id = "";
                ReporteFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                ReporteFragment.this.grupo = "";
                ReporteFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                ReporteFragment.this.getReporteEstimado(ReporteFragment.this.modalidad_id, null, null, null);
            }
        });
        this.modalidadesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteFragment.this.backSpace = ReporteFragment.this.previousLength > s.length();
                if (ReporteFragment.this.backSpace && !ReporteFragment.this.modalidad_id.equals("")) {
                    ReporteFragment.this.modalidad_id = "";
                    ReporteFragment.this.modalidadesAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.ruta_id = "";
                    ReporteFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.poblacion_id = "";
                    ReporteFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.grupo = "";
                    ReporteFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    ReporteFragment.this.getReporteEstimado("1", null, null, null);
                }
            }
        });
        this.rutas = new ArrayList();
        this.poblaciones = new ArrayList();
        this.grupos = new ArrayList();
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)ReporteFragment.this.rutasAdapter.getItem(i);
                ReporteFragment.this.ruta_id = ruta.getId();
                if (ReporteFragment.this.poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    ReporteFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                }
                if (ReporteFragment.this.tlGrupos.getEditText().getText().toString().length() > 0) {
                    ReporteFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                }
                List poblacionesFiltro = ReporteFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ReporteFragment.this.ruta_id)).collect(Collectors.toList());
                ReporteFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteFragment.this.getContext(), 17367050, poblacionesFiltro);
                ReporteFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                ReporteFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ReporteFragment.this.poblacionesAdapter);
                ReporteFragment.this.filtrarReporte(ReporteFragment.this.modalidad_id, ReporteFragment.this.ruta_id);
            }
        });
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteFragment.this.backSpace = ReporteFragment.this.previousLength > s.length();
                if (ReporteFragment.this.backSpace && !ReporteFragment.this.ruta_id.equals("")) {
                    ReporteFragment.this.ruta_id = "";
                    ReporteFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.poblacion_id = "";
                    ReporteFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.grupo = "";
                    ReporteFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    ReporteFragment.this.filtrarReporte(ReporteFragment.this.modalidad_id);
                }
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones(this.ruta_id);
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)ReporteFragment.this.poblacionesAdapter.getItem(i);
                ReporteFragment.this.poblacion_id = poblacion.getId();
                ReporteFragment.this.filtrarReporte(ReporteFragment.this.modalidad_id, ReporteFragment.this.ruta_id, ReporteFragment.this.poblacion_id);
            }
        });
        this.poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteFragment.this.backSpace = ReporteFragment.this.previousLength > s.length();
                if (ReporteFragment.this.backSpace && !ReporteFragment.this.poblacion_id.equals("")) {
                    ReporteFragment.this.poblacion_id = "";
                    ReporteFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.grupo = "";
                    ReporteFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    ReporteFragment.this.filtrarReporte(ReporteFragment.this.modalidad_id, ReporteFragment.this.ruta_id);
                }
            }
        });
        this.tlGrupos.getEditText().addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteFragment.this.backSpace = ReporteFragment.this.previousLength > s.length();
                if (ReporteFragment.this.backSpace) {
                    ReporteFragment.this.grupo = "";
                    ReporteFragment.this.tlGrupos.getEditText().setText((CharSequence)"");
                    ReporteFragment.this.poblacion_id = "";
                    ReporteFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    ReporteFragment.this.getReporteEstimado(ReporteFragment.this.modalidad_id, null, null, null);
                } else if (s.length() > 0) {
                    ReporteFragment.this.grupo = s.toString();
                    ReporteFragment.this.getReporteEstimado(ReporteFragment.this.modalidad_id, ReporteFragment.this.ruta_id, ReporteFragment.this.poblacion_id, ReporteFragment.this.grupo);
                }
            }
        });
    }

    private void getModalidades() {
        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        this.modalidades.add(modalidad15);
        this.modalidades.add(modalidad20);
        this.modalidadesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.modalidades);
        this.modalidadesAutoCompleteTextView.setThreshold(1);
        this.modalidadesAutoCompleteTextView.setAdapter(this.modalidadesAdapter);
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            Gson gson = new Gson();
                            JSONObject obj = data.getJSONObject(i);
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            ReporteFragment.this.rutas.add(ruta);
                            ReporteFragment.this.rutaController.nueva(ruta);
                            Log.d((String)"getRutas", (String)("Ruta a\u00f1adida: " + ruta.toString()));
                        }
                        ReporteFragment.this.rutasAdapter = new ArrayAdapter(ReporteFragment.this.getContext(), 17367050, (List)ReporteFragment.this.rutas);
                        ReporteFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        ReporteFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)ReporteFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ReporteFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            Log.d((String)"getRutas", (String)"Recuperando rutas guardadas localmente.");
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            Log.d((String)"getRutas", (String)("Cantidad de rutas locales encontradas: " + rutasGuardadas.size()));
            for (Ruta ruta : rutasGuardadas) {
                Log.d((String)"getRutas", (String)("Ruta local encontrada: " + ruta.toString()));
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
                Log.d((String)"getRutas", (String)("Ruta a\u00f1adida tras filtrar: " + ruta));
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            ReporteFragment.this.poblaciones.add(poblacion);
                            ReporteFragment.this.poblacionController.nueva(poblacion);
                        }
                        ReporteFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteFragment.this.getContext(), 17367050, (List)ReporteFragment.this.poblaciones);
                        ReporteFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        ReporteFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ReporteFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ReporteFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    private void getReporteEstimado(String modalidad_id, String ruta_id, String poblacion_id, String grupo) {
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            String query;
            Cursor cursor;
            DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            int totalPagados = 0;
            int totalCobranza = 0;
            this.reportes.clear();
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("WHERE (CASE WHEN prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') THEN prestamos.status IN (0,2) ELSE prestamos.status = 0 END) ");
            if (ruta_id != null && !ruta_id.equals("0")) {
                whereClause.append("AND clientes.ruta_id = ").append(ruta_id).append(" ");
                Log.d((String)"getReporteEstimado", (String)("Ruta ID aplicada: " + ruta_id));
            }
            if (poblacion_id != null && !poblacion_id.equals("0")) {
                whereClause.append("AND clientes.poblacion_id = ").append(poblacion_id).append(" ");
                Log.d((String)"getReporteEstimado", (String)("Poblaci\u00f3n ID aplicada: " + poblacion_id));
            }
            if (grupo != null && !grupo.equals("0")) {
                whereClause.append("AND prestamos.grupo_poblacion = ").append(grupo).append(" ");
                Log.d((String)"getReporteEstimado", (String)("Grupo aplicado: " + grupo));
            }
            if (modalidad_id != null) {
                whereClause.append("AND (poblaciones.id IN (31, 1, 2, 4) OR prestamos.modalidad_semanas = ").append(modalidad_id).append(") ");
                Log.d((String)"getReporteEstimado", (String)("Modalidad aplicada: " + modalidad_id));
            }
            if ((cursor = db.rawQuery(query = "SELECT TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.poblacion_id, TABLA_ESTIMADOS.nombre_ruta, TABLA_ESTIMADOS.ruta_id, TABLA_ESTIMADOS.modalidad_semanas, MAX(CASE WHEN TABLA_ESTIMADOS.fecha_pago IS NULL THEN '' ELSE TABLA_ESTIMADOS.fecha_pago END) AS fecha_pago, SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, COUNT(CASE WHEN TABLA_ESTIMADOS.fecha_pago IS NOT NULL THEN TABLA_ESTIMADOS.cantidad_esperada_pago END) AS cantidad_prestamos, TABLA_PAGADOS.pagado, IFNULL(TABLA_PAGADOS.cantidad_pagados, 0) AS cantidad_pagados, TABLA_COBRANZA.faltante, IFNULL(TABLA_COBRANZA.cantidad_no_pagados, 0) AS cantidad_no_pagados FROM (     SELECT pagos.cantidad_esperada_pago, pagos.semana, poblaciones.primer_dia_cobro,     MAX(CASE WHEN pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago,     clientes.nombre_completo, clientes.poblacion_id, clientes.ruta_id, prestamos.grupo_poblacion, prestamos.modalidad_semanas,     poblaciones.nombre_poblacion, rutas.nombre_ruta, prestamos.status, prestamos.updated_at     FROM pagos     INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id     INNER JOIN clientes ON clientes.id = prestamos.cliente_id     INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id     INNER JOIN rutas ON rutas.id = clientes.ruta_id " + whereClause.toString() + "    GROUP BY prestamos.id, clientes.poblacion_id ORDER BY clientes.poblacion_id DESC ) AS TABLA_ESTIMADOS LEFT JOIN (     SELECT SUM(pagos.cantidad_normal_pagada) AS pagado, clientes.poblacion_id,     COUNT(pagos.cantidad_normal_pagada) AS cantidad_pagados     FROM pagos     INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id     INNER JOIN clientes ON clientes.id = prestamos.cliente_id     INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id     INNER JOIN rutas ON rutas.id = clientes.ruta_id " + whereClause.toString() + "    AND pagos.status IN (1, 3) AND pagos.fecha_pago_realizada = DATE('now')     GROUP BY clientes.poblacion_id ORDER BY clientes.poblacion_id DESC ) AS TABLA_PAGADOS ON TABLA_ESTIMADOS.poblacion_id = TABLA_PAGADOS.poblacion_id LEFT JOIN (     SELECT SUM(pagos.cantidad_pendiente) AS faltante, clientes.poblacion_id,     COUNT(pagos.cantidad_pendiente) AS cantidad_no_pagados     FROM pagos     INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id     INNER JOIN clientes ON clientes.id = prestamos.cliente_id     INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id     INNER JOIN rutas ON rutas.id = clientes.ruta_id " + whereClause.toString() + "    AND prestamos.status IN (0, -1) AND pagos.status = -1     AND pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days')     GROUP BY clientes.poblacion_id ORDER BY clientes.poblacion_id DESC ) AS TABLA_COBRANZA ON TABLA_ESTIMADOS.poblacion_id = TABLA_COBRANZA.poblacion_id GROUP BY TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.poblacion_id ORDER BY TABLA_ESTIMADOS.poblacion_id DESC", null)) != null && cursor.moveToFirst()) {
                Log.d((String)"getReporteEstimado", (String)"Datos encontrados, procesando resultados...");
                do {
                    Reporte reporte = new Reporte();
                    reporte.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporte.setCantidad_pagados(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_pagados")));
                    reporte.setCantidad_no_pagados(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_no_pagados")));
                    reporte.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));
                    reporte.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporte.setNombre_ruta(cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")));
                    reporte.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporte.setModalidad_semanas(cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")));
                    reporte.setFecha_pago(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago")));
                    reporte.setPagado(cursor.getString(cursor.getColumnIndexOrThrow("pagado")));
                    reporte.setCantidad_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_prestamos")));
                    this.reportes.add(reporte);
                    Log.d((String)"getReporteEstimado", (String)("Actualizando el adaptador, reportes: " + this.reportes.toString()));
                    Log.d((String)"getReporteEstimado", (String)("Reporte a\u00f1adido: " + reporte.toString()));
                } while (cursor.moveToNext());
                cursor.close();
            } else {
                Log.d((String)"getReporteEstimado", (String)"No se encontraron datos");
            }
            db.close();
            executor.shutdown();
            this.getActivity().runOnUiThread(() -> {
                dialog.cancel();
                this.tvColumnaPagado.setText((CharSequence)("PAGADO \n (" + totalPagados + ")"));
                this.tvColumnaCobranza.setText((CharSequence)("COBRANZA \n (" + totalCobranza + ")"));
                this.reporteAdapter.addAll(this.reportes);
                this.reporteAdapter.notifyItemRangeChanged(0, this.reportes.size());
                Log.d((String)"getReporteEstimado", (String)("Actualizando el adaptador, reportes: " + this.reportes.size()));
            });
        });
    }

    private void filtrarReporte(String modalidad_id, String ruta_id, String poblacion_id) {
        this.reportesFiltrados = new ArrayList();
        this.reportesFiltrados.clear();
        this.totalPagados = 0;
        this.totalCobranza = 0;
        for (Reporte reporte : this.reportes) {
            boolean poblacionCoincide;
            boolean modalidadCoincide = modalidad_id != null && modalidad_id.equals(reporte.getModalidad_semanas());
            boolean rutaCoincide = ruta_id != null && ruta_id.equals(reporte.getRuta_id());
            boolean bl = poblacionCoincide = poblacion_id != null && poblacion_id.equals(reporte.getPoblacion_id());
            if (modalidadCoincide && rutaCoincide && poblacionCoincide) {
                this.totalPagados += this.safeParseInt(reporte.getCantidad_pagados());
                this.totalCobranza += this.safeParseInt(reporte.getCantidad_no_pagados());
                this.reportesFiltrados.add(reporte);
                continue;
            }
            if (modalidadCoincide || !rutaCoincide || !poblacionCoincide) continue;
            this.totalPagados += this.safeParseInt(reporte.getCantidad_pagados());
            this.totalCobranza += this.safeParseInt(reporte.getCantidad_no_pagados());
            this.reportesFiltrados.add(reporte);
        }
        this.tvColumnaPagado.setText((CharSequence)("PAGADO \n (" + this.totalPagados + ")"));
        this.tvColumnaCobranza.setText((CharSequence)("COBRANZA \n (" + this.totalCobranza + ")"));
        if (!this.reportesFiltrados.isEmpty()) {
            this.reporteAdapter.setListaFiltrada(this.reportesFiltrados);
        }
    }

    private void filtrarReporte(String modalidad_id, String ruta_id) {
        this.reportesFiltrados = new ArrayList();
        this.reportesFiltrados.clear();
        this.totalPagados = 0;
        this.totalCobranza = 0;
        Log.d((String)"filtrarReporte", (String)("modalidad_id: " + modalidad_id + ", ruta_id: " + ruta_id));
        for (Reporte reporte : this.reportes) {
            boolean rutaCoincide;
            boolean modalidadCoincide = modalidad_id != null && modalidad_id.equals(reporte.getModalidad_semanas());
            boolean bl = rutaCoincide = ruta_id != null && ruta_id.equals(reporte.getRuta_id());
            if (modalidadCoincide && rutaCoincide) {
                this.totalPagados += this.safeParseInt(reporte.getCantidad_pagados());
                this.totalCobranza += this.safeParseInt(reporte.getCantidad_no_pagados());
                this.reportesFiltrados.add(reporte);
                continue;
            }
            if (modalidadCoincide || !rutaCoincide) continue;
            this.totalPagados += this.safeParseInt(reporte.getCantidad_pagados());
            this.totalCobranza += this.safeParseInt(reporte.getCantidad_no_pagados());
            this.reportesFiltrados.add(reporte);
        }
        this.tvColumnaPagado.setText((CharSequence)("PAGADO \n (" + this.totalPagados + ")"));
        this.tvColumnaCobranza.setText((CharSequence)("COBRANZA \n (" + this.totalCobranza + ")"));
        if (!this.reportesFiltrados.isEmpty()) {
            this.reporteAdapter.setListaFiltrada(this.reportesFiltrados);
        }
    }

    private int safeParseInt(String value) {
        try {
            return value != null ? Integer.parseInt(value) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void filtrarReporte(String modalidad_id) {
        this.reportesFiltrados = new ArrayList();
        this.reportesFiltrados.clear();
        this.totalPagados = 0;
        this.totalCobranza = 0;
        for (Reporte reporte : this.reportes) {
            if (!reporte.getModalidad_semanas().equals(modalidad_id)) continue;
            this.totalPagados += Integer.parseInt(reporte.getCantidad_pagados());
            this.totalCobranza += Integer.parseInt(reporte.getCantidad_no_pagados());
            this.reportesFiltrados.add(reporte);
        }
        this.tvColumnaPagado.setText((CharSequence)("PAGADO \n (" + this.totalPagados + ")"));
        this.tvColumnaCobranza.setText((CharSequence)("COBRANZA \n (" + this.totalCobranza + ")"));
        if (!this.reportesFiltrados.isEmpty()) {
            this.reporteAdapter.setListaFiltrada(this.reportesFiltrados);
        }
    }
}

