/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.reporteCreditos;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.ReporteCreditosController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.ReporteCreditos;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.reporteCreditos.ReporteCreditosViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteCreditosAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.chip.Chip;
import com.google.android.material.chip.ChipGroup;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReporteCreditosFragment
extends Fragment {
    private ReporteCreditosViewModel mViewModel;
    private SharedPreferences sesion;
    private ArrayList<ReporteCreditos> reporteCreditos;
    private ArrayList<ReporteCreditos> reporteCreditosFiltrado;
    private ArrayList<ReporteCreditos> reportesFiltradosNombres;
    private ArrayList<ReporteCreditos> reportesAgregados;
    private TextInputLayout tlFecha;
    private TextInputLayout tlRuta;
    private TextInputLayout tlNombre;
    private Button btnGuardar;
    private Button btnTotales;
    private Button btnAgregar;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private RutaController rutaController;
    private String ruta_id = "";
    private int previousLength;
    private boolean backSpace;
    private static ProgressDialog dialog;
    private RecyclerView recyclerView;
    private ReporteCreditosAdapter reporteCreditosAdapter;
    private LinearLayoutManager linearLayoutManager;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private boolean buscarReporte = false;
    private TextInputEditText svPoblaciones;
    private ReporteCreditosController reporteCreditosController;
    ArrayList<Poblacion> poblaciones;
    ArrayAdapter<Poblacion> poblacionesAdapter;
    String poblacion_id = "";
    String poblacion_nombre = "";
    private PoblacionController poblacionController;

    public static ReporteCreditosFragment newInstance() {
        return new ReporteCreditosFragment();
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        this.rutasAutoCompleteTextView.setText((CharSequence)"", false);
        if (this.svPoblaciones != null) {
            this.svPoblaciones.setText((CharSequence)"");
        }
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        this.requireActivity().setRequestedOrientation(-1);
        return inflater.inflate(2131492973, container, false);
    }

    private void getNuevoReporteCreditosOnline() {
        dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getReporteCreditosAPP");
            data.put("empleado_id", (Object)this.sesion.getString("id", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray reportesArray = response.getJSONArray("data");
                        JSONArray reporteArray = new JSONArray();
                        for (int i = 0; i < reportesArray.length(); ++i) {
                            JSONObject reporteCompleto = reportesArray.getJSONObject(i);
                            JSONObject reporte = new JSONObject();
                            reporte.put("id", (Object)reporteCompleto.getString("id"));
                            reporte.put("poblacion_id", (Object)reporteCompleto.getString("poblacion_id"));
                            reporte.put("observaciones", (Object)reporteCompleto.getString("observaciones"));
                            reporte.put("creditos_otorgados", (Object)reporteCompleto.getString("creditos_otorgados"));
                            reporte.put("total_prestamos", (Object)reporteCompleto.getString("total_prestamos"));
                            reporte.put("prestamos_nuevos", (Object)reporteCompleto.getString("prestamos_nuevos"));
                            reporte.put("monto_nuevos", (Object)reporteCompleto.getString("monto_nuevos"));
                            reporte.put("prestamos_renovados", (Object)reporteCompleto.getString("prestamos_renovados"));
                            reporte.put("monto_renovados", (Object)reporteCompleto.getString("monto_renovados"));
                            reporte.put("empleado_id", (Object)reporteCompleto.getString("empleado_id"));
                            reporte.put("fecha", (Object)reporteCompleto.getString("fecha"));
                            reporte.put("fecha_registro", (Object)reporteCompleto.getString("fecha_registro"));
                            reporteArray.put((Object)reporte);
                        }
                        ReporteCreditosFragment.this.insertarDatosEnSQLite(reporteArray);
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Datos sincronizados correctamente", (int)0).show();
                    } else {
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"No se encontraron datos para sincronizar", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    dialog.dismiss();
                    e.printStackTrace();
                    Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Error al procesar datos del servidor", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertarDatosEnSQLite(JSONArray reporteArray) {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        try {
            db.beginTransaction();
            for (int i = 0; i < reporteArray.length(); ++i) {
                JSONObject reporte = reporteArray.getJSONObject(i);
                ContentValues values = new ContentValues();
                values.put("id", reporte.getString("id"));
                values.put("poblacion_id", reporte.getString("poblacion_id"));
                values.put("observaciones", reporte.getString("observaciones"));
                values.put("creditos_otorgados", reporte.getString("creditos_otorgados"));
                values.put("total_prestamos", reporte.getString("total_prestamos"));
                values.put("prestamos_nuevos", reporte.getString("prestamos_nuevos"));
                values.put("monto_nuevos", reporte.getString("monto_nuevos"));
                values.put("prestamos_renovados", reporte.getString("prestamos_renovados"));
                values.put("monto_renovados", reporte.getString("monto_renovados"));
                values.put("empleado_id", reporte.getString("empleado_id"));
                values.put("fecha", reporte.getString("fecha"));
                values.put("fecha_registro", reporte.getString("fecha_registro"));
                db.insertWithOnConflict("reporte_creditos", null, values, 5);
            }
            db.setTransactionSuccessful();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
            db.close();
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.getNuevoReporteCreditosOnline();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "ReporteCreditoFragment";
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        if (this.isTableExistsAndHasData("reporte_creditos")) {
            this.getNuevoReporteCreditosUpd();
        } else {
            this.getNuevoReporteCreditosOnline();
        }
        this.initElements(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTableExistsAndHasData(String tableName) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        boolean result = false;
        try {
            db = new DatabaseHelper((Context)this.getActivity()).getReadableDatabase();
            String queryTableExists = "SELECT name FROM sqlite_master WHERE type='table' AND name=?";
            cursor = db.rawQuery(queryTableExists, new String[]{tableName});
            if (cursor.getCount() > 0) {
                cursor.close();
                String queryTableHasData = "SELECT COUNT(*) FROM " + tableName;
                cursor = db.rawQuery(queryTableHasData, null);
                if (cursor.moveToFirst()) {
                    int rowCount = cursor.getInt(0);
                    result = rowCount > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    private List<ReporteCreditos> obtenerReportesPendientes() {
        ArrayList<ReporteCreditos> listaReportes = new ArrayList<ReporteCreditos>();
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.query("reporte_creditos", null, "status = ?", new String[]{"1"}, null, null, null);
        if (cursor.moveToFirst()) {
            do {
                ReporteCreditos reporte = new ReporteCreditos();
                reporte.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                reporte.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                reporte.setObservaciones(cursor.getString(cursor.getColumnIndexOrThrow("observaciones")));
                reporte.setCreditos_otorgados(cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados")));
                reporte.setTotal_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos")));
                reporte.setPrestamos_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos")));
                reporte.setMonto_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos")));
                reporte.setPrestamos_renovados(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados")));
                reporte.setMonto_renovados(cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados")));
                reporte.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                reporte.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                listaReportes.add(reporte);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return listaReportes;
    }

    private void enviarReportesPendientes() {
        List<ReporteCreditos> reportes = this.obtenerReportesPendientes();
        Log.d((String)"ReporteDebug", (String)("Enviando reporte Lista completa: " + reportes.toString()));
        for (ReporteCreditos reporte : reportes) {
            Log.d((String)"ReporteDebug", (String)("Enviando reporte: " + reporte.toString()));
            this.registrarReporte2(reporte);
        }
    }

    private void registrarReporte2(final ReporteCreditos reporteCreditos) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"createReporteCreditos");
            data.put("poblacion_id", (Object)reporteCreditos.getPoblacion_id());
            data.put("observaciones", (Object)reporteCreditos.getObservaciones());
            data.put("creditos_otorgados", (Object)reporteCreditos.getCreditos_otorgados());
            data.put("total_prestamos", (Object)reporteCreditos.getTotal_prestamos());
            data.put("prestamos_nuevos", (Object)reporteCreditos.getPrestamos_nuevos());
            data.put("montos_nuevos", (Object)reporteCreditos.getMonto_nuevos());
            data.put("prestamos_renovados", (Object)reporteCreditos.getPrestamos_renovados());
            data.put("montos_renovados", (Object)reporteCreditos.getMonto_renovados());
            data.put("empleado_id", (Object)this.sesion.getString("id", ""));
            data.put("fecha", (Object)reporteCreditos.getFecha());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String nuevoId = response.getJSONObject("data").getString("id");
                        Log.d((String)"DEBUG", (String)("ID devuelto por el servidor: " + nuevoId));
                        ReporteCreditosFragment.this.actualizarReporteEnSQLite2(reporteCreditos.getId(), nuevoId);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void actualizarReporteEnSQLite2(String idLocal, String idServidor) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        ContentValues valores = new ContentValues();
        valores.put("status", Integer.valueOf(0));
        valores.put("id", idServidor);
        db.replace("reporte_creditos", null, valores);
        db.close();
    }

    private void getNuevoReporteCreditosUpd() {
        dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.enviarReportesPendientes();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getReporteCreditosAPP");
            data.put("empleado_id", (Object)this.sesion.getString("id", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray reportesArray = response.getJSONArray("data");
                        JSONArray reporteArray = new JSONArray();
                        for (int i = 0; i < reportesArray.length(); ++i) {
                            JSONObject reporteCompleto = reportesArray.getJSONObject(i);
                            JSONObject reporte = new JSONObject();
                            reporte.put("id", (Object)reporteCompleto.getString("id"));
                            reporte.put("poblacion_id", (Object)reporteCompleto.getString("poblacion_id"));
                            reporte.put("observaciones", (Object)reporteCompleto.getString("observaciones"));
                            reporte.put("creditos_otorgados", (Object)reporteCompleto.getString("creditos_otorgados"));
                            reporte.put("total_prestamos", (Object)reporteCompleto.getString("total_prestamos"));
                            reporte.put("prestamos_nuevos", (Object)reporteCompleto.getString("prestamos_nuevos"));
                            reporte.put("monto_nuevos", (Object)reporteCompleto.getString("monto_nuevos"));
                            reporte.put("prestamos_renovados", (Object)reporteCompleto.getString("prestamos_renovados"));
                            reporte.put("monto_renovados", (Object)reporteCompleto.getString("monto_renovados"));
                            reporte.put("empleado_id", (Object)reporteCompleto.getString("empleado_id"));
                            reporte.put("fecha", (Object)reporteCompleto.getString("fecha"));
                            reporte.put("fecha_registro", (Object)reporteCompleto.getString("fecha_registro"));
                            reporteArray.put((Object)reporte);
                        }
                        ReporteCreditosFragment.this.updateDatosEnSQLite(reporteArray);
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Datos sincronizados correctamente", (int)0).show();
                    } else {
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"No se encontraron datos para sincronizar", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    dialog.dismiss();
                    e.printStackTrace();
                    Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Error al procesar datos del servidor", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void updateDatosEnSQLite(JSONArray reporteArray) {
        SQLiteDatabase db = new DatabaseHelper((Context)this.getActivity()).getWritableDatabase();
        try {
            for (int i = 0; i < reporteArray.length(); ++i) {
                String fecha_registro_local;
                JSONObject reporte = reporteArray.getJSONObject(i);
                String id2 = reporte.getString("id");
                String fecha_registro_servidor = reporte.getString("fecha_registro");
                if (this.isFechaMasReciente(fecha_registro_servidor, fecha_registro_local = this.getFechaRegistroSQLite(db, id2))) {
                    ContentValues values = new ContentValues();
                    values.put("poblacion_id", reporte.getString("poblacion_id"));
                    values.put("observaciones", reporte.getString("observaciones"));
                    values.put("creditos_otorgados", reporte.getString("creditos_otorgados"));
                    values.put("total_prestamos", reporte.getString("total_prestamos"));
                    values.put("prestamos_nuevos", reporte.getString("prestamos_nuevos"));
                    values.put("monto_nuevos", reporte.getString("monto_nuevos"));
                    values.put("prestamos_renovados", reporte.getString("prestamos_renovados"));
                    values.put("monto_renovados", reporte.getString("monto_renovados"));
                    values.put("empleado_id", reporte.getString("empleado_id"));
                    values.put("fecha", reporte.getString("fecha"));
                    values.put("fecha_registro", fecha_registro_servidor);
                    int n = db.update("reporte_creditos", values, "id = ?", new String[]{id2});
                    continue;
                }
                Log.d((String)"DEBUG", (String)("La fecha del servidor no es m\u00e1s reciente para el reporte ID " + id2));
            }
            db.close();
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e((String)"ERROR", (String)("Error procesando el reporte: " + e.getMessage()));
        }
    }

    private String getFechaRegistroSQLite(SQLiteDatabase db, String id2) {
        String fecha_registro = "";
        Cursor cursor = db.rawQuery("SELECT fecha_registro FROM reporte_creditos WHERE id = ?", new String[]{id2});
        if (cursor.moveToFirst()) {
            fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
            if (fecha_registro == null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                fecha_registro = dateFormat.format(new Date());
                this.actualizarFechaRegistroSQLite(db, id2, fecha_registro);
            }
        } else {
            Log.d((String)"DEBUG", (String)("No se encontr\u00f3 un registro para el ID: " + id2));
        }
        cursor.close();
        return fecha_registro;
    }

    private void actualizarFechaRegistroSQLite(SQLiteDatabase db, String id2, String fecha_registro) {
        ContentValues valores = new ContentValues();
        valores.put("fecha_registro", fecha_registro);
        int rowsAffected = db.update("reporte_creditos", valores, "id = ?", new String[]{id2});
        if (rowsAffected > 0) {
            Log.d((String)"DEBUG", (String)("Fecha de registro actualizada correctamente para ID: " + id2));
        } else {
            Log.d((String)"DEBUG", (String)("No se pudo actualizar la fecha de registro para ID: " + id2));
        }
    }

    private boolean isFechaMasReciente(String fechaServidor, String fechaLocal) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
            Date fechaServidorDate = dateFormat.parse(fechaServidor);
            Date fechaLocalDate = dateFormat.parse(fechaLocal);
            return Objects.requireNonNull(fechaServidorDate).after(fechaLocalDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void initElements(View view) {
        this.poblaciones = new ArrayList();
        this.reporteCreditosFiltrado = new ArrayList();
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.svPoblaciones = (TextInputEditText)view.findViewById(2131297083);
        this.svPoblaciones.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                ReporteCreditosFragment.this.filtrarReportePoblaciones(editable.toString());
            }
        });
        this.reporteCreditosController = new ReporteCreditosController((Context)this.getActivity());
        this.rutaController = new RutaController((Context)this.getActivity());
        this.recyclerView = (RecyclerView)view.findViewById(2131296986);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.reporteCreditos = new ArrayList();
        this.reportesAgregados = new ArrayList();
        this.rutas = new ArrayList();
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.reporteCreditosAdapter = new ReporteCreditosAdapter((Context)this.getActivity(), this.reporteCreditos);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.reporteCreditosAdapter);
        this.btnGuardar = (Button)view.findViewById(2131296432);
        this.btnTotales = (Button)view.findViewById(2131296456);
        this.btnAgregar = (Button)view.findViewById(2131296392);
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlNombre = (TextInputLayout)view.findViewById(2131297200);
        this.tlNombre.getEditText().setText((CharSequence)this.sesion.getString("nombre", ""));
        this.tlFecha.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(ReporteCreditosFragment.this.getChildFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Object selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date((Long)selection + (long)offsetFromUTC);
                        ReporteCreditosFragment.this.tlFecha.getEditText().setText((CharSequence)simpleFormat.format(date));
                    }
                });
            }
        });
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)ReporteCreditosFragment.this.rutasAdapter.getItem(i);
                ReporteCreditosFragment.this.ruta_id = ruta.getId();
                ReporteCreditosFragment.this.filtrarReporte(ReporteCreditosFragment.this.ruta_id);
            }
        });
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteCreditosFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteCreditosFragment.this.backSpace = ReporteCreditosFragment.this.previousLength > s.length();
                if (ReporteCreditosFragment.this.backSpace && !ReporteCreditosFragment.this.ruta_id.equals("")) {
                    ReporteCreditosFragment.this.ruta_id = "";
                    ReporteCreditosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    ReporteCreditosFragment.this.reporteCreditosAdapter.setListaFiltrada(ReporteCreditosFragment.this.reporteCreditos);
                }
            }
        });
        new MaterialAlertDialogBuilder((Context)this.getActivity()).setCancelable(false).setTitle((CharSequence)"Opciones").setPositiveButton((CharSequence)"Nuevo reporte", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ReporteCreditosFragment.this.buscarReporte = false;
                ReporteCreditosFragment.this.reporteCreditosAdapter.setBuscarReporte(false);
                ReporteCreditosFragment.this.getNuevoReporteDiarioRutas(null);
            }
        }).setNegativeButton((CharSequence)"Buscar", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ReporteCreditosFragment.this.buscarReporte = true;
                ReporteCreditosFragment.this.reporteCreditosAdapter.setBuscarReporte(true);
                ReporteCreditosFragment.this.tlFecha.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        if (Validator.fieldValidation(ReporteCreditosFragment.this.tlRuta, "Ingresa una ruta")) {
                            ReporteCreditosFragment.this.getReporteCreditos(ReporteCreditosFragment.this.ruta_id, ReporteCreditosFragment.this.tlFecha.getEditText().getText().toString(), ReporteCreditosFragment.this.sesion.getString("id", ""));
                        }
                    }
                });
            }
        }).show();
        this.btnAgregar.setOnClickListener(new View.OnClickListener(){

            @RequiresApi(api=24)
            public void onClick(View view) {
                View dialogView = LayoutInflater.from((Context)ReporteCreditosFragment.this.getActivity()).inflate(2131492940, null, false);
                AutoCompleteTextView poblacionesAutoCompleteTextView = (AutoCompleteTextView)dialogView.findViewById(2131296285);
                Button btnAgregar = (Button)dialogView.findViewById(2131296392);
                final TextInputLayout tlObservaciones = (TextInputLayout)dialogView.findViewById(2131297207);
                final TextInputLayout tlMonto = (TextInputLayout)dialogView.findViewById(2131297197);
                final TextInputLayout tlCantidad = (TextInputLayout)dialogView.findViewById(2131297158);
                final TextInputLayout tlTotalPrestamos = (TextInputLayout)dialogView.findViewById(2131297241);
                final TextInputLayout tlPrestamosNuevos = (TextInputLayout)dialogView.findViewById(2131297222);
                final TextInputLayout tlMontoNuevos = (TextInputLayout)dialogView.findViewById(2131297198);
                final TextInputLayout tlPrestamosRenovados = (TextInputLayout)dialogView.findViewById(2131297223);
                final TextInputLayout tlMontoRenovados = (TextInputLayout)dialogView.findViewById(2131297199);
                final ChipGroup chipGroup = (ChipGroup)dialogView.findViewById(2131296487);
                TextView tvCreditos = (TextView)dialogView.findViewById(2131297280);
                final String[] creditos_otorgados = new String[]{""};
                final String[] total = new String[]{"0"};
                if (ReporteCreditosFragment.this.poblaciones.size() == 0) {
                    ReporteCreditosFragment.this.getPoblaciones(ReporteCreditosFragment.this.ruta_id);
                }
                List poblacionesFiltro = ReporteCreditosFragment.this.poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ReporteCreditosFragment.this.ruta_id)).collect(Collectors.toList());
                ReporteCreditosFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteCreditosFragment.this.getContext(), 17367050, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(ReporteCreditosFragment.this.poblacionesAdapter);
                poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    @RequiresApi(api=24)
                    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                        Poblacion poblacion = (Poblacion)ReporteCreditosFragment.this.poblacionesAdapter.getItem(i);
                        ReporteCreditosFragment.this.poblacion_id = poblacion.getId();
                        ReporteCreditosFragment.this.poblacion_nombre = poblacion.getNombre_poblacion();
                    }
                });
                btnAgregar.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (Validator.fieldValidation(tlMonto, "Ingresa un monto") && Validator.fieldValidation(tlCantidad, "Ingresa una cantidad")) {
                            final Chip chip = new Chip((Context)ReporteCreditosFragment.this.getActivity());
                            chip.setCloseIconVisible(true);
                            chip.setChipBackgroundColorResource(2131100429);
                            final String chipText = "$" + tlMonto.getEditText().getText().toString() + " (" + tlCantidad.getEditText().getText().toString() + ")";
                            chip.setText((CharSequence)chipText);
                            chip.setOnCloseIconClickListener(new View.OnClickListener(){

                                public void onClick(View view) {
                                    creditos_otorgados[0] = creditos_otorgados[0].replace(chipText, "");
                                    chipGroup.removeView((View)chip);
                                }
                            });
                            creditos_otorgados[0] = creditos_otorgados[0] + " " + chipText;
                            chipGroup.addView((View)chip);
                            String[] creditosSplit = creditos_otorgados[0].trim().split("\\$");
                            int t = 0;
                            for (int i = 0; i < creditosSplit.length; ++i) {
                                if (creditosSplit[i].equals("") || creditosSplit[i].equals("null ") || creditosSplit[i].equals(" ")) continue;
                                t += Integer.parseInt(creditosSplit[i].split(" ")[1].replace("(", "").replace(")", ""));
                            }
                            total[0] = String.valueOf(t);
                            tlTotalPrestamos.getEditText().setText((CharSequence)String.valueOf(t));
                            tlMonto.getEditText().setText((CharSequence)"");
                            tlCantidad.getEditText().setText((CharSequence)"");
                            tlMonto.requestFocus();
                        }
                    }
                });
                new MaterialAlertDialogBuilder((Context)ReporteCreditosFragment.this.getActivity()).setCancelable(false).setView(dialogView).setTitle((CharSequence)"Agregar registro al reporte").setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (!ReporteCreditosFragment.this.poblacion_id.equals("")) {
                            ReporteCreditos nuevoRegistro = new ReporteCreditos("", ReporteCreditosFragment.this.poblacion_id, tlObservaciones.getEditText().getText().toString(), "", tlTotalPrestamos.getEditText().getText().toString(), tlPrestamosNuevos.getEditText().getText().toString(), tlMontoNuevos.getEditText().getText().toString(), tlPrestamosRenovados.getEditText().getText().toString(), tlMontoRenovados.getEditText().getText().toString(), "", "", ReporteCreditosFragment.this.poblacion_nombre, "", "", "");
                            nuevoRegistro.setCreditos_otorgados(creditos_otorgados[0]);
                            nuevoRegistro.setSeleccionado(true);
                            String creditos_otorgados2 = "";
                            if (nuevoRegistro.getChipGroupCreditos().size() > 0) {
                                for (Chip chip : nuevoRegistro.getChipGroupCreditos()) {
                                    creditos_otorgados2 = creditos_otorgados2 + " " + chip.getText().toString();
                                }
                            }
                            ReporteCreditosFragment.this.reportesAgregados.add(nuevoRegistro);
                            ReporteCreditosFragment.this.reporteCreditos.add(nuevoRegistro);
                            ReporteCreditosFragment.this.reporteCreditosAdapter.addAll(ReporteCreditosFragment.this.reporteCreditos);
                            ReporteCreditosFragment.this.reporteCreditosAdapter.notifyItemRangeChanged(ReporteCreditosFragment.this.reporteCreditos.size(), 1);
                            ReporteCreditosFragment.this.poblacion_id = "";
                            ReporteCreditosFragment.this.poblacion_nombre = "";
                        } else {
                            Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Selecciona una poblaci\u00f3n", (int)0).show();
                        }
                    }
                }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
        this.btnGuardar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new MaterialAlertDialogBuilder((Context)ReporteCreditosFragment.this.getActivity()).setCancelable(false).setTitle((CharSequence)"Guardar reporte").setMessage((CharSequence)"\u00bfEsta seguro de registrar el reporte?").setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (Validator.fieldValidation(ReporteCreditosFragment.this.tlRuta, "Ingresa una ruta") && Validator.fieldValidation(ReporteCreditosFragment.this.tlFecha, "Ingresa una fecha")) {
                            if (ReporteCreditosFragment.this.buscarReporte) {
                                if (ReporteCreditosFragment.this.reporteCreditos.size() > 0) {
                                    if (ReporteCreditosFragment.this.reportesAgregados.size() > 0) {
                                        for (ReporteCreditos rc : ReporteCreditosFragment.this.reportesAgregados) {
                                            rc.setSeleccionado(false);
                                            ReporteCreditosFragment.this.agregarRegistroReporte(rc);
                                        }
                                        ReporteCreditosFragment.this.reportesAgregados.clear();
                                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Se agregaron registros al reporte", (int)1).show();
                                    } else {
                                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"No se agregaron nuevos registros", (int)0).show();
                                    }
                                    if (((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesEditados.size() > 0) {
                                        for (ReporteCreditos rc : ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesEditados) {
                                            ReporteCreditosFragment.this.editarRegistroReporte(rc);
                                        }
                                        ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesEditados.clear();
                                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Se editaron registros del reporte", (int)1).show();
                                    } else {
                                        Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"No se editaron nuevos registros", (int)0).show();
                                    }
                                }
                            } else if (((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.size() > 0) {
                                for (ReporteCreditos rc : ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados) {
                                    rc.setSeleccionado(false);
                                    ReporteCreditosFragment.this.registrarReporte(rc);
                                }
                                ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.clear();
                                ReporteCreditosFragment.this.getNuevoReporteDiarioRutas(null);
                                ReporteCreditosFragment.this.tlFecha.getEditText().setText((CharSequence)"");
                                ReporteCreditosFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                                Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"Se registro el reporte", (int)0).show();
                            } else {
                                Toast.makeText((Context)ReporteCreditosFragment.this.getActivity(), (CharSequence)"No hay poblaciones seleccionadas", (int)0).show();
                            }
                        }
                    }
                }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
        this.btnTotales.setOnClickListener(new View.OnClickListener(){

            @RequiresApi(api=24)
            public void onClick(View view) {
                View dialogView = LayoutInflater.from((Context)ReporteCreditosFragment.this.getActivity()).inflate(2131492930, null, false);
                TextView tvTotalPrestamos = (TextView)dialogView.findViewById(2131297338);
                TextView tvPrestamosNuevos = (TextView)dialogView.findViewById(2131297322);
                TextView tvMontoNuevos = (TextView)dialogView.findViewById(2131297307);
                TextView tvPrestamosRenovados = (TextView)dialogView.findViewById(2131297323);
                TextView tvMontoRenovados = (TextView)dialogView.findViewById(2131297308);
                if (ReporteCreditosFragment.this.buscarReporte) {
                    int totalPrestamos = ReporteCreditosFragment.this.reporteCreditos.stream().mapToInt(o -> Utils.parseInt(o.getTotal_prestamos())).sum();
                    tvTotalPrestamos.setText((CharSequence)Html.fromHtml((String)("<b>Total prestamos: </b> " + totalPrestamos)));
                    int prestamosNuevosTotal = ReporteCreditosFragment.this.reporteCreditos.stream().mapToInt(o -> Utils.parseInt(o.getPrestamos_nuevos())).sum();
                    tvPrestamosNuevos.setText((CharSequence)Html.fromHtml((String)("<b>Prestamos nuevos: </b> " + prestamosNuevosTotal)));
                    double montosNuevosTotal = ReporteCreditosFragment.this.reporteCreditos.stream().mapToDouble(o -> Utils.parseDouble(o.getMonto_nuevos())).sum();
                    tvMontoNuevos.setText((CharSequence)Html.fromHtml((String)("<b>Montos nuevos: </b> $" + montosNuevosTotal)));
                    int prestamosRenovadosTotal = ReporteCreditosFragment.this.reporteCreditos.stream().mapToInt(o -> Utils.parseInt(o.getPrestamos_renovados())).sum();
                    tvPrestamosRenovados.setText((CharSequence)Html.fromHtml((String)("<b>Prestamos renovados: </b> " + prestamosRenovadosTotal)));
                    double montosRenovadosTotal = ReporteCreditosFragment.this.reporteCreditos.stream().mapToDouble(o -> Utils.parseDouble(o.getMonto_renovados())).sum();
                    tvMontoRenovados.setText((CharSequence)Html.fromHtml((String)("<b>Montos renovados: </b> $" + montosRenovadosTotal)));
                } else {
                    int totalPrestamos = ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.stream().mapToInt(o -> Utils.parseInt(o.getTotal_prestamos())).sum();
                    tvTotalPrestamos.setText((CharSequence)Html.fromHtml((String)("<b>Total prestamos: </b> " + totalPrestamos)));
                    int prestamosNuevosTotal = ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.stream().mapToInt(o -> Utils.parseInt(o.getPrestamos_nuevos())).sum();
                    tvPrestamosNuevos.setText((CharSequence)Html.fromHtml((String)("<b>Prestamos nuevos: </b> " + prestamosNuevosTotal)));
                    double montosNuevosTotal = ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getMonto_nuevos())).sum();
                    tvMontoNuevos.setText((CharSequence)Html.fromHtml((String)("<b>Montos nuevos: </b> $" + montosNuevosTotal)));
                    int prestamosRenovadosTotal = ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.stream().mapToInt(o -> Utils.parseInt(o.getPrestamos_renovados())).sum();
                    tvPrestamosRenovados.setText((CharSequence)Html.fromHtml((String)("<b>Prestamos renovados: </b> " + prestamosRenovadosTotal)));
                    double montosRenovadosTotal = ((ReporteCreditosFragment)ReporteCreditosFragment.this).reporteCreditosAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getMonto_renovados())).sum();
                    tvMontoRenovados.setText((CharSequence)Html.fromHtml((String)("<b>Montos renovados: </b> $" + montosRenovadosTotal)));
                }
                new MaterialAlertDialogBuilder((Context)ReporteCreditosFragment.this.getActivity()).setCancelable(false).setView(dialogView).setTitle((CharSequence)"Totales").setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            Gson gson = new Gson();
                            JSONObject obj = data.getJSONObject(i);
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            ReporteCreditosFragment.this.rutas.add(ruta);
                            ReporteCreditosFragment.this.rutaController.nueva(ruta);
                        }
                        ReporteCreditosFragment.this.rutasAdapter = new ArrayAdapter(ReporteCreditosFragment.this.getContext(), 17367050, (List)ReporteCreditosFragment.this.rutas);
                        ReporteCreditosFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        ReporteCreditosFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)ReporteCreditosFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            for (Ruta ruta : rutasGuardadas) {
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logUltimosTresRegistros() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;
        try {
            String query = "SELECT * FROM reporte_creditos ORDER BY id DESC LIMIT 5";
            cursor = db.rawQuery(query, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                    String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                    String observaciones = cursor.getString(cursor.getColumnIndexOrThrow("observaciones"));
                    String creditos_otorgados = cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados"));
                    String total_prestamos = cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos"));
                    String prestamos_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos"));
                    String monto_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos"));
                    String prestamos_renovados = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados"));
                    String monto_renovados = cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados"));
                    String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                    String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                    String fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
                    String string2 = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                } while (cursor.moveToNext());
            } else {
                Log.d((String)"UltimosRegistros", (String)"No hay registros en la tabla reporte_creditos.");
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLiteError", (String)"Error al obtener los \u00faltimos registros: ", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    private void getReporteCreditos(String ruta_id, String fecha, String empleado_id) {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;
        String whereClause = "";
        ArrayList<String> selectionArgs = new ArrayList<String>();
        this.logUltimosTresRegistros();
        if (ruta_id != null && !ruta_id.isEmpty()) {
            whereClause = whereClause + " AND poblaciones.ruta_id = ?";
            selectionArgs.add(ruta_id);
        }
        if (empleado_id != null && !empleado_id.isEmpty()) {
            whereClause = whereClause + " AND rc.empleado_id = ?";
            selectionArgs.add(empleado_id);
        }
        if (fecha != null && !fecha.isEmpty()) {
            whereClause = whereClause + " AND rc.fecha = ?";
            selectionArgs.add(fecha);
        }
        String query = "SELECT poblaciones.nombre_poblacion, poblaciones.ruta_id, rc.* FROM reporte_creditos AS rc INNER JOIN poblaciones ON poblaciones.id = rc.poblacion_id " + whereClause + " ORDER BY rc.poblacion_id DESC";
        cursor = db.rawQuery(query, selectionArgs.toArray(new String[0]));
        this.reporteCreditos = new ArrayList();
        if (cursor.moveToFirst()) {
            do {
                ReporteCreditos reporteCredito = new ReporteCreditos();
                reporteCredito.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                reporteCredito.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                reporteCredito.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                reporteCredito.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                reporteCredito.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                reporteCredito.setObservaciones(cursor.getString(cursor.getColumnIndexOrThrow("observaciones")));
                reporteCredito.setCreditos_otorgados(cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados")));
                reporteCredito.setTotal_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos")));
                reporteCredito.setPrestamos_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos")));
                reporteCredito.setMonto_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos")));
                reporteCredito.setPrestamos_renovados(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados")));
                reporteCredito.setMonto_renovados(cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados")));
                reporteCredito.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                reporteCredito.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));
                this.reporteCreditos.add(reporteCredito);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        if (!this.reporteCreditos.isEmpty()) {
            this.reporteCreditosAdapter.clear();
            this.reporteCreditosAdapter.addAll(this.reporteCreditos);
            this.reporteCreditosAdapter.notifyItemRangeChanged(this.reporteCreditos.size(), 1);
            this.btnTotales.setVisibility(0);
            this.btnGuardar.setVisibility(0);
            this.btnAgregar.setVisibility(0);
        } else {
            this.btnTotales.setVisibility(8);
            this.btnGuardar.setVisibility(8);
            this.btnAgregar.setVisibility(8);
            Toast.makeText((Context)this.getActivity(), (CharSequence)"No existe ningun reporte con los filtros ingresados", (int)0).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNuevoReporteDiarioRutas(String ruta_id) {
        String[] stringArray;
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        SQLiteDatabase db = new DatabaseHelper((Context)this.getActivity()).getReadableDatabase();
        String whereClause = "WHERE (CASE WHEN prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') THEN prestamos.status IN (0, 2) ELSE prestamos.status = 0 END)";
        if (ruta_id != null && !ruta_id.isEmpty()) {
            whereClause = whereClause + " AND clientes.ruta_id = ?";
        }
        String query = "SELECT TABLA_ESTIMADOS.poblacion_id, TABLA_ESTIMADOS.ruta_id, TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.modalidad_semanas, SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, '' AS estimacion, '' AS abonos_semana, '' AS recuperacion_semana, '' AS anticipos, '' AS total_1, '' AS recuperacion_prestamos, '' AS colocacion, '' AS prestamo_colocadora, '' AS comision, '' AS bono_colocadora, '' AS total_2, '' AS saldo, '' AS pendiente_recuperar, '' AS abonos_recuperar, '' AS empleado_id, '' AS gastos_id, '' AS fecha, '' AS fecha_registro FROM (     SELECT         pagos.cantidad_esperada_pago,         pagos.semana,         poblaciones.primer_dia_cobro,         MAX(CASE WHEN pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago,         clientes.nombre_completo,         clientes.poblacion_id,         clientes.ruta_id,         prestamos.grupo_poblacion,         prestamos.modalidad_semanas,         poblaciones.nombre_poblacion,         rutas.nombre_ruta,         prestamos.status,         prestamos.updated_at     FROM pagos     INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id     INNER JOIN clientes ON clientes.id = prestamos.cliente_id     INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id     INNER JOIN rutas ON rutas.id = clientes.ruta_id " + whereClause + "     GROUP BY prestamos.id     ORDER BY clientes.poblacion_id DESC ) AS TABLA_ESTIMADOS GROUP BY TABLA_ESTIMADOS.nombre_poblacion ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";
        if (ruta_id != null && !ruta_id.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ruta_id;
        } else {
            stringArray = null;
        }
        String[] selectionArgs = stringArray;
        Cursor cursor = db.rawQuery(query, selectionArgs);
        this.reporteCreditos = new ArrayList();
        try {
            if (cursor.moveToFirst()) {
                do {
                    ReporteCreditos reporteCredito = new ReporteCreditos();
                    reporteCredito.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporteCredito.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporteCredito.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporteCredito.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                    reporteCredito.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                    reporteCredito.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));
                    this.reporteCreditos.add(reporteCredito);
                } while (cursor.moveToNext());
            }
        }
        finally {
            cursor.close();
            db.close();
        }
        dialog.cancel();
        if (!this.reporteCreditos.isEmpty()) {
            this.btnTotales.setVisibility(0);
            this.btnGuardar.setVisibility(0);
            this.reporteCreditosAdapter.clear();
            this.reporteCreditosAdapter.addAll(this.reporteCreditos);
            this.reporteCreditosAdapter.notifyItemRangeChanged(this.reporteCreditos.size(), 1);
        } else {
            this.btnTotales.setVisibility(8);
            this.btnGuardar.setVisibility(8);
            Toast.makeText((Context)this.getActivity(), (CharSequence)"No se encontraron reportes para esta ruta.", (int)0).show();
        }
    }

    private void registrarReporte(final ReporteCreditos reporteCreditos) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"createReporteCreditos");
            data.put("poblacion_id", (Object)reporteCreditos.getPoblacion_id());
            data.put("observaciones", (Object)reporteCreditos.getObservaciones());
            data.put("creditos_otorgados", (Object)reporteCreditos.getCreditos_otorgados());
            data.put("total_prestamos", (Object)reporteCreditos.getTotal_prestamos());
            data.put("prestamos_nuevos", (Object)reporteCreditos.getPrestamos_nuevos());
            data.put("montos_nuevos", (Object)reporteCreditos.getMonto_nuevos());
            data.put("prestamos_renovados", (Object)reporteCreditos.getPrestamos_renovados());
            data.put("montos_renovados", (Object)reporteCreditos.getMonto_renovados());
            data.put("empleado_id", (Object)this.sesion.getString("id", ""));
            data.put("fecha", (Object)this.tlFecha.getEditText().getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final String freg = this.tlFecha.getEditText().getText().toString();
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String id2 = response.getJSONObject("data").getString("id");
                        ReporteCreditosFragment.this.registrarReporteCreditosEnSQLite(reporteCreditos.getPoblacion_id(), reporteCreditos.getObservaciones(), reporteCreditos.getCreditos_otorgados(), reporteCreditos.getTotal_prestamos(), reporteCreditos.getPrestamos_nuevos(), reporteCreditos.getMonto_nuevos(), reporteCreditos.getPrestamos_renovados(), reporteCreditos.getMonto_renovados(), ReporteCreditosFragment.this.sesion.getString("id", ""), freg, id2, "on");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
                ReporteCreditosFragment.this.registrarReporteCreditosEnSQLite(reporteCreditos.getPoblacion_id(), reporteCreditos.getObservaciones(), reporteCreditos.getCreditos_otorgados(), reporteCreditos.getTotal_prestamos(), reporteCreditos.getPrestamos_nuevos(), reporteCreditos.getMonto_nuevos(), reporteCreditos.getPrestamos_renovados(), reporteCreditos.getMonto_renovados(), ReporteCreditosFragment.this.sesion.getString("id", ""), freg, "", "off");
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void registrarReporteCreditosEnSQLite(String poblacion_id, String observaciones, String creditos_otorgados, String total_prestamos, String prestamos_nuevos, String monto_nuevos, String prestamos_renovados, String monto_renovados, String empleado_id, String fecha, String idServer, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        String idReporte = idServer != null && !idServer.isEmpty() ? idServer : String.valueOf(this.obtenerSiguienteIdReporte(db));
        ContentValues valores = new ContentValues();
        valores.put("id", idReporte);
        valores.put("poblacion_id", poblacion_id);
        valores.put("observaciones", observaciones);
        valores.put("creditos_otorgados", creditos_otorgados == null || creditos_otorgados.trim().isEmpty() ? "0" : creditos_otorgados);
        valores.put("total_prestamos", total_prestamos == null || total_prestamos.trim().isEmpty() ? "0" : total_prestamos);
        valores.put("prestamos_nuevos", prestamos_nuevos == null || prestamos_nuevos.trim().isEmpty() ? "0" : prestamos_nuevos);
        valores.put("monto_nuevos", monto_nuevos == null || monto_nuevos.trim().isEmpty() ? "0" : monto_nuevos);
        valores.put("prestamos_renovados", prestamos_renovados == null || prestamos_renovados.trim().isEmpty() ? "0" : prestamos_renovados);
        valores.put("monto_renovados", monto_renovados == null || monto_renovados.trim().isEmpty() ? "0" : monto_renovados);
        valores.put("empleado_id", empleado_id);
        valores.put("fecha", fecha);
        if (online != "off") {
            valores.put("status", "0");
        } else {
            valores.put("status", "1");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Mexico_City"));
        calendar.add(12, -10);
        Date nuevaFecha = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.forLanguageTag("es-MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);
        valores.put("fecha_registro", fechaRestada);
        long resultado = db.insert("reporte_creditos", null, valores);
        if (resultado != -1L) {
            Log.d((String)"SQLite", (String)("reporte registrado con \u00e9xito en SQLite con ID: " + idReporte));
        } else {
            Log.d((String)"SQLite", (String)"Error al registrar el reporte en SQLite.");
        }
        db.close();
    }

    private int obtenerSiguienteIdReporte(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM reporte_creditos", null);
        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();
        return ultimoId + 1;
    }

    private void filtrarReporte(String ruta_id) {
        this.reporteCreditosFiltrado = new ArrayList();
        this.reporteCreditosFiltrado.clear();
        for (ReporteCreditos rc : this.reporteCreditos) {
            if (!rc.getRuta_id().equals(ruta_id)) continue;
            this.reporteCreditosFiltrado.add(rc);
        }
        if (!this.reporteCreditosFiltrado.isEmpty()) {
            this.reporteCreditosAdapter.setListaFiltrada(this.reporteCreditosFiltrado);
        }
    }

    private void filtrarReportePoblaciones(String text) {
        if (this.reporteCreditosFiltrado.size() == 0) {
            for (ReporteCreditos rd : this.reporteCreditos) {
                if (!rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())) continue;
                this.reporteCreditosFiltrado.add(rd);
            }
            if (!this.reporteCreditosFiltrado.isEmpty()) {
                this.reporteCreditosAdapter.setListaFiltrada(this.reporteCreditosFiltrado);
            }
        } else {
            this.reportesFiltradosNombres = new ArrayList();
            for (ReporteCreditos rd : this.reporteCreditosFiltrado) {
                if (!rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())) continue;
                this.reportesFiltradosNombres.add(rd);
            }
            if (!this.reportesFiltradosNombres.isEmpty()) {
                this.reporteCreditosAdapter.setListaFiltrada(this.reportesFiltradosNombres);
            }
        }
    }

    private void getPoblaciones(String ruta_id) {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            ReporteCreditosFragment.this.poblaciones.add(poblacion);
                            ReporteCreditosFragment.this.poblacionController.nueva(poblacion);
                        }
                        ReporteCreditosFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteCreditosFragment.this.getContext(), 17367050, ReporteCreditosFragment.this.poblaciones);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
        }
    }

    private void agregarRegistroReporte(final ReporteCreditos reporteCredito) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"createReporteCreditos");
            data.put("poblacion_id", (Object)reporteCredito.getPoblacion_id());
            data.put("observaciones", (Object)reporteCredito.getObservaciones());
            data.put("creditos_otorgados", (Object)reporteCredito.getCreditos_otorgados());
            data.put("total_prestamos", reporteCredito.getTotal_prestamos() == null || reporteCredito.getTotal_prestamos().isEmpty() ? 0 : Integer.parseInt(reporteCredito.getTotal_prestamos()));
            data.put("prestamos_nuevos", reporteCredito.getPrestamos_nuevos() == null || reporteCredito.getPrestamos_nuevos().isEmpty() ? 0 : Integer.parseInt(reporteCredito.getPrestamos_nuevos()));
            data.put("montos_nuevos", reporteCredito.getMonto_nuevos() == null || reporteCredito.getMonto_nuevos().isEmpty() ? 0 : Integer.parseInt(reporteCredito.getMonto_nuevos()));
            data.put("prestamos_renovados", reporteCredito.getPrestamos_renovados() == null || reporteCredito.getPrestamos_renovados().isEmpty() ? 0 : Integer.parseInt(reporteCredito.getPrestamos_renovados()));
            data.put("montos_renovados", reporteCredito.getMonto_renovados() == null || reporteCredito.getMonto_renovados().isEmpty() ? 0 : Integer.parseInt(reporteCredito.getMonto_renovados()));
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
            data.put("fecha", (Object)this.tlFecha.getEditText().getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final String fechaAgregar = this.tlFecha.getEditText().getText().toString();
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String id2 = response.getJSONObject("data").getString("id");
                        ReporteCreditosFragment.this.registrarReporteCreditosEnSQLite(reporteCredito.getPoblacion_id(), reporteCredito.getObservaciones(), reporteCredito.getCreditos_otorgados(), reporteCredito.getTotal_prestamos() == null || reporteCredito.getTotal_prestamos().isEmpty() ? "0" : reporteCredito.getTotal_prestamos(), reporteCredito.getPrestamos_nuevos() == null || reporteCredito.getPrestamos_nuevos().isEmpty() ? "0" : reporteCredito.getPrestamos_nuevos(), reporteCredito.getMonto_nuevos() == null || reporteCredito.getMonto_nuevos().isEmpty() ? "0" : reporteCredito.getMonto_nuevos(), reporteCredito.getPrestamos_renovados() == null || reporteCredito.getPrestamos_renovados().isEmpty() ? "0" : reporteCredito.getPrestamos_renovados(), reporteCredito.getMonto_renovados() == null || reporteCredito.getMonto_renovados().isEmpty() ? "0" : reporteCredito.getMonto_renovados(), ReporteCreditosFragment.this.sesion.getString("id", ""), fechaAgregar, id2, "on");
                        ReporteCreditosFragment.this.getReporteCreditos(ReporteCreditosFragment.this.ruta_id, ReporteCreditosFragment.this.tlFecha.getEditText().getText().toString(), ReporteCreditosFragment.this.sesion.getString("id", ""));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
                ReporteCreditosFragment.this.registrarReporteCreditosEnSQLite(reporteCredito.getPoblacion_id(), reporteCredito.getObservaciones(), reporteCredito.getCreditos_otorgados(), reporteCredito.getTotal_prestamos() == null || reporteCredito.getTotal_prestamos().isEmpty() ? "0" : reporteCredito.getTotal_prestamos(), reporteCredito.getPrestamos_nuevos() == null || reporteCredito.getPrestamos_nuevos().isEmpty() ? "0" : reporteCredito.getPrestamos_nuevos(), reporteCredito.getMonto_nuevos() == null || reporteCredito.getMonto_nuevos().isEmpty() ? "0" : reporteCredito.getMonto_nuevos(), reporteCredito.getPrestamos_renovados() == null || reporteCredito.getPrestamos_renovados().isEmpty() ? "0" : reporteCredito.getPrestamos_renovados(), reporteCredito.getMonto_renovados() == null || reporteCredito.getMonto_renovados().isEmpty() ? "0" : reporteCredito.getMonto_renovados(), ReporteCreditosFragment.this.sesion.getString("id", ""), fechaAgregar, "", "off");
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void editarRegistroReporte(final ReporteCreditos reporteCredito) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"editReporteCreditos");
            data.put("id", (Object)reporteCredito.getId());
            data.put("observaciones", (Object)reporteCredito.getObservaciones());
            data.put("creditos_otorgados", (Object)(TextUtils.isEmpty((CharSequence)reporteCredito.getCreditos_otorgados()) ? "0" : reporteCredito.getCreditos_otorgados()));
            data.put("total_prestamos", (Object)(TextUtils.isEmpty((CharSequence)reporteCredito.getTotal_prestamos()) ? "0" : reporteCredito.getTotal_prestamos()));
            data.put("prestamos_nuevos", (Object)(TextUtils.isEmpty((CharSequence)reporteCredito.getPrestamos_nuevos()) ? "0" : reporteCredito.getPrestamos_nuevos()));
            data.put("monto_nuevos", (Object)(TextUtils.isEmpty((CharSequence)reporteCredito.getMonto_nuevos()) ? "0" : reporteCredito.getMonto_nuevos()));
            data.put("prestamos_renovados", (Object)(TextUtils.isEmpty((CharSequence)reporteCredito.getPrestamos_renovados()) ? "0" : reporteCredito.getPrestamos_renovados()));
            data.put("monto_renovados", (Object)(TextUtils.isEmpty((CharSequence)reporteCredito.getMonto_renovados()) ? "0" : reporteCredito.getMonto_renovados()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    String message = (String)response.get("message");
                    ReporteCreditosFragment.this.actualizarReporteEnSQLite(reporteCredito.getId(), reporteCredito.getObservaciones(), TextUtils.isEmpty((CharSequence)reporteCredito.getCreditos_otorgados()) ? "0" : reporteCredito.getCreditos_otorgados(), TextUtils.isEmpty((CharSequence)reporteCredito.getTotal_prestamos()) ? "0" : reporteCredito.getTotal_prestamos(), TextUtils.isEmpty((CharSequence)reporteCredito.getPrestamos_nuevos()) ? "0" : reporteCredito.getPrestamos_nuevos(), TextUtils.isEmpty((CharSequence)reporteCredito.getMonto_nuevos()) ? "0" : reporteCredito.getMonto_nuevos(), TextUtils.isEmpty((CharSequence)reporteCredito.getPrestamos_renovados()) ? "0" : reporteCredito.getPrestamos_renovados(), TextUtils.isEmpty((CharSequence)reporteCredito.getMonto_renovados()) ? "0" : reporteCredito.getMonto_renovados(), "on");
                    ReporteCreditosFragment.this.getReporteCreditos(ReporteCreditosFragment.this.ruta_id, ReporteCreditosFragment.this.tlFecha.getEditText().getText().toString(), ReporteCreditosFragment.this.sesion.getString("id", ""));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteCreditosFragment.this.getActivity());
                ReporteCreditosFragment.this.actualizarReporteEnSQLite(reporteCredito.getId(), reporteCredito.getObservaciones(), TextUtils.isEmpty((CharSequence)reporteCredito.getCreditos_otorgados()) ? "0" : reporteCredito.getCreditos_otorgados(), TextUtils.isEmpty((CharSequence)reporteCredito.getTotal_prestamos()) ? "0" : reporteCredito.getTotal_prestamos(), TextUtils.isEmpty((CharSequence)reporteCredito.getPrestamos_nuevos()) ? "0" : reporteCredito.getPrestamos_nuevos(), TextUtils.isEmpty((CharSequence)reporteCredito.getMonto_nuevos()) ? "0" : reporteCredito.getMonto_nuevos(), TextUtils.isEmpty((CharSequence)reporteCredito.getPrestamos_renovados()) ? "0" : reporteCredito.getPrestamos_renovados(), TextUtils.isEmpty((CharSequence)reporteCredito.getMonto_renovados()) ? "0" : reporteCredito.getMonto_renovados(), "off");
                ReporteCreditosFragment.this.getReporteCreditos(ReporteCreditosFragment.this.ruta_id, ReporteCreditosFragment.this.tlFecha.getEditText().getText().toString(), ReporteCreditosFragment.this.sesion.getString("id", ""));
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualizarReporteEnSQLite(String id2, String observaciones, String creditos_otorgados, String total_prestamos, String prestamos_nuevos, String monto_nuevos, String prestamos_renovados, String monto_renovados, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.getActivity());
        try (SQLiteDatabase db = dbHelper.getWritableDatabase();){
            ContentValues valores = new ContentValues();
            valores.put("observaciones", observaciones);
            valores.put("creditos_otorgados", creditos_otorgados);
            valores.put("total_prestamos", total_prestamos);
            valores.put("prestamos_nuevos", prestamos_nuevos);
            valores.put("monto_nuevos", monto_nuevos);
            valores.put("prestamos_renovados", prestamos_renovados);
            valores.put("monto_renovados", monto_renovados);
            long timestamp = System.currentTimeMillis();
            if (online != "off") {
                valores.put("status", "0");
                timestamp -= 10000L;
            } else {
                valores.put("status", "2");
                timestamp += 10000L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            String formattedDate = sdf.format(new Date(timestamp));
            valores.put("fecha_registro", formattedDate);
            int filasActualizadas = db.update("reporte_creditos", valores, "id = ?", new String[]{id2});
            if (filasActualizadas > 0) {
                Log.d((String)"SQLite", (String)("Reporte actualizado con \u00e9xito en SQLite con ID: " + id2));
            } else {
                Log.d((String)"SQLite", (String)("No se encontr\u00f3 el reporte con ID: " + id2 + " para actualizar."));
            }
        }
    }
}

