/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.reporteDiario;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.GastosController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.ReporteDiarioDeRutasController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Gastos;
import com.example.sefinsa_app.models.ReporteDiario;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.reporteDiario.ReporteDiarioViewModel;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteDiarioAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReporteDiarioFragment
extends Fragment {
    private ReporteDiarioViewModel mViewModel;
    private SharedPreferences sesion;
    private ArrayList<ReporteDiario> reporteDiarios;
    private ArrayList<ReporteDiario> reporteDiariosFiltrado;
    private ArrayList<ReporteDiario> reportesFiltradosNombres;
    private ArrayList<ReporteDiario> reportesAgregados;
    private TextInputLayout tlFecha;
    private TextInputLayout tlRuta;
    private TextInputLayout tlNombre;
    private Button btnGastos;
    private Button btnGuardar;
    private Button btnTotales;
    private Button btnAgregar;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;
    private GastosController gastosController;
    private ReporteDiarioDeRutasController reportediarioderutasController;
    private RutaController rutaController;
    private String ruta_id = "";
    private String gastos_id = "";
    private int previousLength;
    private boolean backSpace;
    private static ProgressDialog dialog;
    private RecyclerView recyclerView;
    private ReporteDiarioAdapter reporteDiarioAdapter;
    private LinearLayoutManager linearLayoutManager;
    private AutoCompleteTextView rutasAutoCompleteTextView;
    private Gastos gastos;
    private boolean buscarReporte = false;
    private TextInputEditText svPoblaciones;
    ArrayList<ReporteDiario> poblacionesReporte;
    ArrayAdapter<ReporteDiario> poblacionesAdapter;
    String poblacion_id = "";
    String poblacion_nombre = "";
    String estimado_poblacion = "";
    String gasto_id = "";
    private PoblacionController poblacionController;
    private int contador = 0;

    public static ReporteDiarioFragment newInstance() {
        return new ReporteDiarioFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        this.requireActivity().setRequestedOrientation(-1);
        return inflater.inflate(2131492974, container, false);
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        this.rutasAutoCompleteTextView.setText((CharSequence)"", false);
        if (this.svPoblaciones != null) {
            this.svPoblaciones.setText((CharSequence)"");
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                Log.d((String)"ReporteDiarioFragment", (String)"Refresh seleccionado...................");
                this.getNuevoReporteDiarioRutasOnline();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void getNuevoReporteDiarioRutasOnlineUpd() {
        dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        Log.d((String)"DEBUG", (String)"Entro en actualizar registros al INICIO...........");
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getReporteDiarioRutasAPP");
            data.put("empleado_id", (Object)this.sesion.getString("id", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray reportesArray = response.getJSONArray("data");
                        JSONArray reporteArray = new JSONArray();
                        JSONArray gastosArray = new JSONArray();
                        for (int i = 0; i < reportesArray.length(); ++i) {
                            JSONObject reporteCompleto = reportesArray.getJSONObject(i);
                            JSONObject reporte = new JSONObject();
                            reporte.put("id", (Object)reporteCompleto.getString("id"));
                            reporte.put("poblacion_id", (Object)reporteCompleto.getString("poblacion_id"));
                            reporte.put("estimacion", (Object)reporteCompleto.getString("estimacion"));
                            reporte.put("abonos_semana", (Object)reporteCompleto.getString("abonos_semana"));
                            reporte.put("recuperacion_semana", (Object)reporteCompleto.getString("recuperacion_semana"));
                            reporte.put("recuperacion_vencida", (Object)reporteCompleto.getString("recuperacion_vencida"));
                            reporte.put("anticipos", (Object)reporteCompleto.getString("anticipos"));
                            reporte.put("total_1", (Object)reporteCompleto.getString("total_1"));
                            reporte.put("recuperacion_prestamos", (Object)reporteCompleto.getString("recuperacion_prestamos"));
                            reporte.put("colocacion", (Object)reporteCompleto.getString("colocacion"));
                            reporte.put("prestamo_colocadora", (Object)reporteCompleto.getString("prestamo_colocadora"));
                            reporte.put("comision", (Object)reporteCompleto.getString("comision"));
                            reporte.put("bono_colocadora", (Object)reporteCompleto.getString("bono_colocadora"));
                            reporte.put("total_2", (Object)reporteCompleto.getString("total_2"));
                            reporte.put("saldo", (Object)reporteCompleto.getString("saldo"));
                            reporte.put("pendiente_recuperar", (Object)reporteCompleto.getString("pendiente_recuperar"));
                            reporte.put("abonos_recuperar", (Object)reporteCompleto.getString("abonos_recuperar"));
                            reporte.put("comentario", (Object)reporteCompleto.getString("comentario"));
                            reporte.put("empleado_id", (Object)reporteCompleto.getString("empleado_id"));
                            reporte.put("gastos_id", (Object)reporteCompleto.getString("gastos_id"));
                            reporte.put("fecha", (Object)reporteCompleto.getString("fecha"));
                            reporte.put("fecha_registro", (Object)reporteCompleto.getString("fecha_registro"));
                            reporteArray.put((Object)reporte);
                            JSONObject gasto = new JSONObject();
                            gasto.put("id", (Object)reporteCompleto.getString("gastos_id"));
                            gasto.put("otros", (Object)reporteCompleto.optString("otros", "0"));
                            gasto.put("gasolina", (Object)reporteCompleto.optString("gasolina", "0"));
                            gasto.put("hotel", (Object)reporteCompleto.optString("hotel", "0"));
                            gasto.put("alimentos", (Object)reporteCompleto.optString("alimentos", "0"));
                            gasto.put("casetas", (Object)reporteCompleto.optString("casetas", "0"));
                            gasto.put("total", (Object)reporteCompleto.optString("total_gastos", "0"));
                            gastosArray.put((Object)gasto);
                        }
                        ReporteDiarioFragment.this.updateDatosEnSQLite(reporteArray, gastosArray);
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Datos sincronizados correctamente", (int)0).show();
                    } else {
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"No se encontraron datos para sincronizar", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    dialog.dismiss();
                    e.printStackTrace();
                    Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Error al procesar datos del servidor", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private boolean isFechaMasReciente(String fechaServidor, String fechaLocal) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date fechaServidorDate = dateFormat.parse(fechaServidor);
            Date fechaLocalDate = dateFormat.parse(fechaLocal);
            return Objects.requireNonNull(fechaServidorDate).after(fechaLocalDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatosEnSQLite(JSONArray reporteArray, JSONArray gastosArray) {
        try (SQLiteDatabase db = new DatabaseHelper((Context)this.getActivity()).getWritableDatabase();){
            String id2;
            int i;
            for (i = 0; i < reporteArray.length(); ++i) {
                ContentValues values;
                JSONObject reporte = reporteArray.getJSONObject(i);
                id2 = reporte.getString("id");
                String fecha_registro_servidor = reporte.getString("fecha_registro");
                String fecha_registro_local = this.getFechaRegistroSQLite(db, id2);
                if (fecha_registro_local == null || fecha_registro_local.isEmpty()) {
                    values = new ContentValues();
                    this.insertAllFields(values, reporte);
                    values.put("fecha_registro", fecha_registro_servidor);
                    long newRowId = db.insert("reporte_diario_rutas", null, values);
                    Log.d((String)"DEBUG", (String)("Se insert\u00f3 un nuevo registro con ID " + id2 + ": " + newRowId));
                    continue;
                }
                if (this.isFechaMasReciente(fecha_registro_servidor, fecha_registro_local)) {
                    values = new ContentValues();
                    this.insertAllFields(values, reporte);
                    values.put("fecha_registro", fecha_registro_servidor);
                    int rowsAffected = db.update("reporte_diario_rutas", values, "id = ?", new String[]{id2});
                    Log.d((String)"DEBUG", (String)("N\u00famero de filas actualizadas para ID " + id2 + ": " + rowsAffected));
                    continue;
                }
                Log.d((String)"DEBUG", (String)("La fecha del servidor no es m\u00e1s reciente para el reporte ID " + id2));
            }
            for (i = 0; i < gastosArray.length(); ++i) {
                JSONObject gasto = gastosArray.getJSONObject(i);
                id2 = gasto.getString("id");
                if (!this.existeGastoEnSQLite(db, id2)) {
                    ContentValues values = new ContentValues();
                    values.put("id", id2);
                    values.put("otros", gasto.getString("otros"));
                    values.put("gasolina", gasto.getString("gasolina"));
                    values.put("hotel", gasto.getString("hotel"));
                    values.put("alimentos", gasto.getString("alimentos"));
                    values.put("casetas", gasto.getString("casetas"));
                    values.put("total", gasto.getString("total"));
                    long newRowId = db.insert("gastos", null, values);
                    Log.d((String)"DEBUG", (String)("Se insert\u00f3 un nuevo gasto con ID " + id2 + ": " + newRowId));
                    continue;
                }
                Log.d((String)"DEBUG", (String)("El gasto con ID " + id2 + " ya existe. No se insert\u00f3."));
            }
        }
    }

    private void insertAllFields(ContentValues values, JSONObject reporte) {
        try {
            values.put("poblacion_id", reporte.getString("poblacion_id"));
            values.put("estimacion", reporte.getString("estimacion"));
            values.put("abonos_semana", reporte.getString("abonos_semana"));
            values.put("recuperacion_semana", reporte.getString("recuperacion_semana"));
            values.put("recuperacion_vencida", reporte.getString("recuperacion_vencida"));
            values.put("anticipos", reporte.getString("anticipos"));
            values.put("total_1", reporte.getString("total_1"));
            values.put("recuperacion_prestamos", reporte.getString("recuperacion_prestamos"));
            values.put("colocacion", reporte.getString("colocacion"));
            values.put("prestamo_colocadora", reporte.getString("prestamo_colocadora"));
            values.put("comision", reporte.getString("comision"));
            values.put("bono_colocadora", reporte.getString("bono_colocadora"));
            values.put("total_2", reporte.getString("total_2"));
            values.put("saldo", reporte.getString("saldo"));
            values.put("pendiente_recuperar", reporte.getString("pendiente_recuperar"));
            values.put("abonos_recuperar", reporte.getString("abonos_recuperar"));
            values.put("comentario", reporte.getString("comentario"));
            values.put("empleado_id", reporte.getString("empleado_id"));
            values.put("gastos_id", reporte.getString("gastos_id"));
            values.put("fecha", reporte.getString("fecha"));
        }
        catch (JSONException e) {
            Log.e((String)"ERROR", (String)("Error insertando los campos del reporte: " + e.getMessage()));
        }
    }

    private boolean existeGastoEnSQLite(SQLiteDatabase db, String id2) {
        boolean existe = false;
        Cursor cursor = db.rawQuery("SELECT id FROM gastos WHERE id = ?", new String[]{id2});
        if (cursor.moveToFirst()) {
            existe = true;
        }
        cursor.close();
        return existe;
    }

    private String getFechaRegistroSQLite(SQLiteDatabase db, String id2) {
        String fecha_registro = "";
        Cursor cursor = db.rawQuery("SELECT fecha_registro FROM reporte_diario_rutas WHERE id = ?", new String[]{id2});
        if (cursor.moveToFirst()) {
            fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
        }
        cursor.close();
        return fecha_registro;
    }

    private void getNuevoReporteDiarioRutasOnline() {
        dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getReporteDiarioRutasAPP");
            data.put("empleado_id", (Object)this.sesion.getString("id", ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        JSONArray reportesArray = response.getJSONArray("data");
                        JSONArray reporteArray = new JSONArray();
                        JSONArray gastosArray = new JSONArray();
                        for (int i = 0; i < reportesArray.length(); ++i) {
                            JSONObject reporteCompleto = reportesArray.getJSONObject(i);
                            JSONObject reporte = new JSONObject();
                            reporte.put("id", (Object)reporteCompleto.getString("id"));
                            reporte.put("poblacion_id", (Object)reporteCompleto.getString("poblacion_id"));
                            reporte.put("estimacion", (Object)reporteCompleto.getString("estimacion"));
                            reporte.put("abonos_semana", (Object)reporteCompleto.getString("abonos_semana"));
                            reporte.put("recuperacion_semana", (Object)reporteCompleto.getString("recuperacion_semana"));
                            reporte.put("recuperacion_vencida", (Object)reporteCompleto.getString("recuperacion_vencida"));
                            reporte.put("anticipos", (Object)reporteCompleto.getString("anticipos"));
                            reporte.put("total_1", (Object)reporteCompleto.getString("total_1"));
                            reporte.put("recuperacion_prestamos", (Object)reporteCompleto.getString("recuperacion_prestamos"));
                            reporte.put("colocacion", (Object)reporteCompleto.getString("colocacion"));
                            reporte.put("prestamo_colocadora", (Object)reporteCompleto.getString("prestamo_colocadora"));
                            reporte.put("comision", (Object)reporteCompleto.getString("comision"));
                            reporte.put("bono_colocadora", (Object)reporteCompleto.getString("bono_colocadora"));
                            reporte.put("total_2", (Object)reporteCompleto.getString("total_2"));
                            reporte.put("saldo", (Object)reporteCompleto.getString("saldo"));
                            reporte.put("pendiente_recuperar", (Object)reporteCompleto.getString("pendiente_recuperar"));
                            reporte.put("abonos_recuperar", (Object)reporteCompleto.getString("abonos_recuperar"));
                            reporte.put("comentario", (Object)reporteCompleto.getString("comentario"));
                            reporte.put("empleado_id", (Object)reporteCompleto.getString("empleado_id"));
                            reporte.put("gastos_id", (Object)reporteCompleto.getString("gastos_id"));
                            reporte.put("fecha", (Object)reporteCompleto.getString("fecha"));
                            reporte.put("fecha_registro", (Object)reporteCompleto.getString("fecha_registro"));
                            reporteArray.put((Object)reporte);
                            JSONObject gasto = new JSONObject();
                            gasto.put("id", (Object)reporteCompleto.getString("gastos_id"));
                            gasto.put("otros", (Object)reporteCompleto.optString("otros", "0"));
                            gasto.put("gasolina", (Object)reporteCompleto.optString("gasolina", "0"));
                            gasto.put("hotel", (Object)reporteCompleto.optString("hotel", "0"));
                            gasto.put("alimentos", (Object)reporteCompleto.optString("alimentos", "0"));
                            gasto.put("casetas", (Object)reporteCompleto.optString("casetas", "0"));
                            gasto.put("total", (Object)reporteCompleto.optString("total_gastos", "0"));
                            gastosArray.put((Object)gasto);
                        }
                        ReporteDiarioFragment.this.insertarDatosEnSQLite(reporteArray, gastosArray);
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Datos sincronizados correctamente", (int)0).show();
                    } else {
                        dialog.dismiss();
                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"No se encontraron datos para sincronizar", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    dialog.dismiss();
                    e.printStackTrace();
                    Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Error al procesar datos del servidor", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertarDatosEnSQLite(JSONArray reporteArray, JSONArray gastosArray) {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        try {
            ContentValues values;
            int i;
            db.beginTransaction();
            for (i = 0; i < reporteArray.length(); ++i) {
                JSONObject reporte = reporteArray.getJSONObject(i);
                values = new ContentValues();
                values.put("id", reporte.getString("id"));
                values.put("poblacion_id", reporte.getString("poblacion_id"));
                values.put("estimacion", reporte.getString("estimacion"));
                values.put("abonos_semana", reporte.getString("abonos_semana"));
                values.put("recuperacion_semana", reporte.getString("recuperacion_semana"));
                values.put("recuperacion_vencida", reporte.getString("recuperacion_vencida"));
                values.put("anticipos", reporte.getString("anticipos"));
                values.put("total_1", reporte.getString("total_1"));
                values.put("recuperacion_prestamos", reporte.getString("recuperacion_prestamos"));
                values.put("colocacion", reporte.getString("colocacion"));
                values.put("prestamo_colocadora", reporte.getString("prestamo_colocadora"));
                values.put("comision", reporte.getString("comision"));
                values.put("bono_colocadora", reporte.getString("bono_colocadora"));
                values.put("total_2", reporte.getString("total_2"));
                values.put("saldo", reporte.getString("saldo"));
                values.put("pendiente_recuperar", reporte.getString("pendiente_recuperar"));
                values.put("abonos_recuperar", reporte.getString("abonos_recuperar"));
                values.put("comentario", reporte.getString("comentario"));
                values.put("empleado_id", reporte.getString("empleado_id"));
                values.put("gastos_id", reporte.getString("gastos_id"));
                values.put("fecha", reporte.getString("fecha"));
                values.put("fecha_registro", reporte.getString("fecha_registro"));
                db.insertWithOnConflict("reporte_diario_rutas", null, values, 5);
            }
            for (i = 0; i < gastosArray.length(); ++i) {
                JSONObject gasto = gastosArray.getJSONObject(i);
                values = new ContentValues();
                values.put("id", gasto.getString("id"));
                values.put("otros", gasto.getString("otros"));
                values.put("gasolina", gasto.getString("gasolina"));
                values.put("hotel", gasto.getString("hotel"));
                values.put("alimentos", gasto.getString("alimentos"));
                values.put("casetas", gasto.getString("casetas"));
                values.put("total", gasto.getString("total"));
                db.insertWithOnConflict("gastos", null, values, 5);
            }
            db.setTransactionSuccessful();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
            db.close();
        }
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "ReporteDiarioFragment";
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.initElements(view);
        if (this.isTableExistsAndHasData("reporte_diario_rutas")) {
            this.getNuevoReporteDiarioRutasOnlineUpd();
        } else {
            this.getNuevoReporteDiarioRutasOnlineUpd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTableExistsAndHasData(String tableName) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        boolean result = false;
        try {
            db = new DatabaseHelper((Context)this.getActivity()).getReadableDatabase();
            String queryTableExists = "SELECT name FROM sqlite_master WHERE type='table' AND name=?";
            cursor = db.rawQuery(queryTableExists, new String[]{tableName});
            if (cursor.getCount() > 0) {
                cursor.close();
                String queryTableHasData = "SELECT COUNT(*) FROM " + tableName;
                cursor = db.rawQuery(queryTableHasData, null);
                if (cursor.moveToFirst()) {
                    int rowCount = cursor.getInt(0);
                    result = rowCount > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    public void initElements(View view) {
        this.poblacionesReporte = new ArrayList();
        this.reporteDiariosFiltrado = new ArrayList();
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.svPoblaciones = (TextInputEditText)view.findViewById(2131297083);
        this.svPoblaciones.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                ReporteDiarioFragment.this.filtrarReportePoblaciones(editable.toString());
            }
        });
        this.rutaController = new RutaController((Context)this.getActivity());
        this.gastosController = new GastosController((Context)this.getActivity());
        this.reportediarioderutasController = new ReporteDiarioDeRutasController((Context)this.getActivity());
        this.recyclerView = (RecyclerView)view.findViewById(2131296987);
        this.rutasAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296288);
        this.reporteDiarios = new ArrayList();
        this.reportesAgregados = new ArrayList();
        this.rutas = new ArrayList();
        this.gastos = new Gastos();
        if (this.verificarTablaExiste("gastos")) {
            Log.d((String)"DEBUG", (String)"La tabla 'gastos' existe.");
        } else {
            Log.d((String)"DEBUG", (String)"La tabla 'gastos' no existe.");
        }
        if (this.verificarTablaExiste("reporte_diario_rutas")) {
            Log.d((String)"DEBUG", (String)"La tabla 'reporte_diario_rutas' existe.");
        } else {
            Log.d((String)"DEBUG", (String)"La tabla 'reporte_diario_rutas' no existe.");
        }
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.reporteDiarioAdapter = new ReporteDiarioAdapter((Context)this.getActivity(), this.reporteDiarios);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.reporteDiarioAdapter);
        this.btnGastos = (Button)view.findViewById(2131296428);
        this.btnGuardar = (Button)view.findViewById(2131296432);
        this.btnTotales = (Button)view.findViewById(2131296456);
        this.btnAgregar = (Button)view.findViewById(2131296392);
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlNombre = (TextInputLayout)view.findViewById(2131297200);
        this.tlNombre.getEditText().setText((CharSequence)this.sesion.getString("nombre", ""));
        this.tlFecha.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(ReporteDiarioFragment.this.getChildFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Object selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date((Long)selection + (long)offsetFromUTC);
                        ReporteDiarioFragment.this.tlFecha.getEditText().setText((CharSequence)simpleFormat.format(date));
                    }
                });
            }
        });
        this.getRutas();
        this.rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = (Ruta)ReporteDiarioFragment.this.rutasAdapter.getItem(i);
                ReporteDiarioFragment.this.ruta_id = ruta.getId();
                ReporteDiarioFragment.this.filtrarReporte(ReporteDiarioFragment.this.ruta_id);
            }
        });
        this.rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteDiarioFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteDiarioFragment.this.backSpace = ReporteDiarioFragment.this.previousLength > s.length();
                if (ReporteDiarioFragment.this.backSpace && !ReporteDiarioFragment.this.ruta_id.equals("")) {
                    ReporteDiarioFragment.this.ruta_id = "";
                    ReporteDiarioFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                    ReporteDiarioFragment.this.reporteDiarioAdapter.setListaFiltrada(ReporteDiarioFragment.this.reporteDiarios);
                }
            }
        });
        new MaterialAlertDialogBuilder((Context)this.getActivity()).setCancelable(false).setTitle((CharSequence)"Opciones").setPositiveButton((CharSequence)"Nuevo reporte", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ReporteDiarioFragment.this.buscarReporte = false;
                ReporteDiarioFragment.this.reporteDiarioAdapter.setBuscarReporte(false);
                String rutaIdSesion = ReporteDiarioFragment.this.sesion.getString("rutas", "");
                Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
                List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
                Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
                Integer rutaMinima = null;
                try {
                    List rutaIdsNumericos = null;
                    if (Build.VERSION.SDK_INT >= 24) {
                        rutaIdsNumericos = rutaIdsSesion.stream().filter(id2 -> !id2.trim().isEmpty()).map(Integer::parseInt).collect(Collectors.toList());
                    }
                    rutaMinima = (Integer)Collections.min(rutaIdsNumericos);
                    Log.d((String)"getRutas", (String)("Ruta m\u00ednima: " + rutaMinima));
                }
                catch (NumberFormatException e) {
                    Log.e((String)"getRutas", (String)"Error al convertir ruta IDs a enteros", (Throwable)e);
                }
                ReporteDiarioFragment.this.getNuevoReporteDiarioRutas(null);
            }
        }).setNegativeButton((CharSequence)"Buscar", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ReporteDiarioFragment.this.buscarReporte = true;
                ReporteDiarioFragment.this.reporteDiarioAdapter.setBuscarReporte(true);
                ReporteDiarioFragment.this.tlFecha.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        if (Validator.fieldValidation(ReporteDiarioFragment.this.tlRuta, "Ingresa una ruta")) {
                            ReporteDiarioFragment.this.getReporteDiarioRutas(ReporteDiarioFragment.this.ruta_id, ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), ReporteDiarioFragment.this.sesion.getString("id", ""));
                        }
                    }
                });
            }
        }).show();
        this.btnAgregar.setOnClickListener(new View.OnClickListener(){

            @RequiresApi(api=24)
            public void onClick(View view) {
                View dialogView = LayoutInflater.from((Context)ReporteDiarioFragment.this.getActivity()).inflate(2131492942, null, false);
                AutoCompleteTextView poblacionesAutoCompleteTextView = (AutoCompleteTextView)dialogView.findViewById(2131296285);
                final TextInputLayout tlEstimacion = (TextInputLayout)dialogView.findViewById(2131297176);
                final TextInputLayout tlAbonosSemana = (TextInputLayout)dialogView.findViewById(2131297153);
                final TextInputLayout tlRecupSemana = (TextInputLayout)dialogView.findViewById(2131297227);
                final TextInputLayout tlAnticipos = (TextInputLayout)dialogView.findViewById(2131297155);
                final TextInputLayout tlTotal1 = (TextInputLayout)dialogView.findViewById(2131297239);
                final TextInputLayout tlRecupPrestamos = (TextInputLayout)dialogView.findViewById(2131297226);
                final TextInputLayout tlColocacion = (TextInputLayout)dialogView.findViewById(2131297160);
                final TextInputLayout tlPrestamoColocadora = (TextInputLayout)dialogView.findViewById(2131297220);
                final TextInputLayout tlComision = (TextInputLayout)dialogView.findViewById(2131297166);
                final TextInputLayout tlBonoColocadora = (TextInputLayout)dialogView.findViewById(2131297157);
                final TextInputLayout tlTotal2 = (TextInputLayout)dialogView.findViewById(2131297240);
                final TextInputLayout tlSaldo = (TextInputLayout)dialogView.findViewById(2131297231);
                final TextInputLayout tlPendienteRecup = (TextInputLayout)dialogView.findViewById(2131297216);
                final TextInputLayout tlAbonosRecup = (TextInputLayout)dialogView.findViewById(2131297152);
                final int[] total1 = new int[]{0};
                final int[] total2 = new int[]{0};
                final int[] saldo = new int[]{0};
                tlRecupSemana.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        total1[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlAnticipos.getEditText().getText().toString().equals("") ? "0" : tlAnticipos.getEditText().getText().toString());
                        tlTotal1.getEditText().setText((CharSequence)String.valueOf(total1[0]));
                    }
                });
                tlAnticipos.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        total1[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlRecupSemana.getEditText().getText().toString().equals("") ? "0" : tlRecupSemana.getEditText().getText().toString());
                        tlTotal1.getEditText().setText((CharSequence)String.valueOf(total1[0]));
                    }
                });
                tlColocacion.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        total2[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()) + Integer.parseInt(tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()) + Integer.parseInt(tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString());
                        tlTotal2.getEditText().setText((CharSequence)String.valueOf(total2[0]));
                    }
                });
                tlPrestamoColocadora.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        total2[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()) + Integer.parseInt(tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()) + Integer.parseInt(tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString());
                        tlTotal2.getEditText().setText((CharSequence)String.valueOf(total2[0]));
                    }
                });
                tlComision.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        total2[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()) + Integer.parseInt(tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()) + Integer.parseInt(tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString());
                        tlTotal2.getEditText().setText((CharSequence)String.valueOf(total2[0]));
                    }
                });
                tlBonoColocadora.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        total2[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()) + Integer.parseInt(tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()) + Integer.parseInt(tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString());
                        tlTotal2.getEditText().setText((CharSequence)String.valueOf(total2[0]));
                    }
                });
                tlTotal2.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        saldo[0] = Integer.parseInt(tlTotal1.getEditText().getText().toString().equals("") ? "0" : tlTotal1.getEditText().getText().toString()) - Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString());
                        tlSaldo.getEditText().setText((CharSequence)String.valueOf(saldo[0]));
                    }
                });
                ReporteDiarioFragment.this.poblacionesReporte.clear();
                if (ReporteDiarioFragment.this.poblacionesReporte.size() == 0) {
                    ReporteDiarioFragment.this.getPoblaciones(ReporteDiarioFragment.this.ruta_id, poblacionesAutoCompleteTextView);
                }
                poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    @RequiresApi(api=24)
                    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                        ReporteDiario reporteDiario = (ReporteDiario)ReporteDiarioFragment.this.poblacionesAdapter.getItem(i);
                        ReporteDiarioFragment.this.poblacion_nombre = reporteDiario.getNombre_poblacion();
                        ReporteDiarioFragment.this.poblacion_id = reporteDiario.getPoblacion_id();
                        ReporteDiarioFragment.this.poblacion_nombre = reporteDiario.getNombre_poblacion();
                        ReporteDiarioFragment.this.estimado_poblacion = reporteDiario.getEstimado();
                        tlEstimacion.getEditText().setText((CharSequence)ReporteDiarioFragment.this.estimado_poblacion);
                    }
                });
                new MaterialAlertDialogBuilder((Context)ReporteDiarioFragment.this.getActivity()).setCancelable(false).setView(dialogView).setTitle((CharSequence)"Agregar registro al reporte").setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (!ReporteDiarioFragment.this.poblacion_id.equals("")) {
                            Log.d((String)"ReporteDiarioFragment", (String)("Dato en Agregar registro al reporte>Guardar. ID GASTOS" + ReporteDiarioFragment.this.gastos_id));
                            ReporteDiario nuevoRegistro = new ReporteDiario("", ReporteDiarioFragment.this.poblacion_id, tlEstimacion.getEditText().getText().toString(), "", tlAbonosSemana.getEditText().getText().toString(), tlRecupSemana.getEditText().getText().toString(), tlAnticipos.getEditText().getText().toString(), tlTotal1.getEditText().getText().toString(), tlRecupPrestamos.getEditText().getText().toString(), tlColocacion.getEditText().getText().toString(), tlPrestamoColocadora.getEditText().getText().toString(), tlComision.getEditText().getText().toString(), tlBonoColocadora.getEditText().getText().toString(), tlTotal2.getEditText().getText().toString(), tlSaldo.getEditText().getText().toString(), tlPendienteRecup.getEditText().getText().toString(), tlAbonosRecup.getEditText().getText().toString(), "", "", ReporteDiarioFragment.this.gastos_id, "", "", ((ReporteDiario)ReporteDiarioFragment.this.reporteDiarios.get(0)).getComentario());
                            nuevoRegistro.setNombre_poblacion(ReporteDiarioFragment.this.poblacion_nombre);
                            nuevoRegistro.setSeleccionado(true);
                            ReporteDiarioFragment.this.reportesAgregados.add(nuevoRegistro);
                            ReporteDiarioFragment.this.reporteDiarios.add(nuevoRegistro);
                            ReporteDiarioFragment.this.reporteDiarioAdapter.addAll(ReporteDiarioFragment.this.reporteDiarios);
                            ReporteDiarioFragment.this.reporteDiarioAdapter.notifyItemRangeChanged(ReporteDiarioFragment.this.reporteDiarios.size(), 1);
                            ReporteDiarioFragment.this.poblacion_id = "";
                            ReporteDiarioFragment.this.poblacion_nombre = "";
                        } else {
                            Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Selecciona una poblaci\u00f3n", (int)0).show();
                        }
                    }
                }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
        this.btnGastos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                final int[] totalGastos = new int[]{0};
                View dialogView = LayoutInflater.from((Context)ReporteDiarioFragment.this.getActivity()).inflate(2131492933, null, false);
                final TextInputLayout tlOtros = (TextInputLayout)dialogView.findViewById(2131297212);
                final TextInputLayout tlGasolina = (TextInputLayout)dialogView.findViewById(2131297187);
                final TextInputLayout tlHotel = (TextInputLayout)dialogView.findViewById(2131297192);
                final TextInputLayout tlAlimentos = (TextInputLayout)dialogView.findViewById(2131297154);
                final TextInputLayout tlCasetas = (TextInputLayout)dialogView.findViewById(2131297159);
                final TextInputLayout tlTotal = (TextInputLayout)dialogView.findViewById(2131297238);
                Log.d((String)"ReporteDiarioFragment", (String)("Datos para llenar campo de getOtros.............." + ReporteDiarioFragment.this.gastos.getOtros()));
                Log.d((String)"ReporteDiarioFragment", (String)("Datos para llenar campo de getGasolina.............." + ReporteDiarioFragment.this.gastos.getGasolina()));
                Log.d((String)"ReporteDiarioFragment", (String)("Datos para llenar campo de getHotel.............." + ReporteDiarioFragment.this.gastos.getHotel()));
                Log.d((String)"ReporteDiarioFragment", (String)("Datos para llenar campo de getAlimentos.............." + ReporteDiarioFragment.this.gastos.getAlimentos()));
                Log.d((String)"ReporteDiarioFragment", (String)("Datos para llenar campo de getCasetas.............." + ReporteDiarioFragment.this.gastos.getCasetas()));
                Log.d((String)"ReporteDiarioFragment", (String)("Datos para llenar campo de getTotal.............." + ReporteDiarioFragment.this.gastos.getTotal()));
                tlOtros.getEditText().setText((CharSequence)ReporteDiarioFragment.this.gastos.getOtros());
                tlGasolina.getEditText().setText((CharSequence)ReporteDiarioFragment.this.gastos.getGasolina());
                tlHotel.getEditText().setText((CharSequence)ReporteDiarioFragment.this.gastos.getHotel());
                tlAlimentos.getEditText().setText((CharSequence)ReporteDiarioFragment.this.gastos.getAlimentos());
                tlCasetas.getEditText().setText((CharSequence)ReporteDiarioFragment.this.gastos.getCasetas());
                tlTotal.getEditText().setText((CharSequence)ReporteDiarioFragment.this.gastos.getTotal());
                tlOtros.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        totalGastos[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()) + Integer.parseInt(tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()) + Integer.parseInt(tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()) + Integer.parseInt(tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString());
                        tlTotal.getEditText().setText((CharSequence)String.valueOf(totalGastos[0]));
                    }
                });
                tlGasolina.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        totalGastos[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString()) + Integer.parseInt(tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()) + Integer.parseInt(tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()) + Integer.parseInt(tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString());
                        tlTotal.getEditText().setText((CharSequence)String.valueOf(totalGastos[0]));
                    }
                });
                tlHotel.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        totalGastos[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()) + Integer.parseInt(tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString()) + Integer.parseInt(tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()) + Integer.parseInt(tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString());
                        tlTotal.getEditText().setText((CharSequence)String.valueOf(totalGastos[0]));
                    }
                });
                tlAlimentos.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        totalGastos[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()) + Integer.parseInt(tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()) + Integer.parseInt(tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString()) + Integer.parseInt(tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString());
                        tlTotal.getEditText().setText((CharSequence)String.valueOf(totalGastos[0]));
                    }
                });
                tlCasetas.getEditText().addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    }

                    public void afterTextChanged(Editable editable) {
                        totalGastos[0] = Integer.parseInt(editable.toString().equals("") ? "0" : editable.toString()) + Integer.parseInt(tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()) + Integer.parseInt(tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()) + Integer.parseInt(tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()) + Integer.parseInt(tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString());
                        tlTotal.getEditText().setText((CharSequence)String.valueOf(totalGastos[0]));
                    }
                });
                new MaterialAlertDialogBuilder((Context)ReporteDiarioFragment.this.getActivity()).setCancelable(false).setView(dialogView).setTitle((CharSequence)"Gastos").setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (ReporteDiarioFragment.this.buscarReporte) {
                            Log.d((String)"ReporteDiarioFragment", (String)("Dato en Gastos>Guardar. ID GASTOS" + ReporteDiarioFragment.this.gastos_id));
                            ReporteDiarioFragment.this.gastos.setId(ReporteDiarioFragment.this.gastos_id);
                        }
                        ReporteDiarioFragment.this.gastos.setOtros(tlOtros.getEditText().getText().toString());
                        ReporteDiarioFragment.this.gastos.setGasolina(tlGasolina.getEditText().getText().toString());
                        ReporteDiarioFragment.this.gastos.setHotel(tlHotel.getEditText().getText().toString());
                        ReporteDiarioFragment.this.gastos.setAlimentos(tlAlimentos.getEditText().getText().toString());
                        ReporteDiarioFragment.this.gastos.setCasetas(tlCasetas.getEditText().getText().toString());
                        ReporteDiarioFragment.this.gastos.setTotal(tlTotal.getEditText().getText().toString());
                    }
                }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
        this.btnTotales.setOnClickListener(new View.OnClickListener(){

            @RequiresApi(api=24)
            public void onClick(View view) {
                View dialogView = LayoutInflater.from((Context)ReporteDiarioFragment.this.getActivity()).inflate(2131492946, null, false);
                TextView tvEstimacion = (TextView)dialogView.findViewById(2131297284);
                TextView tvAbonosSemana = (TextView)dialogView.findViewById(2131297263);
                TextView tvRecupSemana = (TextView)dialogView.findViewById(2131297325);
                TextView tvAnticipos = (TextView)dialogView.findViewById(2131297265);
                TextView tvTotal1 = (TextView)dialogView.findViewById(2131297335);
                TextView tvRecupPrestamos = (TextView)dialogView.findViewById(2131297324);
                TextView tvColocacion = (TextView)dialogView.findViewById(2131297273);
                TextView tvPrestamoColocadora = (TextView)dialogView.findViewById(2131297321);
                TextView tvComision = (TextView)dialogView.findViewById(2131297277);
                TextView tvBonoColocadora = (TextView)dialogView.findViewById(2131297268);
                TextView tvTotal2 = (TextView)dialogView.findViewById(2131297336);
                TextView tvSaldo = (TextView)dialogView.findViewById(2131297326);
                TextView tvPendienteRecup = (TextView)dialogView.findViewById(2131297318);
                TextView tvAbonosRecup = (TextView)dialogView.findViewById(2131297262);
                TextView tvTotalEntregado = (TextView)dialogView.findViewById(2131297337);
                TextView tvComentario = (TextView)dialogView.findViewById(2131297276);
                final TextInputLayout tlComentario = (TextInputLayout)dialogView.findViewById(2131297164);
                if (ReporteDiarioFragment.this.buscarReporte) {
                    if (ReporteDiarioFragment.this.reporteDiarios.size() > 0) {
                        tlComentario.getEditText().setText((CharSequence)((ReporteDiario)ReporteDiarioFragment.this.reporteDiarios.get(0)).getComentario());
                    }
                    double estimacionTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getEstimacion())).sum();
                    tvEstimacion.setText((CharSequence)Html.fromHtml((String)("<b>Estimaci\u00f3n: </b> $" + estimacionTotal)));
                    double abonosSemTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getAbonos_semana())).sum();
                    tvAbonosSemana.setText((CharSequence)Html.fromHtml((String)("<b>Abonos semana:</b> $" + abonosSemTotal)));
                    double recupSemTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_semana())).sum();
                    tvRecupSemana.setText((CharSequence)Html.fromHtml((String)("<b>Recup. semana:</b> $" + recupSemTotal)));
                    double anticiposTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getAnticipos())).sum();
                    tvAnticipos.setText((CharSequence)Html.fromHtml((String)("<b>Anticipos:</b> $" + anticiposTotal)));
                    double total1Total = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getTotal_1())).sum();
                    tvTotal1.setText((CharSequence)Html.fromHtml((String)("<b>Total:</b> $" + total1Total)));
                    double recupPrestamosTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_prestamos())).sum();
                    tvRecupPrestamos.setText((CharSequence)Html.fromHtml((String)("<b>Recup. prestamos:</b> $" + recupPrestamosTotal)));
                    double colocacionTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getColocacion())).sum();
                    tvColocacion.setText((CharSequence)Html.fromHtml((String)("<b>Colocacion:</b> $" + colocacionTotal)));
                    double prestColocadoraTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getPrestamo_colocadora())).sum();
                    tvPrestamoColocadora.setText((CharSequence)Html.fromHtml((String)("<b>Prest. colocadora:</b> $" + prestColocadoraTotal)));
                    double comisionTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getComision())).sum();
                    tvComision.setText((CharSequence)Html.fromHtml((String)("<b>Comisi\u00f3n:</b> $" + comisionTotal)));
                    double bonoColocadoraTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getBono_colocadora())).sum();
                    tvBonoColocadora.setText((CharSequence)Html.fromHtml((String)("<b>Bono colocadora:</b>  $" + bonoColocadoraTotal)));
                    double total2Total = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getTotal_2())).sum();
                    tvTotal2.setText((CharSequence)Html.fromHtml((String)("<b>Total:</b> $" + total2Total)));
                    double saldoTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getSaldo())).sum();
                    tvSaldo.setText((CharSequence)Html.fromHtml((String)("<b>Saldo:</b> $" + saldoTotal)));
                    double pendienteRecuperarTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getPendiente_recuperar())).sum();
                    tvPendienteRecup.setText((CharSequence)Html.fromHtml((String)("<b>Pendiente. recup:</b> $" + pendienteRecuperarTotal)));
                    double abonosRecuperarTotal = ReporteDiarioFragment.this.reporteDiarios.stream().mapToDouble(o -> Utils.parseDouble(o.getAbonos_recuperar())).sum();
                    tvAbonosRecup.setText((CharSequence)Html.fromHtml((String)("<b>Abonos. recup:</b> " + abonosRecuperarTotal)));
                    double total_entregado = total1Total - total2Total;
                    tvTotalEntregado.setText((CharSequence)Html.fromHtml((String)("<b>Total a entregar:</b> $" + total_entregado)));
                } else {
                    if (((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.size() > 0) {
                        tlComentario.getEditText().setText((CharSequence)((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.get(0).getComentario());
                    }
                    double estimacionTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getEstimacion())).sum();
                    tvEstimacion.setText((CharSequence)Html.fromHtml((String)("<b>Estimaci\u00f3n: </b> $" + estimacionTotal)));
                    double abonosSemTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getAbonos_semana())).sum();
                    tvAbonosSemana.setText((CharSequence)Html.fromHtml((String)("<b>Abonos semana:</b> $" + abonosSemTotal)));
                    double recupSemTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_semana())).sum();
                    tvRecupSemana.setText((CharSequence)Html.fromHtml((String)("<b>Recup. semana:</b> $" + recupSemTotal)));
                    double anticiposTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getAnticipos())).sum();
                    tvAnticipos.setText((CharSequence)Html.fromHtml((String)("<b>Anticipos:</b> $" + anticiposTotal)));
                    double total1Total = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getTotal_1())).sum();
                    tvTotal1.setText((CharSequence)Html.fromHtml((String)("<b>Total:</b> $" + total1Total)));
                    double recupPrestamosTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_prestamos())).sum();
                    tvRecupPrestamos.setText((CharSequence)Html.fromHtml((String)("<b>Recup. prestamos:</b> $" + recupPrestamosTotal)));
                    double colocacionTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getColocacion())).sum();
                    tvColocacion.setText((CharSequence)Html.fromHtml((String)("<b>Colocacion:</b> $" + colocacionTotal)));
                    double prestColocadoraTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getPrestamo_colocadora())).sum();
                    tvPrestamoColocadora.setText((CharSequence)Html.fromHtml((String)("<b>Prest. colocadora:</b> $" + prestColocadoraTotal)));
                    double comisionTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getComision())).sum();
                    tvComision.setText((CharSequence)Html.fromHtml((String)("<b>Comisi\u00f3n:</b> $" + comisionTotal)));
                    double bonoColocadoraTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getBono_colocadora())).sum();
                    tvBonoColocadora.setText((CharSequence)Html.fromHtml((String)("<b>Bono colocadora:</b>  $" + bonoColocadoraTotal)));
                    double total2Total = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getTotal_2())).sum();
                    tvTotal2.setText((CharSequence)Html.fromHtml((String)("<b>Total:</b> $" + total2Total)));
                    double saldoTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getSaldo())).sum();
                    tvSaldo.setText((CharSequence)Html.fromHtml((String)("<b>Saldo:</b> $" + saldoTotal)));
                    double pendienteRecuperarTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getPendiente_recuperar())).sum();
                    tvPendienteRecup.setText((CharSequence)Html.fromHtml((String)("<b>Pendiente. recup:</b> $" + pendienteRecuperarTotal)));
                    double abonosRecuperarTotal = ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.stream().mapToDouble(o -> Utils.parseDouble(o.getAbonos_recuperar())).sum();
                    tvAbonosRecup.setText((CharSequence)Html.fromHtml((String)("<b>Abonos. recup:</b> " + abonosRecuperarTotal)));
                    double total_entregado = total1Total - total2Total;
                    tvTotalEntregado.setText((CharSequence)Html.fromHtml((String)("<b>Total a entregar:</b> $" + total_entregado)));
                }
                new MaterialAlertDialogBuilder((Context)ReporteDiarioFragment.this.getActivity()).setCancelable(false).setView(dialogView).setTitle((CharSequence)"Totales").setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (ReporteDiarioFragment.this.buscarReporte) {
                            for (ReporteDiario rd : ReporteDiarioFragment.this.reporteDiarios) {
                                rd.setComentario(tlComentario.getEditText().getText().toString());
                            }
                            ReporteDiarioFragment.this.agregarComentario(tlComentario.getEditText().getText().toString(), ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), ReporteDiarioFragment.this.sesion.getString("id", ""));
                        } else {
                            for (ReporteDiario rd : ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados) {
                                rd.setComentario(tlComentario.getEditText().getText().toString());
                            }
                        }
                    }
                }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
        this.btnGuardar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new MaterialAlertDialogBuilder((Context)ReporteDiarioFragment.this.getActivity()).setCancelable(false).setTitle((CharSequence)"Guardar reporte").setMessage((CharSequence)"\u00bfEsta seguro de guardar el reporte?").setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (Validator.fieldValidation(ReporteDiarioFragment.this.tlRuta, "Ingresa una ruta") && Validator.fieldValidation(ReporteDiarioFragment.this.tlFecha, "Ingresa una fecha")) {
                            if (ReporteDiarioFragment.this.buscarReporte) {
                                if (ReporteDiarioFragment.this.reporteDiarios.size() > 0) {
                                    ReporteDiarioFragment.this.editarGastos(ReporteDiarioFragment.this.gastos);
                                    if (ReporteDiarioFragment.this.reportesAgregados.size() > 0) {
                                        for (ReporteDiario rd : ReporteDiarioFragment.this.reportesAgregados) {
                                            rd.setSeleccionado(false);
                                            ReporteDiarioFragment.this.agregarRegistroReporte(rd);
                                        }
                                        ReporteDiarioFragment.this.reportesAgregados.clear();
                                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Se agregaron registros al reporte", (int)0).show();
                                    } else {
                                        if (((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesEditados.size() > 0) {
                                            for (ReporteDiario rd : ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesEditados) {
                                                ReporteDiarioFragment.this.editarRegistroReporte(rd);
                                            }
                                            ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesEditados.clear();
                                            Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Se editaron registros del reporte", (int)0).show();
                                        } else {
                                            Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"No se editaron nuevos registros", (int)0).show();
                                        }
                                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"No se agregaron nuevos registros", (int)0).show();
                                    }
                                } else {
                                    Log.d((String)"getRutas", (String)("ELSE DE buscarReporte............: " + ReporteDiarioFragment.this.buscarReporte));
                                }
                            } else {
                                Log.d((String)"getRutas", (String)("reporteDiarios.size() de la sesi\u00f3n descompuestos: " + ReporteDiarioFragment.this.reporteDiarios.size()));
                                if (((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.size() > 0) {
                                    Log.d((String)"getRutas", (String)"ENTRO EN IF DE reporteDiarioAdapter.reportesSeleccionados: ");
                                    ReporteDiarioFragment.this.registrarGastos(ReporteDiarioFragment.this.gastos);
                                } else {
                                    Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"No hay poblaciones seleccionadas", (int)0).show();
                                }
                            }
                        }
                    }
                }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificarTablaExiste(String nombreTabla) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        boolean existe = false;
        try {
            db = new DatabaseHelper(this.getContext()).getReadableDatabase();
            cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type='table' AND name=?", new String[]{nombreTabla});
            existe = cursor != null && cursor.getCount() > 0;
        }
        catch (Exception e) {
            Log.e((String)"ERROR", (String)("Error al verificar si la tabla existe: " + nombreTabla), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return existe;
    }

    public void getRutas() {
        String rutaIdSesion = this.sesion.getString("rutas", "");
        Log.d((String)"getRutas", (String)("Ruta ID de la sesi\u00f3n: " + rutaIdSesion));
        final List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d((String)"getRutas", (String)("Ruta IDs de la sesi\u00f3n descompuestos: " + rutaIdsSesion));
        if (this.rutaController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"rutasActivas");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlRutas, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            Gson gson = new Gson();
                            JSONObject obj = data.getJSONObject(i);
                            Ruta ruta = (Ruta)gson.fromJson(obj.toString(), Ruta.class);
                            if (!rutaIdsSesion.contains(ruta.getId())) continue;
                            ReporteDiarioFragment.this.rutas.add(ruta);
                            ReporteDiarioFragment.this.rutaController.nueva(ruta);
                            Log.d((String)"getRutas", (String)("Ruta a\u00f1adida: " + ruta.toString()));
                        }
                        ReporteDiarioFragment.this.rutasAdapter = new ArrayAdapter(ReporteDiarioFragment.this.getContext(), 17367050, (List)ReporteDiarioFragment.this.rutas);
                        ReporteDiarioFragment.this.rutasAutoCompleteTextView.setThreshold(1);
                        ReporteDiarioFragment.this.rutasAutoCompleteTextView.setAdapter((ListAdapter)ReporteDiarioFragment.this.rutasAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            Log.d((String)"getRutas", (String)"Recuperando rutas guardadas localmente.");
            ArrayList<Ruta> rutasGuardadas = this.rutaController.obtener();
            Log.d((String)"getRutas", (String)("Cantidad de rutas locales encontradas: " + rutasGuardadas.size()));
            for (Ruta ruta : rutasGuardadas) {
                Log.d((String)"getRutas", (String)("Ruta local encontrada: " + ruta.toString()));
                if (!rutaIdsSesion.contains(ruta.getId())) continue;
                this.rutas.add(ruta);
                Log.d((String)"getRutas", (String)("Ruta a\u00f1adida tras filtrar: " + ruta));
            }
            this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367050, this.rutas);
            this.rutasAutoCompleteTextView.setThreshold(1);
            this.rutasAutoCompleteTextView.setAdapter(this.rutasAdapter);
        }
    }

    private void getNuevoReporteDiarioRutas(String rutaId) {
        Cursor cursor;
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Log.d((String)"SQLiteError", (String)("Entro en la consulta local getNuevoReporteDiarioRutas: " + rutaId));
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String query = "SELECT TABLA_ESTIMADOS.poblacion_id, TABLA_ESTIMADOS.ruta_id, TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.modalidad_semanas, SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, '' AS estimacion, '' AS abonos_semana, '' AS recuperacion_semana, '' AS anticipos, '' AS total_1, '' AS recuperacion_prestamos, '' AS colocacion, '' AS prestamo_colocadora, '' AS comision, '' AS bono_colocadora, '' AS total_2, '' AS saldo, '' AS pendiente_recuperar, '' AS abonos_recuperar, '' AS empleado_id, '' AS gastos_id, '' AS fecha, '' AS fecha_registro FROM (   SELECT pagos.cantidad_esperada_pago, pagos.semana, poblaciones.primer_dia_cobro,          MAX(CASE WHEN pagos.fecha_pago >= date('now') AND pagos.fecha_pago < date('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago,          clientes.nombre_completo, clientes.poblacion_id, clientes.ruta_id, prestamos.grupo_poblacion, prestamos.modalidad_semanas,          poblaciones.nombre_poblacion, rutas.nombre_ruta, prestamos.status, prestamos.updated_at   FROM pagos   INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id   INNER JOIN clientes ON clientes.id = prestamos.cliente_id   INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id   INNER JOIN rutas ON rutas.id = clientes.ruta_id   WHERE (CASE WHEN prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') THEN prestamos.status IN (0, 2) ELSE prestamos.status = 0 END) " + (rutaId != null && !rutaId.isEmpty() ? " AND clientes.ruta_id = ? " : "") + "  GROUP BY prestamos.id   ORDER BY clientes.poblacion_id DESC ) AS TABLA_ESTIMADOS GROUP BY TABLA_ESTIMADOS.nombre_poblacion ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";
        try {
            cursor = rutaId != null && !rutaId.isEmpty() ? db.rawQuery(query, new String[]{rutaId}) : db.rawQuery(query, null);
            Log.d((String)"SQLiteState", (String)("Consulta ejecutada correctamente, rutaId: " + rutaId));
        }
        catch (Exception e) {
            Log.e((String)"SQLiteError", (String)"Error al ejecutar la consulta", (Throwable)e);
            dialog.dismiss();
            return;
        }
        this.reporteDiarios.clear();
        if (cursor != null && cursor.moveToFirst()) {
            Log.d((String)"SQLiteData", (String)"Resultados obtenidos de la consulta");
            do {
                ReporteDiario reporteDiario = new ReporteDiario();
                String poblacionId = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                Log.d((String)"ReporteDiarioField", (String)("...........................poblacion_id=" + poblacionId));
                reporteDiario.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                reporteDiario.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                reporteDiario.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                reporteDiario.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));
                reporteDiario.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion")));
                reporteDiario.setAbonos_semana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana")));
                reporteDiario.setRecuperacion_semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana")));
                reporteDiario.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos")));
                reporteDiario.setTotal_1(cursor.getString(cursor.getColumnIndexOrThrow("total_1")));
                reporteDiario.setRecuperacion_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos")));
                reporteDiario.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion")));
                reporteDiario.setPrestamo_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora")));
                reporteDiario.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision")));
                reporteDiario.setBono_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora")));
                reporteDiario.setTotal_2(cursor.getString(cursor.getColumnIndexOrThrow("total_2")));
                reporteDiario.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo")));
                reporteDiario.setPendiente_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar")));
                reporteDiario.setAbonos_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar")));
                reporteDiario.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                reporteDiario.setGastos_id(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id")));
                reporteDiario.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                reporteDiario.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));
                this.reporteDiarios.add(reporteDiario);
                Log.d((String)"ReporteDiario", (String)("Fila obtenida: poblacion_id=" + reporteDiario.getPoblacion_id() + ", ruta_id=" + reporteDiario.getRuta_id() + ", nombre_poblacion=" + reporteDiario.getNombre_poblacion() + ", estimado=" + reporteDiario.getEstimado() + ", estimacion=" + reporteDiario.getEstimacion() + ", abonos_semana=" + reporteDiario.getAbonos_semana() + ", recuperacion_semana=" + reporteDiario.getRecuperacion_semana() + ", anticipos=" + reporteDiario.getAnticipos() + ", total_1=" + reporteDiario.getTotal_1() + ", recuperacion_prestamos=" + reporteDiario.getRecuperacion_prestamos() + ", colocacion=" + reporteDiario.getColocacion() + ", prestamo_colocadora=" + reporteDiario.getPrestamo_colocadora() + ", comision=" + reporteDiario.getComision() + ", bono_colocadora=" + reporteDiario.getBono_colocadora() + ", total_2=" + reporteDiario.getTotal_2() + ", saldo=" + reporteDiario.getSaldo() + ", pendiente_recuperar=" + reporteDiario.getPendiente_recuperar() + ", abonos_recuperar=" + reporteDiario.getAbonos_recuperar() + ", empleado_id=" + reporteDiario.getEmpleado_id() + ", gastos_id=" + reporteDiario.getGastos_id() + ", fecha=" + reporteDiario.getFecha() + ", fecha_registro=" + reporteDiario.getFecha_registro()));
            } while (cursor.moveToNext());
        } else {
            Log.d((String)"SQLiteData", (String)"No se encontraron resultados");
        }
        if (cursor != null) {
            cursor.close();
        }
        db.close();
        this.btnGastos.setVisibility(0);
        this.btnTotales.setVisibility(0);
        this.btnGuardar.setVisibility(0);
        this.reporteDiarioAdapter.addAll(this.reporteDiarios);
        this.reporteDiarioAdapter.notifyItemRangeChanged(this.reporteDiarios.size(), 1);
        dialog.dismiss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logUltimosTresRegistrosGastos() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;
        try {
            String query = "SELECT * FROM gastos ORDER BY id DESC LIMIT 3";
            cursor = db.rawQuery(query, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                    String otros = cursor.getString(cursor.getColumnIndexOrThrow("otros"));
                    String gasolina = cursor.getString(cursor.getColumnIndexOrThrow("gasolina"));
                    String hotel = cursor.getString(cursor.getColumnIndexOrThrow("hotel"));
                    String alimentos = cursor.getString(cursor.getColumnIndexOrThrow("alimentos"));
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    Log.d((String)"UltimosRegistrosGastos", (String)("ID: " + id2 + ", otros ID: " + otros + ", gasolina: " + gasolina + ", hotel: " + hotel + ", Status: " + status + ", alimentos: " + alimentos));
                } while (cursor.moveToNext());
            } else {
                Log.d((String)"UltimosRegistros", (String)"No hay registros en la tabla gastos.");
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLiteError", (String)"Error al obtener los \u00faltimos registros gastos: ", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logUltimosTresRegistros() {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;
        try {
            String query = "SELECT * FROM reporte_diario_rutas ORDER BY id DESC LIMIT 3";
            cursor = db.rawQuery(query, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                    String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                    String estimacion = cursor.getString(cursor.getColumnIndexOrThrow("estimacion"));
                    String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                    String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    String gastos_id = cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"));
                    Log.d((String)"UltimosRegistros", (String)("ID: " + id2 + ", Poblacion ID: " + poblacion_id + ", Estimaci\u00f3n: " + estimacion + ", Empleado_id: " + empleado_id + ", Status: " + status + ", gastos_id: " + gastos_id + ", Fecha: " + fecha));
                } while (cursor.moveToNext());
            } else {
                Log.d((String)"UltimosRegistros", (String)"No hay registros en la tabla reporte_diario_rutas.");
            }
        }
        catch (Exception e) {
            Log.e((String)"SQLiteError", (String)"Error al obtener los \u00faltimos registros: ", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getReporteDiarioRutas(String ruta_id, String fecha, String empleado_id) {
        ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.logUltimosTresRegistros();
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;
        try {
            String whereClause = "";
            String[] whereArgs = new String[]{};
            if (ruta_id != null && !ruta_id.isEmpty()) {
                whereClause = whereClause + "clientes.ruta_id = ? ";
                whereArgs = this.appendToArray(whereArgs, ruta_id);
            }
            if (empleado_id != null && !empleado_id.isEmpty()) {
                if (!whereClause.isEmpty()) {
                    whereClause = whereClause + "AND ";
                }
                whereClause = whereClause + "rd.empleado_id = ? ";
                whereArgs = this.appendToArray(whereArgs, empleado_id);
            }
            if (fecha != null && !fecha.isEmpty()) {
                if (!whereClause.isEmpty()) {
                    whereClause = whereClause + "AND ";
                }
                whereClause = whereClause + "rd.fecha = ? ";
                whereArgs = this.appendToArray(whereArgs, fecha);
            }
            String query = "SELECT T1.poblacion_id, T1.ruta_id, T1.nombre_poblacion, T1.modalidad_semanas, SUM(T1.cantidad_esperada_pago) AS estimado, rd.estimacion, rd.abonos_semana, rd.recuperacion_semana, rd.anticipos, rd.total_1, rd.id, rd.recuperacion_prestamos, rd.colocacion, rd.prestamo_colocadora, rd.comision, rd.bono_colocadora, rd.total_2, rd.saldo, rd.pendiente_recuperar, rd.abonos_recuperar, rd.comentario, rd.empleado_id, rd.gastos_id, rd.fecha, rd.fecha_registro FROM ( SELECT pagos.cantidad_esperada_pago, pagos.semana, MAX(CASE WHEN pagos.fecha_pago >= date('now') AND pagos.fecha_pago < date('now', '+7 day') THEN pagos.fecha_pago END) AS fecha, clientes.nombre_completo, clientes.poblacion_id, clientes.ruta_id, prestamos.grupo_poblacion, prestamos.modalidad_semanas, poblaciones.nombre_poblacion, rutas.nombre_ruta, pagos.fecha_pago FROM pagos INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id INNER JOIN clientes ON clientes.id = prestamos.cliente_id INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id INNER JOIN rutas ON rutas.id = clientes.ruta_id " + (ruta_id != null && !ruta_id.isEmpty() ? "WHERE clientes.ruta_id = ? " : "") + "GROUP BY prestamos.id ORDER BY clientes.poblacion_id DESC) AS T1 INNER JOIN reporte_diario_rutas AS rd ON rd.poblacion_id = T1.poblacion_id WHERE " + (empleado_id != null && !empleado_id.isEmpty() ? "rd.empleado_id = ? AND " : "") + (fecha != null && !fecha.isEmpty() ? "rd.fecha = ? " : "") + "GROUP BY T1.nombre_poblacion ORDER BY T1.poblacion_id DESC";
            cursor = db.rawQuery(query, whereArgs);
            this.reporteDiarios.clear();
            Gastos gastos = new Gastos();
            boolean hayDatos = false;
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    ReporteDiario reporteDiario = new ReporteDiario();
                    reporteDiario.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporteDiario.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporteDiario.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporteDiario.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));
                    reporteDiario.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion")));
                    reporteDiario.setAbonos_semana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana")));
                    reporteDiario.setRecuperacion_semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana")));
                    reporteDiario.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos")));
                    reporteDiario.setTotal_1(cursor.getString(cursor.getColumnIndexOrThrow("total_1")));
                    reporteDiario.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                    reporteDiario.setRecuperacion_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos")));
                    reporteDiario.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion")));
                    reporteDiario.setPrestamo_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora")));
                    reporteDiario.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision")));
                    reporteDiario.setBono_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora")));
                    reporteDiario.setTotal_2(cursor.getString(cursor.getColumnIndexOrThrow("total_2")));
                    reporteDiario.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo")));
                    reporteDiario.setPendiente_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar")));
                    reporteDiario.setAbonos_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar")));
                    reporteDiario.setComentario(cursor.getString(cursor.getColumnIndexOrThrow("comentario")));
                    reporteDiario.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                    reporteDiario.setGastos_id(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id")));
                    reporteDiario.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                    reporteDiario.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));
                    this.gastos_id = cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"));
                    this.reporteDiarios.add(reporteDiario);
                    hayDatos = true;
                } while (cursor.moveToNext());
            }
            if (hayDatos) {
                this.btnAgregar.setVisibility(0);
                this.btnGastos.setVisibility(0);
                this.btnTotales.setVisibility(0);
                this.btnGuardar.setVisibility(0);
            } else {
                this.gastos_id = "";
                this.btnAgregar.setVisibility(8);
                this.btnGastos.setVisibility(8);
                this.btnTotales.setVisibility(8);
                this.btnGuardar.setVisibility(8);
                Toast.makeText((Context)this.getActivity(), (CharSequence)"No existe ning\u00fan reporte con los filtros ingresados", (int)0).show();
            }
            if (!this.gastos_id.equals("")) {
                Log.d((String)"ReporteDiarioFragment", (String)("Dato en getReporteDiarioRutas(). ID GASTOS: " + this.gastos_id));
                this.getGastos(this.gastos_id);
            }
            this.reporteDiarioAdapter.addAll(this.reporteDiarios);
            this.reporteDiarioAdapter.notifyItemRangeChanged(this.reporteDiarios.size(), 1);
        }
        catch (Exception e) {
            Log.e((String)"SQLiteError", (String)"Error en la consulta local: ", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
            dialog.dismiss();
        }
    }

    private String[] appendToArray(String[] array2, String element) {
        String[] newArray = new String[array2.length + 1];
        System.arraycopy(array2, 0, newArray, 0, array2.length);
        newArray[array2.length] = element;
        return newArray;
    }

    private void registrarGastos(final Gastos gastos) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"createGastos");
            data.put("otros", (Object)gastos.getOtros());
            data.put("gasolina", (Object)gastos.getGasolina());
            data.put("hotel", (Object)gastos.getHotel());
            data.put("alimentos", (Object)gastos.getAlimentos());
            data.put("casetas", (Object)gastos.getCasetas());
            data.put("total", (Object)gastos.getTotal());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String id2 = response.getJSONObject("data").getString("id");
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de id'....................: " + id2));
                        ReporteDiarioFragment.this.registrarGastoEnSQLite(gastos.getOtros(), gastos.getGasolina(), gastos.getHotel(), gastos.getAlimentos(), gastos.getCasetas(), gastos.getTotal(), id2, "on");
                        for (ReporteDiario rd : ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados) {
                            rd.setSeleccionado(false);
                            ReporteDiarioFragment.this.registrarReporte(rd);
                        }
                        ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.clear();
                        ReporteDiarioFragment.this.getNuevoReporteDiarioRutas(null);
                        ReporteDiarioFragment.this.tlFecha.getEditText().setText((CharSequence)"");
                        ReporteDiarioFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
                        Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Se registro el reporte", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                Toast.makeText((Context)ReporteDiarioFragment.this.getActivity(), (CharSequence)"Sin Conexi\u00f3n, Se registro el reporte en local", (int)1).show();
                ReporteDiarioFragment.this.registrarGastoEnSQLite(gastos.getOtros(), gastos.getGasolina(), gastos.getHotel(), gastos.getAlimentos(), gastos.getCasetas(), gastos.getTotal(), "", "off");
                for (ReporteDiario rd : ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados) {
                    rd.setSeleccionado(false);
                    ReporteDiarioFragment.this.registrarReporte(rd);
                }
                ((ReporteDiarioFragment)ReporteDiarioFragment.this).reporteDiarioAdapter.reportesSeleccionados.clear();
                ReporteDiarioFragment.this.getNuevoReporteDiarioRutas(null);
                ReporteDiarioFragment.this.tlFecha.getEditText().setText((CharSequence)"");
                ReporteDiarioFragment.this.rutasAutoCompleteTextView.setText((CharSequence)"");
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void actualizarGastoEnSQLite(String id2, String otros, String gasolina, String hotel, String alimentos, String casetas, String total, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        ContentValues valores = new ContentValues();
        valores.put("otros", otros);
        valores.put("gasolina", gasolina);
        valores.put("hotel", hotel);
        valores.put("alimentos", alimentos);
        valores.put("casetas", casetas);
        valores.put("total", total);
        if (online.equals("off")) {
            valores.put("status", "2");
        } else {
            valores.put("status", "0");
        }
        int resultado = db.update("gastos", valores, "id = ?", new String[]{id2});
        if (resultado > 0) {
            Log.d((String)"SQLite", (String)("Gasto actualizado con \u00e9xito en SQLite con ID: " + id2));
        } else {
            Log.d((String)"SQLite", (String)"Error al actualizar el gasto en SQLite.");
        }
        db.close();
    }

    private void registrarGastoEnSQLite(String otros, String gasolina, String hotel, String alimentos, String casetas, String total, String idServer, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        String idGasto = "";
        idGasto = idServer != "" ? idServer : String.valueOf(this.obtenerSiguienteIdGasto(db));
        ContentValues valores = new ContentValues();
        valores.put("id", idGasto);
        valores.put("otros", otros);
        valores.put("gasolina", gasolina);
        valores.put("hotel", hotel);
        valores.put("alimentos", alimentos);
        valores.put("casetas", casetas);
        valores.put("total", total);
        if (online != "off") {
            valores.put("status", "0");
        } else {
            valores.put("status", "1");
        }
        long resultado = db.insert("gastos", null, valores);
        if (resultado != -1L) {
            Log.d((String)"SQLite", (String)("Gasto registrado con \u00e9xito en SQLite con ID: " + idGasto));
            this.gasto_id = idGasto;
        } else {
            Log.d((String)"SQLite", (String)"Error al registrar el gasto en SQLite.");
        }
        db.close();
    }

    private int obtenerSiguienteIdGasto(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM gastos", null);
        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();
        return ultimoId + 1;
    }

    private void editarGastos(final Gastos gastos) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"editGastos");
            data.put("id", (Object)gastos.getId());
            data.put("otros", (Object)gastos.getOtros());
            data.put("gasolina", (Object)gastos.getGasolina());
            data.put("hotel", (Object)gastos.getHotel());
            data.put("alimentos", (Object)gastos.getAlimentos());
            data.put("casetas", (Object)gastos.getCasetas());
            data.put("total", (Object)gastos.getTotal());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                ReporteDiarioFragment.this.actualizarGastoEnSQLite(gastos.getId(), gastos.getOtros(), gastos.getGasolina(), gastos.getHotel(), gastos.getAlimentos(), gastos.getCasetas(), gastos.getTotal(), "on");
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                ReporteDiarioFragment.this.actualizarGastoEnSQLite(gastos.getId(), gastos.getOtros(), gastos.getGasolina(), gastos.getHotel(), gastos.getAlimentos(), gastos.getCasetas(), gastos.getTotal(), "off");
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void agregarComentario(final String comentario, final String fecha, final String empleado_id) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"agregarComentarioReporteDiarioRutas");
            data.put("comentario", (Object)comentario);
            data.put("empleado_id", (Object)empleado_id);
            data.put("fecha", (Object)fecha);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"PRESTSMOS", (String)("Parametros enviados al servidor para agregarComentario: " + data.toString()));
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                ReporteDiarioFragment.this.actualizarComentarioEnSQLite(comentario, empleado_id, fecha, "on");
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                ReporteDiarioFragment.this.actualizarComentarioEnSQLite(comentario, empleado_id, fecha, "off");
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void actualizarComentarioEnSQLite(String comentario, String empleado_id, String fecha, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Log.d((String)"SQLite", (String)"ENTRO EN ACTUALIZAR COMENTARIO");
        Log.d((String)"SQLite", (String)("Datos recibidos -> Comentario: " + comentario + ", Fecha: " + fecha + ", Empleado ID: " + empleado_id + ", Online: " + online));
        if (fecha == null || fecha.isEmpty() || empleado_id == null || empleado_id.isEmpty()) {
            Log.d((String)"SQLite", (String)"Fecha o empleado_id no proporcionados para la actualizaci\u00f3n.");
            db.close();
            return;
        }
        ContentValues valores = new ContentValues();
        valores.put("comentario", comentario);
        if (online != "off") {
            valores.put("status", "0");
        } else {
            valores.put("status", "2");
        }
        int resultado = db.update("reporte_diario_rutas", valores, "empleado_id = ? AND fecha = ?", new String[]{empleado_id, fecha});
        if (resultado > 0) {
            Log.d((String)"SQLite", (String)("Comentario actualizado con \u00e9xito en SQLite para empleado_id: " + empleado_id + ", fecha: " + fecha));
        } else {
            Log.d((String)"SQLite", (String)"Comentario actualizado con \u00e9xito en SQLite para empleado_id: Error!!!! ");
        }
        db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGastos(String id2) {
        Log.d((String)"ReporteDiarioFragment", (String)("ID GASTOS en getGastos.............: " + id2));
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.getActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String query = "SELECT * FROM gastos WHERE id = ?";
        Cursor cursor = null;
        try {
            cursor = db.rawQuery(query, new String[]{id2});
            if (cursor != null && cursor.moveToFirst()) {
                this.gastos = new Gastos();
                this.gastos.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                this.gastos.setOtros(cursor.getString(cursor.getColumnIndexOrThrow("otros")));
                this.gastos.setGasolina(cursor.getString(cursor.getColumnIndexOrThrow("gasolina")));
                this.gastos.setHotel(cursor.getString(cursor.getColumnIndexOrThrow("hotel")));
                this.gastos.setAlimentos(cursor.getString(cursor.getColumnIndexOrThrow("alimentos")));
                this.gastos.setCasetas(cursor.getString(cursor.getColumnIndexOrThrow("casetas")));
                this.gastos.setTotal(cursor.getString(cursor.getColumnIndexOrThrow("total")));
                Log.d((String)"GASTOS LOCAL", (String)("GASTOS TRAIDOS DE LA CONSULTA en getGastos.............: " + this.gastos.toString()));
            } else {
                Toast.makeText((Context)this.getActivity(), (CharSequence)("No se encontraron gastos con el ID " + id2), (int)0).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)this.getActivity(), (CharSequence)"Error al obtener los gastos", (int)0).show();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    private void registrarReporte(final ReporteDiario reporteDiario) {
        Log.d((String)"SEND", (String)"ENTRO A REGISTRAR REPORTE.................");
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"createReporteDiarioRutas");
            data.put("poblacion_id", (Object)reporteDiario.getPoblacion_id());
            data.put("estimacion", (Object)(reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado()));
            data.put("abonos_semana", (Object)reporteDiario.getAbonos_semana());
            data.put("recuperacion_semana", (Object)reporteDiario.getRecuperacion_semana());
            data.put("anticipos", (Object)reporteDiario.getAnticipos());
            data.put("total_1", (Object)reporteDiario.getTotal_1());
            data.put("recuperacion_prestamos", (Object)reporteDiario.getRecuperacion_prestamos());
            data.put("colocacion", (Object)reporteDiario.getColocacion());
            data.put("prestamo_colocadora", (Object)reporteDiario.getPrestamo_colocadora());
            data.put("comision", (Object)reporteDiario.getComision());
            data.put("bono_colocadora", (Object)reporteDiario.getBono_colocadora());
            data.put("total_2", (Object)reporteDiario.getTotal_2());
            data.put("saldo", (Object)reporteDiario.getSaldo());
            data.put("pendiente_recuperar", (Object)reporteDiario.getPendiente_recuperar());
            data.put("abonos_recuperar", (Object)reporteDiario.getAbonos_recuperar());
            data.put("comentario", (Object)reporteDiario.getComentario());
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
            data.put("fecha", (Object)this.tlFecha.getEditText().getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final String fecha = this.tlFecha.getEditText().getText().toString();
        Log.d((String)"SEND", (String)data.toString());
        Log.d((String)"SEND", (String)("FECHA INSERTADA EN SQLITE:....................." + fecha));
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String id2 = response.getJSONObject("data").getString("id");
                        String gastosId = response.getJSONObject("data").getString("gastos_id");
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene EN LINEA 'data de id'....................: " + id2));
                        Log.d((String)"DEBUG", (String)("Respuesta JSON contiene EN LINEA 'data de gastosId'....................: " + gastosId));
                        ReporteDiarioFragment.this.registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado(), reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(), reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), reporteDiario.getComentario(), ReporteDiarioFragment.this.sesion.getString("id", "0"), fecha, gastosId, id2, "on");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                ReporteDiarioFragment.this.registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado(), reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(), reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), reporteDiario.getComentario(), ReporteDiarioFragment.this.sesion.getString("id", "0"), fecha, ReporteDiarioFragment.this.gasto_id, "", "off");
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void agregarRegistroReporte(final ReporteDiario reporteDiario) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"agregarRegistroReporteDiarioRutas");
            data.put("poblacion_id", (Object)reporteDiario.getPoblacion_id());
            data.put("estimacion", (Object)(reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado()));
            data.put("abonos_semana", (Object)reporteDiario.getAbonos_semana());
            data.put("recuperacion_semana", (Object)reporteDiario.getRecuperacion_semana());
            data.put("anticipos", (Object)reporteDiario.getAnticipos());
            data.put("total_1", (Object)reporteDiario.getTotal_1());
            data.put("recuperacion_prestamos", (Object)reporteDiario.getRecuperacion_prestamos());
            data.put("colocacion", (Object)reporteDiario.getColocacion());
            data.put("prestamo_colocadora", (Object)reporteDiario.getPrestamo_colocadora());
            data.put("comision", (Object)reporteDiario.getComision());
            data.put("bono_colocadora", (Object)reporteDiario.getBono_colocadora());
            data.put("total_2", (Object)reporteDiario.getTotal_2());
            data.put("saldo", (Object)reporteDiario.getSaldo());
            data.put("pendiente_recuperar", (Object)reporteDiario.getPendiente_recuperar());
            data.put("abonos_recuperar", (Object)reporteDiario.getAbonos_recuperar());
            data.put("comentario", (Object)reporteDiario.getComentario());
            data.put("empleado_id", (Object)this.sesion.getString("id", "0"));
            data.put("fecha", (Object)this.tlFecha.getEditText().getText().toString());
            data.put("gastos_id", (Object)reporteDiario.getGastos_id());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"SEND", (String)data.toString());
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    if (response.getString("status").equals("success")) {
                        String id2 = response.getJSONObject("data").getString("id");
                        ReporteDiarioFragment.this.registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado(), reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(), reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), reporteDiario.getComentario(), ReporteDiarioFragment.this.sesion.getString("id", "0"), ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), reporteDiario.getGastos_id(), id2, "on");
                        ReporteDiarioFragment.this.getReporteDiarioRutas(ReporteDiarioFragment.this.poblacion_id, ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), ReporteDiarioFragment.this.sesion.getString("id", ""));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                ReporteDiarioFragment.this.registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado(), reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(), reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), reporteDiario.getComentario(), ReporteDiarioFragment.this.sesion.getString("id", "0"), ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), reporteDiario.getGastos_id(), "", "off");
                ReporteDiarioFragment.this.getReporteDiarioRutas(ReporteDiarioFragment.this.poblacion_id, ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), ReporteDiarioFragment.this.sesion.getString("id", ""));
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    private void registrarReporteEnSQLite(String poblacion_id, String estimacion, String abonos_semana, String recuperacion_semana, String anticipos, String total_1, String recuperacion_prestamos, String colocacion, String prestamo_colocadora, String comision, String bono_colocadora, String total_2, String saldo, String pendiente_recuperar, String abonos_recuperar, String comentario, String empleado_id, String fecha, String gastos_id, String idServer, String online) {
        ++this.contador;
        Log.d((String)"SQLite", (String)("Se ha llamado a registrarReporteCreditosEnSQLite " + this.contador + " veces."));
        Log.d((String)"SEND", (String)"ENTRO A REGISTRAR REPORTE EN SQLITE.................");
        DatabaseHelper dbHelper = new DatabaseHelper(this.requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        String idReporte = idServer != null && !idServer.isEmpty() ? idServer : String.valueOf(this.obtenerSiguienteIdReporte(db));
        ContentValues valores = new ContentValues();
        valores.put("id", idReporte);
        valores.put("poblacion_id", poblacion_id);
        valores.put("estimacion", estimacion);
        valores.put("abonos_semana", abonos_semana);
        valores.put("recuperacion_semana", recuperacion_semana);
        valores.put("anticipos", anticipos);
        valores.put("total_1", total_1);
        valores.put("recuperacion_prestamos", recuperacion_prestamos);
        valores.put("colocacion", colocacion);
        valores.put("prestamo_colocadora", prestamo_colocadora);
        valores.put("comision", comision);
        valores.put("bono_colocadora", bono_colocadora);
        valores.put("total_2", total_2);
        valores.put("saldo", saldo);
        valores.put("pendiente_recuperar", pendiente_recuperar);
        valores.put("abonos_recuperar", abonos_recuperar);
        valores.put("comentario", comentario);
        valores.put("empleado_id", empleado_id);
        valores.put("fecha", fecha);
        valores.put("gastos_id", gastos_id);
        if (online != "off") {
            valores.put("status", "0");
        } else {
            valores.put("status", "1");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        Date nuevaFecha = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String fechaRestada = dateFormat.format(nuevaFecha);
        valores.put("fecha_registro", fechaRestada);
        Log.d((String)"SQLite", (String)("fecha al registrar el reporte en SQLite." + fecha));
        long resultado = db.insert("reporte_diario_rutas", null, valores);
        if (resultado != -1L) {
            Log.d((String)"SQLite", (String)("reporte registrado con \u00e9xito en SQLite con ID: " + idReporte));
        } else {
            Log.d((String)"SQLite", (String)"Error al registrar el reporte en SQLite.");
        }
        db.close();
    }

    private int obtenerSiguienteIdReporte(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM reporte_diario_rutas", null);
        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();
        return ultimoId + 1;
    }

    private void editarRegistroReporte(final ReporteDiario reporteDiario) {
        Log.d((String)"SQLite", (String)"ENTRO EN EDITAR REPORTE PARA COMENTARIO: ");
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"editReporteDiarioRutas");
            data.put("id", (Object)reporteDiario.getId());
            data.put("estimacion", (Object)(reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado()));
            data.put("abonos_semana", (Object)reporteDiario.getAbonos_semana());
            data.put("recuperacion_semana", (Object)reporteDiario.getRecuperacion_semana());
            data.put("anticipos", (Object)reporteDiario.getAnticipos());
            data.put("total_1", (Object)reporteDiario.getTotal_1());
            data.put("recuperacion_prestamos", (Object)reporteDiario.getRecuperacion_prestamos());
            data.put("colocacion", (Object)reporteDiario.getColocacion());
            data.put("prestamo_colocadora", (Object)reporteDiario.getPrestamo_colocadora());
            data.put("comision", (Object)reporteDiario.getComision());
            data.put("bono_colocadora", (Object)reporteDiario.getBono_colocadora());
            data.put("total_2", (Object)reporteDiario.getTotal_2());
            data.put("saldo", (Object)reporteDiario.getSaldo());
            data.put("pendiente_recuperar", (Object)reporteDiario.getPendiente_recuperar());
            data.put("abonos_recuperar", (Object)reporteDiario.getAbonos_recuperar());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    String message = (String)response.get("message");
                    ReporteDiarioFragment.this.actualizarReporteEnSQLite(reporteDiario.getId(), reporteDiario.getEstimacion(), reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(), reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), "on");
                    ReporteDiarioFragment.this.getReporteDiarioRutas(ReporteDiarioFragment.this.ruta_id, ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), ReporteDiarioFragment.this.sesion.getString("id", ""));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, (Context)ReporteDiarioFragment.this.getActivity());
                ReporteDiarioFragment.this.actualizarReporteEnSQLite(reporteDiario.getId(), reporteDiario.getEstimacion(), reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(), reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), "off");
                ReporteDiarioFragment.this.getReporteDiarioRutas(ReporteDiarioFragment.this.ruta_id, ReporteDiarioFragment.this.tlFecha.getEditText().getText().toString(), ReporteDiarioFragment.this.sesion.getString("id", ""));
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualizarReporteEnSQLite(String id2, String estimacion, String abonosSemana, String recuperacionSemana, String anticipos, String total1, String recuperacionPrestamos, String colocacion, String prestamoColocadora, String comision, String bonoColocadora, String total2, String saldo, String pendienteRecuperar, String abonosRecuperar, String online) {
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.getActivity());
        try (SQLiteDatabase db = dbHelper.getWritableDatabase();){
            ContentValues valores = new ContentValues();
            valores.put("estimacion", estimacion);
            valores.put("abonos_semana", abonosSemana);
            valores.put("recuperacion_semana", recuperacionSemana);
            valores.put("anticipos", anticipos);
            valores.put("total_1", total1);
            valores.put("recuperacion_prestamos", recuperacionPrestamos);
            valores.put("colocacion", colocacion);
            valores.put("prestamo_colocadora", prestamoColocadora);
            valores.put("comision", comision);
            valores.put("bono_colocadora", bonoColocadora);
            valores.put("total_2", total2);
            valores.put("saldo", saldo);
            valores.put("pendiente_recuperar", pendienteRecuperar);
            valores.put("abonos_recuperar", abonosRecuperar);
            long timestamp = System.currentTimeMillis();
            if (online != "off") {
                valores.put("status", "0");
                timestamp -= 10000L;
            } else {
                valores.put("status", "2");
                timestamp += 10000L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            String formattedDate = sdf.format(new Date(timestamp));
            valores.put("fecha_registro", formattedDate);
            int filasActualizadas = db.update("reporte_diario_rutas", valores, "id = ?", new String[]{id2});
            if (filasActualizadas > 0) {
                Log.d((String)"SQLite", (String)("Reporte actualizado con \u00e9xito en SQLite con ID: " + id2));
            } else {
                Log.d((String)"SQLite", (String)("No se encontr\u00f3 el reporte con ID: " + id2 + " para actualizar."));
            }
        }
    }

    private void filtrarReporte(String ruta_id) {
        this.reporteDiariosFiltrado = new ArrayList();
        this.reporteDiariosFiltrado.clear();
        for (ReporteDiario rd : this.reporteDiarios) {
            if (!rd.getRuta_id().equals(ruta_id)) continue;
            this.reporteDiariosFiltrado.add(rd);
        }
        if (!this.reporteDiariosFiltrado.isEmpty()) {
            this.reporteDiarioAdapter.setListaFiltrada(this.reporteDiariosFiltrado);
        }
    }

    private void filtrarReportePoblaciones(String text) {
        if (this.reporteDiariosFiltrado.size() == 0) {
            for (ReporteDiario rd : this.reporteDiarios) {
                if (!rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())) continue;
                this.reporteDiariosFiltrado.add(rd);
            }
            if (!this.reporteDiariosFiltrado.isEmpty()) {
                this.reporteDiarioAdapter.setListaFiltrada(this.reporteDiariosFiltrado);
            }
        } else {
            this.reportesFiltradosNombres = new ArrayList();
            for (ReporteDiario rd : this.reporteDiariosFiltrado) {
                if (!rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())) continue;
                this.reportesFiltradosNombres.add(rd);
            }
            if (!this.reportesFiltradosNombres.isEmpty()) {
                this.reporteDiarioAdapter.setListaFiltrada(this.reportesFiltradosNombres);
            }
        }
    }

    private void getPoblaciones(final String ruta_id, final AutoCompleteTextView poblacionesAT) {
        this.vs = VolleyS.getInstance((Context)this.getActivity());
        this.requestQueue = this.vs.getRequestQueue();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"getNuevoReporteDiarioRutas");
            data.put("ruta", (Object)ruta_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"SEND", (String)data.toString());
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    JSONArray data = (JSONArray)response.get("data");
                    ReporteDiarioFragment.this.poblacionesReporte.clear();
                    ReporteDiarioFragment.this.btnGastos.setVisibility(0);
                    ReporteDiarioFragment.this.btnTotales.setVisibility(0);
                    ReporteDiarioFragment.this.btnGuardar.setVisibility(0);
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject obj = data.getJSONObject(i);
                        Log.d((String)"DATA", (String)obj.toString());
                        Gson gson = new Gson();
                        ReporteDiario reporteDiario = (ReporteDiario)gson.fromJson(obj.toString(), ReporteDiario.class);
                        ReporteDiarioFragment.this.poblacionesReporte.add(reporteDiario);
                    }
                    ReporteDiarioFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteDiarioFragment.this.getContext(), 17367050, ReporteDiarioFragment.this.poblacionesReporte);
                    poblacionesAT.setThreshold(1);
                    poblacionesAT.setAdapter(ReporteDiarioFragment.this.poblacionesAdapter);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onErrorResponse(VolleyError error) {
                Log.e((String)"API_ERROR", (String)"Error en la respuesta de la API: ", (Throwable)error);
                DatabaseHelper dbHelper = new DatabaseHelper(ReporteDiarioFragment.this.getContext());
                SQLiteDatabase db = dbHelper.getWritableDatabase();
                Cursor cursor = null;
                String query = "SELECT TABLA_ESTIMADOS.poblacion_id, TABLA_ESTIMADOS.ruta_id, TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.modalidad_semanas, SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, '' AS estimacion, '' AS abonos_semana, '' AS recuperacion_semana, '' AS anticipos, '' AS total_1, '' AS recuperacion_prestamos, '' AS colocacion, '' AS prestamo_colocadora, '' AS comision, '' AS bono_colocadora, '' AS total_2, '' AS saldo, '' AS pendiente_recuperar, '' AS abonos_recuperar, '' AS empleado_id, '' AS gastos_id, '' AS fecha, '' AS fecha_registro FROM (     SELECT         pagos.cantidad_esperada_pago,         pagos.semana,         poblaciones.primer_dia_cobro,         MAX(CASE WHEN pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago,         clientes.nombre_completo,         clientes.poblacion_id,         clientes.ruta_id,         prestamos.grupo_poblacion,         prestamos.modalidad_semanas,         poblaciones.nombre_poblacion,         rutas.nombre_ruta,         prestamos.status,         prestamos.updated_at     FROM pagos     INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id     INNER JOIN clientes ON clientes.id = prestamos.cliente_id     INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id     INNER JOIN rutas ON rutas.id = clientes.ruta_id     WHERE (         (prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') AND prestamos.status IN (0, 2))         OR (prestamos.status = 0)     ) " + (ruta_id != null ? "AND clientes.ruta_id = ? " : "") + "    GROUP BY prestamos.id ) AS TABLA_ESTIMADOS GROUP BY TABLA_ESTIMADOS.nombre_poblacion ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";
                try {
                    cursor = ruta_id != null ? db.rawQuery(query, new String[]{ruta_id}) : db.rawQuery(query, null);
                    if (cursor.moveToFirst()) {
                        do {
                            for (int i = 0; i < cursor.getColumnCount(); ++i) {
                                String columnName = cursor.getColumnName(i);
                                String value = cursor.getString(i);
                                Log.d((String)"SQLiteResult", (String)("Columna: " + columnName + " = " + value));
                            }
                            ReporteDiario reporteDiario = new ReporteDiario();
                            reporteDiario.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                            reporteDiario.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                            reporteDiario.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                            reporteDiario.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));
                            reporteDiario.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion")));
                            reporteDiario.setAbonos_semana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana")));
                            reporteDiario.setRecuperacion_semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana")));
                            reporteDiario.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos")));
                            reporteDiario.setTotal_1(cursor.getString(cursor.getColumnIndexOrThrow("total_1")));
                            reporteDiario.setRecuperacion_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos")));
                            reporteDiario.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion")));
                            reporteDiario.setPrestamo_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora")));
                            reporteDiario.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision")));
                            reporteDiario.setBono_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora")));
                            reporteDiario.setTotal_2(cursor.getString(cursor.getColumnIndexOrThrow("total_2")));
                            reporteDiario.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo")));
                            reporteDiario.setPendiente_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar")));
                            reporteDiario.setAbonos_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar")));
                            reporteDiario.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                            reporteDiario.setGastos_id(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id")));
                            reporteDiario.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                            reporteDiario.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));
                            ReporteDiarioFragment.this.poblacionesReporte.add(reporteDiario);
                        } while (cursor.moveToNext());
                    }
                    ReporteDiarioFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteDiarioFragment.this.getContext(), 17367050, ReporteDiarioFragment.this.poblacionesReporte);
                    poblacionesAT.setThreshold(1);
                    poblacionesAT.setAdapter(ReporteDiarioFragment.this.poblacionesAdapter);
                }
                catch (Exception e) {
                    Log.e((String)"SQLiteError", (String)"Error al ejecutar la consulta local", (Throwable)e);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    db.close();
                }
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
        request.setShouldCache(false);
        this.requestQueue.add((Request)request);
    }
}

