/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.reporteGeneral;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.ReporteGeneral;
import com.example.sefinsa_app.ui.reporteGeneral.ReporteGeneralViewModel;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NumeroLetras;
import com.example.sefinsa_app.utilities.ReporteGeneralAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReporteGeneralFragment
extends Fragment {
    private ReporteGeneralViewModel mViewModel;
    private VolleyS vs;
    private RequestQueue requestQueue;
    private RecyclerView recyclerView;
    private ReporteGeneralAdapter reporteGeneralAdapter;
    private LinearLayoutManager linearLayoutManager;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private TextInputLayout tlPoblacion;
    private TextInputLayout tlFechaFiltro;
    private SharedPreferences sesion;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private int previousLength;
    private boolean backSpace;
    private TextView tvPago;
    private String poblacion_id = "";
    private String fecha = "";
    private PoblacionController poblacionController;
    private FloatingActionButton fabImprimirReporte;
    private Fragment fragmento;
    private ArrayList<ReporteGeneral> reporteGeneral;
    private ArrayList<ReporteGeneral> reporteGeneralFiltrado;

    public static ReporteGeneralFragment newInstance() {
        return new ReporteGeneralFragment();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        return inflater.inflate(2131492975, container, false);
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
    }

    @RequiresApi(api=24)
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.requestQueue.getCache().clear();
                this.getReporteDiario();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @RequiresApi(api=24)
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "ReporteGeneralFragment";
        this.initElements(view);
        this.getReporteDiario();
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
    }

    public void initElements(View view) {
        CurrentFragment.fragment = "ReporteDiarioFragment";
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.tvPago = (TextView)view.findViewById(2131297317);
        this.poblacionController = new PoblacionController((Context)this.getActivity());
        this.poblacionesAutoCompleteTextView = (AutoCompleteTextView)view.findViewById(2131296285);
        this.recyclerView = (RecyclerView)view.findViewById(2131296978);
        this.poblaciones = new ArrayList();
        this.tlFechaFiltro = (TextInputLayout)view.findViewById(2131297178);
        this.fecha = this.tlFechaFiltro.getEditText().getText().toString();
        this.reporteGeneral = new ArrayList();
        this.reporteGeneralAdapter = new ReporteGeneralAdapter((Context)this.getActivity(), this.reporteGeneral, this);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.reporteGeneralAdapter);
        this.fabImprimirReporte = (FloatingActionButton)view.findViewById(2131296635);
        this.fabImprimirReporte.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new MaterialAlertDialogBuilder((Context)ReporteGeneralFragment.this.getActivity()).setTitle((CharSequence)"Imprimir reporte general").setPositiveButton((CharSequence)"Imprimir", new DialogInterface.OnClickListener(){

                    @SuppressLint(value={"MissingPermission"})
                    @RequiresApi(api=24)
                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (ReporteGeneralFragment.this.tlFechaFiltro.getEditText().getText().length() > 0) {
                            if (ReporteGeneralFragment.this.reporteGeneralFiltrado.size() > 0) {
                                Date c = Calendar.getInstance().getTime();
                                SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
                                SimpleDateFormat outputFormat = new SimpleDateFormat("dd/MM/yyyy");
                                Date date = null;
                                try {
                                    date = inputFormat.parse(ReporteGeneralFragment.this.tlFechaFiltro.getEditText().getText().toString());
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                                String fechaConvert = outputFormat.format(date);
                                BluetoothUtils.printPhoto(2131230871);
                                BluetoothUtils.printReporteGeneral(ReporteGeneralFragment.this.reporteGeneralFiltrado, fechaConvert);
                            } else {
                                Toast.makeText((Context)ReporteGeneralFragment.this.getActivity(), (CharSequence)"No hay informaci\u00f3n para imprimir", (int)0).show();
                            }
                        } else {
                            Toast.makeText((Context)ReporteGeneralFragment.this.getActivity(), (CharSequence)"Debes ingresar un filtro de fecha", (int)0).show();
                        }
                    }
                }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
            }
        });
        if (this.poblaciones.size() == 0) {
            this.getPoblaciones();
        }
        this.poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @RequiresApi(api=24)
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = (Poblacion)ReporteGeneralFragment.this.poblacionesAdapter.getItem(i);
                ReporteGeneralFragment.this.poblacion_id = poblacion.getNombre_poblacion();
                if (ReporteGeneralFragment.this.fecha.equals("")) {
                    ReporteGeneralFragment.this.filtrarReportePoblacion(ReporteGeneralFragment.this.poblacion_id);
                } else {
                    ReporteGeneralFragment.this.filtrarReporte(ReporteGeneralFragment.this.fecha, ReporteGeneralFragment.this.poblacion_id);
                }
            }
        });
        this.poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                ReporteGeneralFragment.this.previousLength = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ReporteGeneralFragment.this.backSpace = ReporteGeneralFragment.this.previousLength > s.length();
                if (ReporteGeneralFragment.this.backSpace && !ReporteGeneralFragment.this.poblacion_id.equals("")) {
                    ReporteGeneralFragment.this.poblacion_id = "";
                    ReporteGeneralFragment.this.poblacionesAutoCompleteTextView.setText((CharSequence)"");
                    if (ReporteGeneralFragment.this.fecha.equals("")) {
                        ReporteGeneralFragment.this.reporteGeneralAdapter.setListaFiltrada(ReporteGeneralFragment.this.reporteGeneral);
                    } else {
                        ReporteGeneralFragment.this.filtrarReporte(ReporteGeneralFragment.this.fecha);
                    }
                }
            }
        });
        this.tlFechaFiltro.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(ReporteGeneralFragment.this.getFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Object selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date((Long)selection + (long)offsetFromUTC);
                        ReporteGeneralFragment.this.tlFechaFiltro.getEditText().setText((CharSequence)simpleFormat.format(date));
                        ReporteGeneralFragment.this.fecha = ReporteGeneralFragment.this.tlFechaFiltro.getEditText().getText().toString();
                        if (!ReporteGeneralFragment.this.poblacion_id.equals("")) {
                            ReporteGeneralFragment.this.filtrarReporte(ReporteGeneralFragment.this.fecha, ReporteGeneralFragment.this.poblacion_id);
                        } else {
                            ReporteGeneralFragment.this.filtrarReporte(ReporteGeneralFragment.this.fecha);
                        }
                    }
                });
            }
        });
    }

    private void getPoblaciones() {
        if (this.poblacionController.obtener().size() == 0) {
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"index");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPoblaciones, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Poblacion poblacion = (Poblacion)gson.fromJson(obj.toString(), Poblacion.class);
                            ReporteGeneralFragment.this.poblaciones.add(poblacion);
                            ReporteGeneralFragment.this.poblacionController.nueva(poblacion);
                        }
                        ReporteGeneralFragment.this.poblacionesAdapter = new ArrayAdapter(ReporteGeneralFragment.this.getContext(), 17367050, (List)ReporteGeneralFragment.this.poblaciones);
                        ReporteGeneralFragment.this.poblacionesAutoCompleteTextView.setThreshold(1);
                        ReporteGeneralFragment.this.poblacionesAutoCompleteTextView.setAdapter((ListAdapter)ReporteGeneralFragment.this.poblacionesAdapter);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, (Context)ReporteGeneralFragment.this.getActivity());
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(0, 1, 1.0f));
            this.requestQueue.add((Request)request);
        } else {
            this.poblaciones = this.poblacionController.obtener();
            this.poblacionesAdapter = new ArrayAdapter(this.getContext(), 17367050, this.poblaciones);
            this.poblacionesAutoCompleteTextView.setThreshold(1);
            this.poblacionesAutoCompleteTextView.setAdapter(this.poblacionesAdapter);
        }
    }

    @RequiresApi(api=24)
    public void getReporteDiario() {
        final ProgressDialog dialog = new ProgressDialog((Context)this.getActivity(), 2131951627);
        dialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        this.reporteGeneral.clear();
        String empleadoId = this.sesion.getString("id", "");
        String perfilId = this.sesion.getString("perfil_id", "");
        if (empleadoId.isEmpty() || perfilId.isEmpty()) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"Datos de sesi\u00f3n no v\u00e1lidos", (int)0).show();
            dialog.cancel();
            return;
        }
        DatabaseHelper dbHelper = new DatabaseHelper((Context)this.requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String query = "";
        if (perfilId.equals("12") || perfilId.equals("13")) {
            Log.d((String)"ReporteGeneralFragment", (String)"ENTRO EN IF RESUMEN 12 o 13.........................");
            query = "SELECT poblaciones.nombre_poblacion, pagos.fecha_pago_realizada, clientes.nombre_completo, pagos.folio, pagos.concepto, (CASE WHEN pagos.recuperado = 0 THEN pagos.cantidad_normal_pagada ELSE pagos.recuperado END) pago, pagos.cantidad_multa as pago_multa, pagos.semana, rutas.nombre_ruta FROM pagos INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id INNER JOIN clientes ON clientes.id = prestamos.cliente_id INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id INNER JOIN rutas ON rutas.id = poblaciones.ruta_id WHERE pagos.empleado_id = ? AND pagos.fecha_pago_realizada IS NOT NULL";
            Cursor cursor = db.rawQuery(query, new String[]{empleadoId});
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    ReporteGeneral item = new ReporteGeneral();
                    item.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    item.setFecha_pago_realizada(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago_realizada")));
                    item.setNombre_completo(cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")));
                    item.setFolio(cursor.getString(cursor.getColumnIndexOrThrow("folio")));
                    item.setConcepto(cursor.getString(cursor.getColumnIndexOrThrow("concepto")));
                    item.setPago(cursor.getString(cursor.getColumnIndexOrThrow("pago")));
                    item.setPago_multa(cursor.getString(cursor.getColumnIndexOrThrow("pago_multa")));
                    item.setSemana(cursor.getString(cursor.getColumnIndexOrThrow("semana")));
                    item.setNombre_ruta(cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")));
                    this.reporteGeneral.add(item);
                } while (cursor.moveToNext());
                cursor.close();
            }
            String total = "0";
            for (ReporteGeneral item : this.reporteGeneral) {
                total = total + item.getPago();
            }
            this.tvPago.setText((CharSequence)("PAGO ($" + total + ")"));
            this.reporteGeneralAdapter.addAll(this.reporteGeneral);
            this.reporteGeneralAdapter.notifyItemRangeChanged(this.reporteGeneral.size(), 1);
            this.recyclerView.setVisibility(0);
        } else {
            Log.d((String)"ReporteGeneralFragment", (String)"ENTRO EN ELSE RESUMEN.........................");
            this.vs = VolleyS.getInstance(this.getContext());
            this.requestQueue = this.vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"reporteGeneralAPP");
                data.put("empleado", (Object)this.sesion.getString("id", ""));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        double total = 0.0;
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            ReporteGeneral item = (ReporteGeneral)gson.fromJson(obj.toString(), ReporteGeneral.class);
                            total += Utils.convertirDouble(item.getPago());
                            ReporteGeneralFragment.this.reporteGeneral.add(item);
                        }
                        ReporteGeneralFragment.this.tvPago.setText((CharSequence)("PAGO ($" + total + ")"));
                        dialog.cancel();
                        ReporteGeneralFragment.this.reporteGeneralAdapter.addAll(ReporteGeneralFragment.this.reporteGeneral);
                        ReporteGeneralFragment.this.reporteGeneralAdapter.notifyItemRangeChanged(ReporteGeneralFragment.this.reporteGeneral.size(), 1);
                        ReporteGeneralFragment.this.recyclerView.setVisibility(0);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 1, 1.0f));
            request.setShouldCache(false);
            this.requestQueue.add((Request)request);
        }
        dialog.cancel();
    }

    public void compartirPagoReporte(ReporteGeneral rg) throws ParseException {
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = inputFormat.parse(rg.getFecha_pago_realizada());
            String fechaConvert = outputFormat.format(date);
            NumeroLetras numeroLetras = new NumeroLetras();
            String recibido_con_letra = numeroLetras.Convertir(rg.getPago(), "", "", "", "", "", true);
            String text = "--------------------------\n";
            text = text + "Folio: " + (rg.getFolio() == null ? "" : rg.getFolio()) + "\n";
            text = text + "Reimpresion: " + fechaConvert + "\n";
            text = text + "Ruta: " + rg.getNombre_ruta() + "\n";
            text = text + "Poblacion: " + rg.getNombre_poblacion() + "\n";
            text = text + "Recibi de: " + rg.getNombre_completo() + "\n";
            text = text + "Cantidad: $" + rg.getPago() + "\n";
            text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
            if (rg.getPago_multa() != "0.00") {
                text = text + "Multa: $" + rg.getPago_multa() + "\n";
            }
            text = text + "Concepto: " + (rg.getConcepto() == null ? "" : rg.getConcepto()) + "\n";
            text = text + "--------------------------\n";
            File pdfFile = this.generarPDF(text);
            this.compartirPDF(pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File generarPDF(String content) throws IOException {
        File pdfFile = new File(this.getContext().getCacheDir(), "Recibo de pago.pdf");
        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);
        Drawable drawable2 = this.getResources().getDrawable(2131231010);
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        ImageData imageData = ImageDataFactory.create((byte[])stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);
        document.add((IBlockElement)new Paragraph(content));
        document.close();
        return pdfFile;
    }

    private void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile((Context)this.getContext(), (String)(this.getContext().getApplicationContext().getPackageName() + ".provider"), (File)pdfFile);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)pdfUri);
            this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Compartir mediante"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void filtrarReporte(String fecha) {
        this.reporteGeneralFiltrado = new ArrayList();
        this.reporteGeneralFiltrado.clear();
        double total = 0.0;
        for (ReporteGeneral rg : this.reporteGeneral) {
            if (!rg.getFecha_pago_realizada().equals(fecha)) continue;
            total += Utils.convertirDouble(rg.getPago());
            this.reporteGeneralFiltrado.add(rg);
        }
        this.tvPago.setText((CharSequence)("PAGO ($" + total + ")"));
        if (!this.reporteGeneralFiltrado.isEmpty()) {
            this.reporteGeneralAdapter.setListaFiltrada(this.reporteGeneralFiltrado);
        } else {
            this.reporteGeneralAdapter.setListaFiltrada(new ArrayList<ReporteGeneral>());
            Toast.makeText((Context)this.getContext(), (CharSequence)"No se encontraron resultados", (int)0).show();
        }
    }

    private void filtrarReportePoblacion(String poblacion) {
        this.reporteGeneralFiltrado = new ArrayList();
        this.reporteGeneralFiltrado.clear();
        double total = 0.0;
        for (ReporteGeneral rg : this.reporteGeneral) {
            if (!rg.getNombre_poblacion().equals(poblacion)) continue;
            total += Utils.convertirDouble(rg.getPago());
            this.reporteGeneralFiltrado.add(rg);
        }
        this.tvPago.setText((CharSequence)("PAGO ($" + total + ")"));
        if (!this.reporteGeneralFiltrado.isEmpty()) {
            this.reporteGeneralAdapter.setListaFiltrada(this.reporteGeneralFiltrado);
        } else {
            this.reporteGeneralAdapter.setListaFiltrada(new ArrayList<ReporteGeneral>());
            Toast.makeText((Context)this.getContext(), (CharSequence)"No se encontraron resultados", (int)0).show();
        }
    }

    private void filtrarReporte(String fecha, String poblacion) {
        this.reporteGeneralFiltrado = new ArrayList();
        this.reporteGeneralFiltrado.clear();
        Log.d((String)"ReporteGeneralFragment", (String)("Datos encontrados, procesando resultados...: fecha:" + fecha + " / " + poblacion));
        for (ReporteGeneral rg : this.reporteGeneral) {
            if (!rg.getNombre_poblacion().equals(poblacion) || !rg.getFecha_pago_realizada().equals(fecha)) continue;
            this.reporteGeneralFiltrado.add(rg);
        }
        if (!this.reporteGeneralFiltrado.isEmpty()) {
            this.reporteGeneralAdapter.setListaFiltrada(this.reporteGeneralFiltrado);
        } else {
            this.reporteGeneralAdapter.setListaFiltrada(new ArrayList<ReporteGeneral>());
            Toast.makeText((Context)this.getContext(), (CharSequence)"No se encontraron resultados", (int)0).show();
        }
    }
}

