/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.rmd.Crear;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.ui.rmd.Crear.CrearRMDFragment;
import com.example.sefinsa_app.ui.rmd.Crear.MostrarImagenesRMDAdapter;
import com.google.android.material.textfield.TextInputEditText;
import java.util.ArrayList;

public class AgregarArticuloRMDAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<Articulo> articulos;
    private Context context;
    private FragmentActivity activity;
    private final CrearRMDFragment fragment;

    public AgregarArticuloRMDAdapter(CrearRMDFragment fragment, FragmentActivity activity, Context context, ArrayList<Articulo> articulos) {
        this.fragment = fragment;
        this.activity = activity;
        this.context = context;
        this.articulos = articulos;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(2131492899, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, final @SuppressLint(value={"RecyclerView"}) int position) {
        final Articulo articulo = this.articulos.get(position);
        holder.tvArticulo.setText((CharSequence)("Art\u00edculo: " + articulo.getArticulo()));
        holder.tvMarca.setText((CharSequence)("Marca: " + articulo.getMarca()));
        holder.tvColor.setText((CharSequence)("Color: " + articulo.getColor()));
        holder.btnDetalle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(AgregarArticuloRMDAdapter.this.context);
                builder.setTitle((CharSequence)"Detalles de las condiciones");
                builder.setMessage((CharSequence)articulo.getDetalleCondiciones());
                builder.setPositiveButton((CharSequence)"Cerrar", null);
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
        holder.btnEditar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(AgregarArticuloRMDAdapter.this.context);
                View dialogLayout = LayoutInflater.from((Context)AgregarArticuloRMDAdapter.this.context).inflate(2131492948, null);
                builder.setView(dialogLayout);
                final TextInputEditText edTxtArticulo = (TextInputEditText)dialogLayout.findViewById(2131296580);
                final TextInputEditText edTxtMarca = (TextInputEditText)dialogLayout.findViewById(2131296606);
                final TextInputEditText edTxtColor = (TextInputEditText)dialogLayout.findViewById(2131296582);
                final TextInputEditText edTxtCondiciones = (TextInputEditText)dialogLayout.findViewById(2131296588);
                edTxtArticulo.setText((CharSequence)articulo.getArticulo());
                edTxtMarca.setText((CharSequence)articulo.getMarca());
                edTxtColor.setText((CharSequence)articulo.getColor());
                edTxtCondiciones.setText((CharSequence)articulo.getDetalleCondiciones());
                builder.setTitle((CharSequence)"Editar art\u00edculo");
                builder.setPositiveButton((CharSequence)"Editar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        String articuloE = edTxtArticulo.getText().toString();
                        String marcaE = edTxtMarca.getText().toString();
                        String colorE = edTxtColor.getText().toString();
                        String condicionesE = edTxtCondiciones.getText().toString();
                        articulo.setArticulo(articuloE);
                        articulo.setMarca(marcaE);
                        articulo.setColor(colorE);
                        articulo.setDetalleCondiciones(condicionesE);
                        holder.tvArticulo.setText((CharSequence)("Art\u00edculo: " + articulo.getArticulo()));
                        holder.tvMarca.setText((CharSequence)("Marca: " + articulo.getMarca()));
                        holder.tvColor.setText((CharSequence)("Color: " + articulo.getColor()));
                    }
                });
                builder.setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
        holder.btnFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(AgregarArticuloRMDAdapter.this.context);
                View dialogLayout = LayoutInflater.from((Context)AgregarArticuloRMDAdapter.this.context).inflate(2131492978, null);
                builder.setView(dialogLayout);
                builder.setTitle((CharSequence)"Agregar fotos del art\u00edculo");
                Button btnAbrirCamara = (Button)dialogLayout.findViewById(2131296388);
                Button btnAbrirGaleria = (Button)dialogLayout.findViewById(2131296389);
                final TextView tvCountFotos = (TextView)dialogLayout.findViewById(2131297279);
                final RecyclerView rvImagenes = (RecyclerView)dialogLayout.findViewById(2131296982);
                tvCountFotos.setText((CharSequence)(articulo.getImagenes().size() + "/2"));
                MostrarImagenesRMDAdapter adapter = new MostrarImagenesRMDAdapter(AgregarArticuloRMDAdapter.this.fragment, AgregarArticuloRMDAdapter.this.activity, AgregarArticuloRMDAdapter.this.context, articulo.getImagenes());
                LinearLayoutManager layoutManager = new LinearLayoutManager(AgregarArticuloRMDAdapter.this.context, 0, false);
                rvImagenes.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
                rvImagenes.setAdapter((RecyclerView.Adapter)adapter);
                btnAbrirCamara.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (articulo.getImagenes().size() == 2) {
                            Toast.makeText((Context)AgregarArticuloRMDAdapter.this.context, (CharSequence)"No se pueden agregar mas de dos fotos", (int)0).show();
                            return;
                        }
                        MostrarImagenesRMDAdapter adapter = new MostrarImagenesRMDAdapter(AgregarArticuloRMDAdapter.this.fragment, AgregarArticuloRMDAdapter.this.activity, AgregarArticuloRMDAdapter.this.context, articulo.getImagenes());
                        LinearLayoutManager layoutManager = new LinearLayoutManager(AgregarArticuloRMDAdapter.this.context, 0, false);
                        AgregarArticuloRMDAdapter.this.fragment.arbirCamara(position, adapter, (RecyclerView.LayoutManager)layoutManager, rvImagenes, tvCountFotos);
                    }
                });
                btnAbrirGaleria.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (articulo.getImagenes().size() == 2) {
                            Toast.makeText((Context)AgregarArticuloRMDAdapter.this.context, (CharSequence)"No se pueden agregar mas de dos fotos", (int)0).show();
                            return;
                        }
                        MostrarImagenesRMDAdapter adapter = new MostrarImagenesRMDAdapter(AgregarArticuloRMDAdapter.this.fragment, AgregarArticuloRMDAdapter.this.activity, AgregarArticuloRMDAdapter.this.context, articulo.getImagenes());
                        LinearLayoutManager layoutManager = new LinearLayoutManager(AgregarArticuloRMDAdapter.this.context, 0, false);
                        AgregarArticuloRMDAdapter.this.fragment.abrirGaleria(position, adapter, (RecyclerView.LayoutManager)layoutManager, rvImagenes, tvCountFotos);
                    }
                });
                builder.setPositiveButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
        holder.btnEliminar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(AgregarArticuloRMDAdapter.this.context);
                builder.setTitle((CharSequence)"Eliminar art\u00edculo");
                builder.setMessage((CharSequence)"\u00bfDesea eliminar este art\u00edculo?");
                builder.setPositiveButton((CharSequence)"Eliminar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AgregarArticuloRMDAdapter.this.articulos.remove(position);
                        AgregarArticuloRMDAdapter.this.notifyItemRemoved(position);
                        AgregarArticuloRMDAdapter.this.notifyItemRangeChanged(position, AgregarArticuloRMDAdapter.this.articulos.size());
                    }
                });
                builder.setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
    }

    public int getItemCount() {
        return this.articulos.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvArticulo;
        private TextView tvMarca;
        private TextView tvColor;
        private Button btnDetalle;
        private Button btnEditar;
        private Button btnFotos;
        private Button btnEliminar;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.tvArticulo = (TextView)view.findViewById(2131297266);
            this.tvMarca = (TextView)view.findViewById(2131297304);
            this.tvColor = (TextView)view.findViewById(2131297275);
            this.btnDetalle = (Button)view.findViewById(2131296416);
            this.btnEditar = (Button)view.findViewById(2131296417);
            this.btnFotos = (Button)view.findViewById(2131296427);
            this.btnEliminar = (Button)view.findViewById(2131296422);
        }
    }
}

