/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.rmd.Crear;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.InputFilter;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.DashboardActivity;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.ui.folios.crear.DibujarFirmaActivity;
import com.example.sefinsa_app.ui.rmd.Crear.AgregarArticuloRMDAdapter;
import com.example.sefinsa_app.ui.rmd.Crear.DecimalDigitsInputFilter;
import com.example.sefinsa_app.ui.rmd.Crear.MostrarImagenesRMDAdapter;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.example.sefinsa_app.utilities.Validator;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CrearRMDFragment
extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private String mParam1;
    private String mParam2;
    TextInputLayout tlFolio;
    TextInputLayout tlNumeroCuenta;
    TextInputLayout tlNombre;
    TextInputLayout tlTelefono;
    TextInputLayout tlRuta;
    TextInputLayout tlPoblacion;
    TextInputLayout tlFecha;
    TextInputLayout tlValorGarantia;
    TextInputLayout tlPagara;
    TextInputLayout tlFechaIns;
    TextInputLayout tlRecibeMercancia;
    TextInputEditText edTxtFolio;
    TextInputEditText edTxtNumeroCuenta;
    TextInputEditText edTxtNombre;
    TextInputEditText edTxtRuta;
    TextInputEditText edTxtTelefono;
    TextInputEditText edTxtPoblacion;
    TextInputEditText edTxtFecha;
    TextInputEditText edTxtValorGarantia;
    TextInputEditText edTxtPagara;
    TextInputEditText edTxtFechaIns;
    TextInputEditText edTxtRecibeMercancia;
    Button btnAgregarArticulo;
    Button btnInsertarFirmaCliente;
    Button btnInsertarFirmaAsesor;
    Button btnAgregarRMD;
    ImageView imgVwFirmaCliente;
    ImageView imgVwFirmaAsesor;
    String lat = "";
    String lgt = "";
    FusedLocationProviderClient client;
    String prestamoID;
    RMDController rmdController;
    SharedPreferences sesion;
    ArrayList<Articulo> articulosAgregados;
    RecyclerView rvArticulos;
    String firmaCliente;
    String firmaAsesor;
    ImageView imgFirmaCliente;
    ImageView imgFirmaAsesor;
    private static final int REQUEST_CODE_GALERIA = 100;
    private static final int REQUEST_CODE_CAMARA = 101;
    public int iArt;
    public MostrarImagenesRMDAdapter adapterImagenes;
    public RecyclerView.LayoutManager layoutManagerImagenes;
    public RecyclerView rvImagenes;
    public TextView tvCountFotosImagenes;
    public Uri imgUri;

    public static CrearRMDFragment newInstance(String param1, String param2) {
        CrearRMDFragment fragment = new CrearRMDFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mParam1 = this.getArguments().getString(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(2131492963, container, false);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.prestamoID = bundle.getString("prestamoId");
        }
        this.setVars(view);
        this.setControllers();
        this.setInputVars(view);
        this.setInputVals();
        this.setOnClickListeners();
        return view;
    }

    public void onResume() {
        Bitmap bitmap;
        byte[] decodedBytes;
        super.onResume();
        SharedPreferences p = this.requireActivity().getSharedPreferences("firmas", 0);
        this.firmaCliente = p.getString("firmaClienteRMD", null);
        if (this.firmaCliente != null) {
            decodedBytes = Base64.decode((String)this.firmaCliente, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
            this.imgFirmaCliente.setImageBitmap(bitmap);
        }
        this.firmaAsesor = p.getString("firmaAsesorRMD", null);
        if (this.firmaAsesor != null) {
            decodedBytes = Base64.decode((String)this.firmaAsesor, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
            this.imgFirmaAsesor.setImageBitmap(bitmap);
        }
    }

    public void setControllers() {
        this.rmdController = new RMDController(this.getContext(), (Activity)this.getActivity());
    }

    public void setInputVars(View view) {
        this.tlFolio = (TextInputLayout)view.findViewById(2131297182);
        this.tlNumeroCuenta = (TextInputLayout)view.findViewById(2131297206);
        this.tlNombre = (TextInputLayout)view.findViewById(2131297200);
        this.tlTelefono = (TextInputLayout)view.findViewById(2131297234);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297217);
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        this.tlValorGarantia = (TextInputLayout)view.findViewById(2131297243);
        this.tlPagara = (TextInputLayout)view.findViewById(2131297213);
        this.tlFechaIns = (TextInputLayout)view.findViewById(2131297180);
        this.tlRecibeMercancia = (TextInputLayout)view.findViewById(2131297224);
        this.edTxtFolio = (TextInputEditText)view.findViewById(2131296598);
        this.edTxtNumeroCuenta = (TextInputEditText)view.findViewById(2131296610);
        this.edTxtNombre = (TextInputEditText)view.findViewById(2131296608);
        this.edTxtRuta = (TextInputEditText)view.findViewById(2131296622);
        this.edTxtTelefono = (TextInputEditText)view.findViewById(2131296624);
        this.edTxtPoblacion = (TextInputEditText)view.findViewById(2131296619);
        this.edTxtFecha = (TextInputEditText)view.findViewById(2131296593);
        this.edTxtValorGarantia = (TextInputEditText)view.findViewById(2131296629);
        this.edTxtPagara = (TextInputEditText)view.findViewById(2131296615);
        InputFilter[] filter = new InputFilter[]{new DecimalDigitsInputFilter(8, 2)};
        this.edTxtValorGarantia.setFilters(filter);
        this.edTxtPagara.setFilters(filter);
        this.edTxtFechaIns = (TextInputEditText)view.findViewById(2131296595);
        this.edTxtRecibeMercancia = (TextInputEditText)view.findViewById(2131296620);
        this.btnAgregarArticulo = (Button)view.findViewById(2131296393);
        this.btnInsertarFirmaCliente = (Button)view.findViewById(2131296424);
        this.btnInsertarFirmaAsesor = (Button)view.findViewById(2131296423);
        this.btnAgregarRMD = (Button)view.findViewById(2131296395);
        this.imgVwFirmaCliente = (ImageView)view.findViewById(2131296720);
        this.imgVwFirmaAsesor = (ImageView)view.findViewById(2131296719);
    }

    public void setInputVals() {
        RMD rmd = this.rmdController.getDatosBaseRMD(this.prestamoID);
        this.sesion = this.getContext().getSharedPreferences("sesion", 0);
        String empleado_id = this.sesion.getString("id", null);
        this.edTxtFolio.setText((CharSequence)this.rmdController.getPrimerRMDId(empleado_id));
        this.edTxtNumeroCuenta.setText((CharSequence)rmd.getNumeroCuenta());
        this.edTxtNombre.setText((CharSequence)rmd.getNombre());
        this.edTxtTelefono.setText((CharSequence)rmd.getTelefono());
        this.edTxtRuta.setText((CharSequence)rmd.getRuta());
        this.edTxtPoblacion.setText((CharSequence)rmd.getPoblacion());
        LocalDate today = null;
        if (Build.VERSION.SDK_INT >= 26) {
            today = LocalDate.now();
            String[] pFecha = String.valueOf(today).split("-");
            this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
        }
    }

    public void setVars(View view) {
        this.articulosAgregados = new ArrayList();
        this.rvArticulos = (RecyclerView)view.findViewById(2131296974);
        this.imgFirmaCliente = (ImageView)view.findViewById(2131296720);
        this.imgFirmaAsesor = (ImageView)view.findViewById(2131296719);
        SharedPreferences p = this.requireActivity().getSharedPreferences("firmas", 0);
        SharedPreferences.Editor editor = p.edit();
        editor.remove("firmaClienteRMD");
        editor.remove("firmaAsesorRMD");
        editor.apply();
    }

    public void setOnClickListeners() {
        this.btnAgregarArticulo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View vw) {
                CrearRMDFragment.this.getCurrentLocation();
                if (CrearRMDFragment.this.articulosAgregados.size() == 3) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)CrearRMDFragment.this.requireActivity());
                    builder.setTitle((CharSequence)"Cantidad de art\u00edculos maxima alcanzada");
                    builder.setMessage((CharSequence)"No se pueden agregar mas de tres articulos.");
                    builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int id2) {
                            dialog.dismiss();
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.show();
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(CrearRMDFragment.this.getContext());
                    View dialogLayout = LayoutInflater.from((Context)CrearRMDFragment.this.getContext()).inflate(2131492948, null);
                    builder.setView(dialogLayout);
                    TextInputEditText edTxtArticulo = (TextInputEditText)dialogLayout.findViewById(2131296580);
                    TextInputEditText edTxtMarca = (TextInputEditText)dialogLayout.findViewById(2131296606);
                    TextInputEditText edTxtColor = (TextInputEditText)dialogLayout.findViewById(2131296582);
                    TextInputEditText edTxtCondiciones = (TextInputEditText)dialogLayout.findViewById(2131296588);
                    builder.setTitle((CharSequence)"Agregar art\u00edculo");
                    builder.setPositiveButton((CharSequence)"Agregar", null);
                    builder.setNegativeButton((CharSequence)"Cancelar", (dialogInterface, i) -> dialogInterface.dismiss());
                    AlertDialog dialog = builder.create();
                    dialog.setOnShowListener(d -> {
                        Button btnAgregar = dialog.getButton(-1);
                        btnAgregar.setOnClickListener(v -> {
                            String articulo = edTxtArticulo.getText().toString().trim();
                            String marca = edTxtMarca.getText().toString().trim();
                            String color2 = edTxtColor.getText().toString().trim();
                            String condiciones = edTxtCondiciones.getText().toString().trim();
                            ArrayList<Bitmap> imagenes = new ArrayList<Bitmap>();
                            ArrayList<Uri> urisImagenes = new ArrayList<Uri>();
                            if (articulo.isEmpty() || marca.isEmpty() || color2.isEmpty() || condiciones.isEmpty()) {
                                Toast.makeText((Context)CrearRMDFragment.this.getContext(), (CharSequence)"Todos los campos son requeridos", (int)0).show();
                            } else {
                                CrearRMDFragment.this.articulosAgregados.add(new Articulo(articulo, marca, color2, condiciones, imagenes, urisImagenes));
                                CrearRMDFragment.this.setArticulosRecyclerView();
                                Toast.makeText((Context)CrearRMDFragment.this.getContext(), (CharSequence)"Art\u00edculo agregado", (int)0).show();
                                dialog.dismiss();
                            }
                        });
                    });
                    dialog.show();
                }
            }
        });
        this.btnInsertarFirmaCliente.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)CrearRMDFragment.this.getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma de cliente");
                CrearRMDFragment.this.startActivity(intent);
            }
        });
        this.btnInsertarFirmaAsesor.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)CrearRMDFragment.this.getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma de asesor");
                CrearRMDFragment.this.startActivity(intent);
            }
        });
        this.tlFechaIns.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText((CharSequence)"Fecha");
                CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());
                materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(CrearRMDFragment.this.getChildFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener((MaterialPickerOnPositiveButtonClickListener)new MaterialPickerOnPositiveButtonClickListener<Long>(){

                    @SuppressLint(value={"SetTextI18n"})
                    public void onPositiveButtonClick(Long selection) {
                        TimeZone timeZoneUTC = TimeZone.getDefault();
                        int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        Date date = new Date(selection + (long)offsetFromUTC);
                        String f = simpleFormat.format(date);
                        String[] pFecha = f.split("-");
                        CrearRMDFragment.this.tlFechaIns.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
                    }
                });
            }
        });
        this.btnAgregarRMD.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CrearRMDFragment.this.crearRMD();
            }
        });
    }

    public void imprimirTicket(String folio) throws ParseException, IOException {
        BluetoothUtils.context = this.getContext();
        BluetoothUtils.printPhoto(2131230871);
        RMD rmd = this.rmdController.getRMDParaImpresion(folio);
        if (Build.VERSION.SDK_INT >= 26) {
            BluetoothUtils.imprimirRMD(rmd);
        }
    }

    public void crearRMD() {
        final String folio = this.edTxtFolio.getText().toString();
        String numeroCuenta = this.edTxtNumeroCuenta.getText().toString();
        String nombre = this.edTxtNombre.getText().toString();
        String telefono = this.edTxtTelefono.getText().toString();
        String ruta = this.edTxtRuta.getText().toString();
        String poblacion = this.edTxtPoblacion.getText().toString();
        String fecha = this.edTxtFecha.getText().toString();
        ArrayList<Articulo> articulos = this.articulosAgregados;
        String valorGarantia = this.edTxtValorGarantia.getText().toString();
        String pagara = this.edTxtPagara.getText().toString();
        String fechaIns = this.edTxtFechaIns.getText().toString();
        String recibeMercancia = this.edTxtRecibeMercancia.getText().toString();
        String firmaCliente = this.firmaCliente;
        String firmaAsesor = this.firmaAsesor;
        if (Validator.fieldValidation(this.tlValorGarantia, "El campo Valor de garant\u00eda es requerido") && Validator.fieldValidation(this.tlPagara, "El campo Pagara es requerido") && Validator.fieldValidation(this.tlFechaIns, "El campo Fecha es requerido") && Validator.fieldValidation(this.tlRecibeMercancia, "El campo Recibe Mercancia es requerido")) {
            AlertDialog dialog;
            AlertDialog.Builder builder;
            if (firmaCliente == null || firmaAsesor == null) {
                builder = new AlertDialog.Builder((Context)this.requireActivity());
                builder.setTitle((CharSequence)"Ambas firmas son requeridas");
                builder.setMessage((CharSequence)"Faltan una o ambas firmas de ser dibujadas.");
                builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.dismiss();
                    }
                });
                dialog = builder.create();
                dialog.show();
            }
            if (articulos.isEmpty()) {
                builder = new AlertDialog.Builder((Context)this.requireActivity());
                builder.setTitle((CharSequence)"Agregar articulos");
                builder.setMessage((CharSequence)"Se debe de haber agregado por lo menos un art\u00edculo.");
                builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.dismiss();
                    }
                });
                dialog = builder.create();
                dialog.show();
            }
            if (!articulos.isEmpty() && firmaCliente != null && firmaAsesor != null) {
                RMD rmd = new RMD(folio, articulos, valorGarantia, fechaIns, pagara, fecha, firmaCliente, firmaAsesor, recibeMercancia);
                this.rmdController.postRMD(rmd, this.prestamoID, new RMDController.prerararRMDSCallback(){

                    @Override
                    public void onSuccess(String response) {
                        final AlertDialog.Builder builder = new AlertDialog.Builder(CrearRMDFragment.this.getContext());
                        builder.setTitle((CharSequence)"RMD creado");
                        builder.setMessage((CharSequence)"El RMD se ha creado correctamente.");
                        final BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                        builder.setPositiveButton((CharSequence)"Imprimir Ticket", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int id2) {
                                if (BluetoothUtils.mConnectedThread == null || !bluetoothAdapter.isEnabled()) {
                                    BluetoothUtils.mConnectedThread = null;
                                    final AlertDialog.Builder builder2 = new AlertDialog.Builder(CrearRMDFragment.this.getContext());
                                    builder2.setTitle((CharSequence)"No hay impresora conectada");
                                    builder2.setMessage((CharSequence)"\u00bfDesea contectarse a una impresora?");
                                    builder2.setPositiveButton((CharSequence)"Conectarse", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            final ProgressDialog progressDialog = new ProgressDialog(CrearRMDFragment.this.getContext());
                                            if (!bluetoothAdapter.isEnabled()) {
                                                Toast.makeText((Context)CrearRMDFragment.this.getContext(), (CharSequence)"Enciende el bluetooth para continuar", (int)0).show();
                                                AlertDialog d = builder2.create();
                                                progressDialog.dismiss();
                                                d.show();
                                            } else {
                                                DashboardActivity da = (DashboardActivity)CrearRMDFragment.this.getActivity();
                                                da.conectarImpresora(new DashboardActivity.ConexionCallback(){

                                                    @Override
                                                    public void onSuccess() {
                                                        progressDialog.dismiss();
                                                        AlertDialog dialog = builder.create();
                                                        dialog.show();
                                                    }
                                                });
                                            }
                                        }
                                    });
                                    builder2.setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();
                                            Navigation.findNavController((Activity)CrearRMDFragment.this.getActivity(), (int)2131296862).navigate(2131296872);
                                        }
                                    });
                                    builder2.setCancelable(false);
                                    AlertDialog dialog2 = builder2.create();
                                    dialog2.show();
                                } else {
                                    try {
                                        CrearRMDFragment.this.imprimirTicket(folio);
                                        dialog.dismiss();
                                    }
                                    catch (ParseException e) {
                                        throw new RuntimeException(e);
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    AlertDialog d = builder.create();
                                    d.show();
                                }
                            }
                        });
                        builder.setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int id2) {
                                dialog.dismiss();
                                Navigation.findNavController((Activity)CrearRMDFragment.this.getActivity(), (int)2131296862).navigate(2131296872);
                            }
                        });
                        builder.setCancelable(false);
                        AlertDialog dialog = builder.create();
                        dialog.show();
                    }

                    @Override
                    public void onError(String error) {
                        Toast.makeText((Context)CrearRMDFragment.this.getContext(), (CharSequence)"Error al crear RMD", (int)0).show();
                        Log.d((String)"Error insercion local", (String)error);
                    }

                    @Override
                    public void onSucess() {
                    }
                });
                if (NetworkChange.isConnectedToInternet(this.getContext())) {
                    this.rmdController.subirRMDServidor(rmd, this.prestamoID);
                }
            }
        }
    }

    public void setArticulosRecyclerView() {
        AgregarArticuloRMDAdapter adapter = new AgregarArticuloRMDAdapter(this, this.getActivity(), this.getContext(), this.articulosAgregados);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.rvArticulos.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.rvArticulos.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.rvArticulos.setAdapter((RecyclerView.Adapter)adapter);
    }

    public void arbirCamara(int pos, MostrarImagenesRMDAdapter adapter, RecyclerView.LayoutManager layoutManager, RecyclerView rv, TextView tvCountFotos) {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.adapterImagenes = adapter;
        this.layoutManagerImagenes = layoutManager;
        this.rvImagenes = rv;
        this.tvCountFotosImagenes = tvCountFotos;
        this.iArt = pos;
        if (takePictureIntent.resolveActivity(this.requireActivity().getPackageManager()) != null) {
            Uri image_uri;
            ContentValues values = new ContentValues();
            values.put("title", "Imagen ejemplo");
            values.put("description", "Camara ejemplo");
            this.imgUri = image_uri = this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
            takePictureIntent.putExtra("output", (Parcelable)image_uri);
            this.startActivityForResult(takePictureIntent, 101);
        }
    }

    public void abrirGaleria(int pos, MostrarImagenesRMDAdapter adapter, RecyclerView.LayoutManager layoutManager, RecyclerView rv, TextView tvCountFotos) {
        this.adapterImagenes = adapter;
        this.layoutManagerImagenes = layoutManager;
        this.rvImagenes = rv;
        this.tvCountFotosImagenes = tvCountFotos;
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        intent.addCategory("android.intent.category.OPENABLE");
        this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Selecciona imagenes"), 100);
        this.iArt = pos;
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101 && resultCode == -1) {
            this.guardarBitmapDesdeUri(this.imgUri);
        } else if (requestCode == 100 && resultCode == -1 && data != null) {
            int imagenesActuales = this.articulosAgregados.get(this.iArt).getImagenes().size();
            if (data.getClipData() != null) {
                int count = data.getClipData().getItemCount();
                if (count + imagenesActuales > 2) {
                    Toast.makeText((Context)this.getContext(), (CharSequence)"Solo puedes agregar un m\u00e1ximo de 2 im\u00e1genes", (int)0).show();
                    return;
                }
                for (int i = 0; i < count; ++i) {
                    Uri imageUri = data.getClipData().getItemAt(i).getUri();
                    this.guardarBitmapDesdeUri(imageUri);
                }
            } else if (data.getData() != null) {
                if (imagenesActuales >= 2) {
                    Toast.makeText((Context)this.getContext(), (CharSequence)"Solo puedes agregar un m\u00e1ximo de 2 im\u00e1genes", (int)0).show();
                    return;
                }
                Uri imageUri = data.getData();
                this.guardarBitmapDesdeUri(imageUri);
            }
        }
    }

    private void guardarBitmapDesdeUri(Uri uri) {
        try {
            this.articulosAgregados.get(this.iArt).getUrisImagenes().add(uri);
            Bitmap original = MediaStore.Images.Media.getBitmap((ContentResolver)this.requireContext().getContentResolver(), (Uri)uri);
            Bitmap mutableBitmap = original.copy(Bitmap.Config.ARGB_8888, true);
            mutableBitmap = this.agregarFechaYUbicacionAImagen(mutableBitmap);
            this.articulosAgregados.get(this.iArt).getImagenes().add(mutableBitmap);
            this.rvImagenes.setLayoutManager(this.layoutManagerImagenes);
            this.rvImagenes.setAdapter((RecyclerView.Adapter)this.adapterImagenes);
            this.tvCountFotosImagenes.setText((CharSequence)(this.articulosAgregados.get(this.iArt).getImagenes().size() + "/2"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Bitmap agregarFechaYUbicacionAImagen(Bitmap bitmap) {
        this.addDateTimeToBitmap(bitmap);
        this.addCoordsToBitmap(bitmap);
        return bitmap;
    }

    private void addCoordsToBitmap(Bitmap bitmap) {
        this.getCurrentLocation();
        String text = this.lat + ", " + this.lgt;
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(100.0f);
        textPaint.setAntiAlias(true);
        float textWidth = textPaint.measureText(text);
        float textHeight = textPaint.getTextSize();
        float padding = 10.0f;
        float x = (float)bitmap.getWidth() - textWidth - padding;
        float y = (float)bitmap.getHeight() - padding;
        canvas.drawRect(x - padding, y - textHeight - padding / 2.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        canvas.drawText(text, x, y, textPaint);
    }

    @SuppressLint(value={"MissingPermission"})
    private void getCurrentLocation() {
        LocationManager locationManager = (LocationManager)this.getActivity().getSystemService("location");
        this.client = LocationServices.getFusedLocationProviderClient((Activity)this.getActivity());
        if (locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network")) {
            this.client.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    final Location location = (Location)task.getResult();
                    if (location != null) {
                        CrearRMDFragment.this.lat = String.valueOf(location.getLatitude());
                        CrearRMDFragment.this.lgt = String.valueOf(location.getLongitude());
                    } else {
                        LocationRequest locationRequest = new LocationRequest().setPriority(100).setInterval(10000L).setFastestInterval(1000L).setNumUpdates(1);
                        LocationCallback locationCallback = new LocationCallback(){

                            public void onLocationResult(LocationResult locationResult) {
                                Location location1 = locationResult.getLastLocation();
                                CrearRMDFragment.this.lat = String.valueOf(location.getLatitude());
                                CrearRMDFragment.this.lgt = String.valueOf(location.getLongitude());
                            }
                        };
                        CrearRMDFragment.this.client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                    }
                }
            });
        } else {
            this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS").setFlags(0x10000000));
        }
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = this.getCurrentDateTime();
        Canvas canvas = new Canvas(bitmap);
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor((String)"#80000000"));
        canvas.drawRect(0.0f, (float)(bitmap.getHeight() - 110), (float)bitmap.getWidth(), (float)bitmap.getHeight(), backgroundPaint);
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(100.0f);
        textPaint.setAntiAlias(true);
        float x = 10.0f;
        float y = bitmap.getHeight() - 15;
        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void eliminarImagen(int n) {
        this.tvCountFotosImagenes.setText((CharSequence)(n + "/2"));
    }
}

