/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.rmd.Crear;

import android.text.InputFilter;
import android.text.Spanned;

public class DecimalDigitsInputFilter
implements InputFilter {
    private final int maxDigitsBeforeDecimal;
    private final int maxDigitsAfterDecimal;

    public DecimalDigitsInputFilter(int maxDigitsBeforeDecimal, int maxDigitsAfterDecimal) {
        this.maxDigitsBeforeDecimal = maxDigitsBeforeDecimal;
        this.maxDigitsAfterDecimal = maxDigitsAfterDecimal;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        String newString = dest.toString().substring(0, dstart) + source + dest.toString().substring(dend);
        if (newString.equals(".")) {
            return "0.";
        }
        if (newString.contains(".")) {
            String[] parts = newString.split("\\.");
            if (parts.length > 2) {
                return "";
            }
            if (parts[0].length() > this.maxDigitsBeforeDecimal) {
                return "";
            }
            if (parts.length == 2 && parts[1].length() > this.maxDigitsAfterDecimal) {
                return "";
            }
        } else if (newString.length() > this.maxDigitsBeforeDecimal) {
            return "";
        }
        return null;
    }
}

