/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.rmd;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.rmd.Ver.RMDAdapter;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public class RMDFragment
extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private String mParam1;
    private String mParam2;
    RecyclerView rvRMD;
    TextInputLayout tlNombreFolio;
    TextInputLayout tlFecha;
    TextInputLayout tlRuta;
    TextInputLayout tlPoblacion;
    TextInputEditText etNombreFolio;
    TextInputEditText etFecha;
    AutoCompleteTextView acRuta;
    AutoCompleteTextView acPoblacion;
    RMDController rmdController;
    ProgressDialog pDialog;
    ArrayList<Ruta> rutas;
    ArrayList<Poblacion> poblaciones;
    ArrayAdapter<Ruta> rutasAdapter;
    ArrayAdapter<Poblacion> poblacionesAdapter;
    String ruta_id = "";
    String poblacion_id = "";
    private SharedPreferences sesion;
    private String fecha = null;

    public static RMDFragment newInstance(String param1, String param2) {
        RMDFragment fragment = new RMDFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        if (this.getArguments() != null) {
            this.mParam1 = this.getArguments().getString(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(2131492971, container, false);
        this.rmdController = new RMDController(this.getContext(), (Activity)this.getActivity());
        try {
            this.setGlobalVars(view);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return view;
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case 2131296345: {
                this.acRuta.setText((CharSequence)"");
                this.acPoblacion.setText((CharSequence)"");
                this.tlFecha.getEditText().setText((CharSequence)"");
                this.tlNombreFolio.getEditText().setText((CharSequence)"");
                this.tlRuta.getEditText().clearFocus();
                this.tlPoblacion.getEditText().clearFocus();
                this.tlNombreFolio.getEditText().clearFocus();
                this.poblacion_id = "";
                this.ruta_id = "";
                this.fecha = null;
                this.acPoblacion.setAdapter(null);
                this.acPoblacion.setText((CharSequence)"");
                if (NetworkChange.isConnectedToInternet(this.requireContext())) {
                    try {
                        this.dbSync();
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.filtrar();
                }
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void setGlobalVars(View view) throws JSONException {
        this.sesion = this.getActivity().getSharedPreferences("sesion", 0);
        this.rvRMD = (RecyclerView)view.findViewById(2131296985);
        this.tlNombreFolio = (TextInputLayout)view.findViewById(2131297205);
        this.tlFecha = (TextInputLayout)view.findViewById(2131297177);
        this.tlRuta = (TextInputLayout)view.findViewById(2131297228);
        this.tlPoblacion = (TextInputLayout)view.findViewById(2131297217);
        this.etNombreFolio = (TextInputEditText)view.findViewById(2131296609);
        this.etFecha = (TextInputEditText)view.findViewById(2131296593);
        this.acRuta = (AutoCompleteTextView)view.findViewById(2131296288);
        this.acPoblacion = (AutoCompleteTextView)view.findViewById(2131296285);
        this.getRutasEmpleado();
        this.setInputsParaFiltrar();
        if (NetworkChange.isConnectedToInternet(this.getContext())) {
            this.dbSync();
        } else {
            this.filtrar();
        }
    }

    public void getRutasEmpleado() {
        String rutasEmpleado = this.sesion.getString("rutas", "");
        String[] rutasEmpleadoArr = rutasEmpleado.split(",");
        ArrayList<Integer> rutasNumericas = new ArrayList<Integer>();
        for (String rutaStr : rutasEmpleadoArr) {
            try {
                rutasNumericas.add(Integer.parseInt(rutaStr.trim()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(rutasNumericas);
        this.rutas = new ArrayList();
        Iterator iterator = rutasNumericas.iterator();
        while (iterator.hasNext()) {
            int num = (Integer)iterator.next();
            this.rutas.add(new Ruta(String.valueOf(num), "RUTA " + num));
        }
        this.rutasAdapter = new ArrayAdapter(this.getContext(), 17367043, this.rutas);
        this.acRuta.setAdapter(this.rutasAdapter);
        this.acRuta.setText((CharSequence)"");
    }

    public void setInputsParaFiltrar() {
        this.tlNombreFolio.getEditText().addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String input = s.toString();
                RMDFragment.this.acRuta.setText((CharSequence)"");
                RMDFragment.this.acPoblacion.setText((CharSequence)"");
                RMDFragment.this.tlFecha.getEditText().setText((CharSequence)"");
                RMDFragment.this.poblacion_id = "";
                RMDFragment.this.ruta_id = "";
                RMDFragment.this.fecha = null;
                if (input.matches("\\d+")) {
                    RMDFragment.this.setRecycler(RMDFragment.this.rmdController.filtroFolio(input));
                } else if (input.isEmpty()) {
                    RMDFragment.this.filtrar();
                } else {
                    RMDFragment.this.setRecycler(RMDFragment.this.rmdController.filtroNombre(input));
                }
            }
        });
        this.acRuta.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Ruta ruta = (Ruta)parent.getItemAtPosition(position);
                RMDFragment.this.ruta_id = ruta.getId();
                RMDFragment.this.poblacion_id = "";
                RutaController rutaController = new RutaController(RMDFragment.this.getContext());
                RMDFragment.this.poblaciones = rutaController.getPoblaciones(RMDFragment.this.ruta_id);
                RMDFragment.this.poblacionesAdapter = new ArrayAdapter(RMDFragment.this.getContext(), 17367043, RMDFragment.this.poblaciones);
                RMDFragment.this.acPoblacion.setAdapter(RMDFragment.this.poblacionesAdapter);
                RMDFragment.this.acPoblacion.setText((CharSequence)"");
                RMDFragment.this.tlRuta.getEditText().clearFocus();
                RMDFragment.this.filtrar();
            }
        });
        this.acPoblacion.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Poblacion poblacion = (Poblacion)parent.getItemAtPosition(position);
                RMDFragment.this.poblacion_id = poblacion.getId();
                RMDFragment.this.tlPoblacion.getEditText().clearFocus();
                RMDFragment.this.filtrar();
            }
        });
        if (Build.VERSION.SDK_INT >= 26) {
            LocalDate today = LocalDate.now();
            String[] pFecha = String.valueOf(today).split("-");
            this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
            this.fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
        }
        this.tlFecha.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LocalDate today = null;
                String date = null;
                RMDFragment.this.tlNombreFolio.getEditText().setText((CharSequence)"");
                if (Build.VERSION.SDK_INT >= 26) {
                    today = LocalDate.now();
                    String[] pFecha = String.valueOf(today).split("-");
                    date = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                }
                if (!Objects.equals(RMDFragment.this.fecha, date)) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        RMDFragment.this.tlFecha.getEditText().setText(date);
                        RMDFragment.this.fecha = date;
                        RMDFragment.this.filtrar();
                    }
                } else {
                    MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                    materialDateBuilder.setTitleText((CharSequence)"Fecha");
                    CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                    constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());
                    materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());
                    MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                    materialDatePicker.show(RMDFragment.this.getChildFragmentManager(), "MATERIAL_DATE_PICKER");
                    materialDatePicker.addOnPositiveButtonClickListener((MaterialPickerOnPositiveButtonClickListener)new MaterialPickerOnPositiveButtonClickListener<Long>(){

                        @SuppressLint(value={"SetTextI18n"})
                        public void onPositiveButtonClick(Long selection) {
                            TimeZone timeZoneUTC = TimeZone.getDefault();
                            int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                            Date date = new Date(selection + (long)offsetFromUTC);
                            if (Build.VERSION.SDK_INT >= 26) {
                                ZoneId zoneId;
                                LocalDate today = LocalDate.now();
                                Instant instant = date.toInstant();
                                LocalDate selectedDate = instant.atZone(zoneId = ZoneId.systemDefault()).toLocalDate();
                                if (selectedDate.isAfter(today)) {
                                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)RMDFragment.this.getActivity());
                                    builder.setTitle((CharSequence)"Fecha invalida");
                                    builder.setMessage((CharSequence)"La fecha ingresada no puede ser mayor a la de hoy.");
                                    builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int id2) {
                                            dialog.dismiss();
                                        }
                                    });
                                    AlertDialog dialog = builder.create();
                                    dialog.show();
                                } else {
                                    String f = simpleFormat.format(date);
                                    String[] pFecha = f.split("-");
                                    String mFecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                                    RMDFragment.this.tlFecha.getEditText().setText((CharSequence)mFecha);
                                    RMDFragment.this.fecha = mFecha;
                                    RMDFragment.this.filtrar();
                                }
                            }
                        }
                    });
                }
            }
        });
        this.filtrar();
    }

    public void dbSync() throws JSONException {
        this.pDialog = new ProgressDialog(this.getContext());
        this.pDialog.setMessage((CharSequence)"Cargando datos, por favor espere...");
        this.pDialog.setCancelable(false);
        this.pDialog.show();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                RMDFragment.this.pDialog.dismiss();
            }
        }, 25L, TimeUnit.SECONDS);
        this.rmdController = new RMDController(this.getContext(), (Activity)this.getActivity());
        final int[] cargados = new int[]{0};
        this.syncServerApp(new SyncCallback(){

            @Override
            public void onSuccess() {
                cargados[0] = cargados[0] + 1;
                if (cargados[0] >= 3) {
                    RMDFragment.this.pDialog.dismiss();
                    RMDFragment.this.filtrar();
                }
            }
        });
        this.syncEdit(new SyncCallback(){

            @Override
            public void onSuccess() {
                cargados[0] = cargados[0] + 1;
                if (cargados[0] >= 3) {
                    RMDFragment.this.pDialog.dismiss();
                    RMDFragment.this.filtrar();
                }
            }
        });
        this.syncAppServer(new SyncCallback(){

            @Override
            public void onSuccess() {
                cargados[0] = cargados[0] + 1;
                if (cargados[0] >= 3) {
                    RMDFragment.this.pDialog.dismiss();
                    RMDFragment.this.filtrar();
                }
            }
        });
    }

    public void syncServerApp(final SyncCallback callback) {
        this.rmdController.getCountRMDsServidor(new RMDController.GetCountRMDsServidorCallback(){

            @Override
            public void onSuccess(int n) {
                int c = RMDFragment.this.rmdController.getRMDSCount();
                if (c == n) {
                    callback.onSuccess();
                } else {
                    RMDFragment.this.rmdController.getRMDSinSincronizar(new RMDController.GetRMDsSinSincronizarCallback(){

                        @Override
                        public void onSuccess(final ArrayList<RMD> rmds) {
                            if (rmds != null && !rmds.isEmpty()) {
                                final int[] n = new int[]{0};
                                for (RMD rmd : rmds) {
                                    RMDFragment.this.rmdController.intertarRMDServidor(rmd, new RMDController.SincronizarDelServidorCallback(){

                                        @Override
                                        public void onSuccess() {
                                            n[0] = n[0] + 1;
                                            if (n[0] == rmds.size()) {
                                                callback.onSuccess();
                                            }
                                        }

                                        @Override
                                        public void onError(String error) {
                                        }
                                    });
                                }
                            }
                        }

                        @Override
                        public void onError(String error) {
                        }
                    });
                }
            }

            @Override
            public void onError(String error) {
                Log.d((String)"ERROR", (String)("onError: " + error));
            }
        });
    }

    public void syncEdit(SyncCallback callback) throws JSONException {
        this.rmdController.getRMDsEditados();
        callback.onSuccess();
    }

    public void syncAppServer(SyncCallback callback) {
        ArrayList<RMD> rmds = this.rmdController.getRMDsDesincronizados();
        if (rmds != null && !rmds.isEmpty()) {
            this.sincronizar(rmds);
            callback.onSuccess();
        } else {
            callback.onSuccess();
        }
    }

    public void filtrar() {
        if (this.fecha != null) {
            if (!Objects.equals(this.poblacion_id, "")) {
                this.setRecycler(this.rmdController.filtroPoblacionFecha(this.fecha, this.poblacion_id));
            } else if (!Objects.equals(this.ruta_id, "")) {
                this.setRecycler(this.rmdController.filtroRutaFecha(this.fecha, this.ruta_id));
            } else {
                this.setRecycler(this.rmdController.filtroFecha(this.fecha));
            }
        } else if (Build.VERSION.SDK_INT >= 26) {
            LocalDate today = LocalDate.now();
            String[] pFecha = String.valueOf(today).split("-");
            this.tlFecha.getEditText().setText((CharSequence)(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]));
            this.fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
            this.filtrar();
        }
    }

    public void setRecycler(ArrayList<RMD> rmds) {
        RMDAdapter adapter = new RMDAdapter(rmds, this, this.getContext(), this.getActivity());
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.rvRMD.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.rvRMD.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.rvRMD.setAdapter((RecyclerView.Adapter)adapter);
    }

    public File generarPDF(String content, String fc, String fa, String folio) throws IOException {
        File pdfFile = new File(this.getContext().getCacheDir(), "RMD" + folio + ".pdf");
        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);
        Drawable drawable2 = this.getResources().getDrawable(2131231010);
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        ImageData imageData = ImageDataFactory.create((byte[])stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);
        Paragraph p = new Paragraph(content);
        p.setFontSize(6.0f);
        document.add((IBlockElement)p);
        Paragraph p2 = new Paragraph("Firma del cliente: \n");
        p2.setFontSize(8.0f);
        document.add((IBlockElement)p2);
        byte[] decodedBytes2 = Base64.decode((String)fc, (int)0);
        bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes2, (int)0, (int)decodedBytes2.length);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos2);
        ImageData imageData3 = ImageDataFactory.create((byte[])baos2.toByteArray());
        Image image3 = new Image(imageData3);
        image3.scaleToFit(100.0f, 100.0f);
        document.add(image3);
        Paragraph p3 = new Paragraph("Firma del asesor: \n");
        p3.setFontSize(8.0f);
        document.add((IBlockElement)p3);
        byte[] decodedBytes = Base64.decode((String)fa, (int)0);
        bitmap = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos1);
        ImageData imageData2 = ImageDataFactory.create((byte[])baos1.toByteArray());
        Image image2 = new Image(imageData2);
        image2.scaleToFit(100.0f, 100.0f);
        document.add(image2);
        document.close();
        return pdfFile;
    }

    public void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile((Context)this.getContext(), (String)(this.getContext().getApplicationContext().getPackageName() + ".provider"), (File)pdfFile);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)pdfUri);
            this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Compartir mediante"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sincronizar(final ArrayList<RMD> rmds) {
        final int[] c = new int[]{0};
        for (RMD rmd : rmds) {
            this.rmdController.subirRMDsDesincronizadosServidor(rmd, new RMDController.SubirRMDsDesincronizadosServidorCallback(){

                @Override
                public void onSuccess() {
                    c[0] = c[0] + 1;
                    Log.d((String)"aklsdklaskld", (String)(c[0] + " / " + rmds.size()));
                    if (c[0] == rmds.size()) {
                        RMDFragment.this.pDialog.dismiss();
                        RMDFragment.this.filtrar();
                    }
                }

                @Override
                public void onError(String error) {
                }
            });
        }
    }

    public static interface SyncCallback {
        public void onSuccess();
    }
}

