/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.rmd.Ver;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.ui.rmd.RMDFragment;
import com.example.sefinsa_app.utilities.NetworkChange;
import java.util.ArrayList;

public class DetalleRMDArticuloAdapter
extends RecyclerView.Adapter<ViewHolder> {
    ArrayList<Articulo> articulos;
    private String rmdId;
    private RMDFragment fragment;
    private Context context;
    private FragmentActivity activity;

    public DetalleRMDArticuloAdapter(ArrayList<Articulo> articulos, String rmdId, RMDFragment fragment, Context context, FragmentActivity activity) {
        this.articulos = articulos;
        this.rmdId = rmdId;
        this.fragment = fragment;
        this.context = context;
        this.activity = activity;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(2131492927, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final Articulo articulo = this.articulos.get(position);
        holder.txtVwArticulo.setText((CharSequence)("Art\u00edculo: " + articulo.getArticulo()));
        holder.txtVwMarca.setText((CharSequence)("Marca: " + articulo.getMarca()));
        holder.txtVwColor.setText((CharSequence)("Color: " + articulo.getColor()));
        holder.btnDetalle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(DetalleRMDArticuloAdapter.this.context);
                builder.setTitle((CharSequence)"Detalle condiciones");
                builder.setMessage((CharSequence)articulo.getDetalleCondiciones());
                builder.setPositiveButton((CharSequence)"Cerrar", null);
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
        holder.btnFotos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NetworkChange.isConnectedToInternet(DetalleRMDArticuloAdapter.this.context)) {
                    RMDController rmdController = new RMDController(DetalleRMDArticuloAdapter.this.context, (Activity)DetalleRMDArticuloAdapter.this.activity);
                    rmdController.getRutasFotosFromServer(DetalleRMDArticuloAdapter.this.rmdId, articulo.getArticulo());
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(DetalleRMDArticuloAdapter.this.context);
                    builder.setTitle((CharSequence)"Sin conexi\u00f3n a internet");
                    builder.setMessage((CharSequence)"No es posible cargar las imagenes del art\u00edculo sin conexi\u00f3n a internet");
                    builder.setPositiveButton((CharSequence)"Aceptar", null);
                    AlertDialog dialog = builder.create();
                    dialog.show();
                }
            }
        });
    }

    public int getItemCount() {
        return this.articulos.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView txtVwArticulo;
        private TextView txtVwMarca;
        private TextView txtVwColor;
        private Button btnDetalle;
        private Button btnFotos;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.txtVwArticulo = (TextView)view.findViewById(2131297266);
            this.txtVwMarca = (TextView)view.findViewById(2131297304);
            this.txtVwColor = (TextView)view.findViewById(2131297275);
            this.btnDetalle = (Button)view.findViewById(2131296416);
            this.btnFotos = (Button)view.findViewById(2131296427);
        }
    }
}

