/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.ui.rmd.Ver;

import android.app.Activity;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.Html;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.DashboardActivity;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.ui.rmd.RMDFragment;
import com.example.sefinsa_app.ui.rmd.Ver.DetalleRMDArticuloAdapter;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;

public class RMDAdapter
extends RecyclerView.Adapter<ViewHolder> {
    ArrayList<RMD> rmd;
    private RMDFragment fragment;
    private Context context;
    private FragmentActivity activity;
    private RMDController rmdController;

    public RMDAdapter(ArrayList<RMD> rmd, RMDFragment fragment, Context context, FragmentActivity activity) {
        this.rmd = rmd;
        this.fragment = fragment;
        this.context = context;
        this.activity = activity;
        this.rmdController = new RMDController(context, (Activity)activity);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(2131493062, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final String folio = this.rmd.get(position).getId();
        String fecha = this.rmd.get(position).getFecha();
        String nombre = this.rmd.get(position).getNombre();
        String noCuenta = this.rmd.get(position).getNumeroCuenta();
        String poblacion = this.rmd.get(position).getPoblacion();
        holder.txtVwFolio.setText((CharSequence)("Folio: " + folio));
        holder.txtVwFecha.setText((CharSequence)fecha);
        holder.txtWvNombre.setText((CharSequence)("Nombre: " + nombre));
        holder.txtVwNoCuenta.setText((CharSequence)("No. Cuenta: " + noCuenta));
        holder.txtVwPoblacion.setText((CharSequence)("Poblaci\u00f3n: " + poblacion));
        holder.btnDetalles.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RMD rmd = RMDAdapter.this.rmdController.getRMD(folio);
                AlertDialog.Builder builder = new AlertDialog.Builder(RMDAdapter.this.context);
                View dialogLayout = LayoutInflater.from((Context)RMDAdapter.this.context).inflate(2131492943, null);
                builder.setView(dialogLayout);
                TextView txtVwFolio = (TextView)dialogLayout.findViewById(2131297354);
                TextView txtVwFecha = (TextView)dialogLayout.findViewById(2131297350);
                TextView txtVwNoCuenta = (TextView)dialogLayout.findViewById(2131297355);
                TextView txtVwNombre = (TextView)dialogLayout.findViewById(2131297356);
                TextView txtVwPoblacion = (TextView)dialogLayout.findViewById(2131297358);
                RecyclerView rvArticulosDetalleRMD = (RecyclerView)dialogLayout.findViewById(2131296975);
                TextView txtVwValorGarantia = (TextView)dialogLayout.findViewById(2131297361);
                TextView txtVwPagara = (TextView)dialogLayout.findViewById(2131297357);
                TextView txtVwRuta = (TextView)dialogLayout.findViewById(2131297360);
                TextView txtVwFechaPago = (TextView)dialogLayout.findViewById(2131297351);
                ImageView imgFirmaCliente = (ImageView)dialogLayout.findViewById(2131296720);
                ImageView imgFirmaAsesor = (ImageView)dialogLayout.findViewById(2131296719);
                TextView txtVwRecibeMercancia = (TextView)dialogLayout.findViewById(2131297359);
                String folio2 = rmd.getId();
                String fecha = rmd.getFecha();
                String nombre = rmd.getNombre();
                String noCuenta = rmd.getNumeroCuenta();
                String ruta = rmd.getRuta();
                String poblacion = rmd.getPoblacion();
                String valorGarantia = rmd.getValorGarantia();
                String pagara = rmd.getPagara();
                String recibeMercancia = rmd.getRecibeMercancia();
                Bitmap firmaCliente = RMDAdapter.this.base64ToBitmap(rmd.getFirmaCliente());
                Bitmap firmaAsesor = RMDAdapter.this.base64ToBitmap(rmd.getFirmaAsesor());
                String fechaPago = rmd.getFechaIns();
                imgFirmaCliente.setImageBitmap(firmaCliente);
                imgFirmaAsesor.setImageBitmap(firmaAsesor);
                builder.setTitle((CharSequence)"Detalles RMD");
                builder.setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                txtVwFolio.setText((CharSequence)Html.fromHtml((String)("<b>Folio:</b> " + folio2)));
                txtVwFecha.setText((CharSequence)fecha);
                txtVwNoCuenta.setText((CharSequence)Html.fromHtml((String)("<b>No. de Cuenta:</b> " + noCuenta)));
                txtVwNombre.setText((CharSequence)Html.fromHtml((String)("<b>Nombre:</b> " + nombre)));
                txtVwRuta.setText((CharSequence)Html.fromHtml((String)("<b>Ruta:</b> " + ruta)));
                txtVwPoblacion.setText((CharSequence)Html.fromHtml((String)("<b>Poblaci\u00f3n:</b> " + poblacion)));
                txtVwValorGarantia.setText((CharSequence)Html.fromHtml((String)("<b>Valor garant\u00eda:</b> $" + valorGarantia)));
                txtVwPagara.setText((CharSequence)Html.fromHtml((String)("<b>Pagar\u00e1:</b> $" + pagara)));
                txtVwFechaPago.setText((CharSequence)Html.fromHtml((String)("<b>Fecha: </b>" + fechaPago)));
                txtVwRecibeMercancia.setText((CharSequence)Html.fromHtml((String)("<b>Recibe mercanc\u00eda:</b> " + recibeMercancia)));
                ArrayList<Articulo> articulos = RMDAdapter.this.rmdController.getArticulos(folio2);
                DetalleRMDArticuloAdapter adapter = new DetalleRMDArticuloAdapter(articulos, rmd.getId(), RMDAdapter.this.fragment, RMDAdapter.this.context, RMDAdapter.this.activity);
                LinearLayoutManager layoutManager = new LinearLayoutManager(RMDAdapter.this.context);
                rvArticulosDetalleRMD.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
                rvArticulosDetalleRMD.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
                rvArticulosDetalleRMD.setAdapter((RecyclerView.Adapter)adapter);
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
        holder.btnArchivos.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                final AlertDialog.Builder builder = new AlertDialog.Builder(RMDAdapter.this.context);
                builder.setTitle((CharSequence)"Selecciona una opci\u00f3n");
                final BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                builder.setPositiveButton((CharSequence)"Imprimir Ticket", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        if (BluetoothUtils.mConnectedThread == null || !bluetoothAdapter.isEnabled()) {
                            BluetoothUtils.mConnectedThread = null;
                            final AlertDialog.Builder builder2 = new AlertDialog.Builder(RMDAdapter.this.context);
                            builder2.setTitle((CharSequence)"No hay impresora conectada");
                            builder2.setMessage((CharSequence)"\u00bfDesea contectarse a una impresora?");
                            builder2.setPositiveButton((CharSequence)"Conectarse", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    final ProgressDialog progressDialog = new ProgressDialog(RMDAdapter.this.context);
                                    if (!bluetoothAdapter.isEnabled()) {
                                        Toast.makeText((Context)RMDAdapter.this.context, (CharSequence)"Enciende el bluetooth para continuar", (int)0).show();
                                        AlertDialog d = builder2.create();
                                        progressDialog.dismiss();
                                        d.show();
                                    } else {
                                        DashboardActivity da = (DashboardActivity)RMDAdapter.this.activity;
                                        da.conectarImpresora(new DashboardActivity.ConexionCallback(){

                                            @Override
                                            public void onSuccess() {
                                                progressDialog.dismiss();
                                                AlertDialog dialog = builder.create();
                                                dialog.show();
                                            }
                                        });
                                    }
                                }
                            });
                            builder2.setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            });
                            builder2.setCancelable(false);
                            AlertDialog dialog2 = builder2.create();
                            dialog2.show();
                        } else {
                            try {
                                RMDAdapter.this.imprimirTicket(folio);
                                dialog.dismiss();
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            AlertDialog d = builder.create();
                            d.show();
                        }
                    }
                });
                builder.setNeutralButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.dismiss();
                    }
                });
                builder.setNegativeButton((CharSequence)"Compartir pdf", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.dismiss();
                        try {
                            RMDAdapter.this.compartirPDF(folio);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
    }

    public void imprimirTicket(String folio) throws ParseException, IOException {
        if (Objects.equals(API.url, API.urlCredigrup)) {
            BluetoothUtils.printPhoto(2131230871);
        } else {
            BluetoothUtils.printPhoto(2131231012);
        }
        RMD rmd = this.rmdController.getRMDParaImpresion(folio);
        if (Build.VERSION.SDK_INT >= 26) {
            BluetoothUtils.imprimirRMD(rmd);
        }
    }

    public void compartirPDF(String folio) throws IOException {
        RMD rmd = this.rmdController.getRMDParaImpresion(folio);
        String text = "----------------------------------------------------\n";
        text = text + "PRESTAMO GRUSEF S.A. de C.V.\n";
        text = text + "Folio: " + rmd.getId() + "\n";
        text = text + "Fecha: " + rmd.getFecha() + "\n";
        text = text + "No. Cuenta: " + rmd.getNumeroCuenta() + "\n";
        text = text + "Nombre: " + rmd.getNombre() + "\n";
        text = text + "Tel\u00e9fono: " + rmd.getTelefono() + "\n";
        text = text + "Ruta: " + rmd.getRuta() + "\n";
        text = text + "Poblaci\u00f3n: " + rmd.getPoblacion() + "\n\n";
        text = text + "Debido a que de inmediano no me\npuedo poner al corriente en los\npagos que me obligue a hacer en\nmi cuenta conforme al contrato\nfirmado que celebre con ustedes,\nhago entrega de las siguientes\ngarantias:\n\n";
        int i = 1;
        for (Articulo articulo : rmd.getArticulos()) {
            String nombre = RMDAdapter.configurar40Caracteres(articulo.getArticulo(), "Nombre");
            String marca = RMDAdapter.configurar40Caracteres(articulo.getMarca(), "Marca");
            String color2 = RMDAdapter.configurar40Caracteres(articulo.getColor(), "Color");
            String detalleCondiciones = RMDAdapter.configurar40Caracteres(articulo.getDetalleCondiciones(), "Detalles");
            text = text + "Articulo " + i + "\n";
            text = text + "Nombre: " + nombre + "\n";
            text = text + "Marca: " + marca + "\n";
            text = text + "Color: " + color2 + "\n";
            text = text + "Condiciones: " + detalleCondiciones + "\n\n";
            ++i;
        }
        text = text + "Valor garant\u00eda: " + rmd.getValorGarantia() + "\n";
        text = text + "Pagar\u00e1: $" + rmd.getPagara() + "\n";
        text = text + "Fecha: $" + rmd.getFechaIns() + "\n";
        text = text + "Recibe mercanc\u00eda: " + rmd.getRecibeMercancia() + "\n\n";
        text = text + "Y LIQUIDARA EL ADEUDO EN LAS\nPROXIMAS 24 HORAS. DE INCUMPLIR\nCON DICHO ACUERDO ACEPTO QUE MIS\nGARANTIAS SEAN VENDIDAS PARA\nCUBRIR EL IMPORTE MENCIONADO EN\nEL VALOR DE GARANTIA.";
        File pdf = this.fragment.generarPDF(text, rmd.getFirmaCliente(), rmd.getFirmaAsesor(), rmd.getId());
        this.fragment.compartirPDF(pdf);
    }

    private static String configurar40Caracteres(String texto, String x) {
        String[] palabras = texto.split(" ");
        StringBuilder resultado = new StringBuilder();
        int countLinea = 0;
        if (Objects.equals(x, "Nombre")) {
            countLinea = 8;
        }
        if (Objects.equals(x, "Marca")) {
            countLinea = 7;
        }
        if (Objects.equals(x, "Color")) {
            countLinea = 7;
        }
        if (Objects.equals(x, "Detalles")) {
            countLinea = 10;
        }
        for (String palabra : palabras) {
            if ((countLinea += palabra.length() + 1) > 40) {
                resultado.append("\n");
                countLinea = 0;
            }
            resultado.append(palabra).append(" ");
        }
        return resultado.toString().trim();
    }

    public int getItemCount() {
        return this.rmd.size();
    }

    public Bitmap base64ToBitmap(String base64) {
        byte[] decodedString = Base64.decode((String)base64, (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
    }

    public String bitmapToBase64(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView txtVwFolio;
        private TextView txtVwFecha;
        private TextView txtWvNombre;
        private TextView txtVwNoCuenta;
        private TextView txtVwPoblacion;
        private Button btnDetalles;
        private Button btnArchivos;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.txtVwFolio = (TextView)view.findViewById(2131297354);
            this.txtVwFecha = (TextView)view.findViewById(2131297350);
            this.txtWvNombre = (TextView)view.findViewById(2131297362);
            this.txtVwNoCuenta = (TextView)view.findViewById(2131297355);
            this.txtVwPoblacion = (TextView)view.findViewById(2131297358);
            this.btnDetalles = (Button)view.findViewById(2131296416);
            this.btnArchivos = (Button)view.findViewById(2131296397);
        }
    }
}

