/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class AvalesAdapter
extends RecyclerView.Adapter<AvalesViewHolder> {
    Context context;
    ArrayList<Aval> avales;
    private SharedPreferences sesion;
    private String aval_id;
    private VolleyS vs;
    private RequestQueue requestQueue;

    public AvalesAdapter(Context context, ArrayList<Aval> avales) {
        this.context = context;
        this.avales = avales;
    }

    public void setListaFiltrada(ArrayList<Aval> filteredListEstaciones) {
        this.avales = filteredListEstaciones != null ? filteredListEstaciones : new ArrayList();
        this.notifyDataSetChanged();
    }

    @NonNull
    public AvalesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.sesion = this.context.getSharedPreferences("sesion", 0);
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(2131492900, parent, false);
        return new AvalesViewHolder(v);
    }

    public void onBindViewHolder(@NonNull AvalesViewHolder holder, int position) {
        try {
            if (this.avales != null && position >= 0 && position < this.avales.size()) {
                Aval aval = this.avales.get(position);
                if (aval != null) {
                    holder.imprimir(position);
                } else {
                    holder.imprimirDefault();
                }
            } else {
                holder.imprimirDefault();
            }
        }
        catch (Exception e) {
            Log.e((String)"AvalesAdapter", (String)"Error en onBindViewHolder", (Throwable)e);
        }
    }

    public int getItemCount() {
        if (this.avales == null) {
            Log.e((String)"AvalesAdapter", (String)"Lista de avales es nula");
            return 0;
        }
        return this.avales.size();
    }

    public void clear() {
        this.avales.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<Aval> list) {
        this.avales = list;
        this.notifyDataSetChanged();
    }

    private void refreshData() {
        this.requestQueue.getCache().clear();
    }

    public void updateData(ArrayList<Aval> nuevosAvales) {
        this.avales.addAll(nuevosAvales);
        this.notifyDataSetChanged();
    }

    public class AvalesViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvNombreAval;
        TextView tvDireccionAval;
        TextView tvTelefonoAval;
        TextView tvGarantiasAval;
        Button btnEditarAval;
        Button btnVerInfoAval;
        Button btnVerImagenes;
        Button btnGenerarPrestamoAval;
        String informacion;
        ConstraintLayout tarjetaAval;
        private RequestQueue requestQueue;

        public AvalesViewHolder(View itemView) {
            super(itemView);
            this.informacion = "";
            this.tarjetaAval = (ConstraintLayout)itemView.findViewById(2131296272);
            this.tvNombreAval = (TextView)itemView.findViewById(2131296889);
            this.tvTelefonoAval = (TextView)itemView.findViewById(2131297130);
            this.btnEditarAval = (Button)itemView.findViewById(2131296419);
            this.btnVerInfoAval = (Button)itemView.findViewById(2131296465);
            this.btnVerImagenes = (Button)itemView.findViewById(2131296461);
            this.btnGenerarPrestamoAval = (Button)itemView.findViewById(2131296430);
        }

        public void imprimirDefault() {
            if (this.tvNombreAval != null) {
                this.tvNombreAval.setText((CharSequence)"Nombre Predeterminado");
            }
            if (this.tvTelefonoAval != null) {
                this.tvTelefonoAval.setText((CharSequence)"0000000000");
            }
            if (this.btnEditarAval != null) {
                this.btnEditarAval.setVisibility(0);
            }
            if (this.btnVerInfoAval != null) {
                this.btnVerInfoAval.setVisibility(0);
            }
            if (this.btnVerImagenes != null) {
                this.btnVerImagenes.setVisibility(0);
            }
            if (this.btnGenerarPrestamoAval != null) {
                this.btnGenerarPrestamoAval.setVisibility(0);
            }
        }

        private void showAlert(String message) {
            AlertDialog.Builder builder = new AlertDialog.Builder(AvalesAdapter.this.context);
            builder.setMessage((CharSequence)message);
            TextView title = new TextView(AvalesAdapter.this.context);
            title.setText((CharSequence)"Alerta");
            title.setGravity(17);
            title.setTextSize(2, 20.0f);
            title.setTextColor(ContextCompat.getColor((Context)AvalesAdapter.this.context, (int)17170444));
            title.setPadding(0, 20, 0, 20);
            builder.setCustomTitle((View)title);
            builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }

        public void imprimir(int position) {
            AvalesAdapter.this.vs = VolleyS.getInstance(AvalesAdapter.this.context);
            this.requestQueue = AvalesAdapter.this.vs.getRequestQueue();
            String nombre_aval = AvalesAdapter.this.avales.get(position).getNombre_completo();
            this.tvNombreAval.setText((CharSequence)("\nAVAL: " + nombre_aval));
            this.tvTelefonoAval.setText((CharSequence)AvalesAdapter.this.avales.get(position).getTelefono());
            this.informacion = "<b>Aval:</b> " + AvalesAdapter.this.avales.get(position).getNombre_completo() + " <br><br> <b>Direcci\u00f3n:</b> " + AvalesAdapter.this.avales.get(position).getDireccion() + " <br><br> <b>Tel\u00e9fono:</b> " + AvalesAdapter.this.avales.get(position).getTelefono() + " <br><br> <b>Otras referenc\u00edas:</b> " + AvalesAdapter.this.avales.get(position).getOtras_referencias() + " <br><br> <b>Garant\u00edas:</b> " + AvalesAdapter.this.avales.get(position).getGarantias() + " <br><br> ";
            if (AvalesAdapter.this.sesion.getString("nombre_perfil", "").equals("Administrador") || AvalesAdapter.this.sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {
                this.btnGenerarPrestamoAval.setVisibility(8);
                this.btnEditarAval.setVisibility(0);
                this.btnVerImagenes.setVisibility(0);
                int desiredWidth = 74;
                float scale = AvalesAdapter.this.context.getResources().getDisplayMetrics().density;
                int desiredWidthPx = (int)((float)desiredWidth * scale + 0.5f);
                ViewGroup.LayoutParams paramsVerInfo = this.btnVerInfoAval.getLayoutParams();
                paramsVerInfo.width = desiredWidthPx;
                this.btnVerInfoAval.setLayoutParams(paramsVerInfo);
                ViewGroup.LayoutParams paramsVerImg = this.btnVerImagenes.getLayoutParams();
                paramsVerImg.width = desiredWidthPx;
                this.btnVerImagenes.setLayoutParams(paramsVerImg);
                ViewGroup.LayoutParams paramsGenerarPrestamo = this.btnGenerarPrestamoAval.getLayoutParams();
                paramsGenerarPrestamo.width = desiredWidthPx;
                this.btnGenerarPrestamoAval.setLayoutParams(paramsGenerarPrestamo);
                this.btnGenerarPrestamoAval.setOnClickListener(view -> {
                    Bundle args = new Bundle();
                    String personJsonString = Utils.getGsonParser().toJson((Object)AvalesAdapter.this.avales.get(position));
                    args.putString("aval", personJsonString);
                    Navigation.findNavController((Activity)((Activity)AvalesAdapter.this.context), (int)2131296862).navigate(2131296867, args);
                });
                ViewGroup.LayoutParams paramsEditarAval = this.btnEditarAval.getLayoutParams();
                paramsEditarAval.width = desiredWidthPx;
                this.btnEditarAval.setLayoutParams(paramsEditarAval);
            } else if (AvalesAdapter.this.sesion.getString("nombre_perfil", "").equals("VOCERO")) {
                this.btnVerImagenes.setVisibility(0);
                int desiredWidth = 74;
                float scale = AvalesAdapter.this.context.getResources().getDisplayMetrics().density;
                int desiredWidthPx = (int)((float)desiredWidth * scale + 0.5f);
                ViewGroup.LayoutParams paramsVerImagenes = this.btnVerImagenes.getLayoutParams();
                paramsVerImagenes.width = desiredWidthPx;
                this.btnVerImagenes.setLayoutParams(paramsVerImagenes);
            } else if (AvalesAdapter.this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || AvalesAdapter.this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                this.btnEditarAval.setVisibility(8);
                this.btnVerImagenes.setVisibility(0);
            } else {
                this.btnEditarAval.setVisibility(0);
            }
            this.btnEditarAval.setOnClickListener(view -> {
                Bundle args = new Bundle();
                String personJsonString = Utils.getGsonParser().toJson((Object)AvalesAdapter.this.avales.get(position));
                args.putString("aval", personJsonString);
                Navigation.findNavController((Activity)((Activity)AvalesAdapter.this.context), (int)2131296862).navigate(2131296846, args);
            });
            this.btnVerImagenes.setOnClickListener(view -> {
                CharSequence[] opciones = new String[]{"Tomar fotos", "Ver expediente"};
                new MaterialAlertDialogBuilder(AvalesAdapter.this.context).setTitle((CharSequence)"Opciones").setSingleChoiceItems(opciones, -1, (dialogInterface, i) -> {
                    switch (i) {
                        case 0: {
                            dialogInterface.dismiss();
                            AvalesAdapter.this.aval_id = AvalesAdapter.this.avales.get((int)position).id;
                            Log.d((String)"LISTA0", (String)("DATO DE aval_id para FOTOS: " + AvalesAdapter.this.aval_id));
                            Bundle args2 = new Bundle();
                            String personJsonString2 = Utils.getGsonParser().toJson((Object)AvalesAdapter.this.avales.get(position));
                            String personJsonString4 = nombre_aval;
                            args2.putString("aval", personJsonString2);
                            args2.putString("avalNombre", personJsonString4);
                            Navigation.findNavController((Activity)((Activity)AvalesAdapter.this.context), (int)2131296862).navigate(2131296847, args2);
                            break;
                        }
                        case 1: {
                            dialogInterface.dismiss();
                            Bundle args = new Bundle();
                            String personJsonString = Utils.getGsonParser().toJson((Object)AvalesAdapter.this.avales.get(position));
                            String personJsonString3 = AvalesAdapter.this.avales.get((int)position).id;
                            args.putString("aval", personJsonString);
                            args.putString("avalId", personJsonString3);
                            Log.d((String)"DATA_ENVIADA", (String)("Json de avale: " + personJsonString));
                            Log.d((String)"DATA_ENVIADA", (String)("ID de avaleId: " + personJsonString3));
                            Navigation.findNavController((Activity)((Activity)AvalesAdapter.this.context), (int)2131296862).navigate(2131296845, args);
                        }
                    }
                }).show();
            });
            this.btnVerInfoAval.setOnClickListener(view -> {
                View dialogView = LayoutInflater.from((Context)AvalesAdapter.this.context).inflate(2131492935, null, false);
                TextView tvNombreAval = (TextView)dialogView.findViewById(2131297312);
                TextView tvDireccionAval = (TextView)dialogView.findViewById(2131297282);
                TextView tvTelefonoAval = (TextView)dialogView.findViewById(2131297333);
                TextView tvGarantiasAval = (TextView)dialogView.findViewById(2131297294);
                TextView tvUpdGarantiasAval = (TextView)dialogView.findViewById(2131297344);
                TextView tvUpdComprobantesAval = (TextView)dialogView.findViewById(2131297341);
                final TextView tvMapaAval = (TextView)dialogView.findViewById(2131297302);
                tvNombreAval.setText((CharSequence)Html.fromHtml((String)("<b>Aval:</b> " + AvalesAdapter.this.avales.get(position).getNombre_completo())));
                tvMapaAval.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n</b> "));
                tvDireccionAval.setText((CharSequence)Html.fromHtml((String)("<b>Direcci\u00f3n:</b> " + AvalesAdapter.this.avales.get(position).getDireccion())));
                tvTelefonoAval.setText((CharSequence)Html.fromHtml((String)("<b>Tel\u00e9fono:</b> " + AvalesAdapter.this.avales.get(position).getTelefono())));
                tvGarantiasAval.setText((CharSequence)Html.fromHtml((String)("<b>Garant\u00edas:</b> " + AvalesAdapter.this.avales.get(position).getGarantias())));
                Log.d((String)"MyWorker", (String)("INFORMACION EN CLIENTE SELECCIONADO........" + AvalesAdapter.this.avales.get(position).getUpdate_comprobantes_Enaval() + " / " + AvalesAdapter.this.avales.get(position).getUpdate_garantias_Enaval()));
                String updateGarantiasAval = AvalesAdapter.this.avales.get(position).getUpdate_garantias_Enaval();
                String updateComprobantesAval = AvalesAdapter.this.avales.get(position).getUpdate_comprobantes_Enaval();
                updateComprobantesAval = updateComprobantesAval != null ? updateComprobantesAval : "...";
                updateGarantiasAval = updateGarantiasAval != null ? updateGarantiasAval : "...";
                JSONObject data2 = new JSONObject();
                try {
                    data2.put("func", (Object)"coordenadasAval");
                    data2.put("aval_id", (Object)AvalesAdapter.this.avales.get(position).getId());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Log.d((String)"11", (String)"loadAllData: ");
                JsonObjectRequest req2 = new JsonObjectRequest(1, API.urlClientes, data2, (Response.Listener)new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        try {
                            if (!response.get("data").toString().equals("false")) {
                                JSONObject jsonObject = (JSONObject)response.get("data");
                                final String latitud = jsonObject.getString("latitud");
                                final String longitud = jsonObject.getString("longitud");
                                if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                    tvMapaAval.setText((CharSequence)"");
                                } else {
                                    tvMapaAval.setOnClickListener(new View.OnClickListener(){

                                        public void onClick(View v) {
                                            Log.d((String)"qpwopeoqpww", (String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                            Intent intent = new Intent("android.intent.action.VIEW");
                                            intent.setData(Uri.parse((String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud)));
                                            intent.setPackage("com.google.android.apps.maps");
                                            AvalesAdapter.this.context.startActivity(intent);
                                        }
                                    });
                                }
                            }
                        }
                        catch (JSONException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                    }
                });
                this.requestQueue.add((Request)req2);
                updateGarantiasAval = this.formatFecha(updateGarantiasAval);
                updateComprobantesAval = this.formatFecha(updateComprobantesAval);
                tvUpdGarantiasAval.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Garant\u00edas:</b><br>" + updateGarantiasAval)));
                tvUpdComprobantesAval.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Comprobantes:</b><br>" + updateComprobantesAval)));
                tvTelefonoAval.setOnClickListener(view12 -> {
                    Intent intent = new Intent("android.intent.action.DIAL");
                    intent.setData(Uri.parse((String)("tel:" + AvalesAdapter.this.avales.get(position).getTelefono())));
                    AvalesAdapter.this.context.startActivity(intent);
                });
                new MaterialAlertDialogBuilder(AvalesAdapter.this.context).setTitle((CharSequence)"").setView(dialogView).setPositiveButton((CharSequence)"Cerrar", (dialogInterface, i) -> {}).show();
            });
        }

        private String formatFecha(String fecha) {
            if (fecha == null) {
                return "...";
            }
            SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat desiredFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            try {
                Date date = originalFormat.parse(fecha);
                return desiredFormat.format(date);
            }
            catch (ParseException | java.text.ParseException e) {
                e.printStackTrace();
                return "...";
            }
        }
    }
}

