/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.utilities.PrintPic;
import com.example.sefinsa_app.utilities.PrinterCommands;
import com.example.sefinsa_app.utilities.Utils;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class BluetoothPrint
extends AppCompatActivity {
    BluetoothAdapter mBluetoothAdapter;
    BluetoothSocket mmSocket;
    BluetoothDevice mmDevice;
    OutputStream mmOutputStream;
    InputStream mmInputStream;
    Thread workerThread;
    byte[] readBuffer;
    int readBufferPosition;
    volatile boolean stopWorker;
    byte FONT_TYPE;
    public static String printer_id;
    private final Context ctx;
    private final Resources resources;

    public BluetoothPrint(Context ctx, Resources resources) {
        this.ctx = ctx;
        this.resources = resources;
    }

    public void findBT() {
        block6: {
            System.out.println("Printer ID : " + printer_id);
            try {
                Set pairedDevices;
                this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (this.mBluetoothAdapter == null) {
                    Toast.makeText((Context)this.ctx, (CharSequence)"Error con bluetooth", (int)0).show();
                }
                if (!this.mBluetoothAdapter.isEnabled()) {
                    Intent enableBluetooth = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                    Toast.makeText((Context)this.ctx, (CharSequence)"Debes activar el blueetooth para la impresi\u00f3n de tickets", (int)1).show();
                    if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.BLUETOOTH_CONNECT") != 0) {
                        return;
                    }
                    this.startActivityForResult(enableBluetooth, 0);
                }
                if ((pairedDevices = this.mBluetoothAdapter.getBondedDevices()).size() <= 0) break block6;
                for (BluetoothDevice device : pairedDevices) {
                    Log.d((String)"DEVICE", (String)device.getName());
                    if (!device.getName().equals(printer_id)) continue;
                    this.mmDevice = device;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void openBT() throws IOException {
        try {
            if (ActivityCompat.checkSelfPermission((Context)this.ctx, (String)"android.permission.BLUETOOTH_CONNECT") != 0) {
                return;
            }
            UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
            this.mmSocket = this.mmDevice.createRfcommSocketToServiceRecord(uuid);
            this.mmSocket.connect();
            this.mmOutputStream = this.mmSocket.getOutputStream();
            this.mmInputStream = this.mmSocket.getInputStream();
            this.beginListenForData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printQrCode(Bitmap qRBit) {
        try {
            PrintPic printPic1 = PrintPic.getInstance();
            printPic1.init(qRBit);
            byte[] bitmapdata2 = printPic1.printDraw();
            this.mmOutputStream.write(bitmapdata2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.mmSocket.isConnected();
    }

    public void printText(Pago pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "--------------------------\n";
            text = text + "Folio: " + folio + "\n";
            text = text + "Impresi\u00f3n: " + fechaConvert + "\n";
            text = text + "Ruta: " + pago.getNombre_ruta() + "\n";
            text = text + "Poblacion: " + pago.getNombre_poblacion() + "\n";
            text = text + "Recibi de: " + pago.getNombre_completo() + "\n";
            text = text + "Cantidad: $" + recibido + "\n";
            text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
            text = text + "Debe: $" + (Utils.convertirDouble(pago.getBalance()) - Utils.convertirDouble(recibido)) + "\n";
            if (pago_multa != "0.0") {
                text = text + "Multa: $" + pago_multa + "\n";
            }
            text = text + "Concepto: " + concepto + "\n";
            text = text + "--------------------------\n";
            this.mmOutputStream.write(text.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printText(String titulo_ticket, String ruta_ticket, String Poblacion_ticket, String Nombre_ticket, String Atraso_ticket, String pago_ticket, String aviso) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "--------------------------\n";
            text = text + titulo_ticket + "\n";
            text = text + fechaConvert + "\n";
            text = text + ruta_ticket + "\n";
            text = text + Poblacion_ticket + "\n";
            text = text + Nombre_ticket + "\n";
            text = text + Atraso_ticket + "\n";
            text = text + pago_ticket + "\n";
            text = text + aviso + "\n";
            text = text + "--------------------------\n";
            this.mmOutputStream.write(text.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printText(Prestamo pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "--------------------------\n";
            text = text + "Folio: " + folio + "\n";
            text = text + fechaConvert + "\n";
            text = text + "Ruta: " + pago.getNombre_ruta() + "\n";
            text = text + "Poblacion: " + pago.getNombre_poblacion() + "\n";
            text = text + "Recibi de: " + pago.getNombre_completo() + "\n";
            text = text + "Cantidad: $" + recibido + "\n";
            text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
            if (pago_multa != "0.0") {
                text = text + "Multa: $" + pago_multa + "\n";
            }
            text = text + "Concepto: " + concepto + "\n";
            text = text + "--------------------------\n";
            this.mmOutputStream.write(text.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=24)
    public void printReporteGeneral(ArrayList<PagosHechos> pagosHechos, String fecha) {
        try {
            String text = "\nREPORTE GENERAL " + fecha + "\n\n";
            double total = 0.0;
            for (PagosHechos pagoHecho : pagosHechos) {
                total += Utils.convertirDouble(pagoHecho.getCobro());
            }
            text = text + "TOTAL: $" + total + "\n\n";
            Map<String, List<PagosHechos>> pagosHechosGroup = pagosHechos.stream().collect(Collectors.groupingBy(w -> w.getPoblacion()));
            for (Map.Entry<String, List<PagosHechos>> entry : pagosHechosGroup.entrySet()) {
                String key = entry.getKey();
                List<PagosHechos> value = entry.getValue();
                text = text + key + "\n";
                for (int i = 0; i < value.size(); ++i) {
                    Gson gson = new Gson();
                    PagosHechos pagoHecho = (PagosHechos)gson.fromJson(value.get(i).toString(), PagosHechos.class);
                    text = text + pagoHecho.getCliente() + ": $" + pagoHecho.getCobro() + " ";
                    text = text + pagoHecho.getFolio() + " " + pagoHecho.getConcepto() + "\n\n";
                }
            }
            Log.d((String)"REPORTE", (String)text);
            this.mmOutputStream.write(text.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printStruk(String nama_produk, String pengiriman, String Date2) {
        System.out.println("Nama Produk: " + nama_produk);
        System.out.println("Barang: " + pengiriman);
        System.out.println("Date: " + Date2);
        try {
            String text = "---------------------\n";
            text = text + "Produk : " + nama_produk + "\n";
            text = text + "Barang : " + pengiriman + "\n";
            text = text + "Tanggal: " + Date2 + "\n";
            this.mmOutputStream.write(text.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void beginListenForData() {
        try {
            final Handler handler = new Handler();
            int delimiter = 10;
            this.stopWorker = false;
            this.readBufferPosition = 0;
            this.readBuffer = new byte[1024];
            this.workerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!Thread.currentThread().isInterrupted() && !BluetoothPrint.this.stopWorker) {
                        try {
                            int bytesAvailable = BluetoothPrint.this.mmInputStream.available();
                            if (bytesAvailable <= 0) continue;
                            byte[] packetBytes = new byte[bytesAvailable];
                            BluetoothPrint.this.mmInputStream.read(packetBytes);
                            for (int i = 0; i < bytesAvailable; ++i) {
                                byte b = packetBytes[i];
                                if (b == 10) {
                                    byte[] encodedBytes = new byte[BluetoothPrint.this.readBufferPosition];
                                    System.arraycopy(BluetoothPrint.this.readBuffer, 0, encodedBytes, 0, encodedBytes.length);
                                    String data = new String(encodedBytes, StandardCharsets.US_ASCII);
                                    BluetoothPrint.this.readBufferPosition = 0;
                                    handler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                        }
                                    });
                                    continue;
                                }
                                BluetoothPrint.this.readBuffer[BluetoothPrint.this.readBufferPosition++] = b;
                            }
                        }
                        catch (IOException ex) {
                            BluetoothPrint.this.stopWorker = true;
                        }
                    }
                }
            });
            this.workerThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeBT() throws IOException {
        try {
            this.stopWorker = true;
            this.mmOutputStream.close();
            this.mmInputStream.close();
            this.mmSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printPhoto(int img) {
        try {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)this.resources, (int)img);
            if (bmp != null) {
                byte[] command = Utils.decodeBitmap(bmp);
                this.mmOutputStream.write(PrinterCommands.ESC_ALIGN_CENTER);
                this.mmOutputStream.write(command);
            } else {
                Log.e((String)"Print Photo error", (String)"the file isn't exists");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"EXE", (String)e.toString());
            Log.e((String)"PrintTools", (String)"the file isn't exists");
        }
    }

    public static Bitmap decodeFile(File f, int WIDTH, int HIGHT) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o);
            int REQUIRED_WIDTH = WIDTH;
            int REQUIRED_HIGHT = HIGHT;
            int scale = 1;
            while (o.outWidth / scale / 2 >= REQUIRED_WIDTH && o.outHeight / scale / 2 >= REQUIRED_HIGHT) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }
}

